/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.LazyModal;
import com.openbravo.components.ModalConfirmationController;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.ReductionInfo;
import fr.protactile.procaisse.services.ReductionService;
import java.awt.Dimension;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.StageStyle;

public class ReductionsController {
    @FXML
    GridPane pane_left;
    @FXML
    GridPane pane_preview_reduction;
    @FXML
    GridPane list_reductions;
    @FXML
    GridPane pane_next_reduction;
    @FXML
    Button btn_reduction_previous;
    @FXML
    Button btn_reduction_next;
    @FXML
    TextField textValueReduction;
    @FXML
    TextField textNameReduction;
    @FXML
    Button type_pourcentage;
    @FXML
    Button type_somme;
    @FXML
    Button btn_init;
    @FXML
    Button btn_delete;
    private String type_discount;
    private int page_reduction;
    private GridPane[] pane_reductions;
    private int number_page_reduction;
    private int number_line;
    private int number_column;
    private AppView app;
    private List<ReductionInfo> reductions;
    private HashMap<Integer, Button> listPaneReductions;
    private ReductionService mReductionService;
    private ReductionInfo mReductionInfo;
    int row = -1;
    private boolean new_discount;
    private LazyModal mLazyModalConfirm = null;
    private EventHiddenModal mActionEventConfirm = null;
    private ModalConfirmationController mModalConfirmationController = null;
    private Scene scene;
    private EventHandler mEventHandlerReductionAction = new EventHandler<ActionEvent>(){
        private final String styleFocused = "-fx-background-color: #6597d1;";

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"reduction") != null) {
                try {
                    ReductionsController.this.mReductionInfo = (ReductionInfo)mButtonSource.getProperties().get((Object)"reduction");
                    if (ReductionsController.this.mReductionInfo != null) {
                        ReductionsController.this.loadInfoReduction();
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    };

    public void init(AppView app, Scene scene) throws BasicException, URISyntaxException {
        this.app = app;
        this.scene = scene;
        this.mReductionService = ReductionService.getInstance();
        this.reductions = new ArrayList<ReductionInfo>();
        this.listPaneReductions = new HashMap();
        this.number_line = 4;
        this.number_column = 4;
        Image imageNext = new Image(this.getClass().getResource("/com/openbravo/images/btn_next.png").toURI().toString(), 40.0, 30.0, false, false);
        Image imagebPrevious = new Image(this.getClass().getResource("/com/openbravo/images/btn_previous.png").toURI().toString(), 40.0, 30.0, false, false);
        Image imageAdd = new Image(this.getClass().getResource("/com/openbravo/images/add.png").toURI().toString(), 40.0, 30.0, false, false);
        Image imageDelete = new Image(this.getClass().getResource("/com/openbravo/images/sale_delete.png").toURI().toString(), 40.0, 30.0, false, false);
        this.btn_reduction_previous.setGraphic((Node)new ImageView(imagebPrevious));
        this.btn_reduction_next.setGraphic((Node)new ImageView(imageNext));
        this.btn_init.setGraphic((Node)new ImageView(imageAdd));
        this.btn_delete.setGraphic((Node)new ImageView(imageDelete));
        this.textValueReduction.getProperties().put((Object)"vkType", (Object)1);
        this.loadReductions();
        this.initializer();
    }

    private double heightPane() {
        return (AppVarUtils.getScreenDimension().getHeight() - 55.0) * 0.72 / (double)this.number_line;
    }

    private double widthPane() {
        return AppVarUtils.getScreenDimension().getWidth() * 0.66 / (double)this.number_column;
    }

    private void loadReductions() {
        try {
            this.listPaneReductions.clear();
            this.reductions = this.mReductionService.getReductions();
            this.reductions.forEach(reduction -> this.addPaneReduction((ReductionInfo)reduction));
            this.showReductions(this.listPaneReductions);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void showReductions(HashMap<Integer, Button> items) {
        this.number_page_reduction = (int)Math.ceil((double)items.size() / (double)(this.number_line * this.number_column));
        this.pane_reductions = new GridPane[this.number_page_reduction];
        for (int i = 0; i < this.number_page_reduction; ++i) {
            this.pane_reductions[i] = new GridPane();
            this.pane_reductions[i].setVgap(5.0);
            this.pane_reductions[i].setHgap(5.0);
            this.pane_reductions[i].setAlignment(Pos.TOP_CENTER);
            this.pane_reductions[i].getStyleClass().add((Object)"bg-white");
        }
        int index_reduction = 0;
        int column_reduction = 0;
        int row_reduction = 0;
        for (Button paneItem : items.values()) {
            this.pane_reductions[index_reduction].add((Node)paneItem, column_reduction, row_reduction);
            if (column_reduction < this.number_column - 1) {
                ++column_reduction;
                continue;
            }
            if (row_reduction < this.number_line - 1) {
                ++row_reduction;
                column_reduction = 0;
                continue;
            }
            ++index_reduction;
            row_reduction = 0;
            column_reduction = 0;
        }
        this.pane_left.getChildren().clear();
        this.list_reductions.getChildren().clear();
        if (this.number_page_reduction > 0) {
            this.page_reduction = 0;
            this.list_reductions.add((Node)this.pane_reductions[this.page_reduction], 0, 0);
            if (this.number_page_reduction <= 1) {
                this.pane_left.add((Node)this.list_reductions, 0, 0);
            } else {
                this.pane_preview_reduction.getChildren().clear();
                this.pane_next_reduction.getChildren().clear();
                this.pane_next_reduction.add((Node)this.btn_reduction_next, 0, 0);
                this.pane_preview_reduction.getChildren().clear();
                this.pane_left.add((Node)this.pane_preview_reduction, 0, 0);
                this.pane_left.add((Node)this.list_reductions, 0, 1);
                this.pane_left.add((Node)this.pane_next_reduction, 0, 2);
            }
        }
    }

    public void lastPaneReduction() {
        if (this.page_reduction > 0) {
            --this.page_reduction;
            this.list_reductions.getChildren().clear();
            this.list_reductions.add((Node)this.pane_reductions[this.page_reduction], 0, 0);
            this.pane_next_reduction.getChildren().clear();
            this.pane_next_reduction.add((Node)this.btn_reduction_next, 0, 0);
            if (this.page_reduction == 0) {
                this.pane_preview_reduction.getChildren().clear();
            } else {
                this.pane_preview_reduction.getChildren().clear();
                this.pane_preview_reduction.add((Node)this.btn_reduction_previous, 0, 0);
            }
        }
    }

    public void nextPageReduction() {
        if (this.page_reduction < this.number_page_reduction - 1) {
            ++this.page_reduction;
            this.list_reductions.getChildren().clear();
            this.list_reductions.add((Node)this.pane_reductions[this.page_reduction], 0, 0);
            this.pane_preview_reduction.getChildren().clear();
            this.pane_preview_reduction.add((Node)this.btn_reduction_previous, 0, 0);
            if (this.page_reduction == this.number_page_reduction - 1) {
                this.pane_next_reduction.getChildren().clear();
            } else {
                this.pane_next_reduction.getChildren().clear();
                this.pane_next_reduction.add((Node)this.btn_reduction_next, 0, 0);
            }
        }
    }

    private void addPaneReduction(ReductionInfo reduction) {
        Button paneReduction = new Button();
        paneReduction.setAlignment(Pos.CENTER);
        paneReduction.getStyleClass().add((Object)"bg-70c0c1");
        paneReduction.getStyleClass().add((Object)"text-size-18");
        paneReduction.setPrefWidth(this.widthPane());
        paneReduction.setPrefHeight(this.heightPane());
        paneReduction.setText(reduction.printName());
        paneReduction.getProperties().put((Object)"reduction", (Object)reduction);
        paneReduction.setOnAction(this.mEventHandlerReductionAction);
        this.listPaneReductions.put(reduction.getId(), paneReduction);
    }

    public void initializer() {
        this.new_discount = true;
        this.textNameReduction.setText("");
        this.textValueReduction.setText("");
        this.mReductionInfo = null;
        this.type_discount = null;
        this.deselectButtonType(this.type_pourcentage);
        this.deselectButtonType(this.type_somme);
    }

    public void validDisocunt() {
        if (!this.textValueReduction.getText().isEmpty() && !this.textValueReduction.getText().isEmpty() && this.type_discount != null) {
            if (this.new_discount) {
                this.addDiscount();
            } else {
                this.updateDiscount();
                Button paneReduction = this.listPaneReductions.get(this.mReductionInfo.getId());
                if (paneReduction != null) {
                    paneReduction.setText(this.mReductionInfo.printName());
                }
            }
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "R\u00e9duction valid\u00e9e.", 4000, NPosition.CENTER);
            this.initializer();
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de remplir tous les champs.", 4000, NPosition.CENTER);
        }
    }

    private void addDiscount() {
        this.mReductionInfo = new ReductionInfo();
        this.mReductionInfo.setName(this.textNameReduction.getText());
        double discount = Double.parseDouble(this.textValueReduction.getText().isEmpty() ? "0.0" : this.textValueReduction.getText());
        this.mReductionInfo.setReduction(discount);
        this.mReductionInfo.setType(this.type_discount);
        this.mReductionService.save(this.mReductionInfo);
        this.reductions.add(this.mReductionInfo);
        this.addPaneReduction(this.mReductionInfo);
        this.showReductions(this.listPaneReductions);
    }

    private void updateDiscount() {
        this.mReductionInfo.setName(this.textNameReduction.getText());
        double discount = Double.parseDouble(this.textValueReduction.getText().isEmpty() ? "0.0" : this.textValueReduction.getText());
        this.mReductionInfo.setReduction(discount);
        this.mReductionInfo.setType(this.type_discount);
        this.mReductionService.update(this.mReductionInfo);
    }

    public void deleteDiscount() {
        this.modalConfirm();
    }

    private void loadInfoReduction() {
        this.new_discount = false;
        this.textValueReduction.setText(String.valueOf(this.mReductionInfo.getReduction()));
        this.textNameReduction.setText(this.mReductionInfo.getName());
        this.type_discount = this.mReductionInfo.getType();
        if (this.type_discount.equals("pourcentage")) {
            this.selectButtonType(this.type_pourcentage);
            this.deselectButtonType(this.type_somme);
        } else {
            this.deselectButtonType(this.type_pourcentage);
            this.selectButtonType(this.type_somme);
        }
    }

    private void selectButtonType(Button button) {
        if (button.getStyleClass().contains((Object)"bg_green_00d2d3")) {
            button.getStyleClass().remove((Object)"bg_green_00d2d3");
        }
        if (!button.getStyleClass().contains((Object)"bg_aqua_velvet")) {
            button.getStyleClass().add((Object)"bg_aqua_velvet");
        }
    }

    private void deselectButtonType(Button button) {
        if (button.getStyleClass().contains((Object)"bg_aqua_velvet")) {
            button.getStyleClass().remove((Object)"bg_aqua_velvet");
        }
        if (!button.getStyleClass().contains((Object)"bg_green_00d2d3")) {
            button.getStyleClass().add((Object)"bg_green_00d2d3");
        }
    }

    public void setTypePourcentage() {
        this.type_discount = "pourcentage";
        this.selectButtonType(this.type_pourcentage);
        this.deselectButtonType(this.type_somme);
    }

    public void setTypeSomme() {
        this.type_discount = "somme";
        this.selectButtonType(this.type_somme);
        this.deselectButtonType(this.type_pourcentage);
    }

    public void modalConfirm() {
        try {
            this.mActionEventConfirm = new EventHiddenModal(){
                Boolean result = false;

                @Override
                public void onHidden() {
                    if (this.result.booleanValue()) {
                        ReductionsController.this.validDeleteDiscount();
                    }
                    ReductionsController.this.mLazyModalConfirm.destroyEvents();
                    ReductionsController.this.mModalConfirmationController = null;
                    ReductionsController.this.mActionEventConfirm = null;
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (ReductionsController.this.mModalConfirmationController != null) {
                        this.result = ReductionsController.this.mModalConfirmationController.getResult();
                    } else if (mBuilder != null && mBuilder.getController() != null) {
                        ReductionsController.this.mModalConfirmationController = (ModalConfirmationController)mBuilder.getController();
                        this.result = ReductionsController.this.mModalConfirmationController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalConfirm == null) {
                this.mLazyModalConfirm = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/components/popup_confirmation.fxml", new Dimension(400, 150));
            }
            this.mLazyModalConfirm.setEventHiddenModal(this.mActionEventConfirm);
            this.mLazyModalConfirm.load(new Object[0]);
            this.mModalConfirmationController = (ModalConfirmationController)this.mLazyModalConfirm.getLoadder().getController();
            this.mModalConfirmationController.configureText("Suppression R\u00e9duction", "Voulez-vous Supprimer la r\u00e9duction ?", "Confirmer", "Annuler");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void validDeleteDiscount() {
        if (this.mReductionInfo != null) {
            this.mReductionService.delete(this.mReductionInfo);
            this.reductions.remove(this.mReductionInfo);
            this.listPaneReductions.remove(this.mReductionInfo.getId());
            this.showReductions(this.listPaneReductions);
            this.initializer();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "R\u00e9duction supprim\u00e9.", 4000, NPosition.CENTER);
        }
    }
}

