/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.models.CashierLaterItemBox;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class PopupLaterController
implements RootController {
    @FXML
    GridPane main_pane;
    @FXML
    Button button_valid;
    @FXML
    Button button_cancel;
    @FXML
    Label title;
    @FXML
    HBox nextPreviousPane;
    @FXML
    Button label_later;
    @FXML
    Button label_now;
    @FXML
    Button previousPageBtn;
    @FXML
    Button nextPageBtn;
    @FXML
    FlowPane parent_pane;
    @FXML
    HBox pane_buttons;
    @FXML
    HBox later_now_btn_container;
    private Map<Integer, List<CashierLaterItemBox>> components;
    private Stage mStage;
    private TicketInfo ticketDraft;
    private TicketInfo ticket;
    private int totalLaterLines = 0;
    private double componentMaxHeight;
    private double componentMaxWidth;
    private static final int MAX_ROW = 3;
    private static final int MAX_COLUMN = 3;
    private int maxPageIndex = 0;
    private final int pageSize = 9;
    private int page = 0;

    public void initializer() {
        this.mStage.setAlwaysOnTop(false);
        this.setTexts();
        this.loadPanier();
    }

    public void valid() {
        for (int i = 0; i < this.ticketDraft.getLines().size(); ++i) {
            if (this.ticketDraft.getLines().get(i).isProduct_later()) {
                this.ticket.getLines().get(i).setTime_served(this.ticketDraft.getLines().get(i).getTime_served());
                continue;
            }
            for (int j = 0; j < this.ticketDraft.getLines().get(i).getListSupplements().size(); ++j) {
                this.ticket.getLines().get(i).getListSupplements().get(j).setTime_served(this.ticketDraft.getLines().get(i).getListSupplements().get(j).getTime_served());
            }
        }
        this.mStage.close();
    }

    public void loadPanier() {
        if (this.ticketDraft != null) {
            this.main_pane.getChildren().clear();
            for (TicketLineInfo line : this.ticket.getLines()) {
                if (line.isProduct_later()) {
                    ++this.totalLaterLines;
                    continue;
                }
                for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                    if (!optionItemOrder.isOption_later()) continue;
                    ++this.totalLaterLines;
                }
            }
            if (this.totalLaterLines > 9) {
                this.parent_pane.setVgap(7.0);
                this.pane_buttons.setPrefHeight(this.parent_pane.getHeight() * 0.06);
                this.later_now_btn_container.setPrefHeight(this.parent_pane.getHeight() * 0.06);
                this.nextPreviousPane.setManaged(true);
                this.nextPreviousPane.setVisible(true);
                this.previousPageBtn.setDisable(true);
            } else {
                this.parent_pane.setVgap(10.0);
                this.pane_buttons.setPrefHeight(this.parent_pane.getHeight() * 0.09);
                this.later_now_btn_container.setPrefHeight(this.parent_pane.getHeight() * 0.09);
            }
            this.componentMaxHeight = this.main_pane.getPrefHeight() / 3.0 - 20.0;
            this.componentMaxWidth = this.main_pane.getPrefWidth() / 3.0 - 20.0;
            this.components = new HashMap<Integer, List<CashierLaterItemBox>>();
            this.components.put(0, new ArrayList());
            int iteration = 0;
            for (TicketLineInfo line : this.ticketDraft.getLines()) {
                if (!line.isNext() && line.isProduct_later()) {
                    ++iteration;
                    CashierLaterItemBox componentLine = new CashierLaterItemBox(line, this.componentMaxWidth, this.componentMaxHeight);
                    this.components.get(this.maxPageIndex).add(componentLine);
                } else {
                    for (OptionItemOrder optionItemOrder : line.getListSupplements()) {
                        if (!optionItemOrder.isOption_later()) continue;
                        ++iteration;
                        CashierLaterItemBox componentLine = new CashierLaterItemBox(optionItemOrder, this.componentMaxWidth, this.componentMaxHeight);
                        this.components.get(this.maxPageIndex).add(componentLine);
                    }
                }
                if (iteration != 9) continue;
                this.components.put(this.maxPageIndex + 1, new ArrayList());
                ++this.maxPageIndex;
                iteration = 0;
            }
            this.paintItems();
        }
    }

    private void paintItems() {
        this.main_pane.getChildren().clear();
        int currentPlace = -1;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.components.get(this.page).size() - 1 < ++currentPlace) {
                    VBox emptyBox = new VBox();
                    emptyBox.setPrefWidth(this.componentMaxWidth);
                    emptyBox.setPrefHeight(this.componentMaxHeight);
                    emptyBox.setStyle("-fx-background-radius: 20px; -fx-border-radius: 20px; -fx-border-width: 1px; -fx-border-color: #FFFFFF1F; -fx-background-color: transparent;");
                    this.main_pane.add((Node)emptyBox, j, i);
                    continue;
                }
                this.main_pane.add((Node)this.components.get(this.page).get(currentPlace), j, i);
            }
        }
    }

    public void nextPage() {
        if (this.maxPageIndex > this.page) {
            ++this.page;
            this.paintItems();
            if (this.page == this.maxPageIndex) {
                this.nextPageBtn.setDisable(true);
            }
            if (this.previousPageBtn.isDisabled()) {
                this.previousPageBtn.setDisable(false);
            }
        }
    }

    public void previousPage() {
        if (this.page > 0) {
            --this.page;
            this.paintItems();
            if (this.page == 0) {
                this.previousPageBtn.setDisable(true);
            }
            if (this.nextPageBtn.isDisabled()) {
                this.nextPageBtn.setDisable(false);
            }
        }
    }

    private void setTexts() {
        this.title.setText("Souhaitez-vous recevoir vos produits maintenant ou apr\u00e8s votre repas ?");
        this.label_later.setText("\u23f3 Apr\u00e8s le repas");
        this.button_valid.setText("Continuer");
        this.button_cancel.setText("Ignorer");
        this.label_now.setText("Maintenant");
    }

    private void setItemLater(CashierLaterItemBox hBoxItemsLater) {
        if (hBoxItemsLater.getLine() != null) {
            hBoxItemsLater.getLine().setTime_served("later");
        }
        if (hBoxItemsLater.getOptionItemOrder() != null) {
            hBoxItemsLater.getOptionItemOrder().setTime_served("later");
        }
        hBoxItemsLater.selectLater();
    }

    private void setItemNow(CashierLaterItemBox hBoxItemsLater) {
        if (hBoxItemsLater.getLine() != null) {
            hBoxItemsLater.getLine().setTime_served("now");
        }
        if (hBoxItemsLater.getOptionItemOrder() != null) {
            hBoxItemsLater.getOptionItemOrder().setTime_served("now");
        }
        hBoxItemsLater.selectNow();
    }

    public void setItemsLater() {
        for (List<CashierLaterItemBox> items : this.components.values()) {
            for (CashierLaterItemBox hBoxItemsLater : items) {
                this.setItemLater(hBoxItemsLater);
            }
        }
    }

    public void setItemsNow() {
        for (List<CashierLaterItemBox> items : this.components.values()) {
            for (CashierLaterItemBox hBoxItemsLater : items) {
                this.setItemNow(hBoxItemsLater);
            }
        }
    }

    @Override
    public void init(Stage mStage) {
        this.mStage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.mStage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.mStage = mStage;
        if (objects != null && objects.length > 0) {
            this.ticket = (TicketInfo)objects[0];
            this.ticketDraft = (TicketInfo)((TicketInfo)objects[0]).clone();
        }
        this.initializer();
    }

    public void closePopUp() {
        this.mStage.close();
    }
}

