/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoViewRappel;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.kitchen.dao.entities.Tickets;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PopUpSharedOrders
implements RootController {
    @FXML
    TableView tableView;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn etat_order;
    @FXML
    TableColumn total_order;
    @FXML
    Button btn_validate_cancel;
    @FXML
    GridPane footer_print_pane;
    @FXML
    GridPane footer_cancel;
    @FXML
    GridPane pane_main;
    @FXML
    TableColumn table_order;
    @FXML
    TableColumn bipper_order;
    @FXML
    Button btn_cancel;
    @FXML
    GridPane parent_pane;
    @FXML
    GridPane close_pane;
    @FXML
    Label label_number_orders;
    @FXML
    Label label_total_orders;
    private int numberHours = 0;
    private boolean isLimitedByHours = false;
    private final SimpleDateFormat dateFormatter = DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    private List<TicketInfo> orders;
    private boolean result;
    private static double widthPane = AppVarUtils.getScreenDimension().getWidth() * 0.7;
    private static double heightPane = AppVarUtils.getScreenDimension().getHeight() * 0.7;
    private TicketSharedService mTicketSharedService;
    private Stage mStage;
    private List<Tickets> ticketsShared_by_day;
    private Date dateStart_orders;
    private Date dateEnd_orders;

    private void loadOrder() throws BasicException {
        int countOrder = 0;
        double totalOrder = 0.0;
        if (this.dateStart_orders != null && this.dateEnd_orders != null) {
            this.ticketsShared_by_day = this.mTicketSharedService.getAllOrders(this.dateStart_orders, this.dateEnd_orders);
            CaisseInfo mCaisseInfo = AppLocal.dlSales.getCaisse(AppLocal.token);
            this.orders = AppLocal.dlSales.getOrdersPending(mCaisseInfo.getDateOpen());
            ArrayList<TicketInfoViewRappel> items = new ArrayList<TicketInfoViewRappel>();
            for (Tickets order : this.ticketsShared_by_day) {
                String status;
                if (order == null) continue;
                String table = "";
                if (order.getNum_table() != -1 && order.getNum_table() != 0) {
                    table = String.valueOf(order.getNum_table());
                }
                String string = status = order.getPaid() ? "T\u00e9rmin\u00e9e" : "En Cours";
                if (order.getPaid()) {
                    ++countOrder;
                    totalOrder += order.getTotal();
                }
                String nameCustomer = order.getCustomer_name();
                items.add(new TicketInfoViewRappel(String.valueOf(order.getNum_order_kitchen()), nameCustomer, table, order.getBipper(), this.dateFormatter.format(order.getCreated()), this.timeFormatter.format(order.getCreated()), order.getType(), status, Formats.CURRENCY.formatValue(order.getTotal()), "", ""));
            }
            ObservableList data = FXCollections.observableArrayList(items);
            this.tableView.setItems(data);
            this.label_number_orders.setText("Nombre de commandes : " + countOrder);
            this.label_total_orders.setText("Total: " + Formats.CURRENCY.formatValue(totalOrder));
        }
    }

    private String getStatus(String status) {
        if (status != null) {
            switch (status) {
                case "livre": {
                    return "Livr\u00e9e";
                }
                case "paid": {
                    return "Termin\u00e9e";
                }
                case "cancel": {
                    return "Annul\u00e9e";
                }
                case "pending": {
                    return "En cours";
                }
                case "Refund": {
                    return "remboursement";
                }
            }
        }
        return null;
    }

    public void initializer() {
        this.result = false;
        this.numberHours = Integer.parseInt(AppLocal.TICKET_CALLBACK_COUNT != null && !AppLocal.TICKET_CALLBACK_COUNT.isEmpty() ? AppLocal.TICKET_CALLBACK_COUNT : "0");
        Calendar calToday = Calendar.getInstance();
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
        this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
        this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hourOrder"));
        this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("typeOrder"));
        this.etat_order.setCellValueFactory((Callback)new PropertyValueFactory("etatOrder"));
        this.total_order.setCellValueFactory((Callback)new PropertyValueFactory("totalOrder"));
        if (AppLocal.licence == "venteDetail") {
            this.tableView.getColumns().remove((Object)this.table_order);
            this.tableView.getColumns().remove((Object)this.type_order);
            this.tableView.getColumns().remove((Object)this.bipper_order);
            this.num_order.setPrefWidth(widthPane * 0.15);
            this.date_order.setPrefWidth(widthPane * 0.15);
            this.hour_order.setPrefWidth(widthPane * 0.15);
            this.etat_order.setPrefWidth(widthPane * 0.15);
            this.total_order.setPrefWidth(widthPane * 0.2);
        } else {
            this.num_order.setPrefWidth(widthPane * 0.1);
            this.date_order.setPrefWidth(widthPane * 0.15);
            this.hour_order.setPrefWidth(widthPane * 0.15);
            this.type_order.setPrefWidth(widthPane * 0.15);
            this.etat_order.setPrefWidth(widthPane * 0.1);
            this.total_order.setPrefWidth(widthPane * 0.1);
        }
        try {
            if (AppLocal.KITCHEN_COMPOSITE) {
                this.mTicketSharedService = TicketSharedService.getInstance();
            }
            this.loadOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.mStage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.mStage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.mStage = mStage;
        if (objects != null && objects.length > 0) {
            this.dateStart_orders = (Date)objects[0];
            this.dateEnd_orders = (Date)objects[1];
        }
        this.initializer();
    }

    public void closePopUp() {
        this.mStage.close();
    }
}

