/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.StockRapportView;
import com.openbravo.pos.util.LogToFile;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PopUpRapportStock {
    @FXML
    ComboBox typeOperation;
    @FXML
    TableView tableView;
    @FXML
    TableColumn name_product;
    @FXML
    TableColumn quantity;
    @FXML
    DatePicker datepicker;
    private Stage stage;
    private Object[] result;
    private List<StockRapportView> items;
    private HashMap<Integer, Double> listeQuantity;
    private Date dateOpearion;
    private String operation;
    private DataLogicSales dlSales;

    public void init(Stage stage, HashMap<Integer, Double> listQuantity, DataLogicSales dlSales, Date dateOpearion, String operation) throws BasicException {
        this.result = new Object[4];
        this.result[0] = null;
        this.result[1] = null;
        this.result[2] = null;
        this.result[3] = false;
        this.stage = stage;
        this.listeQuantity = listQuantity;
        this.dlSales = dlSales;
        this.name_product.setCellValueFactory((Callback)new PropertyValueFactory("product"));
        this.quantity.setCellValueFactory((Callback)new PropertyValueFactory("quantity"));
        this.quantity.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<StockRapportView, String>>(){

            public void handle(TableColumn.CellEditEvent<StockRapportView, String> t) {
                int idProduct = ((StockRapportView)t.getTableView().getItems().get(t.getTablePosition().getRow())).getIdProduct();
                PopUpRapportStock.this.listeQuantity.put(idProduct, Double.parseDouble((String)t.getNewValue()));
                try {
                    PopUpRapportStock.this.loadQuantity();
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
        });
        this.loadQuantity();
        Date input = dateOpearion;
        Instant instant = input.toInstant();
        ZonedDateTime zdt = instant.atZone(ZoneId.systemDefault());
        LocalDate date = zdt.toLocalDate();
        this.datepicker.setValue((Object)date);
        this.typeOperation.getSelectionModel().select((Object)operation);
    }

    public List<StockRapportView> getItems() throws BasicException {
        this.items = new ArrayList<StockRapportView>();
        for (Integer idProduct : this.listeQuantity.keySet()) {
            ProductInfoExt product = this.dlSales.getProductInfoById(idProduct);
            this.items.add(new StockRapportView(product.getID(), product.getName(), this.printQuantity(this.listeQuantity.get(idProduct))));
        }
        return this.items;
    }

    public Date getDateOperation(LocalDate localDate) {
        Instant instant = Instant.from(localDate.atStartOfDay(ZoneId.systemDefault()));
        Date date = Date.from(instant);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        Date dateTmp = new Date();
        cal.set(11, dateTmp.getHours());
        cal.set(12, dateTmp.getMinutes());
        return cal.getTime();
    }

    public void valider() {
        this.result[0] = this.getDateOperation((LocalDate)this.datepicker.getValue());
        this.result[1] = (String)this.typeOperation.getSelectionModel().getSelectedItem();
        this.result[2] = this.listeQuantity;
        this.result[3] = true;
        this.stage.close();
    }

    private void loadQuantity() throws BasicException {
        this.items = this.getItems();
        ObservableList data = FXCollections.observableArrayList(this.items);
        this.tableView.setItems(data);
    }

    public Object[] getResult() {
        return this.result;
    }

    public String printQuantity(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    public void closePopUp() {
        this.stage.close();
    }
}

