/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.DateUtils;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterErrorsDialogue;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.printer.QueuedDoc;
import com.openbravo.pos.printer.QueuedDocView;
import com.openbravo.pos.printer.Ticket2;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.norm.beans.Duplicata;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PopUpPrintError {
    @FXML
    Button btn_next_date;
    @FXML
    Button btn_previous_date;
    @FXML
    Label jdate;
    @FXML
    TableView tableView;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn printer;
    @FXML
    TableColumn etat_order;
    @FXML
    TableColumn total_order;
    @FXML
    TableColumn serveur_order;
    @FXML
    Button btn_kitchen;
    @FXML
    Button btn_caisse;
    @FXML
    Button btn_caisse_principal;
    @FXML
    Button btn_cancel;
    @FXML
    Button btn_duplicate;
    @FXML
    GridPane footer_print_pane;
    @FXML
    GridPane footer_btns;
    @FXML
    GridPane footer_cancel;
    @FXML
    GridPane pane_main;
    @FXML
    FlowPane pane_raison;
    @FXML
    TextArea raison;
    @FXML
    Label label_error_print;
    private final SimpleDateFormat dateFormatter = com.openbravo.pos.util.DateUtils.formatterYEAR_MONTH_DAY_TIRETS6;
    private final SimpleDateFormat timeFormatter = com.openbravo.pos.util.DateUtils.timeFormatter;
    @FXML
    TableColumn commandNum;
    private Stage stage;
    private AppView app;
    private Date date;
    protected DataLogicSales dlSales;
    List<TicketLineInfo> productToSend;
    private List<QueuedDoc> documents;
    private QueuedDoc document;
    protected DataLogicAdmin dlUsers;
    int row = -1;
    private static final double widthPane = 700.0;
    private PrinterErrorsDialogue parent;

    public void init(Scene scene, AppView app, PrinterErrorsDialogue parent) throws BasicException {
        this.parent = parent;
        this.app = app;
        this.dlSales = (DataLogicSales)this.app.getBean("com.openbravo.dao.DataLogicSales");
        this.productToSend = new ArrayList<TicketLineInfo>();
        this.loadPaneFooter();
        this.switchToBtns();
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.tableView, 0, 0);
        this.document = null;
        this.tableView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                if (PopUpPrintError.this.tableView.getSelectionModel().getSelectedIndex() != -1) {
                    PopUpPrintError.this.row = PopUpPrintError.this.tableView.getSelectionModel().getSelectedIndex();
                    if (PopUpPrintError.this.row != -1) {
                        PopUpPrintError.this.document = PopUpPrintError.this.documents.get(PopUpPrintError.this.row);
                        PopUpPrintError.this.switchToBtns();
                    }
                }
            }
        });
        Calendar calToday = Calendar.getInstance();
        this.date = DateUtils.getToday();
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
        this.commandNum.setCellValueFactory((Callback)new PropertyValueFactory("commandNum"));
        this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
        this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hourOrder"));
        this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("typeOrder"));
        this.printer.setCellValueFactory((Callback)new PropertyValueFactory("printer"));
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date = calToday.getTime();
        }
        this.setTime(this.date);
        this.loadDocuments();
        this.setTexts();
    }

    public void next() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, 1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDay() == cal.getTime().getDay()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText("Aujourd'hui");
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDay() == cal.getTime().getDay()) {
            this.jdate.setText("Hier");
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        this.loadDocuments();
    }

    public void previous() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, -1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDay() == cal.getTime().getDay()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText("Aujourd'hui");
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDay() == cal.getTime().getDay()) {
            this.jdate.setText("Hier");
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        this.loadDocuments();
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
    }

    private void loadDocuments() {
        if (AppVarUtils.QUEUE != null) {
            this.documents = new ArrayList<QueuedDoc>(AppVarUtils.QUEUE.values());
            ArrayList<QueuedDocView> items = new ArrayList<QueuedDocView>();
            for (QueuedDoc doc : this.documents) {
                items.add(new QueuedDocView(doc.getId(), doc.getNumDoc(), this.dateFormatter.format(doc.getDateEchec()), this.timeFormatter.format(doc.getDateEchec()), doc.getTypeDoc(), doc.getPrinter().getName() != null ? doc.getPrinter().getName() : (doc.getPrinter().getNamePrinter() != null ? doc.getPrinter().getNamePrinter() : doc.getPrinter().getIp())));
            }
            ObservableList data = FXCollections.observableArrayList(items);
            this.tableView.setItems(data);
        }
    }

    public void cancel() {
        if (this.document != null) {
            AppVarUtils.QUEUE.remove(this.document.getTypeDoc() + this.document.getIdDocument());
            this.loadDocuments();
            this.document = null;
        }
    }

    public void printTicket() {
        if (this.document != null) {
            try {
                final PrinterInfo pri = this.dlSales.getPrinterByID(this.document.getPrinter().getId());
                final String idDocument = this.document.getTypeDoc().equalsIgnoreCase("TICKET") || this.document.getTypeDoc().equalsIgnoreCase("FACTURE") || this.document.getTypeDoc().equalsIgnoreCase("DUPLICATA") ? this.document.getIdDocument() : "";
                AppVarUtils.QUEUE.remove(this.document.getTypeDoc() + this.document.getIdDocument());
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        PrinterHelper ph = new PrinterHelper();
                        Duplicata d = null;
                        if (PopUpPrintError.this.document.getTypeDoc().equalsIgnoreCase("DUPLICATA")) {
                            try {
                                d = PopUpPrintError.this.dlSales.getDuplicataByIdDoc(idDocument, "Ticket");
                            }
                            catch (BasicException ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                        Decreaser decreaser = new Decreaser(PopUpPrintError.this.dlSales, idDocument, PopUpPrintError.this.document.getTypeDoc(), d, PopUpPrintError.this.document.getNumDoc());
                        PrinterHelper.printTicket(new Ticket2(PopUpPrintError.this.document.getPrinter().getWith(), PopUpPrintError.this.document.getPrinter().getWith(), PopUpPrintError.this.document.getContent()), "Echec d'impression ", "Echec  d'impression de " + PopUpPrintError.this.document.getTypeDoc(), pri, decreaser);
                    }
                });
                Thread.sleep(5100L);
                this.loadDocuments();
                this.document = null;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void printTicketPrincipal() {
        if (this.document != null) {
            AppVarUtils.QUEUE.remove(this.document.getTypeDoc() + this.document.getIdDocument());
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PrinterHelper ph = new PrinterHelper();
                    Decreaser decreaser = new Decreaser(PopUpPrintError.this.dlSales, PopUpPrintError.this.document.getIdDocument(), PopUpPrintError.this.document.getTypeDoc(), null, PopUpPrintError.this.document.getNumDoc());
                    try {
                        PrinterInfo pri = PopUpPrintError.this.dlSales.getPrinterByID(1);
                        PrinterHelper.printTicket(new Ticket2(PopUpPrintError.this.document.getPrinter().getWith(), PopUpPrintError.this.document.getPrinter().getWith(), PopUpPrintError.this.document.getContent()), "Echec  d'impression ", "Echec  d'impression de " + PopUpPrintError.this.document.getTypeDoc(), pri, decreaser);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
            try {
                Thread.sleep(3000L);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            this.loadDocuments();
            this.document = null;
        }
    }

    public void switchToBtns() {
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.footer_btns, 0, 0);
    }

    public void switchToCancel() {
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.footer_cancel, 0, 0);
    }

    private void loadPaneFooter() throws BasicException {
        this.footer_btns.getChildren().clear();
        this.footer_btns.add((Node)this.btn_caisse, 1, 0);
        this.footer_btns.add((Node)this.btn_caisse_principal, 2, 0);
        this.footer_btns.add((Node)this.btn_cancel, 0, 0);
    }

    public void closePopUp() {
        this.parent.dispose();
    }

    private void setTexts() {
        this.label_error_print.setText(AppLocal.getIntString("Text.error.print"));
        this.commandNum.setText("N\u00b0" + AppLocal.getIntString("Text.order"));
        this.date_order.setText(AppLocal.getIntString("Text.date.failure"));
        this.hour_order.setText(AppLocal.getIntString("Text.hour.failure"));
        this.type_order.setText(AppLocal.getIntString("Text.type.document"));
        this.printer.setText(AppLocal.getIntString("Text.type.printer"));
        this.btn_caisse.setText(AppLocal.getIntString("Text.reload"));
        this.btn_caisse_principal.setText(AppLocal.getIntString("Text.printer.caisse"));
        this.btn_cancel.setText(AppLocal.getIntString("Button.cancel"));
    }
}

