/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.glory.fcc.service.BrueBoxServiceCallbackHandler;
import com.glory.fcc.service.BrueBoxServiceStub;
import com.glory.fcc.service.FCCClient;
import com.glory.fcc.service.IUserInterface;
import com.openbravo.AppConstants;
import com.openbravo.basic.BasicException;
import com.openbravo.beans.DateUtils;
import com.openbravo.beans.TicketAvoir;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.controllers.GloryController;
import com.openbravo.controllers.PopUpCouvertController;
import com.openbravo.controllers.PopUpMotifImpressionController;
import com.openbravo.controllers.displayKitchen.AddOrderInterface;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.keen.CassandraManager;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.NumberOrder;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoViewRappel;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.openbravo.postgresql.db.PostgreService;
import com.openbravo.qrcode.QrCodeHelper;
import com.openbravo.service.AvoirService;
import com.openbravo.service.TicketService;
import com.procaisse.MEV.MEVService;
import fr.protactile.kitchen.services.OrderService;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.procaisse.services.AddressService;
import fr.protactile.procaisse.services.TransactionMoneyService;
import fr.protactile.procaisse.tpeCmi.TPECmi;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.rmi.Naming;
import java.rmi.Remote;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.control.KeyBoardPopup;
import org.comtel2000.keyboard.control.KeyboardPane;
import org.comtel2000.keyboard.robot.IRobot;
import org.comtel2000.swing.robot.NativeAsciiRobotHandler;

public class PopUpPrint
implements RootController {
    @FXML
    Button btn_avoir;
    @FXML
    Button btn_next_date;
    @FXML
    Button btn_previous_date;
    @FXML
    Label jdate;
    @FXML
    TableView tableView;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn etat_order;
    @FXML
    TableColumn total_order;
    @FXML
    TableColumn serveur_order;
    @FXML
    Button btn_kitchen;
    @FXML
    Button btn_dk;
    @FXML
    Button btn_label;
    @FXML
    Button btn_caisse;
    @FXML
    Button btn_cancel;
    @FXML
    Button btn_validate_cancel;
    @FXML
    Button btn_duplicate;
    @FXML
    GridPane footer_print_pane;
    @FXML
    GridPane parent_print_pane;
    @FXML
    GridPane close_pane;
    @FXML
    FlowPane top_print_pane;
    @FXML
    GridPane footer_btns;
    @FXML
    GridPane footer_cancel;
    @FXML
    GridPane pane_main;
    @FXML
    FlowPane pane_raison;
    @FXML
    TextArea raison;
    @FXML
    Button btn_justificatif;
    @FXML
    Button btn_recap;
    @FXML
    Label reason_cancel;
    @FXML
    Button btn_keyboard;
    private TicketAvoir avoir;
    private int numberHours = 0;
    private boolean isLimitedByHours = false;
    private final SimpleDateFormat dateFormatter = com.openbravo.pos.util.DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat timeFormatter = com.openbravo.pos.util.DateUtils.timeFormatter;
    private Stage stage_cmi = null;
    private final String cmilodingFxml = "/fxml/cmilodingFxml.fxml";
    private boolean iscanceled = false;
    @FXML
    TableColumn table_order;
    @FXML
    TableColumn bipper_order;
    @FXML
    Button btn_duplicata;
    @FXML
    Button btn_reprint;
    @FXML
    TableColumn source_order;
    private Stage stage;
    private AppView app;
    private Date date;
    private TicketInfo ticketTrackedTempo;
    protected DataLogicSales dlSales;
    private DataLogicOrder dlOrders;
    private AvoirService avoirService;
    private Date dateStart;
    private Date dateEnd;
    private List<PrinterInfo> printers;
    List<TicketLineInfo> productToSend;
    private List<TicketLineInfo> productEMP;
    private List<TicketLineInfo> productSpLater;
    private List<TicketLineInfo> productEmpLater;
    private List<TicketInfo> orders;
    private TicketInfo currentOrder;
    private EnteteInfo entetTicket;
    protected DataLogicAdmin dlUsers;
    private boolean editRaison;
    private Object[] result;
    private static double widthPane = AppVarUtils.getScreenDimension().getWidth() * 0.75;
    private static double heightPane = AppVarUtils.getScreenDimension().getHeight() * 0.7;
    AddressService mAddressService = AddressService.getInstance();
    protected List<PrinterInfo> printersLabel = new ArrayList<PrinterInfo>();
    private OrderService orderService;
    private CassandraManager m_keenProject = null;
    protected DataLogicItems dlItems;
    private TicketService mTicketService;
    private PrinterInfo printerSummaryKitchen;
    private TicketSharedService mTicketSharedService;
    private PostgreService mPostgreService = null;
    private KeyBoardPopup popupKeyBoard;
    private boolean keyBoardLoaded;
    private String ID_PERMISSION_CANCEL_ORDR = "3";
    private String ID_PERMISSION_PRINT_TICKET_CAISSE = "15";
    private String ID_PERMISSION_PRINT_TICKET_KITCHEN = "16";
    private String ID_PERMISSION_PRINT_JUSTIFICATIF_PAYMENT = "17";
    private String ID_PERMISSION_DUPLICATE_TICKET = "18";
    private String ID_PERMISSION_PRINT_LABEL = "19";
    private boolean PERMISSION_CANCEL_ORDR;
    private boolean PERMISSION_PRINT_TICKET_CAISSE;
    private boolean PERMISSION_PRINT_TICKET_KITCHEN;
    private boolean PERMISSION_PRINT_JUSTIFICATIF_PAYMENT;
    private boolean PERMISSION_DUPLICATE_TICKET;
    private boolean PERMISSION_PRINT_LABEL;
    private MEVService mEVService;
    private TPECmi mTPECmi;
    private final String WHITE_STYLE_FONT = "-fx-background-insets: 5;-fx-font-size: 14px;-fx-text-fill: white !important;  -fx-font-family: \"AvenirNext-Bold\"; -fx-font-weight: bold;";

    public void next() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, 1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText(AppLocal.getIntString("Label.today"));
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jdate.setText(AppLocal.getIntString("Label.yesterday"));
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        try {
            this.loadOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void previous() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, -1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText(AppLocal.getIntString("Label.today"));
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jdate.setText(AppLocal.getIntString("Label.yesterday"));
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        try {
            this.loadOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        this.dateStart = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        this.dateEnd = calEnd.getTime();
    }

    private void loadOrder() throws BasicException {
        this.currentOrder = null;
        if ("2".equals(this.app.getAppUserView().getUser().getRole())) {
            if (AppLocal.TICKET_CALLBACK_LIMITED) {
                Calendar cal = Calendar.getInstance();
                this.dateEnd = new Date();
                cal.setTime(this.dateEnd);
                cal.add(10, -this.numberHours);
                this.dateStart = cal.getTime();
                this.btn_previous_date.setDisable(true);
                this.btn_next_date.setDisable(true);
            }
            this.orders = this.dlSales.loadAllTicketByuser(this.dateStart, this.dateEnd, this.app.getAppUserView().getUser().getId());
        } else {
            this.orders = this.dlSales.loadTicketToPrint(this.dateStart, this.dateEnd);
        }
        System.out.println("orders " + this.orders);
        ArrayList<TicketInfoViewRappel> items = new ArrayList<TicketInfoViewRappel>();
        for (TicketInfo order : this.orders) {
            if (order == null) continue;
            String table = "";
            if (order.getIdTable() != -1) {
                table = String.valueOf(order.getTable().getNumber());
            }
            String status = AppConstants.getStatus(order.getStatus());
            String type = AppConstants.getTypeOrder(order.getType());
            String nameCustomer = order.getCustomer() != null ? order.getCustomer().getName() : order.getName_customer();
            String sourceOrder = this.mTicketService.getSourceOrder(order);
            NumberOrder numberOrder = this.mTicketService.getNumberOrder(order);
            Object numberOrderText = numberOrder.getNumber_order();
            numberOrderText = (String)numberOrderText + (String)(numberOrder.getAdditioanl_text() != null && !numberOrder.getAdditioanl_text().isBlank() ? " (" + numberOrder.getAdditioanl_text() + ")" : "");
            items.add(new TicketInfoViewRappel((String)numberOrderText, nameCustomer, table, order.getBipper(), this.dateFormatter.format(order.getDate()), this.timeFormatter.format(order.getDate()), type, status, order.printTotalOrder(), order.getUser().getName(), sourceOrder));
        }
        ObservableList data = FXCollections.observableArrayList(items);
        this.tableView.setItems(data);
    }

    public void printKitchen() {
        if (this.currentOrder != null && !this.currentOrder.getStatus().equalsIgnoreCase("cancel") && !this.currentOrder.getStatus().equalsIgnoreCase("Refund")) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PopUpPrint.this.mTicketService.printKitchen(PopUpPrint.this.currentOrder, false, null, true, false);
                }
            });
        }
    }

    public void printCaisse() {
        block12: {
            if (this.currentOrder != null && this.currentOrder.getStatus().equalsIgnoreCase("cancel") && this.currentOrder.isPaid()) {
                try {
                    new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, AppLocal.getIntString("Message.canceled.order"), 1500, NPosition.BOTTOM_RIGHT);
                    TicketInfo ticketRefund = this.dlSales.getTicketByOrigin(this.currentOrder.getId());
                    this.avoir = this.dlOrders.findTicketAvoirByTicket(ticketRefund.getId());
                    ticketRefund.setAddressInfo(this.mAddressService.findOne(ticketRefund.getAddress()));
                    ticketRefund.setCustomer(this.dlSales.loadCustomerExt(ticketRefund.getCustomerId()));
                    List<TicketLineInfo> lines = this.dlSales.loadLines(ticketRefund.getId());
                    List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(ticketRefund.getId());
                    lines.addAll(linesExterne);
                    ticketRefund.setLines(lines);
                    ticketRefund.setReason_cancel(this.currentOrder.getReason_cancel());
                    this.mTicketService.printPaidTicketCaisse(ticketRefund, this.entetTicket, null);
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", null, ex);
                }
            } else if (this.currentOrder != null && this.currentOrder.getLinesCount() > 0) {
                PrinterHelper printer = new PrinterHelper();
                try {
                    this.currentOrder.setPayments(this.dlSales.findPaymetsByIdTicket(this.currentOrder.getId()));
                    if (!this.currentOrder.isPaid()) {
                        Executors.newSingleThreadExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                PopUpPrint.this.mTicketService.printAddition(PopUpPrint.this.currentOrder);
                                PopUpPrint.this.currentOrder.setPrint_after_update(true);
                                PopUpPrint.this.btn_caisse.setDisable(true);
                            }
                        });
                        break block12;
                    }
                    this.entetTicket = this.dlSales.getEnteteByTicket(this.currentOrder.getId(), this.currentOrder.isPaid());
                    if (this.entetTicket.IsTicketRestituted()) {
                        this.loadPopUpMotifImpression();
                        break block12;
                    }
                    this.mTicketService.printPaidTicketCaisse(this.currentOrder, this.entetTicket, null);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", null, ex);
                }
            } else {
                new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, AppLocal.getIntString("Message.select.order"), 1500, NPosition.BOTTOM_RIGHT);
            }
        }
        if (this.currentOrder != null && this.currentOrder.isPaid()) {
            boolean hasCBPayment = this.hasCbPayment(this.currentOrder);
            System.out.println("******** hasCBPayment hasCBPayment ********" + hasCBPayment);
            if (hasCBPayment && AppLocal.CMI_TPE_PAYMENT) {
                this.printCmiDuplicata(this.currentOrder);
            }
        }
    }

    public void showRaison() {
        if (this.currentOrder != null) {
            boolean paid = false;
            for (TicketLineInfo line : this.currentOrder.getLines()) {
                if (line.getUnits_paid() == 0.0) continue;
                paid = true;
                break;
            }
            if (!paid || this.currentOrder.isPaid()) {
                this.pane_main.getChildren().clear();
                this.tableView.setPrefHeight(heightPane * 0.65 * 0.8);
                this.pane_raison.setPrefHeight(heightPane * 0.65 * 0.2);
                this.pane_main.add((Node)this.tableView, 0, 0);
                this.pane_main.add((Node)this.pane_raison, 0, 1);
                this.switchToCancel();
                this.editRaison = true;
            } else {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.cancel"), 1500, NPosition.BOTTOM_RIGHT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void cancelOrder() {
        this.iscanceled = false;
        if (this.raison.getText().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.reason.cancel"), 1500, NPosition.BOTTOM_RIGHT);
        } else if (this.currentOrder != null) {
            try {
                this.currentOrder.setReason_cancel(this.raison.getText());
                ticketTracked = (TicketInfo)this.currentOrder.clone();
                ticketLoyalty = (TicketInfo)this.currentOrder.clone();
                hasCBPayment = this.hasCbPayment(this.currentOrder);
                System.out.println("********hasCBPayment ******* " + hasCBPayment);
                if (hasCBPayment && AppLocal.CMI_TPE_PAYMENT) {
                    this.loadingCmi("Annulation ");
                    executor = Executors.newSingleThreadExecutor();
                    future = executor.submit(new Callable<Boolean>(){

                        @Override
                        public Boolean call() {
                            Object[] results_cmi = null;
                            PopUpPrint.this.mTPECmi = TPECmi.getInstance();
                            results_cmi = PopUpPrint.this.mTPECmi.doCancelCurrentPayment(PopUpPrint.this.currentOrder);
                            if (results_cmi != null && results_cmi.length == 7) {
                                boolean success = (Boolean)results_cmi[0];
                                System.out.println("++++++success " + success);
                                final String message = String.valueOf(results_cmi[1]);
                                String ticket_cmi = String.valueOf(results_cmi[2]);
                                String session_id = String.valueOf(results_cmi[3]);
                                String ecr_stan = String.valueOf(results_cmi[4]);
                                String eft_stan = String.valueOf(results_cmi[5]);
                                String last4_digits = String.valueOf(results_cmi[6]);
                                PopUpPrint.this.currentOrder.setSession_id(session_id);
                                PopUpPrint.this.currentOrder.setEft_stan(eft_stan);
                                PopUpPrint.this.currentOrder.setTag_erc_stan(ecr_stan);
                                PopUpPrint.this.currentOrder.setLast_digit(last4_digits);
                                PopUpPrint.this.currentOrder.setEcrDateTime(AppLocal.CURRENT_ECR_DATE_TIME);
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        PopUpPrint.this.createPrintPane();
                                    }
                                });
                                if (success) {
                                    PopUpPrint.this.iscanceled = true;
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, message, 1500, NPosition.BOTTOM_RIGHT);
                                        }
                                    });
                                    if (ticket_cmi != null && !ticket_cmi.isEmpty()) {
                                        PrinterHelper printer = new PrinterHelper();
                                        PopUpPrint.this.mTicketService.printCmiTicketPayment(printer, ticket_cmi, true);
                                    }
                                } else {
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, message, 1500, NPosition.BOTTOM_RIGHT);
                                        }
                                    });
                                    PopUpPrint.this.iscanceled = false;
                                }
                                return success;
                            }
                            return false;
                        }
                    });
                    try {
                        result = future.get();
                        if (!result) ** GOTO lbl29
                        this.iscanceled = true;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        executor.shutdown();
                    }
                } else {
                    this.iscanceled = true;
                }
lbl29:
                // 4 sources

                System.out.println("************ iscanceled " + this.iscanceled);
                if (this.iscanceled) {
                    if (AppLocal.KITCHEN_COMPOSITE && this.currentOrder.getId_shared_order() != 0) {
                        this.mTicketSharedService.cancelOrder(this.currentOrder.getId_shared_order(), null);
                    }
                    if (AppLocal.KITCHEN_COMPOSITE) {
                        this.orderService.cancelOrder(this.currentOrder.getId());
                    }
                    this.currentOrder.setPayments(this.dlSales.findPaymetsByIdTicket(this.currentOrder.getId()));
                    if (this.currentOrder.isPaid() && this.currentOrder.getTotalOrder() > 0.0) {
                        this.refundMoney(ticketTracked, -this.currentOrder.getTotalOrder());
                    } else {
                        this.dlSales.cancelOrderPending(this.currentOrder, this.raison.getText(), this.app.getAppUserView().getUser().getId());
                        this.printCanceledTicketAndLoadTable();
                        if (AppLocal.CUSTOMER_LOYALTY) {
                            this.mTicketService.deleteTransactionLoyalty(ticketLoyalty);
                        }
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    private void printCanceledTicketAndLoadTable() throws BasicException {
        this.mTicketService.prepareTicketCuisine(this.currentOrder);
        final TicketInfo tikcetToSend = (TicketInfo)this.currentOrder.clone();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                PopUpPrint.this.mTicketService.printKitchenTicketCanceld(tikcetToSend);
            }
        });
        NotifyWindow notifyWindow = new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, AppLocal.getIntString("Message.cancel.order"), 1500, NPosition.BOTTOM_RIGHT);
        this.loadOrder();
        this.hideRaison();
        this.switchToBtns();
        AppLocal.CANCEL_ORDER = true;
    }

    private void cancelTicket(final TicketInfo ticketTracked, String modeRefund) throws BasicException {
        ticketTracked.setReason_cancel(this.raison.getText());
        TicketInfo ti = this.mTicketService.cancelTicket(this.currentOrder, modeRefund);
        ticketTracked.setReason_cancel(ti.getReason_cancel());
        if (AppLocal.IS_STATS_ONLINE_ENABLED.booleanValue()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PopUpPrint.this.mPostgreService = PostgreService.getInstance();
                    PopUpPrint.this.mPostgreService.canceledOrder(ticketTracked);
                }
            }).start();
        }
        this.entetTicket = this.dlSales.getEnteteByTicket(ti.getId(), this.currentOrder.isPaid());
        this.avoir = this.dlOrders.findTicketAvoirByTicket(ti.getId());
        ti.setAddressInfo(this.mAddressService.findOne(ti.getAddress()));
        ti.setCustomer(this.dlSales.loadCustomerExt(ti.getCustomerId()));
        List<TicketLineInfo> lines = this.dlSales.loadLines(ti.getId());
        List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(ti.getId());
        lines.addAll(linesExterne);
        ti.setLines(lines);
        this.printCanceledOrder(ti);
        this.result[2] = true;
        this.printCanceledTicketAndLoadTable();
    }

    public void cancel() {
        if (this.currentOrder != null) {
            if (this.currentOrder.getClosed().booleanValue()) {
                NotifyWindow notifyWindow = new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.cancel.closed.order"), 2500, NPosition.BOTTOM_RIGHT);
            } else if (!this.currentOrder.getStatus().equalsIgnoreCase("cancel") && !this.currentOrder.getStatus().equalsIgnoreCase("Refund") && this.currentOrder.getTotal() >= 0.0) {
                this.showRaison();
            } else {
                NotifyWindow notifyWindow = new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.unable.cancel.order"), 2500, NPosition.BOTTOM_RIGHT);
            }
        }
    }

    public void hideRaison() {
        this.raison.setText("");
        this.pane_main.getChildren().clear();
        this.tableView.setPrefHeight(heightPane * 0.65);
        this.pane_main.add((Node)this.tableView, 0, 0);
        this.editRaison = false;
    }

    public void duplicate() {
        if (this.currentOrder != null) {
            if (!this.currentOrder.getStatus().equalsIgnoreCase("Refund")) {
                this.result[0] = this.currentOrder;
                this.result[1] = true;
                this.stage.close();
            } else {
                try {
                    TicketInfo canceldTicket = this.dlSales.getTicketById(this.currentOrder.getOrigineCanceledTicketString());
                    canceldTicket.setAddressInfo(this.mAddressService.findOne(canceldTicket.getAddress()));
                    canceldTicket.setCustomer(this.dlSales.loadCustomerExt(canceldTicket.getCustomerId()));
                    List<TicketLineInfo> lines = this.dlSales.loadLines(canceldTicket.getId());
                    List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(canceldTicket.getId());
                    lines.addAll(linesExterne);
                    canceldTicket.setLines(lines);
                    this.result[0] = canceldTicket;
                    this.result[1] = true;
                    this.stage.close();
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", null, ex);
                }
            }
        } else {
            new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, AppLocal.getIntString("Message.select.order.to.duplicate"), 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    public Object[] getResult() {
        return this.result;
    }

    public void switchToBtns() {
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.footer_btns, 0, 0);
    }

    public void switchToCancel() {
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.footer_cancel, 0, 0);
    }

    private void loadPaneFooter() throws BasicException {
        this.PERMISSION_CANCEL_ORDR = this.dlUsers.hasPermission(this.app.getAppUserView().getUser().getId(), this.ID_PERMISSION_CANCEL_ORDR);
        this.PERMISSION_PRINT_TICKET_CAISSE = this.dlUsers.hasPermission(this.app.getAppUserView().getUser().getId(), this.ID_PERMISSION_PRINT_TICKET_CAISSE);
        this.PERMISSION_PRINT_TICKET_KITCHEN = this.dlUsers.hasPermission(this.app.getAppUserView().getUser().getId(), this.ID_PERMISSION_PRINT_TICKET_KITCHEN);
        this.PERMISSION_PRINT_JUSTIFICATIF_PAYMENT = this.dlUsers.hasPermission(this.app.getAppUserView().getUser().getId(), this.ID_PERMISSION_PRINT_JUSTIFICATIF_PAYMENT);
        this.PERMISSION_DUPLICATE_TICKET = this.dlUsers.hasPermission(this.app.getAppUserView().getUser().getId(), this.ID_PERMISSION_DUPLICATE_TICKET);
        this.PERMISSION_PRINT_LABEL = this.dlUsers.hasPermission(this.app.getAppUserView().getUser().getId(), this.ID_PERMISSION_PRINT_LABEL);
        this.footer_btns.getChildren().clear();
        ArrayList<Button> buttons = new ArrayList<Button>();
        if (!"venteDetail".equals(AppLocal.licence)) {
            buttons.add(this.btn_dk);
            if (this.PERMISSION_PRINT_TICKET_KITCHEN) {
                buttons.add(this.btn_kitchen);
            }
            if (this.PERMISSION_PRINT_LABEL) {
                buttons.add(this.btn_label);
            }
        }
        if (AppLocal.MODULE_MEV && !AppLocal.CONTINUITY_MODE_MEV) {
            buttons.add(this.btn_duplicata);
            buttons.add(this.btn_reprint);
        } else if (this.PERMISSION_PRINT_TICKET_CAISSE) {
            buttons.add(this.btn_caisse);
        }
        if (!"venteDetail".equals(AppLocal.licence)) {
            buttons.add(this.btn_avoir);
        }
        if (this.PERMISSION_CANCEL_ORDR) {
            buttons.add(this.btn_cancel);
        }
        if (this.PERMISSION_DUPLICATE_TICKET) {
            buttons.add(this.btn_duplicate);
        }
        if (!"venteDetail".equals(AppLocal.licence)) {
            if (this.PERMISSION_PRINT_JUSTIFICATIF_PAYMENT && !AppLocal.MODULE_MEV && !AppLocal.MODULE_TVA_GLOBAL) {
                buttons.add(this.btn_justificatif);
            }
            if (AppLocal.PRINT_RECAP || AppLocal.PRINT_RECAP_DELIVERY) {
                buttons.add(this.btn_recap);
            }
        }
        for (int i = 0; i < buttons.size(); ++i) {
            ((Button)buttons.get(i)).setPrefWidth(widthPane / (double)buttons.size());
            this.footer_btns.add((Node)buttons.get(i), i, 0);
        }
    }

    public void closePopUp() {
        this.stage.close();
    }

    public void printLabel() {
        if (!(this.currentOrder == null || AppLocal.PRINT_LABEL_TAKE_AWAY && !this.currentOrder.getType().equals("A Emporter") || AppLocal.PRINT_LABEL_PRODUCT_WITH_EXCLUDED_INFREDIENT && !this.currentOrder.hasProductWithExludedIngredient() || this.currentOrder.getStatus().equalsIgnoreCase("cancel") || this.currentOrder.getStatus().equalsIgnoreCase("Refund"))) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        System.out.println("print label 1 ****************** ");
                        TicketInfo tikcetToSendToLabelPrinter = (TicketInfo)PopUpPrint.this.currentOrder.clone();
                        PopUpPrint.this.mTicketService.printLabel(tikcetToSendToLabelPrinter);
                    }
                    catch (Exception ex) {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "L'impression de l'etiquette a \u00e9chou\u00e9.", 1500, NPosition.CENTER);
                        LogToFile.log("severe", null, ex);
                    }
                }
            });
        }
    }

    public void printAvoir() {
        if (this.currentOrder != null && this.avoir != null && !this.currentOrder.getStatus().equalsIgnoreCase("cancel") && !this.currentOrder.getStatus().equalsIgnoreCase("refund")) {
            final PrinterHelper printer = new PrinterHelper();
            if (this.currentOrder.isPaid()) {
                try {
                    this.entetTicket = this.dlSales.getEnteteByTicket(this.currentOrder.getId(), this.currentOrder.isPaid());
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else {
                try {
                    MarqueNFC marqueNF = MarqueNFC.fetchOrStore(this.dlSales);
                    this.entetTicket = new EnteteInfo("", "0", "10.0.1.27", 0, marqueNF.getCompany(), marqueNF.getAdresse1(), marqueNF.getZipCode(), marqueNF.getCity(), marqueNF.getCountry(), marqueNF.getSiret(), marqueNF.getCodeNAF(), marqueNF.getIntraTVA(), this.currentOrder.getDate(), "Commande", this.currentOrder.getLinesCount(), this.currentOrder.getId(), AppLocal.header, AppLocal.footer, "pending", "", "1", "BIBORNE", this.app.getAppUserView().getUser().getId(), true, true, "impression papier", 0, this.app.getAppUserView().getUser().getName());
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Decreaser decreaser = new Decreaser(PopUpPrint.this.dlSales, PopUpPrint.this.currentOrder.getId(), "Ticket Avoir", null, PopUpPrint.this.currentOrder.getNumero_order());
                    BufferedImage qrCodeImage = QrCodeHelper.stringToImageQrCode(PopUpPrint.this.avoir.getBarCode());
                    printer.printAvoir(PopUpPrint.this.avoir.getAmount(), PopUpPrint.this.entetTicket, PopUpPrint.this.avoir, qrCodeImage, decreaser);
                }
            });
        }
    }

    public AddOrderInterface getRemoteAddOrder(PrinterInfo ecran) {
        try {
            String ip;
            Remote r;
            if (ecran != null && ecran.getIp() != null && !ecran.getIp().isEmpty() && (r = Naming.lookup("rmi://" + (ip = ecran.getIp()) + "/TestRMI")) instanceof AddOrderInterface) {
                return (AddOrderInterface)r;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "La connexion \u00e0 l'ecran de suivi a \u00e9chou\u00e9.", 4000, NPosition.CENTER);
        return null;
    }

    public void resendToDK() {
        if (this.currentOrder != null && !this.currentOrder.getStatus().equalsIgnoreCase("cancel") && !this.currentOrder.getStatus().equalsIgnoreCase("Refund")) {
            final TicketInfo ticketToSendToDisplay = (TicketInfo)this.currentOrder.clone();
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        List<PrinterInfo> displayKitchens = PopUpPrint.this.dlSales.getDisplayKitchens();
                        for (PrinterInfo displayKitchen : displayKitchens) {
                            ticketToSendToDisplay.getLines().clear();
                            for (TicketLineInfo line : PopUpPrint.this.currentOrder.getLines()) {
                                if (line.isNext()) {
                                    ticketToSendToDisplay.getLines().add(line);
                                    continue;
                                }
                                if (PopUpPrint.this.dlSales.getProductInfoById(line.getProductID()).getDisplayKitchen() != displayKitchen.getId()) continue;
                                List<SupplementItemInfo> ingrediens = PopUpPrint.this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
                                line.setListIngredientsIN(ingrediens);
                                line.getIngredientsInclus();
                                ticketToSendToDisplay.getLines().add(line);
                            }
                            if (ticketToSendToDisplay.getLines().size() <= 0) continue;
                            PopUpPrint.this.getRemoteAddOrder(displayKitchen).addOrderKitchen(ticketToSendToDisplay);
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
    }

    public void printCanceledOrder(final TicketInfo ti) {
        if (ti != null && ti.getLinesCount() > 0) {
            final PrinterHelper printer = new PrinterHelper();
            try {
                ti.setPayments(this.dlSales.findPaymetsByIdTicket(ti.getId()));
                if (ti.isPaid()) {
                    this.entetTicket = this.dlSales.getEnteteByTicket(ti.getId(), this.currentOrder.isPaid());
                }
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (!PopUpPrint.this.entetTicket.IsTicketRestituted()) {
                            if (AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL) {
                                try {
                                    PopUpPrint.this.mTicketService.printCloseReceiptGlobalTVA(ti);
                                }
                                catch (Exception ex) {
                                    LogToFile.log("severe", null, ex);
                                }
                            } else {
                                Decreaser decreaser = new Decreaser(PopUpPrint.this.dlSales, ti.getId(), "TICKET", null, ti.getNumero_order());
                                printer.printRappelTickets(ti.getNumero_order(), ti, PopUpPrint.this.entetTicket, 0L, decreaser);
                            }
                        } else if (ti.isPaid()) {
                            try {
                                PopUpPrint.this.mTicketService.printDuplicata(ti, printer, PopUpPrint.this.entetTicket, PopUpPrint.this.app.getAppUserView().getUser().getId(), null, null);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", null, ex);
                            }
                        }
                    }
                });
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        } else {
            new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, AppLocal.getIntString("Message.select.order"), 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    public void loadPopUpCouvert() {
        if (this.currentOrder != null && this.currentOrder.isPaid() && this.currentOrder.getTotalOrder() > 0.0) {
            try {
                boolean isExistJustificatifPayment = this.mTicketService.isExistJustificatifPayment(this.currentOrder);
                String title = isExistJustificatifPayment ? "Dupliquer Justificatif paiement" : "Justificatif paiement";
                double height = isExistJustificatifPayment ? 500.0 : 400.0;
                FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/popUp_couvert.fxml"));
                Parent rootNode = (Parent)loader.load();
                final PopUpCouvertController controller = (PopUpCouvertController)loader.getController();
                Scene scenePop = new Scene(rootNode, 400.0, height);
                scenePop.getStylesheets().add((Object)"/styles/styles.css");
                final Stage modalStage = new Stage();
                modalStage.setResizable(false);
                modalStage.setScene(scenePop);
                modalStage.setTitle(title);
                modalStage.initOwner(this.stage.getOwner());
                modalStage.initModality(Modality.APPLICATION_MODAL);
                modalStage.initStyle(StageStyle.UNDECORATED);
                modalStage.setAlwaysOnTop(true);
                controller.init(modalStage, (Object)isExistJustificatifPayment);
                modalStage.show();
                AppLocal.listPopUp.add(modalStage);
                modalStage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                    public void handle(WindowEvent event) {
                        AppLocal.listPopUp.remove(modalStage);
                        Object[] result = controller.getResult();
                        if (((Boolean)result[1]).booleanValue()) {
                            int couvert = (Integer)result[0];
                            String motifif_impression = (String)result[2];
                            PopUpPrint.this.printTicketSansDetail(couvert, motifif_impression);
                        }
                    }
                });
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void printTicketSansDetail(int couvert, String motif_impression) {
        try {
            TicketInfo ticketToPrint = (TicketInfo)this.currentOrder.clone();
            this.mTicketService.printTicketSansDetail(ticketToPrint, couvert, motif_impression);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void initializer(boolean reaload) {
        try {
            this.result = new Object[3];
            this.result[0] = null;
            this.result[1] = false;
            this.result[2] = false;
            if (!reaload) {
                this.stage.initStyle(StageStyle.UNDECORATED);
            }
            this.numberHours = Integer.parseInt(AppLocal.TICKET_CALLBACK_COUNT != null && !AppLocal.TICKET_CALLBACK_COUNT.isEmpty() ? AppLocal.TICKET_CALLBACK_COUNT : "0");
            this.editRaison = false;
            this.dlSales = (DataLogicSales)this.app.getBean("com.openbravo.dao.DataLogicSales");
            this.dlOrders = (DataLogicOrder)this.app.getBean("com.openbravo.dao.DataLogicOrder");
            this.dlUsers = (DataLogicAdmin)this.app.getBean("com.openbravo.pos.admin.DataLogicAdmin");
            this.avoirService = new AvoirService(this.dlOrders);
            Image imageNext = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1rightarrow.png"));
            this.btn_next_date.setGraphic((Node)new ImageView(imageNext));
            Image imagebPrevious = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1leftarrow.png"));
            this.btn_previous_date.setGraphic((Node)new ImageView(imagebPrevious));
            this.btn_next_date.setVisible(false);
            this.printers = new ArrayList<PrinterInfo>();
            this.productToSend = new ArrayList<TicketLineInfo>();
            this.productEMP = new ArrayList<TicketLineInfo>();
            this.productSpLater = new ArrayList<TicketLineInfo>();
            this.productEmpLater = new ArrayList<TicketLineInfo>();
            this.jdate.setText(AppLocal.getIntString("Label.today"));
            this.loadPaneFooter();
            this.switchToBtns();
            this.pane_main.getChildren().clear();
            this.tableView.setPrefHeight(heightPane * 0.65);
            this.pane_main.add((Node)this.tableView, 0, 0);
            this.currentOrder = null;
            this.entetTicket = null;
            this.tableView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                    int row;
                    if (PopUpPrint.this.tableView.getSelectionModel().getSelectedIndex() != -1 && (row = PopUpPrint.this.tableView.getSelectionModel().getSelectedIndex()) != -1) {
                        PopUpPrint.this.currentOrder = PopUpPrint.this.orders.get(row);
                        PopUpPrint.this.hideRaison();
                        PopUpPrint.this.switchToBtns();
                        if (!PopUpPrint.this.currentOrder.isPaid() && PopUpPrint.this.currentOrder.isPrint_after_update()) {
                            PopUpPrint.this.btn_caisse.setDisable(true);
                        } else {
                            PopUpPrint.this.btn_caisse.setDisable(false);
                        }
                        if (!PopUpPrint.this.currentOrder.isPaid()) {
                            PopUpPrint.this.btn_caisse.setText("Addition");
                        } else {
                            PopUpPrint.this.btn_caisse.setText("Ticket Caisse");
                        }
                        try {
                            Object lines;
                            PopUpPrint.this.entetTicket = PopUpPrint.this.dlSales.getEnteteByTicket(PopUpPrint.this.currentOrder.getId(), PopUpPrint.this.currentOrder.isPaid());
                            PopUpPrint.this.avoir = PopUpPrint.this.dlOrders.findTicketAvoirByTicket(PopUpPrint.this.currentOrder.getId());
                            PopUpPrint.this.currentOrder.setAddressInfo(PopUpPrint.this.mAddressService.findOne(PopUpPrint.this.currentOrder.getAddress()));
                            PopUpPrint.this.currentOrder.setCustomer(PopUpPrint.this.dlSales.loadCustomerExt(PopUpPrint.this.currentOrder.getCustomerId()));
                            if (PopUpPrint.this.currentOrder.getSent_from() != null && PopUpPrint.this.currentOrder.getSent_from().equalsIgnoreCase("Dishop")) {
                                lines = PopUpPrint.this.dlSales.loadLinesPlatform(PopUpPrint.this.currentOrder.getId());
                                PopUpPrint.this.currentOrder.setLines((List<TicketLineInfo>)lines);
                            } else {
                                lines = PopUpPrint.this.dlSales.loadLines(PopUpPrint.this.currentOrder.getId());
                                List<TicketLineInfo> linesExterne = PopUpPrint.this.dlSales.getTicketLineExterne(PopUpPrint.this.currentOrder.getId());
                                lines.addAll(linesExterne);
                                PopUpPrint.this.currentOrder.setLines((List<TicketLineInfo>)lines);
                            }
                            for (TicketLineInfo line : PopUpPrint.this.currentOrder.getLines()) {
                                List<SupplementItemInfo> ingrediens = PopUpPrint.this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
                                line.setListIngredientsIN(ingrediens);
                            }
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                }
            });
            Calendar calToday = Calendar.getInstance();
            this.date = DateUtils.getToday();
            this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
            this.table_order.setCellValueFactory((Callback)new PropertyValueFactory("tableOrder"));
            this.bipper_order.setCellValueFactory((Callback)new PropertyValueFactory("bipperOrder"));
            this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
            this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hourOrder"));
            this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("typeOrder"));
            this.etat_order.setCellValueFactory((Callback)new PropertyValueFactory("etatOrder"));
            this.total_order.setCellValueFactory((Callback)new PropertyValueFactory("totalOrder"));
            this.serveur_order.setCellValueFactory((Callback)new PropertyValueFactory("serveurOrder"));
            this.source_order.setCellValueFactory((Callback)new PropertyValueFactory("sourceOrder"));
            this.num_order.setSortable(false);
            this.table_order.setSortable(false);
            this.bipper_order.setSortable(false);
            this.date_order.setSortable(false);
            this.hour_order.setSortable(false);
            this.type_order.setSortable(false);
            this.etat_order.setSortable(false);
            this.total_order.setSortable(false);
            this.serveur_order.setSortable(false);
            this.source_order.setSortable(false);
            double widthTable = widthPane - 30.0;
            if (AppLocal.licence == "venteDetail") {
                this.tableView.getColumns().remove((Object)this.table_order);
                this.tableView.getColumns().remove((Object)this.type_order);
                this.tableView.getColumns().remove((Object)this.bipper_order);
                this.tableView.getColumns().remove((Object)this.source_order);
                this.num_order.setPrefWidth(widthTable * 0.15);
                this.date_order.setPrefWidth(widthTable * 0.15);
                this.hour_order.setPrefWidth(widthTable * 0.15);
                this.etat_order.setPrefWidth(widthTable * 0.15);
                this.total_order.setPrefWidth(widthTable * 0.2);
                this.serveur_order.setPrefWidth(widthTable * 0.15);
            } else {
                String type;
                double long_width = 0.12;
                double short_width = 0.08;
                double width_to_add = 0.0;
                boolean show_table = false;
                boolean show_bipper = false;
                if (!AppLocal.SHOW_PLAN_TABLE) {
                    this.tableView.getColumns().remove((Object)this.table_order);
                    width_to_add += short_width;
                } else {
                    show_table = true;
                }
                boolean bipMandatory = false;
                if (this.currentOrder != null && this.currentOrder.getType() != null && ((type = this.currentOrder.getType()).equalsIgnoreCase("Sur Place") && AppLocal.BIP_ONSITE || type.equalsIgnoreCase("A Emporter") && !this.currentOrder.isTake_away_phone() && AppLocal.BIP_TAKEAWAY || this.currentOrder.isTake_away_phone() && AppLocal.BIP_TAKEAWAY_PHONE)) {
                    bipMandatory = true;
                }
                if (!(AppLocal.BIPPER_CONNECTED && AppLocal.BIPPER_AUTO_PORT != null && !AppLocal.BIPPER_AUTO_PORT.isEmpty() || bipMandatory)) {
                    this.tableView.getColumns().remove((Object)this.bipper_order);
                    width_to_add += short_width;
                } else {
                    show_bipper = true;
                }
                long_width = NumericUtils.round(long_width + (width_to_add /= (double)this.tableView.getColumns().size()));
                short_width = NumericUtils.round(short_width + width_to_add);
                this.num_order.setPrefWidth(widthTable * long_width);
                this.date_order.setPrefWidth(widthTable * long_width);
                this.hour_order.setPrefWidth(widthTable * short_width);
                this.type_order.setPrefWidth(widthTable * short_width);
                this.etat_order.setPrefWidth(widthTable * short_width);
                this.total_order.setPrefWidth(widthTable * short_width);
                this.serveur_order.setPrefWidth(widthTable * long_width);
                this.source_order.setPrefWidth(widthTable * short_width);
                if (show_bipper) {
                    this.bipper_order.setPrefWidth(widthTable * short_width);
                }
                if (show_table) {
                    this.table_order.setPrefWidth(widthTable * short_width);
                }
            }
            if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
                calToday.setTime(this.date);
                calToday.add(6, -1);
                this.date = calToday.getTime();
            }
            this.mTicketService = TicketService.getInstance();
            this.setTime(this.date);
            try {
                this.loadOrder();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            if (AppLocal.KITCHEN_COMPOSITE) {
                this.orderService = OrderService.getInstance();
                this.mTicketSharedService = TicketSharedService.getInstance();
            }
            this.printerSummaryKitchen = this.dlSales.getPrinterSummaryKitchen();
            this.setTexts();
            Image imageKeyBoard = new Image(this.getClass().getResource("/com/openbravo/images/keyBoard.png").toURI().toString(), 40.0, 30.0, false, false);
            this.btn_keyboard.setGraphic((Node)new ImageView(imageKeyBoard));
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer(false);
    }

    @Override
    public void init(Stage mStage, Object app) {
        this.stage = mStage;
        this.app = (AppView)app;
        this.initializer(false);
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        if (objects != null) {
            for (Object object : objects) {
                if (!(object instanceof AppView)) continue;
                this.app = (AppView)object;
            }
        }
        this.initializer(false);
    }

    public void refundMoney(final TicketInfo ticketTracked, final Double total) {
        if (AppLocal.GLORY_ENABLED) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    String bgColor = "cyan";
                    String msg = "Voulez vous rembourser le client via \nle monnayeur ?";
                    ButtonType bGlory = new ButtonType("Monnayeur");
                    ButtonType bAvoir = new ButtonType("Avoir");
                    ButtonType bEspece = new ButtonType("Esp\u00e8ce");
                    Alert alert = new Alert(null, msg, new ButtonType[0]);
                    alert.getButtonTypes().add((Object)bEspece);
                    if (AppLocal.GLORY_ENABLED) {
                        alert.getButtonTypes().add((Object)bGlory);
                    }
                    if (AppLocal.print_avoir.booleanValue()) {
                        alert.getButtonTypes().add((Object)bAvoir);
                    }
                    DialogPane root = alert.getDialogPane();
                    root.getScene().setRoot((Parent)new Group());
                    root.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
                    root.setStyle("    -fx-background-color: " + bgColor + ";-fx-effect: dropshadow(gaussian, " + bgColor + ", 40, 0, 0, 0);-fx-background-insets: 5;-fx-font-size: 14px;-fx-text-fill: white !important;  -fx-font-family: \"AvenirNext-Bold\"; -fx-font-weight: bold;");
                    Stage dialogStage = new Stage(StageStyle.UNDECORATED);
                    root.getButtonTypes().forEach(buttonType -> {
                        ButtonBase button = (ButtonBase)root.lookupButton(buttonType);
                        button.setOnAction(evt -> {
                            root.setUserData(buttonType);
                            dialogStage.close();
                        });
                    });
                    Scene scene = new Scene((Parent)root);
                    dialogStage.setScene(scene);
                    dialogStage.initModality(Modality.APPLICATION_MODAL);
                    dialogStage.setAlwaysOnTop(true);
                    dialogStage.setResizable(false);
                    dialogStage.initStyle(StageStyle.UNDECORATED);
                    root.getScene().getRoot().setEffect((Effect)new DropShadow(10.0, 300.0, 300.0, Color.BLACK));
                    dialogStage.showAndWait();
                    Optional<ButtonType> result = Optional.ofNullable((ButtonType)root.getUserData());
                    if (result.get() == bGlory) {
                        PopUpPrint.this.ticketTrackedTempo = ticketTracked;
                        PopUpPrint.this.doPaymentOnCashGlory(total);
                    } else if (result.get() == bAvoir) {
                        try {
                            PopUpPrint.this.cancelTicket(ticketTracked, "Avoir");
                        }
                        catch (BasicException ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    } else {
                        try {
                            PopUpPrint.this.cancelTicket(ticketTracked, "Espece");
                        }
                        catch (BasicException ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                }
            });
        } else {
            try {
                this.cancelTicket(ticketTracked, "Espece");
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void doPaymentOnCashGlory(final double total) {
        if (FCCClient.getFccInstance().exclusiveMatrice("change") && FCCClient.getFccInstance().takeControl()) {
            this.btn_validate_cancel.setDisable(true);
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    FCCClient.getFccInstance().startChangeAsync(total, new PayementCompleteEvent());
                }
            });
        }
    }

    private void generateAvoir(final long changeAmount) {
        if (AppLocal.print_avoir.booleanValue()) {
            try {
                final EnteteInfo enteteTicket = this.dlSales.getLastEntete();
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        double total = (double)changeAmount / 100.0;
                        Decreaser decreaser = new Decreaser(PopUpPrint.this.dlSales, enteteTicket.getId(), "Ticket Avoir", null, 1);
                        TicketAvoir ticketAvoir = PopUpPrint.this.avoirService.addTicketAvoir(total, PopUpPrint.this.avoirService.getDateExpire(), "Cashglory", null);
                        BufferedImage qrCodeImage = QrCodeHelper.stringToImageQrCode(ticketAvoir.getBarCode());
                        new PrinterHelper().printAvoir(total, enteteTicket, ticketAvoir, qrCodeImage, decreaser);
                    }
                });
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void setGuidance(String msg) {
        new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, msg, 1500, NPosition.BOTTOM_RIGHT);
    }

    public void printRecap() {
        if (this.currentOrder != null && !this.currentOrder.getStatus().equalsIgnoreCase("cancel") && !this.currentOrder.getStatus().equalsIgnoreCase("Refund")) {
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (AppLocal.PRINT_RECAP || AppLocal.PRINT_RECAP_DELIVERY) {
                        PrinterHelper printer = new PrinterHelper();
                        Decreaser decreaserKitchen = new Decreaser(PopUpPrint.this.dlSales, PopUpPrint.this.currentOrder.getId(), "Ticket cuisine", null, PopUpPrint.this.currentOrder.getNumero_order());
                        boolean recap_delivery = AppLocal.PRINT_RECAP_DELIVERY && PopUpPrint.this.currentOrder.getType() != null && PopUpPrint.this.currentOrder.getType().equalsIgnoreCase("En Livraison");
                        PopUpPrint.this.mTicketService.printRecap(PopUpPrint.this.currentOrder, decreaserKitchen, false, recap_delivery, false, null);
                    }
                }
            });
        }
    }

    private void setTexts() {
        this.table_order.setText(AppLocal.getIntString("Label.num.table"));
        this.bipper_order.setText(AppLocal.getIntString("Label.bipper"));
        this.date_order.setText(AppLocal.getIntString("Label.date"));
        this.hour_order.setText(AppLocal.getIntString("Label.heure"));
        this.type_order.setText(AppLocal.getIntString("Label.type"));
        this.etat_order.setText(AppLocal.getIntString("Label.state"));
        this.total_order.setText(AppLocal.getIntString("Label.total"));
        this.serveur_order.setText(AppLocal.getIntString("Label.cashier"));
        this.reason_cancel.setText(AppLocal.getIntString("Label.reason.cancel"));
        this.btn_dk.setText(AppLocal.getIntString("Button.screen.kitchen"));
        this.btn_kitchen.setText(AppLocal.getIntString("Button.ticket.kitchen"));
        this.btn_label.setText(AppLocal.getIntString("Button.label"));
        this.btn_caisse.setText(AppLocal.getIntString("Button.ticket.caisse"));
        this.btn_avoir.setText(AppLocal.getIntString("Button.ticket.free"));
        this.btn_cancel.setText(AppLocal.getIntString("Button.cancel.order"));
        this.btn_duplicate.setText(AppLocal.getIntString("Button.duplicate.order"));
        this.btn_justificatif.setText(AppLocal.getIntString("Button.proof.payment"));
        this.btn_recap.setText(AppLocal.getIntString("Button.recap"));
        this.btn_validate_cancel.setText(AppLocal.getIntString("Button.confirm.cancel"));
    }

    public void loadPopUpMotifImpression() {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/popUp_motif_impression.fxml"));
            Parent rootNode = (Parent)loader.load();
            final PopUpMotifImpressionController controller = (PopUpMotifImpressionController)loader.getController();
            Scene scenePop = new Scene(rootNode, 400.0, 250.0);
            scenePop.getStylesheets().add((Object)"/styles/styles.css");
            final Stage modalStage = new Stage();
            modalStage.setResizable(false);
            modalStage.setScene(scenePop);
            modalStage.setTitle("Duplicata");
            modalStage.initOwner(this.stage.getOwner());
            modalStage.initModality(Modality.APPLICATION_MODAL);
            modalStage.initStyle(StageStyle.UNDECORATED);
            modalStage.setAlwaysOnTop(true);
            controller.init(modalStage);
            modalStage.show();
            AppLocal.listPopUp.add(modalStage);
            modalStage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    AppLocal.listPopUp.remove(modalStage);
                    Object[] result = controller.getResult();
                    if (((Boolean)result[0]).booleanValue()) {
                        String motifif_impression = (String)result[1];
                        PopUpPrint.this.mTicketService.printPaidTicketCaisse(PopUpPrint.this.currentOrder, PopUpPrint.this.entetTicket, motifif_impression);
                    }
                }
            });
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadKeyBoard() {
        try {
            if (!this.keyBoardLoaded) {
                this.keyBoardLoaded = true;
                if (this.popupKeyBoard == null) {
                    KeyboardPane kb = new KeyboardPane();
                    kb.setLayer(DefaultLayer.NUMBLOCK);
                    kb.addRobotHandler((IRobot)new NativeAsciiRobotHandler());
                    kb.setOnKeyboardCloseButton(e -> {
                        this.popupKeyBoard.setVisible(false);
                        this.keyBoardLoaded = false;
                    });
                    kb.setLocale(Locale.forLanguageTag("en"));
                    kb.load();
                    this.popupKeyBoard = new KeyBoardPopup(kb);
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    double width = screenSize.getWidth();
                    double height = screenSize.getHeight();
                    this.popupKeyBoard.setX(width / 4.0);
                    this.popupKeyBoard.setY(height / 4.0 * 3.0);
                    this.popupKeyBoard.setHeight(height / 4.0);
                    this.popupKeyBoard.registerScene(this.stage.getScene());
                }
                this.popupKeyBoard.setVisible(true);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void duplicataTicket() {
        System.out.println("currentOrder payments : " + this.currentOrder.getPayments());
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(() -> {
            if (this.mEVService == null) {
                this.mEVService = new MEVService();
            }
            this.mEVService.duplicataTicket(this.currentOrder);
        });
    }

    public void reprintTicket() {
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(() -> {
            if (this.mEVService == null) {
                this.mEVService = new MEVService();
            }
            this.mEVService.reprintTicket(this.currentOrder);
        });
    }

    public void loadingCmi(String Message2) {
        System.out.println("*-------------------loadingCmi-------------------*");
        try {
            this.parent_print_pane.getChildren().clear();
            this.parent_print_pane.setAlignment(Pos.CENTER);
            Label messageLabel = new Label("Veuillez patienter, votre " + Message2 + " est en cours de traitement...");
            messageLabel.setAlignment(Pos.CENTER);
            messageLabel.setStyle("-fx-font-size: 18px; -fx-text-fill: black;");
            messageLabel.setPrefWidth(this.parent_print_pane.getPrefWidth());
            messageLabel.setPrefHeight(100.0);
            Label loadingGif = new Label();
            loadingGif.setPrefWidth(this.parent_print_pane.getPrefWidth());
            loadingGif.setPrefHeight(this.parent_print_pane.getPrefHeight() - 140.0);
            loadingGif.setAlignment(Pos.CENTER);
            Image gifImage = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/loading.gif"));
            ImageView imageLoading = new ImageView(gifImage);
            GridPane.setHalignment((Node)loadingGif, (HPos)HPos.CENTER);
            GridPane.setValignment((Node)loadingGif, (VPos)VPos.CENTER);
            imageLoading.setFitHeight(150.0);
            imageLoading.setFitWidth(150.0);
            loadingGif.setGraphic((Node)imageLoading);
            this.parent_print_pane.add((Node)messageLabel, 0, 0);
            this.parent_print_pane.add((Node)loadingGif, 0, 1);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void createPrintPane() {
        this.parent_print_pane.getChildren().clear();
        this.parent_print_pane.add((Node)this.close_pane, 0, 0);
        this.parent_print_pane.add((Node)this.top_print_pane, 0, 1);
        this.parent_print_pane.add((Node)this.pane_main, 0, 2);
        this.parent_print_pane.add((Node)this.footer_print_pane, 0, 3);
        this.initializer(true);
    }

    public boolean hasCbPayment(TicketInfo currentOrder) {
        boolean hasCBPayment = true;
        for (PaymentInfo payment : currentOrder.getPayments()) {
            if (payment.getName().equalsIgnoreCase("CB")) continue;
            hasCBPayment = false;
            break;
        }
        return hasCBPayment;
    }

    public void printCmiDuplicata(final TicketInfo ticket) {
        final boolean forPayment = !ticket.getStatus().equals("cancel");
        final String OPERATION_TRANSACTION_STATUS = "TransactStatus";
        this.loadingCmi("Impression Ticket Duplicata ");
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Object[] results_cmi = null;
                PopUpPrint.this.mTPECmi = TPECmi.getInstance();
                System.out.println("*********Duplicata forPayment :" + forPayment);
                results_cmi = PopUpPrint.this.mTPECmi.doCmiTransactStatus(OPERATION_TRANSACTION_STATUS, forPayment, ticket.getTag_erc_stan(), ticket.getEft_stan(), ticket.getEcrDateTime());
                if (results_cmi != null && results_cmi.length == 7) {
                    boolean success = (Boolean)results_cmi[0];
                    String message = String.valueOf(results_cmi[1]);
                    String ticket_cmi = String.valueOf(results_cmi[2]);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PopUpPrint.this.createPrintPane();
                        }
                    });
                    if (success) {
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, message, 1500, NPosition.BOTTOM_RIGHT);
                        if (ticket_cmi != null && !ticket_cmi.isEmpty()) {
                            PrinterHelper printer = new PrinterHelper();
                            PopUpPrint.this.mTicketService.printCmiTicketPayment(printer, ticket_cmi, true);
                        }
                    } else {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, message, 1500, NPosition.BOTTOM_RIGHT);
                    }
                }
            }
        });
    }

    class PayementCompleteEvent
    extends BrueBoxServiceCallbackHandler {
        PayementCompleteEvent() {
        }

        protected String getDetailDenom(BrueBoxServiceStub.DenominationType[] dnm, int[] amount, String manual) {
            Object retStr = "";
            if (dnm != null || Integer.parseInt(manual) > 0) {
                if (dnm != null) {
                    for (BrueBoxServiceStub.DenominationType dnm1 : dnm) {
                        amount[0] = amount[0] + dnm1.getFv().intValue() * dnm1.getPiece().intValue();
                        retStr = (String)retStr + "\n  " + IUserInterface.decimalFormat.format((double)dnm1.getFv().intValue() / 100.0) + "\u20ac " + dnm1.getPiece().intValue() + " Pi\u00e8ces, ";
                    }
                }
                if (Integer.parseInt(manual) > 0) {
                    amount[0] = amount[0] + Integer.parseInt(manual);
                    retStr = (String)retStr + "\n  Manual Input " + IUserInterface.decimalFormat.format(Double.parseDouble(manual) / 100.0) + "\u20ac, ";
                }
            } else {
                retStr = "0 \u20ac";
            }
            return retStr;
        }

        @Override
        public void receiveResultchangeOperation(final BrueBoxServiceStub.ChangeResponse result) {
            if (FCCClient.getFccInstance().isMyTransaction(result.getChangeResponse().getId())) {
                if (result.getChangeResponse().getResult().intValue() == 0) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                double inDepot = (double)Integer.parseInt(result.getChangeResponse().getAmount()) / 100.0;
                                this.refundSucceded(inDepot);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                            PopUpPrint.this.setGuidance("Fin d'encaissement en CashGlory");
                        }

                        private void refundSucceded(double inDepot) {
                            if (inDepot < 0.0) {
                                String msg = "Le monnayeur a rembours\u00e9 au client : " + Formats.CURRENCY.formatValue(inDepot);
                                TransactionMoneyService.getInstance(PopUpPrint.this.app).saveRefundGloryTransaction(inDepot, msg);
                                try {
                                    PopUpPrint.this.cancelTicket(PopUpPrint.this.ticketTrackedTempo, "cashGlory");
                                }
                                catch (BasicException ex) {
                                    LogToFile.log("severe", ex.getMessage(), ex);
                                }
                                FCCClient.getFccInstance().releaseControl();
                                GloryController.showMessageDialogue(Alert.AlertType.WARNING, msg);
                            }
                        }
                    });
                } else if (result.getChangeResponse().getResult().intValue() == 10 || result.getChangeResponse().getResult().intValue() == 99 || result.getChangeResponse().getResult().intValue() == 100) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            int[] insertedAmount = new int[1];
                            int[] dispensedAmount = new int[1];
                            String insertedDenom = PayementCompleteEvent.this.getDetailDenom(result.getChangeResponse().getCash()[0].getDenomination(), insertedAmount, result.getChangeResponse().getManualDeposit());
                            String dispensedDenom = PayementCompleteEvent.this.getDetailDenom(result.getChangeResponse().getCash()[1].getDenomination(), dispensedAmount, "0");
                            long changeAmount = insertedAmount[0] - Integer.parseInt(result.getChangeResponse().getAmount()) - dispensedAmount[0];
                            System.out.println("changeAmount: " + changeAmount);
                            changeAmount = Math.abs(changeAmount);
                            if (changeAmount > 0L) {
                                try {
                                    PopUpPrint.this.setGuidance("Echec de rendre la monnai. Op\u00e9ration annul\u00e9e");
                                    FCCClient.getFccInstance().releaseControl();
                                    TransactionMoneyService.getInstance(PopUpPrint.this.app).saveRefundGloryTransaction((double)insertedAmount[0] / 100.0, "Remboursement \u00e9chou\u00e9. g\u00e9n\u00e9ration d'un avoir de  " + Formats.CURRENCY.formatValue((double)changeAmount / 100.0));
                                    PopUpPrint.this.generateAvoir(changeAmount);
                                    PopUpPrint.this.cancelTicket(PopUpPrint.this.ticketTrackedTempo, "Avoir");
                                    GloryController.showMessageDialogue(Alert.AlertType.ERROR, "Le Monnayeur n'a pas pu payer les monnaies en raison d'un stock insuffisant.\nL'avoir \u00e0 d\u00e9caisser est : " + (double)changeAmount / 100.0 + "\u20ac\nLa monnaie est : " + dispensedDenom + "\nL'op\u00e9ration a \u00e9t\u00e9 annul\u00e9e.");
                                }
                                catch (BasicException ex) {
                                    LogToFile.log("severe", ex.getMessage(), ex);
                                }
                            }
                        }
                    });
                } else if (result.getChangeResponse().getResult().intValue() == 11) {
                    try {
                        Thread.sleep(2000L);
                        double inDepot = (double)Integer.parseInt(result.getChangeResponse().getAmount()) / 100.0;
                        PopUpPrint.this.doPaymentOnCashGlory(Math.abs(inDepot));
                    }
                    catch (InterruptedException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                } else {
                    final double inDepot = (double)Integer.parseInt(result.getChangeResponse().getAmount()) / 100.0;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                FCCClient.getFccInstance().releaseControl();
                                TransactionMoneyService.getInstance(PopUpPrint.this.app).saveRefundGloryTransaction(inDepot, "Remboursement \u00e9chou\u00e9. g\u00e9n\u00e9ration d'un avoir de  " + Formats.CURRENCY.formatValue(inDepot));
                                GloryController.showMessageDialogue(Alert.AlertType.ERROR, "Le Monnayeur n'a pas pu payer la monnaie en raison d'un stock insuffisant.\nL'avoir \u00e0 d\u00e9caisser est :" + inDepot + "\u20ac\nL'op\u00e9ration a \u00e9t\u00e9 annul\u00e9e.");
                                PopUpPrint.this.generateAvoir((long)(inDepot * 100.0));
                                PopUpPrint.this.cancelTicket(PopUpPrint.this.ticketTrackedTempo, "Avoir");
                            }
                            catch (BasicException ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                    });
                }
                FCCClient.getFccInstance().setCancelled(false);
                System.out.println("End");
            } else if (result.getChangeResponse().getResult().intValue() == 11) {
                try {
                    PopUpPrint.this.generateAvoir((long)(PopUpPrint.this.ticketTrackedTempo.getTotalOrder() * 100.0));
                    PopUpPrint.this.cancelTicket(PopUpPrint.this.ticketTrackedTempo, "Avoir");
                    PopUpPrint.this.setGuidance("Erreur exclusive, R\u00e9initialiser Le Monnayeur");
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            PopUpPrint.this.btn_validate_cancel.setDisable(true);
        }
    }
}

