/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.CommentsProductPopUp;
import com.openbravo.components.DiscountsProductPopUp;
import com.openbravo.components.ErrorItemsPopUp;
import com.openbravo.components.ErrorLimitationPopUp;
import com.openbravo.components.HeaderDetailProductButton;
import com.openbravo.components.IngredientDetailProductButton;
import com.openbravo.components.NextPreviousButton;
import com.openbravo.components.OptionDetailProductButton;
import com.openbravo.components.OptionDetailProductTab;
import com.openbravo.components.ProductFamilleButton;
import com.openbravo.components.ProductStockPane;
import com.openbravo.components.RecapOrderPopUp;
import com.openbravo.components.RemoveAllIngredientsButton;
import com.openbravo.components.SubSupplementsPopUp;
import com.openbravo.components.TypeOrderPopUp;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.DetailProductError;
import com.openbravo.pos.ticket.DetailProductResult;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.SubSupplementResult;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ImagesUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import fr.protactile.procaisse.dao.entities.ReductionInfo;
import fr.protactile.procaisse.services.ReductionService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.comtel2000.keyboard.control.DefaultLayer;
import org.comtel2000.keyboard.control.KeyBoardPopup;
import org.comtel2000.keyboard.control.KeyboardPane;
import org.comtel2000.keyboard.robot.IRobot;
import org.comtel2000.swing.robot.NativeAsciiRobotHandler;

public class PopUpOptionNewController
implements RootController {
    @FXML
    Button close_button;
    @FXML
    Button previous_detail_header;
    @FXML
    Button next_detail_header;
    @FXML
    Label image_product_label;
    @FXML
    Label name_product_label;
    @FXML
    Label recap_icon;
    @FXML
    Button type_order_button;
    @FXML
    Button comment_button;
    @FXML
    Button make_items_free_button;
    @FXML
    Button discount_button;
    @FXML
    Button decrease_quantity_button;
    @FXML
    Button increase_quantity_button;
    @FXML
    Label recap_label;
    @FXML
    Label add_label;
    @FXML
    Label price_label;
    @FXML
    Label quantity_label;
    @FXML
    GridPane header_detail_product_pages;
    @FXML
    GridPane header_detail_product_pane;
    @FXML
    GridPane optionTabsPages;
    @FXML
    GridPane nextPreviousOptionsTabs;
    @FXML
    GridPane header_pane;
    @FXML
    GridPane detail_pane;
    @FXML
    GridPane optionsPane;
    @FXML
    GridPane main_pane;
    @FXML
    GridPane productsFamillePane;
    @FXML
    GridPane footer_pane;
    @FXML
    GridPane infos_product_pane;
    @FXML
    GridPane return_to_pane;
    @FXML
    Button previousOptionTab;
    @FXML
    Button nextOptionTab;
    @FXML
    Button valid_product_button;
    @FXML
    Button setting_button;
    @FXML
    Button return_to_button;
    private DetailProductResult detailProductResult;
    private List<OptionItemOrder> listChoiceSupplement;
    private List<ItemOrderInfo> listChoiceIngredient;
    private List<ProductTicket> listProducts;
    private AppView m_App;
    private DataLogicSales dlSales;
    private DataLogicItems dlItems;
    private double multiply;
    private Stage stage;
    private List<SupplementProduct> options;
    private List<SupplementProduct> optionsDB;
    private String unit;
    private List<CarteOrderInfo> groupProductsDB;
    private List<CarteOrderInfo> groupProducts;
    private double priceSell;
    private double discountValue;
    private String labelDiscount;
    private String noteValue;
    private String name_sizeProduct;
    private List<TicketLineInfo> listLinesTmp;
    private TicketLineInfo lineTmp;
    private int indexLine;
    private String type_line;
    private String time_served;
    private String type_order;
    private String typeDiscount;
    private KeyBoardPopup popupKeyBoard;
    private boolean keyBoardLoaded;
    private ProductInfoExt product;
    private List<SupplementItemInfo> ingredients;
    private List<ProductInfoExt> subProducts;
    private ImagesUtils mImagesUtils;
    private final String SIZE_IMAGE_64 = "_64px";
    private final String SIZE_IMAGE_128 = "_128px";
    private String typeDisplay;
    private double discountOrder;
    private String typeDiscountOrder;
    private boolean update_product;
    private double old_multiply;
    private List<HeaderDetailProductButton> groupTabs;
    public static final String STR_INGREDIENTS = "ingredients";
    public static final String STR_SUB_PRODUCT = "sub_product";
    public static final String STR_GROUP_PRODUCTS = "group_products";
    public static final String STR_OPTIONS = "options";
    public static final String STR_ITEM_INGREDIENT = "item_ingredient";
    private GridPane[] headerDetailProductArray;
    private int numberPageDetailProductHeader;
    private int NUMBER_DETAIL_PRODUCT_TAB = 4;
    private int page_detail_product_header;
    @FXML
    GridPane ingredientsPane;
    private int numberPageIngredients;
    private int NUMBER_COLUMN_INGREDIENT = 4;
    private int NUMBER_ROW_INGREDIENT = 5;
    private int MAX_INGREDIENTS_PER_PAGE = 19;
    private int MAX_INGREDIENTS;
    private int page_ingredients;
    private HashMap<Integer, List<IngredientDetailProductButton>> map_ingredients;
    private NextPreviousButton nextItemIngredientButton;
    private NextPreviousButton previousItemIngredientButton;
    private Image imagePreviousItemProduct;
    private Image imageNextItemProduct;
    private Image imageRemovedIngredient;
    private RemoveAllIngredientsButton removeAllIngredientsButton;
    @FXML
    GridPane groupOptionsPane;
    private GridPane[] optionTabsArray;
    private int numberPageOptionsTabs;
    private int NUMBER_COLUMN_OPTIONS_TABS = 7;
    private int NUMBER_ROW_OPTIONS_TABS = 1;
    private int MAX_OPTIONS_TABS_PER_PAGE = 7;
    private int MAX_OPTIONS_TABS;
    private int page_options_tabs;
    private HashMap<Integer, LinkedHashMap<Integer, OptionDetailProductButton>> map_options;
    private int NUMBER_COLUMN_OPTION = 4;
    private int NUMBER_ROW_OPTION = 4;
    private int page_options;
    private int MAX_OPTIONS_PER_PAGE = 16;
    private int MAX_OPTIONS;
    private int numberPageOptions;
    private Button nextItemOptionButton;
    private Button previousItemOptionButton;
    private List<OptionDetailProductTab> groupOptionTabs;
    private Image imageDefaultItemOption;
    private Image imageDecrease;
    private Image imageIncrease;
    private boolean makeItemFree;
    private LinkedHashMap<Integer, OptionDetailProductButton> itemOptionsButton;
    private boolean next_option;
    private String BUTTON_OPTION = "button_option";
    private String EVENT_INCREASE_QTT_OPTION = "increase qtt option";
    private String EVENT_DECREASE_QTT_OPTION = "decrease qqt option";
    private String EVENT_ADD_OPTION = "add option";
    private ErrorLimitationPopUp errorLimitationPopUp;
    private TypeOrderPopUp typeOrderPopUp;
    private Image imageDineInLine;
    private Image imageTakeAwayLine;
    private String styleDineIn = "-fx-background-color: #C77F24; -fx-background-radius: 0px 0px 11px 11px; -fx-text-fill: white;";
    private String styleTakeAway = "-fx-background-color: #00AFD5; -fx-background-radius: 0px 0px 11px 11px; -fx-text-fill: white;";
    private int NUMBER_COLUMN_PRODUCT_FAMILLE = 4;
    private int NUMBER_ROW_PRODUCT_FAMILLE = 3;
    private int MAX_PRODUCT_FAMILLE_PER_PAGE = 12;
    private int MAX_PRODUCT_FAMILLE;
    private HashMap<Integer, LinkedHashMap<Integer, ProductFamilleButton>> map_products_famille;
    private LinkedHashMap<Integer, ProductFamilleButton> productsFamilleButtons;
    private int numberPageProductsFamille;
    private Button nextProductFamilleButton;
    private Button previousProductFamilleButton;
    private int page_products_famille;
    private String styleProductFamille = "-fx-border-color: #FFFFFF1E; -fx-border-radius: 16px; -fx-background-color: #FFFFFF14;  -fx-background-radius: 16px;";
    private ProductTicket currentProductTicket;
    private double heightIngredientsPane;
    private double heightOptionsPane;
    private RecapOrderPopUp recapOrderPopUp;
    private ItemService mItemService;
    private List<ReductionInfo> reductions;
    private ReductionService mReductionService;
    private DiscountsProductPopUp discountsProductPopUp;
    private CommentsProductPopUp commentsProductPopUp;
    private SubSupplementsPopUp subSupplementsPopUp;
    private double priceProduct;
    private ErrorItemsPopUp errorItemsPopUp;
    public boolean productValid;
    private Image imageRecapTriangle;
    private Image imageRecapTriangleInverse;
    private String styleMakeFreeItem = "-fx-font-size: 12px;-fx-text-fill: white;-fx-background-radius: 0px 0px 11px 11px;-fx-background-color:  linear-gradient(to bottom, rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), linear-gradient(to bottom, rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), rgba(149, 111, 248, 0.50);";
    private String styleMakeFreeItemSelected = "-fx-font-size: 12px;-fx-text-fill: white;-fx-background-radius: 0px 0px 11px 11px;-fx-background-color: #0B8871;";
    private ProductStockPane productStockPane;
    private boolean inDriveMode = false;
    private boolean has_stock_management_permission;
    private EventHandler mEventHandlerIngredientsAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                HeaderDetailProductButton mButtonSource = (HeaderDetailProductButton)((Object)event.getSource());
                if (mButtonSource != null) {
                    PopUpOptionNewController.this.deselectHeaderTabs();
                    PopUpOptionNewController.this.selectHeaderTab(mButtonSource);
                    PopUpOptionNewController.this.loadIngredients();
                    if (PopUpOptionNewController.this.inDriveMode) {
                        AppLocal.displayDualScreen.propagateClick("handlerIngredientsAction", null);
                    }
                }
            }
        }
    };
    private EventHandler mEventHandlerOptionsAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                HeaderDetailProductButton mButtonSource = (HeaderDetailProductButton)((Object)event.getSource());
                if (mButtonSource != null) {
                    PopUpOptionNewController.this.deselectHeaderTabs();
                    PopUpOptionNewController.this.selectHeaderTab(mButtonSource);
                    PopUpOptionNewController.this.loadOptionsTabs_Product();
                    if (PopUpOptionNewController.this.inDriveMode) {
                        AppLocal.displayDualScreen.propagateClick("handlerOptionsAction", null);
                    }
                }
            }
        }
    };
    private EventHandler mEventHandlerGroupsProductsAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                HeaderDetailProductButton mButtonSource = (HeaderDetailProductButton)((Object)event.getSource());
                if (mButtonSource != null) {
                    PopUpOptionNewController.this.deselectHeaderTabs();
                    PopUpOptionNewController.this.selectHeaderTab(mButtonSource);
                    if (mButtonSource.getGroupItem() != null && mButtonSource.getGroupItem() instanceof CarteOrderInfo) {
                        CarteOrderInfo groupProducts = (CarteOrderInfo)mButtonSource.getGroupItem();
                        PopUpOptionNewController.this.loadProductsFamille(groupProducts);
                        if (PopUpOptionNewController.this.inDriveMode) {
                            AppLocal.displayDualScreen.propagateClick("handlerGroupProductsAction", new Object[]{groupProducts.clone(), mButtonSource.getIndex()});
                        }
                    }
                }
            }
        }
    };
    private EventHandler mEventHandlerSubProductAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                HeaderDetailProductButton mButtonSource = (HeaderDetailProductButton)((Object)event.getSource());
                if (mButtonSource != null) {
                    PopUpOptionNewController.this.deselectHeaderTabs();
                    PopUpOptionNewController.this.selectHeaderTab(mButtonSource);
                    if (mButtonSource.getGroupItem() != null && mButtonSource.getGroupItem() instanceof ProductInfoExt) {
                        ProductInfoExt subProduct = (ProductInfoExt)mButtonSource.getGroupItem();
                        PopUpOptionNewController.this.loadDetailSubProduct(subProduct);
                        if (PopUpOptionNewController.this.inDriveMode) {
                            AppLocal.displayDualScreen.propagateClick("handlerSubProductsAction", new Object[]{subProduct.clone(), mButtonSource.getIndex()});
                        }
                    }
                }
            }
        }
    };
    private EventHandler mEventHandlerNextIngredientAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                NextPreviousButton buttonSource = (NextPreviousButton)((Object)event.getSource());
                PopUpOptionNewController.this.nextIngredient(buttonSource);
                if (PopUpOptionNewController.this.inDriveMode) {
                    AppLocal.displayDualScreen.propagateClick("prevNextIngredientAction", new Object[]{true});
                }
            }
        }
    };
    private EventHandler mEventHandlerPreviousIngredientAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                NextPreviousButton buttonSource = (NextPreviousButton)((Object)event.getSource());
                PopUpOptionNewController.this.previousIngredient(buttonSource);
                if (PopUpOptionNewController.this.inDriveMode) {
                    AppLocal.displayDualScreen.propagateClick("prevNextIngredientAction", new Object[]{false});
                }
            }
        }
    };
    private EventHandler mEventHandlerIngredientAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                IngredientDetailProductButton buttonIngredient = (IngredientDetailProductButton)((Object)event.getSource());
                if (buttonIngredient != null) {
                    PopUpOptionNewController.this.changeIngredient(buttonIngredient);
                }
            }
        }
    };
    private EventHandler mEventHandlerremoveAllIngredientAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            RemoveAllIngredientsButton buttonAllIngredients = (RemoveAllIngredientsButton)((Object)event.getSource());
            PopUpOptionNewController.this.removeAllIngredients(buttonAllIngredients);
        }
    };
    private EventHandler mEventHandlerNextOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            PopUpOptionNewController.this.nextOptions();
            if (PopUpOptionNewController.this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("nextOptions", null);
            }
        }
    };
    private EventHandler mEventHandlerPreviousOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            PopUpOptionNewController.this.previousOptions();
            if (PopUpOptionNewController.this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("previousOptions", null);
            }
        }
    };
    private EventHandler mEventHandlerOptionTabAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                OptionDetailProductTab buttonGroupOption = (OptionDetailProductTab)((Object)event.getSource());
                if (buttonGroupOption != null) {
                    PopUpOptionNewController.this.deselectOptionTabs();
                    PopUpOptionNewController.this.selectOptionTab(buttonGroupOption);
                    if (buttonGroupOption.getGroupOption().getIs_ingredient().booleanValue()) {
                        PopUpOptionNewController.this.loadIngredients_SubProduct(buttonGroupOption.getGroupProducts(), buttonGroupOption.getProduct(), buttonGroupOption.getGroupOption());
                    } else {
                        PopUpOptionNewController.this.loadOptions(buttonGroupOption);
                    }
                    if (PopUpOptionNewController.this.inDriveMode) {
                        AppLocal.displayDualScreen.propagateClick("handleOptionTabAction", new Object[]{buttonGroupOption});
                    }
                }
            }
        }
    };
    private EventHandler mEventHandlerOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                OptionDetailProductButton buttonOption = (OptionDetailProductButton)((Object)event.getSource());
                if (buttonOption != null) {
                    if (buttonOption.getEventName() == null || !buttonOption.getEventName().equalsIgnoreCase(PopUpOptionNewController.this.EVENT_INCREASE_QTT_OPTION) && !buttonOption.getEventName().equalsIgnoreCase(PopUpOptionNewController.this.EVENT_DECREASE_QTT_OPTION)) {
                        PopUpOptionNewController.this.selectOption(buttonOption);
                    }
                    buttonOption.setEventName(PopUpOptionNewController.this.EVENT_ADD_OPTION);
                }
            }
        }
    };
    private EventHandler mEventHandlerIncreaseQttOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                Button buttonSource = (Button)event.getSource();
                if (buttonSource != null && buttonSource.getProperties().get((Object)PopUpOptionNewController.this.BUTTON_OPTION) != null) {
                    OptionDetailProductButton buttonOption = (OptionDetailProductButton)((Object)buttonSource.getProperties().get((Object)PopUpOptionNewController.this.BUTTON_OPTION));
                    buttonOption.setEventName(PopUpOptionNewController.this.EVENT_INCREASE_QTT_OPTION);
                    if (buttonOption != null) {
                        PopUpOptionNewController.this.increaseQttOption(buttonOption);
                        if (PopUpOptionNewController.this.inDriveMode) {
                            AppLocal.displayDualScreen.propagateClick("handleOptionAction", new Object[]{buttonOption.getOption().getiD(), true});
                        }
                    }
                }
            }
        }
    };
    private EventHandler mEventHandlerDecreaseQttOptionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                Button buttonSource = (Button)event.getSource();
                if (buttonSource != null && buttonSource.getProperties().get((Object)PopUpOptionNewController.this.BUTTON_OPTION) != null) {
                    OptionDetailProductButton buttonOption = (OptionDetailProductButton)((Object)buttonSource.getProperties().get((Object)PopUpOptionNewController.this.BUTTON_OPTION));
                    buttonOption.setEventName(PopUpOptionNewController.this.EVENT_DECREASE_QTT_OPTION);
                    if (buttonOption != null) {
                        PopUpOptionNewController.this.decreaseQttOption(buttonOption);
                        if (PopUpOptionNewController.this.inDriveMode) {
                            AppLocal.displayDualScreen.propagateClick("handleOptionAction", new Object[]{buttonOption.getOption().getiD(), false});
                        }
                    }
                }
            }
        }
    };
    private EventHandler mEventHandlerPopUpTypeorderHide = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent event) {
            if (PopUpOptionNewController.this.typeOrderPopUp != null) {
                PopUpOptionNewController.this.main_pane.setEffect(null);
                PopUpOptionNewController.this.type_line = PopUpOptionNewController.this.typeOrderPopUp.getTypeOrder();
                PopUpOptionNewController.this.setTypeLine();
                PopUpOptionNewController.this.priceProduct = PopUpOptionNewController.this.getPriceProduct();
                System.out.println("priceProduct : " + PopUpOptionNewController.this.priceProduct);
                PopUpOptionNewController.this.setPriceTotal();
            }
        }
    };
    private EventHandler mEventHandlerProductFamilleMouseClick = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                ProductFamilleButton buttonProdutFamille = (ProductFamilleButton)((Object)event.getSource());
                if (buttonProdutFamille != null) {
                    if (event.getClickCount() == 1) {
                        PopUpOptionNewController.this.selectProductFamille(buttonProdutFamille);
                    }
                    if (event.getClickCount() == 2) {
                        PopUpOptionNewController.this.checkAndDeleteProductFamille(buttonProdutFamille);
                    }
                    if (PopUpOptionNewController.this.inDriveMode) {
                        AppLocal.displayDualScreen.propagateClick("handleProductFamilyClick", new Object[]{event.getClickCount(), buttonProdutFamille.getGroupProduct().clone(), buttonProdutFamille.getProduct().clone()});
                    }
                }
            }
        }
    };
    private EventHandler mEventHandlerNextProductFamilleAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                if (PopUpOptionNewController.this.inDriveMode) {
                    AppLocal.displayDualScreen.propagateClick("nextProductsFamily", null);
                }
                PopUpOptionNewController.this.nextProductsFamille();
            }
        }
    };
    private EventHandler mEventHandlerPreviousProductFamilleAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (PopUpOptionNewController.this.checkPopUp()) {
                PopUpOptionNewController.this.hidePopUps();
            } else {
                if (PopUpOptionNewController.this.inDriveMode) {
                    AppLocal.displayDualScreen.propagateClick("previousProductsFamily", null);
                }
                PopUpOptionNewController.this.previousProductsFamille();
            }
        }
    };
    private EventHandler mEventHandlerPopUpRecaporderHide = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent event) {
            PopUpOptionNewController.this.header_pane.setEffect(null);
            PopUpOptionNewController.this.detail_pane.setEffect(null);
            PopUpOptionNewController.this.recap_icon.setGraphic((Node)new ImageView(PopUpOptionNewController.this.imageRecapTriangle));
        }
    };
    private EventHandler mEventHandlerPopUpDiscounts = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent event) {
            if (PopUpOptionNewController.this.discountsProductPopUp != null) {
                PopUpOptionNewController.this.main_pane.setEffect(null);
                if (PopUpOptionNewController.this.discountsProductPopUp.getReduction() != null) {
                    if (PopUpOptionNewController.this.discountValue == PopUpOptionNewController.this.discountsProductPopUp.getReduction().getReduction()) {
                        PopUpOptionNewController.this.discountValue = 0.0;
                        PopUpOptionNewController.this.labelDiscount = null;
                        PopUpOptionNewController.this.typeDiscount = null;
                    } else {
                        PopUpOptionNewController.this.typeDiscount = PopUpOptionNewController.this.discountsProductPopUp.getReduction().getType();
                        PopUpOptionNewController.this.labelDiscount = PopUpOptionNewController.this.discountsProductPopUp.getReduction().getName();
                        PopUpOptionNewController.this.discountValue = PopUpOptionNewController.this.discountsProductPopUp.getReduction().getReduction();
                    }
                    PopUpOptionNewController.this.setPriceTotal();
                }
            }
        }
    };
    private EventHandler mEventHandlerPopUpComments = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent event) {
            if (PopUpOptionNewController.this.commentsProductPopUp != null) {
                PopUpOptionNewController.this.main_pane.setEffect(null);
                PopUpOptionNewController.this.noteValue = PopUpOptionNewController.this.commentsProductPopUp.getCommentText();
                PopUpOptionNewController.this.stage.setAlwaysOnTop(true);
            }
        }
    };
    private EventHandler mEventHandlerPopUpSubSupplements = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent event) {
            if (PopUpOptionNewController.this.subSupplementsPopUp != null) {
                PopUpOptionNewController.this.main_pane.setEffect(null);
                SubSupplementResult result = PopUpOptionNewController.this.subSupplementsPopUp.getResult();
                SupplementItemInfo optionItemParent = PopUpOptionNewController.this.subSupplementsPopUp.getParentSupplement();
                CarteOrderInfo groupProducts = PopUpOptionNewController.this.subSupplementsPopUp.getGroupProducts();
                ProductInfoExt subProduct = PopUpOptionNewController.this.subSupplementsPopUp.getSubProduct();
                int index_group_option = PopUpOptionNewController.this.subSupplementsPopUp.getIndex_group_option();
                OptionDetailProductButton buttonOptionParent = PopUpOptionNewController.this.subSupplementsPopUp.getButtonOptionParent();
                PopUpOptionNewController.this.validSubSupplement(result, buttonOptionParent, groupProducts, subProduct, optionItemParent, index_group_option);
                System.out.println("hide sub supplement : " + new Date());
                if (PopUpOptionNewController.this.inDriveMode) {
                    AppLocal.displayDualScreen.propagateClick("hideSubSupplements", new Object[]{result.isValid()});
                }
            }
        }
    };
    private EventHandler mEventHandlerPopUpErrorItemsHide = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent event) {
            DetailProductError detailProductError;
            PopUpOptionNewController.this.header_pane.setEffect(null);
            PopUpOptionNewController.this.detail_pane.setEffect(null);
            List<DetailProductError> errors = PopUpOptionNewController.this.errorItemsPopUp.getErrors();
            DetailProductError detailProductError2 = detailProductError = errors != null && !errors.isEmpty() ? errors.get(0) : null;
            if (detailProductError != null) {
                PopUpOptionNewController.this.loadPageDetailProduct(detailProductError);
            }
        }
    };
    private EventHandler mEventHandlerMainPaneMouseClick = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            PopUpOptionNewController.this.hidePopUps();
        }
    };
    private EventHandler mEventHandlerErrorLimitationPopUpHide = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent event) {
            if (PopUpOptionNewController.this.errorLimitationPopUp != null) {
                PopUpOptionNewController.this.main_pane.setEffect(null);
            }
        }
    };
    private EventHandler mEventHandlerClickSwitch = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            boolean soldedOut = false;
            if (PopUpOptionNewController.this.productStockPane.getmSwitchButton().isState()) {
                PopUpOptionNewController.this.productStockPane.setOffProduct();
                PopUpOptionNewController.this.header_pane.getChildren().clear();
                PopUpOptionNewController.this.header_pane.add((Node)PopUpOptionNewController.this.close_button, 0, 0);
                soldedOut = true;
            } else {
                PopUpOptionNewController.this.productStockPane.setOnSwithButtons();
                PopUpOptionNewController.this.returnToProduct();
                PopUpOptionNewController.this.productStockPane.setSoldOut(false);
            }
            if (PopUpOptionNewController.this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("handleClickSwitch", new Object[]{soldedOut});
            }
        }
    };
    private EventHandler mEventHandlerSetSoldOutTemporary = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            PopUpOptionNewController.this.productStockPane.setSoldOutTemporary();
            PopUpOptionNewController.this.header_pane.getChildren().clear();
            PopUpOptionNewController.this.header_pane.add((Node)PopUpOptionNewController.this.close_button, 0, 0);
        }
    };

    public void initializer(double quantity, ProductInfoExt product, double price, AppView m_App, List<OptionItemOrder> listOptions, List<ItemOrderInfo> listIngredients, List<ProductTicket> listItems, double discountVal, String noteVal, String labelDiscount, String sizeProduct, String name_sizeProduct, List<TicketLineInfo> lines, double discountOrder, String typeDiscount, String typeDisplay, int indexLine, boolean has_discount_permission, String typeCommande, String type_line, String time_served, boolean has_add_free_options_permission, String type_discount, boolean update_product, double priceProduct, boolean has_stock_management_permission) {
        try {
            Object productClone = product.clone();
            List listOptionsClone = listOptions.stream().map(opt -> opt.clone()).collect(Collectors.toList());
            List listIngredientsClone = listIngredients.stream().map(ing -> ing.clone()).collect(Collectors.toList());
            List listItemsClone = listItems.stream().map(item -> item.clone()).collect(Collectors.toList());
            this.has_stock_management_permission = has_stock_management_permission;
            this.detailProductResult = new DetailProductResult();
            this.m_App = m_App;
            this.priceSell = price;
            this.priceProduct = priceProduct;
            this.product = product;
            this.unit = this.product != null ? this.product.getUnit() : "piece";
            this.old_multiply = this.multiply = this.unit != null && this.unit.equals("poids") ? quantity * 1000.0 : quantity;
            this.type_line = type_line;
            this.time_served = time_served;
            this.type_order = typeCommande;
            if (this.type_line == null) {
                this.type_line = this.type_order;
            }
            this.setTypeLine();
            this.listLinesTmp = lines;
            this.lineTmp = new TicketLineInfo();
            this.lineTmp.setNameProduct(product.getName());
            this.indexLine = indexLine;
            if (this.indexLine == this.listLinesTmp.size()) {
                this.listLinesTmp.add(this.lineTmp);
            }
            this.discountOrder = discountOrder;
            this.typeDiscountOrder = typeDiscount;
            this.discountValue = discountVal;
            this.name_sizeProduct = name_sizeProduct;
            this.labelDiscount = labelDiscount;
            this.typeDiscount = type_discount;
            this.noteValue = noteVal;
            this.listChoiceSupplement = listOptions;
            this.listChoiceIngredient = listIngredients;
            this.listProducts = listItems;
            this.typeDisplay = typeDisplay;
            this.update_product = update_product;
            this.ingredients = product.getIngredients();
            this.optionsDB = product.getSupplements();
            this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
            this.dlItems = (DataLogicItems)m_App.getBean("com.openbravo.dao.DataLogicItems");
            this.dlSales.setDlItems(this.dlItems);
            this.mItemService = ItemService.getInstance();
            this.mReductionService = ReductionService.getInstance();
            this.detail_pane.getChildren().clear();
            this.setButtonsIcons();
            this.getDetailProduct();
            this.setInfoProduct();
            this.setTexts();
            this.loadHeaderButtons();
            this.setTypeLine();
            this.setOptionsOfSubProducts();
            this.make_items_free_button.setDisable(!has_add_free_options_permission);
            this.make_items_free_button.setStyle(this.styleMakeFreeItem);
            this.discount_button.setDisable(!has_discount_permission);
            this.main_pane.setOnMouseClicked(this.mEventHandlerMainPaneMouseClick);
            this.checkAddMinItems();
            this.checkSoldOut();
            if (AppLocal.TYPE_DISPLAY != null && AppLocal.TYPE_DISPLAY.startsWith("window")) {
                this.inDriveMode = true;
                AppLocal.displayDualScreen.propagateClick("initializer", new Object[]{quantity, productClone, price, listOptionsClone, listIngredientsClone, listItemsClone, discountVal, noteVal, labelDiscount, sizeProduct, name_sizeProduct, lines, discountOrder, typeDiscount, typeDisplay, indexLine, has_discount_permission, typeCommande, type_line, time_served, has_add_free_options_permission, type_discount, update_product, priceProduct, this.dlSales, this.dlItems});
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void close() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else {
            this.detailProductResult = null;
            this.closePopup();
        }
    }

    public void printMultiply() {
        if (this.multiply == (double)Math.round(this.multiply)) {
            this.quantity_label.setText(Formats.INT.formatValue(this.multiply));
        } else {
            this.quantity_label.setText(Formats.DOUBLE.formatValue(this.multiply));
        }
    }

    public void increaseQuantity() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else {
            boolean higher_price;
            double quantity_tmp = this.multiply + 1.0;
            double compare_price = this.update_product ? (quantity_tmp - this.old_multiply) * this.product.getPrice_point() : quantity_tmp * this.product.getPrice_point();
            boolean bl = higher_price = this.product.isUse_points() && (AppLocal.currentCustomerLoyalty == null || AppLocal.currentCustomerLoyalty != null && AppLocal.currentCustomerLoyalty.getPoints() < compare_price);
            if (!higher_price) {
                this.multiply += 1.0;
                this.printMultiply();
                this.price_label.setText(this.printPriceSell());
                this.displayScreen();
            }
        }
    }

    public void decreaseQuantity() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else if (this.multiply > 1.0) {
            this.multiply -= 1.0;
            this.printMultiply();
            this.price_label.setText(this.printPriceSell());
            this.displayScreen();
        }
    }

    public String printPriceSell() {
        double quantity = this.unit != null && this.unit.equals("poids") ? this.multiply / 1000.0 : this.multiply;
        double discount = this.typeDiscount != null && this.typeDiscount.equals("somme") ? this.discountValue : this.discountValue * this.priceSell / 100.0 * quantity;
        double price = this.priceSell * quantity - discount;
        return Formats.CURRENCY.formatValue(price);
    }

    public String printTotal() {
        return Formats.CURRENCY.formatValue(this.getTotal());
    }

    private void displayScreen() {
        if (this.typeDisplay != null && this.typeDisplay.equals("window")) {
            this.prepareLines();
            AppLocal.displayDualScreen.sendOrder(null, this.listLinesTmp, this.printTotal(), this.type_order);
        } else if (this.typeDisplay != null && this.typeDisplay.equals("window_drive")) {
            AppLocal.displayDualScreen.setTotalProduct(this.printPriceSell());
        }
    }

    public double getTotal() {
        return TicketInfo.computeTotal(this.listLinesTmp, this.typeDiscountOrder, this.discountOrder);
    }

    public void prepareLines() {
        this.lineTmp.setListSupplements(this.listChoiceSupplement);
        this.lineTmp.setListIngredients(this.listChoiceIngredient);
        this.lineTmp.setMultiply(this.multiply);
        this.lineTmp.setPrice(this.priceSell);
        this.lineTmp.setListProducts(this.listProducts);
        this.lineTmp.setDiscount(this.discountValue);
        this.lineTmp.setNote(this.noteValue);
        this.lineTmp.setLabelDiscount(this.labelDiscount);
        this.lineTmp.setType_discount(this.typeDiscount);
        this.listLinesTmp.set(this.indexLine, this.lineTmp);
    }

    public DetailProductResult getResult() {
        if (this.detailProductResult != null) {
            this.detailProductResult.setListChoiceIngredient(this.listChoiceIngredient);
            this.detailProductResult.setListChoiceSupplement(this.listChoiceSupplement);
            this.detailProductResult.setMultiply(this.unit.equals("poids") ? this.multiply / 1000.0 : this.multiply);
            this.detailProductResult.setPriceSell(this.priceSell);
            this.detailProductResult.setListProducts(this.listProducts);
            this.detailProductResult.setDiscountValue(this.discountValue);
            this.detailProductResult.setNoteValue(this.noteValue);
            this.detailProductResult.setLabelDiscount(this.labelDiscount);
            this.detailProductResult.setType_line(this.type_line);
            this.detailProductResult.setTime_served(this.time_served);
            this.detailProductResult.setTypeDiscount(this.typeDiscount);
        }
        return this.detailProductResult;
    }

    private void calculFreeAfterDelete(OptionDetailProductButton buttonOption) {
        int id_group_products;
        CarteOrderInfo group_products = buttonOption.getGroupProducts();
        ProductInfoExt subProduct = buttonOption.getSubProduct();
        SupplementProduct option = buttonOption.getGroupOption();
        int n = id_group_products = group_products != null ? group_products.getId() : -1;
        int index_group_products = group_products != null ? group_products.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        this.calculFreeAfterDelete(option, id_sub_product, id_group_products, index_group_products, option.isFree_able());
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
    }

    private void calculFreeAfterDelete(SupplementProduct option, int id_product, int id_carte, int index_carte, boolean isFree) {
        if (this.isOptionFreeable(option)) {
            for (OptionItemOrder supplement : this.listChoiceSupplement) {
                if (supplement.getId_groupe_option() != option.getiD() || supplement.getIdCarte() != id_carte || supplement.getIdProduct() != id_product || supplement.getIndex_carte() != index_carte || supplement.getNumber_free() >= supplement.getNumberOption() || !(supplement.getPrice() > 0.0)) continue;
                int free_possible = option.getOption_free() - option.getOption_free_tmp();
                int free = free_possible > supplement.getNumberOption() - supplement.getNumber_free() ? supplement.getNumberOption() - supplement.getNumber_free() : free_possible;
                double price_option = supplement.getPrice() - supplement.getPrice() / (double)(supplement.getNumberOption() - supplement.getNumber_free());
                supplement.setNumber_free(supplement.getNumber_free() + free);
                supplement.setPrice(price_option, supplement.getNumberOption() - supplement.getNumber_free());
                OptionDetailProductButton buttonOption = null;
                for (LinkedHashMap<Integer, OptionDetailProductButton> listButtons : this.map_options.values()) {
                    if (listButtons.get(supplement.getSupplement()) == null) continue;
                    buttonOption = listButtons.get(supplement.getSupplement());
                    break;
                }
                if (buttonOption != null) {
                    buttonOption.checkFreeAndSetStyle();
                }
                this.decrementOptionFree(option, free);
            }
            this.setPriceTotal();
        }
    }

    private boolean isOptionFreeable(SupplementProduct groupeOption) {
        return groupeOption.getOption_free() > groupeOption.getOption_free_tmp();
    }

    private void decrementOptionFree(SupplementProduct groupOption) {
        this.decrementOptionFree(groupOption, 1);
    }

    private void incrementOptionFree(SupplementProduct groupOption, int number_free) {
        groupOption.setOption_free_tmp(groupOption.getOption_free_tmp() - number_free);
    }

    private void decrementOptionFree(SupplementProduct groupOption, int number_free) {
        groupOption.setOption_free_tmp(groupOption.getOption_free_tmp() + number_free);
    }

    public void loadKeyBoard() {
        try {
            if (!this.keyBoardLoaded) {
                this.keyBoardLoaded = true;
                if (this.popupKeyBoard == null) {
                    KeyboardPane kb = new KeyboardPane();
                    kb.setLayer(DefaultLayer.NUMBLOCK);
                    kb.addRobotHandler((IRobot)new NativeAsciiRobotHandler());
                    kb.setOnKeyboardCloseButton(e -> {
                        this.popupKeyBoard.setVisible(false);
                        this.keyBoardLoaded = false;
                    });
                    kb.setLocale(Locale.forLanguageTag("en"));
                    kb.load();
                    this.popupKeyBoard = new KeyBoardPopup(kb);
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    double width = screenSize.getWidth();
                    double height = screenSize.getHeight();
                    this.popupKeyBoard.setX(width / 4.0);
                    this.popupKeyBoard.setY(height / 4.0 * 3.0);
                    this.popupKeyBoard.setHeight(height / 4.0);
                    this.popupKeyBoard.registerScene(this.stage.getScene());
                }
                this.popupKeyBoard.setVisible(true);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public String getColor(SupplementItemInfo option, SupplementProduct gOption) {
        if (option != null && option.getColor() != null && !option.getColor().isEmpty()) {
            return this.getColor(option.getColor());
        }
        if (gOption.getColor() != null && !gOption.getColor().isEmpty()) {
            return this.getColor(gOption.getColor());
        }
        return null;
    }

    public String getColor(String color_option) {
        Object hex = null;
        if (color_option != null && !color_option.isEmpty()) {
            String[] tabColor = color_option.split(",");
            Color color = new Color(Integer.parseInt(tabColor[0]), Integer.parseInt(tabColor[1]), Integer.parseInt(tabColor[2]));
            hex = Integer.toHexString(color.getRGB() & 0xFFFFFF);
            if (((String)hex).length() < 6) {
                int length = 6 - ((String)hex).length();
                for (int h = 0; h < length; ++h) {
                    hex = "0" + (String)hex;
                }
            }
            hex = "#" + (String)hex;
        }
        return hex;
    }

    private void setTexts() {
        this.close_button.setText(AppLocal.getIntString("Text.close"));
        this.comment_button.setText(AppLocal.getIntString("Text.comment"));
        this.make_items_free_button.setText(AppLocal.getIntString("Text.free"));
        this.add_label.setText(AppLocal.getIntString("Text.add"));
    }

    private void setButtonsIcons() throws URISyntaxException {
        Image imageCloseButton = new Image(this.getClass().getResource("/com/openbravo/images/close_button.png").toURI().toString(), 27.0, 27.0, false, false);
        this.close_button.setGraphic((Node)new ImageView(imageCloseButton));
        this.mImagesUtils = new ImagesUtils();
        Image image = this.mImagesUtils.getImageProduct(this.product, AppLocal.refProducts, "_128px", false);
        if (image != null) {
            ImageView imageItem = new ImageView(image);
            imageItem.setFitHeight(50.0);
            imageItem.setFitWidth(50.0);
            imageItem.setPreserveRatio(false);
            imageItem.setSmooth(false);
            this.image_product_label.setGraphic((Node)imageItem);
        }
        Image imageComment = new Image(this.getClass().getResource("/com/openbravo/images/comment.png").toURI().toString(), 25.0, 25.0, false, false);
        this.comment_button.setGraphic((Node)new ImageView(imageComment));
        Image imageDiscount = new Image(this.getClass().getResource("/com/openbravo/images/discount.png").toURI().toString(), 30.0, 29.0, false, false);
        this.discount_button.setGraphic((Node)new ImageView(imageDiscount));
        Image imageRecap = new Image(this.getClass().getResource("/com/openbravo/images/recap.png").toURI().toString(), 19.0, 19.0, false, false);
        this.recap_label.setGraphic((Node)new ImageView(imageRecap));
        this.imageRecapTriangle = new Image(this.getClass().getResource("/com/openbravo/images/recap_triangle_icon.png").toURI().toString(), 16.0, 15.0, false, false);
        this.imageRecapTriangleInverse = new Image(this.getClass().getResource("/com/openbravo/images/recap_triangle_icon_inverse.png").toURI().toString(), 16.0, 15.0, false, false);
        this.recap_icon.setGraphic((Node)new ImageView(this.imageRecapTriangle));
        this.imageDecrease = new Image(this.getClass().getResource("/com/openbravo/images/decrease.png").toURI().toString(), 30.0, 30.0, false, false);
        this.decrease_quantity_button.setGraphic((Node)new ImageView(this.imageDecrease));
        this.imageIncrease = new Image(this.getClass().getResource("/com/openbravo/images/increase.png").toURI().toString(), 30.0, 30.0, false, false);
        this.increase_quantity_button.setGraphic((Node)new ImageView(this.imageIncrease));
        Image imageNext = new Image(this.getClass().getResource("/com/openbravo/images/white_next_icon.png").toURI().toString(), 30.0, 30.0, false, false);
        this.next_detail_header.setGraphic((Node)new ImageView(imageNext));
        Image imagePrevious = new Image(this.getClass().getResource("/com/openbravo/images/white_previous_icon.png").toURI().toString(), 30.0, 30.0, false, false);
        this.previous_detail_header.setGraphic((Node)new ImageView(imagePrevious));
        this.imagePreviousItemProduct = new Image(this.getClass().getResource("/com/openbravo/images/previous_item_product.png").toURI().toString(), 25.0, 25.0, false, false);
        this.imageNextItemProduct = new Image(this.getClass().getResource("/com/openbravo/images/next_item_product.png").toURI().toString(), 25.0, 25.0, false, false);
        this.imageRemovedIngredient = new Image(this.getClass().getResource("/com/openbravo/images/removed_ingredient.png").toURI().toString());
        this.imageDefaultItemOption = new Image(this.getClass().getResource("/com/openbravo/images/default_image_item_option.png").toURI().toString());
        Image imageSetting = new Image(this.getClass().getResource("/com/openbravo/images/setting.png").toURI().toString(), 30.0, 30.0, false, false);
        this.setting_button.setGraphic((Node)new ImageView(imageSetting));
        Image image_go_back = new Image(this.getClass().getResource("/com/openbravo/images/go_back_xhdpi.png").toURI().toString(), 44.0, 44.0, false, false);
        this.return_to_button.setGraphic((Node)new ImageView(image_go_back));
    }

    private void setInfoProduct() {
        int numberItems = this.getNumberItems();
        this.recap_label.setText("Recap: " + numberItems);
        this.name_product_label.setText(this.product.getName());
        this.price_label.setText(this.printPriceSell());
        this.printMultiply();
    }

    private void getDetailProduct() throws BasicException {
        this.options = new ArrayList<SupplementProduct>();
        for (SupplementProduct option : this.optionsDB) {
            if (!option.getItems().isEmpty()) continue;
            option.reloadInfoSize(this.name_sizeProduct);
            List<Object> optionsItem = new ArrayList();
            optionsItem = option.isOrder_name() ? this.dlItems.getSuppelementsItemOrderAlpha(option.getiD()) : this.dlItems.getSuppelementsItem(option.getiD(), true);
            ArrayList<SupplementItemInfo> optionsItemToAdd = new ArrayList<SupplementItemInfo>();
            if (optionsItem.size() <= 0) continue;
            for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
                if (option.getiD() != optionItemOrder.getId_groupe_option()) continue;
                option.setOption_free_tmp(option.getOption_free_tmp() + optionItemOrder.getNumber_free());
            }
            for (SupplementItemInfo supplementItemInfo : optionsItem) {
                double price_option = supplementItemInfo.getPriceOption(this.name_sizeProduct, this.type_order);
                if (this.product.isMany_size() && supplementItemInfo.isMany_size() && price_option == -1.0) continue;
                if (AppLocal.MODULE_NIGHT_TARIFF) {
                    price_option = this.mItemService.calculateNightTariffPrice(price_option);
                }
                supplementItemInfo.setPrice_order(price_option);
                for (GroupSubSupplementInfo group_sub_item : supplementItemInfo.getGroupsSubSupplement()) {
                    for (SupplementItemInfo sub_item : group_sub_item.getSupplements()) {
                        double price_sub_option = sub_item.getPriceOption(this.name_sizeProduct, this.type_order);
                        if (AppLocal.MODULE_NIGHT_TARIFF) {
                            price_sub_option = this.mItemService.calculateNightTariffPrice(price_sub_option);
                        }
                        sub_item.setPrice_order(price_sub_option);
                    }
                }
                optionsItemToAdd.add(supplementItemInfo);
            }
            option.setItems(optionsItemToAdd);
            this.options.add(option);
        }
        this.groupProductsDB = this.product.getCartes();
        this.groupProducts = new ArrayList<CarteOrderInfo>();
        for (CarteOrderInfo carteDB : this.groupProductsDB) {
            for (int i = 0; i < carteDB.getNumber_carte(); ++i) {
                List<ProductInfoExt> itemsPlat;
                CarteOrderInfo carte = new CarteOrderInfo(carteDB.getId(), carteDB.getName(), carteDB.getSizeCarte(), carteDB.getOrderCarte(), carteDB.getNumber_carte());
                carte.setIndex_carte(i + 1);
                if (carteDB.getNumber_carte() > 1) {
                    carte.setName(carteDB.getName() + " " + (i + 1));
                }
                if ((itemsPlat = this.dlSales.getProductsByPlat(carteDB.getId(), true)).size() <= 0) continue;
                carte.setItems(itemsPlat);
                this.groupProducts.add(carte);
            }
        }
        if (this.product.getSub_products() != null && !this.product.getSub_products().isEmpty()) {
            this.loadSubProduct(this.product);
            System.out.println("++++++++++ loadSubProduct1: true");
        }
    }

    private void loadSubProduct(ProductInfoExt product) {
        this.subProducts = new ArrayList<ProductInfoExt>();
        for (ProductInfoExt sub_product : product.getSub_products()) {
            ProductInfoExt new_sub_product = (ProductInfoExt)sub_product.clone();
            new_sub_product.setIndex_sub_product(1);
            this.subProducts.add(new_sub_product);
        }
    }

    private void setHeaderNodes() {
        this.header_pane.getChildren().clear();
        int colum = 0;
        this.header_pane.add((Node)this.infos_product_pane, colum++, 0);
        this.header_pane.add((Node)this.header_detail_product_pages, colum++, 0);
        if (AppLocal.MODEL_CAISSE != null && AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre") && this.has_stock_management_permission) {
            this.header_pane.add((Node)this.setting_button, colum++, 0);
            this.header_detail_product_pages.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.68);
        } else {
            this.header_detail_product_pages.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.63);
        }
        this.header_pane.add((Node)this.close_button, colum++, 0);
    }

    private void loadHeaderButtons() {
        this.setHeaderNodes();
        double heightDetailProductPane = AppVarUtils.getScreenDimension().getHeight() * 0.08;
        this.groupTabs = new ArrayList<HeaderDetailProductButton>();
        HeaderDetailProductButton firstButton = null;
        int index = 1;
        if (this.ingredients.size() > 0) {
            HeaderDetailProductButton ingredientButton = new HeaderDetailProductButton(STR_INGREDIENTS, null, index++);
            ingredientButton.setOnAction(this.mEventHandlerIngredientsAction);
            this.groupTabs.add(ingredientButton);
            if (!(firstButton != null || this.options != null && !this.options.isEmpty() || this.subProducts != null && !this.subProducts.isEmpty() || this.groupProducts != null && !this.groupProducts.isEmpty())) {
                firstButton = ingredientButton;
            }
        }
        if (this.subProducts != null) {
            for (ProductInfoExt sub_product : this.subProducts) {
                HeaderDetailProductButton subProductButton = new HeaderDetailProductButton(STR_SUB_PRODUCT, sub_product, index++);
                subProductButton.setOnAction(this.mEventHandlerSubProductAction);
                this.groupTabs.add(subProductButton);
                if (firstButton != null || this.options != null && !this.options.isEmpty() || this.groupProducts != null && !this.groupProducts.isEmpty()) continue;
                firstButton = subProductButton;
            }
        }
        if (this.groupProducts != null && !this.groupProducts.isEmpty()) {
            for (CarteOrderInfo groupProduct : this.groupProducts) {
                HeaderDetailProductButton groupProductButton = new HeaderDetailProductButton(STR_GROUP_PRODUCTS, groupProduct, index++);
                groupProductButton.setOnAction(this.mEventHandlerGroupsProductsAction);
                this.groupTabs.add(groupProductButton);
                if (firstButton != null) continue;
                firstButton = groupProductButton;
            }
        }
        if (this.options != null && !this.options.isEmpty()) {
            HeaderDetailProductButton optionsButton = new HeaderDetailProductButton(STR_OPTIONS, null, index++);
            optionsButton.setOnAction(this.mEventHandlerOptionsAction);
            this.groupTabs.add(optionsButton);
            if (this.groupProducts == null || this.groupProducts.isEmpty()) {
                firstButton = optionsButton;
            }
        }
        System.out.println("firstButton : " + firstButton);
        this.header_detail_product_pages.getChildren().clear();
        if (!this.groupTabs.isEmpty()) {
            double widthDetailProductTab;
            double widthDetailProductPane;
            System.out.println("+++++ loadHeaderButtons_not_empty_1");
            this.numberPageDetailProductHeader = (int)Math.ceil((double)this.groupTabs.size() / (double)this.NUMBER_DETAIL_PRODUCT_TAB);
            this.headerDetailProductArray = new GridPane[this.numberPageDetailProductHeader];
            for (int i = 0; i < this.numberPageDetailProductHeader; ++i) {
                this.headerDetailProductArray[i] = new GridPane();
                this.headerDetailProductArray[i].setVgap(5.0);
                this.headerDetailProductArray[i].setHgap(5.0);
                this.headerDetailProductArray[i].setAlignment(Pos.CENTER);
            }
            if (this.groupTabs.size() <= 4) {
                widthDetailProductPane = this.header_detail_product_pages.getPrefWidth();
                widthDetailProductTab = widthDetailProductPane / (double)this.groupTabs.size();
                this.header_detail_product_pages.add((Node)this.header_detail_product_pane, 0, 0);
            } else {
                widthDetailProductPane = this.header_detail_product_pages.getPrefWidth() * 0.8;
                widthDetailProductTab = widthDetailProductPane / (double)this.NUMBER_DETAIL_PRODUCT_TAB;
                this.header_detail_product_pages.add((Node)this.previous_detail_header, 0, 0);
                this.header_detail_product_pages.add((Node)this.header_detail_product_pane, 1, 0);
                this.header_detail_product_pages.add((Node)this.next_detail_header, 2, 0);
                this.previous_detail_header.setDisable(true);
            }
            this.header_detail_product_pane.setPrefWidth(widthDetailProductPane);
            int index_detail_header = 0;
            int column_detail_header = 0;
            int numberButtonsInLastpage = this.groupTabs.size() % this.NUMBER_DETAIL_PRODUCT_TAB;
            for (HeaderDetailProductButton headerButton : this.groupTabs) {
                if (this.groupTabs.size() > 4 && index_detail_header == this.numberPageDetailProductHeader - 1 && numberButtonsInLastpage > 0 && numberButtonsInLastpage < this.NUMBER_DETAIL_PRODUCT_TAB) {
                    widthDetailProductTab = widthDetailProductPane / (double)numberButtonsInLastpage;
                }
                headerButton.setPrefHeight(heightDetailProductPane * 0.9);
                headerButton.setPrefWidth(widthDetailProductTab);
                this.headerDetailProductArray[index_detail_header].add((Node)headerButton, column_detail_header, 0);
                if (column_detail_header < this.NUMBER_DETAIL_PRODUCT_TAB - 1) {
                    ++column_detail_header;
                    continue;
                }
                ++index_detail_header;
                column_detail_header = 0;
            }
            if (this.numberPageDetailProductHeader > 0) {
                if (firstButton != null) {
                    this.page_detail_product_header = this.getPageHeaderTab(firstButton);
                }
                if (this.page_detail_product_header >= this.numberPageDetailProductHeader) {
                    this.page_detail_product_header = 0;
                }
                this.header_detail_product_pane.add((Node)this.headerDetailProductArray[this.page_detail_product_header], 0, 0);
                this.loadHeaderTab(firstButton);
            }
        }
    }

    public int getPageHeaderTab(HeaderDetailProductButton firstButton) {
        int index = firstButton.getIndex();
        int page = (int)Math.ceil((double)index / (double)this.NUMBER_DETAIL_PRODUCT_TAB);
        return --page;
    }

    public void nextHeaderTab() {
        if (this.page_detail_product_header < this.numberPageDetailProductHeader - 1) {
            ++this.page_detail_product_header;
            this.header_detail_product_pane.getChildren().clear();
            this.header_detail_product_pane.add((Node)this.headerDetailProductArray[this.page_detail_product_header], 0, 0);
            if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                this.next_detail_header.setDisable(true);
            }
            this.previous_detail_header.setDisable(false);
        }
    }

    public void previousHeaderTab() {
        if (this.page_detail_product_header > 0) {
            --this.page_detail_product_header;
            this.header_detail_product_pane.getChildren().clear();
            this.header_detail_product_pane.add((Node)this.headerDetailProductArray[this.page_detail_product_header], 0, 0);
            if (this.page_detail_product_header == 0) {
                this.previous_detail_header.setDisable(true);
            }
            this.next_detail_header.setDisable(false);
        }
    }

    private void deselectHeaderTabs() {
        for (HeaderDetailProductButton headerButton : this.groupTabs) {
            headerButton.deselect();
        }
    }

    private void selectHeaderTab(HeaderDetailProductButton headerButton) {
        headerButton.select();
    }

    private void loadIngredients(CarteOrderInfo groupProducts, ProductInfoExt subProduct, GridPane paneParent) {
        paneParent.getChildren().clear();
        if (this.map_ingredients == null) {
            this.map_ingredients = new HashMap();
        }
        this.map_ingredients.clear();
        double widthIngredientsPane = AppVarUtils.getScreenDimension().getWidth();
        double widthIngredient = widthIngredientsPane / (double)this.NUMBER_COLUMN_INGREDIENT;
        double heightIngredient = this.heightIngredientsPane / (double)this.NUMBER_ROW_INGREDIENT;
        int index = 0;
        int index_map = 0;
        ArrayList<SupplementItemInfo> ingredientItems = new ArrayList<SupplementItemInfo>();
        if (subProduct != null) {
            if (subProduct.getIngredients() != null) {
                ingredientItems.addAll(subProduct.getIngredients());
            }
        } else {
            ingredientItems.addAll(this.ingredients);
        }
        ArrayList<IngredientDetailProductButton> itemIngredientsButton = new ArrayList<IngredientDetailProductButton>();
        this.numberPageIngredients = (int)Math.ceil((double)ingredientItems.size() / (double)this.MAX_INGREDIENTS_PER_PAGE);
        this.MAX_INGREDIENTS = this.numberPageIngredients > 1 ? this.MAX_INGREDIENTS_PER_PAGE - 1 : this.MAX_INGREDIENTS_PER_PAGE;
        for (SupplementItemInfo ingredient : ingredientItems) {
            boolean removed = this.indexIngredientRemovedIfExist(groupProducts, subProduct, ingredient) != -1;
            Image imageIngredient = this.mImagesUtils.getImageIngredients(ingredient, AppLocal.refIngredients, "_64px", false);
            if (imageIngredient == null) {
                imageIngredient = this.imageDefaultItemOption;
            }
            IngredientDetailProductButton ingredientButton = new IngredientDetailProductButton(groupProducts, subProduct, ingredient, heightIngredient, widthIngredient, imageIngredient, this.imageRemovedIngredient, removed);
            ingredientButton.setOnAction(this.mEventHandlerIngredientAction);
            if (index < this.MAX_INGREDIENTS) {
                itemIngredientsButton.add(ingredientButton);
            } else {
                this.map_ingredients.put(index_map, itemIngredientsButton);
                itemIngredientsButton = new ArrayList();
                itemIngredientsButton.add(ingredientButton);
                ++index_map;
                index = 0;
            }
            ++index;
        }
        if (itemIngredientsButton != null && !itemIngredientsButton.isEmpty()) {
            this.map_ingredients.put(index_map, itemIngredientsButton);
        }
        int column = 0;
        int row = 0;
        this.removeAllIngredientsButton = new RemoveAllIngredientsButton(groupProducts, subProduct, heightIngredient, widthIngredient);
        this.removeAllIngredientsButton.setAlignment(Pos.CENTER);
        this.removeAllIngredientsButton.setTextAlignment(TextAlignment.CENTER);
        this.removeAllIngredientsButton.setWrapText(true);
        this.removeAllIngredientsButton.setText(AppLocal.getIntString("Text.remove.all.ingredients"));
        this.removeAllIngredientsButton.setOnAction(this.mEventHandlerremoveAllIngredientAction);
        paneParent.add((Node)this.removeAllIngredientsButton, column++, row);
        for (int i = 0; i < this.MAX_INGREDIENTS; ++i) {
            GridPane itemIngredientPane = new GridPane();
            itemIngredientPane.setPrefHeight(heightIngredient);
            itemIngredientPane.setPrefWidth(widthIngredient);
            itemIngredientPane.getStyleClass().add((Object)"border_white_opacity12");
            itemIngredientPane.getStyleClass().add((Object)"border_radius_12px");
            itemIngredientPane.getStyleClass().add((Object)"bg_radius_12px");
            itemIngredientPane.getStyleClass().add((Object)"bg_black_opacity50");
            paneParent.add((Node)itemIngredientPane, column, row);
            if (column < this.NUMBER_COLUMN_INGREDIENT - 1) {
                ++column;
                continue;
            }
            column = 0;
            ++row;
        }
        if (this.numberPageIngredients > 1) {
            GridPane nextPreviousPane = new GridPane();
            nextPreviousPane.setAlignment(Pos.CENTER);
            nextPreviousPane.setVgap(5.0);
            nextPreviousPane.setHgap(5.0);
            nextPreviousPane.setPrefHeight(heightIngredient);
            nextPreviousPane.setPrefWidth(widthIngredient);
            nextPreviousPane.getStyleClass().add((Object)"bg_black_232531");
            nextPreviousPane.getStyleClass().add((Object)"border_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"bg_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"border_white_opacity12");
            this.nextItemIngredientButton = new NextPreviousButton(paneParent, nextPreviousPane.getPrefHeight() * 0.8, nextPreviousPane.getPrefWidth() * 0.45);
            this.nextItemIngredientButton.setGraphic((Node)new ImageView(this.imageNextItemProduct));
            this.nextItemIngredientButton.setOnAction(this.mEventHandlerNextIngredientAction);
            this.previousItemIngredientButton = new NextPreviousButton(paneParent, nextPreviousPane.getPrefHeight() * 0.8, nextPreviousPane.getPrefWidth() * 0.45);
            this.previousItemIngredientButton.setGraphic((Node)new ImageView(this.imagePreviousItemProduct));
            this.previousItemIngredientButton.setOnAction(this.mEventHandlerPreviousIngredientAction);
            nextPreviousPane.add((Node)this.previousItemIngredientButton, 0, 0);
            nextPreviousPane.add((Node)this.nextItemIngredientButton, 1, 0);
            paneParent.add((Node)nextPreviousPane, column, row);
            this.previousItemIngredientButton.setDisable(true);
            if (this.numberPageIngredients == 1) {
                this.nextItemIngredientButton.setDisable(true);
            }
            if (!this.isIngredientRemovedExist()) {
                this.removeAllIngredientsButton.setDisable(true);
            }
        }
        this.page_ingredients = 0;
        this.loadPageIngredients(this.page_ingredients, paneParent);
    }

    private void loadPageIngredients(int page_ingredients, GridPane paneParent) {
        List<IngredientDetailProductButton> ingredientsButton = this.map_ingredients.get(page_ingredients);
        if (ingredientsButton != null) {
            int numberIngredients = ingredientsButton.size();
            int index = 0;
            for (Node node : paneParent.getChildren()) {
                if (index < this.MAX_INGREDIENTS) {
                    if (!(node instanceof GridPane)) continue;
                    GridPane ingredientPane = (GridPane)node;
                    ingredientPane.getChildren().clear();
                    if (index < numberIngredients) {
                        ingredientPane.add((Node)ingredientsButton.get(index), 0, 0);
                    }
                    ++index;
                    continue;
                }
                break;
            }
        } else {
            int index = 0;
            for (Node node : paneParent.getChildren()) {
                if (index < this.MAX_INGREDIENTS) {
                    if (node instanceof GridPane) {
                        GridPane ingredientPane = (GridPane)node;
                        ingredientPane.getChildren().clear();
                    }
                    ++index;
                    continue;
                }
                break;
            }
        }
    }

    public void nextIngredient(NextPreviousButton buttonSource) {
        GridPane paneParent = buttonSource.getPaneParent();
        if (this.page_ingredients < this.numberPageIngredients - 1) {
            ++this.page_ingredients;
            this.loadPageIngredients(this.page_ingredients, paneParent);
            if (this.page_ingredients == this.numberPageIngredients - 1) {
                this.nextItemIngredientButton.setDisable(true);
            }
            this.previousItemIngredientButton.setDisable(false);
        }
    }

    public void previousIngredient(NextPreviousButton buttonSource) {
        GridPane paneParent = buttonSource.getPaneParent();
        if (this.page_ingredients > 0) {
            --this.page_ingredients;
            this.loadPageIngredients(this.page_ingredients, paneParent);
            if (this.page_ingredients == 0) {
                this.previousItemIngredientButton.setDisable(true);
            }
            this.nextItemIngredientButton.setDisable(false);
        }
    }

    public void changeIngredient(IngredientDetailProductButton btnIngredient) {
        ProductInfoExt subProduct;
        SupplementItemInfo ingredient = btnIngredient.getIngredient();
        CarteOrderInfo groupProducts = btnIngredient.getGroupProducts();
        int indexRemovedIngredient = this.indexIngredientRemovedIfExist(groupProducts, subProduct = btnIngredient.getSupProduct(), ingredient);
        if (indexRemovedIngredient == -1) {
            this.removeIngredient(btnIngredient);
        } else {
            this.addRemovedIngredient(btnIngredient, indexRemovedIngredient);
        }
    }

    private void addRemovedIngredient(IngredientDetailProductButton btnIngredient, int indexRemovedIngredient) {
        this.listChoiceIngredient.remove(indexRemovedIngredient);
        btnIngredient.setRemoved(false);
        btnIngredient.deselectIngredient();
        if (!this.isIngredientRemovedExist()) {
            this.removeAllIngredientsButton.setDisable(true);
        }
        if (this.inDriveMode) {
            AppLocal.displayDualScreen.propagateClick("addRemovedIngredient", new Object[]{btnIngredient.getIngredient().getiD()});
        }
    }

    private void removeIngredient(IngredientDetailProductButton btnIngredient) {
        int id_group_products;
        CarteOrderInfo groupProducts = btnIngredient.getGroupProducts();
        ProductInfoExt subProduct = btnIngredient.getSupProduct();
        SupplementItemInfo ingredient = btnIngredient.getIngredient();
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        String name_group_products = groupProducts != null ? groupProducts.getName() : null;
        String name_sub_product = subProduct != null ? subProduct.getName() : null;
        String ref_group_product = groupProducts != null ? groupProducts.getRef_web() : null;
        String id_global_carte = groupProducts != null ? groupProducts.getId_global() : null;
        String ref_sub_product = subProduct != null ? subProduct.getRef_web() : null;
        String id_global_sub_product = subProduct != null ? subProduct.getId_global() : null;
        ItemOrderInfo itemOrderInfo = new ItemOrderInfo(ingredient, id_group_products, id_sub_product, name_sub_product, name_group_products, index_group_products, ref_sub_product, ref_group_product, id_global_sub_product, id_global_carte);
        itemOrderInfo.setImageIngredient(btnIngredient.getImageItem());
        this.listChoiceIngredient.add(itemOrderInfo);
        btnIngredient.setRemoved(true);
        btnIngredient.selectRemovedIngredient();
        if (this.removeAllIngredientsButton.isDisable()) {
            this.removeAllIngredientsButton.setDisable(false);
        }
        if (this.inDriveMode) {
            AppLocal.displayDualScreen.propagateClick("removeIngredient", new Object[]{btnIngredient.getIngredient().getiD()});
        }
    }

    private int indexIngredientRemovedIfExist(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo ingredient) {
        int id_group_products;
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        int found = -1;
        for (int i = 0; i < this.listChoiceIngredient.size(); ++i) {
            if (this.listChoiceIngredient.get(i).getIdCarte() != id_group_products && (id_group_products != -1 || this.listChoiceIngredient.get(i).getIdCarte() != 0) || this.listChoiceIngredient.get(i).getIdProduct() != id_sub_product && (id_sub_product != -1 || this.listChoiceIngredient.get(i).getIdProduct() != 0) || this.listChoiceIngredient.get(i).getSupplement() != ingredient.getiD() || this.listChoiceIngredient.get(i).getIndex_carte() != index_group_products) continue;
            found = i;
            break;
        }
        return found;
    }

    public void validProduct() {
        this.closePopup();
    }

    public void closePopup() {
        this.stage.close();
        if (this.inDriveMode) {
            AppLocal.displayDualScreen.propagateClick("close", null);
            AppLocal.displayDualScreen.reloadView(null);
        }
    }

    private boolean isIngredientRemovedExist() {
        for (int i = 0; i < this.listChoiceIngredient.size(); ++i) {
            if (this.listChoiceIngredient.get(i).getIdCarte() != -1 && this.listChoiceIngredient.get(i).getIdCarte() != 0 || this.listChoiceIngredient.get(i).getIdProduct() != -1 && this.listChoiceIngredient.get(i).getIdProduct() != 0) continue;
            return true;
        }
        return false;
    }

    private void removeAllIngredients(RemoveAllIngredientsButton buttonAllIngredients) {
        boolean allIngredientsRemoved = this.isAllIngredientsRemoved(buttonAllIngredients);
        for (List<IngredientDetailProductButton> listIngredients : this.map_ingredients.values()) {
            for (IngredientDetailProductButton btnIngredient : listIngredients) {
                int indexRemovedIngredient;
                CarteOrderInfo groupProducts = btnIngredient.getGroupProducts();
                ProductInfoExt subProduct = btnIngredient.getSupProduct();
                SupplementItemInfo ingredient = btnIngredient.getIngredient();
                if (allIngredientsRemoved) {
                    indexRemovedIngredient = this.indexIngredientRemovedIfExist(groupProducts, subProduct, ingredient);
                    if (indexRemovedIngredient != -1) {
                        this.addRemovedIngredient(btnIngredient, indexRemovedIngredient);
                    }
                } else {
                    indexRemovedIngredient = this.indexIngredientRemovedIfExist(groupProducts, subProduct, ingredient);
                    if (indexRemovedIngredient == -1) {
                        this.removeIngredient(btnIngredient);
                    }
                }
                if (!this.inDriveMode) continue;
                AppLocal.displayDualScreen.propagateClick("removeAllIngredients", new Object[]{allIngredientsRemoved});
            }
        }
    }

    private void loadOptionsTabs_Product() {
        this.detail_pane.getChildren().clear();
        this.detail_pane.add((Node)this.optionTabsPages, 0, 0);
        this.detail_pane.add((Node)this.optionsPane, 0, 1);
        this.sendOptionsToDualScreen(null);
        this.loadOptionsTabs(null, null);
    }

    private void loadOptionsTabs_DirectSubProduct(ProductInfoExt subProduct) {
        this.detail_pane.getChildren().clear();
        this.detail_pane.add((Node)this.optionTabsPages, 0, 0);
        this.detail_pane.add((Node)this.optionsPane, 0, 1);
        this.loadOptionsTabs(null, subProduct);
    }

    private void loadOptionsTabs_GroupProduct(CarteOrderInfo groupProducts, ProductInfoExt subProduct) {
        System.out.println("++++++++ loadOptionsTabs_called_by_GroupProduct_1");
        this.loadOptionsTabs(groupProducts, subProduct);
    }

    private void loadOptionsTabs(CarteOrderInfo groupProducts, ProductInfoExt subProduct) {
        double widthOptionsTabsPane;
        OptionDetailProductTab firstGroupOption = null;
        this.groupOptionsPane.getChildren().clear();
        double heightOptionTabPane = AppVarUtils.getScreenDimension().getHeight() * 0.096;
        this.optionTabsPages.getChildren().clear();
        this.groupOptionTabs = new ArrayList<OptionDetailProductTab>();
        ArrayList<SupplementProduct> groupsOfOptions = new ArrayList<SupplementProduct>();
        if (subProduct != null && subProduct.getIngredients() != null && !subProduct.getIngredients().isEmpty()) {
            SupplementProduct groupIngredient = new SupplementProduct();
            groupIngredient.setName("ingredient");
            groupIngredient.setIs_ingredient(true);
            groupIngredient.setItems(subProduct.getIngredients());
            groupsOfOptions.add(groupIngredient);
        }
        if (subProduct != null) {
            if (subProduct.getSupplements() != null) {
                groupsOfOptions.addAll(subProduct.getSupplements());
            }
        } else {
            groupsOfOptions.addAll(this.options);
        }
        if (groupsOfOptions.size() <= this.MAX_OPTIONS_TABS_PER_PAGE) {
            widthOptionsTabsPane = AppVarUtils.getScreenDimension().getWidth();
            this.optionTabsPages.add((Node)this.groupOptionsPane, 0, 0);
        } else {
            widthOptionsTabsPane = AppVarUtils.getScreenDimension().getWidth() * 0.85;
            this.optionTabsPages.add((Node)this.groupOptionsPane, 0, 0);
            this.optionTabsPages.add((Node)this.nextPreviousOptionsTabs, 1, 0);
        }
        int numberOfGroups = groupsOfOptions.size();
        this.numberPageOptionsTabs = (int)Math.ceil((double)numberOfGroups / (double)this.MAX_OPTIONS_TABS_PER_PAGE);
        this.MAX_OPTIONS_TABS = this.numberPageOptionsTabs > 1 ? this.MAX_OPTIONS_TABS_PER_PAGE - 1 : this.MAX_OPTIONS_TABS_PER_PAGE;
        double widthOptionTab = widthOptionsTabsPane / (double)this.MAX_OPTIONS_TABS;
        this.groupOptionsPane.setPrefWidth(widthOptionsTabsPane);
        int index = 0;
        for (SupplementProduct groupOptions : groupsOfOptions) {
            if (groupOptions == null) continue;
            OptionDetailProductTab optionDetailProductTab = new OptionDetailProductTab(groupProducts, subProduct, groupOptions, widthOptionTab, heightOptionTabPane, index++);
            optionDetailProductTab.setOnAction(this.mEventHandlerOptionTabAction);
            System.out.println("+++++++++++ adding: " + groupOptions.getDisplayedName());
            this.groupOptionTabs.add(optionDetailProductTab);
            if (firstGroupOption != null || groupsOfOptions.size() != 1 && groupOptions.getIs_ingredient().booleanValue()) continue;
            firstGroupOption = optionDetailProductTab;
        }
        this.optionTabsArray = new GridPane[this.numberPageOptionsTabs];
        for (int i = 0; i < this.numberPageOptionsTabs; ++i) {
            this.optionTabsArray[i] = new GridPane();
            this.optionTabsArray[i].setVgap(5.0);
            this.optionTabsArray[i].setHgap(5.0);
            this.optionTabsArray[i].setAlignment(Pos.CENTER);
        }
        int index_option_tab = 0;
        int column_option_tab = 0;
        int numberButtonsInLastpage = numberOfGroups % this.MAX_OPTIONS_TABS;
        for (OptionDetailProductTab optionTab : this.groupOptionTabs) {
            this.optionTabsArray[index_option_tab].add((Node)optionTab, column_option_tab, 0);
            if (column_option_tab < this.MAX_OPTIONS_TABS - 1) {
                ++column_option_tab;
                continue;
            }
            ++index_option_tab;
            column_option_tab = 0;
        }
        if (this.numberPageOptionsTabs > 0) {
            if (numberButtonsInLastpage > 0) {
                for (int i = 0; i < this.MAX_OPTIONS_TABS - numberButtonsInLastpage; ++i) {
                    GridPane emptyOtionTab = new GridPane();
                    GridPane baseFrame = new GridPane();
                    emptyOtionTab.setPrefHeight(heightOptionTabPane);
                    emptyOtionTab.setPrefWidth(widthOptionTab);
                    baseFrame.setPrefHeight(heightOptionTabPane * 0.8);
                    baseFrame.setPrefWidth(widthOptionTab);
                    baseFrame.getStyleClass().add((Object)"bg_radius_12px");
                    baseFrame.getStyleClass().add((Object)"bg_white_opacity18");
                    emptyOtionTab.add((Node)baseFrame, 0, 0);
                    this.optionTabsArray[index_option_tab].add((Node)emptyOtionTab, column_option_tab++, 0);
                }
            }
            this.page_options_tabs = 0;
            this.groupOptionsPane.add((Node)this.optionTabsArray[this.page_options_tabs], 0, 0);
        }
        this.nextOptionTab.setGraphic((Node)new ImageView(this.imageNextItemProduct));
        this.previousOptionTab.setGraphic((Node)new ImageView(this.imagePreviousItemProduct));
        this.optionsPane.getChildren().clear();
        this.optionsPane.setStyle("");
        this.previousOptionTab.setDisable(true);
        if (this.numberPageOptionsTabs == 1) {
            this.nextOptionTab.setDisable(true);
        } else {
            this.nextOptionTab.setDisable(false);
        }
        if (firstGroupOption != null) {
            this.loadDetailGroupOption(firstGroupOption);
        }
    }

    public void nextGroupOption() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else if (this.page_options_tabs < this.numberPageOptionsTabs - 1) {
            ++this.page_options_tabs;
            this.groupOptionsPane.getChildren().clear();
            this.groupOptionsPane.add((Node)this.optionTabsArray[this.page_options_tabs], 0, 0);
            if (this.page_options_tabs == this.numberPageOptionsTabs - 1) {
                this.nextOptionTab.setDisable(true);
            }
            this.previousOptionTab.setDisable(false);
            int index_group_option = this.MAX_OPTIONS_TABS * this.page_options_tabs;
            if (this.groupOptionTabs != null && !this.groupOptionTabs.isEmpty()) {
                OptionDetailProductTab buttonGroupOption = this.groupOptionTabs.get(index_group_option);
                this.loadDetailGroupOption(buttonGroupOption);
            }
            if (this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("nextGroupOption", null);
            }
        }
    }

    public void previousGroupOption() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else if (this.page_options_tabs > 0) {
            --this.page_options_tabs;
            this.groupOptionsPane.getChildren().clear();
            this.groupOptionsPane.add((Node)this.optionTabsArray[this.page_options_tabs], 0, 0);
            if (this.page_options_tabs == 0) {
                this.previousOptionTab.setDisable(true);
            }
            this.nextOptionTab.setDisable(false);
            int index_group_option = this.MAX_OPTIONS_TABS * this.page_options_tabs;
            if (this.groupOptionTabs != null && !this.groupOptionTabs.isEmpty()) {
                OptionDetailProductTab buttonGroupOption = this.groupOptionTabs.get(index_group_option);
                this.loadDetailGroupOption(buttonGroupOption);
            }
            if (this.inDriveMode) {
                AppLocal.displayDualScreen.propagateClick("previousGroupOption", null);
            }
        }
    }

    private boolean isAllIngredientsRemoved(RemoveAllIngredientsButton buttonAllIngredients) {
        CarteOrderInfo groupProduct = buttonAllIngredients.getGroupProducts();
        ProductInfoExt supProduct = buttonAllIngredients.getSupProduct();
        for (SupplementItemInfo ingredient : this.ingredients) {
            boolean removed = this.indexIngredientRemovedIfExist(groupProduct, supProduct, ingredient) != -1;
            if (removed) continue;
            return false;
        }
        return true;
    }

    private void loadOptions(OptionDetailProductTab buttonGroupOption) {
        CarteOrderInfo groupProduct = buttonGroupOption.getGroupProducts();
        ProductInfoExt supProduct = buttonGroupOption.getProduct();
        SupplementProduct groupOption = buttonGroupOption.getGroupOption();
        this.optionsPane.getChildren().clear();
        String bg_color_option = groupOption.getColor() != null && !groupOption.getColor().isEmpty() ? this.getColor(groupOption.getColor()) : "#333645";
        this.optionsPane.setStyle("-fx-background-color: " + bg_color_option + ";-fx-background-radius: 0px 0px 11px 11px;");
        if (this.map_options == null) {
            this.map_options = new HashMap();
        }
        this.map_options.clear();
        double padding = 50.0;
        if (groupProduct != null) {
            this.NUMBER_COLUMN_OPTION = 3;
            this.NUMBER_ROW_OPTION = 4;
            this.MAX_OPTIONS_PER_PAGE = 12;
            this.heightOptionsPane = AppVarUtils.getScreenDimension().getHeight() * 0.5;
        } else {
            this.NUMBER_COLUMN_OPTION = 4;
            this.NUMBER_ROW_OPTION = 4;
            this.MAX_OPTIONS_PER_PAGE = 16;
            this.heightOptionsPane = AppVarUtils.getScreenDimension().getHeight() * 0.7 - padding;
        }
        double widthOptionsPane = AppVarUtils.getScreenDimension().getWidth() - padding;
        double widthOption = widthOptionsPane / (double)this.NUMBER_COLUMN_OPTION;
        double heightOption = this.heightOptionsPane / (double)this.NUMBER_ROW_OPTION;
        int index = 0;
        int index_map = 0;
        this.itemOptionsButton = new LinkedHashMap();
        this.numberPageOptions = (int)Math.ceil((double)groupOption.getItems().size() / (double)this.MAX_OPTIONS_PER_PAGE);
        this.MAX_OPTIONS = this.numberPageOptions > 1 ? this.MAX_OPTIONS_PER_PAGE - 1 : this.MAX_OPTIONS_PER_PAGE;
        for (SupplementItemInfo optionItem : groupOption.getItems()) {
            Image imageOption = this.mImagesUtils.getImageOption(optionItem, AppLocal.refOptions, "_64px", false);
            if (imageOption == null) {
                imageOption = this.imageDefaultItemOption;
            }
            OptionDetailProductButton optionButton = new OptionDetailProductButton(groupProduct, supProduct, groupOption, null, optionItem, heightOption, widthOption, imageOption, this.imageDecrease, this.imageIncrease);
            optionButton.setIndex_group_option(buttonGroupOption.getIndex());
            int indexOption = this.indexSelectedOptionIfExist(groupProduct, supProduct, optionItem);
            if (indexOption != -1) {
                OptionItemOrder optionItemOrder = this.listChoiceSupplement.get(indexOption);
                optionButton.setOptionItemOrder(optionItemOrder);
                if (optionItemOrder != null) {
                    optionButton.setQuantity(optionItemOrder.getNumberOption());
                }
                optionButton.select();
            } else {
                optionButton.deselect();
            }
            optionButton.setOnAction(this.mEventHandlerOptionAction);
            optionButton.getQuantityIncreaseButton().getProperties().put((Object)this.BUTTON_OPTION, (Object)optionButton);
            optionButton.getQuantityDecreaseButton().getProperties().put((Object)this.BUTTON_OPTION, (Object)optionButton);
            optionButton.getQuantityIncreaseButton().setOnAction(this.mEventHandlerIncreaseQttOptionAction);
            optionButton.getQuantityDecreaseButton().setOnAction(this.mEventHandlerDecreaseQttOptionAction);
            if (index < this.MAX_OPTIONS) {
                this.itemOptionsButton.put(optionItem.getiD(), optionButton);
            } else {
                this.map_options.put(index_map, this.itemOptionsButton);
                this.itemOptionsButton = new LinkedHashMap();
                this.itemOptionsButton.put(optionItem.getiD(), optionButton);
                ++index_map;
                index = 0;
            }
            ++index;
        }
        if (this.itemOptionsButton != null && !this.itemOptionsButton.isEmpty()) {
            this.map_options.put(index_map, this.itemOptionsButton);
        }
        int column = 0;
        int row = 0;
        for (int i = 0; i < this.MAX_OPTIONS; ++i) {
            GridPane itemIngredientPane = new GridPane();
            itemIngredientPane.setPrefHeight(heightOption);
            itemIngredientPane.setPrefWidth(widthOption);
            itemIngredientPane.getStyleClass().add((Object)"border_white_opacity12");
            itemIngredientPane.getStyleClass().add((Object)"border_radius_12px");
            itemIngredientPane.getStyleClass().add((Object)"bg_radius_12px");
            itemIngredientPane.getStyleClass().add((Object)"bg_white_opacity12");
            this.optionsPane.add((Node)itemIngredientPane, column, row);
            if (column < this.NUMBER_COLUMN_INGREDIENT - 1) {
                ++column;
                continue;
            }
            column = 0;
            ++row;
        }
        if (this.numberPageOptions > 1) {
            GridPane nextPreviousPane = new GridPane();
            nextPreviousPane.setAlignment(Pos.CENTER);
            nextPreviousPane.setVgap(5.0);
            nextPreviousPane.setHgap(5.0);
            nextPreviousPane.setPrefHeight(heightOption);
            nextPreviousPane.setPrefWidth(widthOption);
            nextPreviousPane.getStyleClass().add((Object)"bg_white_opacity20");
            nextPreviousPane.getStyleClass().add((Object)"border_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"bg_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"border_white_opacity12");
            this.nextItemOptionButton = new Button();
            this.nextItemOptionButton.getStyleClass().add((Object)"border_radius_14px");
            this.nextItemOptionButton.getStyleClass().add((Object)"bg_radius_14px");
            this.nextItemOptionButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.nextItemOptionButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.nextItemOptionButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.nextItemOptionButton.setGraphic((Node)new ImageView(this.imageNextItemProduct));
            this.nextItemOptionButton.setOnAction(this.mEventHandlerNextOptionAction);
            this.previousItemOptionButton = new Button();
            this.previousItemOptionButton.getStyleClass().add((Object)"border_radius_14px");
            this.previousItemOptionButton.getStyleClass().add((Object)"bg_radius_14px");
            this.previousItemOptionButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.previousItemOptionButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.previousItemOptionButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.previousItemOptionButton.setGraphic((Node)new ImageView(this.imagePreviousItemProduct));
            this.previousItemOptionButton.setOnAction(this.mEventHandlerPreviousOptionAction);
            nextPreviousPane.add((Node)this.previousItemOptionButton, 0, 0);
            nextPreviousPane.add((Node)this.nextItemOptionButton, 1, 0);
            this.optionsPane.add((Node)nextPreviousPane, column, row);
            this.previousItemOptionButton.setDisable(true);
            if (this.numberPageOptions == 1) {
                this.nextItemOptionButton.setDisable(true);
            }
        }
        this.page_options = 0;
        this.loadPageOptions(this.page_options);
        this.sendOptionsToDualScreen(groupOption);
    }

    private void loadPageOptions(int page_options) {
        LinkedHashMap<Integer, OptionDetailProductButton> mapOptionsButton = this.map_options.get(page_options);
        List optionsButton = mapOptionsButton.values().stream().collect(Collectors.toList());
        int numberOptions = optionsButton.size();
        int index = 0;
        for (Node node : this.optionsPane.getChildren()) {
            if (index >= this.MAX_OPTIONS) break;
            if (node instanceof GridPane) {
                GridPane optionPane = (GridPane)node;
                optionPane.getChildren().clear();
                if (index < numberOptions) {
                    optionPane.add((Node)optionsButton.get(index), 0, 0);
                }
            }
            ++index;
        }
    }

    public void nextOptions() {
        if (this.page_options < this.numberPageOptions - 1) {
            ++this.page_options;
            this.loadPageOptions(this.page_options);
            if (this.page_options == this.numberPageOptions - 1) {
                this.nextItemOptionButton.setDisable(true);
            }
            this.previousItemOptionButton.setDisable(false);
        }
    }

    public void previousOptions() {
        if (this.page_options > 0) {
            --this.page_options;
            this.loadPageOptions(this.page_options);
            if (this.page_options == 0) {
                this.previousItemOptionButton.setDisable(true);
            }
            this.nextItemOptionButton.setDisable(false);
        }
    }

    private void deselectOptionTabs() {
        for (OptionDetailProductTab headerButton : this.groupOptionTabs) {
            headerButton.deselect();
        }
    }

    private void selectOptionTab(OptionDetailProductTab headerButton) {
        headerButton.select();
    }

    private int indexSelectedOptionIfExist(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo option) {
        int id_group_products;
        int id_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        int found = -1;
        for (int i = 0; i < this.listChoiceSupplement.size(); ++i) {
            if (this.listChoiceSupplement.get(i).getIdCarte() != id_group_products && (id_group_products != -1 || this.listChoiceSupplement.get(i).getIdCarte() != 0) || this.listChoiceSupplement.get(i).getIdProduct() != id_product && (id_product != -1 || this.listChoiceSupplement.get(i).getIdProduct() != 0) || this.listChoiceSupplement.get(i).getSupplement() != option.getiD() || this.listChoiceSupplement.get(i).getIndex_carte() != index_group_products || this.listChoiceSupplement.get(i).getParent_supplement_id() != 0) continue;
            found = i;
            break;
        }
        return found;
    }

    public void selectOption(OptionDetailProductButton buttonOption) {
        ProductInfoExt subProduct;
        SupplementItemInfo optionItem = buttonOption.getOption();
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        int indexOption = this.indexSelectedOptionIfExist(groupProducts, subProduct = buttonOption.getSubProduct(), optionItem);
        if (indexOption == -1) {
            boolean option_freeable;
            SupplementProduct groupOption = buttonOption.getGroupOption();
            boolean bl = option_freeable = groupOption.isFree_able() && optionItem.getPrice_order() > 0.0 && groupOption.getOption_free() > groupOption.getOrderSupplement();
            if (option_freeable) {
                this.makeItemFree = false;
                this.make_items_free_button.setStyle(this.styleMakeFreeItem);
            }
            this.addOption(buttonOption);
        }
    }

    private int sizeOptions(OptionDetailProductButton buttonOption) {
        int id_group_products;
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        ProductInfoExt subProduct = buttonOption.getSubProduct();
        SupplementProduct groupOption = buttonOption.getGroupOption();
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        int size = 0;
        for (OptionItemOrder optionItem : this.listChoiceSupplement) {
            if (optionItem.getIdCarte() != id_group_products && (id_group_products != -1 || optionItem.getIdCarte() != 0) || optionItem.getIdProduct() != id_sub_product && (id_sub_product != -1 || optionItem.getIdProduct() != 0) || optionItem.getId_groupe_option() != groupOption.getiD() || optionItem.getIndex_carte() != index_group_products || optionItem.getParent_supplement_id() != 0) continue;
            size += optionItem.getNumberOption();
        }
        return size;
    }

    private void addOption(OptionDetailProductButton buttonOption) {
        String id_global_group_products;
        int id_group_products;
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        ProductInfoExt subProduct = buttonOption.getSubProduct();
        SupplementProduct groupOption = buttonOption.getGroupOption();
        SupplementItemInfo optionItem = buttonOption.getOption();
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        String name_group_products = groupProducts != null ? groupProducts.getName() : null;
        String name_sub_product = subProduct != null ? subProduct.getName() : null;
        String ref_sub_product = subProduct != null ? subProduct.getRef_web() : null;
        String ref_group_products = groupProducts != null ? groupProducts.getRef_web() : null;
        String id_global_sub_product = subProduct != null ? subProduct.getId_global() : null;
        String string = id_global_group_products = groupProducts != null ? groupProducts.getId_global() : null;
        if (this.listChoiceSupplement.size() > 0 && groupOption.getHas_options().booleanValue() && groupOption.getMax_options() == this.sizeOptions(buttonOption)) {
            this.deleteLastOption(groupProducts, subProduct, groupOption);
        }
        double price = 0.0;
        int number_free = 0;
        if (this.makeItemFree || this.isOptionFreeable(groupOption) && optionItem.getPrice_order() > 0.0) {
            price = 0.0;
            number_free = 1;
            this.makeItemFree = !this.isOptionFreeable(groupOption) || !(optionItem.getPrice_order() > 0.0);
        } else {
            number_free = 0;
            price = optionItem.getPrice_order();
        }
        OptionItemOrder optionItemOrder = new OptionItemOrder(id_group_products, id_sub_product, optionItem.getiD(), optionItem.getName(), name_sub_product, name_group_products, 1, groupOption.getIsBold(), price, index_group_products, number_free, groupOption.isSeparate(), null, groupOption.isMultiple_category(), groupOption.isDisplay_free(), groupOption.getiD(), this.makeItemFree, groupOption.getPrinter(), groupOption.getShift_option(), groupOption.isDisplay_screen_sorti(), this.getColor(optionItem, groupOption), optionItem, groupOption.isNo_printable(), groupOption.getName(), groupOption.isPrint_black_background(), ref_sub_product, ref_group_products, id_global_sub_product, id_global_group_products);
        optionItemOrder.setImageSupplement(buttonOption.getImageItem());
        this.listChoiceSupplement.add(optionItemOrder);
        buttonOption.setOptionItemOrder(optionItemOrder);
        if (!this.makeItemFree) {
            this.decrementOptionFree(groupOption);
        }
        this.next_option = this.listChoiceSupplement.size() > 0 && groupOption.getHas_options() != false && groupOption.getMax_options() == this.sizeOptions(buttonOption);
        System.out.println("next_option : " + this.next_option);
        if (optionItem.getGroupsSubSupplement() != null && !optionItem.getGroupsSubSupplement().isEmpty()) {
            this.loadSubSupplements(buttonOption);
        } else if (this.next_option) {
            this.nextOption(buttonOption);
        }
        this.makeItemFree = false;
        this.make_items_free_button.setStyle(this.styleMakeFreeItem);
        buttonOption.setQuantity(1);
        buttonOption.select();
        this.sendSelectedOptionToDualScreen(optionItem);
        this.setPriceTotal();
        if (groupOption.getNumber_click() == 1 || groupOption.getMax_options() == 1) {
            // empty if block
        }
    }

    private OptionItemOrder lastOption(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementProduct groupOption) {
        int id_group_products;
        int group_option = groupOption.getiD();
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        OptionItemOrder optionItem = null;
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            if (optionItemOrder.getParent_supplement_id() != 0 || optionItemOrder.getId_groupe_option() != group_option || optionItemOrder.getIdCarte() != id_group_products || optionItemOrder.getIdProduct() != id_sub_product || optionItemOrder.getIndex_carte() != index_group_products) continue;
            optionItem = optionItemOrder;
        }
        return optionItem;
    }

    private void decreaseQttOption(OptionDetailProductButton buttonOption, OptionItemOrder itemToUpdate) {
        if (itemToUpdate.getNumber_free() == itemToUpdate.getNumberOption()) {
            if (!itemToUpdate.isForce_free()) {
                this.incrementOptionFree(buttonOption.getGroupOption(), 1);
            }
            this.calculFreeAfterDelete(buttonOption);
            itemToUpdate.setNumber_free(itemToUpdate.getNumber_free() - 1);
            itemToUpdate.setNumberOption(itemToUpdate.getNumberOption() - 1);
        } else {
            itemToUpdate.setNumberOption(itemToUpdate.getNumberOption() - 1);
            if (buttonOption.getOption() != null) {
                itemToUpdate.setPrice(buttonOption.getOption().getPrice_order(), itemToUpdate.getNumberOption() - itemToUpdate.getNumber_free());
            }
        }
        buttonOption.setQuantity(itemToUpdate.getNumberOption());
        buttonOption.getQuantityIncreaseButton().setOpacity(1.0);
        buttonOption.checkFreeAndSetStyle();
        this.setPriceTotal();
    }

    private void deleteLastOption(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementProduct groupOption) {
        OptionItemOrder itemToDelete = this.lastOption(groupProducts, subProduct, groupOption);
        if (itemToDelete != null) {
            OptionDetailProductButton buttonOption = null;
            for (LinkedHashMap<Integer, OptionDetailProductButton> listButtons : this.map_options.values()) {
                if (listButtons.get(itemToDelete.getSupplement()) == null) continue;
                buttonOption = listButtons.get(itemToDelete.getSupplement());
                break;
            }
            if (buttonOption != null) {
                if (itemToDelete.getNumberOption() > 1) {
                    this.decreaseQttOption(buttonOption, itemToDelete);
                } else {
                    this.deleteOption(buttonOption, itemToDelete);
                }
            }
        }
    }

    private void sendDeSelectedOptionToDualScreen(SupplementItemInfo option) {
        System.out.println("+++ sent_de: " + option.getiD());
        if (this.typeDisplay != null && this.typeDisplay.startsWith("window")) {
            this.prepareLines();
            AppLocal.displayDualScreen.deselectOption(option);
        }
    }

    private void deleteOption(OptionDetailProductButton buttonOtion, OptionItemOrder itemToDelete) {
        if (itemToDelete.getNumber_free() > 0) {
            this.incrementOptionFree(buttonOtion.getGroupOption(), itemToDelete.getNumber_free());
            if (!itemToDelete.isForce_free()) {
                this.incrementOptionFree(buttonOtion.getGroupOption(), 1);
            }
            this.listChoiceSupplement.remove(itemToDelete);
            this.calculFreeAfterDelete(buttonOtion);
        } else {
            this.listChoiceSupplement.remove(itemToDelete);
        }
        if (buttonOtion.getOption() != null) {
            // empty if block
        }
        this.sendDeSelectedOptionToDualScreen(buttonOtion.getOption());
        buttonOtion.deselect();
        this.deleteSubOptions(buttonOtion);
        this.setPriceTotal();
    }

    private void sendSelectedOptionToDualScreen(SupplementItemInfo option) {
        System.out.println("+++ sent: " + option.getiD());
        if (this.typeDisplay != null && this.typeDisplay.startsWith("window")) {
            this.prepareLines();
            AppLocal.displayDualScreen.selectOption(option);
        }
    }

    private void nextOption(OptionDetailProductButton buttonOption) {
        int index_group_option = buttonOption.getIndex_group_option();
        if (this.groupOptionTabs != null && !this.groupOptionTabs.isEmpty()) {
            int index_group_option_next = index_group_option + 1;
            if (index_group_option_next < this.groupOptionTabs.size()) {
                int page = (int)Math.ceil((double)(index_group_option_next + 1) / (double)this.MAX_OPTIONS_TABS);
                if (--page > this.page_options_tabs) {
                    this.nextGroupOption();
                } else {
                    OptionDetailProductTab buttonGroupOption = this.groupOptionTabs.get(index_group_option_next);
                    this.loadDetailGroupOption(buttonGroupOption);
                }
            } else {
                int index_header_tab = -1;
                if (buttonOption.getGroupProducts() != null) {
                    for (HeaderDetailProductButton groupTab : this.groupTabs) {
                        if (groupTab == null || !groupTab.getGroup_type().equalsIgnoreCase(STR_GROUP_PRODUCTS) || ((CarteOrderInfo)groupTab.getGroupItem()).getId() != buttonOption.getGroupProducts().getId() || ((CarteOrderInfo)groupTab.getGroupItem()).getIndex_carte() != buttonOption.getGroupProducts().getIndex_carte()) continue;
                        index_header_tab = groupTab.getIndex();
                        break;
                    }
                } else if (buttonOption.getSubProduct() != null) {
                    for (HeaderDetailProductButton groupTab : this.groupTabs) {
                        if (groupTab == null || !groupTab.getGroup_type().equalsIgnoreCase(STR_SUB_PRODUCT) || ((ProductInfoExt)groupTab.getGroupItem()).getID() != buttonOption.getSubProduct().getID() || ((ProductInfoExt)groupTab.getGroupItem()).getIndex_sub_product() != buttonOption.getSubProduct().getIndex_sub_product()) continue;
                        index_header_tab = groupTab.getIndex();
                        break;
                    }
                }
                if (index_header_tab != -1 && ++index_header_tab <= this.groupTabs.size()) {
                    int index = index_header_tab;
                    int page = (int)Math.ceil((double)index / (double)this.NUMBER_DETAIL_PRODUCT_TAB);
                    if (--page != this.page_detail_product_header && page < this.numberPageDetailProductHeader) {
                        this.page_detail_product_header = page;
                        this.header_detail_product_pane.getChildren().clear();
                        this.header_detail_product_pane.add((Node)this.headerDetailProductArray[this.page_detail_product_header], 0, 0);
                        if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                            this.next_detail_header.setDisable(true);
                        }
                        this.previous_detail_header.setDisable(false);
                    }
                    HeaderDetailProductButton nextGroupTab = null;
                    for (HeaderDetailProductButton groupTab : this.groupTabs) {
                        if (groupTab.getIndex() != index_header_tab) continue;
                        nextGroupTab = groupTab;
                    }
                    this.loadHeaderTab(nextGroupTab);
                }
            }
        }
    }

    private void increaseQttOption(OptionDetailProductButton buttonOption) {
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        ProductInfoExt subProduct = buttonOption.getSubProduct();
        SupplementItemInfo optionItem = buttonOption.getOption();
        SupplementProduct groupOption = buttonOption.getGroupOption();
        int indexOption = this.indexSelectedOptionIfExist(groupProducts, subProduct, optionItem);
        if (indexOption != -1) {
            int number = this.listChoiceSupplement.get(indexOption).getNumberOption();
            if (number < groupOption.getNumber_click() && number < groupOption.getMax_options()) {
                OptionItemOrder lastOption = this.lastOption(groupProducts, subProduct, groupOption);
                boolean same_option = false;
                boolean delete_last_option = false;
                if (lastOption != null && lastOption.getSupplement() == this.listChoiceSupplement.get(indexOption).getSupplement() && lastOption.getIdProduct() == this.listChoiceSupplement.get(indexOption).getIdProduct() && lastOption.getIdCarte() == this.listChoiceSupplement.get(indexOption).getIdCarte() && lastOption.getIndex_carte() == this.listChoiceSupplement.get(indexOption).getIndex_carte()) {
                    same_option = true;
                }
                if (this.listChoiceSupplement.size() > 0 && groupOption.getHas_options().booleanValue() && groupOption.getMax_options() == this.sizeOptions(buttonOption)) {
                    delete_last_option = true;
                }
                if (!same_option && delete_last_option) {
                    this.deleteLastOption(groupProducts, subProduct, groupOption);
                }
                if (!same_option || !delete_last_option) {
                    int numberFree = this.listChoiceSupplement.get(indexOption).getNumber_free();
                    if (this.isOptionFreeable(groupOption) && optionItem.getPrice_order() > 0.0) {
                        this.listChoiceSupplement.get(indexOption).setNumber_free(++numberFree);
                        this.decrementOptionFree(groupOption);
                    }
                    this.listChoiceSupplement.get(indexOption).setNumberOption(++number);
                    this.listChoiceSupplement.get(indexOption).setPrice(optionItem.getPrice_order(), number - numberFree);
                    if (this.listChoiceSupplement.size() > 0 && groupOption.getHas_options().booleanValue() && groupOption.getMax_options() == this.sizeOptions(buttonOption)) {
                        this.nextOption(buttonOption);
                    }
                }
                buttonOption.setQuantity(number);
                buttonOption.checkFreeAndSetStyle();
                this.setPriceTotal();
            } else {
                double heightPopUp = 150.0;
                double widthPopUp = 500.0;
                BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
                this.main_pane.setEffect((Effect)blur);
                if (this.errorLimitationPopUp == null) {
                    this.errorLimitationPopUp = new ErrorLimitationPopUp(heightPopUp, widthPopUp, groupOption);
                    this.errorLimitationPopUp.setOnHidden(this.mEventHandlerErrorLimitationPopUpHide);
                }
                Dimension screenDimension = AppVarUtils.getScreenDimension();
                this.errorLimitationPopUp.setX((screenDimension.getWidth() - widthPopUp) / 2.0);
                this.errorLimitationPopUp.setY((screenDimension.getHeight() - heightPopUp) / 2.0);
                this.errorLimitationPopUp.show(this.stage.getOwner());
            }
            if (number >= groupOption.getNumber_click() || number >= groupOption.getMax_options()) {
                // empty if block
            }
        }
    }

    private void decreaseQttOption(OptionDetailProductButton buttonOption) {
        SupplementItemInfo optionItem;
        ProductInfoExt subProduct;
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        int indexOption = this.indexSelectedOptionIfExist(groupProducts, subProduct = buttonOption.getSubProduct(), optionItem = buttonOption.getOption());
        if (indexOption != -1) {
            OptionItemOrder optionToDelete = this.listChoiceSupplement.get(indexOption);
            if (optionToDelete.getNumberOption() > 1) {
                this.decreaseQttOption(buttonOption, optionToDelete);
            } else {
                this.deleteOption(buttonOption, optionToDelete);
            }
        }
    }

    public void setMakeItemFree() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else {
            this.makeItemFree = true;
            this.make_items_free_button.setStyle(this.styleMakeFreeItemSelected);
        }
    }

    public void loadPopUpTypeOrder() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else {
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.main_pane.setEffect((Effect)blur);
            double heightPopUp = 200.0;
            double widthPopUp = 400.0;
            if (this.typeOrderPopUp == null) {
                this.typeOrderPopUp = new TypeOrderPopUp(heightPopUp, widthPopUp, this.type_line);
                this.typeOrderPopUp.setOnHidden(this.mEventHandlerPopUpTypeorderHide);
            }
            Dimension screenDimension = AppVarUtils.getScreenDimension();
            this.typeOrderPopUp.setX((screenDimension.getWidth() - widthPopUp) / 2.0);
            this.typeOrderPopUp.setY((screenDimension.getHeight() - heightPopUp) / 2.0);
            this.typeOrderPopUp.show(this.stage.getOwner());
        }
    }

    private void setTypeLine() {
        try {
            if (this.type_line != null) {
                switch (this.type_line) {
                    case "Sur Place": {
                        this.setTypeLineDineIn();
                        break;
                    }
                    case "A Emporter": {
                        this.setTypeLineTakeAway();
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void setTypeLineDineIn() throws URISyntaxException {
        this.imageDineInLine = new Image(this.getClass().getResource("/com/openbravo/images/at_spot_line.png").toURI().toString(), 30.0, 30.0, false, false);
        this.type_order_button.setGraphic((Node)new ImageView(this.imageDineInLine));
        this.type_order_button.setStyle(this.styleDineIn);
    }

    private void setTypeLineTakeAway() throws URISyntaxException {
        this.imageTakeAwayLine = new Image(this.getClass().getResource("/com/openbravo/images/take_away_line.png").toURI().toString(), 30.0, 30.0, false, false);
        this.type_order_button.setGraphic((Node)new ImageView(this.imageTakeAwayLine));
        this.type_order_button.setStyle(this.styleTakeAway);
    }

    private int indexSubProductIfExist(ProductInfoExt item, CarteOrderInfo groupProduct) {
        int indexSubProduct = -1;
        for (int i = 0; i < this.listProducts.size(); ++i) {
            if (this.listProducts.get(i).getIdProduct() != item.getID() || this.listProducts.get(i).getIdCarte() != groupProduct.getId() || this.listProducts.get(i).getIndex_carte() != groupProduct.getIndex_carte()) continue;
            indexSubProduct = i;
            break;
        }
        return indexSubProduct;
    }

    private void loadProductsFamille(CarteOrderInfo groupProducts) {
        this.productsFamillePane.getChildren().clear();
        if (this.map_products_famille == null) {
            this.map_products_famille = new HashMap();
        }
        this.map_products_famille.clear();
        double padding = 50.0;
        double heightProductsFamillePane = AppVarUtils.getScreenDimension().getHeight() * 0.24 - padding;
        double widthProductsFamillePane = AppVarUtils.getScreenDimension().getWidth() - padding;
        double widthProductFamille = widthProductsFamillePane / (double)this.NUMBER_COLUMN_PRODUCT_FAMILLE;
        double heightProductFamille = heightProductsFamillePane / (double)this.NUMBER_ROW_PRODUCT_FAMILLE;
        int index = 0;
        int index_map = 0;
        int index_sub_product = 0;
        ProductFamilleButton productButtonSelected = null;
        int numberProducts = groupProducts.getItems().size();
        this.productsFamilleButtons = new LinkedHashMap();
        this.MAX_PRODUCT_FAMILLE = numberProducts > this.MAX_PRODUCT_FAMILLE_PER_PAGE ? this.MAX_PRODUCT_FAMILLE_PER_PAGE - 1 : this.MAX_PRODUCT_FAMILLE_PER_PAGE;
        this.numberPageProductsFamille = (int)Math.ceil((double)numberProducts / (double)this.MAX_PRODUCT_FAMILLE);
        for (ProductInfoExt productFamille : groupProducts.getItems()) {
            Image image = this.mImagesUtils.getImageProduct(productFamille, AppLocal.refProducts, "_128px", false);
            if (image == null) {
                image = this.imageDefaultItemOption;
            }
            ProductFamilleButton productButton = new ProductFamilleButton(groupProducts, productFamille, widthProductFamille, heightProductFamille, image, index_sub_product++);
            int indexOption = this.indexSubProductIfExist(productFamille, groupProducts);
            if (indexOption != -1) {
                productButton.select();
                productButtonSelected = productButton;
            } else {
                productButton.deselect();
            }
            productButton.setOnMouseClicked(this.mEventHandlerProductFamilleMouseClick);
            if (index < this.MAX_PRODUCT_FAMILLE) {
                this.productsFamilleButtons.put(productFamille.getID(), productButton);
            } else {
                this.map_products_famille.put(index_map, this.productsFamilleButtons);
                this.productsFamilleButtons = new LinkedHashMap();
                this.productsFamilleButtons.put(productFamille.getID(), productButton);
                ++index_map;
                index = 0;
            }
            ++index;
        }
        if (this.productsFamilleButtons != null && !this.productsFamilleButtons.isEmpty()) {
            this.map_products_famille.put(index_map, this.productsFamilleButtons);
        }
        int column = 0;
        int row = 0;
        for (int i = 0; i < this.MAX_PRODUCT_FAMILLE; ++i) {
            GridPane productFamillePane = new GridPane();
            productFamillePane.setPrefHeight(heightProductFamille);
            productFamillePane.setPrefWidth(widthProductFamille);
            productFamillePane.setStyle(this.styleProductFamille);
            this.productsFamillePane.add((Node)productFamillePane, column, row);
            if (column < this.NUMBER_COLUMN_PRODUCT_FAMILLE - 1) {
                ++column;
                continue;
            }
            column = 0;
            ++row;
        }
        if (this.numberPageProductsFamille > 1) {
            GridPane nextPreviousPane = new GridPane();
            nextPreviousPane.setAlignment(Pos.CENTER);
            nextPreviousPane.setVgap(5.0);
            nextPreviousPane.setHgap(5.0);
            nextPreviousPane.setPrefHeight(heightProductFamille);
            nextPreviousPane.setPrefWidth(widthProductFamille);
            nextPreviousPane.getStyleClass().add((Object)"bg_white_opacity20");
            nextPreviousPane.getStyleClass().add((Object)"border_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"bg_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"border_white_opacity12");
            this.nextProductFamilleButton = new Button();
            this.nextProductFamilleButton.getStyleClass().add((Object)"border_radius_14px");
            this.nextProductFamilleButton.getStyleClass().add((Object)"bg_radius_14px");
            this.nextProductFamilleButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.nextProductFamilleButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.nextProductFamilleButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.nextProductFamilleButton.setGraphic((Node)new ImageView(this.imageNextItemProduct));
            this.nextProductFamilleButton.setOnAction(this.mEventHandlerNextProductFamilleAction);
            this.previousProductFamilleButton = new Button();
            this.previousProductFamilleButton.getStyleClass().add((Object)"border_radius_14px");
            this.previousProductFamilleButton.getStyleClass().add((Object)"bg_radius_14px");
            this.previousProductFamilleButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.previousProductFamilleButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.previousProductFamilleButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.previousProductFamilleButton.setGraphic((Node)new ImageView(this.imagePreviousItemProduct));
            this.previousProductFamilleButton.setOnAction(this.mEventHandlerPreviousProductFamilleAction);
            nextPreviousPane.add((Node)this.previousProductFamilleButton, 0, 0);
            nextPreviousPane.add((Node)this.nextProductFamilleButton, 1, 0);
            this.productsFamillePane.add((Node)nextPreviousPane, column, row);
            this.previousProductFamilleButton.setDisable(true);
        }
        this.page_products_famille = 0;
        this.loadPageProductsFamille(this.page_products_famille);
        this.detail_pane.getChildren().clear();
        this.detail_pane.add((Node)this.productsFamillePane, 0, 0);
        this.detail_pane.add((Node)this.optionTabsPages, 0, 1);
        this.detail_pane.add((Node)this.optionsPane, 0, 2);
        this.optionTabsPages.getChildren().clear();
        this.optionsPane.getChildren().clear();
        this.optionsPane.setStyle("");
        if (productButtonSelected != null) {
            this.loadSelectedSubProduct(productButtonSelected);
        }
    }

    public void nextProductsFamille() {
        if (this.page_products_famille < this.numberPageProductsFamille - 1) {
            ++this.page_products_famille;
            this.loadPageProductsFamille(this.page_products_famille);
            if (this.page_products_famille == this.numberPageProductsFamille - 1) {
                this.nextProductFamilleButton.setDisable(true);
            }
            this.previousProductFamilleButton.setDisable(false);
        }
    }

    public void previousProductsFamille() {
        if (this.page_products_famille > 0) {
            --this.page_products_famille;
            this.loadPageProductsFamille(this.page_products_famille);
            if (this.page_products_famille == 0) {
                this.previousProductFamilleButton.setDisable(true);
            }
            this.nextProductFamilleButton.setDisable(false);
        }
    }

    private void loadPageProductsFamille(int page_products_famille) {
        LinkedHashMap<Integer, ProductFamilleButton> mapProductFamilleButton = this.map_products_famille.get(page_products_famille);
        List productsFamilleButton = mapProductFamilleButton.values().stream().collect(Collectors.toList());
        int numberProductsFamille = productsFamilleButton.size();
        int index = 0;
        for (Node node : this.productsFamillePane.getChildren()) {
            if (index >= this.MAX_PRODUCT_FAMILLE) break;
            if (node instanceof GridPane) {
                GridPane productFamillePane = (GridPane)node;
                productFamillePane.getChildren().clear();
                if (index < numberProductsFamille) {
                    productFamillePane.add((Node)productsFamilleButton.get(index), 0, 0);
                }
            }
            ++index;
        }
    }

    private boolean isItemOfGroupProductsAlreadyAdded(CarteOrderInfo groupProducts) {
        int id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : -1;
        boolean itemAdded = false;
        for (int i = 0; i < this.listProducts.size(); ++i) {
            if (this.listProducts.get(i).getIdCarte() != id_group_products || this.listProducts.get(i).getIndex_carte() != index_group_products) continue;
            itemAdded = true;
        }
        return itemAdded;
    }

    public void selectProductFamille(ProductFamilleButton buttonProdutFamille) {
        int id_group_products;
        System.out.println("+++++++++ select_family_1");
        CarteOrderInfo groupProducts = buttonProdutFamille.getGroupProduct();
        ProductInfoExt productFamille = buttonProdutFamille.getProduct();
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (productFamille != null ? productFamille.getIndex_sub_product() : -1);
        String name_group_products = groupProducts != null ? groupProducts.getName() : null;
        String id_global_carte = groupProducts != null ? groupProducts.getId_global() : null;
        String ref_carte = groupProducts != null ? groupProducts.getRef_web() : null;
        String size_group_products = groupProducts != null && groupProducts.getSizeCarte() != null && !groupProducts.getSizeCarte().isEmpty() ? groupProducts.getSizeCarte() : this.name_sizeProduct;
        boolean itemAdded = this.isItemOfGroupProductsAlreadyAdded(groupProducts);
        int index_product_item = this.indexSubProductIfExist(productFamille, groupProducts);
        if (!itemAdded && index_product_item == -1) {
            ProductTicket productTicket = new ProductTicket(productFamille, id_group_products, name_group_products, 1, index_group_products, this.name_sizeProduct, productFamille.getRef_web(), ref_carte, id_global_carte);
            this.listProducts.add(productTicket);
            this.currentProductTicket = productTicket;
            buttonProdutFamille.select();
            this.loadInfoProduct(productFamille, size_group_products, groupProducts);
            this.loadOptionsTabs_GroupProduct(groupProducts, productFamille);
            productTicket.setOptions(productFamille.getSupplements());
        }
        if (index_product_item != -1) {
            this.currentProductTicket = this.listProducts.get(index_product_item);
            this.loadInfoProduct(productFamille, size_group_products, groupProducts);
            this.loadOptionsTabs_GroupProduct(groupProducts, productFamille);
        }
        this.setPriceTotal();
    }

    public void checkAndDeleteProductFamille(ProductFamilleButton buttonProdutFamille) {
        int id_group_products;
        CarteOrderInfo groupProducts = buttonProdutFamille.getGroupProduct();
        ProductInfoExt productFamille = buttonProdutFamille.getProduct();
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (productFamille != null ? productFamille.getIndex_sub_product() : -1);
        int index_product_item = this.indexSubProductIfExist(productFamille, groupProducts);
        if (index_product_item != -1) {
            this.listProducts.remove(index_product_item);
            buttonProdutFamille.deselect();
            ArrayList<OptionItemOrder> listSupplement = new ArrayList<OptionItemOrder>();
            ArrayList<ItemOrderInfo> listIngredient = new ArrayList<ItemOrderInfo>();
            listSupplement.addAll(this.listChoiceSupplement);
            listIngredient.addAll(this.listChoiceIngredient);
            boolean delete = false;
            for (ItemOrderInfo ingredient : this.listChoiceIngredient) {
                if (ingredient.getIdCarte() != id_group_products || ingredient.getIdProduct() != productFamille.getID() || ingredient.getIndex_carte() != index_group_products) continue;
                listIngredient.remove(ingredient);
                delete = true;
            }
            for (OptionItemOrder supplement : this.listChoiceSupplement) {
                if (supplement.getIdCarte() != id_group_products || supplement.getIdProduct() != productFamille.getID() || supplement.getIndex_carte() != index_group_products) continue;
                listSupplement.remove(supplement);
                delete = true;
            }
            if (delete) {
                this.listChoiceSupplement.clear();
                this.listChoiceSupplement.addAll(listSupplement);
                this.listChoiceIngredient.clear();
                this.listChoiceIngredient.addAll(listIngredient);
            }
            this.optionTabsPages.getChildren().clear();
            this.optionsPane.getChildren().clear();
            this.optionsPane.setStyle("");
            this.setPriceTotal();
        }
    }

    private void loadInfoProduct(ProductInfoExt subProduct, String size_group_products, CarteOrderInfo groupProducts) {
        try {
            int index_group_products;
            int id_group_products;
            int id_sub_product = subProduct != null ? subProduct.getID() : -1;
            int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
            int n2 = groupProducts != null ? groupProducts.getIndex_carte() : (index_group_products = subProduct != null ? subProduct.getIndex_sub_product() : -1);
            if (subProduct.getIngredients().isEmpty()) {
                List<SupplementItemInfo> ingredientsItem = this.dlSales.getIngredientsByProducts(subProduct.getID(), true, false);
                subProduct.setIngredients(ingredientsItem);
            }
            if (subProduct.getSupplements().isEmpty()) {
                List<SupplementProduct> optionsProduct = this.dlItems.getSupplementsByProduct(subProduct.getID(), false, true);
                subProduct.setSupplements(optionsProduct);
                for (SupplementProduct supplement : subProduct.getSupplements()) {
                    List<SupplementItemInfo> optionsItem = this.dlItems.getSuppelementsItem(supplement.getiD(), true);
                    if (optionsItem.size() <= 0) continue;
                    ArrayList<SupplementItemInfo> optionsItemToAdd = new ArrayList<SupplementItemInfo>();
                    for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
                        if (supplement.getiD() != optionItemOrder.getId_groupe_option() || id_sub_product != optionItemOrder.getIdProduct() || id_group_products != optionItemOrder.getIdCarte() || index_group_products != optionItemOrder.getIndex_carte()) continue;
                        supplement.setOption_free_tmp(supplement.getOption_free_tmp() + optionItemOrder.getNumber_free());
                    }
                    for (SupplementItemInfo item : optionsItem) {
                        double price_option = item.getPriceOption(size_group_products, this.type_order);
                        if (this.product.isMany_size() && item.isMany_size() && price_option == -1.0) continue;
                        item.setPrice_order(price_option);
                        optionsItemToAdd.add(item);
                    }
                    supplement.setItems(optionsItemToAdd);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void loadDetailSubProduct(ProductInfoExt subProduct) {
        this.loadInfoProduct(subProduct, this.name_sizeProduct, null);
        this.loadOptionsTabs_DirectSubProduct(subProduct);
    }

    private void loadIngredients() {
        this.NUMBER_COLUMN_INGREDIENT = 4;
        this.NUMBER_ROW_INGREDIENT = 5;
        this.MAX_INGREDIENTS_PER_PAGE = 19;
        this.heightIngredientsPane = AppVarUtils.getScreenDimension().getHeight() * 0.8;
        this.loadIngredients(null, null, this.ingredientsPane);
        this.detail_pane.getChildren().clear();
        this.detail_pane.add((Node)this.ingredientsPane, 0, 0);
    }

    private void loadIngredients_SubProduct(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementProduct groupOption) {
        if (groupProducts != null) {
            this.NUMBER_COLUMN_INGREDIENT = 4;
            this.NUMBER_ROW_INGREDIENT = 3;
            this.MAX_INGREDIENTS_PER_PAGE = 11;
            this.heightIngredientsPane = AppVarUtils.getScreenDimension().getHeight() * 0.5 - 40.0;
        } else {
            this.NUMBER_COLUMN_INGREDIENT = 4;
            this.NUMBER_ROW_INGREDIENT = 4;
            this.MAX_INGREDIENTS_PER_PAGE = 15;
            this.heightIngredientsPane = AppVarUtils.getScreenDimension().getHeight() * 0.7 - 50.0;
        }
        this.optionsPane.setStyle("-fx-background-color: #333645; -fx-background-radius: 0px 0px 11px 11px;");
        this.loadIngredients(groupProducts, subProduct, this.optionsPane);
    }

    public void loadPopUpRecapOrder() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else {
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.header_pane.setEffect((Effect)blur);
            this.detail_pane.setEffect((Effect)blur);
            double heightPopUp = AppVarUtils.getScreenDimension().getHeight() * 0.6;
            double widthPopUp = AppVarUtils.getScreenDimension().getWidth() * 0.35;
            if (this.recapOrderPopUp == null) {
                this.recapOrderPopUp = new RecapOrderPopUp(heightPopUp, widthPopUp);
                this.recapOrderPopUp.setOnHidden(this.mEventHandlerPopUpRecaporderHide);
            }
            for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
                if (optionItemOrder.getImageSupplement() != null) continue;
                Image imageOption = this.mImagesUtils.getImageOption(optionItemOrder, AppLocal.refOptions, "_64px", false);
                if (imageOption == null) {
                    imageOption = this.imageDefaultItemOption;
                }
                optionItemOrder.setImageSupplement(imageOption);
            }
            for (ItemOrderInfo itemOrderInfo : this.listChoiceIngredient) {
                if (itemOrderInfo.getImageIngredient() != null) continue;
                Image imageIngredient = this.mImagesUtils.getImageIngredients(itemOrderInfo, AppLocal.refIngredients, "_64px", false);
                if (imageIngredient == null) {
                    imageIngredient = this.imageDefaultItemOption;
                }
                itemOrderInfo.setImageIngredient(imageIngredient);
            }
            for (ProductTicket subProduct : this.listProducts) {
                if (subProduct.getImageProduct() != null) continue;
                Image imageProduct = this.mImagesUtils.getImageProduct(subProduct, AppLocal.refProducts, "_64px", false);
                if (imageProduct == null) {
                    imageProduct = this.imageDefaultItemOption;
                }
                subProduct.setImageProduct(imageProduct);
            }
            this.recapOrderPopUp.init(this.product, this.priceProduct, this.multiply, this.name_sizeProduct, this.listChoiceSupplement, this.listChoiceIngredient, this.listProducts, this.noteValue);
            this.recapOrderPopUp.setX(10.0);
            this.recapOrderPopUp.setY(AppVarUtils.getScreenDimension().getHeight() * 0.3);
            this.recapOrderPopUp.show(this.stage.getOwner());
            this.recap_icon.setGraphic((Node)new ImageView(this.imageRecapTriangleInverse));
        }
    }

    private void loadHeaderTab(HeaderDetailProductButton firstButton) {
        if (firstButton != null) {
            switch (firstButton.getGroup_type()) {
                case "ingredients": {
                    this.deselectHeaderTabs();
                    this.selectHeaderTab(firstButton);
                    this.loadIngredients();
                    break;
                }
                case "sub_product": {
                    this.deselectHeaderTabs();
                    this.selectHeaderTab(firstButton);
                    if (firstButton.getGroupItem() == null || !(firstButton.getGroupItem() instanceof ProductInfoExt)) break;
                    ProductInfoExt subProduct = (ProductInfoExt)firstButton.getGroupItem();
                    this.loadDetailSubProduct(subProduct);
                    break;
                }
                case "group_products": {
                    this.deselectHeaderTabs();
                    this.selectHeaderTab(firstButton);
                    if (firstButton.getGroupItem() == null || !(firstButton.getGroupItem() instanceof CarteOrderInfo)) break;
                    CarteOrderInfo groupProducts = (CarteOrderInfo)firstButton.getGroupItem();
                    this.loadProductsFamille(groupProducts);
                    break;
                }
                case "options": {
                    this.deselectHeaderTabs();
                    this.selectHeaderTab(firstButton);
                    this.loadOptionsTabs_Product();
                }
            }
        }
    }

    public void loadDisounts() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else {
            if (this.reductions == null) {
                this.reductions = this.mReductionService.getReductions();
            }
            if (this.reductions != null) {
                BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
                this.main_pane.setEffect((Effect)blur);
                double heightPopUp = AppVarUtils.getScreenDimension().getHeight() * 0.6;
                double widthPopUp = AppVarUtils.getScreenDimension().getWidth() * 0.6;
                if (this.discountsProductPopUp == null) {
                    this.discountsProductPopUp = new DiscountsProductPopUp(heightPopUp, widthPopUp, this.reductions);
                    this.discountsProductPopUp.setOnHidden(this.mEventHandlerPopUpDiscounts);
                }
                ReductionInfo reduction = new ReductionInfo();
                reduction.setType(this.typeDiscount);
                reduction.setReduction(this.discountValue);
                reduction.setName(this.labelDiscount);
                this.discountsProductPopUp.setReduction(reduction);
                this.discountsProductPopUp.buildDiscountPane();
                Dimension screenDimension = AppVarUtils.getScreenDimension();
                this.discountsProductPopUp.setX((screenDimension.getWidth() - widthPopUp) / 2.0);
                this.discountsProductPopUp.setY((screenDimension.getHeight() - heightPopUp) / 2.0);
                this.discountsProductPopUp.show(this.stage.getOwner());
            }
        }
    }

    public void loadComments() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else {
            BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
            this.main_pane.setEffect((Effect)blur);
            double heightPopUp = AppVarUtils.getScreenDimension().getHeight() * 0.8;
            double widthPopUp = AppVarUtils.getScreenDimension().getWidth() * 0.9;
            if (this.commentsProductPopUp == null) {
                this.commentsProductPopUp = new CommentsProductPopUp(heightPopUp, widthPopUp, this.noteValue);
                this.commentsProductPopUp.setOnHidden(this.mEventHandlerPopUpComments);
                this.commentsProductPopUp.initOwner((Window)this.stage);
            }
            this.commentsProductPopUp.buildListCommentsPane();
            Dimension screenDimension = AppVarUtils.getScreenDimension();
            this.commentsProductPopUp.setX((screenDimension.getWidth() - widthPopUp) / 2.0);
            this.commentsProductPopUp.setY((screenDimension.getHeight() - heightPopUp) / 2.0);
            this.stage.setAlwaysOnTop(false);
            this.commentsProductPopUp.show();
        }
    }

    private List<OptionItemOrder> getChosenSubOptions(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo option) {
        int id_group_products;
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        ArrayList<OptionItemOrder> listChosenOptionsMultiple = new ArrayList<OptionItemOrder>();
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            if (optionItemOrder.getIdCarte() != id_group_products && (id_group_products != -1 || optionItemOrder.getIdCarte() != 0) || optionItemOrder.getIdProduct() != id_sub_product && (id_sub_product != -1 || optionItemOrder.getIdProduct() != 0) || optionItemOrder.getParent_supplement_id() != option.getiD() || optionItemOrder.getIndex_carte() != index_group_products) continue;
            listChosenOptionsMultiple.add((OptionItemOrder)optionItemOrder.clone());
        }
        return listChosenOptionsMultiple;
    }

    public void loadSubSupplements(OptionDetailProductButton buttonOption) {
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        ProductInfoExt subProduct = buttonOption.getSubProduct();
        SupplementItemInfo optionItem = buttonOption.getOption();
        BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
        this.main_pane.setEffect((Effect)blur);
        double heightPopUp = AppVarUtils.getScreenDimension().getHeight() * 0.8;
        double widthPopUp = AppVarUtils.getScreenDimension().getWidth() * 0.8;
        List<OptionItemOrder> listChosenSubSupplement = this.getChosenSubOptions(groupProducts, subProduct, optionItem);
        if (this.subSupplementsPopUp == null) {
            this.subSupplementsPopUp = new SubSupplementsPopUp(widthPopUp, heightPopUp);
            this.subSupplementsPopUp.setOnHidden(this.mEventHandlerPopUpSubSupplements);
        }
        this.subSupplementsPopUp.initializer(buttonOption, groupProducts, subProduct, optionItem, listChosenSubSupplement, buttonOption.getIndex_group_option());
        Dimension screenDimension = AppVarUtils.getScreenDimension();
        this.subSupplementsPopUp.setX((screenDimension.getWidth() - widthPopUp) / 2.0);
        this.subSupplementsPopUp.setY((screenDimension.getHeight() - heightPopUp) / 2.0);
        this.subSupplementsPopUp.show(this.stage.getOwner());
        if (this.inDriveMode) {
            AppLocal.displayDualScreen.propagateClick("loadSubSupplements", new Object[]{buttonOption.getOption().getiD()});
        }
    }

    private void validSubSupplement(SubSupplementResult result, OptionDetailProductButton buttonOptionParent, CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo optionItemParent, int index_group_option) {
        if (result.isValid()) {
            List<OptionItemOrder> supplements = result.getListChoiceSupplement();
            List<OptionItemOrder> supplements_to_delete = result.getSupplements_to_delete();
            this.deleteOption(groupProducts, subProduct, optionItemParent, supplements_to_delete);
            this.chooseOptions(groupProducts, subProduct, optionItemParent, supplements);
            if (this.next_option) {
                this.nextOption(buttonOptionParent);
                if (this.inDriveMode) {
                    AppLocal.displayDualScreen.propagateClick("nextOption", new Object[]{buttonOptionParent.getOption().getiD()});
                }
            }
        }
    }

    private void deleteOption(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo optionItemParent, List<OptionItemOrder> supplements_to_delete) {
        for (OptionItemOrder subOption : supplements_to_delete) {
            OptionItemOrder option_to_delete = this.getSubOption(groupProducts, subProduct, optionItemParent, subOption);
            if (option_to_delete == null) continue;
            this.listChoiceSupplement.remove(option_to_delete);
        }
        this.setPriceTotal();
    }

    private OptionItemOrder getSubOption(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo optionItemParent, OptionItemOrder subOptionItem) {
        int id_group_products;
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        int sub_supplement_id = subOptionItem.getSupplement();
        int parent_supplement_id = optionItemParent.getiD();
        OptionItemOrder option = null;
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            if (optionItemOrder.getIdCarte() != id_group_products && (id_group_products != -1 || optionItemOrder.getIdCarte() != 0) || optionItemOrder.getIdProduct() != id_sub_product && (id_sub_product != -1 || optionItemOrder.getIdProduct() != 0) || optionItemOrder.getIndex_carte() != index_group_products || sub_supplement_id != optionItemOrder.getSupplement() || parent_supplement_id != optionItemOrder.getParent_supplement_id()) continue;
            option = optionItemOrder;
            break;
        }
        return option;
    }

    private void chooseOptions(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo optionItemParent, List<OptionItemOrder> supplements) {
        for (OptionItemOrder subOption : supplements) {
            OptionItemOrder sub_option = this.getSubOption(groupProducts, subProduct, optionItemParent, subOption);
            if (sub_option != null) continue;
            this.listChoiceSupplement.add(subOption);
        }
        this.setPriceTotal();
    }

    private double getPriceProduct() {
        double price = this.priceProduct;
        if (this.product.isMany_size()) {
            ArrayList<ProductSizeInfo> listSizes = new ArrayList<ProductSizeInfo>();
            listSizes.addAll(this.product.getListSizes());
            ProductSizeInfo sizeTmp = null;
            for (ProductSizeInfo size : listSizes) {
                if (!this.name_sizeProduct.equals(size.getName())) continue;
                sizeTmp = size;
            }
            if (this.product.isDifferent_price()) {
                if (sizeTmp != null) {
                    switch (this.type_line) {
                        case "Sur Place": {
                            price = sizeTmp.getPrice_sp();
                            break;
                        }
                        case "A Emporter": {
                            price = sizeTmp.getPrice_emp();
                        }
                    }
                }
            } else if (sizeTmp != null) {
                price = sizeTmp.getPrice();
            }
        } else {
            price = this.mItemService.getPriceByType(this.product, this.type_line);
        }
        return price;
    }

    private void setPriceTotal() {
        double price = this.priceProduct;
        System.out.println("price : " + price);
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            price += optionItemOrder.getPrice().doubleValue();
        }
        for (ProductTicket subProduct : this.listProducts) {
            price += subProduct.getPriceProduct();
        }
        this.priceSell = price;
        this.price_label.setText(this.printPriceSell());
        this.checkAddMinItems();
        int numberItems = this.getNumberItems();
        this.recap_label.setText("Recap: " + numberItems);
    }

    public void checkAndValid() {
        if (this.checkPopUp()) {
            this.hidePopUps();
        } else {
            try {
                int number;
                ArrayList<DetailProductError> errors = new ArrayList<DetailProductError>();
                for (SupplementProduct option : this.options) {
                    if (!option.getHas_options().booleanValue()) continue;
                    number = 0;
                    for (OptionItemOrder supplement : this.listChoiceSupplement) {
                        if (supplement.getParent_supplement_id() != 0 || supplement.getId_groupe_option() != option.getiD() || supplement.getIdCarte() != -1 && supplement.getIdCarte() != 0 || supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
                        number += supplement.getNumberOption();
                    }
                    if ((number >= option.getMin_options() || number >= option.getItems().size() * option.getNumber_click()) && number <= option.getMax_options()) continue;
                    errors.add(new DetailProductError(null, null, option, STR_OPTIONS, option.getMin_options(), option.getMax_options(), number, option.getName()));
                }
                for (CarteOrderInfo groupProduct : this.groupProducts) {
                    number = 0;
                    for (ProductTicket subProduct : this.listProducts) {
                        if (subProduct.getIdCarte() != groupProduct.getId() || groupProduct.getIndex_carte() != subProduct.getIndex_carte()) continue;
                        ++number;
                    }
                    if (number != 0) continue;
                    errors.add(new DetailProductError(groupProduct, null, null, STR_GROUP_PRODUCTS, 1, 1, number, groupProduct.getName()));
                }
                for (ProductTicket subProduct : this.listProducts) {
                    for (SupplementProduct option : subProduct.getOptions()) {
                        if (!option.getHas_options().booleanValue()) continue;
                        int number2 = 0;
                        for (OptionItemOrder supplement : this.listChoiceSupplement) {
                            if (supplement.getParent_supplement_id() != 0 || supplement.getId_groupe_option() != option.getiD() || supplement.getIdCarte() != subProduct.getIdCarte() || supplement.getIdProduct() != subProduct.getIdProduct() || supplement.getIndex_carte() != subProduct.getIndex_carte()) continue;
                            number2 += supplement.getNumberOption();
                        }
                        if ((number2 >= option.getMin_options() || number2 >= option.getItems().size() * option.getNumber_click()) && number2 <= option.getMax_options()) continue;
                        errors.add(new DetailProductError(null, subProduct, option, STR_SUB_PRODUCT, option.getMin_options(), option.getMax_options(), number2, subProduct.getNameProduct() + " - " + option.getName()));
                    }
                }
                if (errors.isEmpty()) {
                    this.closePopup();
                } else {
                    this.loadPopUpErrorItems(errors);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void setOptionsOfSubProducts() throws BasicException {
        if (this.listProducts != null) {
            for (ProductTicket subProduct : this.listProducts) {
                if (subProduct.getOptions() != null && !subProduct.getOptions().isEmpty()) continue;
                List<SupplementProduct> optionsProduct = this.dlItems.getSupplementsByProduct(subProduct.getIdProduct(), false, true);
                for (SupplementProduct supplementProduct : optionsProduct) {
                    List<SupplementItemInfo> optionsItem = this.dlItems.getSuppelementsItem(supplementProduct.getiD(), true);
                    supplementProduct.setItems(optionsItem);
                }
                subProduct.setOptions(optionsProduct);
            }
        }
    }

    public void loadPopUpErrorItems(List<DetailProductError> errors) {
        BoxBlur blur = new BoxBlur(6.0, 6.0, 4);
        this.header_pane.setEffect((Effect)blur);
        this.detail_pane.setEffect((Effect)blur);
        double heightError = 50.0;
        double heightPopUp = heightError * (double)errors.size();
        double heightMaxPopUp = AppVarUtils.getScreenDimension().getHeight() * 0.6;
        if (heightPopUp > heightMaxPopUp) {
            heightPopUp = heightMaxPopUp;
        }
        double widthPopUp = AppVarUtils.getScreenDimension().getWidth() * 0.35;
        if (this.errorItemsPopUp == null) {
            this.errorItemsPopUp = new ErrorItemsPopUp();
            this.errorItemsPopUp.setOnHidden(this.mEventHandlerPopUpErrorItemsHide);
        }
        double yWindow = AppVarUtils.getScreenDimension().getHeight() * 0.9 - heightPopUp;
        this.errorItemsPopUp.init(errors, widthPopUp, heightPopUp);
        this.errorItemsPopUp.setX(AppVarUtils.getScreenDimension().getWidth() - 10.0);
        this.errorItemsPopUp.setY(yWindow);
        this.errorItemsPopUp.show(this.stage.getOwner());
    }

    private void deleteSubOptions(OptionDetailProductButton buttonOption) {
        SupplementItemInfo optionItemParent;
        ProductInfoExt subProduct;
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        List<OptionItemOrder> supplements_to_delete = this.getChosenSubOptions(groupProducts, subProduct = buttonOption.getSubProduct(), optionItemParent = buttonOption.getOption());
        if (supplements_to_delete != null && !supplements_to_delete.isEmpty()) {
            for (OptionItemOrder sub_option : supplements_to_delete) {
                OptionItemOrder sub_option_to_delete = this.getSubOption(groupProducts, subProduct, optionItemParent, sub_option);
                if (sub_option_to_delete == null) continue;
                this.listChoiceSupplement.remove(sub_option_to_delete);
            }
            this.setPriceTotal();
        }
    }

    private void loadDetailGroupOption(OptionDetailProductTab buttonGroupOption) {
        this.deselectOptionTabs();
        this.selectOptionTab(buttonGroupOption);
        if (buttonGroupOption.getGroupOption().getIs_ingredient().booleanValue()) {
            this.loadIngredients_SubProduct(buttonGroupOption.getGroupProducts(), buttonGroupOption.getProduct(), buttonGroupOption.getGroupOption());
        } else {
            this.loadOptions(buttonGroupOption);
        }
    }

    private void hidePopUps() {
        if (this.typeOrderPopUp != null && this.typeOrderPopUp.isShowing()) {
            this.typeOrderPopUp.hide();
        }
        if (this.discountsProductPopUp != null && this.discountsProductPopUp.isShowing()) {
            this.discountsProductPopUp.hide();
        }
        if (this.commentsProductPopUp != null && this.commentsProductPopUp.isShowing()) {
            this.commentsProductPopUp.hide();
        }
        if (this.recapOrderPopUp != null && this.recapOrderPopUp.isShowing()) {
            this.recapOrderPopUp.hide();
        }
        if (this.subSupplementsPopUp != null && this.subSupplementsPopUp.isShowing()) {
            this.subSupplementsPopUp.hide();
        }
        if (this.errorItemsPopUp != null && this.errorItemsPopUp.isShowing()) {
            this.errorItemsPopUp.hide();
        }
        if (this.errorLimitationPopUp != null && this.errorLimitationPopUp.isShowing()) {
            this.errorLimitationPopUp.hide();
        }
    }

    private boolean checkPopUp() {
        if (this.typeOrderPopUp != null && this.typeOrderPopUp.isShowing()) {
            return true;
        }
        if (this.discountsProductPopUp != null && this.discountsProductPopUp.isShowing()) {
            return true;
        }
        if (this.commentsProductPopUp != null && this.commentsProductPopUp.isShowing()) {
            return true;
        }
        if (this.recapOrderPopUp != null && this.recapOrderPopUp.isShowing()) {
            return true;
        }
        if (this.subSupplementsPopUp != null && this.subSupplementsPopUp.isShowing()) {
            return true;
        }
        if (this.errorItemsPopUp != null && this.errorItemsPopUp.isShowing()) {
            return true;
        }
        return this.errorLimitationPopUp != null && this.errorLimitationPopUp.isShowing();
    }

    public void checkAddMinItems() {
        boolean error = false;
        try {
            int number;
            for (SupplementProduct option : this.options) {
                if (!option.getHas_options().booleanValue()) continue;
                number = 0;
                for (OptionItemOrder supplement : this.listChoiceSupplement) {
                    if (supplement.getParent_supplement_id() != 0 || supplement.getId_groupe_option() != option.getiD() || supplement.getIdCarte() != -1 && supplement.getIdCarte() != 0 || supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
                    number += supplement.getNumberOption();
                }
                if (number >= option.getMin_options() || number >= option.getItems().size() * option.getNumber_click()) continue;
                error = true;
            }
            for (CarteOrderInfo groupProduct : this.groupProducts) {
                number = 0;
                for (ProductTicket subProduct : this.listProducts) {
                    if (subProduct.getIdCarte() != groupProduct.getId() || groupProduct.getIndex_carte() != subProduct.getIndex_carte()) continue;
                    ++number;
                }
                if (number != 0) continue;
                error = true;
            }
            for (ProductTicket subProduct : this.listProducts) {
                for (SupplementProduct option : subProduct.getOptions()) {
                    if (!option.getHas_options().booleanValue()) continue;
                    int number2 = 0;
                    for (OptionItemOrder supplement : this.listChoiceSupplement) {
                        if (supplement.getParent_supplement_id() != 0 || supplement.getId_groupe_option() != option.getiD() || supplement.getIdCarte() != subProduct.getIdCarte() || supplement.getIdProduct() != subProduct.getIdProduct() || supplement.getIndex_carte() != subProduct.getIndex_carte()) continue;
                        number2 += supplement.getNumberOption();
                    }
                    if (number2 >= option.getMin_options() || number2 >= option.getItems().size() * option.getNumber_click()) continue;
                    error = true;
                }
            }
            if (error) {
                if (this.productValid) {
                    this.valid_product_button.setStyle("-fx-background-color: #2D2D2D;-fx-background-radius: 0px 0px 11px 11px;-fx-text-fill: white;");
                }
                this.productValid = false;
            } else {
                if (!this.productValid) {
                    this.valid_product_button.setStyle("-fx-background-color: #0B8871;-fx-background-radius: 0px 0px 11px 11px;-fx-text-fill: white;");
                }
                this.productValid = true;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private int getNumberItems() {
        int quantity = (int)this.multiply;
        for (OptionItemOrder supplement : this.listChoiceSupplement) {
            quantity = (int)((double)quantity + (double)supplement.getNumberOption() * this.multiply);
        }
        for (ProductTicket subProduct : this.listProducts) {
            quantity = (int)((double)quantity + (double)subProduct.getNumberProduct() * this.multiply);
        }
        return quantity;
    }

    private void loadPageDetailProduct(DetailProductError detailProductError) {
        if (detailProductError.getTypeError() != null) {
            switch (detailProductError.getTypeError()) {
                case "options": {
                    this.loadGroupOptionsWithError(detailProductError);
                    if (!this.inDriveMode) break;
                    AppLocal.displayDualScreen.propagateClick("loadGroupOptionsWithError", new Object[]{detailProductError});
                    break;
                }
                case "group_products": {
                    this.loadGroupProductsWithError(detailProductError);
                    if (!this.inDriveMode) break;
                    AppLocal.displayDualScreen.propagateClick("loadGroupProductsWithError", new Object[]{detailProductError});
                    break;
                }
                case "sub_product": {
                    this.loadSubProductWithError(detailProductError);
                    if (!this.inDriveMode) break;
                    AppLocal.displayDualScreen.propagateClick("loadSubProductWithError", new Object[]{detailProductError});
                }
            }
        }
    }

    private void loadGroupOptionsWithError(DetailProductError detailProductError) {
        if (detailProductError.getGroupOption() != null) {
            int page;
            HeaderDetailProductButton groupTabOption = null;
            for (HeaderDetailProductButton groupTab : this.groupTabs) {
                if (!groupTab.getGroup_type().equals(STR_OPTIONS)) continue;
                groupTabOption = groupTab;
            }
            if (groupTabOption != null && (page = this.getPageHeaderTab(groupTabOption)) < this.numberPageDetailProductHeader) {
                this.page_detail_product_header = page;
                this.header_detail_product_pane.getChildren().clear();
                this.header_detail_product_pane.add((Node)this.headerDetailProductArray[this.page_detail_product_header], 0, 0);
                if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                    this.next_detail_header.setDisable(true);
                }
                this.previous_detail_header.setDisable(false);
                this.deselectHeaderTabs();
                this.selectHeaderTab(groupTabOption);
                this.loadOptionsTabs_Product();
                SupplementProduct groupOption = detailProductError.getGroupOption();
                this.loadGroupOptionWithChangePage(groupOption);
            }
        }
    }

    private void loadGroupOptionWithChangePage(SupplementProduct groupOption) {
        int index_group_option;
        OptionDetailProductTab optionDetailProductTab = null;
        for (OptionDetailProductTab groupOptionTab : this.groupOptionTabs) {
            if (groupOptionTab.getGroupOption().getiD() != groupOption.getiD()) continue;
            optionDetailProductTab = groupOptionTab;
            break;
        }
        if (optionDetailProductTab != null && (index_group_option = optionDetailProductTab.getIndex()) < this.groupOptionTabs.size()) {
            int page = (int)Math.ceil((double)(index_group_option + 1) / (double)this.MAX_OPTIONS_TABS);
            if (--page < this.numberPageOptionsTabs) {
                this.page_options_tabs = page;
                this.groupOptionsPane.getChildren().clear();
                this.groupOptionsPane.add((Node)this.optionTabsArray[this.page_options_tabs], 0, 0);
                if (this.page_options_tabs == this.numberPageOptionsTabs - 1) {
                    this.nextOptionTab.setDisable(true);
                }
                this.previousOptionTab.setDisable(false);
                this.loadDetailGroupOption(optionDetailProductTab);
            }
        }
    }

    private void loadGroupProductsWithError(DetailProductError detailProductError) {
        if (detailProductError.getGroupProducts() != null) {
            HeaderDetailProductButton groupProductsTab = null;
            for (HeaderDetailProductButton groupTab : this.groupTabs) {
                if (!groupTab.getGroup_type().equals(STR_GROUP_PRODUCTS) || !(groupTab.getGroupItem() instanceof CarteOrderInfo) || ((CarteOrderInfo)groupTab.getGroupItem()).getId() != detailProductError.getGroupProducts().getId() || ((CarteOrderInfo)groupTab.getGroupItem()).getIndex_carte() != detailProductError.getGroupProducts().getIndex_carte()) continue;
                groupProductsTab = groupTab;
            }
            this.loadGroupProduct(groupProductsTab, null);
        }
    }

    private void loadGroupProduct(HeaderDetailProductButton groupProductsTab, DetailProductError detailProductError) {
        int page;
        if (groupProductsTab != null && (page = this.getPageHeaderTab(groupProductsTab)) < this.numberPageDetailProductHeader) {
            this.page_detail_product_header = page;
            this.header_detail_product_pane.getChildren().clear();
            this.header_detail_product_pane.add((Node)this.headerDetailProductArray[this.page_detail_product_header], 0, 0);
            if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                this.next_detail_header.setDisable(true);
            }
            this.previous_detail_header.setDisable(false);
            this.deselectHeaderTabs();
            this.selectHeaderTab(groupProductsTab);
            if (groupProductsTab.getGroupItem() != null && groupProductsTab.getGroupItem() instanceof CarteOrderInfo) {
                CarteOrderInfo groupProducts = (CarteOrderInfo)groupProductsTab.getGroupItem();
                this.loadProductsFamille(groupProducts);
                if (detailProductError != null && detailProductError.getGroupOption() != null) {
                    SupplementProduct groupOption = detailProductError.getGroupOption();
                    this.loadGroupOptionWithChangePage(groupOption);
                }
            }
        }
    }

    private void loadSubProductWithError(DetailProductError detailProductError) {
        if (detailProductError.getSubProduct() != null) {
            ProductTicket productTicket = detailProductError.getSubProduct();
            if (productTicket.getIdCarte() != 0 && productTicket.getIdCarte() != -1) {
                HeaderDetailProductButton groupProductsTab = null;
                for (HeaderDetailProductButton groupTab : this.groupTabs) {
                    if (!groupTab.getGroup_type().equals(STR_GROUP_PRODUCTS) || !(groupTab.getGroupItem() instanceof CarteOrderInfo) || ((CarteOrderInfo)groupTab.getGroupItem()).getId() != productTicket.getIdCarte() || ((CarteOrderInfo)groupTab.getGroupItem()).getIndex_carte() != productTicket.getIndex_carte()) continue;
                    groupProductsTab = groupTab;
                }
                this.loadGroupProduct(groupProductsTab, detailProductError);
            } else {
                int page;
                HeaderDetailProductButton subProductsTab = null;
                for (HeaderDetailProductButton groupTab : this.groupTabs) {
                    if (!groupTab.getGroup_type().equals(STR_SUB_PRODUCT) || !(groupTab.getGroupItem() instanceof ProductInfoExt) || ((ProductInfoExt)groupTab.getGroupItem()).getID() != productTicket.getIdProduct() || ((ProductInfoExt)groupTab.getGroupItem()).getIndex_sub_product() != productTicket.getIndex_carte()) continue;
                    subProductsTab = groupTab;
                }
                if (subProductsTab != null && (page = this.getPageHeaderTab(subProductsTab)) < this.numberPageDetailProductHeader) {
                    this.page_detail_product_header = page;
                    this.header_detail_product_pane.getChildren().clear();
                    this.header_detail_product_pane.add((Node)this.headerDetailProductArray[this.page_detail_product_header], 0, 0);
                    if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                        this.next_detail_header.setDisable(true);
                    }
                    this.previous_detail_header.setDisable(false);
                    if (subProductsTab.getGroupItem() != null && subProductsTab.getGroupItem() instanceof ProductInfoExt) {
                        ProductInfoExt subProduct = (ProductInfoExt)subProductsTab.getGroupItem();
                        this.deselectHeaderTabs();
                        this.selectHeaderTab(subProductsTab);
                        this.loadDetailSubProduct(subProduct);
                        SupplementProduct groupOption = detailProductError.getGroupOption();
                        this.loadGroupOptionWithChangePage(groupOption);
                    }
                }
            }
        }
    }

    private void loadSelectedSubProduct(ProductFamilleButton productButtonSelected) {
        CarteOrderInfo groupProducts = productButtonSelected.getGroupProduct();
        ProductInfoExt productFamille = productButtonSelected.getProduct();
        String size_group_products = groupProducts != null && groupProducts.getSizeCarte() != null && !groupProducts.getSizeCarte().isEmpty() ? groupProducts.getSizeCarte() : this.name_sizeProduct;
        this.loadInfoProduct(productFamille, size_group_products, groupProducts);
        this.loadOptionsTabs_GroupProduct(groupProducts, productFamille);
        int page = this.getPageProductFamille(productButtonSelected);
        if (page < this.numberPageProductsFamille) {
            this.page_products_famille = page;
            this.loadPageProductsFamille(this.page_products_famille);
            if (this.page_products_famille == this.numberPageProductsFamille - 1 && this.nextProductFamilleButton != null) {
                this.nextProductFamilleButton.setDisable(true);
            }
            if (this.previousProductFamilleButton != null) {
                this.previousProductFamilleButton.setDisable(false);
            }
        }
    }

    public int getPageProductFamille(ProductFamilleButton productButtonSelected) {
        int index = productButtonSelected.getIndex();
        int page = (int)Math.ceil((double)(index + 1) / (double)this.numberPageProductsFamille);
        return --page;
    }

    private void checkSoldOut() {
        if (this.product.isSold_out()) {
            this.header_pane.getChildren().clear();
            this.header_pane.add((Node)this.close_button, 0, 0);
            this.showSettingProductPane();
        }
    }

    public void setOnOffProduct() {
        this.header_pane.getChildren().clear();
        this.header_pane.add((Node)this.return_to_pane, 0, 0);
        this.header_pane.add((Node)this.close_button, 1, 0);
        this.showSettingProductPane();
    }

    public void showSettingProductPane() {
        double heightPaneOnOffProduct = AppVarUtils.getScreenDimension().getHeight() * 0.9;
        double widthPaneOnOffProduct = AppVarUtils.getScreenDimension().getWidth();
        if (this.productStockPane == null) {
            this.productStockPane = new ProductStockPane(this.product, heightPaneOnOffProduct, widthPaneOnOffProduct);
            this.productStockPane.getmSwitchButton().setOnMouseClicked(this.mEventHandlerClickSwitch);
            this.productStockPane.getmSwitchButton().getButton().setOnMouseClicked(this.mEventHandlerClickSwitch);
            this.productStockPane.getButton_sold_out_temporary().setOnAction(this.mEventHandlerSetSoldOutTemporary);
        }
        this.productStockPane.checkSoldOut();
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.header_pane, 0, 0);
        this.main_pane.add((Node)this.productStockPane, 0, 1);
    }

    public void returnToProduct() {
        this.main_pane.getChildren().clear();
        this.setHeaderNodes();
        this.main_pane.add((Node)this.header_pane, 0, 0);
        this.main_pane.add((Node)this.detail_pane, 0, 1);
        this.main_pane.add((Node)this.footer_pane, 0, 2);
    }

    private void sendOptionsToDualScreen(SupplementProduct goption) {
        if (this.typeDisplay != null && this.typeDisplay.startsWith("window")) {
            this.prepareLines();
            AppLocal.displayDualScreen.loadInfoProduct(this.product, this.printTotal(), this.printPriceSell(), goption, this.options, this.listChoiceSupplement);
        }
    }
}

