/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.DateUtils;
import com.openbravo.beans.OrderOnLine;
import com.openbravo.controllers.DetailOrderOnline;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.OrderOnLineService;
import com.procaisse.notifications.OnLineOrderDialogue;
import com.procaisse.notifications.OnLineOrderView;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import javafx.util.Callback;

public class PopUpOnLineOrder {
    @FXML
    TableView tableViewOnLine;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn date_delivry;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn type_payement;
    @FXML
    TableColumn customerName;
    @FXML
    TableColumn customerAdress;
    @FXML
    TableColumn etat_order;
    @FXML
    TableColumn totalOrder;
    @FXML
    Button btn_caisse;
    @FXML
    Button btn_cancel;
    @FXML
    GridPane footer_print_pane;
    @FXML
    private DatePicker datePickerFilter;
    @FXML
    GridPane footer_btns;
    @FXML
    GridPane footer_cancel;
    @FXML
    GridPane pane_main;
    @FXML
    FlowPane pane_raison;
    @FXML
    TextArea raison;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    @FXML
    TableColumn customerTel;
    @FXML
    TableColumn commandNum;
    private AppView app;
    private Date date;
    protected DataLogicSales dlSales;
    List<TicketLineInfo> productToSend;
    private List<OrderOnLine> documents;
    private OrderOnLine document;
    int row = -1;
    private static double widthPane = 700.0;
    private Scene scene;
    private OnLineOrderDialogue parent;

    public void init(Scene scene, AppView app, OnLineOrderDialogue parent) throws BasicException {
        this.parent = parent;
        this.scene = scene;
        this.app = app;
        this.dlSales = (DataLogicSales)this.app.getBean("com.openbravo.dao.DataLogicSales");
        this.productToSend = new ArrayList<TicketLineInfo>();
        this.loadPaneFooter();
        this.switchToBtns();
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.tableViewOnLine, 0, 0);
        this.tableViewOnLine.setFixedCellSize(40.0);
        this.document = null;
        this.tableViewOnLine.setRowFactory((Callback)new Callback<TableView<OnLineOrderView>, TableRow<OnLineOrderView>>(){

            public TableRow<OnLineOrderView> call(TableView<OnLineOrderView> param) {
                TableRow<OnLineOrderView> row = new TableRow<OnLineOrderView>(){

                    public void updateItem(OnLineOrderView item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setAlignment(Pos.BASELINE_CENTER);
                            super.setStyle("");
                            if (Integer.valueOf(item.getStatus()) == 1) {
                                this.getStyleClass().remove((Object)"bg-white");
                                this.getStyleClass().add((Object)"bg-red");
                            } else if (Integer.valueOf(item.getStatus()) == 2) {
                                this.getStyleClass().add((Object)"bg-green");
                            } else {
                                this.getStyleClass().add((Object)"bg-white");
                            }
                        } else {
                            this.setStyle("-fx-background-color: white; -fx-border-color: #89d3d6; -fx-border-width: 0 0 0 0;");
                        }
                    }
                };
                return row;
            }
        });
        this.tableViewOnLine.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                if (PopUpOnLineOrder.this.tableViewOnLine.getSelectionModel().getSelectedIndex() != -1) {
                    PopUpOnLineOrder.this.row = PopUpOnLineOrder.this.tableViewOnLine.getSelectionModel().getSelectedIndex();
                    PopUpOnLineOrder.this.tableViewOnLine.getSelectionModel().getSelectedItem();
                    if (PopUpOnLineOrder.this.row != -1) {
                        PopUpOnLineOrder.this.document = ((OnLineOrderView)PopUpOnLineOrder.this.tableViewOnLine.getSelectionModel().getSelectedItem()).getDoc();
                        PopUpOnLineOrder.this.switchToBtns();
                    }
                }
            }
        });
        Calendar calToday = Calendar.getInstance();
        this.date = DateUtils.getToday();
        this.datePickerFilter.setShowWeekNumbers(false);
        this.datePickerFilter.setValue((Object)LocalDate.now());
        this.datePickerFilter.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LocalDate datePickerValue = (LocalDate)PopUpOnLineOrder.this.datePickerFilter.getValue();
                AppVarUtils.QUEUED_ONLINE_ORDERS_TODAY = new HashMap<String, OrderOnLine>(AppVarUtils.QUEUED_ONLINE_ORDERS);
                AppVarUtils.QUEUED_ONLINE_ORDERS = new HashMap<String, OrderOnLine>();
                AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT = 0;
                OrderOnLineService onLineService = new OrderOnLineService(AppLocal.ID_ONLINE_SERVER);
                onLineService.updateUnsynchronizedOrders(com.openbravo.pos.util.DateUtils.asDate(datePickerValue));
                PopUpOnLineOrder.this.loadDocuments();
                if (!PopUpOnLineOrder.this.datePickerFilter.isShowing()) {
                    PopUpOnLineOrder.this.datePickerFilter.show();
                } else {
                    PopUpOnLineOrder.this.datePickerFilter.hide();
                }
                AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT = 0;
            }
        });
        this.commandNum.setCellValueFactory((Callback)new PropertyValueFactory("commandNum"));
        this.customerTel.setCellValueFactory((Callback)new PropertyValueFactory("customerTel"));
        this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
        this.date_delivry.setCellValueFactory((Callback)new PropertyValueFactory("dateDelivry"));
        this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("typeOrder"));
        this.customerName.setCellValueFactory((Callback)new PropertyValueFactory("customerName"));
        this.customerAdress.setCellValueFactory((Callback)new PropertyValueFactory("customerAdress"));
        this.totalOrder.setCellValueFactory((Callback)new PropertyValueFactory("totalOrder"));
        this.type_payement.setCellValueFactory((Callback)new PropertyValueFactory("typePayement"));
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date = calToday.getTime();
        }
        this.loadDocuments();
    }

    private void loadDocuments() {
        if (AppVarUtils.QUEUED_ONLINE_ORDERS != null) {
            this.document = null;
            this.documents = new ArrayList<OrderOnLine>(AppVarUtils.QUEUED_ONLINE_ORDERS.values());
            ArrayList<OnLineOrderView> items = new ArrayList<OnLineOrderView>();
            Collections.sort(this.documents, new Comparator<OrderOnLine>(){

                @Override
                public int compare(OrderOnLine l1, OrderOnLine l2) {
                    return l2.getId() - l1.getId();
                }
            });
            for (OrderOnLine doc : this.documents) {
                items.add(new OnLineOrderView("" + doc.getId(), this.dateFormatter.format(doc.getDateCmd()), this.dateFormatter.format(doc.getDateDelevery()), doc.getType(), doc.getClientName(), doc.getClientTel(), Formats.CURRENCY.formatValue(doc.getTotal()), doc.getTypePayment(), doc.getJsonOrder().getBoolean("removed") ? 1 : (doc.getJsonOrder().getBoolean("status") ? 2 : 0), doc.getAdresse(), doc));
            }
            ObservableList data = FXCollections.observableArrayList(items);
            this.tableViewOnLine.setItems(data);
        }
    }

    public void cancel() {
        if (this.document != null) {
            AppVarUtils.QUEUED_ONLINE_ORDERS.remove(this.document.getId());
            this.loadDocuments();
            this.document = null;
        }
    }

    public void printTicket() {
        if (this.document != null) {
            // empty if block
        }
    }

    public void detailOrder() {
        if (this.document != null) {
            this.buildDetail(this.document);
        }
    }

    private void buildDetail(OrderOnLine order) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/popUp_detailOrder.fxml"));
            Parent rootNode = (Parent)loader.load();
            DetailOrderOnline controller = (DetailOrderOnline)loader.getController();
            Scene scenePop = new Scene(rootNode, AppVarUtils.getScreenDimension().getWidth() * 0.7, AppVarUtils.getScreenDimension().getHeight() * 0.6);
            scenePop.getStylesheets().add((Object)"/styles/styles.css");
            final Stage modalStage = new Stage();
            modalStage.setResizable(false);
            modalStage.setScene(scenePop);
            modalStage.setTitle("D\u00e9tail Commande");
            modalStage.initOwner(this.scene.getWindow());
            modalStage.initModality(Modality.APPLICATION_MODAL);
            modalStage.initStyle(StageStyle.DECORATED);
            modalStage.setAlwaysOnTop(true);
            controller.init(modalStage, order);
            modalStage.show();
            AppLocal.listPopUp.add(modalStage);
            modalStage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    AppLocal.listPopUp.remove(modalStage);
                }
            });
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void printTicketPrincipal() {
        if (this.document != null) {
            AppVarUtils.QUEUED_ONLINE_ORDERS.remove(this.document.getId());
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                }
            });
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                LogToFile.log("severe", null, ex);
            }
            this.loadDocuments();
            this.document = null;
        }
    }

    public void switchToBtns() {
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.footer_btns, 0, 0);
    }

    public void switchToCancel() {
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.footer_cancel, 0, 0);
    }

    private void loadPaneFooter() throws BasicException {
        this.footer_btns.getChildren().clear();
        this.footer_btns.add((Node)this.btn_caisse, 0, 0);
        this.footer_btns.add((Node)this.btn_cancel, 1, 0);
    }

    public void closePopUp() {
        this.parent.dispose();
    }
}

