/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.components.PopUpNotification;
import com.openbravo.components.PopUpOnlineOrderNotification;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.sales.JPanelOrderSuivi;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.notifications.OnLineOrderDialogue;
import java.io.IOException;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.swing.JFrame;

public class PopUpNotificationController {
    @FXML
    Button btn_action;
    @FXML
    Label label_count;
    boolean isFirst = true;
    private PopUpNotification m_PopUpNotification;
    private AppView mAppView;
    private PopUpOnlineOrderNotification mPopUpOnlineOrderNotification;

    public void init(AppView app) {
        this.mAppView = app;
        Image image = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/fa_envelope.png"));
        this.label_count.setText("" + AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT);
        this.btn_action.setGraphic((Node)new ImageView(image));
        this.btn_action.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (PopUpNotificationController.this.m_PopUpNotification != null && PopUpNotificationController.this.m_PopUpNotification.getModalStage() != null) {
                    PopUpNotificationController.this.m_PopUpNotification.getModalStage().hide();
                }
                if (PopUpNotificationController.this.mPopUpOnlineOrderNotification != null) {
                    PopUpNotificationController.this.mPopUpOnlineOrderNotification.dispose();
                }
                if (PopUpNotificationController.this.m_PopUpNotification != null || PopUpNotificationController.this.mPopUpOnlineOrderNotification != null) {
                    PopUpNotificationController.this.goToPanelOrders();
                }
            }
        });
    }

    public void apply(int total) {
        if (AppLocal.SUIVI_ONLINE_ORDER) {
            if (total <= 1) {
                this.label_count.setText(total + " commande en ligne re\u00e7ue");
            } else {
                this.label_count.setText(total + " commandes en ligne re\u00e7ues");
            }
        } else if (this.isFirst && total > 0) {
            System.out.println(total + " commandes en ligne sont \n pr\u00eats \u00e0 traiter aujourd'hui !");
            this.label_count.setText(total + " commandes en ligne sont \n pr\u00eats \u00e0 traiter aujourd'hui !");
            this.isFirst = false;
        } else if (!this.label_count.getText().equalsIgnoreCase(total + " commandes en ligne sont \n pr\u00eats \u00e0 traiter aujourd'hui !")) {
            this.label_count.setText(total + " commandes en ligne sont \n pr\u00eats \u00e0 \u00eatre imprimer !");
        }
        this.label_count.setWrapText(true);
    }

    public PopUpNotification getM_PopUpNotification() {
        return this.m_PopUpNotification;
    }

    public void setM_PopUpNotification(PopUpNotification m_PopUpNotification) {
        this.m_PopUpNotification = m_PopUpNotification;
    }

    public void goToPanelOrders() {
        if (AppLocal.user != null) {
            if (AppLocal.SUIVI_ONLINE_ORDER) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        JPanelOrderSuivi suiviOrderPanel;
                        AppView m_appview = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
                        if (AppLocal.view_current == null || !AppLocal.view_current.equals("com.openbravo.pos.sales.JPanelOrderSuivi")) {
                            m_appview.getAppUserView().showTask("com.openbravo.pos.sales.JPanelOrderSuivi");
                            AppLocal.view_back = "com.openbravo.pos.sales.JCaissePanel";
                            AppLocal.view_current = "com.openbravo.pos.sales.JPanelOrderSuivi";
                        }
                        if ((suiviOrderPanel = (JPanelOrderSuivi)m_appview.getAppUserView().getPanelView("com.openbravo.pos.sales.JPanelOrderSuivi")) != null) {
                            suiviOrderPanel.loadOrdersOnline();
                        }
                    }
                });
            } else {
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AppVarUtils.QUEUED_ONLINE_ORDERS_COUNT = 0;
                            OnLineOrderDialogue.showMessage(new JFrame(), PopUpNotificationController.this.mAppView);
                        }
                        catch (IOException ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                        catch (BasicException ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                });
            }
        }
    }

    public PopUpOnlineOrderNotification getmPopUpOnlineOrderNotification() {
        return this.mPopUpOnlineOrderNotification;
    }

    public void setmPopUpOnlineOrderNotification(PopUpOnlineOrderNotification mPopUpOnlineOrderNotification) {
        this.mPopUpOnlineOrderNotification = mPopUpOnlineOrderNotification;
    }
}

