/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicProduct;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.KitchenCompositeErrorsDialogue;
import com.openbravo.pos.printer.TicketKitchenView;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.TicketService;
import fr.protactile.kitchen.services.OrderKitchenScreenService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class PopUpKitchenCompositeErrors {
    @FXML
    TableView tableView;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn type_order;
    @FXML
    Label label_title;
    @FXML
    Button btn_relance;
    @FXML
    Button btn_print;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    private AppView app;
    private List<TicketInfo> orders;
    private TicketInfo currentTicket;
    private DataLogicSales dlSales;
    private DataLogicProduct dlProduct;
    private DataLogicOrder dlOrders;
    private KitchenCompositeErrorsDialogue parent;
    private boolean printFond;
    private boolean isSeparate;
    private boolean displayQuantity;
    private TicketService mTicketService;

    public void init(Scene scene, AppView app, KitchenCompositeErrorsDialogue parent) throws BasicException {
        this.parent = parent;
        this.app = app;
        this.dlSales = (DataLogicSales)app.getBean("com.openbravo.dao.DataLogicSales");
        this.dlProduct = (DataLogicProduct)app.getBean("com.openbravo.dao.DataLogicProduct");
        this.dlOrders = (DataLogicOrder)app.getBean("com.openbravo.dao.DataLogicOrder");
        this.tableView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (PopUpKitchenCompositeErrors.this.tableView.getSelectionModel().getSelectedIndex() != -1 && (row = PopUpKitchenCompositeErrors.this.tableView.getSelectionModel().getSelectedIndex()) != -1) {
                    PopUpKitchenCompositeErrors.this.currentTicket = PopUpKitchenCompositeErrors.this.orders.get(row);
                }
            }
        });
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("num"));
        this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hour"));
        this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.loadOrders();
        this.setTexts();
    }

    private void loadOrders() {
        if (AppVarUtils.QUEUE_TICKET_KITCHEN != null) {
            this.orders = AppVarUtils.QUEUE_TICKET_KITCHEN;
            ArrayList<TicketKitchenView> items = new ArrayList<TicketKitchenView>();
            for (TicketInfo ticket : this.orders) {
                items.add(new TicketKitchenView("" + ticket.getNumero_order(), this.timeFormatter.format(ticket.getDate()), ticket.getType()));
            }
            ObservableList data = FXCollections.observableArrayList(items);
            this.tableView.setItems(data);
        }
    }

    public void printTicket() {
        if (this.currentTicket != null) {
            try {
                Decreaser decreaserKitchen = new Decreaser(this.dlSales, this.currentTicket.getId(), "Ticket cuisine", null, this.currentTicket.getNumero_order());
                if (this.mTicketService == null) {
                    this.mTicketService = TicketService.getInstance();
                }
                this.mTicketService.printRecap(this.currentTicket, decreaserKitchen, false, false, false, null);
                AppVarUtils.QUEUE_TICKET_KITCHEN.remove(this.currentTicket);
                this.loadOrders();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void relance() {
        if (this.currentTicket != null) {
            AppVarUtils.QUEUE_TICKET_KITCHEN.remove(this.currentTicket);
            OrderKitchenScreenService mOrderKitchenScreenService = new OrderKitchenScreenService(this.dlSales, this.dlProduct, this.dlOrders, AppLocal.dlItems);
            mOrderKitchenScreenService.sendOrderToKitchen(this.currentTicket, true, true);
            this.loadOrders();
        }
    }

    public void closePopUp() {
        this.parent.dispose();
    }

    private void setTexts() {
        this.label_title.setText(AppLocal.getIntString("Text.error.kitchen"));
        this.hour_order.setText(AppLocal.getIntString("Text.hour.failure"));
        this.type_order.setText(AppLocal.getIntString("Label.type"));
        this.btn_relance.setText(AppLocal.getIntString("Text.reload"));
        this.btn_print.setText(AppLocal.getIntString("Text.print.recap"));
    }
}

