/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.DateUtils;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.InvoiceView;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoView;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.TicketService;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.norm.beans.Facture;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PopUpInvoiceController
implements RootController {
    @FXML
    Button decreaserButton;
    @FXML
    Button incrementerButton;
    @FXML
    Button btn_print_facture;
    @FXML
    Button btn_edit;
    @FXML
    Button btn_reprint;
    @FXML
    Button btn_print_less;
    @FXML
    TableView tableView;
    @FXML
    GridPane edit_pane;
    @FXML
    GridPane top_invoice_pane;
    @FXML
    GridPane footer_print_pane;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn etat_order;
    @FXML
    TableColumn total_order;
    @FXML
    TableColumn serveur_order;
    @FXML
    TextField couvertTextFeild;
    @FXML
    TextField jCompany;
    @FXML
    Label jCompanyLabel;
    @FXML
    ToggleGroup groupe;
    @FXML
    RadioButton physical;
    @FXML
    RadioButton moral;
    @FXML
    TextField jName;
    @FXML
    Label jNameLabel;
    @FXML
    TextField jAddress;
    @FXML
    Label jAddressLabel;
    @FXML
    TextField jZipCode;
    @FXML
    Label jZipCodeLabel;
    @FXML
    TextField jCity;
    @FXML
    Label jCityLabel;
    @FXML
    TextField jCountry;
    @FXML
    Label jCountryLabel;
    @FXML
    TextField jSiret;
    @FXML
    Label jSiretLabel;
    @FXML
    TextField jCodeNAF;
    @FXML
    Label jCodeNAFLabel;
    @FXML
    TextField jTVA;
    @FXML
    Label jTVALabel;
    @FXML
    FlowPane switchMoralPhysicalFP;
    @FXML
    HBox couvertFlowPane;
    @FXML
    Label label_number_covered;
    @FXML
    GridPane main_pane;
    @FXML
    GridPane list_factures_pane;
    @FXML
    Button btn_edit_invoice;
    @FXML
    Button btn_list_invoices;
    @FXML
    Button btn_next_date;
    @FXML
    Button btn_previous_date;
    @FXML
    Label jdate;
    @FXML
    TableColumn id_invoice;
    @FXML
    TableColumn type_customer;
    @FXML
    TableColumn address;
    @FXML
    TableColumn zip_code;
    @FXML
    TableColumn name;
    @FXML
    TableColumn typeDocument;
    @FXML
    TableColumn date_invoice;
    @FXML
    TableColumn total_ttc;
    @FXML
    TableView tableView_invoices;
    private int couvertNumber;
    private final SimpleDateFormat dateFormatter = com.openbravo.pos.util.DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat timeFormatter = com.openbravo.pos.util.DateUtils.timeFormatter;
    private Stage stage;
    private AppView app;
    private Date date;
    private final String FACTURE_TYPE_BSM = "Bien";
    protected DataLogicSales dlSales;
    private Date dateStart;
    private Date dateEnd;
    private List<PrinterInfo> printers;
    List<TicketLineInfo> productToSend;
    private List<TicketInfo> orders;
    private TicketInfo currentOrder;
    private EnteteInfo entetTicket;
    private static double width = 700.0;
    private static double widthPane;
    private TicketService mTicketService;
    private List<Facture> factures;
    private Facture currentInvoice;
    final SimpleDateFormat dateFormatterFullFacture = new SimpleDateFormat("dd/MM/yyyy \u00e0 HH'h'mm'm'ss's'");
    private boolean editInvoice = false;

    public void closePopUp() {
        this.stage.close();
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        this.dateStart = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        this.dateEnd = calEnd.getTime();
    }

    private void loadOrder() throws BasicException {
        this.orders = "2".equals(this.app.getAppUserView().getUser().getRole()) ? this.dlSales.loadTicketInvoiceByuser(this.dateStart, this.dateEnd, this.app.getAppUserView().getUser().getId()) : this.dlSales.loadTicketInvoice(this.dateStart, this.dateEnd);
        ArrayList<TicketInfoView> items = new ArrayList<TicketInfoView>();
        for (TicketInfo order : this.orders) {
            String table = "";
            if (order.getIdTable() != -1) {
                table = String.valueOf(order.getTable().getNumber());
            }
            String status = this.getStatus(order.getStatus());
            String nameCustomer = order.getCustomer() != null ? order.getCustomer().getName() : order.getName_customer();
            String orderNum = order.getCaisse() != null ? order.getCaisse() + order.getNumero_order() : String.valueOf(order.getNumero_order());
            items.add(new TicketInfoView(orderNum, nameCustomer, order.getCustomerPhone(), this.dateFormatter.format(order.getDate()), this.timeFormatter.format(order.getDate()), order.getType(), status, order.printTotalOrder(), order.getUser().getName(), order.getSource_order(), table));
        }
        ObservableList data = FXCollections.observableArrayList(items);
        this.tableView.setItems(data);
        this.btn_reprint.setDisable(true);
        this.btn_edit.setDisable(true);
    }

    public void editInvoice() {
        if (this.entetTicket != null && !this.entetTicket.IsTicketRestituted()) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.edit.invoice"), 1500, NPosition.BOTTOM_RIGHT);
        } else if (this.currentOrder != null && this.currentOrder.getInvoice() > 0) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.edit.invoice"), 1500, NPosition.BOTTOM_RIGHT);
        } else if (this.currentOrder != null && this.currentOrder.getLinesCount() > 0 && this.currentOrder.getInvoice() <= 0) {
            this.top_invoice_pane.getChildren().clear();
            this.edit_pane.getChildren().clear();
            this.edit_pane.add((Node)this.couvertFlowPane, 0, 0);
            this.edit_pane.add((Node)this.switchMoralPhysicalFP, 0, 1);
            this.edit_pane.add((Node)this.jCompanyLabel, 0, 2);
            this.edit_pane.add((Node)this.jCompany, 1, 2);
            this.edit_pane.add((Node)this.jAddressLabel, 0, 3);
            this.edit_pane.add((Node)this.jAddress, 1, 3);
            this.edit_pane.add((Node)this.jCityLabel, 0, 4);
            this.edit_pane.add((Node)this.jCity, 1, 4);
            this.edit_pane.add((Node)this.jZipCodeLabel, 0, 5);
            this.edit_pane.add((Node)this.jZipCode, 1, 5);
            this.edit_pane.add((Node)this.jCountryLabel, 0, 6);
            this.edit_pane.add((Node)this.jCountry, 1, 6);
            this.edit_pane.add((Node)this.jSiretLabel, 0, 7);
            this.edit_pane.add((Node)this.jSiret, 1, 7);
            this.edit_pane.add((Node)this.jTVALabel, 0, 8);
            this.edit_pane.add((Node)this.jTVA, 1, 8);
            this.top_invoice_pane.add((Node)this.edit_pane, 0, 0);
            this.footer_print_pane.getChildren().clear();
            this.footer_print_pane.add((Node)this.btn_print_facture, 0, 0);
            this.btn_print_facture.setDisable(false);
            this.edit_pane.requestFocus();
            this.couvertTextFeild.setText("" + this.couvertNumber);
            this.couvertFlowPane.setSpacing(5.0);
        }
    }

    public void incrementNumber() {
        ++this.couvertNumber;
        this.couvertTextFeild.setText("" + this.couvertNumber);
    }

    public void decreaseNumber() {
        if (this.couvertNumber > 0) {
            --this.couvertNumber;
            this.couvertTextFeild.setText("" + this.couvertNumber);
        }
    }

    public void reprintFacture() {
        block13: {
            if (this.editInvoice) {
                if (this.currentOrder != null && this.currentOrder.getInvoice() > 0) {
                    try {
                        final Facture currentFacture = this.dlSales.getFactureById(this.currentOrder.getInvoice());
                        if (currentFacture == null) break block13;
                        if (currentFacture.isCancel()) {
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.cancel.invoice"), 4000, NPosition.BOTTOM_RIGHT);
                            break block13;
                        }
                        this.currentOrder.setPayments(this.dlSales.findPaymetsByIdTicket(this.currentOrder.getId()));
                        Executors.newSingleThreadExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                PrinterHelper printer = new PrinterHelper();
                                if (!PopUpInvoiceController.this.entetTicket.IsTicketRestituted()) {
                                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.print.invoice"), 1500, NPosition.BOTTOM_RIGHT);
                                } else {
                                    PopUpInvoiceController.this.mTicketService.printFacture(PopUpInvoiceController.this.entetTicket, PopUpInvoiceController.this.currentOrder, currentFacture);
                                }
                            }
                        });
                    }
                    catch (BasicException ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            } else {
                try {
                    this.entetTicket = this.dlSales.getEnteteByTicket(this.currentInvoice.getTicket(), true);
                    this.currentInvoice = this.dlSales.getFactureById(this.currentInvoice.getId());
                    this.currentOrder = this.dlSales.getTicketById(this.currentInvoice.getTicket());
                    this.currentOrder.setPayments(this.dlSales.findPaymetsByIdTicket(this.currentOrder.getId()));
                    if (this.currentOrder != null) {
                        List<TicketLineInfo> lines = this.dlSales.loadLines(this.currentOrder.getId());
                        List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(this.currentOrder.getId());
                        lines.addAll(linesExterne);
                        this.currentOrder.setLines(lines);
                    }
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                PrinterHelper printer = new PrinterHelper();
                try {
                    if (!this.entetTicket.IsTicketRestituted()) {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Veuillez imprimer le ticket d'origine pour pouvoir imprimer la facture .", 1500, NPosition.BOTTOM_RIGHT);
                    } else {
                        this.mTicketService.printFacture(this.entetTicket, this.currentOrder, this.currentInvoice);
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    public void printInvoice() {
        Facture facture = null;
        if (this.physical.isSelected()) {
            if (!this.isValidFormPhysical()) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.empty.fields"), 1500, NPosition.BOTTOM_RIGHT);
            } else {
                facture = new Facture();
                facture.setPhysical_person(true);
                facture.setName_contact(this.jName.getText().trim());
            }
        } else if (!this.isValidFormMoral()) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.empty.fields"), 1500, NPosition.BOTTOM_RIGHT);
        } else {
            facture = new Facture();
            facture.setPhysical_person(false);
            facture.setCompany(this.jCompany.getText().trim());
            facture.setSiret(this.jSiret.getText());
            facture.setNum_tva(this.jTVA.getText().trim());
        }
        if (facture != null) {
            try {
                facture.setAddress(this.jAddress.getText().trim());
                facture.setZip_code(this.jZipCode.getText().trim());
                facture.setCity(this.jCity.getText().trim());
                facture.setCountry(this.jCountry.getText().trim());
                facture.setTicket(this.currentOrder.getId());
                facture.setDateFacture(new Date());
                facture.setFacture_type("Bien");
                final Facture f = this.mTicketService.addFacture(facture, this.app.getAppUserView().getUser().getId());
                if (f != null) {
                    this.currentOrder.setCouverts(Integer.valueOf(this.couvertTextFeild.getText()));
                    this.dlSales.updateCouvertTicket(Integer.valueOf(this.couvertTextFeild.getText()), this.currentOrder);
                    this.currentOrder.setPayments(this.dlSales.findPaymetsByIdTicket(this.currentOrder.getId()));
                    Executors.newSingleThreadExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            PrinterHelper printer = new PrinterHelper();
                            Decreaser decreaser = new Decreaser(PopUpInvoiceController.this.dlSales, PopUpInvoiceController.this.currentOrder.getId(), "FACTURE", null, PopUpInvoiceController.this.currentOrder.getNumero_order());
                            printer.printFacture(f, PopUpInvoiceController.this.currentOrder, PopUpInvoiceController.this.entetTicket, 0, decreaser, null);
                        }
                    });
                }
                this.stage.close();
            }
            catch (Exception ex) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error"), 1500, NPosition.BOTTOM_RIGHT);
                LogToFile.log("severe", null, ex);
            }
        }
    }

    private boolean isSiretValid(String siret) {
        return !siret.isEmpty() && siret.length() == 14 && this.isNumber(siret);
    }

    private boolean isValidFormPhysical() {
        boolean valid = true;
        if (this.jName.getText().trim().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.empty.customer.field"), 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        if (this.jZipCode.getText().trim().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.empty.zipcode.field"), 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        if (this.jAddress.getText().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Merci de remplir l'adresse du client", 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        if (this.jCity.getText().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Merci de remplir la ville du client", 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        if (this.jCountry.getText().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Merci de remplir le pays du client", 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        return valid;
    }

    private boolean isValidFormMoral() {
        boolean valid = true;
        if (this.jCompany.getText().trim().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.empty.customer.field"), 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        if (this.jZipCode.getText().trim().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.empty.zipcode.field"), 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        if (this.jTVA.getText().trim().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.empty.tva.field"), 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        if (this.jAddress.getText().trim().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.empty.address.field"), 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        if (this.jCity.getText().trim().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.empty.city.field"), 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        if (!this.isSiretValid(this.jSiret.getText())) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.empty.siret.field"), 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        if (this.jCountry.getText().isEmpty()) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Merci de remplir le pays du client", 1500, NPosition.BOTTOM_RIGHT);
            valid = false;
        }
        return valid;
    }

    private boolean isNumber(String aString) {
        try {
            Long.parseLong(aString);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private String getStatus(String status) {
        if (status != null) {
            switch (status) {
                case "livre": {
                    return "Livr\u00e9e";
                }
                case "paid": {
                    return "Termin\u00e9e";
                }
                case "cancel": {
                    return "Annul\u00e9e";
                }
                case "pending": {
                    return "En cours";
                }
                case "Refund": {
                    return "remboursement";
                }
            }
        }
        return null;
    }

    private void initializer() {
        widthPane = width * 0.9;
        this.dlSales = (DataLogicSales)this.app.getBean("com.openbravo.dao.DataLogicSales");
        this.currentOrder = null;
        this.entetTicket = null;
        this.mTicketService = TicketService.getInstance();
        this.tableView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (PopUpInvoiceController.this.tableView.getSelectionModel().getSelectedIndex() != -1 && (row = PopUpInvoiceController.this.tableView.getSelectionModel().getSelectedIndex()) != -1) {
                    PopUpInvoiceController.this.currentOrder = PopUpInvoiceController.this.orders.get(row);
                    try {
                        PopUpInvoiceController.this.entetTicket = PopUpInvoiceController.this.dlSales.getEnteteByTicket(PopUpInvoiceController.this.currentOrder.getId(), PopUpInvoiceController.this.currentOrder.isPaid());
                        List<TicketLineInfo> lines = PopUpInvoiceController.this.dlSales.loadLines(PopUpInvoiceController.this.currentOrder.getId());
                        List<TicketLineInfo> linesExterne = PopUpInvoiceController.this.dlSales.getTicketLineExterne(PopUpInvoiceController.this.currentOrder.getId());
                        lines.addAll(linesExterne);
                        PopUpInvoiceController.this.currentOrder.setLines(lines);
                        PopUpInvoiceController.this.couvertNumber = PopUpInvoiceController.this.currentOrder.getCouverts();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                    if (PopUpInvoiceController.this.currentOrder != null && PopUpInvoiceController.this.currentOrder.getInvoice() > 0) {
                        PopUpInvoiceController.this.btn_edit.setDisable(true);
                        PopUpInvoiceController.this.btn_reprint.setDisable(false);
                    } else {
                        PopUpInvoiceController.this.btn_edit.setDisable(false);
                        PopUpInvoiceController.this.btn_reprint.setDisable(true);
                    }
                }
            }
        });
        this.physical.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                if (PopUpInvoiceController.this.physical.isSelected()) {
                    PopUpInvoiceController.this.jCityLabel.setText(AppLocal.getIntString("Text.city"));
                    PopUpInvoiceController.this.jAddressLabel.setText(AppLocal.getIntString("Label.address"));
                    PopUpInvoiceController.this.edit_pane.getChildren().clear();
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.couvertFlowPane, 0, 0);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.switchMoralPhysicalFP, 0, 1);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jNameLabel, 0, 2);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jName, 1, 2);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jAddressLabel, 0, 3);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jAddress, 1, 3);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jCityLabel, 0, 4);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jCity, 1, 4);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jZipCodeLabel, 0, 5);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jZipCode, 1, 5);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jCountryLabel, 0, 6);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jCountry, 1, 6);
                    PopUpInvoiceController.this.couvertTextFeild.setText("" + PopUpInvoiceController.this.couvertNumber);
                    PopUpInvoiceController.this.couvertFlowPane.setSpacing(5.0);
                }
                if (PopUpInvoiceController.this.groupe != null) {
                    PopUpInvoiceController.this.groupe.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                        public void changed(ObservableValue<? extends Toggle> arg0, Toggle arg1, Toggle arg2) {
                        }
                    });
                }
            }
        });
        this.moral.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                if (PopUpInvoiceController.this.moral.isSelected()) {
                    PopUpInvoiceController.this.jCityLabel.setText(AppLocal.getIntString("Text.city") + "*");
                    PopUpInvoiceController.this.jAddressLabel.setText(AppLocal.getIntString("Label.address") + "*");
                    PopUpInvoiceController.this.edit_pane.getChildren().clear();
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.couvertFlowPane, 0, 0);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.switchMoralPhysicalFP, 0, 1);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jCompanyLabel, 0, 2);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jCompany, 1, 2);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jAddressLabel, 0, 3);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jAddress, 1, 3);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jCityLabel, 0, 4);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jCity, 1, 4);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jZipCodeLabel, 0, 5);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jZipCode, 1, 5);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jCountryLabel, 0, 6);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jCountry, 1, 6);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jSiretLabel, 0, 7);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jSiret, 1, 7);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jTVALabel, 0, 8);
                    PopUpInvoiceController.this.edit_pane.add((Node)PopUpInvoiceController.this.jTVA, 1, 8);
                    PopUpInvoiceController.this.couvertTextFeild.setText("" + PopUpInvoiceController.this.couvertNumber);
                    PopUpInvoiceController.this.couvertFlowPane.setSpacing(5.0);
                }
                if (PopUpInvoiceController.this.groupe != null) {
                    PopUpInvoiceController.this.groupe.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                        public void changed(ObservableValue<? extends Toggle> arg0, Toggle arg1, Toggle arg2) {
                        }
                    });
                }
            }
        });
        Calendar calToday = Calendar.getInstance();
        this.date = DateUtils.getToday();
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
        this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
        this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hourOrder"));
        this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("typeOrder"));
        this.etat_order.setCellValueFactory((Callback)new PropertyValueFactory("etatOrder"));
        this.total_order.setCellValueFactory((Callback)new PropertyValueFactory("totalOrder"));
        this.serveur_order.setCellValueFactory((Callback)new PropertyValueFactory("serveurOrder"));
        this.num_order.setSortable(false);
        this.date_order.setSortable(false);
        this.hour_order.setSortable(false);
        this.type_order.setSortable(false);
        this.etat_order.setSortable(false);
        this.total_order.setSortable(false);
        this.serveur_order.setSortable(false);
        if (AppLocal.licence.equals("venteDetail")) {
            this.tableView.getColumns().remove((Object)this.type_order);
            this.num_order.setPrefWidth(widthPane * 0.15);
            this.date_order.setPrefWidth(widthPane * 0.15);
            this.hour_order.setPrefWidth(widthPane * 0.15);
            this.etat_order.setPrefWidth(widthPane * 0.15);
            this.total_order.setPrefWidth(widthPane * 0.2);
            this.serveur_order.setPrefWidth(widthPane * 0.15);
        } else {
            this.num_order.setPrefWidth(widthPane * 0.12);
            this.date_order.setPrefWidth(widthPane * 0.15);
            this.hour_order.setPrefWidth(widthPane * 0.12);
            this.type_order.setPrefWidth(widthPane * 0.12);
            this.etat_order.setPrefWidth(widthPane * 0.12);
            this.total_order.setPrefWidth(widthPane * 0.15);
            this.serveur_order.setPrefWidth(widthPane * 0.15);
        }
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date = calToday.getTime();
        }
        this.setTime(this.date);
        try {
            this.loadOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        this.top_invoice_pane.getChildren().clear();
        this.top_invoice_pane.add((Node)this.tableView, 0, 0);
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.btn_edit, 0, 0);
        this.footer_print_pane.add((Node)this.btn_reprint, 1, 0);
        this.btn_print_facture.setDisable(false);
        this.tableView_invoices.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (PopUpInvoiceController.this.tableView_invoices.getSelectionModel().getSelectedIndex() != -1 && (row = PopUpInvoiceController.this.tableView_invoices.getSelectionModel().getSelectedIndex()) != -1) {
                    PopUpInvoiceController.this.currentInvoice = PopUpInvoiceController.this.factures.get(row);
                    PopUpInvoiceController.this.btn_edit.setDisable(true);
                    PopUpInvoiceController.this.btn_reprint.setDisable(false);
                }
            }
        });
        this.id_invoice.setCellValueFactory((Callback)new PropertyValueFactory("idInvoice"));
        this.type_customer.setCellValueFactory((Callback)new PropertyValueFactory("typeCustomer"));
        this.address.setCellValueFactory((Callback)new PropertyValueFactory("address"));
        this.zip_code.setCellValueFactory((Callback)new PropertyValueFactory("zipCode"));
        this.name.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.typeDocument.setCellValueFactory((Callback)new PropertyValueFactory("typeDocument"));
        this.date_invoice.setCellValueFactory((Callback)new PropertyValueFactory("dateInvoice"));
        this.total_ttc.setCellValueFactory((Callback)new PropertyValueFactory("totalTTC"));
        Image imageNext = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1rightarrow.png"));
        this.btn_next_date.setGraphic((Node)new ImageView(imageNext));
        Image imagebPrevious = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1leftarrow.png"));
        this.btn_previous_date.setGraphic((Node)new ImageView(imagebPrevious));
        this.setTexts();
        this.showEditInvoiceView();
        this.factures = new ArrayList<Facture>();
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object app) {
        this.stage = mStage;
        this.app = (AppView)app;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        if (objects != null) {
            for (Object object : objects) {
                if (!(object instanceof AppView)) continue;
                this.app = (AppView)object;
            }
        }
        this.initializer();
    }

    private void setTexts() {
        this.date_order.setText(AppLocal.getIntString("Label.date"));
        this.hour_order.setText(AppLocal.getIntString("Label.heure"));
        this.type_order.setText(AppLocal.getIntString("Label.type"));
        this.etat_order.setText(AppLocal.getIntString("Label.state"));
        this.total_order.setText(AppLocal.getIntString("Label.total"));
        this.serveur_order.setText(AppLocal.getIntString("Label.cashier"));
        this.label_number_covered.setText(AppLocal.getIntString("Label.number.covered") + " : ");
        this.moral.setText(AppLocal.getIntString("Label.moral.person"));
        this.physical.setText(AppLocal.getIntString("Label.physical.person"));
        this.jCompanyLabel.setText(AppLocal.getIntString("Label.company") + " *");
        this.jNameLabel.setText(AppLocal.getIntString("Label.customer.name") + "*");
        this.jAddressLabel.setText(AppLocal.getIntString("Label.address") + "*");
        this.jZipCodeLabel.setText(AppLocal.getIntString("Text.zipCode") + "*");
        this.jCityLabel.setText(AppLocal.getIntString("Text.city") + "*");
        this.jCountryLabel.setText(AppLocal.getIntString("Label.country") + "*");
        this.jSiretLabel.setText(AppLocal.getIntString("Label.siret") + "*");
        this.jTVALabel.setText(AppLocal.getIntString("Label.tva") + "*");
        this.btn_print_facture.setText(AppLocal.getIntString("Button.print.invoice"));
        this.btn_edit.setText(AppLocal.getIntString("Button.edit.invoice"));
        this.btn_reprint.setText(AppLocal.getIntString("Button.reprint.invoice"));
        this.id_invoice.setText("Num");
        this.type_customer.setText("Physique/Moral");
        this.address.setText("Adress");
        this.zip_code.setText("Code postale");
        this.name.setText("Nom/Soci\u00e9t\u00e9");
        this.typeDocument.setText("Type document");
        this.date_invoice.setText("Date de Facturation");
        this.total_ttc.setText("Total");
    }

    public void showEditInvoiceView() {
        this.editInvoice = true;
        this.currentOrder = null;
        Calendar calToday = Calendar.getInstance();
        this.date = DateUtils.getToday();
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date = calToday.getTime();
        }
        this.setTime(this.date);
        try {
            this.loadOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.selectTypeOrder(this.btn_edit_invoice);
        this.deselectTypeOrder(this.btn_list_invoices);
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.top_invoice_pane, 0, 0);
        this.btn_reprint.setText(AppLocal.getIntString("Button.reprint.invoice"));
    }

    public void showListInvoicesView() {
        this.editInvoice = false;
        Calendar calToday = Calendar.getInstance();
        this.date = DateUtils.getToday();
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date = calToday.getTime();
        }
        this.setTime(this.date);
        this.jdate.setText(AppLocal.getIntString("Label.today"));
        this.btn_next_date.setVisible(false);
        this.loadInvoices();
        this.deselectTypeOrder(this.btn_edit_invoice);
        this.selectTypeOrder(this.btn_list_invoices);
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.list_factures_pane, 0, 0);
        this.btn_reprint.setText("Imprimer");
    }

    private void loadInvoices() {
        try {
            this.currentInvoice = null;
            this.currentOrder = null;
            this.entetTicket = null;
            this.factures = this.dlSales.getFactures(this.dateStart, this.dateEnd);
            ArrayList<InvoiceView> items = new ArrayList<InvoiceView>();
            for (Facture facture : this.factures) {
                String typeCustomer = facture.isPhysical_person() ? "Personne Physique " : "Personne moral";
                String address = facture.getAddress() + " " + facture.getCity() + " " + facture.getCountry();
                String nameCustomer = facture.isPhysical_person() ? facture.getName_contact() : facture.getCompany();
                items.add(new InvoiceView(typeCustomer, address, facture.getZip_code(), nameCustomer, this.dateFormatterFullFacture.format(facture.getDateFacture()), Formats.CURRENCY.formatValue(facture.getTotal()), facture.getType_operation(), String.valueOf(facture.getId())));
            }
            ObservableList data = FXCollections.observableArrayList(items);
            this.tableView_invoices.setItems(data);
            this.btn_reprint.setDisable(true);
            this.btn_edit.setDisable(true);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void selectTypeOrder(Button button) {
        this.removeStyleClass(button, "invoice", "invoice_selected");
    }

    private void deselectTypeOrder(Button button) {
        this.removeStyleClass(button, "invoice_selected", "invoice");
    }

    private void removeStyleClass(Button button, String first, String second) {
        button.getStyleClass().remove((Object)first);
        if (!button.getStyleClass().contains((Object)second)) {
            button.getStyleClass().add((Object)second);
        }
    }

    public void next() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, 1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText(AppLocal.getIntString("Label.today"));
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jdate.setText(AppLocal.getIntString("Label.yesterday"));
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        try {
            this.loadInvoices();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void previous() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, -1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText(AppLocal.getIntString("Label.today"));
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jdate.setText(AppLocal.getIntString("Label.yesterday"));
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        try {
            this.loadInvoices();
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }
}

