/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.CatalogGrouItems;
import com.openbravo.components.NodeItemOnOff;
import com.openbravo.components.SwitchButton;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.events.CustomCatalogGroupOptions;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.ImagesUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PopUpGestionStockOptionController
implements RootController {
    @FXML
    GridPane pane_weight;
    @FXML
    GridPane pane_next_prev;
    @FXML
    GridPane pane_option;
    @FXML
    GridPane grid_main;
    @FXML
    Button btn_previous;
    @FXML
    Button next_btn;
    @FXML
    Label label_option;
    @FXML
    GridPane panel_main;
    @FXML
    GridPane pane_footer;
    @FXML
    GridPane paneAllGOption;
    @FXML
    ListView listGroupsOptions;
    @FXML
    Button products_button;
    @FXML
    Button options_button;
    @FXML
    Button ingredients_button;
    @FXML
    Button btn_synchronize;
    private List<CatalogGrouItems> listItemsGroupsOptions;
    private ObservableList observableListGroupsOptions;
    private List<Button> btnsOptions;
    private AppView m_App;
    private DataLogicSales dlSales;
    private DataLogicItems dlItems;
    private List<SupplementInfo> options;
    private double widthPopUp;
    private double heightPopUp;
    private double widthOptions;
    private double heightOption;
    private int column;
    private int row;
    private int index;
    private int indexItemOption;
    private int numberPageItemOption;
    private double numberColumnItemOption;
    private double numberRowItemOption;
    private double widthButtonItemOption;
    private double heightButtonItemOption;
    private int pagesGOptions;
    private int pagesOptions;
    private int indexG;
    private Image imageNext;
    private Image imagebPrevious;
    private Label titleGridOption;
    private GridPane[] panesGOptions;
    private FilerUtils m_FilerUtils = null;
    private HashMap<Integer, Button> listButtonGOptions;
    private HashMap<Integer, SupplementInfo> listGroupeOptions;
    private int indexGroupeOption;
    private HashMap<Integer, Integer> listPageByGroupeOption;
    private HashMap<Integer, Integer> listGroupeOptionByPage;
    private String bg_cell;
    private String text_cell;
    private String bg_color;
    private ImagesUtils mImagesUtils;
    private HashMap<Integer, SoftReference> refOptions;
    private HashMap<Integer, SoftReference> refProducts;
    private List<ProductInfoExt> subProducts;
    private int indexGO = 0;
    private Stage stage;
    private ItemService mItemService;
    private final String SIZE_IMAGE_128 = "_128px";
    private List<SupplementInfo> optionsDB;
    public static final String STR_INGREDIENTS = "ingredients";
    public static final String STR_CATEGORIES = "categories";
    public static final String STR_OPTIONS = "options";
    public static final String STR_OPTION_ITEM = "option_item";
    public static final String STR_PRODUCT_ITEM = "product_item";
    public static final String STR_INGREDIENT_ITEM = "ingredient_item";
    private List<CategoryInfo> categories;
    private List<CategoryInfo> categoriesDB;
    private List<SupplementInfo> ingredients;
    private HashMap<Integer, SupplementItemInfo> ingredientsItem;
    private HashMap<Integer, SupplementItemInfo> optionsItem;
    private HashMap<Integer, ProductInfoExt> productsItem;
    private EventHandler mEventHandlerClickSwitchOption = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            GridPane paneSwitch;
            NodeItemOnOff paneOption;
            SwitchButton mSwitchButton = null;
            if (event.getSource() instanceof SwitchButton) {
                mSwitchButton = (SwitchButton)((Object)event.getSource());
            } else if (event.getSource() instanceof Button) {
                Button button = (Button)event.getSource();
                mSwitchButton = (SwitchButton)button.getParent();
            }
            if (mSwitchButton != null && (paneOption = (NodeItemOnOff)(paneSwitch = (GridPane)mSwitchButton.getParent()).getParent()) != null && paneOption.getItem() instanceof SupplementItemInfo) {
                SupplementItemInfo option;
                SupplementItemInfo supplementItemInfo = option = paneOption != null ? (SupplementItemInfo)paneOption.getItem() : null;
                if (mSwitchButton.isState()) {
                    mSwitchButton.setOff();
                    PopUpGestionStockOptionController.this.setSoldOut(option, true);
                } else {
                    mSwitchButton.setOn();
                    PopUpGestionStockOptionController.this.setSoldOut(option, false);
                }
            }
        }
    };
    private EventHandler mEventHandlerGroupOptionsAction = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            Button buttonSource = (Button)event.getSource();
            CatalogGrouItems catalogGrouOptions = (CatalogGrouItems)buttonSource.getParent();
            if (catalogGrouOptions != null && catalogGrouOptions.getGroupItems() != null && catalogGrouOptions.getGroupItems() instanceof SupplementInfo) {
                PopUpGestionStockOptionController.this.selectGroupOptions(catalogGrouOptions);
            }
        }
    };
    private EventHandler mEventHandlerCategoriesAction = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            Button buttonSource = (Button)event.getSource();
            CatalogGrouItems catalogGrouOptions = (CatalogGrouItems)buttonSource.getParent();
            if (catalogGrouOptions != null && catalogGrouOptions.getGroupItems() != null && catalogGrouOptions.getGroupItems() instanceof CategoryInfo) {
                PopUpGestionStockOptionController.this.selectCategory(catalogGrouOptions);
            }
        }
    };
    private EventHandler mEventHandlerClickSwitchProduct = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            GridPane paneSwitch;
            NodeItemOnOff paneProduct;
            SwitchButton mSwitchButton = null;
            if (event.getSource() instanceof SwitchButton) {
                mSwitchButton = (SwitchButton)((Object)event.getSource());
            } else if (event.getSource() instanceof Button) {
                Button button = (Button)event.getSource();
                mSwitchButton = (SwitchButton)button.getParent();
            }
            if (mSwitchButton != null && (paneProduct = (NodeItemOnOff)(paneSwitch = (GridPane)mSwitchButton.getParent()).getParent()) != null && paneProduct.getItem() instanceof ProductInfoExt) {
                ProductInfoExt product;
                ProductInfoExt productInfoExt = product = paneProduct != null ? (ProductInfoExt)paneProduct.getItem() : null;
                if (mSwitchButton.isState()) {
                    mSwitchButton.setOff();
                    PopUpGestionStockOptionController.this.setSoldOutProduct(product, true);
                } else {
                    mSwitchButton.setOn();
                    PopUpGestionStockOptionController.this.setSoldOutProduct(product, false);
                }
            }
        }
    };
    private EventHandler mEventHandlerGroupIngredientsAction = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            Button buttonSource = (Button)event.getSource();
            CatalogGrouItems catalogGrouIngredients = (CatalogGrouItems)buttonSource.getParent();
            if (catalogGrouIngredients != null && catalogGrouIngredients.getGroupItems() != null && catalogGrouIngredients.getGroupItems() instanceof SupplementInfo) {
                PopUpGestionStockOptionController.this.selectGroupIngredients(catalogGrouIngredients);
            }
        }
    };
    private EventHandler mEventHandlerClickSwitchIngredient = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            GridPane paneSwitch;
            NodeItemOnOff paneOption;
            SwitchButton mSwitchButton = null;
            if (event.getSource() instanceof SwitchButton) {
                mSwitchButton = (SwitchButton)((Object)event.getSource());
            } else if (event.getSource() instanceof Button) {
                Button button = (Button)event.getSource();
                mSwitchButton = (SwitchButton)button.getParent();
            }
            if (mSwitchButton != null && (paneOption = (NodeItemOnOff)(paneSwitch = (GridPane)mSwitchButton.getParent()).getParent()) != null && paneOption.getItem() instanceof SupplementItemInfo) {
                SupplementItemInfo ingredient;
                SupplementItemInfo supplementItemInfo = ingredient = paneOption != null ? (SupplementItemInfo)paneOption.getItem() : null;
                if (mSwitchButton.isState()) {
                    mSwitchButton.setOff();
                    PopUpGestionStockOptionController.this.setSoldOutIngrdient(ingredient, true);
                } else {
                    mSwitchButton.setOn();
                    PopUpGestionStockOptionController.this.setSoldOutIngrdient(ingredient, false);
                }
            }
        }
    };

    public void initializer(AppView m_App, HashMap<Integer, SoftReference> refOptions, HashMap<Integer, SoftReference> refProducts) {
        try {
            this.refOptions = refOptions;
            this.refProducts = refProducts;
            this.ingredientsItem = new HashMap();
            this.optionsItem = new HashMap();
            this.productsItem = new HashMap();
            this.mImagesUtils = new ImagesUtils();
            if (AppLocal.bg_options != null) {
                if (AppLocal.bg_options.equals("black")) {
                    this.bg_cell = "bg-black";
                    this.text_cell = "text-white";
                    this.bg_color = "black";
                } else {
                    this.bg_cell = "bg-white";
                    this.text_cell = "text-black";
                    this.bg_color = "white";
                }
            }
            this.panel_main.getStyleClass().add((Object)this.bg_cell);
            this.listButtonGOptions = new HashMap();
            this.listGroupeOptions = new HashMap();
            this.listPageByGroupeOption = new HashMap();
            this.listGroupeOptionByPage = new HashMap();
            this.m_FilerUtils = FilerUtils.getInstance();
            this.widthPopUp = AppVarUtils.getScreenDimension().getWidth() * 0.9;
            this.heightPopUp = AppVarUtils.getScreenDimension().getHeight() - 100.0;
            this.btnsOptions = new ArrayList<Button>();
            this.imageNext = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1rightarrow.png"));
            this.imagebPrevious = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1leftarrow.png"));
            Image imagebUpload = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/upload_icon_60x60.png"));
            this.btn_synchronize.setGraphic((Node)new ImageView(imagebUpload));
            this.widthOptions = this.widthPopUp * 0.78;
            this.heightOption = this.heightPopUp * 0.9;
            this.m_App = m_App;
            this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
            this.dlItems = (DataLogicItems)m_App.getBean("com.openbravo.dao.DataLogicItems");
            this.dlSales.setDlItems(this.dlItems);
            this.options = new ArrayList<SupplementInfo>();
            this.optionsDB = this.dlSales.getSupplements();
            for (SupplementInfo option : this.optionsDB) {
                if (!option.getItems().isEmpty()) continue;
                ArrayList<SupplementItemInfo> optionsItem = new ArrayList();
                optionsItem = this.dlItems.getSuppelementsItem(option.getiD(), true, false);
                option.setItems(optionsItem);
            }
            List<SupplementItemInfo> optionsItemSoldOut = this.getOptionsSoldOut();
            if (optionsItemSoldOut != null && !optionsItemSoldOut.isEmpty()) {
                SupplementInfo groupOptionsSoldOut = new SupplementInfo();
                groupOptionsSoldOut.setName("Supplements en rupture");
                groupOptionsSoldOut.setItems(optionsItemSoldOut);
                groupOptionsSoldOut.setSold_out(true);
                this.options.add(groupOptionsSoldOut);
            }
            this.options.addAll(this.optionsDB);
            this.categoriesDB = this.dlSales.getCategoriesCaisse(true);
            this.categories = new ArrayList<CategoryInfo>();
            for (CategoryInfo category : this.categoriesDB) {
                category.setProducts(this.dlItems.getProductsByCategory(category.getID()));
            }
            List<ProductInfoExt> productsSoldOut = this.getProductsSoldOut();
            if (productsSoldOut != null && !productsSoldOut.isEmpty()) {
                CategoryInfo categorySoldOut = new CategoryInfo();
                categorySoldOut.setName("Produits en rupture");
                categorySoldOut.setProducts(productsSoldOut);
                categorySoldOut.setSold_out_group_products(true);
                this.categories.add(categorySoldOut);
            }
            this.categories.addAll(this.categoriesDB);
            this.ingredients = this.dlSales.getIngredients();
            for (SupplementInfo ingredient : this.ingredients) {
                ingredient.setItems(this.dlSales.getIngredientsItem(ingredient.getiD()));
            }
            this.column = 0;
            this.row = 0;
            this.index = 0;
            this.setSizesNode(this.heightPopUp * 0.765);
            this.observableListGroupsOptions = FXCollections.observableArrayList();
            this.listItemsGroupsOptions = new ArrayList<CatalogGrouItems>();
            this.listGroupsOptions.setCellFactory((Callback)new Callback<ListView<CatalogGrouItems>, ListCell<CatalogGrouItems>>(){

                public CustomCatalogGroupOptions call(ListView<CatalogGrouItems> listView) {
                    return new CustomCatalogGroupOptions();
                }
            });
            this.loadCategories();
            ++this.index;
            this.mItemService = ItemService.getInstance();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void loadGroupsItems(List<CatalogGrouItems> groupItems) {
        CatalogGrouItems firstGroupItems;
        if (this.listGroupsOptions.getItems().isEmpty()) {
            this.listGroupsOptions.getItems().clear();
        }
        if (!this.listItemsGroupsOptions.isEmpty()) {
            this.listItemsGroupsOptions.clear();
        }
        if (!this.observableListGroupsOptions.isEmpty()) {
            this.observableListGroupsOptions.clear();
        }
        for (CatalogGrouItems groupItem : groupItems) {
            this.listItemsGroupsOptions.add(groupItem);
        }
        this.observableListGroupsOptions.setAll(this.listItemsGroupsOptions);
        this.listGroupsOptions.setItems(this.observableListGroupsOptions);
        if (this.listGroupsOptions.getItems() != null && !this.listGroupsOptions.getItems().isEmpty() && (firstGroupItems = (CatalogGrouItems)((Object)this.listGroupsOptions.getItems().get(0))) != null) {
            System.out.println("firstGroupItems.getGroup_type() : " + firstGroupItems.getGroup_type());
            switch (firstGroupItems.getGroup_type()) {
                case "categories": {
                    if (!(firstGroupItems.getGroupItems() instanceof CategoryInfo)) break;
                    this.selectCategory(firstGroupItems);
                    break;
                }
                case "options": {
                    if (!(firstGroupItems.getGroupItems() instanceof SupplementInfo)) break;
                    this.selectGroupOptions(firstGroupItems);
                    break;
                }
                case "ingredients": {
                    if (!(firstGroupItems.getGroupItems() instanceof SupplementInfo)) break;
                    this.selectGroupIngredients(firstGroupItems);
                }
            }
        }
    }

    public void loadGroupsOptions() {
        this.options_button.setStyle("-fx-background-color: #f56123;-fx-background-radius: 10px, -fx-border-radius: 10px");
        this.products_button.setStyle("-fx-background-color: " + this.bg_color + ";-fx-background-radius: 10px, -fx-border-radius: 10px");
        this.ingredients_button.setStyle("-fx-background-color: " + this.bg_color + ";-fx-background-radius: 10px, -fx-border-radius: 10px");
        ArrayList<CatalogGrouItems> groupItems = new ArrayList<CatalogGrouItems>();
        int lineGOption = 7;
        double height = this.heightOption * 0.9 / (double)lineGOption;
        for (SupplementInfo option : this.options) {
            CatalogGrouItems mCatalogGrouOptions = new CatalogGrouItems(option, STR_OPTIONS, height);
            mCatalogGrouOptions.getButton().setOnMouseClicked(this.mEventHandlerGroupOptionsAction);
            groupItems.add(mCatalogGrouOptions);
        }
        this.loadGroupsItems(groupItems);
    }

    public void loadGroupsIngredients() {
        this.ingredients_button.setStyle("-fx-background-color: #f56123;-fx-background-radius: 10px, -fx-border-radius: 10px");
        this.products_button.setStyle("-fx-background-color: " + this.bg_color + ";-fx-background-radius: 10px, -fx-border-radius: 10px");
        this.options_button.setStyle("-fx-background-color: " + this.bg_color + ";-fx-background-radius: 10px, -fx-border-radius: 10px");
        ArrayList<CatalogGrouItems> groupItems = new ArrayList<CatalogGrouItems>();
        int lineGOption = 7;
        double height = this.heightOption * 0.9 / (double)lineGOption;
        for (SupplementInfo groupIngredient : this.ingredients) {
            CatalogGrouItems catalogGroupIngredient = new CatalogGrouItems(groupIngredient, STR_INGREDIENTS, height);
            catalogGroupIngredient.getButton().setOnMouseClicked(this.mEventHandlerGroupIngredientsAction);
            groupItems.add(catalogGroupIngredient);
        }
        this.loadGroupsItems(groupItems);
    }

    public void loadCategories() {
        this.products_button.setStyle("-fx-background-color: #f56123;-fx-background-radius: 10px, -fx-border-radius: 10px");
        this.options_button.setStyle("-fx-background-color: " + this.bg_color + ";-fx-background-radius: 10px, -fx-border-radius: 10px");
        this.ingredients_button.setStyle("-fx-background-color: " + this.bg_color + ";-fx-background-radius: 10px, -fx-border-radius: 10px");
        ArrayList<CatalogGrouItems> groupItems = new ArrayList<CatalogGrouItems>();
        int lineGOption = 7;
        double height = this.heightOption * 0.9 / (double)lineGOption;
        for (CategoryInfo category : this.categories) {
            CatalogGrouItems groupItem = new CatalogGrouItems(category, STR_CATEGORIES, height);
            groupItem.getButton().setOnMouseClicked(this.mEventHandlerCategoriesAction);
            groupItems.add(groupItem);
        }
        this.loadGroupsItems(groupItems);
    }

    private void selectGroupOptions(CatalogGrouItems mCatalogGrouOptions) {
        try {
            this.deselectAllGroupsItems();
            this.selectGroupItems(mCatalogGrouOptions.getButton());
            this.selectGroupeOption((SupplementInfo)mCatalogGrouOptions.getGroupItems());
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void deselectAllGroupsItems() {
        for (Object item : this.listGroupsOptions.getItems()) {
            Button button = ((CatalogGrouItems)((Object)item)).getButton();
            if (button == null) continue;
            button.setStyle("-fx-background-color: " + this.bg_color + "; -fx-background-radius: 10px");
        }
    }

    private void selectGroupItems(Button button) {
        button.setStyle("-fx-background-color: #f56123; -fx-background-radius: 10px");
    }

    private void selectGroupeOption(SupplementInfo Goption) throws BasicException {
        this.loadGridOption(Goption);
    }

    public void loadGridOption(SupplementInfo Goption) throws BasicException {
        int sizeTotal;
        this.pane_option.getChildren().clear();
        if (Goption.isSold_out()) {
            List<SupplementItemInfo> optionsItemSoldOut = this.getOptionsSoldOut();
            Goption.setItems(optionsItemSoldOut);
        }
        if ((sizeTotal = Goption.getItems().size()) > 0) {
            ArrayList<GridPane> buttonsOptions = new ArrayList<GridPane>();
            for (SupplementItemInfo optionItem : Goption.getItems()) {
                Image image = null;
                if (AppLocal.SHOW_IMAGE_OPTIONS) {
                    image = this.mImagesUtils.getImageOption(optionItem, this.refOptions, "_128px", false);
                }
                NodeItemOnOff btnSupplement = new NodeItemOnOff().item(optionItem).image(image).itemType(STR_OPTION_ITEM).height(this.heightButtonItemOption).width(this.widthButtonItemOption).build();
                if (AppLocal.bg_options.equals("black")) {
                    btnSupplement.setStyle("-fx-background-color: #000000;-fx-background-radius: 10px, -fx-border-radius: 10px;");
                } else {
                    btnSupplement.setStyle("-fx-background-color: #ffffff;-fx-background-radius: 10px, -fx-border-radius: 10px;");
                }
                if (!btnSupplement.getStyleClass().contains((Object)"gestion_stock_item_cell")) {
                    btnSupplement.getStyleClass().add((Object)"gestion_stock_item_cell");
                }
                btnSupplement.getmSwitchButton().setOnMouseClicked(this.mEventHandlerClickSwitchOption);
                btnSupplement.getmSwitchButton().getButton().setOnMouseClicked(this.mEventHandlerClickSwitchOption);
                buttonsOptions.add(btnSupplement);
            }
            this.showItems(buttonsOptions);
        }
    }

    private void nextPageGroupeOption() {
        if (this.indexG < this.pagesGOptions - 1) {
            ++this.indexG;
            if (this.listGroupeOptionByPage.containsKey(this.indexG)) {
                int n = this.listGroupeOptionByPage.get(this.indexG);
            }
            this.paneAllGOption.getChildren().clear();
            this.paneAllGOption.add((Node)this.panesGOptions[this.indexG], 0, 0);
        }
    }

    private void previousPageGroupeOption() {
        if (this.indexG > 0) {
            --this.indexG;
            int indexResult = this.listGroupeOptionByPage.get(this.indexG);
            this.paneAllGOption.getChildren().clear();
            this.paneAllGOption.add((Node)this.panesGOptions[this.indexG], 0, 0);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer(null, null, null);
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        AppView app = (AppView)object;
        this.initializer(app, null, null);
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        AppView app = (AppView)objects[0];
        HashMap refOptions = (HashMap)objects[1];
        HashMap refProducts = (HashMap)objects[2];
        this.initializer(app, refOptions, refProducts);
    }

    private void showItems(List<GridPane> buttonsOptions) {
        this.numberPageItemOption = (int)Math.ceil((double)buttonsOptions.size() / 24.0);
        final GridPane[] paneOptionItems = new GridPane[this.numberPageItemOption];
        for (int i = 0; i < this.numberPageItemOption; ++i) {
            paneOptionItems[i] = new GridPane();
            paneOptionItems[i].setHgap(5.0);
            paneOptionItems[i].setVgap(5.0);
        }
        this.column = 0;
        this.row = 0;
        this.indexItemOption = 0;
        for (GridPane btnSupplement : buttonsOptions) {
            if ((double)this.row == this.numberRowItemOption - 1.0 && (double)this.column == this.numberColumnItemOption - 1.0) {
                btnSupplement.setPrefHeight(this.heightButtonItemOption);
                btnSupplement.setPrefWidth(this.widthButtonItemOption);
                paneOptionItems[this.indexItemOption].add((Node)btnSupplement, this.column, this.row);
                ++this.indexItemOption;
                this.column = 0;
                this.row = 0;
                continue;
            }
            btnSupplement.setPrefHeight(this.heightButtonItemOption);
            btnSupplement.setPrefWidth(this.widthButtonItemOption);
            paneOptionItems[this.indexItemOption].add((Node)btnSupplement, this.column, this.row);
            if ((double)this.row < this.numberRowItemOption - 1.0) {
                ++this.row;
                continue;
            }
            if (!((double)this.column < this.numberColumnItemOption - 1.0)) continue;
            this.row = 0;
            ++this.column;
        }
        if (this.indexItemOption < this.numberPageItemOption) {
            while (this.numberRowItemOption >= (double)(this.row + 1) && this.numberColumnItemOption >= (double)(this.column + 1)) {
                Button btn = new Button();
                btn.getStyleClass().add((Object)"gestion_stock_item_cell");
                btn.getStyleClass().add((Object)this.bg_cell);
                btn.setPrefHeight(this.heightButtonItemOption);
                btn.setPrefWidth(this.widthButtonItemOption);
                paneOptionItems[this.indexItemOption].add((Node)btn, this.column, this.row);
                if ((double)this.row < this.numberRowItemOption - 1.0) {
                    ++this.row;
                    continue;
                }
                if (!((double)this.column < this.numberColumnItemOption - 1.0)) break;
                this.row = 0;
                ++this.column;
            }
        }
        this.pagesOptions = 0;
        this.pane_option.add((Node)paneOptionItems[this.pagesOptions], 0, 0);
        this.pane_footer.getChildren().clear();
        if (buttonsOptions.size() > 25) {
            Button nextFamille = new Button();
            Button previuosFamille = new Button();
            Image imageNext = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1rightarrow.png"));
            nextFamille.setGraphic((Node)new ImageView(imageNext));
            Image imagebPrevious = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1leftarrow.png"));
            previuosFamille.setGraphic((Node)new ImageView(imagebPrevious));
            previuosFamille.setPrefHeight(this.heightPopUp * 0.1);
            nextFamille.setPrefHeight(this.heightPopUp * 0.1);
            nextFamille.setPrefWidth(this.widthButtonItemOption / 2.0 - 4.0);
            previuosFamille.setPrefWidth(this.widthButtonItemOption / 2.0 - 4.0);
            nextFamille.getStyleClass().add((Object)"gestion_stock_item_cell");
            previuosFamille.getStyleClass().add((Object)"gestion_stock_item_cell");
            nextFamille.getStyleClass().add((Object)this.bg_cell);
            previuosFamille.getStyleClass().add((Object)this.bg_cell);
            nextFamille.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (PopUpGestionStockOptionController.this.pagesOptions < PopUpGestionStockOptionController.this.numberPageItemOption - 1) {
                        ++PopUpGestionStockOptionController.this.pagesOptions;
                        PopUpGestionStockOptionController.this.pane_option.getChildren().clear();
                        PopUpGestionStockOptionController.this.pane_option.add((Node)paneOptionItems[PopUpGestionStockOptionController.this.pagesOptions], 0, 0);
                    }
                }
            });
            previuosFamille.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    if (PopUpGestionStockOptionController.this.pagesOptions > 0) {
                        --PopUpGestionStockOptionController.this.pagesOptions;
                        PopUpGestionStockOptionController.this.pane_option.getChildren().clear();
                        PopUpGestionStockOptionController.this.pane_option.add((Node)paneOptionItems[PopUpGestionStockOptionController.this.pagesOptions], 0, 0);
                    }
                }
            });
            this.pane_footer.add((Node)previuosFamille, 0, 0);
            this.pane_footer.add((Node)nextFamille, 1, 0);
        }
    }

    private void setSizesNode(double height) {
        this.numberColumnItemOption = 5.0;
        this.numberRowItemOption = 5.0;
        this.widthButtonItemOption = this.widthOptions / this.numberColumnItemOption;
        this.heightButtonItemOption = height / this.numberRowItemOption;
    }

    public void closePopUp() {
        this.synchroniszeItems();
        this.stage.close();
    }

    private void setSoldOut(SupplementItemInfo option, boolean sold_out) {
        this.mItemService.setSoldOutOption(option.getiD(), sold_out);
        option.setSold_out(sold_out);
        this.addOption(option);
    }

    private List<SupplementItemInfo> getOptionsSoldOut() {
        ArrayList<SupplementItemInfo> optionsItemSoldOut = new ArrayList<SupplementItemInfo>();
        for (SupplementInfo supplementInfo : this.optionsDB) {
            for (SupplementItemInfo item : supplementInfo.getItems()) {
                if (!item.isSold_out()) continue;
                optionsItemSoldOut.add(item);
            }
        }
        return optionsItemSoldOut;
    }

    private void selectCategory(CatalogGrouItems groupItems) {
        try {
            this.deselectAllGroupsItems();
            this.selectGroupItems(groupItems.getButton());
            this.selectCategory((CategoryInfo)groupItems.getGroupItems());
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void selectCategory(CategoryInfo category) throws BasicException {
        int sizeTotal;
        this.pane_option.getChildren().clear();
        if (category.isSold_out_group_products()) {
            List<ProductInfoExt> products = this.getProductsSoldOut();
            category.setProducts(products);
        }
        if ((sizeTotal = category.getProducts().size()) > 0) {
            ArrayList<GridPane> buttonsOptions = new ArrayList<GridPane>();
            for (ProductInfoExt product : category.getProducts()) {
                Image image = null;
                if (AppLocal.SHOW_IMAGE_PRODUCTS) {
                    image = this.mImagesUtils.getImageProduct(product, AppLocal.refProducts, "_128px", false);
                }
                NodeItemOnOff btnProduct = new NodeItemOnOff().item(product).image(image).itemType(STR_PRODUCT_ITEM).height(this.heightButtonItemOption).width(this.widthButtonItemOption).build();
                if (AppLocal.bg_options.equals("black")) {
                    btnProduct.setStyle("-fx-background-color: #000000;-fx-background-radius: 10px, -fx-border-radius: 10px;");
                } else {
                    btnProduct.setStyle("-fx-background-color: #ffffff;-fx-background-radius: 10px, -fx-border-radius: 10px;");
                }
                if (!btnProduct.getStyleClass().contains((Object)"gestion_stock_item_cell")) {
                    btnProduct.getStyleClass().add((Object)"gestion_stock_item_cell");
                }
                btnProduct.getmSwitchButton().setOnMouseClicked(this.mEventHandlerClickSwitchProduct);
                btnProduct.getmSwitchButton().getButton().setOnMouseClicked(this.mEventHandlerClickSwitchProduct);
                buttonsOptions.add(btnProduct);
            }
            this.showItems(buttonsOptions);
        }
    }

    private void setSoldOutProduct(ProductInfoExt product, boolean sold_out) {
        List<ProductInfoExt> products = this.mItemService.setSoldOut(product.getID(), sold_out);
        product.setSold_out(sold_out);
        AppLocal.product_management = true;
        products.add(product);
        this.addProducts(products);
    }

    private void selectGroupIngredients(CatalogGrouItems catalogGrouIngredients) {
        try {
            this.deselectAllGroupsItems();
            this.selectGroupItems(catalogGrouIngredients.getButton());
            this.selectGroupeIngredient((SupplementInfo)catalogGrouIngredients.getGroupItems());
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void selectGroupeIngredient(SupplementInfo groupIngredient) throws BasicException {
        this.loadGridIngredients(groupIngredient);
    }

    public void loadGridIngredients(SupplementInfo groupIngredient) throws BasicException {
        this.pane_option.getChildren().clear();
        int sizeTotal = groupIngredient.getItems().size();
        if (sizeTotal > 0) {
            ArrayList<GridPane> buttonsIngredients = new ArrayList<GridPane>();
            for (SupplementItemInfo optionItem : groupIngredient.getItems()) {
                Image image = null;
                if (AppLocal.SHOW_IMAGE_OPTIONS) {
                    image = this.mImagesUtils.getImageOption(optionItem, this.refOptions, "_128px", false);
                }
                NodeItemOnOff btnSupplement = new NodeItemOnOff().item(optionItem).image(image).itemType(STR_INGREDIENT_ITEM).height(this.heightButtonItemOption).width(this.widthButtonItemOption).build();
                if (AppLocal.bg_options.equals("black")) {
                    btnSupplement.setStyle("-fx-background-color: #000000;-fx-background-radius: 10px, -fx-border-radius: 10px;");
                } else {
                    btnSupplement.setStyle("-fx-background-color: #ffffff;-fx-background-radius: 10px, -fx-border-radius: 10px;");
                }
                if (!btnSupplement.getStyleClass().contains((Object)"gestion_stock_item_cell")) {
                    btnSupplement.getStyleClass().add((Object)"gestion_stock_item_cell");
                }
                btnSupplement.getmSwitchButton().setOnMouseClicked(this.mEventHandlerClickSwitchIngredient);
                btnSupplement.getmSwitchButton().getButton().setOnMouseClicked(this.mEventHandlerClickSwitchIngredient);
                buttonsIngredients.add(btnSupplement);
            }
            this.showItems(buttonsIngredients);
        }
    }

    private void setSoldOutIngrdient(SupplementItemInfo ingredient, boolean sold_out) {
        List<ProductInfoExt> products = this.mItemService.setSoldOutIngredient(ingredient.getiD(), sold_out);
        ingredient.setSold_out(sold_out);
        AppLocal.product_management = true;
        this.addIngeredientsAndProducts(ingredient, products);
    }

    private void addIngeredientsAndProducts(SupplementItemInfo ingredient, List<ProductInfoExt> products) {
        this.ingredientsItem.put(ingredient.getiD(), ingredient);
        for (ProductInfoExt product : products) {
            this.productsItem.put(product.getID(), product);
        }
    }

    private void addProducts(List<ProductInfoExt> products) {
        for (ProductInfoExt product : products) {
            this.productsItem.put(product.getID(), product);
        }
    }

    private void addOption(SupplementItemInfo option) {
        this.optionsItem.put(option.getiD(), option);
    }

    public void synchroniszeItems() {
        System.out.println("click on synchroniszeItems");
        if (!(this.productsItem.values().isEmpty() && this.ingredientsItem.values().isEmpty() && this.optionsItem.values().isEmpty())) {
            System.out.println("start click on synchroniszeItems");
            ArrayList<ProductInfoExt> listProducts = new ArrayList<ProductInfoExt>(this.productsItem.values());
            ArrayList<SupplementItemInfo> listIngredients = new ArrayList<SupplementItemInfo>(this.ingredientsItem.values());
            ArrayList<SupplementItemInfo> listOptions = new ArrayList<SupplementItemInfo>(this.optionsItem.values());
            this.mItemService.synchronizeItems(listProducts, listIngredients, listOptions);
            this.productsItem.clear();
            this.ingredientsItem.clear();
            this.optionsItem.clear();
        }
    }

    private List<ProductInfoExt> getProductsSoldOut() {
        ArrayList<ProductInfoExt> productsSoldOut = new ArrayList<ProductInfoExt>();
        for (CategoryInfo category : this.categoriesDB) {
            for (ProductInfoExt product : category.getProducts()) {
                if (!product.isSold_out()) continue;
                productsSoldOut.add(product);
            }
        }
        return productsSoldOut;
    }
}

