/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.CarteService;
import java.net.URISyntaxException;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;

public class PopUpDonwloadDBItemController
implements RootController {
    private Stage stage;
    private boolean isConfimed = false;
    @FXML
    Label labelMessage;
    @FXML
    Label message_download;
    @FXML
    Label labelTitle;
    @FXML
    Button textCancel;
    @FXML
    Button textConfirm;
    @FXML
    GridPane main_pane;
    @FXML
    GridPane confirm_pane;
    @FXML
    GridPane download_logo_pane;
    @FXML
    FlowPane download_pane;
    @FXML
    Label download_label;
    @FXML
    Label title_1;
    @FXML
    Label title_2;
    @FXML
    Label logo_label;
    private String m_textConfirm = "Oui";
    private String m_textCancel = "Non";
    private String title = "...";
    private String message = "Souhaitez-vous t\u00e9l\u00e9charger le fichier maintenant ?";
    private AppView m_App;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        if (this.labelMessage != null) {
            this.labelMessage.setText(message);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.labelTitle != null) {
            this.labelTitle.setText(title);
        }
    }

    public String getTextConfirm() {
        return this.m_textConfirm;
    }

    public String getTextCancel() {
        return this.m_textCancel;
    }

    public void setTextConfirm(String m_textConfirm) {
        this.m_textConfirm = m_textConfirm;
        if (this.textConfirm != null) {
            this.textConfirm.setText(m_textConfirm);
        }
    }

    public void setTextCancel(String m_textCancel) {
        this.m_textCancel = m_textCancel;
        if (this.textCancel != null) {
            this.textCancel.setText(m_textCancel);
        }
    }

    public void configureText(String mTitle) {
        this.setTitle(mTitle);
    }

    public void configureText(String mTitle, String mMessage) {
        this.setTitle(mTitle);
        this.setMessage(mMessage);
    }

    public void configureText(String mTitle, String mMessage, String mTextConfirm, String mTextCancel) {
        this.setTitle(mTitle);
        this.setMessage(mMessage);
        this.setTextConfirm(mTextConfirm);
        this.setTextCancel(mTextCancel);
    }

    public void cancel() {
        this.stage.close();
    }

    public void valider() {
        this.isConfimed = true;
        this.stage.close();
    }

    public boolean getResult() {
        return this.isConfimed;
    }

    private void initializer() {
        this.labelMessage.setText(this.message);
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.confirm_pane, 0, 0);
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        if (object instanceof String) {
            this.message = (String)object;
        }
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        for (Object object : objects) {
            if (!(object instanceof String)) continue;
            this.message = (String)object;
        }
        this.initializer();
    }

    private void downloadCarte() {
        this.setDesignDonwload();
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.download_logo_pane, 0, 0);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    CarteService mCarteService = new CarteService(AppLocal.dlSales, AppLocal.dlItems, PopUpDonwloadDBItemController.this.m_App);
                    mCarteService.downloadPicture();
                    mCarteService.downloadCarte();
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est telecharg\u00e9e.", 4000, NPosition.BOTTOM_RIGHT);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            PopUpDonwloadDBItemController.this.stage.close();
                        }
                    });
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.BOTTOM_RIGHT);
                }
            }
        }).start();
    }

    private void setDesignDonwload() {
        try {
            Stop[] stops = new Stop[]{new Stop(0.0, Color.web((String)"#EF3A13")), new Stop(1.0, Color.web((String)"#9241A7"))};
            LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.NO_CYCLE, stops);
            this.main_pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)linearGradient, new CornerRadii(20.0), null)}));
            Image image_logo = new Image(this.getClass().getResource("/com/openbravo/images/logo_biborne_new.png").toURI().toString());
            ImageView imageViewLogo = new ImageView(image_logo);
            imageViewLogo.setFitWidth(94.754);
            imageViewLogo.setFitHeight(31.77);
            imageViewLogo.setPreserveRatio(false);
            imageViewLogo.setSmooth(false);
            imageViewLogo.setCache(false);
            this.logo_label.setGraphic((Node)imageViewLogo);
            this.title_1.setText("Telechargement en Cours...");
            this.title_2.setText("Votre t\u00e9l\u00e9chargement est en cours. Merci de patienter");
            Image image_download = new Image(this.getClass().getResource("/com/openbravo/images/download_icon.png").toURI().toString());
            ImageView imageViewDownload = new ImageView(image_download);
            imageViewDownload.setFitWidth(AppVarUtils.getScreenDimension().getWidth() * 0.09);
            imageViewDownload.setPreserveRatio(true);
            imageViewDownload.setSmooth(true);
            imageViewDownload.setCache(true);
            this.download_label.setGraphic((Node)imageViewDownload);
        }
        catch (URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }
}

