/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.DateUtils;
import com.openbravo.controllers.displayKitchen.AddOrderInterface;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.printer.DisplayKitchenErrorsDialogue;
import com.openbravo.pos.printer.QueuedTicketView;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import java.rmi.Naming;
import java.rmi.Remote;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.util.Callback;

public class PopUpDKErrors {
    @FXML
    Button btn_next_date;
    @FXML
    Button btn_previous_date;
    @FXML
    Label jdate;
    @FXML
    TableView tableView;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn printer;
    @FXML
    TableColumn etat_order;
    @FXML
    TableColumn total_order;
    @FXML
    TableColumn serveur_order;
    @FXML
    Button btn_kitchen;
    @FXML
    Button btn_caisse;
    @FXML
    Button btn_cancel;
    @FXML
    Button btn_duplicate;
    @FXML
    GridPane footer_print_pane;
    @FXML
    GridPane footer_btns;
    @FXML
    GridPane footer_cancel;
    @FXML
    GridPane pane_main;
    @FXML
    FlowPane pane_raison;
    @FXML
    TextArea raison;
    private final SimpleDateFormat dateFormatter = com.openbravo.pos.util.DateUtils.formatterYEAR_MONTH_DAY_TIRETS6;
    private final SimpleDateFormat timeFormatter = com.openbravo.pos.util.DateUtils.timeFormatter;
    @FXML
    TableColumn commandNum;
    private AppView app;
    private Date date;
    protected DataLogicSales dlSales;
    List<TicketLineInfo> productToSend;
    private List<TicketInfo> documents;
    private TicketInfo document;
    protected DataLogicAdmin dlUsers;
    int row = -1;
    private static double widthPane = 700.0;
    private DisplayKitchenErrorsDialogue parent;

    public void init(Scene scene, AppView app, DisplayKitchenErrorsDialogue parent) throws BasicException {
        this.parent = parent;
        this.app = app;
        this.dlSales = (DataLogicSales)this.app.getBean("com.openbravo.dao.DataLogicSales");
        this.productToSend = new ArrayList<TicketLineInfo>();
        this.loadPaneFooter();
        this.switchToBtns();
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.tableView, 0, 0);
        this.document = null;
        this.tableView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                if (PopUpDKErrors.this.tableView.getSelectionModel().getSelectedIndex() != -1) {
                    PopUpDKErrors.this.row = PopUpDKErrors.this.tableView.getSelectionModel().getSelectedIndex();
                    if (PopUpDKErrors.this.row != -1) {
                        PopUpDKErrors.this.document = PopUpDKErrors.this.documents.get(PopUpDKErrors.this.row);
                        PopUpDKErrors.this.switchToBtns();
                    }
                }
            }
        });
        Calendar calToday = Calendar.getInstance();
        this.date = DateUtils.getToday();
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
        this.commandNum.setCellValueFactory((Callback)new PropertyValueFactory("commandNum"));
        this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
        this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hourOrder"));
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date = calToday.getTime();
        }
        this.loadDocuments();
    }

    public void next() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, 1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDay() == cal.getTime().getDay()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText("Aujourd'hui");
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDay() == cal.getTime().getDay()) {
            this.jdate.setText("Hier");
        }
        this.date = cal.getTime();
        this.loadDocuments();
    }

    private void loadDocuments() {
        if (AppVarUtils.ERRONEOUS_TICKETS_DK != null) {
            this.documents = new ArrayList<TicketInfo>(AppVarUtils.ERRONEOUS_TICKETS_DK.values());
            ArrayList<QueuedTicketView> items = new ArrayList<QueuedTicketView>();
            for (TicketInfo doc : this.documents) {
                items.add(new QueuedTicketView(doc.getTicketId(), doc.getNumero_order(), this.dateFormatter.format(doc.getLastUpdate()), this.timeFormatter.format(doc.getLastUpdate())));
            }
            ObservableList data = FXCollections.observableArrayList(items);
            this.tableView.setItems(data);
        }
    }

    public void cancel() {
        if (this.document != null) {
            AppVarUtils.ERRONEOUS_TICKETS_DK.remove(this.document.getId());
            this.loadDocuments();
            this.document = null;
        }
    }

    public void printTicket() {
        if (this.document != null) {
            AppVarUtils.ERRONEOUS_TICKETS_DK.remove(this.document.getId());
            final TicketInfo ticketToSendToDisplay = (TicketInfo)this.document.clone();
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        List<PrinterInfo> displayKitchens = PopUpDKErrors.this.dlSales.getDisplayKitchens();
                        for (PrinterInfo displayKitchen : displayKitchens) {
                            AddOrderInterface remoteObject;
                            ticketToSendToDisplay.getLines().clear();
                            for (TicketLineInfo line : PopUpDKErrors.this.document.getLines()) {
                                if (line.isNext()) {
                                    ticketToSendToDisplay.getLines().add(line);
                                    continue;
                                }
                                if (PopUpDKErrors.this.dlSales.getProductInfoById(line.getProductID()).getDisplayKitchen() != displayKitchen.getId()) continue;
                                List<SupplementItemInfo> ingrediens = PopUpDKErrors.this.dlSales.getIngredientsByProducts(line.getProductID(), true, false);
                                line.setListIngredientsIN(ingrediens);
                                line.getIngredientsInclus();
                                ticketToSendToDisplay.getLines().add(line);
                            }
                            if (ticketToSendToDisplay.getLines().size() <= 0 || (remoteObject = PopUpDKErrors.this.getRemoteAddOrder(displayKitchen)) == null) continue;
                            remoteObject.addOrderKitchen(ticketToSendToDisplay);
                            PopUpDKErrors.this.loadDocuments();
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            });
        }
    }

    public AddOrderInterface getRemoteAddOrder(PrinterInfo ecran) {
        try {
            String ip;
            Remote r;
            if (ecran != null && ecran.getIp() != null && !ecran.getIp().isEmpty() && (r = Naming.lookup("rmi://" + (ip = ecran.getIp()) + "/TestRMI")) instanceof AddOrderInterface) {
                return (AddOrderInterface)r;
            }
        }
        catch (Exception ex) {
            if (AppVarUtils.ERRONEOUS_TICKETS_DK == null) {
                AppVarUtils.ERRONEOUS_TICKETS_DK = new HashMap<String, TicketInfo>();
            }
            if (this.document != null) {
                AppVarUtils.ERRONEOUS_TICKETS_DK.put(this.document.getId(), this.document);
            }
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "La connexion \u00e0 l'ecran de suivi a \u00e9chou\u00e9.", 4000, NPosition.BOTTOM_LEFT);
        return null;
    }

    public void switchToBtns() {
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.footer_btns, 0, 0);
    }

    public void switchToCancel() {
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.footer_cancel, 0, 0);
    }

    private void loadPaneFooter() throws BasicException {
        this.footer_btns.getChildren().clear();
        this.footer_btns.add((Node)this.btn_caisse, 1, 0);
        this.footer_btns.add((Node)this.btn_cancel, 0, 0);
    }

    public void closePopUp() {
        this.parent.dispose();
    }
}

