/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.stage.Stage;

public class PopUpChooseDesignOptionController
implements RootController {
    private Stage stage;
    private double height;
    private double width;
    @FXML
    Label label_background_image;
    @FXML
    Label label_background_color;
    @FXML
    Label icon_label;
    @FXML
    Label text_1_label;
    @FXML
    Label text_2_label;

    public void setChoosePopUpToFalse() {
        this.saveValuePopUpOptions(false, false);
        this.stage.close();
    }

    public void validNewDesign() {
        this.saveValuePopUpOptions(true, false);
        this.stage.close();
    }

    public void close() {
        this.stage.close();
    }

    private void initializer() {
        try {
            this.height = AppVarUtils.getScreenDimension().getHeight() * 0.8;
            this.width = AppVarUtils.getScreenDimension().getWidth() * 0.85;
            double heightImageBackground = this.height * 0.85;
            double widthImageBackground = this.width * 0.98;
            ImageView imageBackground = new ImageView(new Image(this.getClass().getResource("/com/openbravo/images/bg_options.png").toURI().toString()));
            imageBackground.setFitWidth(widthImageBackground);
            imageBackground.setFitHeight(heightImageBackground);
            imageBackground.setSmooth(false);
            imageBackground.setPreserveRatio(false);
            this.label_background_image.setGraphic((Node)imageBackground);
            double heightIconBiborne = this.height * 0.15;
            ImageView imageIconBiborne = new ImageView(new Image(this.getClass().getResource("/com/openbravo/images/image_biborne1.png").toURI().toString()));
            imageIconBiborne.setFitHeight(heightIconBiborne);
            imageIconBiborne.setPreserveRatio(true);
            imageIconBiborne.setSmooth(true);
            imageIconBiborne.setCache(true);
            this.icon_label.setGraphic((Node)imageIconBiborne);
            LinearGradient linearGradient = new LinearGradient(0.0, 1.0, 0.0, 0.0, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.web((String)"#1C1C1E")), new Stop(0.7775, Color.rgb((int)0, (int)0, (int)0, (double)0.47))});
            CornerRadii cornerRadii = new CornerRadii(20.0);
            BackgroundFill backgroundFill = new BackgroundFill((Paint)linearGradient, cornerRadii, Insets.EMPTY);
            this.label_background_color.setBackground(new Background(new BackgroundFill[]{backgroundFill}));
            String text_1 = "Une nouvelle mise \u00e0 jour du syst\u00e8me des pop-up \n d'options est disponible ! \ud83d\ude80";
            this.text_1_label.setText(text_1);
            String text_2 = "Voulez-vous la tester ? Vous pourrez toujours \n revenir en arri\u00e8re si besoin .";
            this.text_2_label.setText(text_2);
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        this.initializer();
    }

    private void saveValuePopUpOptions(boolean use_new_pop_up_option, boolean show_pop_up_choose_design) {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        AppConfig config = null;
        config = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        config.setProperty("use.new.pop.up.options", use_new_pop_up_option ? "yes" : "no");
        config.setProperty("show.pop.up.choose.design.options", use_new_pop_up_option ? "yes" : "no");
        config.save();
        AppLocal.USE_NEW_POP_UP_OPTIONS = use_new_pop_up_option;
        AppLocal.SHOW_POP_UP_CHOOSE_DESIGN_OPTIONS = show_pop_up_choose_design;
    }
}

