/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoViewRappel;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.TicketService;
import fr.protactile.kitchen.services.OrderService;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import javax.swing.JDialog;

public class PopUpCancelOrders
implements RootController {
    @FXML
    TableView tableView;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn etat_order;
    @FXML
    TableColumn total_order;
    @FXML
    TableColumn serveur_order;
    @FXML
    Button btn_validate_cancel;
    @FXML
    GridPane footer_print_pane;
    @FXML
    GridPane footer_cancel;
    @FXML
    GridPane pane_main;
    @FXML
    TableColumn bipper_order;
    @FXML
    Button btn_cancel;
    @FXML
    GridPane parent_pane;
    @FXML
    GridPane close_pane;
    @FXML
    GridPane footer_pane;
    @FXML
    Label message;
    private int numberHours = 0;
    private boolean isLimitedByHours = false;
    private final SimpleDateFormat dateFormatter = DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    private List<TicketInfo> orders;
    private boolean result;
    private static double widthPane = AppVarUtils.getScreenDimension().getWidth() * 0.7;
    private static double heightPane = AppVarUtils.getScreenDimension().getHeight() * 0.7;
    private OrderService orderService;
    protected DataLogicItems dlItems;
    private TicketService mTicketService;
    private TicketSharedService mTicketSharedService;
    private String REASON_CANCEL = "fermeture de la caisse";
    private JDialog dialog;
    private Stage mStage;
    private String meesage_text = "Traitement des commades partag\u00e9es";

    private void loadOrder() throws BasicException {
        this.orders = new ArrayList<TicketInfo>();
        CaisseInfo mCaisseInfo = AppLocal.dlSales.getCaisse(AppLocal.token);
        final List<TicketInfo> tmp_orders = AppLocal.dlSales.getOrdersPending(mCaisseInfo.getDateOpen());
        System.out.println("+++++++++++ tmp_orders : " + tmp_orders);
        this.message.setText(this.meesage_text);
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.message, 0, 0);
        this.footer_pane.getChildren().clear();
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                for (TicketInfo order : tmp_orders) {
                    System.out.println("+++++++++ " + new Date());
                    boolean result_cancel = PopUpCancelOrders.this.mTicketService.cancelSharedOrder(order);
                    if (result_cancel) continue;
                    PopUpCancelOrders.this.orders.add(order);
                }
                if (PopUpCancelOrders.this.orders.isEmpty()) {
                    PopUpCancelOrders.this.result = true;
                    PopUpCancelOrders.this.close();
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ArrayList<TicketInfoViewRappel> items = new ArrayList<TicketInfoViewRappel>();
                            for (TicketInfo order : PopUpCancelOrders.this.orders) {
                                if (order == null) continue;
                                String table = "";
                                if (order.getIdTable() != -1) {
                                    table = String.valueOf(order.getTable().getNumber());
                                }
                                String status = PopUpCancelOrders.this.getStatus(order.getStatus());
                                String nameCustomer = order.getCustomer() != null ? order.getCustomer().getName() : order.getName_customer();
                                items.add(new TicketInfoViewRappel(order.getNumberOrder(), nameCustomer, table, order.getBipper(), PopUpCancelOrders.this.dateFormatter.format(order.getDate()), PopUpCancelOrders.this.timeFormatter.format(order.getDate()), order.getType(), status, order.printTotalOrder(), order.getUser().getName(), order.getSource_order()));
                            }
                            ObservableList data = FXCollections.observableArrayList(items);
                            PopUpCancelOrders.this.tableView.setItems(data);
                            PopUpCancelOrders.this.pane_main.getChildren().clear();
                            PopUpCancelOrders.this.pane_main.add((Node)PopUpCancelOrders.this.tableView, 0, 0);
                            PopUpCancelOrders.this.footer_pane.add((Node)PopUpCancelOrders.this.btn_cancel, 0, 0);
                        }
                    });
                }
            }
        });
    }

    public void cancelOrder(TicketInfo order) throws BasicException, SQLException {
        if (order != null) {
            order.setReason_cancel(this.REASON_CANCEL);
            if (AppLocal.KITCHEN_COMPOSITE && order.getId_shared_order() != 0) {
                this.mTicketSharedService.cancelOrder(order.getId_shared_order(), null, true);
            }
            AppLocal.dlSales.cancelOrderPending(order, this.REASON_CANCEL, AppLocal.user.getId());
        }
    }

    public boolean getResult() {
        System.out.println("************************* getResult ************************ : " + this.result);
        return this.result;
    }

    private String getStatus(String status) {
        if (status != null) {
            switch (status) {
                case "livre": {
                    return "Livr\u00e9e";
                }
                case "paid": {
                    return "Termin\u00e9e";
                }
                case "cancel": {
                    return "Annul\u00e9e";
                }
                case "pending": {
                    return "En cours";
                }
                case "Refund": {
                    return "remboursement";
                }
            }
        }
        return null;
    }

    public void initializer(JDialog dialog) {
        this.result = false;
        this.dialog = dialog;
        this.numberHours = Integer.parseInt(AppLocal.TICKET_CALLBACK_COUNT != null && !AppLocal.TICKET_CALLBACK_COUNT.isEmpty() ? AppLocal.TICKET_CALLBACK_COUNT : "0");
        Calendar calToday = Calendar.getInstance();
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
        this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
        this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hourOrder"));
        this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("typeOrder"));
        this.etat_order.setCellValueFactory((Callback)new PropertyValueFactory("etatOrder"));
        this.total_order.setCellValueFactory((Callback)new PropertyValueFactory("totalOrder"));
        this.serveur_order.setCellValueFactory((Callback)new PropertyValueFactory("serveurOrder"));
        if (AppLocal.licence == "venteDetail") {
            this.tableView.getColumns().remove((Object)this.type_order);
            this.tableView.getColumns().remove((Object)this.bipper_order);
            this.num_order.setPrefWidth(widthPane * 0.15);
            this.date_order.setPrefWidth(widthPane * 0.15);
            this.hour_order.setPrefWidth(widthPane * 0.15);
            this.etat_order.setPrefWidth(widthPane * 0.15);
            this.total_order.setPrefWidth(widthPane * 0.2);
            this.serveur_order.setPrefWidth(widthPane * 0.15);
        } else {
            this.num_order.setPrefWidth(widthPane * 0.1);
            this.date_order.setPrefWidth(widthPane * 0.15);
            this.hour_order.setPrefWidth(widthPane * 0.1);
            this.type_order.setPrefWidth(widthPane * 0.1);
            this.etat_order.setPrefWidth(widthPane * 0.1);
            this.total_order.setPrefWidth(widthPane * 0.1);
            this.serveur_order.setPrefWidth(widthPane * 0.14);
        }
        this.setText();
        this.mTicketService = TicketService.getInstance();
        try {
            this.loadOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.orderService = OrderService.getInstance();
            this.mTicketSharedService = TicketSharedService.getInstance();
        }
        this.parent_pane.getChildren().clear();
        if (dialog != null) {
            this.pane_main.setPrefHeight(AppVarUtils.getScreenDimension().getHeight() * 0.595);
            this.parent_pane.add((Node)this.pane_main, 0, 0);
            this.parent_pane.add((Node)this.footer_pane, 0, 1);
        } else {
            this.pane_main.setPrefHeight(AppVarUtils.getScreenDimension().getHeight() * 0.539);
            this.parent_pane.add((Node)this.close_pane, 0, 0);
            this.parent_pane.add((Node)this.pane_main, 0, 1);
            this.parent_pane.add((Node)this.footer_pane, 0, 2);
        }
    }

    public void cancelOrders() {
        this.btn_cancel.setText(AppLocal.getIntString("Text.cancel") + " ...");
        this.btn_cancel.setDisable(true);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(() -> {
            try {
                for (TicketInfo order : this.orders) {
                    this.cancelOrder(order);
                }
                this.result = true;
                this.close();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        });
    }

    private void setText() {
        this.date_order.setText(AppLocal.getIntString("Label.date"));
        this.hour_order.setText(AppLocal.getIntString("Label.heure"));
        this.type_order.setText(AppLocal.getIntString("Label.type"));
        this.etat_order.setText(AppLocal.getIntString("Label.state"));
        this.total_order.setText(AppLocal.getIntString("Label.total"));
        this.serveur_order.setText(AppLocal.getIntString("Label.server"));
        this.btn_cancel.setText(AppLocal.getIntString("Text.cancel.all.orders"));
    }

    @Override
    public void init(Stage mStage) {
        this.mStage = mStage;
        this.initializer(null);
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.mStage = mStage;
        this.initializer(null);
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.mStage = mStage;
        this.initializer(null);
    }

    private void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PopUpCancelOrders.this.mStage.close();
                }
            });
        }
    }

    public void closePopUp() {
        this.mStage.close();
    }
}

