/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.TicketAvoir;
import com.openbravo.components.LazyModal;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.CancelOrderController;
import com.openbravo.controllers.DiscountController;
import com.openbravo.controllers.LoyaltyCardController;
import com.openbravo.controllers.PendingOrdersController;
import com.openbravo.controllers.PopTransferOrder;
import com.openbravo.controllers.PopUpPaymentController;
import com.openbravo.controllers.SeparatePaymentController;
import com.openbravo.controllers.SuiviController;
import com.openbravo.controllers.loyalty.SendValidCodeController;
import com.openbravo.dao.DataLogicEmployees;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.keen.CassandraManager;
import com.openbravo.models.HBoxLine;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.admin.User;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.OrderSharedBuilder;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.SALLEINFO;
import com.openbravo.pos.ticket.TableInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoBuilder;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TicketResto;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.AvoirService;
import com.openbravo.service.TicketService;
import fr.protactile.kitchen.dao.entities.Tickets;
import fr.protactile.kitchen.services.OrderService;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.norm.beans.EnteteInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.tpeCB.PaymentResult;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.stage.StageStyle;

public class PlanTableController
implements PropertyChangeListener {
    protected AppView m_App;
    @FXML
    FlowPane button_salles;
    @FXML
    Pane pane_table;
    @FXML
    ListView list_detail;
    @FXML
    Label num_order_label;
    @FXML
    Label total_order_label;
    @FXML
    GridPane pane_btn_orderEMP;
    @FXML
    Button btn_change_table;
    @FXML
    GridPane right_pane_first;
    @FXML
    Button btn_transfer_order;
    @FXML
    GridPane right_pane_last;
    @FXML
    Button btn_discount;
    @FXML
    Button btn_cancel;
    @FXML
    GridPane right_pane_center;
    @FXML
    Button btn_reclame_plat;
    @FXML
    Button btn_reclame_dessert;
    @FXML
    Label label_total;
    @FXML
    Button btn_print;
    @FXML
    Button btn_maj;
    @FXML
    Button btn_encaisse;
    private double btn_pane_height;
    private double btn_pane_width;
    AvoirService avoirService;
    private Scene scene;
    private List<TableInfo> tables;
    private int salleID;
    private DataLogicSales dlSales;
    private DataLogicOrder dlOrders;
    private DataLogicItems dlItems;
    private List<SALLEINFO> salles;
    private List<Button> btnSalles;
    private HashMap<Integer, Button> btnTables;
    private HashMap<Integer, Button> btnTablesAvailables;
    private TicketInfo currentOrder;
    private EnteteInfo enteteTicket;
    private List<PrinterInfo> printers;
    private List<TicketLineInfo> productToSend;
    private CassandraManager m_keenProject = null;
    private DataLogicAdmin dlAdmin;
    private final String DISCOUNT_PERMISSION = "2";
    private boolean has_discount_permission;
    private final String CANCEL_PERMISSION = "3";
    private boolean has_cancel_permission;
    private final String TRANSFER_PERMISSION = "4";
    private boolean has_transfer_permission;
    private boolean changeTable;
    private TableInfo newTable;
    private OrderService orderService;
    private DataLogicEmployees dlEmployees;
    private EventHiddenModal mActionEventLoyaltyCard = null;
    private LazyModal mLazyModalLoyaltyCard = null;
    private final String loyaltyCardFxml = "/fxml/loyaltyCard_view.fxml";
    private TicketService ticketService;
    private List<TicketInfo> sharedOrders;
    private TicketSharedService mTicketSharedService;
    private HashMap<Integer, TicketInfo> mapsharedOrders;
    private LazyModal mLazyModalValidCode = null;
    private EventHiddenModal mActionEventValidCode = null;
    private String valid_code_fxml = "/fx/templates/borne/send_valid_code.fxml";
    private final String CASH_IN = "cash_in";
    private final String PAYMENT_CB = "payment_cb";
    private final String PAYMENT_CASH = "payment_cash";

    public void init(AppView app, Scene scene) throws BasicException {
        this.m_App = app;
        this.ticketService = TicketService.getInstance();
        this.ticketService.setMPopUpTicketDateError(scene);
        this.btn_pane_height = (AppVarUtils.getScreenDimension().getHeight() - 55.0) * 0.8 * 0.35;
        this.btn_pane_width = AppVarUtils.getScreenDimension().getWidth() * 0.3;
        this.scene = scene;
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.dlOrders = (DataLogicOrder)this.m_App.getBean("com.openbravo.dao.DataLogicOrder");
        this.dlAdmin = (DataLogicAdmin)this.m_App.getBean("com.openbravo.pos.admin.DataLogicAdmin");
        this.dlEmployees = (DataLogicEmployees)this.m_App.getBean("com.openbravo.dao.DataLogicEmployees");
        this.dlSales.setDlEmployees(this.dlEmployees);
        this.avoirService = new AvoirService(this.dlOrders);
        this.printers = new ArrayList<PrinterInfo>();
        this.productToSend = new ArrayList<TicketLineInfo>();
        this.btnSalles = new ArrayList<Button>();
        this.btnTables = new HashMap();
        this.btnTablesAvailables = new HashMap();
        this.salleID = -1;
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.mapsharedOrders = new HashMap();
            this.orderService = OrderService.getInstance();
            this.mTicketSharedService = TicketSharedService.getInstance();
            this.mTicketSharedService.addPropertyChangeListener(this);
            this.loadOrderTabletto();
        }
        this.setTexts();
    }

    public void load() throws BasicException {
        this.afterChangeTable();
        this.has_discount_permission = this.dlAdmin.hasPermission(this.m_App.getAppUserView().getUser().getId(), "2");
        this.has_cancel_permission = this.dlAdmin.hasPermission(this.m_App.getAppUserView().getUser().getId(), "3");
        this.has_transfer_permission = this.dlAdmin.hasPermission(this.m_App.getAppUserView().getUser().getId(), "4");
        this.loadPermissionComptoir();
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.loadOrderTabletto();
        }
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            PlanTableController.this.loadSalles();
                            if (PlanTableController.this.salleID != -1) {
                                PlanTableController.this.loadTable(PlanTableController.this.salleID);
                            }
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                });
            }
        });
    }

    private void loadPermissionComptoir() {
        this.right_pane_last.getChildren().clear();
        this.right_pane_center.getChildren().clear();
        this.right_pane_first.getChildren().clear();
        if (this.has_cancel_permission) {
            this.btn_reclame_dessert.setPrefWidth(this.btn_pane_width * 0.5);
            this.right_pane_last.add((Node)this.btn_reclame_dessert, 0, 0);
            this.right_pane_last.add((Node)this.btn_cancel, 1, 0);
        } else {
            this.btn_reclame_dessert.setPrefWidth(this.btn_pane_width);
            this.right_pane_last.add((Node)this.btn_reclame_dessert, 0, 0);
        }
        if (this.has_discount_permission) {
            this.btn_reclame_plat.setPrefWidth(this.btn_pane_width * 0.5);
            this.right_pane_center.add((Node)this.btn_reclame_plat, 0, 0);
            this.right_pane_center.add((Node)this.btn_discount, 1, 0);
        } else {
            this.btn_reclame_plat.setPrefWidth(this.btn_pane_width);
            this.right_pane_center.add((Node)this.btn_reclame_plat, 0, 0);
        }
        if (this.has_transfer_permission) {
            this.btn_change_table.setPrefWidth(this.btn_pane_width * 0.5);
            this.right_pane_first.add((Node)this.btn_change_table, 0, 0);
            this.right_pane_first.add((Node)this.btn_transfer_order, 1, 0);
        } else {
            this.btn_change_table.setPrefWidth(this.btn_pane_width);
            this.right_pane_first.add((Node)this.btn_change_table, 0, 0);
        }
    }

    public void loadSalles() throws BasicException {
        this.salles = this.dlSales.getSalles();
        this.button_salles.getChildren().clear();
        this.btnSalles.clear();
        if (this.salles.size() > 0 && this.salleID == -1) {
            this.salleID = this.salles.get(0).getId();
        }
        for (final SALLEINFO salle : this.salles) {
            final Button btnSalle = new Button(salle.getName());
            btnSalle.setPrefWidth(140.0);
            btnSalle.setPrefHeight(40.0);
            this.button_salles.getChildren().add((Object)btnSalle);
            this.btnSalles.add(btnSalle);
            if (this.salleID == salle.getId()) {
                btnSalle.getStyleClass().add((Object)"btn-salle-selected");
            } else {
                btnSalle.getStyleClass().add((Object)"btn-salle");
            }
            btnSalle.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    PlanTableController.this.salleID = salle.getId();
                    try {
                        PlanTableController.this.loadTable(salle.getId());
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    for (Button btn : PlanTableController.this.btnSalles) {
                        if (btn.getStyleClass().contains((Object)"btn-salle-selected")) {
                            btn.getStyleClass().remove((Object)"btn-salle-selected");
                        }
                        if (btn.getStyleClass().contains((Object)"btn-salle")) continue;
                        btn.getStyleClass().add((Object)"btn-salle");
                    }
                    if (btnSalle.getStyleClass().contains((Object)"btn-salle")) {
                        btnSalle.getStyleClass().remove((Object)"btn-salle");
                    }
                    if (!btnSalle.getStyleClass().contains((Object)"btn-salle-selected")) {
                        btnSalle.getStyleClass().add((Object)"btn-salle-selected");
                    }
                }
            });
        }
    }

    public void loadTable(int idSalle) throws BasicException {
        String id_old_order = this.currentOrder != null ? this.currentOrder.getId() : "";
        System.out.println("++++++++++++++ id_old_order : " + id_old_order);
        boolean clean_panier = true;
        this.currentOrder = null;
        this.tables = this.dlSales.getTablesBySalle(idSalle);
        this.pane_table.getChildren().clear();
        this.btnTables.clear();
        this.btnTablesAvailables.clear();
        for (final TableInfo table : this.tables) {
            if ("rectangle".equals(table.getType()) || "cercle".equals(table.getType())) {
                Button btnTable = new Button(String.valueOf(table.getNumber()));
                btnTable.setWrapText(true);
                TicketInfo ticket = this.checkAvailability(table);
                if (ticket == null) {
                    btnTable.getStyleClass().add((Object)"bg_table");
                    this.btnTablesAvailables.put(table.getId(), btnTable);
                } else {
                    if (ticket.getId().equals(id_old_order)) {
                        clean_panier = false;
                        try {
                            this.loadDetailTable(table);
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                    if (ticket.getUser() != null) {
                        btnTable.setText(btnTable.getText() + "\n" + ticket.getUser().getName());
                    }
                    btnTable.getStyleClass().add((Object)"bg_reserved");
                    this.btnTables.put(table.getId(), btnTable);
                }
                if ("rectangle".equals(table.getType())) {
                    btnTable.getStyleClass().add((Object)"btn_table");
                } else {
                    btnTable.getStyleClass().add((Object)"btn_bar");
                }
                this.pane_table.getChildren().add((Object)btnTable);
                btnTable.setLayoutX((double)table.getX());
                btnTable.setLayoutY((double)table.getY());
                btnTable.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        if (table.isAvailable()) {
                            if (PlanTableController.this.changeTable) {
                                PlanTableController.this.choosenewTable(table);
                            } else {
                                PlanTableController.this.chooseTable(table);
                            }
                        } else {
                            try {
                                PlanTableController.this.loadDetailTable(table);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                    }
                });
            }
            if (!"comptoir".equals(table.getType())) continue;
            Button btnComptoir = new Button();
            btnComptoir.getStyleClass().add((Object)"btn_comptoir");
            this.pane_table.getChildren().add((Object)btnComptoir);
            btnComptoir.setLayoutX((double)table.getX());
            btnComptoir.setLayoutY((double)table.getY());
        }
        if (clean_panier) {
            this.clearPanier();
        }
    }

    public void choosenewTable(TableInfo table) {
        this.newTable = table;
        for (Integer key : this.btnTablesAvailables.keySet()) {
            if (key.intValue() != table.getId()) {
                if (this.btnTablesAvailables.get(key).getStyleClass().contains((Object)"bg-yellow-moutarde")) {
                    this.btnTablesAvailables.get(key).getStyleClass().remove((Object)"bg-yellow-moutarde");
                }
                if (this.btnTablesAvailables.get(key).getStyleClass().contains((Object)"bg_table")) continue;
                this.btnTablesAvailables.get(key).getStyleClass().add((Object)"bg_table");
                continue;
            }
            if (this.btnTablesAvailables.get(key).getStyleClass().contains((Object)"bg_table")) {
                this.btnTablesAvailables.get(key).getStyleClass().remove((Object)"bg_table");
            }
            if (this.btnTablesAvailables.get(key).getStyleClass().contains((Object)"bg-yellow-moutarde")) continue;
            this.btnTablesAvailables.get(key).getStyleClass().add((Object)"bg-yellow-moutarde");
        }
    }

    public void clearPanier() {
        this.list_detail.getItems().clear();
        this.num_order_label.setText("");
        this.total_order_label.setText("");
    }

    public void loadDetailTable(TableInfo table) throws BasicException {
        boolean local_order = true;
        this.currentOrder = "2".equals(this.m_App.getAppUserView().getUser().getRole()) ? this.dlSales.loadTicketByTableUser(table.getId(), this.m_App.getAppUserView().getUser().getId()) : this.dlSales.loadTicketByTable(table.getId());
        if (this.currentOrder == null && AppLocal.KITCHEN_COMPOSITE && this.mapsharedOrders.get(table.getNumber()) != null && (!"2".equals(this.m_App.getAppUserView().getUser().getRole()) || this.mapsharedOrders.get(table.getNumber()).getUser() != null && this.mapsharedOrders.get(table.getNumber()).getUser().getId().equals(this.m_App.getAppUserView().getUser().getId()))) {
            local_order = false;
            this.currentOrder = this.mapsharedOrders.get(table.getNumber());
        }
        if (this.currentOrder != null) {
            for (Integer key : this.btnTables.keySet()) {
                if (key.intValue() != table.getId()) {
                    if (this.btnTables.get(key).getStyleClass().contains((Object)"bg-red")) {
                        this.btnTables.get(key).getStyleClass().remove((Object)"bg-red");
                    }
                    if (this.btnTables.get(key).getStyleClass().contains((Object)"bg_reserved")) continue;
                    this.btnTables.get(key).getStyleClass().add((Object)"bg_reserved");
                    continue;
                }
                if (this.btnTables.get(key).getStyleClass().contains((Object)"bg_reserved")) {
                    this.btnTables.get(key).getStyleClass().remove((Object)"bg_reserved");
                }
                if (this.btnTables.get(key).getStyleClass().contains((Object)"bg-red")) continue;
                this.btnTables.get(key).getStyleClass().add((Object)"bg-red");
            }
            if (local_order) {
                this.enteteTicket = this.dlSales.getEnteteByTicket(this.currentOrder.getId(), this.currentOrder.isPaid());
                this.currentOrder.setCustomer(this.dlSales.loadCustomerExt(this.currentOrder.getCustomerId()));
                List<TicketLineInfo> lines = this.dlSales.loadLines(this.currentOrder.getId());
                List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(this.currentOrder.getId());
                lines.addAll(linesExterne);
                this.currentOrder.setLines(lines);
                if (AppLocal.CUSTOMER_LOYALTY) {
                    this.ticketService.setCustomerLoyalty(this.currentOrder);
                }
            }
            this.loadPanier();
        }
    }

    public void chooseTable(TableInfo table) {
        for (Integer key : this.btnTables.keySet()) {
            if (this.btnTables.get(key).getStyleClass().contains((Object)"bg-red")) {
                this.btnTables.get(key).getStyleClass().remove((Object)"bg-red");
            }
            if (this.btnTables.get(key).getStyleClass().contains((Object)"bg_reserved")) continue;
            this.btnTables.get(key).getStyleClass().add((Object)"bg_reserved");
        }
        AppLocal.table = table;
        this.m_App.getAppUserView().showTask("com.openbravo.pos.sales.JCaissePanel");
        AppLocal.view_back = AppLocal.view_current;
        AppLocal.view_current = "com.openbravo.pos.sales.JCaissePanel";
    }

    private void changeColorSalles() {
        for (Button btn : this.btnSalles) {
            if (btn.getStyleClass().contains((Object)"btn-salle-selected")) {
                btn.getStyleClass().remove((Object)"btn-salle-selected");
            }
            if (btn.getStyleClass().contains((Object)"btn-salle")) continue;
            btn.getStyleClass().add((Object)"btn-salle");
        }
    }

    public void prepareReclame() {
        this.printers.clear();
        for (TicketLineInfo line : this.currentOrder.getLines()) {
            PrinterInfo printerTmp;
            ProductInfoExt productTmp;
            if (line.isNext()) continue;
            if (line.isMenu()) {
                try {
                    for (ProductTicket product : line.getListProducts()) {
                        ProductInfoExt pro = this.dlSales.getProductInfoById(product.getId());
                        if (pro.getPrinterID() == -1) continue;
                        PrinterInfo printerTmp2 = this.dlSales.getPrinterByID(pro.getPrinterID());
                        int found = -1;
                        for (PrinterInfo printer : this.printers) {
                            if (printer.getId() != printerTmp2.getId()) continue;
                            found = 1;
                        }
                        if (found != -1) continue;
                        this.printers.add(printerTmp2);
                    }
                    productTmp = this.dlSales.getProductInfoById(line.getProductID());
                    if (productTmp.getPrinterID() == -1) continue;
                    line.setPrinterID(productTmp.getPrinterID());
                    printerTmp = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                    int found = -1;
                    for (PrinterInfo printer : this.printers) {
                        if (printer.getId() != printerTmp.getId()) continue;
                        found = 1;
                    }
                    if (found != -1) continue;
                    this.printers.add(printerTmp);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                continue;
            }
            try {
                productTmp = this.dlSales.getProductInfoById(line.getProductID());
                if (productTmp.getPrinterID() == -1) continue;
                printerTmp = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                int found = -1;
                for (PrinterInfo printer : this.printers) {
                    if (printer.getId() != printerTmp.getId()) continue;
                    found = 1;
                }
                if (found != -1) continue;
                this.printers.add(printerTmp);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void discount() {
        if (this.currentOrder != null) {
            boolean paid = false;
            for (TicketLineInfo line : this.currentOrder.getLines()) {
                if (line.getUnits_paid() == 0.0) continue;
                paid = true;
                break;
            }
            if (!paid) {
                try {
                    EventHiddenModal mAction = new EventHiddenModal(){
                        Object[] result;

                        @Override
                        public void onHidden() {
                            if (((Boolean)this.result[2]).booleanValue()) {
                                PlanTableController.this.currentOrder.setDiscount((Double)this.result[0]);
                                PlanTableController.this.currentOrder.setTypeDiscount((String)this.result[1]);
                                PlanTableController.this.currentOrder.setTotal(PlanTableController.this.currentOrder.getTotal());
                                try {
                                    PlanTableController.this.dlSales.updateDiscountOrder(PlanTableController.this.currentOrder);
                                }
                                catch (Exception ex) {
                                    LogToFile.log("severe", ex.getMessage(), ex);
                                }
                                PlanTableController.this.loadPanier();
                            }
                        }

                        @Override
                        public void onHidden(AppLoaderBuilder mBuilder) {
                            if (mBuilder != null && mBuilder.getController() != null) {
                                DiscountController mController = (DiscountController)mBuilder.getController();
                                this.result = mController.getResult();
                            }
                            this.onHidden();
                        }
                    };
                    LazyModal mLazy = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/popUp_discount.fxml", new Dimension(500, 400), mAction);
                    mLazy.load(this.currentOrder.getRealTotal(), this.currentOrder.getTypeDiscount(), this.currentOrder.getDiscount(), this.currentOrder.getLabel_discount());
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
    }

    public void loadPanier() {
        if (this.currentOrder != null) {
            Object orderNum = "";
            orderNum = this.currentOrder.getNum_order_kitchen() != -1 && this.currentOrder.getNum_order_kitchen() != 0 ? String.valueOf(this.currentOrder.getNum_order_kitchen()) : (this.currentOrder.getSent_from() != null ? "C-" + this.currentOrder.getNum_order_borne() : (this.currentOrder.getCaisse() != null ? this.currentOrder.getCaisse() + this.currentOrder.getNumero_order() : String.valueOf(this.currentOrder.getNumero_order())));
            this.num_order_label.setText(AppLocal.getIntString("Label.num.order") + (String)orderNum);
            this.total_order_label.setText(this.currentOrder.printTotal());
            this.list_detail.getItems().clear();
            ArrayList<HBoxLine> list = new ArrayList<HBoxLine>();
            for (final TicketLineInfo line : this.currentOrder.getLines()) {
                if (line.isNext()) continue;
                HBoxLine componentLine = new HBoxLine(line);
                componentLine.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        if (event.getClickCount() == 2) {
                            PlanTableController.this.loadPopUpPendingOrders(line);
                        }
                    }
                });
                list.add(componentLine);
                for (OptionItemOrder supplement : line.getListSupplements()) {
                    if (supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
                    if (AppLocal.DEACTIVE_QUANTITY) {
                        for (int i = 0; i < supplement.getNumberOption(); ++i) {
                            HBoxLine componentLineOption = new HBoxLine("+" + supplement.getNameSupplement(), this.printPrice(supplement.getPrice() / (double)supplement.getNumberOption()));
                            list.add(componentLineOption);
                        }
                        continue;
                    }
                    if (supplement.getNumberOption() > 1) {
                        HBoxLine componentLineOption = new HBoxLine("+" + this.printQuantity(line.getMultiply() * (double)supplement.getNumberOption()) + " " + supplement.getNameSupplement(), this.printPrice(supplement.getPrice() * line.getMultiply()));
                        list.add(componentLineOption);
                        continue;
                    }
                    if (line.getMultiply() > 1.0) {
                        HBoxLine componentLineOption = new HBoxLine("+" + this.printQuantity(line.getMultiply()) + " " + supplement.getNameSupplement(), this.printPrice(supplement.getPrice() * line.getMultiply()));
                        list.add(componentLineOption);
                        continue;
                    }
                    HBoxLine componentLineOption = new HBoxLine("+" + supplement.getNameSupplement(), this.printPrice(supplement.getPrice()));
                    list.add(componentLineOption);
                }
                for (ItemOrderInfo ingredient : line.getListIngredients()) {
                    if (ingredient.getIdProduct() != -1 && ingredient.getIdProduct() != 0) continue;
                    HBoxLine componentLineIngredient = new HBoxLine(AppLocal.getIntString("Label.without") + "  " + ingredient.getNameSupplement());
                    list.add(componentLineIngredient);
                }
                for (ProductTicket item : line.getListProducts()) {
                    HBoxLine componentLineItem;
                    if (line.getMultiply() > 1.0) {
                        componentLineItem = new HBoxLine(" " + this.printQuantity(line.getMultiply()) + " " + item.getNameProduct(), item.printPrice());
                        list.add(componentLineItem);
                    } else {
                        componentLineItem = new HBoxLine(" " + item.getNameProduct(), item.printPrice());
                        list.add(componentLineItem);
                    }
                    for (OptionItemOrder supplement : line.getListSupplements()) {
                        if (supplement.getIdProduct() != item.getIdProduct() || supplement.getIdCarte() != item.getIdCarte() || supplement.getIndex_carte() != item.getIndex_carte()) continue;
                        if (AppLocal.DEACTIVE_QUANTITY) {
                            for (int i = 0; i < supplement.getNumberOption(); ++i) {
                                HBoxLine componentLineOption = new HBoxLine("+" + supplement.getNameSupplement(), supplement.printPrice());
                                list.add(componentLineOption);
                            }
                            continue;
                        }
                        if (supplement.getNumberOption() > 1) {
                            HBoxLine componentLineOption = new HBoxLine("+" + this.printQuantity(line.getMultiply() * (double)supplement.getNumberOption()) + " " + supplement.getNameSupplement(), this.printPrice(supplement.getPrice() * line.getMultiply() * (double)supplement.getNumberOption()));
                            list.add(componentLineOption);
                            continue;
                        }
                        if (line.getMultiply() > 1.0) {
                            HBoxLine componentLineOption = new HBoxLine("+" + this.printQuantity(line.getMultiply()) + " " + supplement.getNameSupplement(), this.printPrice(supplement.getPrice() * line.getMultiply()));
                            list.add(componentLineOption);
                            continue;
                        }
                        HBoxLine componentLineOption = new HBoxLine("+" + supplement.getNameSupplement(), this.printPrice(supplement.getPrice()));
                        list.add(componentLineOption);
                    }
                    for (ItemOrderInfo ingredient : line.getListIngredients()) {
                        if (ingredient.getIdProduct() != item.getIdProduct() || ingredient.getIdCarte() != item.getIdCarte() || ingredient.getIndex_carte() != item.getIndex_carte()) continue;
                        HBoxLine componentLineIngredient = new HBoxLine(AppLocal.getIntString("Label.without") + "  " + ingredient.getNameSupplement());
                        list.add(componentLineIngredient);
                    }
                }
                if (!(line.getValueDiscount() > 0.0)) continue;
                String name = line.printLabelDiscount();
                HBoxLine componentLineDiscount = new HBoxLine(" " + name, "-" + Formats.CURRENCY.formatValue(line.getDiscount()));
                list.add(componentLineDiscount);
            }
            if (this.currentOrder.getDiscount() > 0.0) {
                String text = this.currentOrder.getTypeDiscount() == "pourcentage" ? "Promotion globale " + (int)this.currentOrder.getDiscount() + "%" : "Promotion globale";
                HBoxLine componentLineDiscount = new HBoxLine(text, "-" + this.currentOrder.printDiscount());
                list.add(componentLineDiscount);
            }
            ObservableList observableList = FXCollections.observableArrayList();
            observableList.setAll(list);
            this.list_detail.setItems(observableList);
        }
    }

    public void reclamePlat() {
        if (this.currentOrder != null) {
            this.prepareReclame();
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PrinterHelper printer = new PrinterHelper();
                    Decreaser decreaser = new Decreaser(PlanTableController.this.dlSales, PlanTableController.this.currentOrder.getId(), "Reclamation de plat", null, PlanTableController.this.currentOrder.getNumero_order());
                    printer.printPlat(PlanTableController.this.currentOrder, PlanTableController.this.printers, decreaser);
                }
            });
        }
    }

    public void reclameDessert() {
        if (this.currentOrder != null) {
            this.prepareReclame();
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PrinterHelper printer = new PrinterHelper();
                    Decreaser decreaser = new Decreaser(PlanTableController.this.dlSales, PlanTableController.this.currentOrder.getId(), "Reclamation de dessert", null, PlanTableController.this.currentOrder.getNumero_order());
                    printer.printDessert(PlanTableController.this.currentOrder, PlanTableController.this.printers, decreaser);
                }
            });
        }
    }

    public void cancelOrder() {
        if (this.currentOrder != null) {
            boolean paid = false;
            for (TicketLineInfo line : this.currentOrder.getLines()) {
                if (line.getUnits_paid() == 0.0) continue;
                paid = true;
                break;
            }
            if (!paid) {
                try {
                    EventHiddenModal mAction = new EventHiddenModal(){
                        Object[] result;

                        @Override
                        public void onHidden() {
                            if (((Boolean)this.result[1]).booleanValue()) {
                                PlanTableController.this.confirmCancel((String)this.result[0]);
                            }
                        }

                        @Override
                        public void onHidden(AppLoaderBuilder mBuilder) {
                            if (mBuilder != null && mBuilder.getController() != null) {
                                CancelOrderController mController = (CancelOrderController)mBuilder.getController();
                                this.result = mController.getResult();
                            }
                            this.onHidden();
                        }
                    };
                    LazyModal mLazy = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/popUp_cancel.fxml", new Dimension(400, 200), mAction);
                    mLazy.load(new Object[0]);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.cancel"), 1500, NPosition.BOTTOM_RIGHT);
            }
        }
    }

    public void updateOrder() {
        if (this.currentOrder != null) {
            if (this.currentOrder.getTicketId() == 0) {
                try {
                    AppLocal.table = this.ticketService.checkAvailability(this.currentOrder.getNum_table());
                }
                catch (BasicException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else {
                AppLocal.table = this.currentOrder.getTable();
            }
            AppLocal.ticket = this.currentOrder;
            this.m_App.getAppUserView().showTask("com.openbravo.pos.sales.JCaissePanel");
            AppLocal.view_back = AppLocal.view_current;
            AppLocal.view_current = "com.openbravo.pos.sales.JCaissePanel";
            AppLocal.view = "com.openbravo.pos.sales.JPanelPlanTable";
        }
    }

    public String printQuantity(double multiply) {
        if (multiply == (double)Math.round(multiply)) {
            return Formats.INT.formatValue(multiply);
        }
        return Formats.DOUBLE.formatValue(multiply);
    }

    public String printPrice(double price) {
        if (price != 0.0) {
            return Formats.CURRENCY.formatValue(price);
        }
        return "";
    }

    public void encaisser() {
        if (this.ticketService.isValidPeriod() && this.currentOrder != null && this.currentOrder.getLinesCount() > 0) {
            try {
                if (AppLocal.CUSTOMER_LOYALTY && !this.currentOrder.isCustomer_loyalty_verified() && AppLocal.SEND_SMS && this.currentOrder.getmCustomerLoyalty() != null && this.currentOrder.getTotalPoint() > 0.0) {
                    this.loadPopUpValidCode("cash_in");
                } else {
                    this.payWithoutCustomerLoyalty();
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void reloadTicket() throws BasicException {
        List<TicketLineInfo> lines = this.dlSales.loadLines(this.currentOrder.getId());
        List<TicketLineInfo> linesExterne = this.dlSales.getTicketLineExterne(this.currentOrder.getId());
        lines.addAll(linesExterne);
        this.currentOrder.setLines(lines);
        if (this.currentOrder != null && AppLocal.KITCHEN_COMPOSITE && this.mTicketSharedService != null) {
            Tickets order = OrderSharedBuilder.create(this.currentOrder, "caisse", null, true);
            this.mTicketSharedService.updateOrder(order);
        }
        this.loadPanier();
    }

    public void encaisserOrder(List<TicketLineInfo> lines, List<PaymentInfo> payments, Map<Integer, TicketAvoir> ticketsAvoirs, boolean open_drawer, HashMap<Integer, TicketResto> ticketsRestau, boolean print_ticket, String holder_ticket) {
        if (this.dlSales.isValidPeriod()) {
            try {
                this.currentOrder.setHolder(holder_ticket);
                this.ticketService.paidOldOrder(this.currentOrder, lines, payments, ticketsAvoirs, open_drawer, ticketsRestau, false, print_ticket, false, holder_ticket, "print paper", null);
                System.out.println("++++++++++++++++ salleID : " + this.salleID);
                if (this.salleID != -1) {
                    this.loadTable(this.salleID);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void print() {
        try {
            if (this.currentOrder != null && AppLocal.printerCaisse.getNumber() > 0) {
                if (this.currentOrder.getTicketId() == 0) {
                    this.mapsharedOrders.remove(this.currentOrder.getNum_table());
                    System.out.println("++++++++++++++ save order");
                    this.ticketService.orderAttente(false, this.currentOrder, false, false, false, false, false, false);
                }
                TicketInfo ticketToPrint = (TicketInfo)this.currentOrder.clone();
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        PlanTableController.this.ticketService.printAddition(PlanTableController.this.currentOrder);
                    }
                });
                if (this.salleID != -1) {
                    this.loadTable(this.salleID);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void encaissement(boolean separe) throws IOException, BasicException, URISyntaxException {
        double widthPayment = separe ? 0.9 : 0.6;
        for (TicketLineInfo line : this.currentOrder.getLines()) {
            ProductInfoExt product = this.dlSales.getProductInfoById(line.getProductID());
            if (product != null) {
                line.setUnitProduct(product.getUnit());
                continue;
            }
            line.setUnitProduct("piece");
        }
        EventHiddenModal mAction = new EventHiddenModal(){
            Object[] result;

            @Override
            public void onHidden() {
                if (((Boolean)this.result[1]).booleanValue()) {
                    List m_aPaymentInfo = (List)this.result[0];
                    List lines = (List)this.result[3];
                    Map ticketsAvoirs = (Map)this.result[5];
                    HashMap ticketsRestau = (HashMap)this.result[7];
                    boolean printTicket = (Boolean)this.result[9];
                    boolean validOrder = true;
                    if (validOrder) {
                        String holder_ticket = (String)this.result[10];
                        PlanTableController.this.validPayment(lines, m_aPaymentInfo, ticketsAvoirs, ticketsRestau, AppLocal.OPEN_DRAWER, printTicket, holder_ticket);
                    }
                } else {
                    try {
                        PlanTableController.this.reloadTicket();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }

            @Override
            public void onHidden(AppLoaderBuilder mBuilder) {
                if (mBuilder != null && mBuilder.getController() != null) {
                    PopUpPaymentController mController = (PopUpPaymentController)mBuilder.getController();
                    this.result = mController.getResult();
                }
                this.onHidden();
            }
        };
        LazyModal mLazy = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/popUp_payment.fxml", AppVarUtils.getDimensionRatio(widthPayment, 500), mAction);
        mLazy.load(new Object[0]);
        PopUpPaymentController mController = (PopUpPaymentController)mLazy.getLoadder().getController();
        mController.init(this.m_App, separe, this.currentOrder.getTotal(), null, this.dlSales, this.scene, this.currentOrder, this.currentOrder.getTicketId() == 0, false, this.dlOrders, true, false, true, false);
    }

    private TicketInfo checkAvailability(TableInfo table) throws BasicException {
        TicketInfo ticketTmp = this.dlSales.checktable(table.getId());
        if (ticketTmp != null) {
            table.setAvailable(false);
            return ticketTmp;
        }
        if (AppLocal.KITCHEN_COMPOSITE && this.mapsharedOrders.get(table.getNumber()) != null) {
            table.setAvailable(false);
            return this.mapsharedOrders.get(table.getNumber());
        }
        table.setAvailable(true);
        return null;
    }

    public void changeTable() {
        if (this.currentOrder != null) {
            if (this.changeTable) {
                this.validChange();
            } else {
                this.prepareChange();
            }
        }
    }

    private void prepareChange() {
        if (this.currentOrder != null) {
            this.beforeChangeTable();
        }
    }

    private void validChange() {
        if (this.currentOrder != null && this.newTable != null) {
            try {
                if (this.currentOrder.getId_shared_order() != 0 && this.currentOrder.getId_shared_order() != -1) {
                    if (this.mTicketSharedService != null) {
                        this.mTicketSharedService.changeTable(this.currentOrder.getId_shared_order(), this.newTable.getNumber());
                    }
                    if (this.currentOrder.getTicketId() == 0) {
                        this.mapsharedOrders.remove(this.currentOrder.getNum_table());
                        this.currentOrder.setNum_table(this.newTable.getNumber());
                        this.mapsharedOrders.put(this.currentOrder.getNum_table(), this.currentOrder);
                    }
                }
                if (this.currentOrder.getTicketId() != 0) {
                    this.dlSales.setAvailableTable(this.currentOrder.getTable().getId());
                    this.dlSales.addTableToTicket(this.currentOrder, this.newTable);
                }
                if (this.salleID != -1) {
                    this.loadTable(this.salleID);
                    this.loadDetailTable(this.newTable);
                }
                this.afterChangeTable();
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Table chang\u00e9.", 1500, NPosition.BOTTOM_RIGHT);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void afterChangeTable() {
        this.newTable = null;
        this.changeTable = false;
        this.btn_change_table.setText(AppLocal.getIntString("Button.change.table"));
    }

    private void beforeChangeTable() {
        this.changeTable = true;
        this.btn_change_table.setText(AppLocal.getIntString("Button.valid"));
    }

    public void paymentCB() {
        if (this.ticketService.isValidPeriod()) {
            if (AppLocal.CUSTOMER_LOYALTY && !this.currentOrder.isCustomer_loyalty_verified() && AppLocal.SEND_SMS && this.currentOrder.getmCustomerLoyalty() != null && this.currentOrder.getTotalPoint() > 0.0) {
                this.loadPopUpValidCode("payment_cb");
            } else {
                this.fastPaymentCB();
            }
        }
    }

    public void paymentCach() {
        if (this.ticketService.isValidPeriod()) {
            if (AppLocal.CUSTOMER_LOYALTY && !this.currentOrder.isCustomer_loyalty_verified() && AppLocal.SEND_SMS && this.currentOrder.getmCustomerLoyalty() != null && this.currentOrder.getTotalPoint() > 0.0) {
                this.loadPopUpValidCode("payment_cash");
            } else {
                this.fastPaymentCash();
            }
        }
    }

    private void loadPopUpPendingOrders(final TicketLineInfo line) {
        try {
            EventHiddenModal mAction = new EventHiddenModal(){
                Object[] result;

                @Override
                public void onHidden() {
                    double quantity = (Double)this.result[1];
                    TicketInfo ticket = (TicketInfo)this.result[0];
                    if (((Boolean)this.result[2]).booleanValue()) {
                        try {
                            PlanTableController.this.changeLine(ticket, quantity, line);
                            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Article transf\u00e9r\u00e9.", 1500, NPosition.BOTTOM_RIGHT);
                        }
                        catch (BasicException | SQLException ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        PendingOrdersController mController = (PendingOrdersController)mBuilder.getController();
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            LazyModal mLazy = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/popUp_pendingOrders.fxml", AppVarUtils.getDimensionRatio(0.6, 0.6), mAction);
            mLazy.load(this.m_App, line);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void changeLine(TicketInfo ticket, double quantity, TicketLineInfo line) throws BasicException, SQLException {
        TicketLineInfo newLine = (TicketLineInfo)line.clone();
        newLine.setMultiply(quantity);
        newLine.setTicket(ticket.getId());
        Double ht = (newLine.getPrice() * newLine.getMultiply() - newLine.getDiscount()) / (1.0 + newLine.getTaxRate());
        newLine.setHtAmount(ht);
        newLine.setTaxAmount(newLine.getPrice() * newLine.getMultiply() - newLine.getDiscount() - ht);
        ticket.addLine(newLine);
        boolean update = true;
        if (line.getMultiply() > quantity) {
            line.setMultiply(line.getMultiply() - quantity);
            Double ht_line = (line.getPrice() * line.getMultiply() - line.getDiscount()) / (1.0 + line.getTaxRate());
            line.setHtAmount(ht_line);
            line.setTaxAmount(line.getPrice() * line.getMultiply() - line.getDiscount() - ht_line);
        } else {
            int index = -1;
            for (int i = 0; i < 10; ++i) {
                if (line.getID() != this.currentOrder.getLines().get(i).getID()) continue;
                index = i;
                break;
            }
            if (index != -1) {
                this.currentOrder.removeLine(index);
            }
            update = false;
        }
        this.dlSales.changeLine(this.currentOrder, line, update);
        this.dlSales.addLineToTicket(ticket, newLine);
        this.reloadTicket();
    }

    public void transferOrder() {
        if (this.currentOrder != null && this.currentOrder.getSent_from() == null) {
            try {
                List<User> users = this.dlAdmin.getUsersExcept(this.currentOrder.getUser().getId());
                EventHiddenModal mAction = new EventHiddenModal(){
                    Object[] result;

                    @Override
                    public void onHidden() {
                        User user = (User)this.result[0];
                        if (((Boolean)this.result[1]).booleanValue()) {
                            try {
                                if (user != null) {
                                    PlanTableController.this.dlSales.transfertOrder(PlanTableController.this.currentOrder, user.getId(), PlanTableController.this.m_App.getAppUserView().getUser().getId());
                                    PlanTableController.this.reloadTicket();
                                    NotifyWindow notifyWindow = new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Commande transf\u00e9r\u00e9.", 1500, NPosition.BOTTOM_RIGHT);
                                }
                            }
                            catch (BasicException ex) {
                                Logger.getLogger(SuiviController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }

                    @Override
                    public void onHidden(AppLoaderBuilder mBuilder) {
                        if (mBuilder != null && mBuilder.getController() != null) {
                            PopTransferOrder mController = (PopTransferOrder)mBuilder.getController();
                            this.result = mController.getResult();
                        }
                        this.onHidden();
                    }
                };
                LazyModal mLazy = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/popUp_transferOrder.fxml", AppVarUtils.getDimensionRatio(0.3, 0.25), mAction);
                mLazy.load(users);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void openDrawer() {
        this.ticketService.openDrawer();
    }

    private void addLoyaltyCard() {
        this.mActionEventLoyaltyCard = new EventHiddenModal(){
            CustomerInfo cutomerResult;

            @Override
            public void onHidden() {
                try {
                    PlanTableController.this.currentOrder.setCustomer(this.cutomerResult);
                    PlanTableController.this.checkPaymentSepare();
                    PlanTableController.this.mLazyModalLoyaltyCard.destroyEvents();
                    PlanTableController.this.mActionEventLoyaltyCard = null;
                }
                catch (BasicException | IOException | URISyntaxException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }

            @Override
            public void onHidden(AppLoaderBuilder mBuilder) {
                if (mBuilder != null && mBuilder.getController() != null) {
                    LoyaltyCardController mController = (LoyaltyCardController)mBuilder.getController();
                    this.cutomerResult = mController.getCustomer();
                }
                this.onHidden();
            }
        };
        if (this.mLazyModalLoyaltyCard == null) {
            this.mLazyModalLoyaltyCard = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/loyaltyCard_view.fxml", new Dimension(400, 300));
        }
        this.mLazyModalLoyaltyCard.setEventHiddenModal(this.mActionEventLoyaltyCard);
        this.mLazyModalLoyaltyCard.load(new Object[0]);
    }

    private void checkPaymentSepare() throws IOException, BasicException, URISyntaxException {
        if (AppLocal.PAYMENT_SEPARE && this.currentOrder.getLineSize() > 1) {
            EventHiddenModal mAction = new EventHiddenModal(){
                Object[] result;

                @Override
                public void onHidden() {
                    if (((Boolean)this.result[1]).booleanValue()) {
                        try {
                            boolean shouldSeparePayment = (Boolean)this.result[0];
                            PlanTableController.this.encaissement(shouldSeparePayment);
                        }
                        catch (Exception ex) {
                            LogToFile.log("severe", ex.getMessage(), ex);
                        }
                    }
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        SeparatePaymentController mController = (SeparatePaymentController)mBuilder.getController();
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            LazyModal mLazy = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/popUp_paymentSepare.fxml", new Dimension(400, 200), mAction);
            mLazy.load(new Object[0]);
        } else {
            this.encaissement(false);
        }
    }

    private void loadOrderTabletto() {
        this.mapsharedOrders.clear();
        List<Tickets> orders_borne_tmp = this.mTicketSharedService.getOrders("Tabletto");
        this.sharedOrders = TicketInfoBuilder.create(this.dlSales).toTickets(orders_borne_tmp);
        this.sharedOrders.forEach(order -> {
            if (order.getNum_table() != 0) {
                this.mapsharedOrders.put(order.getNum_table(), (TicketInfo)order);
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (AppLocal.KITCHEN_COMPOSITE) {
            this.loadOrdersWIthTable();
        }
    }

    private void saveExteriorOrder(List<PaymentInfo> paymentsInfo, Map<Integer, TicketAvoir> ticketsAvoirs, HashMap<Integer, TicketResto> ticketsRestau, boolean print_ticket, String holder_ticket) {
        if (this.dlSales.isValidPeriod()) {
            this.currentOrder.setHolder(holder_ticket);
            TicketInfo ticketToSave = (TicketInfo)this.currentOrder.clone();
            this.ticketService.encaisserOrder(ticketToSave, paymentsInfo, ticketsAvoirs, false, true, ticketsRestau, false, false, print_ticket, holder_ticket, "print paper", null);
            this.loadOrdersWIthTable();
        }
    }

    private void validPayment(List<TicketLineInfo> lines, List<PaymentInfo> paymentsInfo, Map<Integer, TicketAvoir> ticketsAvoirs, HashMap<Integer, TicketResto> ticketsRestau, boolean open_drawer, boolean print_ticket, String holder_ticket) {
        if (this.currentOrder.getTicketId() == 0) {
            this.saveExteriorOrder(paymentsInfo, ticketsAvoirs, ticketsRestau, print_ticket, holder_ticket);
        } else {
            this.encaisserOrder(lines, paymentsInfo, ticketsAvoirs, open_drawer, ticketsRestau, print_ticket, holder_ticket);
        }
    }

    private void loadOrdersWIthTable() {
        this.loadOrderTabletto();
        if (this.salleID != -1) {
            try {
                this.loadTable(this.salleID);
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void confirmCancel(String reason_cancel) {
        this.ticketService.prepareTicketCuisine(this.currentOrder);
        final TicketInfo tikcetToSend = (TicketInfo)this.currentOrder.clone();
        if (AppLocal.KITCHEN_COMPOSITE && this.currentOrder.getId_shared_order() != 0) {
            this.mTicketSharedService.cancelOrder(this.currentOrder.getId_shared_order(), null);
        }
        if (this.currentOrder.getTicketId() == 0) {
            if (this.currentOrder.getId_order_kitchen() != 0 && this.currentOrder.getId_order_kitchen() != -1) {
                this.orderService.cancelOrderById(this.currentOrder.getId_order_kitchen());
            }
            this.loadOrdersWIthTable();
        } else {
            try {
                if (AppLocal.KITCHEN_COMPOSITE) {
                    this.orderService.cancelOrder(this.currentOrder.getId());
                }
                this.dlSales.cancelOrderPending(this.currentOrder, reason_cancel, this.m_App.getAppUserView().getUser().getId());
                if (this.salleID != -1) {
                    this.loadTable(this.salleID);
                }
                AppLocal.CANCEL_ORDER = true;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Commande annul\u00e9.", 1500, NPosition.BOTTOM_RIGHT);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                PlanTableController.this.ticketService.printKitchenTicketCanceld(tikcetToSend);
            }
        });
    }

    private void loadPopUpValidCode(final String post_action) {
        try {
            int height_popUp = this.currentOrder.getmCustomerLoyalty().isActif() ? (int)(AppVarUtils.getScreenDimension().getHeight() * 0.5) : (int)(AppVarUtils.getScreenDimension().getHeight() * 0.7);
            this.mActionEventValidCode = new EventHiddenModal(){
                boolean result;

                @Override
                public void onHidden() {
                    if (this.result) {
                        PlanTableController.this.currentOrder.setCustomer_loyalty_verified(true);
                        if (post_action != null) {
                            switch (post_action) {
                                case "cash_in": {
                                    PlanTableController.this.payWithoutCustomerLoyalty();
                                    break;
                                }
                                case "payment_cb": {
                                    PlanTableController.this.fastPaymentCB();
                                    break;
                                }
                                case "payment_cash": {
                                    PlanTableController.this.fastPaymentCash();
                                }
                            }
                        }
                    }
                    PlanTableController.this.mLazyModalValidCode.destroyEvents();
                    PlanTableController.this.mActionEventValidCode = null;
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        SendValidCodeController mController = (SendValidCodeController)mBuilder.getController();
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalValidCode == null) {
                this.mLazyModalValidCode = new LazyModal(StageStyle.UNDECORATED, this.scene, this.valid_code_fxml, new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.5), height_popUp));
            } else {
                this.mLazyModalValidCode.setmDimension(new Dimension((int)(AppVarUtils.getScreenDimension().getWidth() * 0.5), height_popUp));
            }
            this.mLazyModalValidCode.setEventHiddenModal(this.mActionEventValidCode);
            this.mLazyModalValidCode.load(false, this.currentOrder.getmCustomerLoyalty());
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void payWithoutCustomerLoyalty() {
        if (this.currentOrder.getTotal() > 0.0) {
            if (AppLocal.LOYALTY_CARD) {
                this.addLoyaltyCard();
            } else {
                try {
                    this.checkPaymentSepare();
                }
                catch (BasicException | IOException | URISyntaxException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        } else {
            ArrayList<PaymentInfo> paymentsInfo = new ArrayList<PaymentInfo>();
            this.validPayment(this.currentOrder.getLines(), paymentsInfo, null, null, false, true, null);
        }
    }

    private void fastPaymentCB() {
        ArrayList<PaymentInfo> payments = new ArrayList<PaymentInfo>();
        payments.add(new PaymentInfo("CB", this.currentOrder.getTotal(), this.currentOrder.getTotal()));
        PaymentResult paymentResult = this.ticketService.validOrderAfterPayment(payments, this.currentOrder);
        if (paymentResult != null) {
            String holder_ticket = paymentResult.getHolder_ticket();
            this.currentOrder.setHolder(holder_ticket);
            this.validPayment(this.currentOrder.getLines(), payments, null, null, AppLocal.CB_DRAWER && AppLocal.OPEN_DRAWER, true, holder_ticket);
        }
    }

    private void fastPaymentCash() {
        ArrayList<PaymentInfo> payments = new ArrayList<PaymentInfo>();
        payments.add(new PaymentInfo("Espece", this.currentOrder.getTotal(), this.currentOrder.getTotal()));
        this.validPayment(this.currentOrder.getLines(), payments, null, null, AppLocal.OPEN_DRAWER, true, null);
    }

    private void setTexts() {
        this.btn_change_table.setText(AppLocal.getIntString("Button.change.table"));
        this.btn_transfer_order.setText(AppLocal.getIntString("Button.transfert.order"));
        this.btn_reclame_plat.setText(AppLocal.getIntString("Button.reclam.plat"));
        this.btn_reclame_dessert.setText(AppLocal.getIntString("Button.reclam.dessert"));
        this.btn_cancel.setText(AppLocal.getIntString("Button.cancel"));
        this.label_total.setText(AppLocal.getIntString("Label.total"));
        this.btn_maj.setText(AppLocal.getIntString("Button.update"));
        this.btn_encaisse.setText(AppLocal.getIntString("Button.cashier"));
        this.btn_print.setText(AppLocal.getIntString("Button.print"));
        this.btn_discount.setText(AppLocal.getIntString("Button.discount"));
    }
}

