/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoViewRappel;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.Stage;
import javafx.util.Callback;

public class PendingOrdersController
implements RootController {
    @FXML
    TableView tableView;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn total_order;
    @FXML
    TableColumn serveur_order;
    @FXML
    TableColumn table_order;
    @FXML
    TableColumn bipper_order;
    @FXML
    TextField text_quantity;
    @FXML
    Label label_max_quantity;
    private final SimpleDateFormat dateFormatter = DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    private Stage stage;
    private AppView app;
    private Date date;
    protected DataLogicSales dlSales;
    private DataLogicOrder dlOrders;
    private List<TicketInfo> orders;
    private TicketInfo currentOrder;
    private DataLogicAdmin dlUsers;
    private Object[] result;
    private double max_quantity;
    private String id_Ticket;
    private TicketLineInfo line;

    public void initializer() {
        this.result = new Object[3];
        this.max_quantity = this.line.getMultiply();
        this.id_Ticket = this.line.getM_sTicket();
        this.result[0] = this.max_quantity;
        this.result[1] = null;
        this.result[2] = false;
        this.text_quantity.setText(String.valueOf(this.line.getMultiply()));
        this.label_max_quantity.setText("(max : " + this.max_quantity + ")");
        this.dlSales = (DataLogicSales)this.app.getBean("com.openbravo.dao.DataLogicSales");
        this.dlOrders = (DataLogicOrder)this.app.getBean("com.openbravo.dao.DataLogicOrder");
        this.dlUsers = (DataLogicAdmin)this.app.getBean("com.openbravo.pos.admin.DataLogicAdmin");
        this.currentOrder = null;
        this.tableView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (PendingOrdersController.this.tableView.getSelectionModel().getSelectedIndex() != -1 && (row = PendingOrdersController.this.tableView.getSelectionModel().getSelectedIndex()) != -1) {
                    try {
                        PendingOrdersController.this.currentOrder = PendingOrdersController.this.orders.get(row);
                        List<TicketLineInfo> lines = PendingOrdersController.this.dlSales.loadLines(PendingOrdersController.this.currentOrder.getId());
                        List<TicketLineInfo> linesExterne = PendingOrdersController.this.dlSales.getTicketLineExterne(PendingOrdersController.this.currentOrder.getId());
                        lines.addAll(linesExterne);
                        PendingOrdersController.this.currentOrder.setLines(lines);
                    }
                    catch (BasicException ex) {
                        Logger.getLogger(PendingOrdersController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        });
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
        this.table_order.setCellValueFactory((Callback)new PropertyValueFactory("tableOrder"));
        this.bipper_order.setCellValueFactory((Callback)new PropertyValueFactory("bipperOrder"));
        this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
        this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hourOrder"));
        this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("typeOrder"));
        this.total_order.setCellValueFactory((Callback)new PropertyValueFactory("totalOrder"));
        this.serveur_order.setCellValueFactory((Callback)new PropertyValueFactory("serveurOrder"));
        try {
            this.loadOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void loadOrder() throws BasicException {
        this.orders = "2".equals(this.app.getAppUserView().getUser().getRole()) ? this.dlSales.loadPendingOrdersByUser(this.app.getAppUserView().getUser().getId(), this.id_Ticket) : this.dlSales.loadPendingOrders(this.id_Ticket);
        ArrayList<TicketInfoViewRappel> items = new ArrayList<TicketInfoViewRappel>();
        for (TicketInfo order : this.orders) {
            if (order == null) continue;
            String table = "";
            if (order.getIdTable() != -1) {
                table = String.valueOf(order.getTable().getNumber());
            }
            String status = "";
            String nameCustomer = order.getCustomer() != null ? order.getCustomer().getName() : order.getName_customer();
            items.add(new TicketInfoViewRappel(String.valueOf(order.getNumero_order()), nameCustomer, table, order.getBipper(), this.dateFormatter.format(order.getDate()), this.timeFormatter.format(order.getDate()), order.getType(), status, order.printTotalOrder(), order.getUser().getName(), order.getSource_order()));
        }
        ObservableList data = FXCollections.observableArrayList(items);
        this.tableView.setItems(data);
    }

    public Object[] getResult() {
        return this.result;
    }

    public void closePopUp() {
        this.stage.close();
    }

    public void valid() {
        if (this.currentOrder != null) {
            double quantity;
            double d = quantity = this.text_quantity.getText().isEmpty() ? 1.0 : Double.parseDouble(this.text_quantity.getText());
            if (quantity > this.max_quantity) {
                quantity = this.max_quantity;
            }
            this.result[0] = this.currentOrder;
            this.result[1] = quantity;
            this.result[2] = true;
            this.stage.close();
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de sp\u00e9cifier la commande.", 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        this.app = (AppView)objects[0];
        this.line = (TicketLineInfo)objects[1];
        this.initializer();
    }
}

