/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.glory.fcc.service.BrueBoxServiceCallbackHandler;
import com.glory.fcc.service.BrueBoxServiceStub;
import com.glory.fcc.service.FCCClient;
import com.glory.fcc.service.FCCConst;
import com.glory.fcc.service.IUserInterface;
import com.openbravo.beans.TrackPayement;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.format.Formats;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import java.rmi.RemoteException;
import java.util.List;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javax.swing.JOptionPane;
import org.jdom.Element;

public class PaymentGloryController
implements RootController,
IUserInterface {
    private Stage stage;
    private Double totalValue;
    @FXML
    GridPane pane_main;
    @FXML
    GridPane pane_footer;
    @FXML
    Button cancel_button;
    @FXML
    Button refund_button;
    @FXML
    Label total;
    @FXML
    Label paid;
    @FXML
    Label remaining;
    @FXML
    Label rendu_label;
    @FXML
    Label errorLabel;
    @FXML
    Label recoverMoney;
    @FXML
    GridPane pane_info_payment;
    FCCClient fcc;
    Thread eventListenerGlory;
    private boolean gloryOccuped = false;
    private int success = -1;
    private TrackPayement tracker;
    double amountToPay;

    public void closePopUp() {
        System.out.println("closePopUp");
        this.doEndListeningGlory();
        this.stage.close();
    }

    public void cancelPayment() {
        this.doEndListeningGlory();
        this.stage.close();
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
    }

    @Override
    public void init(Stage mStage, Object total) {
        this.stage = mStage;
        this.totalValue = (Double)total;
        this.total.setText((String)total);
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        this.tracker = (TrackPayement)objects[0];
        this.fcc = (FCCClient)objects[1];
        this.totalValue = this.tracker.getTotal();
        this.total.setText(Formats.DOUBLE.formatValue(this.tracker.getTotal()) + " \u20ac");
        this.paid.setText(Formats.DOUBLE.formatValue(0) + " \u20ac");
        this.remaining.setText(Formats.DOUBLE.formatValue(this.totalValue) + " \u20ac");
        this.registerEventListener();
        this.doSaleOnCashGlory();
        this.intializer();
    }

    @Override
    public void setGuidance(String msg, int status) {
    }

    public void setGuidance(String msg) {
    }

    @Override
    public void setDeposit(final String amount) {
        final double amountPaid = Double.valueOf(amount);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PaymentGloryController.this.paid.setText(amount + " \u20ac");
                double d = amountPaid - PaymentGloryController.this.totalValue;
                PaymentGloryController.this.remaining.setText(IUserInterface.decimalFormat.format(Math.abs(d)) + " \u20ac");
                PaymentGloryController.this.rendu_label.setText(d > 0.0 ? "\u00c0 rendre" : "Reste \u00e0 payer");
                PaymentGloryController.this.tracker.setPaid(amountPaid);
                PaymentGloryController.this.tracker.setRendu(d);
            }
        });
    }

    @Override
    public void setStatus(int devid, String msg) {
    }

    @Override
    public String getStatusString(int statusCode) {
        if (FCCConst.STATUS_STRING.length <= statusCode) {
            return "Unknown";
        }
        return FCCConst.STATUS_STRING[statusCode];
    }

    @Override
    public void showRecoveryScreen(String errCode, String text) {
    }

    @Override
    public void setWarningLabel(int proc, String devid, String fv) {
    }

    @Override
    public void startRepFC() {
    }

    @Override
    public boolean getRepFCState() {
        return false;
    }

    @Override
    public void setEventInventory(Element node) {
    }

    public void registerEventListener() {
        PaymentGloryController iu = this;
        this.eventListenerGlory = this.getFccInstance().registerAdjustTimeAndGetStatus(iu);
        System.out.println("registerEventListener : eventListenerGlory " + this.eventListenerGlory);
    }

    public void cancelCashGlorySale() {
        System.out.println("___cancelCashGlorySale");
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PaymentGloryController.this.getFccInstance().cancelChangeOperation();
                    PaymentGloryController.this.setGuidance("L'operation est annul\u00e9e ");
                    PaymentGloryController.this.setDeposit("0.0");
                }
                catch (RemoteException e) {
                    JOptionPane.showMessageDialog(null, "Change Cancel could not be achieved.", "", 0);
                    e.printStackTrace();
                }
            }
        });
    }

    public FCCClient getFccInstance() {
        return FCCClient.getFccInstance();
    }

    public void doEndListeningGlory() {
        System.out.println("eventListenerGlory" + this.eventListenerGlory);
        if (this.eventListenerGlory != null && this.gloryOccuped) {
            this.cancelCashGlorySale();
        }
        if (this.eventListenerGlory != null) {
            this.getFccInstance().unRegisterEvent();
            this.eventListenerGlory.interrupt();
            this.eventListenerGlory = null;
        }
    }

    public void doSaleOnCashGlory() {
        this.gloryOccuped = true;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PaymentGloryController.this.setGuidance("Op\u00e9ration en cours... ");
                PaymentGloryController.this.getFccInstance().startChangeAsync(PaymentGloryController.this.totalValue, new ChangeCompleteEvent());
            }
        });
    }

    @Override
    public String getGuidance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setInventory(BrueBoxServiceStub.InventoryResponseType inv) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void doPaymentOnCashGlory(final double total) {
        this.gloryOccuped = true;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                PaymentGloryController.this.setGuidance("D\u00e9caissement en cours... ");
                PaymentGloryController.this.cancel_button.setDisable(true);
                PaymentGloryController.this.getFccInstance().startChangeAsync(-total, new ChangeCompleteEvent());
            }
        });
    }

    public boolean isTransactionSuccessed() {
        return this.success == 0 && this.amountToPay == 0.0;
    }

    private void loadEchecMsg(String msg) {
        this.errorLabel.setText(msg);
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.errorLabel, 0, 0, 1, 2);
        this.pane_main.add((Node)this.recoverMoney, 0, 2, 1, 1);
        this.pane_footer.getChildren().clear();
        this.pane_footer.add((Node)this.refund_button, 0, 0);
    }

    public void refundPayment() {
        this.recoverMoney.setVisible(true);
        this.doPaymentOnCashGlory(this.amountToPay);
    }

    private void intializer() {
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.pane_info_payment, 0, 0);
        this.pane_footer.getChildren().clear();
        this.pane_footer.add((Node)this.cancel_button, 0, 0);
    }

    @Override
    public void setReplenishCounting(List<Element> denomination) {
        BrueBoxServiceStub.DenominationType[] cashDenomiArray = this.getFccInstance().getCashDenomiArrayFromNodeListDenomi(denomination);
    }

    class ChangeCompleteEvent
    extends BrueBoxServiceCallbackHandler {
        ChangeCompleteEvent() {
        }

        private String getDetailDenom(BrueBoxServiceStub.DenominationType[] dnm, int[] amount, String manual) {
            Object retStr = "";
            if (dnm != null || Integer.parseInt(manual) > 0) {
                if (dnm != null) {
                    for (int i = 0; i < dnm.length; ++i) {
                        amount[0] = amount[0] + dnm[i].getFv().intValue() * dnm[i].getPiece().intValue();
                        retStr = (String)retStr + "\n  " + IUserInterface.decimalFormat.format(dnm[i].getFv().intValue() / 100) + "Euro " + dnm[i].getPiece().intValue() + " Pieces, ";
                    }
                }
                if (Integer.parseInt(manual) > 0) {
                    amount[0] = amount[0] + Integer.parseInt(manual);
                    retStr = (String)retStr + "\n  Manual Input " + IUserInterface.decimalFormat.format(Double.parseDouble(manual) / 100.0) + "Euro, ";
                }
            } else {
                retStr = "Nothing";
            }
            return retStr;
        }

        @Override
        public void receiveResultchangeOperation(final BrueBoxServiceStub.ChangeResponse result) {
            System.out.println("______________                     _________________________");
            if (result.getChangeResponse().getResult().intValue() == 0) {
                System.out.println("2873 : FCC_SUCCESS ");
                try {
                    double inDepot = (double)Integer.parseInt(result.getChangeResponse().getAmount()) / 100.0;
                    System.out.println("______________inDepot" + inDepot);
                    if (inDepot > 0.0) {
                        PaymentGloryController.this.getFccInstance().addSequenceNumber();
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                PaymentGloryController.this.setGuidance("Fin d'encaissement en CashGlory");
                PaymentGloryController.this.success = 0;
            } else if (result.getChangeResponse().getResult().intValue() == 1 || PaymentGloryController.this.getFccInstance().isCancelled()) {
                PaymentGloryController.this.setGuidance("L'operation est annul\u00e9e ");
                System.out.println("2909 : FCC_CANCEL ");
                PaymentGloryController.this.remaining.setText(Formats.DOUBLE.formatValue(PaymentGloryController.this.totalValue));
                PaymentGloryController.this.paid.setText(Formats.DOUBLE.formatValue(0));
                PaymentGloryController.this.success = 1;
            } else if (result.getChangeResponse().getResult().intValue() == 10 || result.getChangeResponse().getResult().intValue() == 99 || result.getChangeResponse().getResult().intValue() == 100) {
                System.out.println("FCC_SHORTAGE || FCC_INTERNAL_ERROR || FCC_MACHINE_ERROR");
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String insertedDenom = "";
                        String dispensedDenom = "";
                        int[] insertedAmount = new int[1];
                        int[] dispensedAmount = new int[1];
                        insertedDenom = ChangeCompleteEvent.this.getDetailDenom(result.getChangeResponse().getCash()[0].getDenomination(), insertedAmount, result.getChangeResponse().getManualDeposit());
                        dispensedDenom = ChangeCompleteEvent.this.getDetailDenom(result.getChangeResponse().getCash()[1].getDenomination(), dispensedAmount, "0");
                        long changeAmount = insertedAmount[0] - Integer.parseInt(result.getChangeResponse().getAmount()) - dispensedAmount[0];
                        if (changeAmount > 0L) {
                            PaymentGloryController.this.setGuidance("Echec de rendre la monnai. Op\u00e9ration annul\u00e9e");
                            PaymentGloryController.this.remaining.setText(Formats.DOUBLE.formatValue(PaymentGloryController.this.totalValue));
                            PaymentGloryController.this.paid.setText(Formats.DOUBLE.formatValue(0));
                            StringBuilder msg = new StringBuilder();
                            msg.append("Le Monnayeur n'a pas pu payer les monnaies en raison d'un stock insuffisant.\n").append("Le Montant ins\u00e9r\u00e9 est : " + insertedDenom.replace("Euro", "\u20ac") + "\nLa monnaie est : " + (dispensedDenom.equalsIgnoreCase("Nothing") ? "0" : dispensedDenom) + "\nL'op\u00e9ration a \u00e9t\u00e9 annul\u00e9e.");
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, msg.toString(), 4000, NPosition.BOTTOM_RIGHT);
                            PaymentGloryController.this.amountToPay = (double)insertedAmount[0] / 100.0;
                            PaymentGloryController.this.loadEchecMsg(msg.toString());
                        }
                        PaymentGloryController.this.success = 2;
                    }
                });
            } else {
                System.out.println("else");
                PaymentGloryController.this.setGuidance("Le monnayeur est occup\u00e9 .");
                PaymentGloryController.this.success = 3;
            }
            PaymentGloryController.this.getFccInstance().setCancelled(false);
            PaymentGloryController.this.gloryOccuped = false;
            System.out.println("End " + (PaymentGloryController.this.success == 0));
            if (PaymentGloryController.this.success == 0) {
                System.out.println("End");
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PaymentGloryController.this.cancel_button.setDisable(true);
                        PaymentGloryController.this.closePopUp();
                    }
                });
            }
        }
    }
}

