/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.DateUtils;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoViewRappel;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.kitchen.services.TicketSharedService;
import fr.protactile.norm.beans.EnteteInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;

public class OrdersBorneController
implements RootController {
    @FXML
    Button btn_next_date;
    @FXML
    Button btn_previous_date;
    @FXML
    Label jdate;
    @FXML
    TableView tableView;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn etat_order;
    @FXML
    TableColumn total_order;
    @FXML
    Button btn_kitchen;
    @FXML
    GridPane footer_print_pane;
    @FXML
    GridPane pane_main;
    private int numberHours = 0;
    private boolean isLimitedByHours = false;
    private final SimpleDateFormat dateFormatter = com.openbravo.pos.util.DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat timeFormatter = com.openbravo.pos.util.DateUtils.timeFormatter;
    @FXML
    TableColumn table_order;
    private Stage stage;
    private AppView app;
    private Date date;
    protected DataLogicSales dlSales;
    private DataLogicOrder dlOrders;
    private Date dateStart;
    private Date dateEnd;
    private List<PrinterInfo> printers;
    List<TicketLineInfo> productToSend;
    private List<TicketLineInfo> productEMP;
    private List<TicketLineInfo> productSpLater;
    private List<TicketLineInfo> productEmpLater;
    private List<TicketInfo> orders;
    private TicketInfo currentOrder;
    private EnteteInfo entetTicket;
    protected DataLogicAdmin dlUsers;
    private TicketSharedService ticketService;

    public void next() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, 1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText("Aujourd'hui");
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jdate.setText("Hier");
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        try {
            this.loadOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void previous() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, -1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDate() == cal.getTime().getDate()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText("Aujourd'hui");
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDate() == cal.getTime().getDate()) {
            this.jdate.setText("Hier");
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        try {
            this.loadOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void prepareTicketCuisine() {
        this.printers.clear();
        this.productToSend.clear();
        this.productEMP.clear();
        this.productEmpLater.clear();
        this.productSpLater.clear();
        for (TicketLineInfo line : this.currentOrder.getLines()) {
            if (line.isDiver()) continue;
            if (!line.isNext()) {
                if (line.isMenu()) {
                    boolean sendProduct = false;
                    try {
                        ProductInfoExt productTmp = this.dlSales.getProductInfoById(line.getProductID());
                        if (productTmp.getPrinterID() != -1) {
                            sendProduct = true;
                            line.setPrinterID(productTmp.getPrinterID());
                            PrinterInfo printerTmp = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                            int found = -1;
                            for (PrinterInfo printer : this.printers) {
                                if (printer.getId() != printerTmp.getId()) continue;
                                found = 1;
                            }
                            if (found == -1) {
                                this.printers.add(printerTmp);
                            }
                        }
                        for (ProductTicket product : line.getListProducts()) {
                            if (product.getPrinterID() == -1) continue;
                            sendProduct = true;
                            PrinterInfo printerTmp = this.dlSales.getPrinterByID(product.getPrinterID());
                            int found = -1;
                            for (PrinterInfo printer : this.printers) {
                                if (printer.getId() != printerTmp.getId()) continue;
                                found = 1;
                            }
                            if (found != -1) continue;
                            this.printers.add(printerTmp);
                        }
                        if (!sendProduct) continue;
                        this.productToSend.add(line);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    continue;
                }
                try {
                    ProductInfoExt productTmp = this.dlSales.getProductInfoById(line.getProductID());
                    if (productTmp.getPrinterID() == -1) continue;
                    line.setPrinterID(productTmp.getPrinterID());
                    this.productToSend.add(line);
                    PrinterInfo printerTmp = this.dlSales.getPrinterByID(productTmp.getPrinterID());
                    int found = -1;
                    for (PrinterInfo printer : this.printers) {
                        if (printer.getId() != printerTmp.getId()) continue;
                        found = 1;
                    }
                    if (found != -1) continue;
                    this.printers.add(printerTmp);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                continue;
            }
            TicketLineInfo linePrevious = new TicketLineInfo();
            linePrevious.setNext(true);
            this.productToSend.add(linePrevious);
        }
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        this.dateStart = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        this.dateEnd = calEnd.getTime();
    }

    private void loadOrder() throws BasicException {
        this.currentOrder = null;
        if ("2".equals(this.app.getAppUserView().getUser().getRole())) {
            if (AppLocal.TICKET_CALLBACK_LIMITED) {
                Calendar cal = Calendar.getInstance();
                this.dateEnd = new Date();
                cal.setTime(this.dateEnd);
                cal.add(10, -this.numberHours);
                this.dateStart = cal.getTime();
                this.btn_previous_date.setDisable(true);
                this.btn_next_date.setDisable(true);
            }
            this.orders = this.dlSales.loadAllTicketByuser(this.dateStart, this.dateEnd, this.app.getAppUserView().getUser().getId());
        } else {
            this.orders = this.dlSales.loadTicketToPrint(this.dateStart, this.dateEnd);
        }
        ArrayList<TicketInfoViewRappel> items = new ArrayList<TicketInfoViewRappel>();
        for (TicketInfo order : this.orders) {
            String orderNum;
            if (order == null) continue;
            String table = "";
            if (order.getIdTable() != -1) {
                table = String.valueOf(order.getTable().getNumber());
            }
            String status = this.getStatus(order.getStatus());
            String nameCustomer = order.getCustomer() != null ? order.getCustomer().getName() : order.getName_customer();
            String string = orderNum = order.getCaisse() != null ? order.getCaisse() + order.getNumero_order() : String.valueOf(order.getNumero_order());
            if (order.getNum_order_kitchen() != -1) {
                orderNum = String.valueOf(order.getNum_order_kitchen());
            }
            items.add(new TicketInfoViewRappel(orderNum, nameCustomer, table, order.getBipper(), this.dateFormatter.format(order.getDate()), this.timeFormatter.format(order.getDate()), order.getType(), status, order.printTotalOrder(), order.getUser().getName(), order.getSource_order()));
        }
        ObservableList data = FXCollections.observableArrayList(items);
        this.tableView.setItems(data);
    }

    public void printKitchen() {
        if (this.currentOrder != null && !this.currentOrder.getStatus().equalsIgnoreCase("cancel") && !this.currentOrder.getStatus().equalsIgnoreCase("Refund")) {
            this.prepareTicketCuisine();
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    Decreaser decreaser = new Decreaser(OrdersBorneController.this.dlSales, OrdersBorneController.this.currentOrder.getId(), "Ticket cuisine", null, OrdersBorneController.this.currentOrder.getNumero_order());
                    OrdersBorneController.this.sortLines(OrdersBorneController.this.currentOrder);
                }
            });
        }
    }

    private String getStatus(String status) {
        if (status != null) {
            switch (status) {
                case "livre": {
                    return "Livr\u00e9e";
                }
                case "paid": {
                    return "Termin\u00e9e";
                }
                case "cancel": {
                    return "Annul\u00e9e";
                }
                case "pending": {
                    return "En cours";
                }
                case "Refund": {
                    return "remboursement";
                }
            }
        }
        return null;
    }

    public void closePopUp() {
        this.stage.close();
    }

    private void sortLines(TicketInfo ticket) {
        ArrayList<TicketLineInfo> linesSP = new ArrayList<TicketLineInfo>();
        boolean printLater = ticket.getType().equals("Sur Place");
        if (printLater) {
            int found_take_away = -1;
            for (TicketLineInfo line : this.productToSend) {
                if ((line.getPlace_served() == null || !line.getPlace_served().equals("A Emporter")) && (line.getTime_served() == null || !line.getTime_served().equals("later"))) continue;
                found_take_away = 1;
                break;
            }
            if (found_take_away == -1) {
                printLater = false;
            }
        }
        if (printLater) {
            for (TicketLineInfo line : this.productToSend) {
                TicketLineInfo newLine = new TicketLineInfo(line);
                newLine.setPrinterID(line.getPrinterID());
                newLine.setTypeUpdate(line.getTypeUpdate());
                if (line.getPlace_served() != null && line.getPlace_served().equals("A Emporter")) {
                    if (line.getTime_served() != null && line.getTime_served().equals("later")) {
                        this.productEmpLater.add(newLine);
                        continue;
                    }
                    this.productEMP.add(newLine);
                    continue;
                }
                if (line.getTime_served() != null && line.getTime_served().equals("later")) {
                    this.productSpLater.add(newLine);
                    continue;
                }
                linesSP.add(newLine);
            }
            this.productToSend.clear();
            this.productToSend.addAll(linesSP);
        }
    }

    private void initializer() {
        this.stage.initStyle(StageStyle.UNDECORATED);
        this.ticketService = TicketSharedService.getInstance();
        this.numberHours = Integer.parseInt(AppLocal.TICKET_CALLBACK_COUNT != null && !AppLocal.TICKET_CALLBACK_COUNT.isEmpty() ? AppLocal.TICKET_CALLBACK_COUNT : "0");
        this.dlSales = (DataLogicSales)this.app.getBean("com.openbravo.dao.DataLogicSales");
        this.dlOrders = (DataLogicOrder)this.app.getBean("com.openbravo.dao.DataLogicOrder");
        this.dlUsers = (DataLogicAdmin)this.app.getBean("com.openbravo.pos.admin.DataLogicAdmin");
        Image imageNext = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1rightarrow.png"));
        this.btn_next_date.setGraphic((Node)new ImageView(imageNext));
        Image imagebPrevious = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/1leftarrow.png"));
        this.btn_previous_date.setGraphic((Node)new ImageView(imagebPrevious));
        this.btn_next_date.setVisible(false);
        this.printers = new ArrayList<PrinterInfo>();
        this.productToSend = new ArrayList<TicketLineInfo>();
        this.productEMP = new ArrayList<TicketLineInfo>();
        this.productSpLater = new ArrayList<TicketLineInfo>();
        this.productEmpLater = new ArrayList<TicketLineInfo>();
        this.jdate.setText("Aujourd'hui");
        this.currentOrder = null;
        this.entetTicket = null;
        this.tableView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (OrdersBorneController.this.tableView.getSelectionModel().getSelectedIndex() != -1 && (row = OrdersBorneController.this.tableView.getSelectionModel().getSelectedIndex()) != -1) {
                    OrdersBorneController.this.currentOrder = OrdersBorneController.this.orders.get(row);
                    try {
                        OrdersBorneController.this.entetTicket = OrdersBorneController.this.dlSales.getEnteteByTicket(OrdersBorneController.this.currentOrder.getId(), OrdersBorneController.this.currentOrder.isPaid());
                        OrdersBorneController.this.currentOrder.setCustomer(OrdersBorneController.this.dlSales.loadCustomerExt(OrdersBorneController.this.currentOrder.getCustomerId()));
                        List<TicketLineInfo> lines = OrdersBorneController.this.dlSales.loadLines(OrdersBorneController.this.currentOrder.getId());
                        List<TicketLineInfo> linesExterne = OrdersBorneController.this.dlSales.getTicketLineExterne(OrdersBorneController.this.currentOrder.getId());
                        lines.addAll(linesExterne);
                        OrdersBorneController.this.currentOrder.setLines(lines);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        });
        Calendar calToday = Calendar.getInstance();
        this.date = DateUtils.getToday();
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
        this.table_order.setCellValueFactory((Callback)new PropertyValueFactory("tableOrder"));
        this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
        this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hourOrder"));
        this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("typeOrder"));
        this.etat_order.setCellValueFactory((Callback)new PropertyValueFactory("etatOrder"));
        this.total_order.setCellValueFactory((Callback)new PropertyValueFactory("totalOrder"));
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date = calToday.getTime();
        }
        this.setTime(this.date);
        try {
            this.loadOrder();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object app) {
        this.stage = mStage;
        this.app = (AppView)app;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        if (objects != null) {
            for (Object object : objects) {
                if (!(object instanceof AppView)) continue;
                this.app = (AppView)object;
            }
        }
        this.initializer();
    }
}

