/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppUser;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.TicketService;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class OpenCaisseController {
    @FXML
    Label num_fond;
    @FXML
    Label label_cash_fund;
    @FXML
    Button btn_open_drawer;
    @FXML
    Button btn_valid;
    private JRootApp app;
    private AppUser user;
    private int role;
    private CaisseInfo caisse;
    private DataLogicSales dlSales;
    private Stage stage;
    private boolean first_press;
    @FXML
    GridPane keyborad_pane;
    private TicketService mTickService;

    public void init(Stage stage, Scene scene, int role, JRootApp app, AppUser user) throws BasicException {
        try {
            this.app = app;
            this.user = user;
            this.role = role;
            this.dlSales = (DataLogicSales)app.getBean("com.openbravo.dao.DataLogicSales");
            this.caisse = this.dlSales.getCaisse(AppLocal.token);
            String value_turnover = Formats.DOUBLE.formatValue(this.caisse.getFondClose());
            value_turnover = value_turnover.replaceAll(",", ".");
            this.num_fond.setText(value_turnover);
            this.stage = stage;
            this.first_press = true;
            this.btn_valid.setText(AppLocal.getIntString("Button.valid"));
            this.btn_open_drawer.setText(AppLocal.getIntString("Button.open.drawer"));
            this.label_cash_fund.setText(AppLocal.getIntString("Label.cash.fund.open"));
            this.mTickService = TicketService.getInstance();
        }
        catch (Exception ex) {
            Logger.getLogger(OpenCaisseController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void select0() {
        this.press_number("0");
    }

    public void select1() {
        this.press_number("1");
    }

    public void select2() {
        this.press_number("2");
    }

    public void select3() {
        this.press_number("3");
    }

    public void select4() {
        this.press_number("4");
    }

    public void select5() {
        this.press_number("5");
    }

    public void select6() {
        this.press_number("6");
    }

    public void select7() {
        this.press_number("7");
    }

    public void select8() {
        this.press_number("8");
    }

    public void select9() {
        this.press_number("9");
    }

    public void selectBack() {
        if (this.first_press) {
            this.num_fond.setText("");
            this.first_press = false;
        }
        if (this.num_fond.getText().length() >= 1) {
            this.num_fond.setText(this.num_fond.getText().substring(0, this.num_fond.getText().length() - 1));
        }
    }

    public void selectPoint() {
        if (this.first_press) {
            this.num_fond.setText("");
            this.first_press = false;
        }
        if (this.num_fond.getText().length() >= 1) {
            this.num_fond.setText(this.num_fond.getText() + ".");
        }
    }

    public void valider() {
        this.stage.close();
        double fond_caisse = Double.parseDouble(this.num_fond.getText().isEmpty() ? "0.0" : this.num_fond.getText());
        this.caisse.setFondCaisse(fond_caisse);
        this.caisse.setOuverte(true);
        this.caisse.setDateOpen(new Date());
        this.caisse.setUser_open(this.user.getUserInfo());
        try {
            this.dlSales.openCaisse(this.caisse);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.app.openAppView(this.user, this.role, true);
        AppLocal.changeUser = true;
        this.app.getFxPanel().setScene(this.app.getCurrentScene());
    }

    private void press_number(String number) {
        if (this.first_press) {
            this.num_fond.setText("");
            this.first_press = false;
        }
        this.num_fond.setText(this.num_fond.getText() + number);
    }

    public void openDrawer() {
        this.mTickService.openDrawer();
    }
}

