/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.components.LazyModal;
import com.openbravo.components.ModalConfirmationController;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.config.ConfigurationManagerSite;
import com.openbravo.pos.config.SiteConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.parser.ResponseObject;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.CarteService;
import com.openbravo.service.SiteConfigService;
import fr.protactile.procaisse.dao.entities.CityDeliveryInfo;
import fr.protactile.procaisse.dao.entities.TimeTableInfo;
import fr.protactile.procaisse.dao.entities.WorkShiftInfo;
import fr.protactile.procaisse.dao.entities.ZoneDeliveryInfo;
import fr.protactile.procaisse.services.CityDeliveryService;
import fr.protactile.procaisse.services.TimeTableService;
import fr.protactile.procaisse.services.ZoneDeliveryService;
import java.awt.Dimension;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import org.json.simple.JSONObject;

public class ManageSiteCommandeController {
    @FXML
    TextField start_time1_monday;
    @FXML
    TextField end_time1_monday;
    @FXML
    TextField start_time2_monday;
    @FXML
    TextField end_time2_monday;
    @FXML
    TextField start_time1_tuesday;
    @FXML
    TextField end_time1_tuesday;
    @FXML
    TextField start_time2_tuesday;
    @FXML
    TextField end_time2_tuesday;
    @FXML
    TextField start_time1_wednesday;
    @FXML
    TextField end_time1_wednesday;
    @FXML
    TextField start_time2_wednesday;
    @FXML
    TextField end_time2_wednesday;
    @FXML
    TextField start_time1_thursday;
    @FXML
    TextField end_time1_thursday;
    @FXML
    TextField start_time2_thursday;
    @FXML
    TextField end_time2_thursday;
    @FXML
    TextField start_time1_friday;
    @FXML
    TextField end_time1_friday;
    @FXML
    TextField start_time2_friday;
    @FXML
    TextField end_time2_friday;
    @FXML
    TextField start_time1_saturday;
    @FXML
    TextField end_time1_saturday;
    @FXML
    TextField start_time2_saturday;
    @FXML
    TextField end_time2_saturday;
    @FXML
    TextField start_time1_sunday;
    @FXML
    TextField end_time1_sunday;
    @FXML
    TextField start_time2_sunday;
    @FXML
    TextField end_time2_sunday;
    @FXML
    TableView list_zones;
    @FXML
    TableColumn column_zone;
    @FXML
    TableColumn column_min_total;
    @FXML
    TextField name_zone;
    @FXML
    TextField zipCode;
    @FXML
    TextField min_total_order;
    @FXML
    CheckBox at_spot;
    @FXML
    CheckBox take_away;
    @FXML
    CheckBox delivery;
    @FXML
    CheckBox platform;
    @FXML
    TextField url_platform;
    @FXML
    CheckBox stripe;
    @FXML
    GridPane pane_params;
    @FXML
    Label label_url_platform;
    @FXML
    CheckBox day_off_1;
    @FXML
    CheckBox day_off_2;
    @FXML
    CheckBox day_off_3;
    @FXML
    CheckBox day_off_4;
    @FXML
    CheckBox day_off_5;
    @FXML
    CheckBox day_off_6;
    @FXML
    CheckBox day_off_7;
    @FXML
    GridPane pane_shift_day1;
    @FXML
    GridPane pane_shift_day2;
    @FXML
    GridPane pane_shift_day3;
    @FXML
    GridPane pane_shift_day4;
    @FXML
    GridPane pane_shift_day5;
    @FXML
    GridPane pane_shift_day6;
    @FXML
    GridPane pane_shift_day7;
    @FXML
    GridPane first_shift_monday;
    @FXML
    GridPane second_shift_monday;
    @FXML
    GridPane first_shift_tuesday;
    @FXML
    GridPane second_shift_tuesday;
    @FXML
    GridPane first_shift_wednesday;
    @FXML
    GridPane second_shift_wednesday;
    @FXML
    GridPane first_shift_thursday;
    @FXML
    GridPane second_shift_thursday;
    @FXML
    GridPane first_shift_friday;
    @FXML
    GridPane second_shift_friday;
    @FXML
    GridPane first_shift_saturday;
    @FXML
    GridPane second_shift_saturday;
    @FXML
    GridPane first_shift_sunday;
    @FXML
    GridPane second_shift_sunday;
    @FXML
    TableView list_cities;
    @FXML
    TableColumn column_city;
    @FXML
    TableColumn column_zip_code;
    @FXML
    TextField name_city;
    @FXML
    TextField zip_code;
    @FXML
    Button btn_init_zone;
    @FXML
    Button btn_init_city;
    @FXML
    Button btn_delete_zone;
    @FXML
    Button btn_delete_city;
    @FXML
    CheckBox hide_image_option;
    @FXML
    ComboBox list_cities_to_add;
    @FXML
    TableView list_cities_zone;
    @FXML
    TableColumn column_city_zone;
    @FXML
    TableColumn column_delete;
    @FXML
    TextField delivery_costs;
    @FXML
    Button btn_upload_item;
    @FXML
    Button btn_upload_images;
    protected AppView m_App;
    private List<TimeTableInfo> timestables;
    private TimeTableService mTimeTableService;
    private TextField[][] startTimeShift;
    private TextField[][] endTimeShift;
    private ZoneDeliveryService mZoneDeliveryService;
    private List<ZoneDeliveryInfo> zones;
    private ObservableList<ZoneDeliveryInfo> data_zones;
    private ConfigurationManagerSite mConfigurationManagerSite;
    private SiteConfig mSiteConfig;
    private CheckBox[] daysOff;
    private GridPane[] shifts_day;
    private GridPane[] first_shifts;
    private GridPane[] second_shifts;
    private ZoneDeliveryInfo currentZoneDeliveryInfo;
    private List<CityDeliveryInfo> cities;
    private int index_current_zone;
    private SiteConfigService mSiteConfigService;
    private CityDeliveryInfo currentCityDeliveryInfo;
    private int index_current_city;
    private CityDeliveryService mCityDeliveryService;
    private ObservableList<CityDeliveryInfo> data_cities;
    private LazyModal mLazyModalConfirm = null;
    private EventHiddenModal mActionEventConfirm = null;
    private ModalConfirmationController mModalConfirmationController = null;
    private Scene scene;
    private List<CityDeliveryInfo> cities_to_add;
    private List<CityDeliveryInfo> cities_of_zone;
    private ObservableList<CityDeliveryInfo> data_cities_to_add;
    private ObservableList<CityDeliveryInfo> data_cities_of_zone;
    private Image imageDelete;
    private boolean add_city = true;
    private DataLogicSales dlSales;
    private DataLogicItems dlItems;
    private CarteService mCarteService;
    private EventHandler platFormHandle = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            if (event.getSource() instanceof CheckBox) {
                ManageSiteCommandeController.this.loadNodesParams();
            }
        }
    };
    private EventHandler dayOffHandle = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            CheckBox checkBoxSource;
            if (event.getSource() instanceof CheckBox && (checkBoxSource = (CheckBox)event.getSource()) != null && checkBoxSource.getProperties().get((Object)"index") != null) {
                int index = (Integer)checkBoxSource.getProperties().get((Object)"index");
                ManageSiteCommandeController.this.loadNodeShift(index, checkBoxSource.isSelected());
            }
        }
    };

    public void initializer(AppView m_App, Scene scene) throws URISyntaxException {
        this.m_App = m_App;
        this.scene = scene;
        this.startTimeShift = new TextField[][]{{this.start_time1_monday, this.start_time2_monday}, {this.start_time1_tuesday, this.start_time2_tuesday}, {this.start_time1_wednesday, this.start_time2_wednesday}, {this.start_time1_thursday, this.start_time2_thursday}, {this.start_time1_friday, this.start_time2_friday}, {this.start_time1_saturday, this.start_time2_saturday}, {this.start_time1_sunday, this.start_time2_sunday}};
        this.endTimeShift = new TextField[][]{{this.end_time1_monday, this.end_time2_monday}, {this.end_time1_tuesday, this.end_time2_tuesday}, {this.end_time1_wednesday, this.end_time2_wednesday}, {this.end_time1_thursday, this.end_time2_thursday}, {this.end_time1_friday, this.end_time2_friday}, {this.end_time1_saturday, this.end_time2_saturday}, {this.end_time1_sunday, this.end_time2_sunday}};
        this.daysOff = new CheckBox[]{this.day_off_1, this.day_off_2, this.day_off_3, this.day_off_4, this.day_off_5, this.day_off_6, this.day_off_7};
        this.shifts_day = new GridPane[]{this.pane_shift_day1, this.pane_shift_day2, this.pane_shift_day3, this.pane_shift_day4, this.pane_shift_day5, this.pane_shift_day6, this.pane_shift_day7};
        this.first_shifts = new GridPane[]{this.first_shift_monday, this.first_shift_tuesday, this.first_shift_wednesday, this.first_shift_thursday, this.first_shift_friday, this.first_shift_saturday, this.first_shift_sunday};
        this.second_shifts = new GridPane[]{this.second_shift_monday, this.second_shift_tuesday, this.second_shift_wednesday, this.second_shift_thursday, this.second_shift_friday, this.second_shift_saturday, this.second_shift_sunday};
        this.min_total_order.getProperties().put((Object)"vkType", (Object)1);
        this.delivery_costs.getProperties().put((Object)"vkType", (Object)1);
        this.mTimeTableService = TimeTableService.getInstance();
        this.mZoneDeliveryService = ZoneDeliveryService.getInstance();
        this.mCityDeliveryService = CityDeliveryService.getInstance();
        Image imageAdd = new Image(this.getClass().getResource("/com/openbravo/images/add.png").toURI().toString(), 40.0, 30.0, false, false);
        this.imageDelete = new Image(this.getClass().getResource("/com/openbravo/images/sale_delete.png").toURI().toString(), 40.0, 30.0, false, false);
        this.btn_init_zone.setGraphic((Node)new ImageView(imageAdd));
        this.btn_delete_zone.setGraphic((Node)new ImageView(this.imageDelete));
        this.btn_init_city.setGraphic((Node)new ImageView(imageAdd));
        this.btn_delete_city.setGraphic((Node)new ImageView(this.imageDelete));
        this.timestables = this.mTimeTableService.getTimesTable();
        this.zones = this.mZoneDeliveryService.getZones();
        this.cities = this.mCityDeliveryService.getCities();
        this.mSiteConfigService = SiteConfigService.getInstance();
        this.loadTimesTable();
        this.createTable();
        this.mConfigurationManagerSite = new ConfigurationManagerSite();
        this.mSiteConfig = this.mConfigurationManagerSite.getmSiteConfig();
        this.loadParamsSite();
        this.platform.setOnAction(this.platFormHandle);
        int index = 0;
        for (CheckBox checkBox : this.daysOff) {
            checkBox.getProperties().put((Object)"index", (Object)index);
            checkBox.setOnAction(this.dayOffHandle);
            ++index;
        }
        this.initZone();
        this.initCity();
        this.dlSales = (DataLogicSales)m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.dlItems = (DataLogicItems)m_App.getBean("com.openbravo.dao.DataLogicItems");
        this.dlSales.setDlItems(this.dlItems);
        this.mCarteService = new CarteService(this.dlSales, this.dlItems, m_App);
    }

    private void loadTimesTable() {
        int index_day = 0;
        for (TimeTableInfo timetable : this.timestables) {
            this.daysOff[index_day].setSelected(timetable.getDay_off() == false);
            this.loadNodeShift(index_day, this.daysOff[index_day].isSelected());
            if (timetable.getWorkShiftCollection() != null) {
                int index_work_shift = 0;
                for (WorkShiftInfo workShiftInfo : timetable.getWorkShiftCollection()) {
                    this.startTimeShift[index_day][index_work_shift].setText(workShiftInfo.getStart_shift());
                    this.endTimeShift[index_day][index_work_shift].setText(workShiftInfo.getEnd_shift());
                    ++index_work_shift;
                }
            }
            ++index_day;
        }
    }

    public void createTable() {
        this.column_zone.setCellValueFactory((Callback)new PropertyValueFactory("name_zone"));
        this.column_min_total.setCellValueFactory((Callback)new PropertyValueFactory("text_min_total"));
        this.list_zones.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (ManageSiteCommandeController.this.list_zones.getSelectionModel().getSelectedIndex() != -1 && (row = ManageSiteCommandeController.this.list_zones.getSelectionModel().getSelectedIndex()) != -1) {
                    ManageSiteCommandeController.this.currentZoneDeliveryInfo = ManageSiteCommandeController.this.zones.get(row);
                    ManageSiteCommandeController.this.index_current_zone = row;
                    ManageSiteCommandeController.this.loadInfoZone();
                }
            }
        });
        this.data_zones = FXCollections.observableArrayList(this.zones);
        this.list_zones.getItems().clear();
        this.list_zones.setItems(this.data_zones);
        this.column_city.setCellValueFactory((Callback)new PropertyValueFactory("city"));
        this.column_zip_code.setCellValueFactory((Callback)new PropertyValueFactory("zipCode"));
        this.list_cities.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (ManageSiteCommandeController.this.list_cities.getSelectionModel().getSelectedIndex() != -1 && (row = ManageSiteCommandeController.this.list_cities.getSelectionModel().getSelectedIndex()) != -1) {
                    ManageSiteCommandeController.this.currentCityDeliveryInfo = ManageSiteCommandeController.this.cities.get(row);
                    ManageSiteCommandeController.this.index_current_city = row;
                    ManageSiteCommandeController.this.loadInfoCity();
                }
            }
        });
        this.data_cities = FXCollections.observableArrayList(this.cities);
        this.list_cities.getItems().clear();
        this.list_cities.setItems(this.data_cities);
        this.column_city_zone.setCellValueFactory((Callback)new PropertyValueFactory("city"));
        Callback<TableColumn<CityDeliveryInfo, Void>, TableCell<CityDeliveryInfo, Void>> cellFactory = new Callback<TableColumn<CityDeliveryInfo, Void>, TableCell<CityDeliveryInfo, Void>>(){

            public TableCell<CityDeliveryInfo, Void> call(TableColumn<CityDeliveryInfo, Void> param) {
                TableCell<CityDeliveryInfo, Void> cell = new TableCell<CityDeliveryInfo, Void>(){
                    private final Button btn = new Button();
                    {
                        this.btn.setGraphic((Node)new ImageView(ManageSiteCommandeController.this.imageDelete));
                        this.btn.getStyleClass().add((Object)"bg_transparent");
                        this.btn.setOnAction(event -> {
                            System.out.println("++++++ getIndex() : " + this.getIndex());
                            CityDeliveryInfo city = ManageSiteCommandeController.this.cities_of_zone.get(this.getIndex());
                            city.setIdZoneDelivery(0);
                            ManageSiteCommandeController.this.cities_of_zone.remove(city);
                            ManageSiteCommandeController.this.cities_to_add.add(city);
                            ManageSiteCommandeController.this.data_cities_to_add.add((Object)city);
                            ManageSiteCommandeController.this.data_cities_of_zone.remove((Object)city);
                            System.out.println("selectedData: " + city);
                        });
                    }

                    public void updateItem(Void item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else {
                            this.setGraphic((Node)this.btn);
                        }
                    }
                };
                return cell;
            }
        };
        this.column_delete.setCellFactory((Callback)cellFactory);
    }

    private void loadInfoZone() {
        this.name_zone.setText(this.currentZoneDeliveryInfo.getName_zone());
        this.min_total_order.setText(String.valueOf(this.currentZoneDeliveryInfo.getMin_total()));
        this.delivery_costs.setText(String.valueOf(this.currentZoneDeliveryInfo.getDelivery_costs()));
        this.cities_of_zone = this.currentZoneDeliveryInfo.getCityCollection();
        this.data_cities_of_zone = FXCollections.observableArrayList(this.cities_of_zone);
        this.list_cities_zone.getItems().clear();
        this.list_cities_zone.setItems(this.data_cities_of_zone);
        this.initCitiesToAdd();
    }

    private void saveTimesTable() {
        int index_day = 0;
        for (TimeTableInfo timestable : this.timestables) {
            timestable.setDay_off(!this.daysOff[index_day].isSelected());
            if (timestable.getWorkShiftCollection() != null) {
                int index_work_shift = 0;
                for (WorkShiftInfo workShiftInfo : timestable.getWorkShiftCollection()) {
                    workShiftInfo.setStart_shift(this.startTimeShift[index_day][index_work_shift].getText());
                    workShiftInfo.setEnd_shift(this.endTimeShift[index_day][index_work_shift].getText());
                    ++index_work_shift;
                }
            }
            ++index_day;
        }
        this.mTimeTableService.update(this.timestables);
    }

    public void saveZone() {
        if (!this.name_zone.getText().isEmpty() && !this.min_total_order.getText().isEmpty()) {
            if (this.currentZoneDeliveryInfo == null) {
                this.currentZoneDeliveryInfo = new ZoneDeliveryInfo();
            }
            this.currentZoneDeliveryInfo.setName_zone(this.name_zone.getText());
            this.currentZoneDeliveryInfo.setMin_total(Double.parseDouble(this.min_total_order.getText().isEmpty() ? "0.0" : this.min_total_order.getText()));
            this.currentZoneDeliveryInfo.setDelivery_costs(Double.parseDouble(this.delivery_costs.getText().isEmpty() ? "0.0" : this.delivery_costs.getText()));
            this.mZoneDeliveryService.save(this.currentZoneDeliveryInfo, this.cities_of_zone);
            this.loadZones();
            this.initZone();
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de remplir tous les champs.", 4000, NPosition.CENTER);
        }
    }

    public void initZone() {
        this.index_current_zone = -1;
        this.currentZoneDeliveryInfo = null;
        this.name_zone.setText("");
        this.min_total_order.setText("");
        this.delivery_costs.setText("");
        if (this.cities_of_zone != null) {
            this.cities_of_zone.clear();
        } else {
            this.cities_of_zone = new ArrayList<CityDeliveryInfo>();
        }
        this.zones = this.mZoneDeliveryService.getZones();
        this.data_zones = FXCollections.observableArrayList(this.zones);
        this.list_zones.getItems().clear();
        this.list_zones.setItems(this.data_zones);
        if (this.data_cities_of_zone != null) {
            this.data_cities_of_zone.clear();
        } else {
            this.data_cities_of_zone = FXCollections.observableArrayList(this.cities_of_zone);
            this.list_cities_zone.getItems().clear();
            this.list_cities_zone.setItems(this.data_cities_of_zone);
        }
        this.initCitiesToAdd();
    }

    private void loadParamsSite() {
        this.at_spot.setSelected(this.mSiteConfig.isAt_spot());
        this.take_away.setSelected(this.mSiteConfig.isTake_away());
        this.delivery.setSelected(this.mSiteConfig.isDelivery());
        this.platform.setSelected(this.mSiteConfig.isPlatform());
        this.url_platform.setText(this.mSiteConfig.getPlatfom_url());
        this.stripe.setSelected(this.mSiteConfig.isStripe());
        this.hide_image_option.setSelected(this.mSiteConfig.isHide_image_option());
        this.loadNodesParams();
    }

    private void saveParamsSite() {
        this.mSiteConfig.setAt_spot(this.at_spot.isSelected());
        this.mSiteConfig.setTake_away(this.take_away.isSelected());
        this.mSiteConfig.setDelivery(this.delivery.isSelected());
        this.mSiteConfig.setPlatform(this.platform.isSelected());
        this.mSiteConfig.setPlatfom_url(this.url_platform.getText());
        this.mSiteConfig.setStripe(this.stripe.isSelected());
        this.mSiteConfig.setHide_image_option(this.hide_image_option.isSelected());
        this.mConfigurationManagerSite.save(this.mSiteConfig);
    }

    public void saveAndUpload() {
        try {
            this.saveParamsSite();
            this.saveTimesTable();
            this.uploadParamsSite();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "les param\u00e8tres sont upload\u00e9.", 4000, NPosition.CENTER);
        }
        catch (IOException ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 4000, NPosition.CENTER);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void loadNodesParams() {
        if (this.platform.isSelected()) {
            this.pane_params.getChildren().clear();
            this.pane_params.add((Node)this.at_spot, 0, 0);
            this.pane_params.add((Node)this.take_away, 0, 1);
            this.pane_params.add((Node)this.delivery, 0, 2);
            this.pane_params.add((Node)this.platform, 0, 3);
            this.pane_params.add((Node)this.label_url_platform, 0, 4);
            this.pane_params.add((Node)this.url_platform, 0, 5);
            this.pane_params.add((Node)this.stripe, 0, 6);
            this.pane_params.add((Node)this.hide_image_option, 0, 7);
        } else {
            this.pane_params.getChildren().clear();
            this.pane_params.add((Node)this.at_spot, 0, 0);
            this.pane_params.add((Node)this.take_away, 0, 1);
            this.pane_params.add((Node)this.delivery, 0, 2);
            this.pane_params.add((Node)this.platform, 0, 3);
            this.pane_params.add((Node)this.stripe, 0, 4);
            this.pane_params.add((Node)this.hide_image_option, 0, 5);
        }
    }

    private void loadNodeShift(int index, boolean selected) {
        this.shifts_day[index].getChildren().clear();
        if (selected) {
            this.shifts_day[index].add((Node)this.first_shifts[index], 0, 0);
            this.shifts_day[index].add((Node)this.second_shifts[index], 1, 0);
        }
    }

    public void addCity() {
        if (!this.name_city.getText().isEmpty() && !this.zip_code.getText().isEmpty()) {
            CityDeliveryInfo mCityDeliveryInfo = new CityDeliveryInfo(this.name_city.getText(), this.zip_code.getText());
            this.cities.add(mCityDeliveryInfo);
            this.data_cities.add((Object)mCityDeliveryInfo);
            this.name_city.setText("");
            this.zip_code.setText("");
        }
    }

    private void uploadParamsSite() throws IOException {
        if (AppLocal.ONLINE_ORDER_HOST_NAME != null && !AppLocal.ONLINE_ORDER_HOST_NAME.isEmpty()) {
            JSONObject jsonParamSite = ResponseObject.getRootJsonParamsSite(this.zones, this.timestables, this.mSiteConfig);
            this.mSiteConfigService.uploadParamsSite(jsonParamSite);
        }
    }

    private void loadInfoCity() {
        this.name_city.setText(this.currentCityDeliveryInfo.getCity());
        this.zip_code.setText(this.currentCityDeliveryInfo.getZipCode());
    }

    public void initCity() {
        this.index_current_city = -1;
        this.currentCityDeliveryInfo = null;
        this.name_city.setText("");
        this.zip_code.setText("");
    }

    public void saveCity() {
        if (!this.name_city.getText().isEmpty() && !this.zip_code.getText().isEmpty()) {
            boolean new_city = false;
            if (this.currentCityDeliveryInfo == null) {
                new_city = true;
                this.currentCityDeliveryInfo = new CityDeliveryInfo();
            }
            this.currentCityDeliveryInfo.setCity(this.name_city.getText());
            this.currentCityDeliveryInfo.setZipCode(this.zip_code.getText());
            this.mCityDeliveryService.save(this.currentCityDeliveryInfo);
            if (new_city) {
                this.cities.add(this.currentCityDeliveryInfo);
                this.data_cities.add((Object)this.currentCityDeliveryInfo);
            } else {
                this.data_cities.set(this.index_current_city, (Object)this.currentCityDeliveryInfo);
            }
            this.initCity();
            this.initCitiesToAdd();
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de remplir tous les champs.", 4000, NPosition.CENTER);
        }
    }

    public void deleteZone() {
        if (this.currentZoneDeliveryInfo != null) {
            this.modalConfirm(true);
        }
    }

    public void deleteCity() {
        if (this.currentCityDeliveryInfo != null) {
            this.modalConfirm(false);
        }
    }

    private void validDeleteZone() {
        if (this.currentZoneDeliveryInfo != null) {
            this.mZoneDeliveryService.delete(this.currentZoneDeliveryInfo);
            this.zones.remove(this.currentZoneDeliveryInfo);
            this.data_zones.remove(this.index_current_zone);
            this.initZone();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Zone supprim\u00e9.", 4000, NPosition.CENTER);
        }
    }

    private void valideDeleteCity() {
        if (this.currentCityDeliveryInfo != null) {
            this.mCityDeliveryService.remove(this.currentCityDeliveryInfo);
            this.cities.remove(this.currentCityDeliveryInfo);
            this.data_cities.remove(this.index_current_city);
            this.initCity();
            this.initCitiesToAdd();
            this.loadZones();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Ville supprim\u00e9.", 4000, NPosition.CENTER);
        }
    }

    private void modalConfirm(final boolean is_zone) {
        String title_modal = is_zone ? "Suppression Zone" : "Suppression Ville";
        String message_modal = is_zone ? "Voulez-vous Supprimer la zone ?" : "Voulez-vous Supprimer la ville ?";
        try {
            this.mActionEventConfirm = new EventHiddenModal(){
                Boolean result = false;

                @Override
                public void onHidden() {
                    if (this.result.booleanValue()) {
                        if (is_zone) {
                            ManageSiteCommandeController.this.validDeleteZone();
                        } else {
                            ManageSiteCommandeController.this.valideDeleteCity();
                        }
                    }
                    ManageSiteCommandeController.this.mLazyModalConfirm.destroyEvents();
                    ManageSiteCommandeController.this.mModalConfirmationController = null;
                    ManageSiteCommandeController.this.mActionEventConfirm = null;
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (ManageSiteCommandeController.this.mModalConfirmationController != null) {
                        this.result = ManageSiteCommandeController.this.mModalConfirmationController.getResult();
                    } else if (mBuilder != null && mBuilder.getController() != null) {
                        ManageSiteCommandeController.this.mModalConfirmationController = (ModalConfirmationController)mBuilder.getController();
                        this.result = ManageSiteCommandeController.this.mModalConfirmationController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalConfirm == null) {
                this.mLazyModalConfirm = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/components/popup_confirmation.fxml", new Dimension(400, 150));
            }
            this.mLazyModalConfirm.setEventHiddenModal(this.mActionEventConfirm);
            this.mLazyModalConfirm.load(new Object[0]);
            this.mModalConfirmationController = (ModalConfirmationController)this.mLazyModalConfirm.getLoadder().getController();
            this.mModalConfirmationController.configureText(title_modal, message_modal, "Confirmer", "Annuler");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void initCitiesToAdd() {
        this.cities_to_add = this.mCityDeliveryService.getNewCities();
        this.data_cities_to_add = FXCollections.observableArrayList(this.cities_to_add);
        this.list_cities_to_add.setItems(this.data_cities_to_add);
    }

    public void chooseCity() {
        System.out.println("++++++++++++ click");
        CityDeliveryInfo city_to_add = (CityDeliveryInfo)this.list_cities_to_add.getValue();
        System.out.println("+++++++++ city_to_add : " + city_to_add);
        if (city_to_add != null && !this.existInCitiesZone(city_to_add)) {
            System.out.println("+++++ city_to_add name : " + city_to_add.getCity());
            this.add_city = false;
            this.cities_of_zone.add(city_to_add);
            this.data_cities_of_zone.add((Object)city_to_add);
        }
        this.add_city = true;
    }

    private boolean existInCitiesZone(CityDeliveryInfo city) {
        if (this.cities_of_zone != null) {
            for (CityDeliveryInfo city_zone : this.cities_of_zone) {
                if (!Objects.equals(city_zone.getId(), city.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private void loadZones() {
        this.zones = this.mZoneDeliveryService.getZones();
        this.data_zones = FXCollections.observableArrayList(this.zones);
        this.list_zones.getItems().clear();
        this.list_zones.setItems(this.data_zones);
    }

    public void save() {
        try {
            this.saveParamsSite();
            this.saveTimesTable();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "les param\u00e8tres sont valid\u00e9.", 4000, NPosition.CENTER);
        }
        catch (Exception ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 4000, NPosition.CENTER);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void uploadItems() {
        this.btn_upload_item.setText("Upload des produits en cours ...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ManageSiteCommandeController.this.mCarteService = new CarteService(ManageSiteCommandeController.this.dlSales, ManageSiteCommandeController.this.dlItems, ManageSiteCommandeController.this.m_App);
                    ManageSiteCommandeController.this.mCarteService.uploadCarte();
                    Platform.runLater(() -> ManageSiteCommandeController.this.btn_upload_item.setText("Mettre \u00e0 jour des produits"));
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est upload\u00e9.", 4000, NPosition.CENTER);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    Platform.runLater(() -> ManageSiteCommandeController.this.btn_upload_item.setText("Mettre \u00e0 jour des produits"));
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
                }
            }
        }).start();
    }

    public void uploadImages() {
        this.btn_upload_images.setText("Upload des images en cours ...");
        new Thread(() -> {
            try {
                boolean upload = this.mCarteService.uploadPicture();
                Platform.runLater(() -> this.btn_upload_images.setText("Mettre \u00e0 jour des images"));
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est upload\u00e9.", 4000, NPosition.CENTER);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                Platform.runLater(() -> this.btn_upload_images.setText("Mettre \u00e0 jour des images"));
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
            }
        }).start();
    }
}

