/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.entities.LoyaltyCardInfo;
import fr.protactile.procaisse.services.CustomerService;
import fr.protactile.procaisse.services.LoyaltyCardService;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class LoyaltyCardController
implements RootController {
    @FXML
    GridPane pane_main;
    @FXML
    GridPane pane_scan;
    @FXML
    GridPane pane_add_customer;
    @FXML
    Label phone_customer;
    @FXML
    TextField text_loyalty_card;
    @FXML
    Button button;
    @FXML
    Label label_scan_card;
    @FXML
    Label label_phone_customer;
    private LoyaltyCardService mLoyaltyCardService = LoyaltyCardService.getInstance();
    private CustomerService mCustomerService;
    private boolean pane_scan_displayed;
    private CustomerInfo customer;
    private Stage stage;

    public LoyaltyCardController() {
        CustomerService.getInstance();
        this.mCustomerService = CustomerService.getInstance();
        this.pane_scan_displayed = true;
    }

    public void intializer() {
        this.loadPaneScanCard();
        this.text_loyalty_card.getProperties().put((Object)"vkType", (Object)4);
        this.text_loyalty_card.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    LoyaltyCardController.this.checkCodeLoyaltyCard();
                }
            }
        });
        this.button.setText(AppLocal.getIntString("Button.valid"));
        this.label_scan_card.setText(AppLocal.getIntString("Text.scan.loyalty.card"));
        this.label_phone_customer.setText(AppLocal.getIntString("Text.phone.customer"));
    }

    private void selectNum(int number) {
        if (this.phone_customer.getText().length() < 10) {
            this.phone_customer.setText(this.phone_customer.getText() + number);
        }
    }

    public void select0() {
        this.selectNum(0);
    }

    public void select1() {
        this.selectNum(1);
    }

    public void select2() {
        this.selectNum(2);
    }

    public void select3() {
        this.selectNum(3);
    }

    public void select4() {
        this.selectNum(4);
    }

    public void select5() {
        this.selectNum(5);
    }

    public void select6() {
        this.selectNum(6);
    }

    public void select7() {
        this.selectNum(7);
    }

    public void select8() {
        this.selectNum(8);
    }

    public void select9() {
        this.selectNum(9);
    }

    public void selectBack() {
        if (this.phone_customer.getText().length() >= 1) {
            this.phone_customer.setText(this.phone_customer.getText().substring(0, this.phone_customer.getText().length() - 1));
        }
    }

    private void checkCodeLoyaltyCard() {
        LoyaltyCardInfo loyaltyCard = this.mLoyaltyCardService.getLoyaltyCardByBarCode(this.text_loyalty_card.getText());
        if (loyaltyCard != null) {
            this.customer = loyaltyCard.getCustomer();
            this.customer.setLoyaltyCardCollection(this.mLoyaltyCardService.findByCustomer(this.customer.getId()));
            this.closeStage();
        } else {
            this.loadPaneLoyaltyCard();
        }
    }

    private void loadPaneLoyaltyCard() {
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.pane_add_customer, 0, 0);
        this.pane_scan_displayed = false;
        this.button.setText(AppLocal.getIntString("Button.valid"));
    }

    public void valid() {
        boolean valid = true;
        try {
            if (!this.pane_scan_displayed) {
                if (this.phone_customer.getText().length() == 10) {
                    this.customer = this.mCustomerService.getCustomerWithCards(this.phone_customer.getText());
                    if (this.customer != null && this.customer.getLoyaltyCardCollection() != null && !this.customer.getLoyaltyCardCollection().isEmpty()) {
                        new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Ce client a d\u00e9j\u00e0 une carte de fid\u00e9lit\u00e9.", 1500, NPosition.BOTTOM_RIGHT);
                        valid = false;
                    } else {
                        LoyaltyCardInfo mLoyaltyCardInfo = new LoyaltyCardInfo(this.text_loyalty_card.getText());
                        this.customer = this.mCustomerService.saveWithLoyaltyCard(this.phone_customer.getText(), mLoyaltyCardInfo);
                    }
                } else {
                    new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Le num\u00e9ro t\u00e9l\u00e9phone do\u00eet contenir 10 chiffres.", 1500, NPosition.BOTTOM_RIGHT);
                }
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        if (valid) {
            this.closeStage();
        } else {
            this.customer = null;
            this.loadPaneScanCard();
            this.text_loyalty_card.setText("");
            this.text_loyalty_card.requestFocus();
        }
    }

    public CustomerInfo getCustomer() {
        return this.customer;
    }

    private void closeStage() {
        this.stage.close();
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.intializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.intializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        this.intializer();
    }

    private void loadPaneScanCard() {
        this.pane_scan_displayed = true;
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.pane_scan, 0, 0);
        this.button.setText(AppLocal.getIntString("Label.next"));
    }
}

