/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.controllers.CaisseFermeController;
import com.openbravo.controllers.RootAppController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppUser;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.BackupService;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.ColorInput;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Paint;
import javafx.stage.DirectoryChooser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoginController {
    private static Log logger = LogFactory.getFactory().getInstance(LoginController.class);
    private JRootApp app;
    @FXML
    private Label labelPassword;
    @FXML
    private Label labelPassword_borne;
    @FXML
    Button btn_back;
    @FXML
    Button btn_back_borne;
    @FXML
    Button btn_paste_password_borne;
    @FXML
    Button btn_paste_password;
    @FXML
    Button btn_finger;
    @FXML
    TextField text_finger_print;
    @FXML
    ImageView logo_norme;
    @FXML
    Label licence;
    @FXML
    Label version_app;
    @FXML
    Label num_support;
    @FXML
    Label codeLoginLabel;
    @FXML
    GridPane pane_fingerprint;
    @FXML
    GridPane ClavierPanel;
    @FXML
    Label CodeLoginLabel;
    @FXML
    Label CodeLoginLabel_borne;
    @FXML
    GridPane keyborad_pane;
    @FXML
    GridPane pane_norme;
    @FXML
    GridPane pane_root;
    @FXML
    GridPane centre_pane;
    @FXML
    Label bottom_label;
    @FXML
    FlowPane top_login;
    @FXML
    GridPane top_pane_main;
    @FXML
    GridPane left_pane;
    @FXML
    GridPane versionPane;
    @FXML
    GridPane right_pane;
    @FXML
    GridPane top_login_pane;
    @FXML
    StackPane login_pane;
    @FXML
    Button btn_delete;
    @FXML
    BorderPane border_pane;
    @FXML
    Button btn0;
    @FXML
    Button btn1;
    @FXML
    Button btn2;
    @FXML
    Button btn3;
    @FXML
    Button btn4;
    @FXML
    Button btn5;
    @FXML
    Button btn6;
    @FXML
    Button btn7;
    @FXML
    Button btn8;
    @FXML
    Button btn9;
    @FXML
    Button btn_ok;
    private String password = "";
    private int role;
    private Scene scene;
    private boolean finger_print;
    private final String DEFUALT_PASSWORD_USER_MAINTAIN = "123888";
    private final String URI_FXML_ERROR_CAISSE = "/fxml/error_caisse.fxml";
    private String MSG_ERROR_PASSWORD;
    private String colorCaisse;
    GridPane version_pane = new GridPane();

    public void initComponents(JRootApp app) {
        try {
            this.MSG_ERROR_PASSWORD = AppLocal.getIntString("Message.incorrect.password");
            this.app = app;
            Image imageFinger = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/finger_printer-login.png"));
            ImageView iconFinger = new ImageView(imageFinger);
            iconFinger.setFitWidth(50.0);
            iconFinger.setFitHeight(50.0);
            iconFinger.setSmooth(true);
            iconFinger.setPreserveRatio(true);
            if (AppLocal.modeCaisse != null && !AppLocal.modeCaisse.equals("Caisse") && !AppLocal.modeCaisse.isEmpty()) {
                this.pane_root.getChildren().clear();
                this.pane_root.setStyle("-fx-background-color: #9B9B9B;");
                this.pane_root.add((Node)this.border_pane, 0, 0);
                Image image = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/go_back_xhdpi.png"));
                this.btn_back_borne.setGraphic((Node)new ImageView(image));
                this.labelPassword_borne.setStyle("-fx-background-color: #ebeff2;");
                this.addInfoNorme();
            } else {
                this.pane_root.getChildren().clear();
                Image img = new Image(this.getClass().getResource("/com/openbravo/images/login_background.png").toURI().toString(), AppVarUtils.getScreenDimension().getWidth() * 0.7, AppVarUtils.getScreenDimension().getHeight(), false, false);
                Image img_delete = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/delete_char.png"));
                BackgroundImage bImg = new BackgroundImage(img, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.DEFAULT, BackgroundSize.DEFAULT);
                Background bGround = new Background(new BackgroundImage[]{bImg});
                double width = AppVarUtils.getScreenDimension().getWidth() * 0.7;
                double with_info = AppVarUtils.getScreenDimension().getWidth() * 0.3;
                this.login_pane.setPrefWidth(width);
                this.login_pane.setPrefHeight(AppVarUtils.getScreenDimension().getHeight());
                this.login_pane.setBackground(bGround);
                this.left_pane.setPrefWidth(with_info);
                this.right_pane.setPrefHeight(AppVarUtils.getScreenDimension().getHeight() * 0.8);
                this.versionPane.setPrefWidth(with_info);
                this.version_pane.setPrefWidth(with_info);
                this.version_pane.setPrefHeight(AppVarUtils.getScreenDimension().getHeight() * 0.005);
                this.version_pane.setPrefWidth(with_info);
                this.version_pane.setPrefHeight(AppVarUtils.getScreenDimension().getHeight() * 0.005);
                Label biborne_name = new Label("BIBORNE |");
                biborne_name.setPrefWidth(this.version_pane.getPrefWidth() * 0.42);
                biborne_name.getStyleClass().add((Object)"softwareLabel");
                Label version_app = new Label(" Version 10.0.1.27");
                biborne_name.setAlignment(Pos.TOP_LEFT);
                version_app.setAlignment(Pos.TOP_LEFT);
                version_app.setPrefWidth(this.version_pane.getPrefWidth() * 0.5);
                version_app.getStyleClass().add((Object)"version_app");
                this.version_pane.add((Node)biborne_name, 0, 0);
                this.version_pane.add((Node)version_app, 1, 0);
                this.version_pane.setHgap(5.0);
                this.versionPane.add((Node)this.version_pane, 0, 0);
                Image image = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/back-arrow.png"));
                this.btn_back.setGraphic((Node)new ImageView(image));
                this.pane_root.add((Node)this.centre_pane, 0, 0);
                this.initColorCaisse();
            }
            this.codeLoginLabel.setText(AppLocal.getIntString("Text.password"));
            this.btn_paste_password.setOnAction(e -> this.pasteClipboard(true));
            this.btn_paste_password_borne.setOnAction(e -> this.pasteClipboard(false));
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void init(int role, Scene scene) {
        this.role = role;
        this.scene = scene;
        if (AppLocal.modeCaisse != null && !AppLocal.modeCaisse.equals("Caisse") && !AppLocal.modeCaisse.isEmpty()) {
            this.labelPassword_borne.setText("");
        } else {
            this.labelPassword.setText("");
        }
        this.password = "";
        if (this.finger_print) {
            this.clickTextFinger();
        }
    }

    @FXML
    private void writeNumber(ActionEvent actionEvent) {
        if (AppLocal.modeCaisse != null && !AppLocal.modeCaisse.equals("Caisse") && !AppLocal.modeCaisse.isEmpty()) {
            if (this.password.length() < 7) {
                this.labelPassword_borne.setText(this.labelPassword_borne.getText() + "*");
                this.password = this.password + ((Button)actionEvent.getSource()).getText();
            }
        } else if (this.password.length() < 7) {
            this.labelPassword.setText(this.labelPassword.getText() + "*");
            this.password = this.password + ((Button)actionEvent.getSource()).getText();
        }
    }

    @FXML
    private void deleteNumber(ActionEvent actionEvent) {
        if (AppLocal.modeCaisse != null && !AppLocal.modeCaisse.equals("Caisse") && !AppLocal.modeCaisse.isEmpty()) {
            if (this.labelPassword_borne.getText().length() > 0) {
                this.labelPassword_borne.setText(this.labelPassword_borne.getText().substring(0, this.labelPassword_borne.getText().length() - 1));
                this.password = this.password.substring(0, this.password.length() - 1);
            }
        } else if (this.labelPassword.getText().length() > 0) {
            this.labelPassword.setText(this.labelPassword.getText().substring(0, this.labelPassword.getText().length() - 1));
            this.password = this.password.substring(0, this.password.length() - 1);
        }
    }

    @FXML
    private void login(ActionEvent actionEvent) {
        if (AppLocal.modeCaisse != null && !AppLocal.modeCaisse.equals("Caisse") && !AppLocal.modeCaisse.isEmpty()) {
            this.loginUser(false, this.labelPassword_borne);
        } else {
            this.loginUser(false, this.labelPassword);
        }
    }

    private void loginUser(boolean fingerPrint, Label labelpass) {
        if (!fingerPrint && labelpass.getText().length() >= 0 || fingerPrint && !this.text_finger_print.getText().isEmpty()) {
            try {
                AppUser user = null;
                if (!fingerPrint) {
                    System.out.println("++++++++++++AppVarUtils.generatorDailyCode() " + AppVarUtils.generatorDailyCode());
                    if (!this.password.equals("123888") && AppVarUtils.generatorDailyCode().equals(this.password)) {
                        user = this.app.login("123888", false);
                    } else if (AppLocal.modeCaisse == null || !AppLocal.modeCaisse.equals("Borne")) {
                        user = this.app.login(this.password, false);
                    }
                }
                if (user != null) {
                    AppLocal.reload_permission = true;
                    AppLocal.user = user;
                    CaisseInfo caisse = this.app.getCaisse();
                    Date today = new Date();
                    this.rappelBackupUSB(user.getRole().equals("1"));
                    System.out.println("***!app.getM_dlItems().isClotured(\"j\", today) && caisse.isOuverte())" + (!this.app.getM_dlItems().isClotured("j", today) && caisse.isOuverte() != false));
                    if (!this.app.getM_dlItems().isClotured("j", today) && caisse.isOuverte().booleanValue() || this.role == 1) {
                        System.out.println("*******role :  " + this.role);
                        if (this.role != 1 || !user.getRole().equals("2")) {
                            this.app.openAppView(user, this.role, true);
                            AppLocal.changeUser = true;
                            this.app.getFxPanel().setScene(this.app.getCurrentScene());
                        }
                    } else if (!(this.app.getM_dlItems().isClotured("j", today) || this.app.getM_dlItems().isClotured("m", today) || this.app.getM_dlItems().isClotured("a", today))) {
                        FXMLLoader loaderLogin = new FXMLLoader(this.getClass().getResource("/fxml/error_caisse.fxml"));
                        Parent rootNodeLogin = (Parent)loaderLogin.load();
                        Scene sceneCaisse = new Scene(rootNodeLogin, AppVarUtils.getScreenDimension().getWidth(), AppVarUtils.getScreenDimension().getHeight());
                        sceneCaisse.getStylesheets().add((Object)"/styles/styles.css");
                        CaisseFermeController controller = (CaisseFermeController)loaderLogin.getController();
                        controller.init(this.role, this.app, user, sceneCaisse);
                        this.app.getFxPanel().setScene(sceneCaisse);
                    } else {
                        new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.period.closed"), 4000, NPosition.CENTER);
                        this.back();
                    }
                } else {
                    new NotifyWindow(NotifyType.WARNING_NOTIFICATION, this.MSG_ERROR_PASSWORD, 1500, NPosition.TOP_CENTER_FULL, (int)AppVarUtils.getScreenDimension().getWidth(), 70);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void back() {
        this.app.getFxPanel().setScene(this.scene);
    }

    public void clickTextFinger() {
    }

    private void rappelBackupUSB(boolean b) {
        if (AppLocal.isBackupRecomended.booleanValue() && this.role == 1 && b) {
            if (this.doesWantBackup()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DirectoryChooser chooser = new DirectoryChooser();
                        chooser.setInitialDirectory(new File("."));
                        chooser.setTitle("Disque externe des backups");
                        File selectedFile = chooser.showDialog(LoginController.this.scene.getWindow());
                        if (selectedFile != null) {
                            try {
                                new BackupService().doBackup(selectedFile);
                                AppLocal.isBackupRecomended = false;
                            }
                            catch (IOException ex) {
                                Logger.getLogger(RootAppController.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                });
            } else {
                logger.info((Object)"No Selection ");
            }
        }
    }

    private boolean doesWantBackup() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Sauvegarde externe");
        alert.setHeaderText(null);
        alert.setContentText("Voulez vous faire une sauvegarde externe ? \nS\u00e9lectionner votre choix.");
        ButtonType buttonTypeOne = new ButtonType("Oui, Sauvegarder");
        ButtonType buttonTypeCancel = new ButtonType("Non, Plus Tard", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonTypeOne, buttonTypeCancel});
        Optional result = alert.showAndWait();
        return result.get() == buttonTypeOne;
    }

    private void addInfoNorme() throws URISyntaxException {
        double heightImageNorme = AppVarUtils.getScreenDimension().getHeight() * 0.25;
        this.licence.setText(AppLocal.getIntString("Label.num.licence") + " : " + String.valueOf(AppLocal.getLicenceId()));
        this.version_app.setText("Version : 10.0.1.27");
        this.num_support.setText(AppLocal.getIntString("Label.telephone.assistance") + " : 09 72 66 38 73");
        Image image_logo = new Image(this.getClass().getResource("/com/openbravo/images/logo_certificat.png").toURI().toString());
        this.logo_norme.setImage(image_logo);
        this.logo_norme.setFitHeight(heightImageNorme);
        this.logo_norme.setPreserveRatio(true);
        this.logo_norme.setSmooth(true);
    }

    public void initColorCaisse() {
        if (AppLocal.color_borne != null && !AppLocal.color_borne.isEmpty()) {
            Color rbgColor = ColorUtils.getColorByString(AppLocal.color_borne);
            this.colorCaisse = String.format("#%02x%02x%02x", rbgColor.getRed(), rbgColor.getGreen(), rbgColor.getBlue());
        } else {
            this.colorCaisse = "#FF5E00";
        }
        String styleCaisse = " -fx-background-color: " + this.colorCaisse + ";";
        this.pane_root.setStyle(styleCaisse);
        this.centre_pane.setStyle(styleCaisse);
        this.left_pane.setStyle(styleCaisse);
        this.versionPane.setStyle(styleCaisse);
        this.top_login_pane.setStyle(styleCaisse);
        this.codeLoginLabel.setStyle("-fx-font-family: Poppins, Helvetica, Arial, sans-serif;-fx-font-size: 27px;-fx-text-fill: " + this.colorCaisse + ";-fx-font-weight: bold;-fx-font-style: normal;");
        this.changeButtonStyle(this.btn0, this.colorCaisse);
        this.changeButtonStyle(this.btn1, this.colorCaisse);
        this.changeButtonStyle(this.btn2, this.colorCaisse);
        this.changeButtonStyle(this.btn3, this.colorCaisse);
        this.changeButtonStyle(this.btn4, this.colorCaisse);
        this.changeButtonStyle(this.btn5, this.colorCaisse);
        this.changeButtonStyle(this.btn6, this.colorCaisse);
        this.changeButtonStyle(this.btn7, this.colorCaisse);
        this.changeButtonStyle(this.btn8, this.colorCaisse);
        this.changeButtonStyle(this.btn9, this.colorCaisse);
        this.changeButtonStyle(this.btn_delete, this.colorCaisse);
        this.changeButtonStyle(this.btn_paste_password, this.colorCaisse);
        this.version_pane.setStyle(styleCaisse);
        this.changeButtonStyleConnect(this.btn_ok, this.colorCaisse);
        this.labelPassword.setStyle(" -fx-text-fill: " + this.colorCaisse + ";    -fx-background-color :#FFFFFF;    -fx-font-weight: bold;    -fx-font-size: 25px;   -fx-background-radius: 50px;   -fx-border-radius: 50px;   -fx-hgap: 20px;   -fx-padding: 15px;   -fx-font-style: italic;    -fx-effect: dropshadow(three-pass-box, #CCCCCD, 10, 0, 0, 0);");
    }

    public void changeButtonStyle(Button btn, String color) {
        String IDLE_BUTTON_STYLE_KEY = " -fx-font-family: Poppins, Helvetica, Arial, sans-serif;    -fx-font-weight:bold;    -fx-font-size: 26px;    -fx-hgap: 20px;    -fx-background-radius: 16px;    -fx-border-radius: 16px;    -fx-border-width: 2px;    -fx-border-color:" + color + ";    -fx-text-fill:" + color + ";    -fx-background-color:  #FFFFFF;    -fx-pref-height: 70px;    -fx-pref-width: 70px;";
        String HOVERED_BUTTON_STYLE = " -fx-font-family: Poppins, Helvetica, Arial, sans-serif;    -fx-font-weight: bold;    -fx-font-size: 26px;    -fx-hgap: 20px;    -fx-background-radius: 16px;    -fx-border-radius: 16px;    -fx-border-width: 2px;    -fx-text-fill: #FFFFFF;    -fx-pref-height: 70px;    -fx-pref-width: 70px;    -fx-background-color:  " + color + ";    -fx-border-color: " + color + ";";
        btn.setStyle(IDLE_BUTTON_STYLE_KEY);
        btn.setOnMouseEntered(e -> btn.setStyle(HOVERED_BUTTON_STYLE));
        btn.setOnMouseExited(e -> btn.setStyle(IDLE_BUTTON_STYLE_KEY));
    }

    public void changeButtonStyleConnect(Button btn, String color) {
        String IDLE_BUTTON_STYLE = " -fx-font-family: Poppins, Helvetica, Arial, sans-serif;    -fx-font-weight: bold;    -fx-font-size: 24px;    -fx-hgap: 20px;    -fx-background-color: #FFFFFF;    -fx-background-radius: 16px;    -fx-border-radius: 16px;    -fx-border-width: 3px;    -fx-border-color: " + color + ";    -fx-text-fill:" + color + ";";
        String HOVERED_BUTTON_STYLE = " -fx-font-family: Poppins, Helvetica, Arial, sans-serif;    -fx-font-weight: bold;    -fx-font-size: 24px;    -fx-hgap: 20px;    -fx-background-color:  " + color + ";    -fx-background-radius: 16px;    -fx-border-radius: 16px;    -fx-border-width: 3px;    -fx-border-color: " + color + ";    -fx-text-fill: #FFFFFF;";
        btn.setStyle(IDLE_BUTTON_STYLE);
        btn.setOnMouseEntered(e -> btn.setStyle(HOVERED_BUTTON_STYLE));
        btn.setOnMouseExited(e -> btn.setStyle(IDLE_BUTTON_STYLE));
    }

    public ImageView changeImageColor(Image image) {
        ImageView imageView = new ImageView(image);
        imageView.setClip((Node)new ImageView(image));
        ColorAdjust monochrome = new ColorAdjust();
        monochrome.setSaturation(-1.0);
        javafx.scene.paint.Color blue = javafx.scene.paint.Color.RED;
        Blend blush = new Blend(BlendMode.MULTIPLY, (Effect)monochrome, (Effect)new ColorInput(0.0, 0.0, imageView.getImage().getWidth(), imageView.getImage().getHeight(), (Paint)blue));
        imageView.effectProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)imageView.hoverProperty()).then((Object)blush).otherwise((Object)null));
        imageView.setCache(true);
        imageView.setCacheHint(CacheHint.SPEED);
        return imageView;
    }

    public void pasteClipboard(boolean forCaisse) {
        String code = this.getParsedClipbaordContent();
        if (code == null) {
            return;
        }
        this.password = code;
        if (forCaisse) {
            this.labelPassword.setText(code.chars().mapToObj(c -> "*").reduce("", (prev, curr) -> prev + curr, String::concat));
        } else {
            this.labelPassword_borne.setText(code.chars().mapToObj(c -> "*").reduce("", (prev, curr) -> prev + curr, String::concat));
        }
        Clipboard.getSystemClipboard().clear();
    }

    public String getParsedClipbaordContent() {
        try {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            if (clipboard.hasString()) {
                String code = String.valueOf(Integer.parseInt(clipboard.getString()));
                return code.length() > 7 ? code.substring(0, 7) : code;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }
}

