/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.LazyModal;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.CitiesDeliveryController;
import com.openbravo.controllers.GeoController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.CityInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.services.AddressService;
import fr.protactile.procaisse.services.CityService;
import fr.protactile.procaisse.services.CustomerService;
import java.awt.Dimension;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import se.walkercrou.places.Place;

public class LivraisonController {
    @FXML
    TextField name_customer;
    @FXML
    Label label_name;
    @FXML
    TextField phone;
    @FXML
    TextField nom_client;
    @FXML
    GridPane main_pane;
    @FXML
    FlowPane pane_message;
    @FXML
    ScrollPane scroll_client;
    @FXML
    FlowPane button_clients;
    @FXML
    BorderPane new_address_pane;
    @FXML
    BorderPane new_client_pane;
    @FXML
    TextField new_client;
    @FXML
    TextField addresslv;
    @FXML
    TextField zipCodelv;
    @FXML
    TextField citylv;
    @FXML
    TextField codeEntreelv;
    @FXML
    TextField interphonelv;
    @FXML
    TextField batimentlv;
    @FXML
    Button btn_geo;
    @FXML
    Button btn_geo_new;
    @FXML
    TextField escalierlv;
    @FXML
    TextField etagelv;
    @FXML
    TextField appartementlv;
    @FXML
    TextField societelv;
    @FXML
    TextField address;
    @FXML
    TextField zipCode;
    @FXML
    TextField city;
    @FXML
    TextField codeEntree;
    @FXML
    TextField interphone;
    @FXML
    TextField batiment;
    @FXML
    TextField escalier;
    @FXML
    TextField etage;
    @FXML
    TextField appartement;
    @FXML
    TextField societe;
    @FXML
    FlowPane pane_name_fx;
    @FXML
    Label label_name_customer;
    @FXML
    Button btn_filter_name_client;
    @FXML
    TextField prefix_phone_text;
    @FXML
    Label label_search_by_num;
    @FXML
    Label label_search_by_name;
    @FXML
    Label label_message;
    @FXML
    Label label_prefix_phone;
    @FXML
    Button btn_valid;
    @FXML
    Label label_name_new_customer;
    @FXML
    Button btn_add_address;
    @FXML
    Button btn_add_client;
    private AppView m_App;
    private boolean newAddress;
    private int filter_number;
    private AddressInfo oldAddress;
    private CustomerInfo currentCustomer;
    private List<CustomerInfo> listCustomersFilter;
    private Place placeCurrent;
    private Scene scene;
    private boolean showEspaceClient;
    private AddressService mAddressService = AddressService.getInstance();
    private CustomerService mCustomerService = CustomerService.getInstance();
    private CityService mCityService = CityService.getInstance();
    private EventHiddenModal mActionEventCitiesDelivery = null;
    private LazyModal mLazyModalCitiesDelivery = null;
    private final String citiesDeliveryFxml = "/fxml/CitiesDelivery.fxml";

    public void init(AppView app, Scene scene) {
        this.newAddress = true;
        this.m_App = app;
        this.currentCustomer = null;
        this.scene = scene;
        this.placeCurrent = new Place();
        this.showEspaceClient = false;
        this.filter_number = AppLocal.FILTER_NUMBER != null && !AppLocal.FILTER_NUMBER.isEmpty() ? Integer.parseInt(AppLocal.FILTER_NUMBER) : 4;
        Image imagegeo = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/geo.png"));
        this.btn_geo.setGraphic((Node)new ImageView(imagegeo));
        Image imagegeoNew = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/geo.png"));
        this.btn_geo_new.setGraphic((Node)new ImageView(imagegeoNew));
        Image imagegeoFilter = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/filter_icon.png"));
        this.btn_filter_name_client.setGraphic((Node)new ImageView(imagegeoFilter));
        this.listCustomersFilter = new ArrayList<CustomerInfo>();
        this.nom_client.getProperties().put((Object)"vkType", (Object)5);
        this.nom_client.getProperties().put((Object)"vkSize", (Object)2);
        this.address.getProperties().put((Object)"vkSize", (Object)2);
        this.zipCode.getProperties().put((Object)"vkSize", (Object)2);
        this.city.getProperties().put((Object)"vkSize", (Object)2);
        this.codeEntree.getProperties().put((Object)"vkSize", (Object)2);
        this.interphone.getProperties().put((Object)"vkSize", (Object)2);
        this.batiment.getProperties().put((Object)"vkSize", (Object)2);
        this.escalier.getProperties().put((Object)"vkSize", (Object)2);
        this.etage.getProperties().put((Object)"vkSize", (Object)2);
        this.appartement.getProperties().put((Object)"vkSize", (Object)2);
        this.societe.getProperties().put((Object)"vkSize", (Object)2);
        this.new_client.getProperties().put((Object)"vkSize", (Object)2);
        this.addresslv.getProperties().put((Object)"vkSize", (Object)2);
        this.zipCodelv.getProperties().put((Object)"vkSize", (Object)2);
        this.citylv.getProperties().put((Object)"vkSize", (Object)2);
        this.codeEntreelv.getProperties().put((Object)"vkSize", (Object)2);
        this.interphonelv.getProperties().put((Object)"vkSize", (Object)2);
        this.batimentlv.getProperties().put((Object)"vkSize", (Object)2);
        this.escalierlv.getProperties().put((Object)"vkSize", (Object)2);
        this.etagelv.getProperties().put((Object)"vkSize", (Object)2);
        this.appartementlv.getProperties().put((Object)"vkSize", (Object)2);
        this.societelv.getProperties().put((Object)"vkSize", (Object)2);
        this.phone.getProperties().put((Object)"vkSize", (Object)2);
        this.new_client.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    LivraisonController.this.btn_geo_new.fire();
                }
            }
        });
        this.phone.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.ENTER) {
                    if (LivraisonController.this.phone.getText().length() == 10) {
                        LivraisonController.this.new_client.requestFocus();
                    }
                } else {
                    if (LivraisonController.this.phone.getText().length() > 10) {
                        String s = LivraisonController.this.phone.getText().substring(0, 10);
                        LivraisonController.this.phone.setText(s);
                        LivraisonController.this.phone.positionCaret(LivraisonController.this.phone.getText().length());
                    }
                    LivraisonController.this.searchByPhone();
                }
            }
        });
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.pane_message, 0, 0);
        this.zipCode.setOnKeyReleased(event -> {
            if (this.zipCode.getText().length() >= 5) {
                this.findCityByZipCode(this.zipCode.getText(), false);
            }
        });
        this.zipCodelv.setOnKeyReleased(event -> {
            if (this.zipCodelv.getText().length() >= 5) {
                this.findCityByZipCode(this.zipCodelv.getText(), true);
            }
        });
        this.setTexts();
    }

    public void findCityByZipCode(String zip_code, boolean new_customer) {
        List<CityInfo> citiesDelivery = this.mCityService.findByName(zip_code);
        if (citiesDelivery != null && !citiesDelivery.isEmpty()) {
            if (citiesDelivery.size() == 1) {
                CityInfo cityDelivery = citiesDelivery.get(0);
                if (cityDelivery != null) {
                    if (new_customer) {
                        this.citylv.setText(cityDelivery.getName().toUpperCase());
                    } else {
                        this.city.setText(cityDelivery.getName().toUpperCase());
                    }
                }
            } else {
                this.loadPopUpCities(citiesDelivery, new_customer);
            }
        }
    }

    public void loadOldAdress() {
        this.newAddress = false;
        this.oldAddress = AppLocal.oldAddress;
        this.currentCustomer = AppLocal.customer_to_change;
        this.loadEspaceAddress();
    }

    public void getGeo() {
        try {
            String fxmlFile = "/fxml/geolocalisation.fxml";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
            Parent rootNode = (Parent)loader.load();
            final GeoController controller = (GeoController)loader.getController();
            Scene scenePop = new Scene(rootNode, 600.0, 400.0);
            scenePop.getStylesheets().add((Object)"/styles/styles.css");
            Stage modalStage = new Stage();
            modalStage.setScene(scenePop);
            modalStage.initOwner(this.scene.getWindow());
            modalStage.initModality(Modality.APPLICATION_MODAL);
            modalStage.initStyle(StageStyle.UTILITY);
            modalStage.setAlwaysOnTop(true);
            controller.init(modalStage);
            modalStage.show();
            modalStage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Object[] result = controller.getResult();
                    if (((Boolean)result[1]).booleanValue()) {
                        LivraisonController.this.placeCurrent = (Place)result[0];
                        if (LivraisonController.this.placeCurrent != null && LivraisonController.this.placeCurrent.getAddress() != null) {
                            if (LivraisonController.this.placeCurrent.getVicinity() != null) {
                                LivraisonController.this.city.setText(LivraisonController.this.placeCurrent.getVicinity());
                            }
                            if (!"".equals(LivraisonController.this.placeCurrent.getZipCode())) {
                                LivraisonController.this.zipCode.setText(LivraisonController.this.placeCurrent.getZipCode());
                            }
                            LivraisonController.this.address.setText(LivraisonController.this.placeCurrent.getAddress());
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void getGeoNew() {
        try {
            String fxmlFile = "/fxml/geolocalisation.fxml";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
            Parent rootNode = (Parent)loader.load();
            final GeoController controller = (GeoController)loader.getController();
            Scene scenePop = new Scene(rootNode, 600.0, 400.0);
            scenePop.getStylesheets().add((Object)"/styles/styles.css");
            Stage modalStage = new Stage();
            modalStage.setScene(scenePop);
            modalStage.initOwner(this.scene.getWindow());
            modalStage.initModality(Modality.APPLICATION_MODAL);
            modalStage.initStyle(StageStyle.UTILITY);
            modalStage.setAlwaysOnTop(true);
            controller.init(modalStage);
            modalStage.show();
            modalStage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    Object[] result = controller.getResult();
                    if (((Boolean)result[1]).booleanValue()) {
                        LivraisonController.this.placeCurrent = (Place)result[0];
                        if (LivraisonController.this.placeCurrent != null) {
                            if (LivraisonController.this.placeCurrent.getAddress() != null) {
                                if (LivraisonController.this.placeCurrent.getVicinity() != null) {
                                    LivraisonController.this.citylv.setText(LivraisonController.this.placeCurrent.getVicinity());
                                }
                                if (!"".equals(LivraisonController.this.placeCurrent.getZipCode())) {
                                    LivraisonController.this.zipCodelv.setText(LivraisonController.this.placeCurrent.getZipCode());
                                }
                                Object addressString = "";
                                if (!"".equals(LivraisonController.this.placeCurrent.getStreet())) {
                                    addressString = (String)addressString + LivraisonController.this.placeCurrent.getStreet() + " ";
                                }
                                if (!"".equals(LivraisonController.this.placeCurrent.getRoute())) {
                                    addressString = (String)addressString + LivraisonController.this.placeCurrent.getRoute();
                                }
                                LivraisonController.this.addresslv.setText((String)addressString);
                            }
                            LivraisonController.this.main_pane.requestFocus();
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void searchByPhone() {
        if (!this.showEspaceClient) {
            this.listCustomersFilter.clear();
            try {
                if (this.phone != null && !this.phone.getText().isEmpty() && this.phone.getText().length() >= this.filter_number) {
                    this.listCustomersFilter = this.mCustomerService.filterByPhoneOrName(this.phone.getText(), this.nom_client.getText());
                    if (this.listCustomersFilter.size() > 0) {
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.scroll_client, 0, 0);
                        this.loadClient();
                    } else if (this.phone.getText().length() == 10) {
                        this.showEspaceClient = true;
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.new_client_pane, 0, 0);
                    } else {
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.pane_message, 0, 0);
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void searchByNom() {
        block6: {
            if (!this.showEspaceClient) {
                this.listCustomersFilter.clear();
                if (!this.nom_client.getText().isEmpty()) {
                    try {
                        this.listCustomersFilter = this.mCustomerService.filterByPhoneOrName(this.phone.getText(), this.nom_client.getText());
                        if (this.listCustomersFilter.size() > 0) {
                            this.main_pane.getChildren().clear();
                            this.main_pane.add((Node)this.scroll_client, 0, 0);
                            this.loadClient();
                            break block6;
                        }
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.pane_message, 0, 0);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                } else {
                    this.main_pane.getChildren().clear();
                    this.main_pane.add((Node)this.pane_message, 0, 0);
                }
            }
        }
    }

    public void loadClient() {
        this.button_clients.getChildren().clear();
        for (final CustomerInfo customer : this.listCustomersFilter) {
            FlowPane pane_client = new FlowPane();
            pane_client.setVgap(2.0);
            pane_client.setHgap(2.0);
            pane_client.setPrefWidth(200.0);
            pane_client.getStyleClass().add((Object)"btn_client");
            int nbAdresses = customer.getAdresseInfoCollection().size();
            pane_client.setPrefHeight((double)(nbAdresses * 70 + 50));
            GridPane pane_name = new GridPane();
            pane_name.setPrefWidth(200.0);
            pane_name.setPrefHeight(70.0);
            pane_name.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
            Label nameClient = new Label(customer.getName());
            Label phoneClient = new Label(customer.printPhone());
            nameClient.setPrefHeight(70.0);
            phoneClient.setAlignment(Pos.CENTER);
            nameClient.setAlignment(Pos.CENTER);
            nameClient.setPrefWidth(100.0);
            phoneClient.setPrefHeight(70.0);
            phoneClient.setPrefWidth(100.0);
            pane_name.add((Node)nameClient, 0, 0);
            pane_name.add((Node)phoneClient, 1, 0);
            pane_client.getChildren().add((Object)pane_name);
            for (final AddressInfo addresse : customer.getAdresseInfoCollection()) {
                Button btn_address = new Button(addresse.getAddress() + ", " + addresse.getCity());
                btn_address.setPrefHeight(70.0);
                btn_address.setPrefWidth(200.0);
                btn_address.getStyleClass().add((Object)"btn_address");
                btn_address.setWrapText(true);
                btn_address.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        LivraisonController.this.main_pane.requestFocus();
                        AppLocal.Address_ID = addresse.getId();
                        AppLocal.Client_ID = customer.getId();
                        AppLocal.demandeLivraison = true;
                        AppLocal.changeAddress = false;
                        AppLocal.oldAddress = null;
                        AppLocal.customer_to_change = null;
                        LivraisonController.this.m_App.getAppUserView().showTask("com.openbravo.pos.sales.JCaissePanel");
                        AppLocal.view_back = AppLocal.view_current;
                        AppLocal.view_current = "com.openbravo.pos.sales.JCaissePanel";
                        LivraisonController.this.initialize();
                    }
                });
                pane_client.getChildren().add((Object)btn_address);
            }
            Button btn_new_address = new Button("Nouvelle Adresse");
            btn_new_address.setPrefHeight(50.0);
            btn_new_address.setPrefWidth(200.0);
            btn_new_address.getStyleClass().add((Object)"btn_new_address");
            btn_new_address.setWrapText(true);
            btn_new_address.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    LivraisonController.this.currentCustomer = customer;
                    LivraisonController.this.loadEspaceAddress();
                }
            });
            pane_client.getChildren().add((Object)btn_new_address);
            this.button_clients.getChildren().add((Object)pane_client);
        }
    }

    public void phone7() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "7");
            this.searchByPhone();
        }
    }

    public void phone8() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "8");
            this.searchByPhone();
        }
    }

    public void phone9() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "9");
            this.searchByPhone();
        }
    }

    public void phone6() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "6");
            this.searchByPhone();
        }
    }

    public void phone5() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "5");
            this.searchByPhone();
        }
    }

    public void phone4() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "4");
            this.searchByPhone();
        }
    }

    public void phone3() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "3");
            this.searchByPhone();
        }
    }

    public void phone2() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "2");
            this.searchByPhone();
        }
    }

    public void phone1() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "1");
            this.searchByPhone();
        }
    }

    public void phone0() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "0");
            this.searchByPhone();
        }
    }

    public void phoneClear() {
        if (this.phone.getText().length() >= 1) {
            this.phone.setText(this.phone.getText().substring(0, this.phone.getText().length() - 1));
            this.searchByPhone();
        }
    }

    public void loadEspaceAddress() {
        this.showEspaceClient = true;
        if (!this.newAddress) {
            this.pane_name_fx.getChildren().clear();
            this.pane_name_fx.getChildren().add((Object)this.label_name_customer);
            this.pane_name_fx.getChildren().add((Object)this.name_customer);
            this.name_customer.setText(this.currentCustomer.getName());
            this.phone.setText(this.currentCustomer.getPhone());
            this.loadInfoOldAdress();
        } else {
            this.pane_name_fx.getChildren().clear();
            this.pane_name_fx.getChildren().add((Object)this.label_name);
            this.label_name.setText(this.currentCustomer.getName());
        }
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.new_address_pane, 0, 0);
    }

    private void loadInfoOldAdress() {
        if (this.oldAddress != null) {
            this.address.setText(this.oldAddress.getAddress());
            this.appartement.setText(this.oldAddress.getAppartement());
            this.batiment.setText(this.oldAddress.getBatiment());
            this.city.setText(this.oldAddress.getCity());
            this.codeEntree.setText(this.oldAddress.getEntrycode());
            this.escalier.setText(this.oldAddress.getEscalier());
            this.etage.setText(this.oldAddress.getEtage());
            this.interphone.setText(this.oldAddress.getInterphone());
            this.societe.setText(this.oldAddress.getSociete());
            this.zipCode.setText(this.oldAddress.getZipcode());
        }
    }

    public void filterClientName() {
        this.searchByNom();
    }

    public void loadEspaceClient() {
        this.showEspaceClient = true;
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.new_client_pane, 0, 0);
    }

    public AddressInfo getNewAddress() throws BasicException, SQLException {
        AddressInfo addresse = new AddressInfo();
        addresse.setAddress(this.address.getText());
        addresse.setAppartement(this.appartement.getText());
        addresse.setBatiment(this.batiment.getText());
        addresse.setCity(this.city.getText());
        addresse.setEntrycode(this.codeEntree.getText());
        addresse.setEscalier(this.escalier.getText());
        addresse.setEtage(this.etage.getText());
        addresse.setInterphone(this.interphone.getText());
        addresse.setSociete(this.societe.getText());
        addresse.setZipcode(this.zipCode.getText());
        addresse.setIdCustomer(this.currentCustomer.getId());
        if (this.placeCurrent != null) {
            addresse.setLat(this.placeCurrent.getLatitude());
            addresse.setLon(this.placeCurrent.getLongitude());
        }
        AddressInfo newaddresse = this.mAddressService.add(addresse);
        return newaddresse;
    }

    public AddressInfo getUpdatedAddress() throws BasicException, SQLException {
        this.oldAddress.setAddress(this.address.getText());
        this.oldAddress.setAppartement(this.appartement.getText());
        this.oldAddress.setBatiment(this.batiment.getText());
        this.oldAddress.setCity(this.city.getText());
        this.oldAddress.setEntrycode(this.codeEntree.getText());
        this.oldAddress.setEscalier(this.escalier.getText());
        this.oldAddress.setEtage(this.etage.getText());
        this.oldAddress.setInterphone(this.interphone.getText());
        this.oldAddress.setSociete(this.societe.getText());
        this.oldAddress.setZipcode(this.zipCode.getText());
        this.oldAddress.setIdCustomer(this.currentCustomer.getId());
        if (this.placeCurrent != null) {
            this.oldAddress.setLat(this.placeCurrent.getLatitude());
            this.oldAddress.setLon(this.placeCurrent.getLongitude());
        }
        this.mAddressService.update(this.oldAddress);
        return this.oldAddress;
    }

    public void addAddress() {
        if (!(this.address.getText().isEmpty() || this.zipCode.getText().isEmpty() || this.city.getText().isEmpty())) {
            try {
                int addressID;
                if (this.newAddress) {
                    addressID = this.getNewAddress().getId();
                } else {
                    addressID = this.getUpdatedAddress().getId();
                    this.currentCustomer.setName(this.name_customer.getText());
                    this.currentCustomer.setPhone(this.phone.getText());
                    this.mCustomerService.merge(this.currentCustomer);
                }
                AppLocal.Address_ID = addressID;
                AppLocal.Client_ID = this.currentCustomer.getId();
                this.placeCurrent = null;
                this.newAddress = true;
                this.oldAddress = null;
                AppLocal.changeAddress = false;
                AppLocal.oldAddress = null;
                AppLocal.customer_to_change = null;
                this.main_pane.requestFocus();
                if (AppLocal.srcChangeAddress == null || AppLocal.srcChangeAddress.equals("caisse")) {
                    AppLocal.demandeLivraison = true;
                    this.m_App.getAppUserView().showTask("com.openbravo.pos.sales.JCaissePanel");
                    AppLocal.view_back = AppLocal.view_current;
                    AppLocal.view_current = "com.openbravo.pos.sales.JCaissePanel";
                } else {
                    AppLocal.changeCustomerSuivi = true;
                    this.m_App.getAppUserView().showTask("com.openbravo.pos.sales.JPanelOrderSuivi");
                    AppLocal.view_back = "com.openbravo.pos.sales.JCaissePanel";
                    AppLocal.view_current = "com.openbravo.pos.sales.JPanelOrderSuivi";
                }
                AppLocal.Address_ID = addressID;
                this.initialize();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci  de remplir les champs necessaires.", 1500, NPosition.CENTER);
        }
    }

    public void addClient() {
        if (this.new_client.getText().isEmpty() || this.addresslv.getText().isEmpty() || this.citylv.getText().isEmpty() || this.zipCodelv.getText().isEmpty()) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de remplir les champs necessaires.", 1500, NPosition.CENTER);
        } else if (this.phone.getText().length() == 10) {
            CustomerInfo customer = new CustomerInfo();
            customer.setName(this.new_client.getText());
            customer.setPhone(this.phone.getText());
            customer.setDiscount(0.0);
            customer.setType("customer");
            customer.setPrefix_phone(this.prefix_phone_text.getText());
            AddressInfo addresse = new AddressInfo();
            addresse.setAddress(this.addresslv.getText());
            addresse.setAppartement(this.appartementlv.getText());
            addresse.setBatiment(this.batimentlv.getText());
            addresse.setCity(this.citylv.getText());
            addresse.setEntrycode(this.codeEntreelv.getText());
            addresse.setEscalier(this.escalierlv.getText());
            addresse.setEtage(this.etagelv.getText());
            addresse.setInterphone(this.interphonelv.getText());
            addresse.setSociete(this.societelv.getText());
            addresse.setZipcode(this.zipCodelv.getText());
            addresse.setIsSynchro(false);
            if (this.placeCurrent != null) {
                addresse.setLat(this.placeCurrent.getLatitude());
                addresse.setLon(this.placeCurrent.getLongitude());
            }
            try {
                this.mCustomerService.saveWithAddress(customer, addresse);
                AppLocal.Address_ID = addresse.getId();
                AppLocal.Client_ID = customer.getId();
                AppLocal.demandeLivraison = true;
                AppLocal.changeAddress = false;
                AppLocal.oldAddress = null;
                AppLocal.customer_to_change = null;
                this.main_pane.requestFocus();
                this.m_App.getAppUserView().showTask("com.openbravo.pos.sales.JCaissePanel");
                AppLocal.view_back = AppLocal.view_current;
                AppLocal.view_current = "com.openbravo.pos.sales.JCaissePanel";
                this.initialize();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.CENTER);
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Le num\u00e9ro t\u00e9l\u00e9phone do\u00eet contenir 10 chiffres.", 1500, NPosition.CENTER);
        }
    }

    public void initialize() {
        this.newAddress = true;
        AppLocal.srcChangeAddress = null;
        this.showEspaceClient = false;
        this.nom_client.setText("");
        this.phone.setText("");
        this.new_client.setText("");
        this.addresslv.setText("");
        this.zipCodelv.setText("");
        this.citylv.setText("");
        this.codeEntreelv.setText("");
        this.interphonelv.setText("");
        this.batimentlv.setText("");
        this.escalierlv.setText("");
        this.etagelv.setText("");
        this.appartementlv.setText("");
        this.societelv.setText("");
        this.address.setText("");
        this.zipCode.setText("");
        this.city.setText("");
        this.codeEntree.setText("");
        this.interphone.setText("");
        this.batiment.setText("");
        this.escalier.setText("");
        this.etage.setText("");
        this.appartement.setText("");
        this.societe.setText("");
        this.nom_client.setText("");
        this.prefix_phone_text.setText(AppLocal.PREFIX_PHONE);
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.pane_message, 0, 0);
    }

    public void hideEspaceClient() {
        this.addresslv.setText("");
        this.zipCodelv.setText("");
        this.citylv.setText("");
        this.codeEntreelv.setText("");
        this.interphonelv.setText("");
        this.batimentlv.setText("");
        this.escalierlv.setText("");
        this.etagelv.setText("");
        this.appartementlv.setText("");
        this.societelv.setText("");
        this.address.setText("");
        this.zipCode.setText("");
        this.city.setText("");
        this.codeEntree.setText("");
        this.interphone.setText("");
        this.batiment.setText("");
        this.escalier.setText("");
        this.etage.setText("");
        this.appartement.setText("");
        this.societe.setText("");
        this.nom_client.setText("");
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.pane_message, 0, 0);
        this.showEspaceClient = false;
        AppLocal.changeAddress = false;
        AppLocal.oldAddress = null;
        AppLocal.customer_to_change = null;
    }

    public void loadPopUpCities(List<CityInfo> citiesDelivery, final boolean new_customer) {
        this.mActionEventCitiesDelivery = new EventHiddenModal(){
            Object[] result;

            @Override
            public void onHidden() {
                CityInfo cityDelivery;
                if (((Boolean)this.result[1]).booleanValue() && (cityDelivery = (CityInfo)this.result[0]) != null) {
                    if (new_customer) {
                        LivraisonController.this.citylv.setText(cityDelivery.getName().toUpperCase());
                    } else {
                        LivraisonController.this.city.setText(cityDelivery.getName().toUpperCase());
                    }
                }
                LivraisonController.this.mLazyModalCitiesDelivery.destroyEvents();
                LivraisonController.this.mActionEventCitiesDelivery = null;
            }

            @Override
            public void onHidden(AppLoaderBuilder mBuilder) {
                if (mBuilder != null && mBuilder.getController() != null) {
                    CitiesDeliveryController mController = (CitiesDeliveryController)mBuilder.getController();
                    this.result = mController.getResult();
                }
                this.onHidden();
            }
        };
        if (this.mLazyModalCitiesDelivery == null) {
            this.mLazyModalCitiesDelivery = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/CitiesDelivery.fxml", new Dimension(400, 500));
        }
        this.mLazyModalCitiesDelivery.setEventHiddenModal(this.mActionEventCitiesDelivery);
        this.mLazyModalCitiesDelivery.load(citiesDelivery);
    }

    private void setTexts() {
        this.label_search_by_num.setText(AppLocal.getIntString("Button.search.by.num"));
        this.label_search_by_name.setText(AppLocal.getIntString("Button.search.by.name"));
        this.label_message.setText(AppLocal.getIntString("Label.customer.not.found"));
        this.label_name_customer.setText(AppLocal.getIntString("Label.customer.name"));
        this.label_name_new_customer.setText(AppLocal.getIntString("Label.customer.name"));
        this.label_prefix_phone.setText(AppLocal.getIntString("Label.prefix.phone"));
        this.btn_valid.setText(AppLocal.getIntString("Button.valid.customer"));
        this.address.setPromptText(AppLocal.getIntString("Text.address"));
        this.zipCode.setPromptText(AppLocal.getIntString("Text.zipCode"));
        this.city.setPromptText(AppLocal.getIntString("Text.city"));
        this.codeEntree.setPromptText(AppLocal.getIntString("Text.codeEntree"));
        this.interphone.setPromptText(AppLocal.getIntString("Text.interphone"));
        this.batiment.setPromptText(AppLocal.getIntString("Text.batiment"));
        this.escalier.setPromptText(AppLocal.getIntString("Text.escalier"));
        this.etage.setPromptText(AppLocal.getIntString("Text.etage"));
        this.appartement.setPromptText(AppLocal.getIntString("Text.appartement"));
        this.societe.setPromptText(AppLocal.getIntString("Text.societe"));
        this.addresslv.setPromptText(AppLocal.getIntString("Text.address"));
        this.zipCodelv.setPromptText(AppLocal.getIntString("Text.zipCode"));
        this.citylv.setPromptText(AppLocal.getIntString("Text.city"));
        this.codeEntreelv.setPromptText(AppLocal.getIntString("Text.codeEntree"));
        this.interphonelv.setPromptText(AppLocal.getIntString("Text.interphone"));
        this.batimentlv.setPromptText(AppLocal.getIntString("Text.batiment"));
        this.escalierlv.setPromptText(AppLocal.getIntString("Text.escalier"));
        this.etagelv.setPromptText(AppLocal.getIntString("Text.etage"));
        this.appartementlv.setPromptText(AppLocal.getIntString("Text.appartement"));
        this.societelv.setPromptText(AppLocal.getIntString("Text.societe"));
        this.btn_geo_new.setText(AppLocal.getIntString("Button.geolocalisation"));
        this.btn_add_address.setText(AppLocal.getIntString("Button.add.address"));
        this.btn_add_client.setText(AppLocal.getIntString("Button.add.customer"));
        this.btn_geo.setText(AppLocal.getIntString("Button.geolocalisation"));
    }
}

