/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.BackupUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.Hashcypher;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.dao.entities.LicenceInfo;
import fr.protactile.procaisse.dao.impl.CaisseInfoDao;
import fr.protactile.procaisse.services.BlockingCheckService;
import fr.protactile.procaisse.services.InfoLicenceGeneratedService;
import fr.protactile.procaisse.services.SecurityCheckService;
import java.io.InputStream;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;

public class LicenceKeyController {
    private MarqueNFC marqueNF;
    private String keenio;
    private boolean closed;
    private JRootApp jRootApp;
    @FXML
    TextField siret;
    @FXML
    TextField id_franchise;
    @FXML
    TextField key;
    @FXML
    TextField ipmaitre;
    @FXML
    GridPane main_pane;
    @FXML
    GridPane pane_title;
    @FXML
    GridPane pane_parent;
    @FXML
    GridPane pane_form;
    @FXML
    GridPane valid_pane;
    @FXML
    GridPane pane_key;
    @FXML
    GridPane pane_siret;
    @FXML
    GridPane pane_name_restaurant;
    @FXML
    GridPane pane_address;
    @FXML
    GridPane pane_zip_code;
    @FXML
    GridPane pane_city;
    @FXML
    GridPane pane_email;
    @FXML
    GridPane pane_phone;
    @FXML
    Label name_restaurant;
    @FXML
    Label address;
    @FXML
    Label zipCode;
    @FXML
    Label city;
    @FXML
    Label email;
    @FXML
    Label phone;
    @FXML
    Label message_error;
    @FXML
    GridPane pane_message_error;
    @FXML
    Label your;
    @FXML
    Label title_line1;
    @FXML
    Label title_line2;
    @FXML
    Button btn_save;
    @FXML
    Button btn_exit;
    @FXML
    GridPane paneMode;
    @FXML
    GridPane Pane_franchiseId;
    @FXML
    GridPane pane_ipAdress;
    @FXML
    RadioButton check_franchise;
    @FXML
    RadioButton checkresto;
    @FXML
    Label labelidfranchise;
    @FXML
    Label key_label;
    @FXML
    Label siret_label;
    GridPane Container = new GridPane();
    @FXML
    GridPane pane_check_resto;
    @FXML
    GridPane pane_check_franchise;
    private String selectedValue;
    AppConfig config;
    final FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private SecurityCheckService securityCheckService;

    public void initialize(JRootApp jRootApp, String message_error_value, MarqueNFC marqueNFC, String keenio) {
        this.jRootApp = jRootApp;
        this.marqueNF = marqueNFC;
        this.keenio = keenio;
        this.ipmaitre.setPromptText("192.xxx.xxx.xxx");
        this.key.setPromptText("xxxx-xxxx-xxxx-xxxx");
        final double height = AppVarUtils.getScreenDimension().getHeight();
        this.labelidfranchise.setWrapText(true);
        System.out.println("+++++++++ marqueNF : " + this.marqueNF);
        Font.loadFont((InputStream)this.getClass().getResourceAsStream("/fonts/MonumentExtended.ttf"), (double)24.0);
        Font.loadFont((InputStream)this.getClass().getResourceAsStream("/fonts/SF-Pro-Text-BoldItalic.ttf"), (double)24.0);
        this.setActiveBtnAction(this.btn_save);
        if (keenio != null) {
            this.key.setText(keenio);
        }
        if (this.check_franchise.isSelected()) {
            this.displayFranchiseForm(height);
        }
        if (this.checkresto.isSelected()) {
            this.displayRestoForm(height);
        }
        this.check_franchise.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                LicenceKeyController.this.checkresto.setSelected(newValue == false);
                LicenceKeyController.this.deselectRadioButton(LicenceKeyController.this.pane_check_resto);
                LicenceKeyController.this.selectRadioButton(LicenceKeyController.this.pane_check_franchise);
                LicenceKeyController.this.pane_message_error.setVisible(false);
                LicenceKeyController.this.displayFranchiseForm(height);
            }
        });
        this.checkresto.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                LicenceKeyController.this.pane_message_error.setVisible(false);
                LicenceKeyController.this.check_franchise.setSelected(newValue == false);
                LicenceKeyController.this.deselectRadioButton(LicenceKeyController.this.pane_check_franchise);
                LicenceKeyController.this.selectRadioButton(LicenceKeyController.this.pane_check_resto);
                LicenceKeyController.this.displayRestoForm(height);
            }
        });
        if (this.marqueNF != null) {
            this.main_pane.getChildren().clear();
            this.main_pane.setVgap(5.0);
            this.key_label.getStyleClass().add((Object)"text-orange");
            this.siret_label.getStyleClass().add((Object)"text-orange");
            this.main_pane.setPrefHeight(height * 0.65);
            this.pane_key.setPrefHeight(this.main_pane.getPrefHeight() * 0.13);
            this.pane_siret.setPrefHeight(this.main_pane.getPrefHeight() * 0.13);
            this.siret.setText(this.marqueNF.getSiret());
            this.name_restaurant.setText(this.marqueNF.getCompany());
            this.address.setText(this.marqueNF.getAdresse1());
            this.zipCode.setText(this.marqueNF.getZipCode());
            this.city.setText(this.marqueNF.getCity());
            this.email.setText(this.marqueNF.getEmail());
            this.phone.setText(this.marqueNF.getTel());
            this.main_pane.add((Node)this.pane_key, 0, 0);
            this.main_pane.add((Node)this.pane_siret, 0, 1);
            this.main_pane.add((Node)this.pane_name_restaurant, 0, 2);
            this.main_pane.add((Node)this.pane_address, 0, 3);
            this.main_pane.add((Node)this.pane_city, 0, 4);
            this.main_pane.add((Node)this.pane_email, 0, 5);
            this.main_pane.add((Node)this.pane_phone, 0, 6);
        } else {
            this.main_pane.getChildren().clear();
            this.main_pane.setPrefHeight(height * 0.65);
            this.paneMode.setHgap(40.0);
            this.paneMode.setVgap(40.0);
            this.paneMode.setPrefHeight(this.main_pane.getPrefHeight() * 0.3);
            this.main_pane.setAlignment(Pos.CENTER);
            this.Container.setPrefHeight(0.0);
            this.Container.setPrefWidth(this.main_pane.getPrefWidth());
            this.main_pane.add((Node)this.paneMode, 0, 0);
            this.main_pane.add((Node)this.Container, 0, 1);
        }
        this.pane_message_error.setVisible(false);
        this.pane_parent.getChildren().clear();
        this.pane_parent.add((Node)this.pane_form, 0, 0);
        if (message_error_value != null && !message_error_value.isEmpty()) {
            this.setMessageError(message_error_value);
            this.pane_message_error.setVisible(true);
        }
    }

    private void setMessageError(String message_error_value) {
        this.message_error.setText(message_error_value);
        this.pane_message_error.setStyle("-fx-background-color: #fb3e3e; -fx-background-radius: 1em;");
    }

    public void save() {
        try {
            System.out.println("+++++++++++++++save()");
            final String key_value = this.key.getText();
            final String siret_value = this.siret.getText();
            if (!key_value.isEmpty() && !siret_value.isEmpty()) {
                final InfoLicenceGeneratedService infoLicenceGeneratedService = InfoLicenceGeneratedService.getInstance();
                final LicenceInfo licence = infoLicenceGeneratedService.getInfoLicence(key_value, siret_value, true);
                if (licence != null) {
                    if (licence.isBlocked()) {
                        this.setMessageError(licence.getErrorMsg());
                        this.pane_message_error.setVisible(true);
                    } else if (!licence.isActive()) {
                        System.out.println("licence.getErrorMsg() : " + licence.getErrorMsg());
                        this.setMessageError(licence.getErrorMsg());
                        this.pane_message_error.setVisible(true);
                    } else {
                        this.setTextStart();
                        new Thread(() -> Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    LicenceKeyController.this.updateLocalInfoLicence(licence);
                                    LicenceKeyController.this.setInfoCaisse(licence);
                                    AppLocal.licenceActivated = true;
                                    LicenceKeyController.this.securityCheckService = SecurityCheckService.getInstance();
                                    LicenceKeyController.this.securityCheckService.setDateValidation(licence.getDailyDate(), licence.getTemporaryUsePeriod());
                                    infoLicenceGeneratedService.updateUserKeenIo(key_value, siret_value, licence);
                                    BlockingCheckService blockingCheckService = BlockingCheckService.getInstance();
                                    blockingCheckService.setBlockingCheck(licence.isBlocked(), licence.getBlockingDate());
                                    LicenceKeyController.this.jRootApp.loadFirstViewAfterCheckKeyLicence();
                                    new Thread(new Runnable(){

                                        @Override
                                        public void run() {
                                            LicenceKeyController.this.initSetupFTP(key_value);
                                        }
                                    }).start();
                                }
                                catch (Exception ex) {
                                    LogToFile.log("severe", null, ex);
                                }
                            }
                        })).start();
                    }
                } else {
                    String erreurMsg = "Erreur r\u00e9seau";
                    this.setMessageError(erreurMsg);
                    this.pane_message_error.setVisible(true);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void exit() {
        this.closed = false;
        try {
            Journal.writeToJET(new Event(40, "Arret de l'application", "", "", new Date().getTime(), "licence indisponible"));
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        System.exit(0);
    }

    public boolean getResult() {
        return this.closed;
    }

    public void setInfoCaisse(LicenceInfo licence) {
        this.config = AppConfig.getInstance(true, this.m_FilerUtils.getFileProperties());
        if (licence.getTypeDisplay() != null && !licence.getTypeDisplay().isEmpty()) {
            this.config.setProperty("model.caisse", licence.getTypeDisplay());
            AppLocal.MODEL_CAISSE = licence.getTypeDisplay();
        }
        if (licence.getType() != null && !licence.getType().isEmpty()) {
            this.config.setProperty("mode.display", licence.getType());
            AppLocal.modeCaisse = licence.getType();
            AppLocal.MODE_DISPLAY = licence.getType();
        }
        if (licence.getIpMaster() != null && !licence.getIpMaster().isEmpty()) {
            this.config.setProperty("ip.master", licence.getIpMaster());
        }
        if (this.check_franchise.isSelected()) {
            this.config.setProperty("mode.franchise", "yes");
        } else {
            this.config.setProperty("mode.franchise", "no");
        }
        String franchise_ID = this.id_franchise.getText() != null && !this.id_franchise.getText().isEmpty() ? this.id_franchise.getText() : licence.getFranchise_id();
        this.config.setProperty("franchise.id", franchise_ID);
        if (licence.getName_machine() != null && !licence.getName_machine().isEmpty()) {
            this.config.setProperty("machine.hostname", licence.getName_machine());
            AppLocal.source_order = licence.getName_machine();
            AppLocal.host_name = licence.getName_machine();
        }
        if (licence.getCurrency() != null && !licence.getCurrency().isEmpty()) {
            this.config.setProperty("format.currency", licence.getCurrency());
            AppLocal.FORMAT_CURRENCY = licence.getCurrency();
            Formats.setCurrencyPattern(AppLocal.FORMAT_CURRENCY);
        }
        if (licence.getType().equals("Maitre")) {
            this.config.setProperty("module.bornes", "yes");
        } else {
            this.config.setProperty("remote.sync", "yes");
        }
        this.config.setProperty("stats.online", "yes");
        this.config.save();
        AppLocal.MODE_FRANCHISE = this.config.getBooleanAndDefaultProperty("mode.franchise");
        AppLocal.FRANCHISE_ID = this.id_franchise.getText();
    }

    public void updateLocalInfoLicence(LicenceInfo licence) {
        if (licence != null) {
            System.out.println("+++++++++++++++++++++++blocked" + licence.isBlocked());
            try {
                boolean blocked = licence.isBlocked();
                boolean active = licence.isActive();
                AppLocal.licenceActivated = !blocked;
                CaisseInfo caisseInfo = AppLocal.dlSales.getCaisse(AppLocal.token);
                if (caisseInfo != null) {
                    System.out.println("++++++++++++++++++++++++caisseInfo" + caisseInfo.toString());
                    caisseInfo.setBlocked(blocked);
                    caisseInfo.setActive(active);
                    CaisseInfoDao mCaisseInfoDao = new CaisseInfoDao();
                    mCaisseInfoDao.updateStatusBlocked(caisseInfo);
                }
            }
            catch (BasicException ex) {
                Logger.getLogger(LicenceKeyController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setTextStart() {
        this.pane_message_error.getChildren().clear();
        this.pane_message_error.setStyle("");
        this.message_error.getStyleClass().clear();
        this.message_error.setText("Lancement de l'application en cours ...");
        this.message_error.getStyleClass().addAll((Object[])new String[]{"text_green1", "text-size-20"});
        this.pane_message_error.add((Node)this.message_error, 0, 0);
        this.pane_message_error.setVisible(true);
        System.out.println("++++++++++++++++is Done");
    }

    public GridPane setPaneImagePos() {
        GridPane gridPanePosImage = new GridPane();
        try {
            double heigtPane = AppVarUtils.getScreenDimension().getHeight();
            double heightImg = heigtPane * 0.93;
            double width = AppVarUtils.getScreenDimension().getWidth() * 0.45;
            double widthImg = width * 0.9;
            gridPanePosImage.setAlignment(Pos.CENTER);
            gridPanePosImage.setPrefHeight(heigtPane);
            gridPanePosImage.setPrefWidth(width + 20.0);
            Image img = new Image(this.getClass().getResource("/com/openbravo/images/pos_capture.png").toURI().toString(), AppVarUtils.getScreenDimension().getWidth() * 0.7, AppVarUtils.getScreenDimension().getHeight(), false, false);
            ImageView imgView = new ImageView(img);
            imgView.setFitWidth(widthImg * 0.9);
            imgView.setFitHeight(heightImg);
            Rectangle clip = new Rectangle(imgView.getFitWidth(), imgView.getFitHeight());
            clip.setArcWidth(20.0);
            clip.setArcHeight(20.0);
            imgView.setClip((Node)clip);
            Platform.runLater(() -> {
                SnapshotParameters parameters = new SnapshotParameters();
                parameters.setFill((Paint)Color.TRANSPARENT);
                WritableImage roundedImage = imgView.snapshot(parameters, null);
                imgView.setClip(null);
                DropShadow dropShadow = new DropShadow(25.0, Color.ORANGERED);
                imgView.setEffect((Effect)dropShadow);
                imgView.setImage((Image)roundedImage);
            });
            StackPane root = new StackPane(new Node[]{imgView});
            gridPanePosImage.add((Node)root, 0, 0);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return gridPanePosImage;
    }

    public void displayFranchiseForm(double height) {
        this.main_pane.setPrefHeight(height * 0.65);
        this.Container.getChildren().clear();
        this.Container.setVgap(15.0);
        this.paneMode.setPrefHeight(this.main_pane.getPrefHeight() * 0.3);
        this.Container.setPrefHeight(this.main_pane.getPrefHeight() * 0.5);
        this.Container.setPrefWidth(this.paneMode.getPrefWidth());
        this.pane_key.setPrefHeight(this.Container.getPrefHeight() * 0.3);
        this.pane_siret.setPrefHeight(this.Container.getPrefHeight() * 0.3);
        this.Pane_franchiseId.setPrefHeight(this.Container.getPrefHeight() * 0.3);
        this.Container.add((Node)this.pane_siret, 0, 0);
        this.Container.add((Node)this.Pane_franchiseId, 0, 1);
        this.Container.add((Node)this.pane_key, 0, 2);
        this.pane_key.setAlignment(Pos.TOP_CENTER);
    }

    public void displayRestoForm(double height) {
        this.main_pane.setPrefHeight(height * 0.65);
        this.Container.getChildren().clear();
        this.Container.setVgap(15.0);
        this.paneMode.setPrefHeight(this.main_pane.getPrefHeight() * 0.3);
        this.Container.setPrefHeight(this.main_pane.getPrefHeight() * 0.5);
        this.Container.setPrefWidth(this.paneMode.getPrefWidth());
        this.pane_key.setPrefHeight(this.Container.getPrefHeight() * 0.3);
        this.pane_siret.setPrefHeight(this.Container.getPrefHeight() * 0.3);
        this.Pane_franchiseId.setPrefHeight(this.Container.getPrefHeight() * 0.3);
        this.Container.add((Node)this.pane_siret, 0, 0);
        this.Container.add((Node)this.pane_key, 0, 1);
    }

    public void setActiveBtnAction(Button btn_save) {
        btn_save.setDisable(true);
        this.key.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.key.getText().isEmpty() && !this.siret.getText().isEmpty()) {
                this.setDisableBtnSave(false);
            } else {
                this.setDisableBtnSave(true);
            }
        });
        this.siret.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!this.key.getText().isEmpty() && !this.siret.getText().isEmpty()) {
                this.setDisableBtnSave(false);
            } else {
                this.setDisableBtnSave(true);
            }
        });
    }

    private void setDisableBtnSave(boolean disable) {
        this.btn_save.setDisable(disable);
        if (disable) {
            if (this.btn_save.getStyleClass().contains((Object)"text-white")) {
                this.btn_save.getStyleClass().remove((Object)"text-white");
            }
            if (this.btn_save.getStyleClass().contains((Object)"bg_FF7039")) {
                this.btn_save.getStyleClass().remove((Object)"bg_FF7039");
            }
            if (this.btn_save.getStyleClass().contains((Object)"border_FF7039")) {
                this.btn_save.getStyleClass().remove((Object)"border_FF7039");
            }
            if (!this.btn_save.getStyleClass().contains((Object)"text_393B3F")) {
                this.btn_save.getStyleClass().add((Object)"text_393B3F");
            }
            if (!this.btn_save.getStyleClass().contains((Object)"bg-white")) {
                this.btn_save.getStyleClass().add((Object)"bg-white");
            }
            if (!this.btn_save.getStyleClass().contains((Object)"border_7680AC")) {
                this.btn_save.getStyleClass().add((Object)"border_7680AC");
            }
        } else {
            if (this.btn_save.getStyleClass().contains((Object)"text_393B3F")) {
                this.btn_save.getStyleClass().remove((Object)"text_393B3F");
            }
            if (this.btn_save.getStyleClass().contains((Object)"bg-white")) {
                this.btn_save.getStyleClass().remove((Object)"bg-white");
            }
            if (this.btn_save.getStyleClass().contains((Object)"border_7680AC")) {
                this.btn_save.getStyleClass().remove((Object)"border_7680AC");
            }
            if (!this.btn_save.getStyleClass().contains((Object)"text-white")) {
                this.btn_save.getStyleClass().add((Object)"text-white");
            }
            if (!this.btn_save.getStyleClass().contains((Object)"bg_FF7039")) {
                this.btn_save.getStyleClass().add((Object)"bg_FF7039");
            }
            if (!this.btn_save.getStyleClass().contains((Object)"border_FF7039")) {
                this.btn_save.getStyleClass().add((Object)"border_FF7039");
            }
        }
    }

    private boolean initBackup(String key_value) {
        boolean is_created_task = false;
        String cleanedKeenIo = key_value.replaceAll("[^0-9]", "");
        String userName = Hashcypher.hashAccessBackUp(cleanedKeenIo);
        String userPassword = Hashcypher.hashAccessBackUp(cleanedKeenIo + "pa42");
        System.out.println("userName ******************: " + userName);
        System.out.println("userPassword ***************** : " + userPassword);
        BackupUtils backupUtils = new BackupUtils();
        boolean result = backupUtils.createUserFTP(userName, userPassword);
        System.out.println("result : " + result);
        if (result) {
            backupUtils.addInfosAccessToConfig(userName, userPassword);
            backupUtils.createBackupTask();
            backupUtils.createBackup();
            is_created_task = true;
        }
        return is_created_task;
    }

    private boolean createTaskAutoRestart() {
        boolean is_created = false;
        System.out.println("AppLocal.modeCaisse : " + AppLocal.modeCaisse);
        if (AppLocal.modeCaisse != null && AppLocal.modeCaisse.equalsIgnoreCase("Borne")) {
            SystemUtils.createAutoStartTask();
            is_created = true;
        }
        return is_created;
    }

    private void saveConfigurationFTP(boolean is_configured) {
        System.out.println("*******************  saveConfigurationFTP() ************* ");
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        AppConfig config = null;
        config = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        if (is_configured) {
            config.setProperty("ftp.account.configured", "yes");
        } else {
            config.setProperty("ftp.account.configured", "no");
        }
        config.save();
    }

    public void initSetupFTP(final String key_value) {
        try {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean is_backup_task_created = LicenceKeyController.this.initBackup(key_value);
                    boolean is_created = LicenceKeyController.this.createTaskAutoRestart();
                    if (is_backup_task_created && (is_created || AppLocal.modeCaisse == null || !AppLocal.modeCaisse.equalsIgnoreCase("Borne"))) {
                        LicenceKeyController.this.saveConfigurationFTP(true);
                    } else {
                        LicenceKeyController.this.saveConfigurationFTP(false);
                    }
                }
            }).start();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void selectRadioButton(GridPane pane) {
        pane.getStyleClass().remove((Object)"radioButton_pane");
        Stop[] stops = new Stop[]{new Stop(0.0294, Color.rgb((int)255, (int)99, (int)70, (double)0.08)), new Stop(0.9824, Color.rgb((int)255, (int)70, (int)181, (double)0.08))};
        LinearGradient linearGradient = new LinearGradient(0.5, 1.0, 1.0, 0.5, true, CycleMethod.NO_CYCLE, stops);
        BackgroundFill backgroundFill = new BackgroundFill((Paint)linearGradient, new CornerRadii(14.849), Insets.EMPTY);
        Background background = new Background(new BackgroundFill[]{backgroundFill});
        BorderStroke borderStroke = new BorderStroke((Paint)Color.web((String)"#FF6346"), BorderStrokeStyle.SOLID, new CornerRadii(14.849), new BorderWidths(1.791));
        Border border = new Border(new BorderStroke[]{borderStroke});
        pane.setBackground(background);
        pane.setBorder(border);
    }

    public void deselectRadioButton(GridPane pane) {
        BorderStroke borderStroke = new BorderStroke((Paint)Color.web((String)"#A4A8AE"), BorderStrokeStyle.SOLID, new CornerRadii(14.849), new BorderWidths(1.791));
        Border border = new Border(new BorderStroke[]{borderStroke});
        pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, new CornerRadii(14.849), Insets.EMPTY)}));
        pane.setBorder(border);
    }
}

