/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;
import javax.swing.JDialog;

public class InfoNormeController
implements RootController {
    public final SimpleDateFormat dateFormatter = DateUtils.formatterDAY_MONTH_YEAR_SLASHES;
    private Stage stage;
    private JDialog dialog;
    @FXML
    Label name;
    @FXML
    Label licence;
    @FXML
    Label date_licence;
    @FXML
    Label utilisation_licence;
    @FXML
    Label version;
    @FXML
    Label publish_date;
    @FXML
    Label logo_certificat;
    @FXML
    Label num_certificat;
    @FXML
    Label date_certificat;
    @FXML
    Label label_account;
    @FXML
    Label label_name_company;
    @FXML
    Label label_licence;
    @FXML
    Label label_date_licence;
    @FXML
    Label label_utilisation_licence;
    @FXML
    Label label_info;
    @FXML
    Label label_version;
    @FXML
    Label label_certificat;
    @FXML
    Label category_certificat;
    @FXML
    Label date_validity;

    public void closePopUp() {
        if (this.stage != null) {
            this.stage.close();
        } else if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void initializer() {
        MarqueNFC marqueNF = null;
        String keenio = null;
        try {
            marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            keenio = AppLocal.dlItems.getUserKeenIo();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        try {
            double heightImage = AppVarUtils.getScreenDimension().getHeight() * 0.7 * 0.4 * 0.65;
            if (marqueNF != null) {
                this.name.setText(marqueNF.getCompany());
                if (keenio != null) {
                    this.licence.setText(keenio);
                }
                if (marqueNF.getDateFirstConnexion() != null) {
                    this.date_licence.setText(this.dateFormatter.format(marqueNF.getDateFirstConnexion()));
                    Date date_creation = marqueNF.getDateFirstConnexion();
                    Date current_date = new Date();
                    long diff = current_date.getTime() - date_creation.getTime();
                    long licence_days = TimeUnit.MILLISECONDS.toDays(diff);
                    this.utilisation_licence.setText(licence_days + " jour(s) pass\u00e9(s)");
                }
            }
            this.version.setText("10.0.1.27");
            this.num_certificat.setText("N\u00b0 525/0413-6");
            this.date_certificat.setText("Date d\u2019\u00e9mission : 05/11/24");
            this.date_validity.setText("Date de fin de validit\u00e9 : 02/11/2025");
            this.category_certificat.setText("Cat\u00e9gorie B ");
            Image image_logo = new Image(this.getClass().getResource("/com/openbravo/images/logo_certificat.png").toURI().toString());
            ImageView view_logo = new ImageView();
            view_logo.setImage(image_logo);
            view_logo.setFitHeight(heightImage);
            view_logo.setPreserveRatio(true);
            view_logo.setSmooth(true);
            view_logo.setCache(true);
            this.logo_certificat.setGraphic((Node)view_logo);
            this.setTexts();
        }
        catch (URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        if (object instanceof JDialog) {
            this.dialog = (JDialog)object;
        }
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        for (Object object : objects) {
            if (!(object instanceof JDialog)) continue;
            this.dialog = (JDialog)object;
        }
        this.initializer();
    }

    private void setTexts() {
        this.label_account.setText(AppLocal.getIntString("label.account"));
        this.label_name_company.setText(AppLocal.getIntString("label.name.company"));
        this.label_licence.setText("Code \u00e9quipement");
        this.label_date_licence.setText(AppLocal.getIntString("label.date.licence"));
        this.label_utilisation_licence.setText(AppLocal.getIntString("label.utilisation.licence"));
        this.label_info.setText(AppLocal.getIntString("label.info"));
        this.label_version.setText(AppLocal.getIntString("Label.version"));
    }
}

