/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.pos.forms.AppLocal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import se.walkercrou.places.GoogleServices;
import se.walkercrou.places.Place;
import se.walkercrou.places.Prediction;

public class GeoController {
    @FXML
    TextField autoComplete;
    @FXML
    ListView listView;
    @FXML
    GridPane pane_geo;
    @FXML
    Label label_address;
    private Stage stage;
    private Object[] result;
    private GoogleServices client;
    private Place placeCurrent;
    private ScheduledFuture scheduledFuture;
    private ScheduledExecutorService scheduler;
    private ObservableList<Place> data;
    private List<Place> items;

    public void init(final Stage stage) {
        this.pane_geo.requestFocus();
        this.stage = stage;
        this.result = new Object[2];
        this.result[0] = null;
        this.result[1] = true;
        this.items = new ArrayList<Place>();
        this.client = new GoogleServices();
        this.data = FXCollections.observableArrayList();
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.autoComplete.getProperties().put((Object)"vkType", (Object)6);
        this.autoComplete.getProperties().put((Object)"vkSize", (Object)2);
        this.label_address.setText(AppLocal.getIntString("Label.add.address"));
        this.listView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Place>(){

            public void changed(ObservableValue<? extends Place> observable, Place oldValue, Place newValue) {
                Place place = newValue;
                if (place != null) {
                    GeoController.this.result[0] = place;
                    GeoController.this.result[1] = true;
                    stage.close();
                }
            }
        });
        this.autoComplete.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                this.callUpdate();
            }

            private void callUpdate() {
                if (GeoController.this.autoComplete.getText().length() >= 3) {
                    String inputText;
                    if (GeoController.this.scheduledFuture != null) {
                        GeoController.this.scheduledFuture.cancel(true);
                    }
                    if (!(inputText = GeoController.this.autoComplete.getText()).isEmpty()) {
                        GeoController.this.scheduledFuture = GeoController.this.scheduler.schedule(new Runnable(){

                            @Override
                            public void run() {
                                if (GeoController.this.items.size() > 0) {
                                    GeoController.this.items.clear();
                                }
                                System.out.println("+++++++++++++ inputText : " + inputText);
                                final List<Prediction> predictions = GeoController.this.client.getPlacePredictions("France, " + inputText);
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        if (predictions != null) {
                                            for (Prediction prediction : predictions) {
                                                Place place = prediction.getPlace();
                                                if (place == null) continue;
                                                GeoController.this.items.add(place);
                                            }
                                            GeoController.this.data.setAll(GeoController.this.items);
                                            GeoController.this.listView.setItems(GeoController.this.data);
                                        }
                                    }
                                });
                            }
                        }, 1L, TimeUnit.SECONDS);
                    }
                } else {
                    GeoController.this.listView.getItems().clear();
                    GeoController.this.data.clear();
                    GeoController.this.items.clear();
                    if (GeoController.this.scheduledFuture != null) {
                        GeoController.this.scheduledFuture.cancel(true);
                    }
                }
            }
        });
    }

    public Object[] getResult() {
        return this.result;
    }
}

