/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.PaymentLine;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;

public class FondCaisseController
implements RootController {
    @FXML
    FlowPane pane_main;
    @FXML
    Label label_turnover;
    @FXML
    Label label_cash_fund;
    private AppView app;
    private DataLogicSales dlSales;
    private List<PaymentLine> payments;
    private Stage stage;
    private double course;

    private void loadFondCaisse() throws BasicException {
        for (PaymentLine payment : this.payments) {
            try {
                GridPane panePayment = new GridPane();
                panePayment.setPrefWidth(100.0);
                panePayment.getStyleClass().add((Object)"bg-white");
                panePayment.setPrefHeight(150.0);
                panePayment.setHgap(5.0);
                panePayment.setVgap(5.0);
                Button btnPayment = new Button();
                btnPayment.setPrefHeight(panePayment.getPrefHeight() * 0.5);
                btnPayment.setPrefWidth(panePayment.getPrefWidth());
                btnPayment.getStyleClass().add((Object)"bg-c91ead");
                Object namePayment = payment.getM_PaymentType();
                System.out.println("payment.getM_PaymentType() : " + payment.getM_PaymentType());
                switch (payment.getM_PaymentType()) {
                    case "Espece": {
                        Image imageCash = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/change.png"));
                        btnPayment.setGraphic((Node)new ImageView(imageCash));
                        namePayment = AppLocal.getIntString("Button.cash");
                        break;
                    }
                    case "CB": {
                        Image imagebCb = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/carteB.png"));
                        btnPayment.setGraphic((Node)new ImageView(imagebCb));
                        namePayment = AppLocal.getIntString("Button.cb");
                        break;
                    }
                    case "Carte Ticket Resto": {
                        Image imagebCbTr = new Image(this.getClass().getResource("/com/openbravo/images/carte_tr.jpg").toURI().toString(), 40.0, 30.0, false, false);
                        btnPayment.setGraphic((Node)new ImageView(imagebCbTr));
                        namePayment = AppLocal.getIntString("Text.carte.tr");
                        break;
                    }
                    case "Ticket Resto": {
                        Image imageTr = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/ticketResto.png"));
                        btnPayment.setGraphic((Node)new ImageView(imageTr));
                        namePayment = payment.getM_PaymentType();
                        break;
                    }
                    case "cashdro": {
                        Image imageCashDro = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/cashdro.png"));
                        btnPayment.setGraphic((Node)new ImageView(imageCashDro));
                        namePayment = payment.getM_PaymentType();
                        break;
                    }
                    case "Debit": {
                        Image imageDebit = new Image(this.getClass().getResource("/com/openbravo/images/debit-card.png").toURI().toString(), 30.0, 30.0, false, false);
                        btnPayment.setGraphic((Node)new ImageView(imageDebit));
                        namePayment = AppLocal.getIntString("Label.debit");
                        break;
                    }
                    case "Avoir": {
                        Image imageFree = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/avoir.png"));
                        btnPayment.setGraphic((Node)new ImageView(imageFree));
                        namePayment = payment.getM_PaymentType();
                        if (payment.getM_PaymentValue() > 0.0) {
                            namePayment = (String)namePayment + " Encaiss\u00e9";
                            break;
                        }
                        namePayment = (String)namePayment + " D\u00e9caiss\u00e9";
                        break;
                    }
                    case "cheque": {
                        Image imageCheque = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/check.png"));
                        btnPayment.setGraphic((Node)new ImageView(imageCheque));
                        namePayment = AppLocal.getIntString("Label.cheque");
                        break;
                    }
                    case "Cr\u00e9dit Employ\u00e9": {
                        Image imageCredit = new Image(this.getClass().getResource("/com/openbravo/images/debit-card.png").toURI().toString(), 30.0, 30.0, false, false);
                        btnPayment.setGraphic((Node)new ImageView(imageCredit));
                        namePayment = AppLocal.getIntString("Label.credit_employe");
                        break;
                    }
                    case "Twint": {
                        Image imageTwint = new Image(this.getClass().getResource("/com/openbravo/images/twint.png").toURI().toString(), 30.0, 30.0, false, false);
                        btnPayment.setGraphic((Node)new ImageView(imageTwint));
                        break;
                    }
                    case "Ch\u00e8que vacances": {
                        Image imageChequeVacances = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/cheque_vacances.png"));
                        ImageView imageViewChequeVacances = new ImageView(imageChequeVacances);
                        imageViewChequeVacances.setFitHeight(25.0);
                        imageViewChequeVacances.setPreserveRatio(true);
                        imageViewChequeVacances.setSmooth(true);
                        imageViewChequeVacances.setCache(true);
                        btnPayment.setGraphic((Node)imageViewChequeVacances);
                        break;
                    }
                    case "Virement bancaire": {
                        Image imageBankTransfer = new Image(this.getClass().getResource("/com/openbravo/images/bank_transfer.jpg").toURI().toString(), 30.0, 30.0, false, false);
                        btnPayment.setGraphic((Node)new ImageView(imageBankTransfer));
                    }
                }
                Label labelPayment = new Label();
                labelPayment.setPrefHeight(panePayment.getPrefHeight() * 0.5);
                labelPayment.setPrefWidth(panePayment.getPrefWidth());
                labelPayment.setAlignment(Pos.CENTER);
                labelPayment.setTextAlignment(TextAlignment.CENTER);
                labelPayment.setWrapText(true);
                labelPayment.setText((String)namePayment + "\n" + Formats.CURRENCY.formatValue(payment.getM_PaymentValue()));
                panePayment.add((Node)btnPayment, 0, 0);
                panePayment.add((Node)labelPayment, 0, 1);
                this.pane_main.getChildren().add((Object)panePayment);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(FondCaisseController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.course != 0.0) {
            GridPane paneCourse = new GridPane();
            paneCourse.setPrefWidth(100.0);
            paneCourse.setPrefHeight(110.0);
            paneCourse.setHgap(5.0);
            paneCourse.setVgap(5.0);
            Label labelCourse = new Label();
            labelCourse.setPrefHeight(paneCourse.getPrefHeight() * 0.6);
            labelCourse.setPrefWidth(paneCourse.getPrefWidth());
            labelCourse.setAlignment(Pos.CENTER);
            labelCourse.setTextAlignment(TextAlignment.CENTER);
            labelCourse.setText("Sortie");
            labelCourse.getStyleClass().add((Object)"bg-c91ead");
            Label valueCourse = new Label();
            valueCourse.setPrefHeight(paneCourse.getPrefHeight() * 0.4);
            valueCourse.setPrefWidth(paneCourse.getPrefWidth());
            valueCourse.setAlignment(Pos.CENTER);
            valueCourse.setTextAlignment(TextAlignment.CENTER);
            valueCourse.setText("-" + Formats.CURRENCY.formatValue(this.course));
            paneCourse.add((Node)labelCourse, 0, 0);
            paneCourse.add((Node)valueCourse, 0, 1);
            this.pane_main.getChildren().add((Object)paneCourse);
        }
    }

    public void closePopUp() {
        this.stage.close();
    }

    private void initializer() {
        try {
            this.dlSales = (DataLogicSales)this.app.getBean("com.openbravo.dao.DataLogicSales");
            CaisseInfo caisse = this.dlSales.getCaisse(AppLocal.token);
            double turnover = this.dlSales.getCA(caisse.getDateOpen());
            this.course = this.dlSales.getTotalCourses();
            turnover += caisse.getFondCaisse().doubleValue();
            this.label_turnover.setText(Formats.CURRENCY.formatValue(turnover -= this.course));
            this.payments = this.dlSales.loadPayment(caisse.getDateOpen(), new Date());
            this.loadFondCaisse();
            this.label_cash_fund.setText(AppLocal.getIntString("Label.cash.fund"));
        }
        catch (BasicException ex) {
            Logger.getLogger(FondCaisseController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object app) {
        this.stage = mStage;
        this.app = (AppView)app;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        if (objects != null) {
            for (Object object : objects) {
                if (!(object instanceof AppView)) continue;
                this.app = (AppView)object;
            }
        }
        this.initializer();
    }
}

