/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicEmployees;
import com.openbravo.models.Employee;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.util.Callback;

public class EmployeeController {
    private AppView app;
    private DataLogicEmployees dlEmployees;
    private List<Employee> employees;
    private ObservableList<Employee> data;
    private Employee currentEmployee;
    private boolean newEmployee;
    @FXML
    TableColumn name;
    @FXML
    TableColumn phone;
    @FXML
    TableColumn fonction;
    @FXML
    TableColumn credit;
    @FXML
    TableView list_employees;
    @FXML
    TextField name_employee;
    @FXML
    TextField phone_employee;
    @FXML
    TextField fonction_employee;
    @FXML
    TextField credit_employee;
    @FXML
    TextField code_carte;
    @FXML
    TextField fixed_amount;

    public void init(AppView app) {
        try {
            this.app = app;
            this.dlEmployees = (DataLogicEmployees)app.getBean("com.openbravo.dao.DataLogicEmployees");
            this.name.setCellValueFactory((Callback)new PropertyValueFactory("name"));
            this.phone.setCellValueFactory((Callback)new PropertyValueFactory("phone"));
            this.fonction.setCellValueFactory((Callback)new PropertyValueFactory("fonction"));
            this.credit.setCellValueFactory((Callback)new PropertyValueFactory("credit"));
            this.list_employees.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

                public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                    int row;
                    if (EmployeeController.this.list_employees.getSelectionModel().getSelectedIndex() != -1 && (row = EmployeeController.this.list_employees.getSelectionModel().getSelectedIndex()) != -1) {
                        EmployeeController.this.currentEmployee = EmployeeController.this.employees.get(row);
                        EmployeeController.this.loadDetailEmployee();
                    }
                }
            });
            this.loadEmployees();
            this.newEmployee = true;
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    private void loadDetailEmployee() {
        this.newEmployee = false;
        this.name_employee.setText(this.currentEmployee.getName());
        this.phone_employee.setText(this.currentEmployee.getPhone());
        this.fonction_employee.setText(this.currentEmployee.getFonction());
        this.credit_employee.setText(String.valueOf(this.currentEmployee.getCredit()));
        this.code_carte.setText(this.currentEmployee.getCode_carte());
        this.fixed_amount.setText(String.valueOf(this.currentEmployee.getFixed_amount()));
    }

    public void loadEmployees() throws BasicException {
        this.employees = this.dlEmployees.getEmployees();
        this.data = FXCollections.observableArrayList(this.employees);
        this.list_employees.getItems().clear();
        this.list_employees.setItems(this.data);
    }

    public void initEmployee() {
        this.newEmployee = true;
        this.name_employee.setText("");
        this.phone_employee.setText("");
        this.fonction_employee.setText("");
        this.credit_employee.setText("");
        this.code_carte.setText("");
        this.fixed_amount.setText("");
    }

    public void validEmployee() {
        if (!this.name_employee.getText().isEmpty()) {
            try {
                if (this.newEmployee && this.currentEmployee == null) {
                    this.currentEmployee = new Employee();
                }
                if (this.currentEmployee != null) {
                    this.currentEmployee.setName(this.name_employee.getText());
                    this.currentEmployee.setPhone(this.phone_employee.getText());
                    this.currentEmployee.setFonction(this.fonction_employee.getText());
                    this.currentEmployee.setCredit(Double.parseDouble(this.credit_employee.getText().isEmpty() ? "0.0" : this.credit_employee.getText()));
                    this.currentEmployee.setCode_carte(this.code_carte.getText());
                    this.currentEmployee.setFixed_amount(Double.parseDouble(this.fixed_amount.getText().isEmpty() ? "0.0" : this.fixed_amount.getText()));
                    if (this.newEmployee) {
                        this.dlEmployees.addEmployee(this.currentEmployee);
                    } else {
                        this.dlEmployees.updateEmployee(this.currentEmployee);
                    }
                    this.loadEmployees();
                    this.initEmployee();
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les informations du salari\u00e9 sont enregistr\u00e9 avec succes.", 1500, NPosition.BOTTOM_RIGHT);
                }
            }
            catch (Exception ex) {
                LogToFile.log("sever", ex.getMessage(), ex);
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de saisir le nom.", 1500, NPosition.BOTTOM_RIGHT);
        }
    }
}

