/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.views.ButtonBoxOptionScreen;
import com.openbravo.controllers.DrivePopUpOptionController;
import com.openbravo.controllers.IDualScreenController;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.drive.shared.PopUpPropagationManager;
import com.openbravo.drive.shared.PopupControllerInitializerDto;
import com.openbravo.drive.shared.PopupViewInitializerDto;
import com.openbravo.events.DriveBasketListBorne;
import com.openbravo.format.Formats;
import com.openbravo.models.DriveHBoxBorne;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductSizeInfo;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.ImagesUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.StringUtils;
import com.openbravo.service.ItemService;
import com.sun.jna.NativeLibrary;
import fr.protactile.procaisse.biborne_video_player.BiborneVideoPlayerController;
import fr.protactile.procaisse.biborne_video_player.ScreenUtil;
import java.io.File;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import javafx.util.Callback;
import uk.co.caprica.vlcj.binding.support.runtime.RuntimeUtil;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;

public class DualScreenDriveControllerNew
implements IDualScreenController {
    @FXML
    ImageView logo;
    @FXML
    ImageView image_product;
    @FXML
    ImageView logo_additional;
    @FXML
    ImageView headerBannerImage;
    @FXML
    ImageView bannerIntermediateImage;
    @FXML
    GridPane list_products;
    @FXML
    GridPane pane_logo;
    @FXML
    GridPane pane_parent;
    @FXML
    GridPane pane_info_products;
    @FXML
    GridPane pane_items_options;
    @FXML
    GridPane pane_options;
    @FXML
    GridPane header_options;
    @FXML
    GridPane list_additional_products;
    @FXML
    GridPane list_additionals;
    @FXML
    HBox pane_call;
    @FXML
    Label label_call;
    @FXML
    Label name_group_option;
    @FXML
    Label label_image;
    @FXML
    Label label_title;
    @FXML
    Label label_total_order;
    @FXML
    Label pagination_label;
    @FXML
    Label price_product;
    @FXML
    Label label_logo_additional;
    @FXML
    Label headerBannerLabel;
    @FXML
    Label optionBannerImage;
    @FXML
    Label name_product;
    @FXML
    TextFlow name_product_label;
    @FXML
    TextFlow name_menu_label;
    @FXML
    TextFlow groupOptionText;
    @FXML
    VBox main_pane_basket_products;
    @FXML
    StackPane header_product;
    @FXML
    StackPane stack_pane_video;
    @FXML
    StackPane stack_pane_logo;
    @FXML
    StackPane stack_pane;
    @FXML
    StackPane options_header_box;
    @FXML
    StackPane basket_header_box;
    @FXML
    StackPane optionsPaneBanner;
    @FXML
    ListView basket_products;
    @FXML
    Button close_button;
    @FXML
    Button previous_detail_header;
    @FXML
    Button next_detail_header;
    @FXML
    Button previousOptionTab;
    @FXML
    Button nextOptionTab;
    @FXML
    Button valid_product_button;
    @FXML
    Button setting_button;
    @FXML
    Button return_to_button;
    @FXML
    Button type_order_button;
    @FXML
    Button comment_button;
    @FXML
    Button make_items_free_button;
    @FXML
    Button discount_button;
    @FXML
    Button decrease_quantity_button;
    @FXML
    Button increase_quantity_button;
    @FXML
    Label recap_label;
    @FXML
    Label add_label;
    @FXML
    Label price_label;
    @FXML
    Label quantity_label;
    @FXML
    Label image_product_label;
    @FXML
    Label recap_icon;
    @FXML
    Label sizesProductPrice;
    @FXML
    Label sizesProductImage;
    @FXML
    Label sizesProductName;
    @FXML
    HBox header_detail_product_pages;
    @FXML
    HBox header_detail_product_pane;
    @FXML
    HBox groupOptionsPane;
    @FXML
    HBox menu_stepper;
    @FXML
    GridPane detail_pane;
    @FXML
    GridPane optionsPane;
    @FXML
    GridPane options_main_pane;
    @FXML
    GridPane productsFamillePane;
    @FXML
    GridPane footer_pane;
    @FXML
    GridPane return_to_pane;
    @FXML
    GridPane ingredientsPane;
    @FXML
    GridPane ingredientsPane2;
    @FXML
    StackPane subOptionsPane;
    @FXML
    StackPane sizesPane;
    @FXML
    VBox optionTabsPages;
    @FXML
    VBox sizesMainPane;
    @FXML
    GridPane subOptionsMainPane;
    @FXML
    StackPane ingredientsSpecialPane;
    @FXML
    Label ingredientsProductName;
    @FXML
    Label ingredientsProductPrice;
    @FXML
    Label ingredientsProductImage;
    @FXML
    Label ingredientsTitleLabel;
    @FXML
    HBox ingredientsProductSizes;
    @FXML
    HBox infos_product_pane;
    FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private double width;
    private double height;
    private List<ProductInfoExt> itemsAdditionnals;
    private int number_pages_products;
    private int page_product;
    private GridPane[] pane_products_moment;
    private List<Button> buttons_products;
    private List<Double> image_products_height;
    private List<Double> image_products_width;
    private final int MAX_LINE_PRODUCT = 4;
    private final int MAX_COLUMN_PRODUCT = 2;
    private HashMap<Integer, SoftReference> refProducts;
    protected String color_hex = ColorUtils.getColor(AppLocal.color_borne);
    protected String text_color_borne_hex = ColorUtils.getColor(AppLocal.TEXT_COLOR_BORNE);
    private LinkedHashMap<Integer, Button> buttons_options;
    private HashMap<Integer, SoftReference> refOptions;
    private ImagesUtils mImagesUtils;
    private final int MAX_LINE_OPTION = 5;
    private final int MAX_COLUMN_OPTION = 5;
    private Image image_logo;
    private final String BG_SELECTED_OPTION = "bg_casandra_yellow";
    private final String BG_TRANSPARENT = "bg_transparent";
    private ItemService mItemService;
    private String typeOrder;
    private final String SIZE_IMAGE_128 = "_128px";
    private boolean video_exist;
    private Timer timer_garbage;
    private final int TIMER_GARBAGE_COLLECT = 60000;
    private static final String VIDEO_FILE = System.getProperty("user.home") + "\\images\\logos\\" + AppLocal.VIDEO_BORNE;
    @FXML
    private ImageView player_canvas;
    private MediaPlayerFactory mediaPlayerFactory;
    private EmbeddedMediaPlayer embeddedMediaPlayer;
    private AnimationTimer mAnimationTimer;
    private double height_media;
    private String class_size_text_product;
    private String optionsStyle;
    private String class_size_text_options;
    private String class_size_label_call;
    private DrivePopUpOptionController popupOptionsController;
    private PopUpPropagationManager popUpPropagationManager;
    private Function<Integer, Integer> hidePopup;
    private String hexColorBorne;
    private HashMap<Integer, SoftReference> refIngredients;
    private ProductSizeInfo selectedSizeInfo;
    private List<ProductSizeInfo> listSizes;
    private int currentPage = 1;
    private int totalPage;
    public static final int PAGE_SIZE = 4;
    private List<TicketLineInfo> lines;
    private BiborneVideoPlayerController biborneVideoPlayerController;

    @Override
    public void init(double width, double height) {
        System.out.println("+++++++++ drive initiated");
        try {
            File check_video;
            Font.loadFont((InputStream)this.getClass().getResourceAsStream("/fonts/Namaku.ttf"), (double)12.0);
            this.stack_pane.getStyleClass().add((Object)"drive-root");
            this.lines = new ArrayList<TicketLineInfo>();
            this.hexColorBorne = ColorUtils.getColor(AppLocal.color_borne);
            this.pane_parent.getChildren().clear();
            this.pane_parent.add((Node)this.stack_pane_logo, 0, 0);
            this.pane_logo.setAlignment(Pos.BOTTOM_CENTER);
            this.width = width;
            this.height = height;
            this.height_media = height;
            System.out.println("++++******************************* width drive : " + width);
            System.out.println("++++******************************* height drive : " + height);
            if (width <= 720.0 && height <= 1280.0) {
                this.class_size_text_product = "text-size-15";
                this.optionsStyle = "text-size-14,text_gray";
                this.class_size_text_options = "text-size-10";
                this.class_size_label_call = "text-size-35";
            } else {
                this.class_size_text_product = "text-size-16";
                this.optionsStyle = "text-size-14,text_gray";
                this.class_size_text_options = "text-size-12";
                this.class_size_label_call = "text-size-45";
            }
            this.label_call.getStyleClass().add((Object)this.class_size_label_call);
            this.image_products_width = new ArrayList<Double>();
            this.image_products_height = new ArrayList<Double>();
            this.buttons_products = new ArrayList<Button>();
            this.buttons_options = new LinkedHashMap();
            this.refProducts = new HashMap();
            this.refIngredients = new HashMap();
            this.mImagesUtils = new ImagesUtils();
            this.refOptions = new HashMap();
            this.mItemService = ItemService.getInstance();
            this.basket_products.setCellFactory((Callback)new Callback<ListView<DriveHBoxBorne>, ListCell<DriveHBoxBorne>>(){

                public DriveBasketListBorne call(ListView<DriveHBoxBorne> listView) {
                    return new DriveBasketListBorne();
                }
            });
            this.basket_products.setCellFactory((Callback)new Callback<ListView<DriveHBoxBorne>, ListCell<DriveHBoxBorne>>(){

                public DriveBasketListBorne call(ListView<DriveHBoxBorne> listView) {
                    return new DriveBasketListBorne();
                }
            });
            this.itemsAdditionnals = this.mItemService.getAdditionnalProducts(this.typeOrder);
            this.label_title.setText("OFFRE DU MOMENT");
            this.label_title.setTextAlignment(TextAlignment.CENTER);
            if (AppLocal.TYPE_MEDIA_HOME != null && AppLocal.TYPE_MEDIA_HOME.equalsIgnoreCase("Video") && (check_video = new File(new File(System.getProperty("user.home")), "images/logos/" + AppLocal.VIDEO_BORNE)).exists()) {
                this.video_exist = true;
            }
            if (this.video_exist) {
                this.pane_logo.getChildren().clear();
                this.pane_logo.add((Node)this.stack_pane_video, 0, 0);
                this.loadFirstView();
            } else {
                this.pane_logo.getChildren().clear();
                this.pane_logo.add((Node)this.label_image, 0, 0);
                this.loadPhotos();
            }
            if (AppLocal.HIDE_DRIVE_SCREEN_VOICE_MESSAGE_PANE || this.video_exist) {
                this.pane_call.setVisible(false);
                this.pane_call.setManaged(false);
            } else {
                this.label_call.setStyle("-fx-background-color: " + this.color_hex + "; -fx-text-fill: white; -fx-border-radius: 15; -fx-background-radius: 15;");
            }
            this.initializePopUpController();
            this.main_pane_basket_products.setStyle("-fx-background-color: " + this.color_hex + ";");
            this.setBannersImagesViews();
        }
        catch (BasicException ex) {
            Logger.getLogger(DualScreenDriveControllerNew.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initializePopUpController() {
        this.hidePopup = value -> {
            this.pane_parent.setEffect(null);
            this.options_main_pane.setVisible(false);
            this.options_main_pane.setManaged(false);
            this.ingredientsSpecialPane.setVisible(false);
            this.ingredientsSpecialPane.setManaged(false);
            this.sizesPane.setVisible(false);
            this.sizesPane.setManaged(false);
            this.pane_parent.setVisible(true);
            this.pane_parent.setManaged(true);
            this.listSizes = null;
            this.selectedSizeInfo = null;
            if (this.video_exist && AppLocal.SHOW_DRIVE_BASKET_ONLY_BY_CLICK) {
                this.startVideoPlayer();
            }
            return 0;
        };
        this.popupOptionsController = new DrivePopUpOptionController();
        this.popupOptionsController.initView(this.getPopupViewInitializerDto());
        this.popUpPropagationManager = new PopUpPropagationManager(this.popupOptionsController);
    }

    private void setBannersImagesViews() {
        File file;
        String path = AppLocal.DRIVE_BASKET_BANNER_IMG;
        if (path != null && !path.isEmpty() && (file = this.m_FilerUtils.getFileFullPath("images/logos/" + path)) != null && file.exists()) {
            Image image = new Image(file.toURI().toString());
            this.headerBannerImage.setImage(image);
            this.headerBannerImage.setPreserveRatio(true);
            this.headerBannerImage.setSmooth(true);
            this.headerBannerImage.setCache(true);
        }
    }

    @Override
    public void loadPanier(TicketInfo order, List<TicketLineInfo> lines, String total, String typeOrder) {
        if (!AppLocal.SHOW_DRIVE_BASKET_ONLY_BY_CLICK) {
            Platform.runLater(() -> this.showBasket(order));
        }
    }

    public void showBasket(TicketInfo order) {
        System.out.println("+++++++++ drive cart");
        List<TicketLineInfo> detailOrder = order.getLines();
        String totalOrder = order.printTotal();
        if (this.video_exist) {
            this.stopVideoPlayer();
        }
        if (detailOrder != null && !detailOrder.isEmpty()) {
            this.currentPage = 1;
            this.lines.clear();
            this.lines.addAll(detailOrder);
            this.totalPage = detailOrder.size() > 4 ? (int)Math.ceil((double)detailOrder.size() / 4.0) : 1;
            this.pane_parent.getChildren().clear();
            this.pane_parent.add((Node)this.main_pane_basket_products, 0, 0);
            this.label_total_order.setText(totalOrder);
            this.painTicketLines();
        } else {
            this.reloadPhoto(true);
        }
    }

    @Override
    public void reloadView(String typeOrder) {
        System.out.println("+++++++++ drive reload");
        this.reloadPhoto(false);
    }

    public void loadProducts(List<ProductInfoExt> products, double width, double height, int max_column_products, int max_line_products, GridPane paneParent) {
        System.out.println("+++++++++ drive load products");
        this.buttons_products.clear();
        double width_product = width / (double)max_column_products;
        double height_product = height / (double)max_line_products;
        this.image_products_height.clear();
        this.image_products_width.clear();
        for (ProductInfoExt product : products) {
            if (product.getImageProduct() == null || product.getImageProduct().isEmpty()) continue;
            Button btnProdcut = new Button();
            btnProdcut.setPrefWidth(width_product);
            btnProdcut.setPrefHeight(height_product);
            btnProdcut.setStyle("-fx-background-color: #ffffff;");
            try {
                this.addImageProduct(btnProdcut, product);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            this.buttons_products.add(btnProdcut);
        }
        double height_button = height_product;
        double width_button = width_product;
        double height_products = height;
        int buttons_of_line = (int)(width / width_button);
        buttons_of_line = buttons_of_line > max_column_products ? max_column_products : buttons_of_line;
        double max_lines = (int)Math.round(height_products / height_button);
        this.number_pages_products = (int)Math.ceil((double)this.buttons_products.size() / (max_lines * (double)buttons_of_line));
        this.pane_products_moment = new GridPane[this.number_pages_products];
        for (int i = 0; i < this.number_pages_products; ++i) {
            this.pane_products_moment[i] = new GridPane();
            this.pane_products_moment[i].setVgap(10.0);
            this.pane_products_moment[i].setHgap(10.0);
            this.pane_products_moment[i].setAlignment(Pos.CENTER);
            this.pane_products_moment[i].getStyleClass().add((Object)"bg_transparent");
        }
        int index_product = 0;
        int column_product = 0;
        int row_product = 0;
        for (Button buttonItem : this.buttons_products) {
            this.pane_products_moment[index_product].add((Node)buttonItem, column_product, row_product);
            if (column_product < buttons_of_line - 1) {
                ++column_product;
                continue;
            }
            if ((double)row_product < max_lines - 1.0) {
                ++row_product;
                column_product = 0;
                continue;
            }
            ++index_product;
            row_product = 0;
            column_product = 0;
        }
        paneParent.getChildren().clear();
        if (this.number_pages_products > 0) {
            this.page_product = 0;
            paneParent.add((Node)this.pane_products_moment[this.page_product], 0, 0);
        }
    }

    private double getHeight_Product() {
        return this.height * 0.9 * 0.9;
    }

    private double getWidth_Product() {
        return this.width * 0.7;
    }

    private void addImageProduct(Button btnProduct, ProductInfoExt product) {
        System.out.println("+++++++++ drive add image");
        boolean existImage = false;
        GridPane paneProduct = new GridPane();
        paneProduct.setPrefHeight(btnProduct.getPrefHeight());
        paneProduct.setPrefWidth(btnProduct.getPrefWidth());
        double heightImage = AppLocal.HIDE_NAME_PRODUCTS ? btnProduct.getPrefHeight() * 0.7 : btnProduct.getPrefHeight() * 0.6;
        double heightName = btnProduct.getPrefHeight() * 0.3;
        double widthImage = btnProduct.getPrefWidth() * 0.65;
        Label priceProduct = new Label(Formats.CURRENCY.formatValue(product.getPriceSell()));
        priceProduct.setStyle("-fx-font-size: 12pt; -fx-text-fill: #ffffff; -fx-border-color: transparent; -fx-background-color: #feca57;");
        priceProduct.setAlignment(Pos.CENTER);
        priceProduct.setPrefWidth(widthImage * 0.4);
        priceProduct.setPrefHeight(heightImage * 0.15);
        Label nameProduct = new Label(product.getName());
        nameProduct.setAlignment(Pos.CENTER);
        nameProduct.setTextAlignment(TextAlignment.CENTER);
        nameProduct.setPrefWidth(paneProduct.getPrefWidth());
        nameProduct.getStyleClass().add((Object)this.class_size_text_product);
        nameProduct.getStyleClass().add((Object)"text-black");
        nameProduct.setWrapText(true);
        Image image_product_moment = this.getImageProduct(product);
        if (image_product_moment != null) {
            ImageView iv2 = new ImageView();
            iv2.setImage(image_product_moment);
            iv2.setFitHeight(heightImage);
            iv2.setPreserveRatio(true);
            iv2.setSmooth(true);
            iv2.setCache(true);
            Label labelImage = new Label();
            labelImage.setAlignment(Pos.CENTER);
            labelImage.setGraphic((Node)iv2);
            labelImage.setPrefWidth(btnProduct.getPrefWidth());
            nameProduct.setPrefHeight(heightName);
            GridPane pane_bottom_price = new GridPane();
            pane_bottom_price.setPrefWidth(btnProduct.getPrefWidth());
            pane_bottom_price.setPrefHeight(btnProduct.getPrefHeight() * 0.1);
            pane_bottom_price.setAlignment(Pos.BOTTOM_CENTER);
            pane_bottom_price.add((Node)priceProduct, 0, 0);
            int row = 0;
            paneProduct.add((Node)labelImage, 0, row++);
            if (!AppLocal.HIDE_NAME_PRODUCTS) {
                labelImage.setPrefHeight(btnProduct.getPrefHeight() * 0.6);
                paneProduct.add((Node)nameProduct, 0, row++);
            } else {
                labelImage.setPrefHeight(btnProduct.getPrefHeight() * 0.85);
            }
            paneProduct.add((Node)pane_bottom_price, 0, row);
            btnProduct.setGraphic((Node)paneProduct);
            this.image_products_height.add(iv2.getBoundsInLocal().getHeight());
            this.image_products_width.add(iv2.getBoundsInLocal().getWidth());
            existImage = true;
        }
        if (!existImage) {
            paneProduct.setAlignment(Pos.CENTER);
            GridPane panePrice = new GridPane();
            panePrice.setPrefWidth(nameProduct.getPrefWidth());
            panePrice.setPrefHeight(btnProduct.getPrefHeight() * 0.1);
            panePrice.setAlignment(Pos.CENTER);
            panePrice.add((Node)priceProduct, 0, 0);
            nameProduct.setPrefHeight(btnProduct.getPrefHeight() * 0.9);
            paneProduct.add((Node)nameProduct, 0, 0);
            paneProduct.add((Node)panePrice, 0, 1);
            btnProduct.setGraphic((Node)paneProduct);
        }
        btnProduct.getStyleClass().add((Object)"bg-white");
    }

    private Image getImageProduct(ProductInfoExt product) {
        System.out.println("+++++++++ drive get image");
        Image image_product = null;
        File image = null;
        if (this.refProducts.containsKey(product.getID()) && this.refProducts.get(product.getID()) != null) {
            image_product = (Image)this.refProducts.get(product.getID()).get();
        }
        if (image_product == null) {
            if (product.getImageProduct() != null) {
                image = this.m_FilerUtils.getFileFullPath("images/products/" + product.getImageProduct());
            }
            if (image != null && image.exists()) {
                image_product = new Image(image.toURI().toString());
                if (!this.refProducts.containsKey(product.getID())) {
                    this.refProducts.put(product.getID(), new SoftReference<Image>(image_product));
                } else if (this.refProducts.get(product.getID()) == null) {
                    this.refProducts.replace(product.getID(), new SoftReference<Image>(image_product));
                }
            }
        }
        return image_product;
    }

    @Override
    public void loadAdditionnals(String typeOrder) {
    }

    private void loadPhotos() {
        System.out.println("+++++++++ drive load photos");
        try {
            File image_file;
            Image image_home = null;
            List<PhotoDispaly> imgs = AppLocal.dlSales.getHomeBornePhoto();
            if (!imgs.isEmpty() && (image_file = this.m_FilerUtils.getFileFullPath("images/photosBorne/" + imgs.get(0).getPath())).exists()) {
                image_home = new Image(image_file.toURI().toString());
                System.out.println("++++++++++++++++ image_home" + image_home);
            }
            this.setImageHome(image_home, this.logo, (int)this.height_media, AppLocal.LOGO_BORNE);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void loadMediaFirstPage() {
        if (AppLocal.TYPE_MEDIA_HOME != null && AppLocal.TYPE_MEDIA_HOME.equalsIgnoreCase("Video")) {
            if (this.video_exist) {
                this.startVideoPlayer();
            }
        } else {
            this.loadPhotos();
        }
    }

    public void reloadPhoto(boolean emptyOrder) {
        this.pane_parent.getChildren().clear();
        this.pane_parent.add((Node)this.stack_pane_logo, 0, 0);
        if (this.video_exist && (emptyOrder || AppLocal.SHOW_DRIVE_BASKET_ONLY_BY_CLICK)) {
            System.out.println("+++++ showing menu/video");
            this.startVideoPlayer();
        }
    }

    @Override
    public void setTotal(String textToral) {
    }

    @Override
    public void loadRendu(double total, double paid, double rendu) {
    }

    @Override
    public void hideRendu() {
    }

    @Override
    public void loadMomentsProducts() {
    }

    @Override
    public void loadInfoProduct(ProductInfoExt product, String total_order, String total_product, SupplementProduct goption, List<SupplementProduct> options, List<OptionItemOrder> listOptions) {
    }

    public void loadGridOption(SupplementProduct Goption, List<OptionItemOrder> listOptions) {
        System.out.println("+++++++++ drive grid option");
        double width_pane_options = this.width * 0.9;
        double height_pane_options = this.height * 0.52 * 0.93;
        double width_option = width_pane_options / 5.0;
        double height_option = height_pane_options / 5.0;
        double max_option = 25.0;
        int buttons_of_line = 5;
        int buttons_of_column = 5;
        if (max_option <= 4.0) {
            buttons_of_line = 2;
            buttons_of_column = 2;
        } else if (max_option <= 9.0) {
            buttons_of_line = 3;
            buttons_of_column = 3;
        } else {
            buttons_of_line = 5;
            buttons_of_column = 5;
        }
        this.pane_items_options.getChildren().clear();
        int sizeTotal = Goption.getItems().size();
        if (sizeTotal > 0) {
            this.buttons_options.clear();
            for (SupplementItemInfo optionItem : Goption.getItems()) {
                Image image = this.mImagesUtils.getImageOption(optionItem, this.refOptions, "_128px", true);
                ButtonBoxOptionScreen btnSupplement = new ButtonBoxOptionScreen(Goption, optionItem, width_option, height_option, image, this.class_size_text_options);
                if (this.existOption(optionItem, listOptions) != null) {
                    btnSupplement.getStyleClass().add((Object)"bg_casandra_yellow");
                } else {
                    btnSupplement.getStyleClass().add((Object)"bg_transparent");
                }
                btnSupplement.setWrapText(true);
                this.buttons_options.put(optionItem.getiD(), btnSupplement);
            }
            int column_item = 0;
            int row_item = 0;
            for (Button buttonItem : this.buttons_options.values()) {
                this.pane_items_options.add((Node)buttonItem, column_item, row_item);
                if (column_item < buttons_of_line - 1) {
                    ++column_item;
                    continue;
                }
                if (row_item < buttons_of_column - 1) {
                    ++row_item;
                    column_item = 0;
                    continue;
                }
                row_item = 0;
                column_item = 0;
            }
        }
    }

    public void loadProducts(List<ProductInfoExt> products) {
        this.loadProducts(products, this.getWidth_Product(), this.getHeight_Product(), 2, 4, this.list_products);
    }

    public void loadAdditionalProduct(List<ProductInfoExt> products) {
        double height_additional = this.height * 0.3;
        double width_additional = this.width * 0.8;
        this.loadProducts(products, width_additional, height_additional, 2, 2, this.list_additional_products);
    }

    @Override
    public void selectOption(SupplementItemInfo option) {
        this.popupOptionsController.selectOption(option.getiD());
    }

    @Override
    public void deselectOption(SupplementItemInfo option) {
        this.popupOptionsController.deleteOption(option.getiD());
    }

    @Override
    public void setTotalProduct(String text_total) {
        this.popupOptionsController.setPrice(text_total);
    }

    private OptionItemOrder existOption(SupplementItemInfo optionItem, List<OptionItemOrder> listOptions) {
        System.out.println("+++++++++ drive exists option");
        for (OptionItemOrder optionItemOrder : listOptions) {
            if (optionItemOrder.getIdCarte() != -1 && optionItemOrder.getIdCarte() != 0 || optionItemOrder.getIdProduct() != -1 && optionItemOrder.getIdProduct() != 0 || optionItemOrder.getSupplement() != optionItem.getiD() || optionItemOrder.getParent_supplement_id() != 0) continue;
            return optionItemOrder;
        }
        return null;
    }

    public void loadAdditionals() {
        double height_additional = this.height * 0.15;
        double width_additional = this.width * 0.6;
        this.loadProducts(this.itemsAdditionnals, width_additional, height_additional, 2, 1, this.list_additionals);
    }

    private void loadFirstView() {
        System.out.println("+++++++++ drive first view");
        String javaHome = System.getProperty("java.home");
        System.out.println("++++ javaHome : " + javaHome);
        boolean is64bit = false;
        is64bit = System.getProperty("os.name").contains("Windows") ? System.getenv("ProgramFiles(x86)") != null : System.getProperty("os.arch").indexOf("64") != -1;
        boolean bl = is64bit = is64bit && !javaHome.contains("(x86)");
        if (is64bit) {
            NativeLibrary.addSearchPath((String)RuntimeUtil.getLibVlcLibraryName(), (String)"lib/X64");
        } else {
            NativeLibrary.addSearchPath((String)RuntimeUtil.getLibVlcLibraryName(), (String)"lib/X86");
        }
        this.video_exist = true;
        this.initBiborneVideoPlayer();
        this.timer_garbage = new Timer();
        this.timer_garbage.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                System.gc();
                System.runFinalization();
            }
        }, 0L, 60000L);
    }

    public void startVideoPlayer() {
        this.biborneVideoPlayerController.restart();
    }

    private void setImageHome(Image image_home, ImageView background, double height, String path) {
        File image;
        System.out.println("+++++++++++ AppLocal.LOGO_BORNE : " + AppLocal.LOGO_BORNE);
        System.out.println("+++++++++ path : " + path);
        if (image_home == null && path != null && !path.isEmpty() && (image = new File(new File(System.getProperty("user.home")), "images/logos/" + path)).exists()) {
            image_home = new Image(image.toURI().toString());
        }
        if (image_home != null) {
            System.out.println("++++++++++++image");
            background.setImage(image_home);
            background.setFitHeight(height);
            background.setPreserveRatio(true);
            background.setSmooth(true);
            background.setCache(true);
        } else {
            try {
                Image img_logo = new Image(this.getClass().getResource("/com/openbravo/images/logo_biborne.png").toURI().toString());
                background.setImage(img_logo);
                background.setFitWidth(this.width * 0.7);
                background.setPreserveRatio(true);
                background.setSmooth(true);
                background.setCache(true);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void startTimerVideo() {
        this.mAnimationTimer.start();
    }

    public void toggleOptionsView() {
        if (this.options_main_pane.isVisible()) {
            this.hidePopup.apply(null);
        } else {
            this.showPopup();
        }
    }

    private void showPopup() {
        if (this.selectedSizeInfo == null) {
            this.displayPopUp();
        } else {
            new Thread(){

                @Override
                public void run() {
                    try {
                        4.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        DualScreenDriveControllerNew.this.displayPopUp();
                    }
                }
            }.start();
        }
    }

    private void displayPopUp() {
        this.pane_parent.setEffect(null);
        this.pane_parent.setVisible(false);
        this.pane_parent.setManaged(false);
        this.sizesPane.setVisible(false);
        this.sizesPane.setManaged(false);
        this.options_main_pane.setVisible(true);
        this.options_main_pane.setManaged(true);
        if (this.video_exist) {
            this.stopVideoPlayer();
        }
    }

    public void showSizesPane(ProductInfoExt subProduct, List<ProductSizeInfo> listSizes) {
        this.pane_parent.setEffect((Effect)new BoxBlur(6.0, 6.0, 4));
        this.listSizes = listSizes;
        this.sizesPane.setVisible(true);
        this.sizesPane.setManaged(true);
        Image image = this.mImagesUtils.getImageProduct(subProduct, this.refProducts, "", true);
        ImageView imageItem = new ImageView(image);
        imageItem.setFitHeight(this.height * 0.3);
        imageItem.setPreserveRatio(true);
        imageItem.setSmooth(true);
        this.sizesProductImage.setGraphic((Node)imageItem);
        this.sizesProductName.setText(subProduct.getName());
        this.paintSizes();
    }

    public void paintSizes() {
        this.sizesMainPane.getChildren().clear();
        for (ProductSizeInfo info : this.listSizes) {
            double relativeWidth = this.width * 0.5;
            boolean selected = false;
            if (this.selectedSizeInfo != null) {
                selected = this.selectedSizeInfo.getID() == info.getID();
            }
            double borderWidth = selected ? 0.0 : 1.0;
            String boxBgColor = selected ? this.hexColorBorne : "white";
            HBox hbox = new HBox();
            hbox.setPadding(new Insets(10.0, 20.0, 10.0, 20.0));
            hbox.setSpacing(40.0);
            hbox.setMinHeight(100.0);
            hbox.setMaxHeight(100.0);
            hbox.setStyle("-fx-background-color: " + boxBgColor + "; -fx-font-weight: normal; -fx-border-width: " + borderWidth + "px; -fx-border-radius: 50em; -fx-background-radius: 50em; -fx-border-color: lightgray; -fx-background-border: none; -fx-effect: dropshadow(gaussian, rgba(0,0,0,0.3), 10, 0.0, 0, 4);");
            hbox.setMinWidth(relativeWidth);
            hbox.setMaxWidth(relativeWidth);
            hbox.setAlignment(Pos.CENTER);
            String textFill = selected ? "white" : "black";
            Label contentBox = new Label(StringUtils.CapitalizeFirstLetter(info.getLabel_size().equals("junior") ? "Junior" : info.getLabel_size()));
            contentBox.setWrapText(true);
            contentBox.setAlignment(Pos.CENTER);
            contentBox.setStyle("-fx-text-fill: " + textFill + "; -fx-font-weight: bold; -fx-font-size: 20pt; -fx-background-color: transparent;");
            hbox.getChildren().add((Object)contentBox);
            Label priceBox = new Label(Formats.CURRENCY.formatValue(info.getPrice()));
            priceBox.setWrapText(true);
            priceBox.setAlignment(Pos.CENTER);
            priceBox.setStyle("-fx-text-fill: " + textFill + "; -fx-font-weight: normal; -fx-font-size: 20pt; -fx-background-color: transparent;");
            hbox.getChildren().add((Object)priceBox);
            this.sizesMainPane.getChildren().add((Object)hbox);
        }
    }

    @Override
    public Object propagateClick(String functionName, Object[] args) {
        switch (functionName) {
            case "selectSize": {
                if (this.listSizes == null) break;
                this.selectedSizeInfo = this.listSizes.stream().filter(size -> size.getID() == ((Integer)args[0]).intValue()).findFirst().orElse(null);
                this.paintSizes();
                break;
            }
            case "initializer": {
                this.popupOptionsController.initializer(this.getPopupControllerDto(args));
                if (this.popupOptionsController == null || this.popupOptionsController.isSoldedOut()) break;
                this.showPopup();
                break;
            }
            case "showSizesPane": {
                this.showSizesPane((ProductInfoExt)args[0], (List)args[1]);
                break;
            }
            case "handleClickSwitch": {
                boolean isSoldedOut = (Boolean)args[0];
                if (isSoldedOut) {
                    this.hidePopup.apply(null);
                    break;
                }
                this.showPopup();
                break;
            }
            case "showBasket": {
                this.showBasket((TicketInfo)args[0]);
                break;
            }
            case "close": {
                this.hidePopup.apply(null);
                break;
            }
            case "nextPage": {
                System.out.println("+++++++++ called_next_page");
                return this.nextPage();
            }
            case "previousPage": {
                return this.previousPage();
            }
            default: {
                this.popUpPropagationManager.handlePropagation(functionName, args);
            }
        }
        System.out.println("+++++++++ null_after_called_next_page");
        return null;
    }

    private PopupViewInitializerDto getPopupViewInitializerDto() {
        return new PopupViewInitializerDto(this.close_button, this.previous_detail_header, this.next_detail_header, this.previousOptionTab, this.nextOptionTab, this.valid_product_button, this.setting_button, this.return_to_button, this.recap_label, this.add_label, this.price_label, this.quantity_label, this.image_product_label, this.name_product_label, this.recap_icon, this.header_detail_product_pages, this.header_detail_product_pane, this.optionTabsPages, this.detail_pane, this.optionsPane, this.options_main_pane, this.productsFamillePane, this.footer_pane, this.infos_product_pane, this.return_to_pane, this.type_order_button, this.comment_button, this.ingredientsPane, this.make_items_free_button, this.discount_button, this.decrease_quantity_button, this.increase_quantity_button, this.hidePopup, this.groupOptionsPane, this.width, this.height, this.ingredientsSpecialPane, this.ingredientsProductImage, this.ingredientsProductName, this.ingredientsProductPrice, this.ingredientsProductSizes, this.ingredientsPane2, this.basket_header_box, this.bannerIntermediateImage, this.optionsPaneBanner, this.subOptionsPane, this.subOptionsMainPane, this.menu_stepper, this.name_menu_label, this.pane_parent, this.groupOptionText, this.ingredientsTitleLabel);
    }

    private PopupControllerInitializerDto getPopupControllerDto(Object[] args) {
        return new PopupControllerInitializerDto((Double)args[0], (ProductInfoExt)args[1], (Double)args[2], (List)args[3], (List)args[4], (List)args[5], (Double)args[6], (String)args[7], (String)args[8], (String)args[9], (String)args[10], (List)args[11], (Double)args[12], (String)args[13], (String)args[14], (Integer)args[15], (Boolean)args[16], (String)args[17], (String)args[18], (String)args[19], (Boolean)args[20], (String)args[21], (Boolean)args[22], (Double)args[23], (DataLogicSales)args[24], (DataLogicItems)args[25], this.refProducts, this.refOptions, this.refIngredients);
    }

    public boolean nextPage() {
        boolean hasNext = false;
        if (this.currentPage + 1 <= this.totalPage) {
            ++this.currentPage;
            Platform.runLater(() -> this.painTicketLines());
            hasNext = this.currentPage < this.totalPage;
        }
        return hasNext;
    }

    public boolean previousPage() {
        boolean hasPrevious = false;
        if (this.currentPage - 1 >= 1) {
            --this.currentPage;
            this.painTicketLines();
            hasPrevious = this.currentPage > 1;
        }
        return hasPrevious;
    }

    private void painTicketLines() {
        int currentPageIndex = this.currentPage - 1;
        int startAt = currentPageIndex * 4;
        int endAt = (currentPageIndex + 1) * 4;
        int trueEndAt = Math.min(endAt, this.lines.size());
        this.basket_products.getItems().clear();
        List<TicketLineInfo> sub = this.lines.subList(startAt, trueEndAt);
        ArrayList<DriveHBoxBorne> list = new ArrayList<DriveHBoxBorne>();
        for (TicketLineInfo line : sub) {
            if (line.isNext()) continue;
            DriveHBoxBorne componentLine = new DriveHBoxBorne(line, this.class_size_text_product, this.optionsStyle, this.width);
            list.add(componentLine);
        }
        ObservableList observableList = FXCollections.observableArrayList();
        observableList.setAll(list);
        this.basket_products.setItems(observableList);
        this.pagination_label.setText(this.currentPage + " / " + this.totalPage);
    }

    private void initBiborneVideoPlayer() {
        this.biborneVideoPlayerController = new BiborneVideoPlayerController(ScreenUtil.getSecondaryScreenBounds(), message -> {
            if ("video_touched".equals(message)) {
                System.out.println("++++++++++ video_touched");
            }
        });
        this.biborneVideoPlayerController.play(VIDEO_FILE);
    }

    public void stopVideoPlayer() {
        this.biborneVideoPlayerController.stop();
    }
}

