/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.HBoxCell;
import com.openbravo.controllers.IDualScreenController;
import com.openbravo.events.CustomBasketListCell;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javax.swing.Timer;

public class DualScreenController
implements IDualScreenController {
    @FXML
    ImageView logo;
    @FXML
    ListView listView;
    @FXML
    Label label_total;
    @FXML
    GridPane list_products;
    @FXML
    GridPane pane_slide;
    @FXML
    GridPane pane_product_moment;
    @FXML
    Label label_image;
    @FXML
    Label label_title;
    @FXML
    GridPane pane_right;
    @FXML
    GridPane pane_basket;
    @FXML
    GridPane pane_rendu;
    @FXML
    Label label_total_order;
    @FXML
    Label label_paid;
    @FXML
    Label label_rendu;
    @FXML
    Label info_version;
    @FXML
    GridPane pane_footer;
    @FXML
    GridPane pane_parent;
    @FXML
    GridPane pane_left;
    @FXML
    GridPane pane_footer_products;
    @FXML
    FlowPane button_products_panier;
    @FXML
    Label label_call;
    @FXML
    GridPane pane_info_products;
    private List<PhotoDispaly> list;
    Map<Integer, Image> maps_photos = new HashMap<Integer, Image>();
    private Timer time_load_photos;
    int x = 0;
    FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private double width;
    private double height;
    private ObservableList observableList;
    private List<HBoxCell> m_listItems;
    private List<ProductInfoExt> moment_products;
    private List<ProductInfoExt> itemsAdditionnals;
    private int number_pages_products;
    private int page_product;
    private GridPane[] pane_products;
    private List<Button> buttons_products;
    private List<Double> image_products_height;
    private List<Double> image_products_width;
    private final int MAX_LINE_PRODUCT = 2;
    private final int MAX_COLUMN_PRODUCT = 2;
    private HashMap<Integer, SoftReference> refProducts;
    private boolean load_images = true;
    private boolean load_moment = false;
    private String typeOrder;
    private ItemService mItemService;

    @Override
    public void init(double width, double height) {
        try {
            this.width = width;
            this.height = height;
            this.image_products_width = new ArrayList<Double>();
            this.image_products_height = new ArrayList<Double>();
            this.buttons_products = new ArrayList<Button>();
            this.refProducts = new HashMap();
            this.observableList = FXCollections.observableArrayList();
            this.m_listItems = new ArrayList<HBoxCell>();
            this.listView.setCellFactory(listView -> new CustomBasketListCell());
            this.list = AppLocal.dlSales.getAllPhoto();
            this.pane_right.getChildren().clear();
            this.pane_right.add((Node)this.pane_basket, 0, 0);
            this.label_total.setText("Bonjour");
            if (AppLocal.HIDE_NAME_APP) {
                this.pane_footer.getChildren().clear();
            }
            this.info_version.setText(" 10.0.1.27");
            this.mItemService = ItemService.getInstance();
            this.moment_products = this.mItemService.getMomentProducts(null);
            this.itemsAdditionnals = this.mItemService.getAdditionnalProducts(this.typeOrder);
            this.loadPhotos();
        }
        catch (BasicException ex) {
            Logger.getLogger(DualScreenController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadMomentProduct() {
        this.load_moment = true;
        if (this.moment_products.size() > 0) {
            this.label_title.setText("Les produits du moment");
            this.pane_slide.getChildren().clear();
            this.pane_slide.add((Node)this.pane_product_moment, 0, 0);
            this.loadProducts(this.moment_products, this.typeOrder);
        }
    }

    private void SetImageSize(int i) {
        PhotoDispaly mPhotoDispaly = this.list.get(i);
        Image image_pub = null;
        double widthImage = this.width * 0.7 * 0.9;
        double heightImage = this.height * 0.8;
        if (this.maps_photos.containsKey(mPhotoDispaly.getId())) {
            image_pub = this.maps_photos.get(mPhotoDispaly.getId());
        } else {
            File image = this.m_FilerUtils.getFileFullPath("images/photosDisplay/" + mPhotoDispaly.getPath());
            if (image.exists()) {
                try {
                    image_pub = new Image(image.toURI().toString());
                    this.maps_photos.put(mPhotoDispaly.getId(), image_pub);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }
        if (image_pub != null) {
            this.logo.setImage(image_pub);
            this.logo.setFitWidth(widthImage);
            this.logo.setPreserveRatio(true);
            this.logo.setSmooth(true);
            this.logo.setCache(true);
        }
    }

    @Override
    public void loadPanier(TicketInfo order, List<TicketLineInfo> lines, String total, String typeOrder) {
        this.typeOrder = typeOrder;
        if (!this.load_moment) {
            this.loadMomentProduct();
        }
        List<TicketLineInfo> detailOrder = null;
        String totalOrder = null;
        boolean displayBasket = false;
        if (order != null) {
            detailOrder = order.getLines();
            totalOrder = order.printTotal();
            displayBasket = true;
        } else if (lines != null) {
            detailOrder = lines;
            totalOrder = total;
            displayBasket = true;
        }
        if (displayBasket) {
            this.clearPanier();
            for (TicketLineInfo line : detailOrder) {
                HBoxCell componentLine = new HBoxCell(line, this.width * 0.3 - 60.0);
                this.m_listItems.add(componentLine);
            }
            this.observableList.setAll(this.m_listItems);
            this.listView.setItems(this.observableList);
            this.label_total.setText("Total : " + totalOrder);
        }
    }

    @Override
    public void reloadView(String typeOrder) {
        this.clearPanier();
        this.reloadPhoto(typeOrder);
    }

    private void clearPanier() {
        if (this.listView.getItems().isEmpty()) {
            this.listView.getItems().clear();
        }
        if (!this.m_listItems.isEmpty()) {
            this.m_listItems.clear();
        }
        if (!this.observableList.isEmpty()) {
            this.observableList.clear();
        }
        this.label_total.setText("Bonjour");
    }

    public void loadProducts(List<ProductInfoExt> products, String typeOrder) {
        System.out.println("++++++++++++++ load moment 3");
        this.buttons_products.clear();
        double width_product = this.getWidth_Product() / 2.0;
        double height_product = this.getHeight_Product() / 2.0;
        this.image_products_height.clear();
        this.image_products_width.clear();
        for (ProductInfoExt product : products) {
            if (product.getImageProduct() == null || product.getImageProduct().isEmpty()) continue;
            double price_product = this.mItemService.getPriceProductByType(product, typeOrder, true);
            Button btnProdcut = new Button();
            btnProdcut.setPrefWidth(width_product);
            btnProdcut.setPrefHeight(height_product);
            btnProdcut.setStyle("-fx-background-color: #ffffff;");
            try {
                this.addImageProduct(btnProdcut, product, price_product);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            this.buttons_products.add(btnProdcut);
        }
        double height_button = height_product;
        double width_button = width_product;
        if (this.image_products_height.size() > 0) {
            height_button = this.grand_diemnsion(this.image_products_height) / 0.75;
            height_button = height_button < this.getMinHeightProduct() ? this.getMinHeightProduct() : height_button;
            for (Button buttonItem : this.buttons_products) {
                buttonItem.setPrefHeight(height_button);
            }
        }
        double height_products = this.getHeight_Product();
        int buttons_of_line = (int)(this.getWidth_Product() / width_button);
        buttons_of_line = buttons_of_line > 2 ? 2 : buttons_of_line;
        double max_lines = (int)Math.round(height_products / height_button);
        this.number_pages_products = (int)Math.ceil((double)this.buttons_products.size() / (max_lines * (double)buttons_of_line));
        this.pane_products = new GridPane[this.number_pages_products];
        for (int i = 0; i < this.number_pages_products; ++i) {
            this.pane_products[i] = new GridPane();
            this.pane_products[i].setVgap(2.0);
            this.pane_products[i].setHgap(2.0);
            this.pane_products[i].setAlignment(Pos.CENTER);
            this.pane_products[i].getStyleClass().add((Object)"bg-white");
        }
        int index_product = 0;
        int column_product = 0;
        int row_product = 0;
        for (Button buttonItem : this.buttons_products) {
            this.pane_products[index_product].add((Node)buttonItem, column_product, row_product);
            if (column_product < buttons_of_line - 1) {
                ++column_product;
                continue;
            }
            if ((double)row_product < max_lines - 1.0) {
                ++row_product;
                column_product = 0;
                continue;
            }
            ++index_product;
            row_product = 0;
            column_product = 0;
        }
        this.list_products.getChildren().clear();
        if (this.number_pages_products > 0) {
            this.page_product = 0;
            this.list_products.add((Node)this.pane_products[this.page_product], 0, 0);
        }
        if (this.time_load_photos != null) {
            this.time_load_photos.stop();
        }
    }

    private double getHeight_Product() {
        return this.height * 0.9 * 0.9;
    }

    private double getWidth_Product() {
        return this.width * 0.7;
    }

    private void addImageProduct(Button btnProduct, ProductInfoExt product, double price_product) {
        boolean existImage = false;
        GridPane paneProduct = new GridPane();
        paneProduct.setPrefHeight(btnProduct.getPrefHeight());
        paneProduct.setPrefWidth(btnProduct.getPrefWidth());
        double heightImage = AppLocal.HIDE_NAME_PRODUCTS ? btnProduct.getPrefHeight() : btnProduct.getPrefHeight() * 0.75;
        double heightName = btnProduct.getPrefHeight() * 0.25;
        double widthImage = btnProduct.getPrefWidth() * 0.8;
        Label priceProduct = new Label(Formats.CURRENCY.formatValue(price_product));
        priceProduct.setStyle("-fx-font-size: 12pt; -fx-text-fill: #1bbc9b; -fx-border-color: transparent; -fx-background-color: transparent;");
        priceProduct.setAlignment(Pos.CENTER);
        priceProduct.setPrefWidth(widthImage * 0.4);
        priceProduct.setPrefHeight(heightImage * 0.2);
        Label nameProduct = new Label(product.getName());
        nameProduct.setAlignment(Pos.CENTER);
        nameProduct.setTextAlignment(TextAlignment.CENTER);
        nameProduct.setPrefWidth(paneProduct.getPrefWidth());
        nameProduct.setStyle("-fx-text-fill: #000000;");
        Image image_product = this.getImageProduct(product);
        if (image_product != null) {
            ImageView iv2 = new ImageView();
            iv2.setImage(image_product);
            iv2.setFitWidth(widthImage);
            iv2.setPreserveRatio(true);
            iv2.setSmooth(true);
            iv2.setCache(true);
            Label labelImage = new Label();
            labelImage.setAlignment(Pos.CENTER);
            labelImage.setGraphic((Node)iv2);
            labelImage.setPrefHeight(heightImage);
            labelImage.setPrefWidth(btnProduct.getPrefWidth());
            nameProduct.setPrefHeight(heightName);
            GridPane panePrice = new GridPane();
            panePrice.setPrefWidth(labelImage.getPrefWidth());
            panePrice.setPrefHeight(labelImage.getPrefHeight());
            panePrice.setAlignment(Pos.BOTTOM_RIGHT);
            GridPane pane_bottom_price = new GridPane();
            pane_bottom_price.setPrefWidth(iv2.getBoundsInLocal().getWidth());
            pane_bottom_price.setPrefHeight(labelImage.getPrefHeight() * 0.2);
            pane_bottom_price.setAlignment(Pos.BOTTOM_RIGHT);
            pane_bottom_price.add((Node)priceProduct, 0, 0);
            panePrice.add((Node)pane_bottom_price, 0, 0);
            StackPane stackPane = new StackPane();
            stackPane.setPrefWidth(labelImage.getPrefWidth());
            stackPane.setPrefHeight(labelImage.getPrefHeight());
            stackPane.getChildren().add((Object)labelImage);
            stackPane.getChildren().add((Object)panePrice);
            paneProduct.add((Node)stackPane, 0, 0);
            if (!AppLocal.HIDE_NAME_PRODUCTS) {
                paneProduct.add((Node)nameProduct, 0, 1);
            }
            btnProduct.setGraphic((Node)paneProduct);
            this.image_products_height.add(iv2.getBoundsInLocal().getHeight());
            this.image_products_width.add(iv2.getBoundsInLocal().getWidth());
            existImage = true;
        }
        if (!existImage) {
            paneProduct.setAlignment(Pos.CENTER);
            GridPane panePrice = new GridPane();
            panePrice.setPrefWidth(nameProduct.getPrefWidth());
            panePrice.setPrefHeight(btnProduct.getPrefHeight() * 0.1);
            panePrice.setAlignment(Pos.CENTER);
            panePrice.add((Node)priceProduct, 0, 0);
            nameProduct.setPrefHeight(btnProduct.getPrefHeight() * 0.9);
            paneProduct.add((Node)nameProduct, 0, 0);
            paneProduct.add((Node)panePrice, 0, 1);
            btnProduct.setGraphic((Node)paneProduct);
        }
    }

    private double grand_diemnsion(List<Double> dimension) {
        double max = dimension.get(0);
        for (Double image_height : dimension) {
            if (!(max < image_height)) continue;
            max = image_height;
        }
        return max;
    }

    private double getMinWidthProduct() {
        return this.getWidth_Product() / 2.0;
    }

    private double getMinHeightProduct() {
        return this.getHeight_Product() / 2.0;
    }

    private Image getImageProduct(ProductInfoExt product) {
        Image image_product = null;
        File image = null;
        if (this.refProducts.containsKey(product.getID()) && this.refProducts.get(product.getID()) != null) {
            image_product = (Image)this.refProducts.get(product.getID()).get();
        }
        if (image_product == null) {
            if (product.getImageProduct() != null) {
                image = this.m_FilerUtils.getFileFullPath("images/products/" + product.getImageProduct());
            }
            if (image != null && image.exists()) {
                image_product = new Image(image.toURI().toString());
                if (!this.refProducts.containsKey(product.getID())) {
                    this.refProducts.put(product.getID(), new SoftReference<Image>(image_product));
                } else if (this.refProducts.get(product.getID()) == null) {
                    this.refProducts.replace(product.getID(), new SoftReference<Image>(image_product));
                }
            }
        }
        return image_product;
    }

    private void loadImagePub() {
        this.load_images = true;
        if (this.list.size() > 0) {
            System.out.println("++++++++++++++++++*************************** list.size() ============================***************************************************: " + this.list.size());
            this.SetImageSize(this.list.size() - 1);
            int time = AppLocal.timeSlide;
            if (time == 0) {
                time = 5;
            }
            if (this.list.size() > 1) {
                if (this.time_load_photos == null) {
                    this.time_load_photos = new Timer(time * 1000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                DualScreenController.this.SetImageSize(DualScreenController.this.x);
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                            ++DualScreenController.this.x;
                            if (DualScreenController.this.x >= DualScreenController.this.list.size()) {
                                DualScreenController.this.x = 0;
                            }
                        }
                    });
                }
                this.time_load_photos.start();
            }
        }
    }

    @Override
    public void loadAdditionnals(String typeOrder) {
        System.out.println("++++++++++++++ itemsAdditionnals : " + this.itemsAdditionnals.size());
        if (this.itemsAdditionnals.size() > 0) {
            this.pane_slide.getChildren().clear();
            this.pane_slide.add((Node)this.pane_product_moment, 0, 0);
            this.label_title.setText("Un petit dessert?");
            this.loadProducts(this.itemsAdditionnals, typeOrder);
        }
    }

    public void loadPhotos() {
        this.load_moment = false;
        this.pane_slide.getChildren().clear();
        if (this.moment_products.size() > 0) {
            this.loadMomentProduct();
        } else if (this.list.size() > 0) {
            this.pane_slide.add((Node)this.label_image, 0, 0);
            this.loadImagePub();
        } else {
            FilerUtils m_FilerUtils = FilerUtils.getInstance();
            AppConfig appConfig = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
            String path = appConfig.getProperty("main.path");
            File image = m_FilerUtils.getFileFullPath("images/logos/" + path);
            Image img_logo = new Image(image.toURI().toString());
            System.out.println("+++++++++++++++++++++++URL LOGO MAIN " + img_logo.getUrl());
            if (img_logo != null) {
                this.label_image.setAlignment(Pos.CENTER_RIGHT);
                this.pane_slide.add((Node)this.label_image, 0, 0);
                this.logo.setImage(img_logo);
                this.logo.setFitHeight(img_logo.getHeight());
                this.logo.setFitWidth(img_logo.getWidth());
                System.out.println("+++++++++++printed");
            }
        }
    }

    public void reloadPhoto(String typeOrder) {
        this.typeOrder = typeOrder;
        this.load_moment = false;
        this.pane_slide.getChildren().clear();
        if (this.list.size() > 0) {
            this.pane_slide.add((Node)this.label_image, 0, 0);
            if (this.load_images) {
                this.loadImagePub();
            }
        } else if (this.moment_products.size() > 0) {
            this.loadMomentProduct();
        }
    }

    @Override
    public void loadRendu(double total, double paid, double rendu) {
        this.label_total_order.setText(Formats.CURRENCY.formatValue(total));
        this.label_paid.setText(Formats.CURRENCY.formatValue(paid));
        this.label_rendu.setText(Formats.CURRENCY.formatValue(rendu));
        this.pane_right.getChildren().clear();
        this.pane_right.add((Node)this.pane_rendu, 0, 0);
    }

    @Override
    public void hideRendu() {
        this.pane_right.getChildren().clear();
        this.pane_right.add((Node)this.pane_basket, 0, 0);
    }

    @Override
    public void setTotal(String textToral) {
        this.label_total.setText(textToral);
    }

    @Override
    public void loadMomentsProducts() {
    }

    @Override
    public void loadInfoProduct(ProductInfoExt product, String total_order, String total_product, SupplementProduct goption, List<SupplementProduct> options, List<OptionItemOrder> listOptions) {
    }

    @Override
    public void selectOption(SupplementItemInfo option) {
    }

    @Override
    public void deselectOption(SupplementItemInfo option) {
    }

    @Override
    public void setTotalProduct(String text_total) {
    }
}

