/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.DriveGroupOptionsHeaderButton;
import com.openbravo.components.DriveHeaderDetailProductButton;
import com.openbravo.components.DriveIngredientDetailButton;
import com.openbravo.components.DriveOptionDetailButton;
import com.openbravo.components.DriveProductFamilleButton;
import com.openbravo.components.DriveSubSupplementsController;
import com.openbravo.components.OptionDetailProductTab;
import com.openbravo.components.TypeOrderPopUp;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.drive.shared.PopupControllerInitializerDto;
import com.openbravo.drive.shared.PopupViewInitializerDto;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.CarteOrderInfo;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.DetailProductError;
import com.openbravo.pos.ticket.DetailProductResult;
import com.openbravo.pos.ticket.GroupSubSupplementInfo;
import com.openbravo.pos.ticket.ItemOrderInfo;
import com.openbravo.pos.ticket.OptionItemOrder;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.ticket.ProductTicket;
import com.openbravo.pos.ticket.SubSupplementResult;
import com.openbravo.pos.ticket.SupplementItemInfo;
import com.openbravo.pos.ticket.SupplementProduct;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.ImagesUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.ItemService;
import java.awt.Color;
import java.lang.ref.SoftReference;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.BoxBlur;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class DrivePopUpOptionController {
    @FXML
    Button close_button;
    @FXML
    Button previous_detail_header;
    @FXML
    Button next_detail_header;
    @FXML
    Button previousOptionTab;
    @FXML
    Button nextOptionTab;
    @FXML
    Button valid_product_button;
    @FXML
    Button setting_button;
    @FXML
    Button return_to_button;
    @FXML
    Button type_order_button;
    @FXML
    Button comment_button;
    @FXML
    Button make_items_free_button;
    @FXML
    Button discount_button;
    @FXML
    Button decrease_quantity_button;
    @FXML
    Button increase_quantity_button;
    @FXML
    Label recap_label;
    @FXML
    Label add_label;
    @FXML
    Label price_label;
    @FXML
    Label quantity_label;
    @FXML
    Label image_product_label;
    @FXML
    Label recap_icon;
    @FXML
    TextFlow name_product_label;
    @FXML
    TextFlow name_menu_label;
    @FXML
    HBox header_detail_product_pages;
    @FXML
    HBox header_detail_product_pane;
    @FXML
    HBox groupOptionsPane;
    @FXML
    HBox menu_stepper;
    @FXML
    GridPane detail_pane;
    @FXML
    GridPane optionsPane;
    @FXML
    GridPane options_main_pane;
    @FXML
    GridPane productsFamillePane;
    @FXML
    GridPane footer_pane;
    @FXML
    GridPane return_to_pane;
    @FXML
    GridPane ingredientsPane;
    @FXML
    GridPane ingredientsPane2;
    @FXML
    GridPane pane_parent;
    @FXML
    StackPane basket_header_box;
    @FXML
    StackPane optionsPaneBanner;
    @FXML
    ImageView bannerIntermediateImage;
    @FXML
    TextFlow groupOptionText;
    @FXML
    StackPane subOptionsPane;
    @FXML
    VBox optionTabsPages;
    @FXML
    GridPane subOptionsMainPane;
    @FXML
    StackPane ingredientsSpecialPane;
    @FXML
    Label ingredientsProductName;
    @FXML
    Label ingredientsProductPrice;
    @FXML
    Label ingredientsProductImage;
    @FXML
    Label ingredientsTitleLabel;
    @FXML
    HBox infos_product_pane;
    private DetailProductResult detailProductResult;
    private List<OptionItemOrder> listChoiceSupplement;
    private List<ItemOrderInfo> listChoiceIngredient;
    private List<ProductTicket> listProducts;
    private double multiply;
    private List<SupplementProduct> options;
    private List<SupplementProduct> optionsDB;
    private String unit;
    private List<CarteOrderInfo> groupProductsDB;
    private List<CarteOrderInfo> groupProducts;
    private double priceSell;
    private double discountValue;
    private String labelDiscount;
    private String noteValue;
    private String name_sizeProduct;
    private List<TicketLineInfo> listLinesTmp;
    private TicketLineInfo lineTmp;
    private int indexLine;
    private String type_line;
    private String time_served;
    private String type_order;
    private String typeDiscount;
    private ProductInfoExt product;
    private List<SupplementItemInfo> ingredients;
    private List<ProductInfoExt> subProducts;
    private ImagesUtils mImagesUtils;
    private String typeDisplay;
    private double discountOrder;
    private String typeDiscountOrder;
    private boolean update_product;
    private double old_multiply;
    private List<DriveHeaderDetailProductButton> groupTabs;
    public static final String STR_INGREDIENTS = "ingredients";
    public static final String STR_SUB_PRODUCT = "sub_product";
    public static final String STR_GROUP_PRODUCTS = "group_products";
    public static final String STR_OPTIONS = "options";
    public static final String STR_ITEM_INGREDIENT = "item_ingredient";
    private List<List<DriveHeaderDetailProductButton>> headerButtonsArray;
    private final List<DriveHeaderDetailProductButton> stepperButtons = new ArrayList<DriveHeaderDetailProductButton>();
    private int numberPageDetailProductHeader;
    private final int NUMBER_DETAIL_PRODUCT_TAB = 4;
    private int page_detail_product_header;
    private int numberPageIngredients;
    private int NUMBER_COLUMN_INGREDIENT = 4;
    private int NUMBER_ROW_INGREDIENT = 2;
    private int MAX_INGREDIENTS_PER_PAGE = 19;
    private int MAX_INGREDIENTS;
    private int page_ingredients;
    private HashMap<Integer, List<DriveIngredientDetailButton>> map_ingredients;
    private Image imagePreviousItemProduct;
    private Image imageNextItemProduct;
    private Image imageRemovedIngredient;
    private List<List<DriveGroupOptionsHeaderButton>> optionTabsArray;
    private int numberPageOptionsTabs;
    private final int MAX_OPTIONS_TABS_PER_PAGE = 7;
    private int MAX_OPTIONS_TABS;
    private int page_options_tabs;
    private HashMap<Integer, LinkedHashMap<Integer, DriveOptionDetailButton>> map_options;
    private int NUMBER_COLUMN_OPTION = 4;
    private int NUMBER_ROW_OPTION = 4;
    private int page_options;
    private int MAX_OPTIONS_PER_PAGE = 16;
    private int MAX_OPTIONS;
    private int numberPageOptions;
    private Button nextItemOptionButton;
    private Button previousItemOptionButton;
    private List<DriveGroupOptionsHeaderButton> groupOptionTabs;
    private Image imageDefaultItemOption;
    private boolean makeItemFree;
    private LinkedHashMap<Integer, DriveOptionDetailButton> itemOptionsButton;
    private boolean next_option;
    private final String BUTTON_OPTION = "button_option";
    private TypeOrderPopUp typeOrderPopUp;
    private Image imageTakeAwayLine;
    private Image imageDineInLine;
    private final String styleTakeAway = "-fx-background-color: #00AFD5; -fx-background-radius: 0px 0px 11px 11px; -fx-text-fill: white;";
    private String styleDineIn = "-fx-background-color: #C77F24; -fx-background-radius: 0px 0px 11px 11px; -fx-text-fill: white;";
    private final int NUMBER_COLUMN_PRODUCT_FAMILLE = 3;
    private final int NUMBER_ROW_PRODUCT_FAMILLE = 3;
    private final int MAX_PRODUCT_FAMILLE_PER_PAGE = 9;
    private int MAX_PRODUCT_FAMILLE;
    private HashMap<Integer, LinkedHashMap<Integer, DriveProductFamilleButton>> map_products_famille;
    private LinkedHashMap<Integer, DriveProductFamilleButton> productsFamilleButtons;
    private int numberPageProductsFamille;
    private Button nextProductFamilleButton;
    private Button previousProductFamilleButton;
    private int page_products_famille;
    private final String styleProductFamille = "-fx-border-color: #FFFFFF1E; -fx-border-radius: 16px; -fx-background-color: #FFFFFF14;  -fx-background-radius: 16px;";
    private double heightIngredientsPane;
    private double heightOptionsPane;
    private ItemService mItemService;
    private double priceProduct;
    public boolean productValid;
    private final String styleMakeFreeItem = "-fx-font-size: 12px;-fx-text-fill: white;-fx-background-radius: 0px 0px 11px 11px;-fx-background-color:  linear-gradient(to bottom, rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), linear-gradient(to bottom, rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), rgba(149, 111, 248, 0.50);";
    private final String styleMakeFreeItemSelected = "-fx-font-size: 12px;-fx-text-fill: white;-fx-background-radius: 0px 0px 11px 11px;-fx-background-color: #0B8871;";
    private Function<Integer, Integer> hidePopup;
    private DataLogicSales dlSales;
    private DataLogicItems dlItems;
    private List<DriveIngredientDetailButton> ingredientsButtons;
    private List<DriveOptionDetailButton> optionsButtons;
    private double screenWidth;
    private double screenHeight;
    private String hexColorBorne;
    private static final int MAX_MENU_STEPS = 3;
    private CategoryInfo category;
    private int menuCurrentStep = 1;
    private String currentSubProductName;
    private HashMap<Integer, SoftReference> refProducts;
    private HashMap<Integer, SoftReference> refIngredients;
    private HashMap<Integer, SoftReference> refOptions;
    private HBox optionsPrevNextButtons;
    private DriveSubSupplementsController subSupplementsController;

    public void initializer(PopupControllerInitializerDto dto) {
        try {
            this.refProducts = dto.refProducts;
            this.refIngredients = dto.refIngredients;
            this.refOptions = dto.refOptions;
            this.refIngredients = dto.refIngredients;
            this.hexColorBorne = ColorUtils.getColor(AppLocal.color_borne);
            this.ingredientsButtons = new ArrayList<DriveIngredientDetailButton>();
            this.optionsButtons = new ArrayList<DriveOptionDetailButton>();
            this.dlItems = dto.dlItems;
            this.dlSales = dto.dlSales;
            this.detailProductResult = new DetailProductResult();
            this.priceSell = dto.price;
            this.priceProduct = dto.priceProduct;
            this.product = dto.product;
            this.unit = this.product != null ? this.product.getUnit() : "piece";
            this.old_multiply = this.multiply = this.unit != null && this.unit.equals("poids") ? dto.quantity * 1000.0 : dto.quantity;
            this.type_line = dto.type_line;
            this.time_served = dto.time_served;
            this.type_order = dto.typeCommande;
            if (this.type_line == null) {
                this.type_line = this.type_order;
            }
            this.listLinesTmp = dto.lines;
            this.lineTmp = new TicketLineInfo();
            this.lineTmp.setNameProduct(this.product.getName());
            this.indexLine = dto.indexLine;
            if (this.indexLine == this.listLinesTmp.size()) {
                this.listLinesTmp.add(this.lineTmp);
            }
            this.discountOrder = dto.discountOrder;
            this.typeDiscountOrder = dto.typeDiscount;
            this.discountValue = dto.discountVal;
            this.name_sizeProduct = dto.name_sizeProduct;
            this.labelDiscount = dto.labelDiscount;
            this.typeDiscount = dto.type_discount;
            this.noteValue = dto.noteVal;
            this.listChoiceSupplement = dto.listOptions;
            this.listChoiceIngredient = dto.listIngredients;
            this.listProducts = dto.listItems;
            this.typeDisplay = dto.typeDisplay;
            this.update_product = dto.update_product;
            this.ingredients = this.product.getIngredients();
            this.optionsDB = this.product.getSupplements();
            this.mItemService = ItemService.getInstance();
            this.subProducts = new ArrayList<ProductInfoExt>();
            this.groupProducts = new ArrayList<CarteOrderInfo>();
            this.options = new ArrayList<SupplementProduct>();
            this.setButtonsIcons();
            this.setInfoBanner();
            this.getDetailProduct();
            this.loadHeaderButtons();
            this.setOptionsOfSubProducts();
            this.setFooterStyle();
        }
        catch (BasicException | URISyntaxException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void initView(PopupViewInitializerDto dto) {
        this.screenHeight = dto.screenHeight;
        this.screenWidth = dto.screenWidth;
        this.ingredientsPane = dto.ingredientsPane;
        this.close_button = dto.close_button;
        this.previous_detail_header = dto.previous_detail_header;
        this.next_detail_header = dto.next_detail_header;
        this.previousOptionTab = dto.previousOptionTab;
        this.nextOptionTab = dto.nextOptionTab;
        this.valid_product_button = dto.valid_product_button;
        this.setting_button = dto.setting_button;
        this.return_to_button = dto.return_to_button;
        this.recap_label = dto.recap_label;
        this.add_label = dto.add_label;
        this.price_label = dto.price_label;
        this.quantity_label = dto.quantity_label;
        this.image_product_label = dto.image_product_label;
        this.name_product_label = dto.name_product_label;
        this.recap_icon = dto.recap_icon;
        this.header_detail_product_pages = dto.header_detail_product_pages;
        this.header_detail_product_pane = dto.header_detail_product_pane;
        this.optionTabsPages = dto.optionTabsPages;
        this.detail_pane = dto.detail_pane;
        this.optionsPane = dto.optionsPane;
        this.options_main_pane = dto.options_main_pane;
        this.productsFamillePane = dto.productsFamillePane;
        this.footer_pane = dto.footer_pane;
        this.infos_product_pane = dto.infos_product_pane;
        this.return_to_pane = dto.return_to_pane;
        this.type_order_button = dto.type_order_button;
        this.comment_button = dto.comment_button;
        this.make_items_free_button = dto.make_items_free_button;
        this.discount_button = dto.discount_button;
        this.decrease_quantity_button = dto.decrease_quantity_button;
        this.increase_quantity_button = dto.increase_quantity_button;
        this.hidePopup = dto.hidePopup;
        this.groupOptionsPane = dto.groupOptionsPane;
        this.ingredientsSpecialPane = dto.ingredientsSpecialPane;
        this.ingredientsProductImage = dto.ingredientsProductImage;
        this.ingredientsProductName = dto.ingredientsProductName;
        this.ingredientsProductPrice = dto.ingredientsProductPrice;
        this.ingredientsPane2 = dto.ingredientsPane2;
        this.basket_header_box = dto.basket_header_box;
        this.bannerIntermediateImage = dto.bannerIntermediateImage;
        this.optionsPaneBanner = dto.optionsPaneBanner;
        this.subOptionsPane = dto.subOptionsPane;
        this.subOptionsMainPane = dto.subOptionsMainPane;
        this.menu_stepper = dto.menu_stepper;
        this.name_menu_label = dto.name_menu_label;
        this.pane_parent = dto.pane_parent;
        this.groupOptionText = dto.groupOptionText;
        this.ingredientsTitleLabel = dto.ingredientsTitleLabel;
    }

    public void close() {
        this.detailProductResult = null;
        this.hidePopup.apply(null);
    }

    public void printMultiply() {
        if (this.multiply == (double)Math.round(this.multiply)) {
            this.quantity_label.setText("Quantit\u00e9 " + Formats.INT.formatValue(this.multiply));
        } else {
            this.quantity_label.setText("Quantit\u00e9 " + Formats.DOUBLE.formatValue(this.multiply));
        }
    }

    public void setFooterStyle() {
        this.footer_pane.setStyle("-fx-background-color: " + this.hexColorBorne + "; -fx-background-radius: 40 40 0 0; -fx-border-radius: 40 40 0 0;");
    }

    public void increaseQuantity() {
        boolean higher_price;
        double quantity_tmp = this.multiply + 1.0;
        double compare_price = this.update_product ? (quantity_tmp - this.old_multiply) * this.product.getPrice_point() : quantity_tmp * this.product.getPrice_point();
        boolean bl = higher_price = this.product.isUse_points() && (AppLocal.currentCustomerLoyalty == null || AppLocal.currentCustomerLoyalty != null && AppLocal.currentCustomerLoyalty.getPoints() < compare_price);
        if (!higher_price) {
            this.multiply += 1.0;
            this.printMultiply();
            this.price_label.setText(this.printPriceSell());
            this.displayScreen();
        }
    }

    public void decreaseQuantity() {
        if (this.multiply > 1.0) {
            this.multiply -= 1.0;
            this.printMultiply();
            this.price_label.setText(this.printPriceSell());
            this.displayScreen();
        }
    }

    public String printPriceSell() {
        double quantity = this.unit != null && this.unit.equals("poids") ? this.multiply / 1000.0 : this.multiply;
        double discount = this.typeDiscount != null && this.typeDiscount.equals("somme") ? this.discountValue : this.discountValue * this.priceSell / 100.0 * quantity;
        double price = this.priceSell * quantity - discount;
        return Formats.CURRENCY.formatValue(price);
    }

    public String printTotal() {
        return Formats.CURRENCY.formatValue(this.getTotal());
    }

    private void displayScreen() {
        if (this.typeDisplay != null && this.typeDisplay.equals("window")) {
            this.prepareLines();
            AppLocal.displayDualScreen.sendOrder(null, this.listLinesTmp, this.printTotal(), this.type_order);
        } else if (this.typeDisplay != null && this.typeDisplay.equals("window_drive")) {
            AppLocal.displayDualScreen.setTotalProduct(this.printPriceSell());
        }
    }

    public double getTotal() {
        return TicketInfo.computeTotal(this.listLinesTmp, this.typeDiscountOrder, this.discountOrder);
    }

    public void prepareLines() {
        this.lineTmp.setListSupplements(this.listChoiceSupplement);
        this.lineTmp.setListIngredients(this.listChoiceIngredient);
        this.lineTmp.setMultiply(this.multiply);
        this.lineTmp.setPrice(this.priceSell);
        this.lineTmp.setListProducts(this.listProducts);
        this.lineTmp.setDiscount(this.discountValue);
        this.lineTmp.setNote(this.noteValue);
        this.lineTmp.setLabelDiscount(this.labelDiscount);
        this.lineTmp.setType_discount(this.typeDiscount);
        this.listLinesTmp.set(this.indexLine, this.lineTmp);
    }

    public DetailProductResult getResult() {
        if (this.detailProductResult != null) {
            this.detailProductResult.setListChoiceIngredient(this.listChoiceIngredient);
            this.detailProductResult.setListChoiceSupplement(this.listChoiceSupplement);
            this.detailProductResult.setMultiply(this.unit.equals("poids") ? this.multiply / 1000.0 : this.multiply);
            this.detailProductResult.setPriceSell(this.priceSell);
            this.detailProductResult.setListProducts(this.listProducts);
            this.detailProductResult.setDiscountValue(this.discountValue);
            this.detailProductResult.setNoteValue(this.noteValue);
            this.detailProductResult.setLabelDiscount(this.labelDiscount);
            this.detailProductResult.setType_line(this.type_line);
            this.detailProductResult.setTime_served(this.time_served);
            this.detailProductResult.setTypeDiscount(this.typeDiscount);
        }
        return this.detailProductResult;
    }

    private void calculFreeAfterDelete(DriveOptionDetailButton buttonOption) {
        int id_group_products;
        CarteOrderInfo group_products = buttonOption.getGroupProducts();
        ProductInfoExt subProduct = buttonOption.getSubProduct();
        SupplementProduct option = buttonOption.getGroupOption();
        int n = id_group_products = group_products != null ? group_products.getId() : -1;
        int index_group_products = group_products != null ? group_products.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        this.calculFreeAfterDelete(option, id_sub_product, id_group_products, index_group_products);
    }

    private void calculFreeAfterDelete(SupplementProduct option, int id_product, int id_carte, int index_carte) {
        if (this.isOptionFreeable(option)) {
            for (OptionItemOrder supplement : this.listChoiceSupplement) {
                if (supplement.getId_groupe_option() != option.getiD() || supplement.getIdCarte() != id_carte || supplement.getIdProduct() != id_product || supplement.getIndex_carte() != index_carte || supplement.getNumber_free() >= supplement.getNumberOption() || !(supplement.getPrice() > 0.0)) continue;
                int free_possible = option.getOption_free() - option.getOption_free_tmp();
                int free = free_possible > supplement.getNumberOption() - supplement.getNumber_free() ? supplement.getNumberOption() - supplement.getNumber_free() : free_possible;
                double price_option = supplement.getPrice() - supplement.getPrice() / (double)(supplement.getNumberOption() - supplement.getNumber_free());
                supplement.setNumber_free(supplement.getNumber_free() + free);
                supplement.setPrice(price_option, supplement.getNumberOption() - supplement.getNumber_free());
                DriveOptionDetailButton buttonOption = null;
                for (LinkedHashMap<Integer, DriveOptionDetailButton> listButtons : this.map_options.values()) {
                    if (listButtons.get(supplement.getSupplement()) == null) continue;
                    buttonOption = listButtons.get(supplement.getSupplement());
                    break;
                }
                if (buttonOption != null) {
                    // empty if block
                }
                this.decrementOptionFree(option, free);
            }
            this.setPriceTotal();
        }
    }

    private boolean isOptionFreeable(SupplementProduct groupeOption) {
        return groupeOption.getOption_free() > groupeOption.getOption_free_tmp();
    }

    private void decrementOptionFree(SupplementProduct groupOption) {
        this.decrementOptionFree(groupOption, 1);
    }

    private void incrementOptionFree(SupplementProduct groupOption, int number_free) {
        groupOption.setOption_free_tmp(groupOption.getOption_free_tmp() - number_free);
    }

    private void decrementOptionFree(SupplementProduct groupOption, int number_free) {
        groupOption.setOption_free_tmp(groupOption.getOption_free_tmp() + number_free);
    }

    public String getColor(SupplementItemInfo option, SupplementProduct gOption) {
        if (option != null && option.getColor() != null && !option.getColor().isEmpty()) {
            return this.getColor(option.getColor());
        }
        if (gOption.getColor() != null && !gOption.getColor().isEmpty()) {
            return this.getColor(gOption.getColor());
        }
        return null;
    }

    public String getColor(String color_option) {
        Object hex = null;
        if (color_option != null && !color_option.isEmpty()) {
            String[] tabColor = color_option.split(",");
            Color color = new Color(Integer.parseInt(tabColor[0]), Integer.parseInt(tabColor[1]), Integer.parseInt(tabColor[2]));
            hex = Integer.toHexString(color.getRGB() & 0xFFFFFF);
            if (((String)hex).length() < 6) {
                int length = 6 - ((String)hex).length();
                for (int h = 0; h < length; ++h) {
                    hex = "0" + (String)hex;
                }
            }
            hex = "#" + (String)hex;
        }
        return hex;
    }

    private void setButtonsIcons() throws URISyntaxException {
        this.imagePreviousItemProduct = new Image("/images/backward-arrow-grayed.png");
        this.imageNextItemProduct = new Image("/images/forward-arrows.png");
    }

    private void setInfoBanner() {
        this.mImagesUtils = new ImagesUtils();
        Platform.runLater(() -> {
            Image image = this.mImagesUtils.getImageProduct(this.product, this.refProducts, "", true);
            if (image != null) {
                ImageView imageItem = new ImageView(image);
                imageItem.setFitWidth(this.infos_product_pane.getWidth() * 0.38);
                imageItem.setPreserveRatio(true);
                imageItem.setSmooth(false);
                this.image_product_label.setGraphic((Node)imageItem);
            }
        });
        int numberItems = this.getNumberItems();
        this.quantity_label.setText("Quantit\u00e9 " + numberItems);
        this.setProductName(List.of("\n" + this.product.getName().toUpperCase()));
        this.price_label.setText(this.printPriceSell());
        this.setMenuLabelText("");
        this.menu_stepper.getChildren().clear();
    }

    private void getDetailProduct() throws BasicException {
        this.options.clear();
        for (SupplementProduct option : this.optionsDB) {
            if (!option.getItems().isEmpty()) continue;
            option.reloadInfoSize(this.name_sizeProduct);
            List<SupplementItemInfo> optionsItem = option.isOrder_name() ? this.dlItems.getSuppelementsItemOrderAlpha(option.getiD()) : this.dlItems.getSuppelementsItem(option.getiD(), true);
            ArrayList<SupplementItemInfo> optionsItemToAdd = new ArrayList<SupplementItemInfo>();
            if (optionsItem == null || optionsItem.isEmpty()) continue;
            for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
                if (option.getiD() != optionItemOrder.getId_groupe_option()) continue;
                option.setOption_free_tmp(option.getOption_free_tmp() + optionItemOrder.getNumber_free());
            }
            for (SupplementItemInfo item : optionsItem) {
                double price_option = item.getPriceOption(this.name_sizeProduct, this.type_order);
                if (this.product.isMany_size() && item.isMany_size() && price_option == -1.0) continue;
                item.setPrice_order(price_option);
                for (GroupSubSupplementInfo group_sub_item : item.getGroupsSubSupplement()) {
                    for (SupplementItemInfo sub_item : group_sub_item.getSupplements()) {
                        sub_item.setPrice_order(sub_item.getPriceOption(this.name_sizeProduct, this.type_order));
                    }
                }
                optionsItemToAdd.add(item);
            }
            option.setItems(optionsItemToAdd);
            this.options.add(option);
        }
        this.groupProductsDB = this.product.getCartes();
        this.groupProducts.clear();
        for (CarteOrderInfo carteDB : this.groupProductsDB) {
            for (int i = 0; i < carteDB.getNumber_carte(); ++i) {
                List<ProductInfoExt> itemsPlat;
                CarteOrderInfo carte = new CarteOrderInfo(carteDB.getId(), carteDB.getName(), carteDB.getSizeCarte(), carteDB.getOrderCarte(), carteDB.getNumber_carte());
                carte.setIndex_carte(i + 1);
                if (carteDB.getNumber_carte() > 1) {
                    carte.setName(carteDB.getName() + " " + (i + 1));
                }
                if ((itemsPlat = this.dlSales.getProductsByPlat(carteDB.getId(), true)).isEmpty()) continue;
                carte.setItems(itemsPlat);
                this.groupProducts.add(carte);
            }
        }
        if (this.product.getSub_products() != null && !this.product.getSub_products().isEmpty()) {
            this.loadSubProduct(this.product);
        }
    }

    private void loadSubProduct(ProductInfoExt product) {
        this.subProducts.clear();
        for (ProductInfoExt sub_product : product.getSub_products()) {
            ProductInfoExt new_sub_product = (ProductInfoExt)sub_product.clone();
            new_sub_product.setIndex_sub_product(1);
            this.subProducts.add(new_sub_product);
        }
    }

    private void loadHeaderButtons() {
        double heightDetailProductPane = this.screenHeight * 0.08;
        int buttonsCount = (this.ingredients.isEmpty() ? 0 : 1) + (this.subProducts.isEmpty() ? 0 : this.subProducts.size()) + (this.groupProducts.isEmpty() ? 0 : this.groupProducts.size()) + (this.options.isEmpty() ? 0 : 1);
        this.header_detail_product_pages.getChildren().clear();
        double widthDetailProductPane = this.screenWidth * 0.9;
        this.header_detail_product_pages.getChildren().add((Object)this.header_detail_product_pane);
        double widthDetailProductTab = widthDetailProductPane / (double)Math.min(buttonsCount, 4);
        this.header_detail_product_pane.setPrefWidth(widthDetailProductPane);
        this.groupTabs = new ArrayList<DriveHeaderDetailProductButton>();
        DriveHeaderDetailProductButton firstButton = null;
        int index = 1;
        if (!this.ingredients.isEmpty()) {
            DriveHeaderDetailProductButton ingredientButton = new DriveHeaderDetailProductButton(STR_INGREDIENTS, null, index++, widthDetailProductTab, heightDetailProductPane * 0.9);
            this.groupTabs.add(ingredientButton);
            if (firstButton == null && this.options.isEmpty() && this.subProducts.isEmpty() && this.groupProducts.isEmpty()) {
                firstButton = ingredientButton;
            }
        }
        if (!this.subProducts.isEmpty()) {
            for (ProductInfoExt sub_product : this.subProducts) {
                DriveHeaderDetailProductButton subProductButton = new DriveHeaderDetailProductButton(STR_SUB_PRODUCT, sub_product, index++, widthDetailProductTab, heightDetailProductPane * 0.9);
                this.groupTabs.add(subProductButton);
                if (firstButton != null || !this.options.isEmpty() || !this.groupProducts.isEmpty()) continue;
                firstButton = subProductButton;
            }
        }
        if (!this.groupProducts.isEmpty()) {
            for (CarteOrderInfo groupProduct : this.groupProducts) {
                DriveHeaderDetailProductButton groupProductButton = new DriveHeaderDetailProductButton(STR_GROUP_PRODUCTS, groupProduct, index++, widthDetailProductTab, heightDetailProductPane * 0.9);
                this.groupTabs.add(groupProductButton);
                if (firstButton != null) continue;
                firstButton = groupProductButton;
            }
        }
        if (!this.options.isEmpty()) {
            DriveHeaderDetailProductButton optionsButton = new DriveHeaderDetailProductButton(STR_OPTIONS, null, index++, widthDetailProductTab, heightDetailProductPane * 0.9);
            this.groupTabs.add(optionsButton);
            if (this.groupProducts.isEmpty()) {
                firstButton = optionsButton;
            }
        }
        if (buttonsCount > 0) {
            this.numberPageDetailProductHeader = (int)Math.ceil((double)this.groupTabs.size() / 4.0);
            boolean areNotGroups = this.groupTabs.stream().allMatch(btn -> !Objects.equals(STR_GROUP_PRODUCTS, btn.getGroup_type()));
            this.headerButtonsArray = new ArrayList<List<DriveHeaderDetailProductButton>>();
            for (int i = 0; i < this.numberPageDetailProductHeader; ++i) {
                ArrayList<DriveHeaderDetailProductButton> sub = new ArrayList<DriveHeaderDetailProductButton>();
                int startIndex = i * 4;
                int endIndex = (i + 1) * 4;
                int trueEndIndex = Math.min(endIndex, this.groupTabs.size());
                for (int j = startIndex; j < trueEndIndex; ++j) {
                    DriveHeaderDetailProductButton headerButton = this.groupTabs.get(j);
                    int startOrEnd = 2;
                    if (this.groupTabs.size() == 1) {
                        startOrEnd = 0;
                    } else {
                        if (j == startIndex) {
                            startOrEnd = -1;
                        }
                        if (j == trueEndIndex - 1) {
                            startOrEnd = 1;
                        }
                    }
                    headerButton.setView(startOrEnd, areNotGroups);
                    sub.add(headerButton);
                }
                if (sub.isEmpty()) continue;
                this.headerButtonsArray.add(sub);
            }
            if (this.numberPageDetailProductHeader > 0) {
                if (firstButton != null) {
                    this.page_detail_product_header = this.getPageHeaderTab(firstButton);
                }
                if (this.page_detail_product_header >= this.numberPageDetailProductHeader) {
                    this.page_detail_product_header = 0;
                }
                this.header_detail_product_pane.getChildren().clear();
                this.header_detail_product_pane.getChildren().addAll((Collection)this.headerButtonsArray.get(this.page_detail_product_header));
                this.loadHeaderTab(firstButton);
            }
        }
    }

    public int getPageHeaderTab(DriveHeaderDetailProductButton firstButton) {
        int index = firstButton.getIndex();
        int page = (int)Math.ceil((double)index / 4.0);
        return --page;
    }

    public void nextHeaderTab() {
        if (this.page_detail_product_header < this.numberPageDetailProductHeader - 1) {
            ++this.page_detail_product_header;
            this.header_detail_product_pane.getChildren().clear();
            this.header_detail_product_pane.getChildren().addAll((Collection)this.headerButtonsArray.get(this.page_detail_product_header));
            if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                // empty if block
            }
        }
    }

    public void previousHeaderTab() {
        if (this.page_detail_product_header > 0) {
            --this.page_detail_product_header;
            this.header_detail_product_pane.getChildren().clear();
            this.header_detail_product_pane.getChildren().addAll((Collection)this.headerButtonsArray.get(this.page_detail_product_header));
            if (this.page_detail_product_header == 0) {
                // empty if block
            }
        }
    }

    private void deselectHeaderTabs(int currentButtonIndex) {
        for (DriveHeaderDetailProductButton headerButton : this.groupTabs) {
            headerButton.deselect(currentButtonIndex);
        }
    }

    private void selectHeaderTab(DriveHeaderDetailProductButton headerButton) {
        headerButton.select();
        this.updateMenuStepper(headerButton.getIndex(), headerButton.getContent());
    }

    public void handleIngredientsAction() {
        DriveHeaderDetailProductButton btn = this.getGroupTabBtn(STR_INGREDIENTS, null);
        this.deselectHeaderTabs(btn.getIndex());
        this.selectHeaderTab(btn);
        this.loadIngredients();
    }

    public void handleOptionsAction() {
        DriveHeaderDetailProductButton btn = this.getGroupTabBtn(STR_OPTIONS, null);
        this.deselectHeaderTabs(btn.getIndex());
        this.selectHeaderTab(btn);
        this.loadOptionsTabs_Product();
    }

    public void handleGroupProductsAction(CarteOrderInfo groupProducts, int index) {
        DriveHeaderDetailProductButton btn = this.getGroupTabBtn(STR_GROUP_PRODUCTS, index);
        this.deselectHeaderTabs(btn.getIndex());
        this.selectHeaderTab(btn);
        this.loadProductsFamille(groupProducts);
    }

    public void handleSubProductsAction(ProductInfoExt subProduct, int index) {
        System.out.println("subProduct handleSubProductsAction : " + subProduct.getName());
        DriveHeaderDetailProductButton btn = this.getGroupTabBtn(STR_SUB_PRODUCT, index);
        this.deselectHeaderTabs(btn.getIndex());
        this.selectHeaderTab(btn);
        this.loadDetailSubProduct(subProduct);
    }

    private void loadIngredients(CarteOrderInfo groupProducts, ProductInfoExt subProduct) {
        this.preparePane(subProduct);
        this.options_main_pane.setEffect((Effect)new BoxBlur(6.0, 6.0, 4));
        if (this.map_ingredients == null) {
            this.map_ingredients = new HashMap();
        }
        this.map_ingredients.clear();
        double widthIngredientsPane = this.screenWidth;
        double widthIngredient = widthIngredientsPane / (double)this.NUMBER_COLUMN_INGREDIENT;
        double heightIngredient = this.heightIngredientsPane / (double)this.NUMBER_ROW_INGREDIENT;
        int index = 0;
        int index_map = 0;
        ArrayList<SupplementItemInfo> ingredientItems = new ArrayList<SupplementItemInfo>();
        if (subProduct != null) {
            if (subProduct.getIngredients() != null) {
                ingredientItems.addAll(subProduct.getIngredients());
            }
        } else {
            ingredientItems.addAll(this.ingredients);
        }
        ArrayList<DriveIngredientDetailButton> itemIngredientsButton = new ArrayList<DriveIngredientDetailButton>();
        this.numberPageIngredients = (int)Math.ceil((double)ingredientItems.size() / (double)this.MAX_INGREDIENTS_PER_PAGE);
        this.MAX_INGREDIENTS = this.numberPageIngredients > 1 ? this.MAX_INGREDIENTS_PER_PAGE - 1 : this.MAX_INGREDIENTS_PER_PAGE;
        for (SupplementItemInfo ingredient : ingredientItems) {
            boolean removed = this.indexIngredientRemovedIfExist(groupProducts, subProduct, ingredient) != -1;
            Image imageIngredient = this.mImagesUtils.getImageIngredients(ingredient, this.refIngredients, "", true);
            if (imageIngredient == null) {
                imageIngredient = this.imageDefaultItemOption;
            }
            DriveIngredientDetailButton ingredientButton = new DriveIngredientDetailButton(groupProducts, subProduct, ingredient, heightIngredient, widthIngredient, imageIngredient, this.imageRemovedIngredient, removed);
            this.ingredientsButtons.add(ingredientButton);
            if (index < this.MAX_INGREDIENTS) {
                itemIngredientsButton.add(ingredientButton);
            } else {
                this.map_ingredients.put(index_map, itemIngredientsButton);
                itemIngredientsButton = new ArrayList();
                itemIngredientsButton.add(ingredientButton);
                ++index_map;
                index = 0;
            }
            ++index;
        }
        if (!itemIngredientsButton.isEmpty()) {
            this.map_ingredients.put(index_map, itemIngredientsButton);
        }
        this.page_ingredients = 0;
        this.loadPageIngredients(this.page_ingredients);
    }

    private void loadPageIngredients(int page_ingredients) {
        this.ingredientsPane2.getChildren().clear();
        List<DriveIngredientDetailButton> ingredientsButton = this.map_ingredients.get(page_ingredients);
        if (ingredientsButton != null && !ingredientsButton.isEmpty()) {
            this.ingredientsTitleLabel.setManaged(true);
            this.ingredientsTitleLabel.setVisible(true);
            if (!this.ingredientsPane2.isVisible()) {
                this.ingredientsPane2.setManaged(true);
                this.ingredientsPane2.setVisible(true);
            }
            int numberOfRows = ingredientsButton.size() / this.NUMBER_COLUMN_INGREDIENT;
            if (ingredientsButton.size() % this.NUMBER_COLUMN_INGREDIENT > 0) {
                ++numberOfRows;
            }
            System.out.println("+++ numberOfRows: " + numberOfRows);
            for (int i = 0; i < numberOfRows; ++i) {
                HBox box = new HBox();
                box.setAlignment(Pos.CENTER);
                box.setSpacing(20.0);
                int startIndex = i * this.NUMBER_COLUMN_INGREDIENT;
                int endIndex = (i + 1) * this.NUMBER_COLUMN_INGREDIENT;
                int trueEndIndex = Math.min(endIndex, ingredientsButton.size());
                box.getChildren().addAll(ingredientsButton.subList(startIndex, trueEndIndex));
                this.ingredientsPane2.add((Node)box, 0, i);
            }
        } else {
            this.ingredientsPane2.setVisible(false);
            this.ingredientsPane2.setManaged(false);
            this.ingredientsTitleLabel.setVisible(false);
            this.ingredientsTitleLabel.setManaged(false);
        }
    }

    public void nextIngredient() {
        if (this.page_ingredients < this.numberPageIngredients - 1) {
            ++this.page_ingredients;
            this.loadPageIngredients(this.page_ingredients);
        }
    }

    public void previousIngredient() {
        if (this.page_ingredients > 0) {
            --this.page_ingredients;
            this.loadPageIngredients(this.page_ingredients);
        }
    }

    public void prevNextIngredientAction(boolean nextIngredient) {
        if (nextIngredient) {
            this.nextIngredient();
        } else {
            this.previousIngredient();
        }
    }

    public void addRemovedIngredient(int idIngredient) {
        DriveIngredientDetailButton btnIngredient = this.getIngredientButton(idIngredient);
        if (btnIngredient == null) {
            return;
        }
        this.addRemovedIngredient(btnIngredient);
    }

    public void addRemovedIngredient(DriveIngredientDetailButton btnIngredient) {
        CarteOrderInfo groupProducts = btnIngredient.getGroupProducts();
        ProductInfoExt subProduct = btnIngredient.getSupProduct();
        SupplementItemInfo ingredient = btnIngredient.getIngredient();
        int indexRemovedIngredient = this.indexIngredientRemovedIfExist(groupProducts, subProduct, ingredient);
        this.listChoiceIngredient.remove(indexRemovedIngredient);
        btnIngredient.setRemoved(false);
        btnIngredient.deselectIngredient();
    }

    public void removeIngredient(int idIngredient) {
        DriveIngredientDetailButton btnIngredient = this.getIngredientButton(idIngredient);
        if (btnIngredient == null) {
            return;
        }
        this.removeIngredient(btnIngredient);
    }

    private void removeIngredient(DriveIngredientDetailButton btnIngredient) {
        int id_group_products;
        btnIngredient.setVisible(false);
        CarteOrderInfo groupProducts = btnIngredient.getGroupProducts();
        ProductInfoExt subProduct = btnIngredient.getSupProduct();
        SupplementItemInfo ingredient = btnIngredient.getIngredient();
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        String name_group_products = groupProducts != null ? groupProducts.getName() : null;
        String name_sub_product = subProduct != null ? subProduct.getName() : null;
        String ref_group_product = groupProducts != null ? groupProducts.getRef_web() : null;
        String id_global_carte = groupProducts != null ? groupProducts.getId_global() : null;
        String ref_sub_product = subProduct != null ? subProduct.getRef_web() : null;
        String id_global_sub_product = subProduct != null ? subProduct.getId_global() : null;
        ItemOrderInfo itemOrderInfo = new ItemOrderInfo(ingredient, id_group_products, id_sub_product, name_sub_product, name_group_products, index_group_products, ref_sub_product, ref_group_product, id_global_sub_product, id_global_carte);
        itemOrderInfo.setImageIngredient(btnIngredient.getImageItem());
        this.listChoiceIngredient.add(itemOrderInfo);
        btnIngredient.setRemoved(true);
        btnIngredient.selectRemovedIngredient();
        btnIngredient.setVisible(true);
    }

    private int indexIngredientRemovedIfExist(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo ingredient) {
        int id_group_products;
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        int found = -1;
        for (int i = 0; i < this.listChoiceIngredient.size(); ++i) {
            if (this.listChoiceIngredient.get(i).getIdCarte() != id_group_products && (id_group_products != -1 || this.listChoiceIngredient.get(i).getIdCarte() != 0) || this.listChoiceIngredient.get(i).getIdProduct() != id_sub_product && (id_sub_product != -1 || this.listChoiceIngredient.get(i).getIdProduct() != 0) || this.listChoiceIngredient.get(i).getSupplement() != ingredient.getiD() || this.listChoiceIngredient.get(i).getIndex_carte() != index_group_products) continue;
            found = i;
            break;
        }
        return found;
    }

    public void validProduct() {
        this.hidePopup.apply(null);
    }

    public void removeAllIngredients(boolean allIngredientsRemoved) {
        for (List<DriveIngredientDetailButton> listIngredients : this.map_ingredients.values()) {
            for (DriveIngredientDetailButton btnIngredient : listIngredients) {
                int indexRemovedIngredient;
                CarteOrderInfo groupProducts = btnIngredient.getGroupProducts();
                ProductInfoExt subProduct = btnIngredient.getSupProduct();
                SupplementItemInfo ingredient = btnIngredient.getIngredient();
                if (allIngredientsRemoved) {
                    indexRemovedIngredient = this.indexIngredientRemovedIfExist(groupProducts, subProduct, ingredient);
                    if (indexRemovedIngredient == -1) continue;
                    this.addRemovedIngredient(btnIngredient);
                    continue;
                }
                indexRemovedIngredient = this.indexIngredientRemovedIfExist(groupProducts, subProduct, ingredient);
                if (indexRemovedIngredient != -1) continue;
                this.removeIngredient(btnIngredient);
            }
        }
    }

    private void loadOptionsTabs_Product() {
        System.out.println("product loadOptionsTabs_Product: " + this.product);
        if (this.product != null) {
            this.currentSubProductName = this.product.getName();
            System.out.println("currentSubProductName loadOptionsTabs_Product: " + this.currentSubProductName);
        }
        this.toggleHeaderButtons((Node)this.optionTabsPages);
        this.preparePane(this.optionsPane);
        System.out.println("++++++++ loadOptionsTabs_called_by_Product");
        this.setOptionsPaneBannerStyle(false, true);
        this.loadOptionsTabs(null, null);
    }

    private void loadOptionsTabs_DirectSubProduct(ProductInfoExt subProduct) {
        System.out.println("subProduct loadOptionsTabs_DirectSubProduct: " + this.product);
        if (subProduct != null) {
            this.currentSubProductName = subProduct.getName();
            System.out.println("currentSubProductName loadOptionsTabs_DirectSubProduct: " + this.currentSubProductName);
        }
        this.toggleHeaderButtons((Node)this.optionTabsPages);
        this.preparePane(this.optionsPane);
        this.setOptionsPaneBannerStyle(false, false);
        this.loadOptionsTabs(null, subProduct);
    }

    private void loadOptionsTabs_GroupProduct(CarteOrderInfo groupProducts, ProductInfoExt subProduct) {
        if (subProduct != null) {
            this.currentSubProductName = subProduct.getName();
        }
        this.toggleHeaderButtons((Node)this.optionTabsPages);
        this.setOptionsPaneBannerStyle(false, false);
        this.loadOptionsTabs(groupProducts, subProduct);
    }

    private void loadOptionsTabs(CarteOrderInfo groupProducts, ProductInfoExt subProduct) {
        this.groupOptionsPane.getChildren().clear();
        DriveGroupOptionsHeaderButton firstGroupOption = null;
        double heightOptionTabPane = this.screenHeight * 0.096;
        this.groupOptionTabs = new ArrayList<DriveGroupOptionsHeaderButton>();
        ArrayList<SupplementProduct> groupsOfOptions = new ArrayList<SupplementProduct>();
        if (subProduct != null && subProduct.getIngredients() != null && !subProduct.getIngredients().isEmpty()) {
            SupplementProduct groupIngredient = new SupplementProduct();
            groupIngredient.setName("ingredient");
            groupIngredient.setIs_ingredient(true);
            groupIngredient.setItems(subProduct.getIngredients());
            groupsOfOptions.add(groupIngredient);
        }
        if (subProduct != null) {
            if (subProduct.getSupplements() != null) {
                groupsOfOptions.addAll(subProduct.getSupplements());
            }
        } else {
            groupsOfOptions.addAll(this.options);
        }
        this.optionTabsPages.getChildren().clear();
        double widthOptionsTabsPane = this.options_main_pane.getPrefWidth() * 0.9;
        this.optionTabsPages.getChildren().add((Object)this.groupOptionsPane);
        this.optionTabsPages.getChildren().add((Object)this.groupOptionText);
        int numberOfGroups = groupsOfOptions.size();
        this.numberPageOptionsTabs = (int)Math.ceil((double)numberOfGroups / 7.0);
        this.MAX_OPTIONS_TABS = this.numberPageOptionsTabs > 1 ? 6 : 7;
        double widthOptionTab = widthOptionsTabsPane / (double)Math.min(this.MAX_OPTIONS_TABS, groupsOfOptions.size());
        this.groupOptionsPane.setPrefWidth(widthOptionsTabsPane);
        this.groupOptionsPane.setMaxWidth(widthOptionsTabsPane);
        int index = 0;
        for (SupplementProduct groupOptions : groupsOfOptions) {
            if (groupOptions == null) continue;
            DriveGroupOptionsHeaderButton optionDetailProductTab = new DriveGroupOptionsHeaderButton(groupProducts, subProduct, groupOptions, widthOptionTab, heightOptionTabPane, index++);
            this.groupOptionTabs.add(optionDetailProductTab);
            if (firstGroupOption != null || groupsOfOptions.size() != 1 && groupOptions.getIs_ingredient().booleanValue()) continue;
            firstGroupOption = optionDetailProductTab;
        }
        this.optionTabsArray = new ArrayList<List<DriveGroupOptionsHeaderButton>>();
        for (int i = 0; i < this.numberPageOptionsTabs; ++i) {
            ArrayList<DriveGroupOptionsHeaderButton> sub = new ArrayList<DriveGroupOptionsHeaderButton>();
            int startIndex = i * this.MAX_OPTIONS_TABS;
            int endIndex = (i + 1) * this.MAX_OPTIONS_TABS;
            int trueEndIndex = Math.min(endIndex, this.groupOptionTabs.size());
            for (int j = startIndex; j < trueEndIndex; ++j) {
                DriveGroupOptionsHeaderButton headerButton = this.groupOptionTabs.get(j);
                int startOrEnd = 2;
                if (this.groupOptionTabs.size() == 1) {
                    startOrEnd = 0;
                } else {
                    if (j == startIndex) {
                        startOrEnd = -1;
                    }
                    if (j == trueEndIndex - 1) {
                        startOrEnd = 1;
                    }
                }
                headerButton.setView(startOrEnd);
                sub.add(headerButton);
            }
            if (sub.isEmpty()) continue;
            this.optionTabsArray.add(sub);
        }
        if (this.numberPageOptionsTabs > 0) {
            this.page_options_tabs = 0;
            this.groupOptionsPane.getChildren().addAll((Collection)this.optionTabsArray.get(this.page_options_tabs));
        }
        this.optionsPane.getChildren().clear();
        if (firstGroupOption != null) {
            this.loadDetailGroupOption(firstGroupOption);
        } else {
            this.loadIngredients_SubProduct(null, subProduct);
        }
    }

    public void setPrevNextButtonsStates() {
        this.optionsPrevNextButtons.getChildren().clear();
        int denom = 0;
        if (this.page_options_tabs < this.numberPageOptionsTabs - 1) {
            ++denom;
        }
        if (this.page_options_tabs > this.numberPageOptionsTabs - 1) {
            ++denom;
        }
        if (denom != 0) {
            ImageView view;
            double prevNextBtnsSize = this.previousOptionTab.getPrefWidth() / (double)denom - 10.0;
            if (this.page_options_tabs < this.numberPageOptionsTabs - 1) {
                this.previousOptionTab.setVisible(true);
                this.previousOptionTab.setManaged(true);
                view = new ImageView(this.imagePreviousItemProduct);
                view.setFitWidth(prevNextBtnsSize);
                this.previousOptionTab.setGraphic((Node)view);
                this.previousOptionTab.setPrefHeight(this.previousOptionTab.getPrefHeight());
                this.previousOptionTab.setPrefWidth(prevNextBtnsSize);
                this.previousOptionTab.setStyle("-fx-background-color: transparent; -fx-border-width: 2px; -fx-background-radius: 15px; -fx-border-radius: 15px;");
                this.optionsPrevNextButtons.getChildren().add((Object)this.previousOptionTab);
            } else {
                this.previousOptionTab.setVisible(false);
                this.previousOptionTab.setManaged(false);
            }
            if (this.page_options_tabs > this.numberPageOptionsTabs - 1) {
                this.nextOptionTab.setVisible(true);
                this.nextOptionTab.setManaged(true);
                view = new ImageView(this.imageNextItemProduct);
                view.setFitWidth(prevNextBtnsSize);
                this.nextOptionTab.setGraphic((Node)view);
                this.nextOptionTab.setPrefHeight(this.previousOptionTab.getPrefHeight());
                this.nextOptionTab.setPrefWidth(prevNextBtnsSize);
                this.nextOptionTab.setStyle("-fx-background-color: transparent; -fx-border-width: 2px; -fx-background-radius: 15px; -fx-border-radius: 15px;");
                this.optionsPrevNextButtons.getChildren().add((Object)this.nextOptionTab);
            } else {
                this.nextOptionTab.setVisible(false);
                this.nextOptionTab.setManaged(false);
            }
        }
    }

    public void nextGroupOption() {
        if (this.page_options_tabs < this.numberPageOptionsTabs - 1) {
            ++this.page_options_tabs;
            this.groupOptionsPane.getChildren().clear();
            this.groupOptionsPane.getChildren().addAll((Collection)this.optionTabsArray.get(this.page_options_tabs));
            int index_group_option = this.MAX_OPTIONS_TABS * this.page_options_tabs;
            if (this.groupOptionTabs != null && !this.groupOptionTabs.isEmpty()) {
                DriveGroupOptionsHeaderButton buttonGroupOption = this.groupOptionTabs.get(index_group_option);
                this.loadDetailGroupOption(buttonGroupOption);
            }
        }
    }

    public void previousGroupOption() {
        if (this.page_options_tabs > 0) {
            --this.page_options_tabs;
            this.groupOptionsPane.getChildren().clear();
            this.groupOptionsPane.getChildren().addAll((Collection)this.optionTabsArray.get(this.page_options_tabs));
            int index_group_option = this.MAX_OPTIONS_TABS * this.page_options_tabs;
            if (this.groupOptionTabs != null && !this.groupOptionTabs.isEmpty()) {
                DriveGroupOptionsHeaderButton buttonGroupOption = this.groupOptionTabs.get(index_group_option);
                this.loadDetailGroupOption(buttonGroupOption);
            }
        }
    }

    private void loadOptions(DriveGroupOptionsHeaderButton buttonGroupOption) {
        this.optionsButtons.clear();
        CarteOrderInfo groupProduct = buttonGroupOption.getGroupProducts();
        ProductInfoExt supProduct = buttonGroupOption.getProduct();
        SupplementProduct groupOption = buttonGroupOption.getGroupOption();
        this.preparePane(this.optionsPane);
        if (this.map_options == null) {
            this.map_options = new HashMap();
        }
        this.map_options.clear();
        double horizontalSpacing = 30 * (this.NUMBER_COLUMN_OPTION - 1);
        double verticalSpacing = 30 * (this.NUMBER_ROW_OPTION - 1);
        if (groupProduct != null) {
            this.NUMBER_COLUMN_OPTION = 4;
            this.NUMBER_ROW_OPTION = 4;
            this.MAX_OPTIONS_PER_PAGE = 12;
        } else {
            this.NUMBER_COLUMN_OPTION = 4;
            this.NUMBER_ROW_OPTION = 4;
            this.MAX_OPTIONS_PER_PAGE = 16;
        }
        this.heightOptionsPane = this.screenHeight * 0.63 - verticalSpacing;
        double widthOptionsPane = this.screenWidth - horizontalSpacing;
        double widthOption = widthOptionsPane / (double)this.NUMBER_COLUMN_OPTION;
        double heightOption = this.heightOptionsPane / (double)this.NUMBER_ROW_OPTION;
        int index = 0;
        int index_map = 0;
        this.itemOptionsButton = new LinkedHashMap();
        this.numberPageOptions = (int)Math.ceil((double)groupOption.getItems().size() / (double)this.MAX_OPTIONS_PER_PAGE);
        this.MAX_OPTIONS = this.numberPageOptions > 1 ? this.MAX_OPTIONS_PER_PAGE - 1 : this.MAX_OPTIONS_PER_PAGE;
        for (SupplementItemInfo optionItem : groupOption.getItems()) {
            Image imageOption = this.mImagesUtils.getImageOption(optionItem, this.refOptions, "", true);
            if (imageOption == null) {
                imageOption = this.imageDefaultItemOption;
            }
            DriveOptionDetailButton optionButton = new DriveOptionDetailButton(groupProduct, supProduct, groupOption, null, optionItem, heightOption, widthOption, imageOption);
            this.optionsButtons.add(optionButton);
            optionButton.setIndex_group_option(buttonGroupOption.getIndex());
            int indexOption = this.indexSelectedOptionIfExist(groupProduct, supProduct, optionItem);
            if (indexOption != -1) {
                OptionItemOrder optionItemOrder = this.listChoiceSupplement.get(indexOption);
                optionButton.setOptionItemOrder(optionItemOrder);
                if (optionItemOrder != null) {
                    optionButton.setQuantity(optionItemOrder.getNumberOption());
                }
                optionButton.select();
            } else {
                optionButton.deselect();
            }
            optionButton.getQuantityIncreaseButton().getProperties().put((Object)"button_option", (Object)optionButton);
            optionButton.getQuantityDecreaseButton().getProperties().put((Object)"button_option", (Object)optionButton);
            if (index < this.MAX_OPTIONS) {
                this.itemOptionsButton.put(optionItem.getiD(), optionButton);
            } else {
                this.map_options.put(index_map, this.itemOptionsButton);
                this.itemOptionsButton = new LinkedHashMap();
                this.itemOptionsButton.put(optionItem.getiD(), optionButton);
                ++index_map;
                index = 0;
            }
            ++index;
        }
        if (this.itemOptionsButton != null && !this.itemOptionsButton.isEmpty()) {
            this.map_options.put(index_map, this.itemOptionsButton);
        }
        int column = 0;
        int row = 0;
        for (int i = 0; i < this.MAX_OPTIONS; ++i) {
            GridPane itemIngredientPane = new GridPane();
            itemIngredientPane.setPrefHeight(heightOption);
            itemIngredientPane.setPrefWidth(widthOption);
            itemIngredientPane.getStyleClass().add((Object)"border_white_opacity12");
            itemIngredientPane.getStyleClass().add((Object)"border_radius_12px");
            itemIngredientPane.getStyleClass().add((Object)"bg_radius_12px");
            itemIngredientPane.getStyleClass().add((Object)"bg_white_opacity12");
            this.optionsPane.add((Node)itemIngredientPane, column, row);
            if (column < this.NUMBER_COLUMN_INGREDIENT - 1) {
                ++column;
                continue;
            }
            column = 0;
            ++row;
        }
        if (this.numberPageOptions > 1) {
            GridPane nextPreviousPane = new GridPane();
            nextPreviousPane.setAlignment(Pos.CENTER);
            nextPreviousPane.setVgap(10.0);
            nextPreviousPane.setHgap(10.0);
            nextPreviousPane.setPrefHeight(heightOption);
            nextPreviousPane.setPrefWidth(widthOption);
            nextPreviousPane.getStyleClass().add((Object)"bg_white_opacity20");
            nextPreviousPane.getStyleClass().add((Object)"border_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"bg_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"border_white_opacity12");
            this.nextItemOptionButton = new Button();
            this.nextItemOptionButton.getStyleClass().add((Object)"border_radius_14px");
            this.nextItemOptionButton.getStyleClass().add((Object)"bg_radius_14px");
            this.nextItemOptionButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.nextItemOptionButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.nextItemOptionButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.4);
            ImageView view = new ImageView(this.imageNextItemProduct);
            view.setFitHeight(nextPreviousPane.getPrefHeight() * 0.35);
            view.setFitWidth(nextPreviousPane.getPrefWidth() * 0.35);
            this.nextItemOptionButton.setGraphic((Node)view);
            this.previousItemOptionButton = new Button();
            this.previousItemOptionButton.getStyleClass().add((Object)"border_radius_14px");
            this.previousItemOptionButton.getStyleClass().add((Object)"bg_radius_14px");
            this.previousItemOptionButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.previousItemOptionButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.previousItemOptionButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.4);
            ImageView view2 = new ImageView(this.imagePreviousItemProduct);
            view2.setFitHeight(nextPreviousPane.getPrefHeight() * 0.35);
            view2.setFitWidth(nextPreviousPane.getPrefWidth() * 0.35);
            this.previousItemOptionButton.setGraphic((Node)view2);
            nextPreviousPane.add((Node)this.previousItemOptionButton, 0, 0);
            nextPreviousPane.add((Node)this.nextItemOptionButton, 1, 0);
            this.optionsPane.add((Node)nextPreviousPane, column, row);
            this.previousItemOptionButton.setVisible(false);
            this.previousItemOptionButton.setManaged(false);
            if (this.numberPageOptions == 1) {
                this.nextItemOptionButton.setVisible(false);
                this.nextItemOptionButton.setManaged(false);
            }
        }
        this.page_options = 0;
        this.loadPageOptions(this.page_options);
    }

    private void loadPageOptions(int page_options) {
        LinkedHashMap<Integer, DriveOptionDetailButton> mapOptionsButton = this.map_options.get(page_options);
        List optionsButton = mapOptionsButton.values().stream().collect(Collectors.toList());
        int numberOptions = optionsButton.size();
        int index = 0;
        for (Node node : this.optionsPane.getChildren()) {
            if (index >= this.MAX_OPTIONS) break;
            if (node instanceof GridPane) {
                GridPane optionPane = (GridPane)node;
                optionPane.getChildren().clear();
                if (index < numberOptions) {
                    optionPane.add((Node)optionsButton.get(index), 0, 0);
                }
            }
            ++index;
        }
    }

    public void nextOptions() {
        if (this.page_options < this.numberPageOptions - 1) {
            ++this.page_options;
            this.loadPageOptions(this.page_options);
            if (!this.previousItemOptionButton.isVisible()) {
                this.previousItemOptionButton.setVisible(true);
                this.previousItemOptionButton.setManaged(true);
            }
            if (this.page_options < this.numberPageOptions - 1) {
                double width = this.previousItemOptionButton.getPrefWidth();
                this.previousItemOptionButton.setPrefWidth(width / 2.0);
                this.nextItemOptionButton.setVisible(true);
                this.nextItemOptionButton.setManaged(true);
                this.nextItemOptionButton.setPrefWidth(width / 2.0);
            } else if (this.page_options == this.numberPageOptions - 1) {
                double width = this.nextItemOptionButton.getPrefWidth();
                this.nextItemOptionButton.setVisible(false);
                this.nextItemOptionButton.setManaged(false);
                this.previousItemOptionButton.setPrefWidth(width * 2.0);
            }
        }
    }

    public void previousOptions() {
        if (this.page_options > 0) {
            --this.page_options;
            this.loadPageOptions(this.page_options);
            if (!this.nextItemOptionButton.isVisible()) {
                this.nextItemOptionButton.setVisible(true);
                this.nextItemOptionButton.setManaged(true);
            }
            if (this.page_options > this.numberPageOptions - 1) {
                double width = this.nextItemOptionButton.getPrefWidth();
                this.nextItemOptionButton.setPrefWidth(width / 2.0);
                this.previousItemOptionButton.setVisible(true);
                this.previousItemOptionButton.setManaged(true);
                this.previousItemOptionButton.setPrefWidth(width);
            } else if (this.page_options == 0) {
                double width = this.previousItemOptionButton.getPrefWidth();
                this.previousItemOptionButton.setVisible(false);
                this.previousItemOptionButton.setManaged(false);
                this.nextItemOptionButton.setPrefWidth(width * 2.0);
            }
        }
    }

    public void handleOptionTabAction(OptionDetailProductTab btn) {
        DriveGroupOptionsHeaderButton buttonGroupOption = this.getGroupOptionTabBtn(btn);
        if (buttonGroupOption != null) {
            this.deselectOptionTabs(buttonGroupOption.getIndex());
            this.selectOptionTab(buttonGroupOption);
            if (buttonGroupOption.getGroupOption().getIs_ingredient().booleanValue()) {
                this.loadIngredients_SubProduct(buttonGroupOption.getGroupProducts(), buttonGroupOption.getProduct());
            } else {
                this.loadOptions(buttonGroupOption);
            }
        }
    }

    private void deselectOptionTabs(int currentButtonIndex) {
        for (DriveGroupOptionsHeaderButton headerButton : this.groupOptionTabs) {
            headerButton.deselect(currentButtonIndex);
        }
    }

    private void selectOptionTab(DriveGroupOptionsHeaderButton headerButton) {
        headerButton.select();
        this.groupOptionText.getChildren().clear();
        if (headerButton.getGroupOption() != null && !headerButton.getGroupOption().getIs_ingredient().booleanValue()) {
            Text text2 = new Text(headerButton.getGroupOption().getMin_options() + " min - " + headerButton.getGroupOption().getMax_options() + " max");
            text2.setStyle("-fx-font-size: 15pt; -fx-fill: black; -fx-font-weight: bold;");
            this.groupOptionText.getChildren().add((Object)text2);
        }
    }

    private int indexSelectedOptionIfExist(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo option) {
        int id_group_products;
        int id_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        int found = -1;
        for (int i = 0; i < this.listChoiceSupplement.size(); ++i) {
            if (this.listChoiceSupplement.get(i).getIdCarte() != id_group_products && (id_group_products != -1 || this.listChoiceSupplement.get(i).getIdCarte() != 0) || this.listChoiceSupplement.get(i).getIdProduct() != id_product && (id_product != -1 || this.listChoiceSupplement.get(i).getIdProduct() != 0) || this.listChoiceSupplement.get(i).getSupplement() != option.getiD() || this.listChoiceSupplement.get(i).getIndex_carte() != index_group_products || this.listChoiceSupplement.get(i).getParent_supplement_id() != 0) continue;
            found = i;
            break;
        }
        return found;
    }

    public void selectOption(int optionId) {
        ProductInfoExt subProduct;
        DriveOptionDetailButton buttonOption = this.getOptionBtn(optionId);
        if (buttonOption == null) {
            return;
        }
        SupplementItemInfo optionItem = buttonOption.getOption();
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        int indexOption = this.indexSelectedOptionIfExist(groupProducts, subProduct = buttonOption.getSubProduct(), optionItem);
        if (indexOption == -1) {
            boolean option_freeable;
            SupplementProduct groupOption = buttonOption.getGroupOption();
            boolean bl = option_freeable = groupOption.isFree_able() && optionItem.getPrice_order() > 0.0 && groupOption.getOption_free() > groupOption.getOrderSupplement();
            if (option_freeable) {
                this.makeItemFree = false;
                this.make_items_free_button.setStyle("-fx-font-size: 12px;-fx-text-fill: white;-fx-background-radius: 0px 0px 11px 11px;-fx-background-color:  linear-gradient(to bottom, rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), linear-gradient(to bottom, rgba(0, 0, 0, 0.20), rgba(0, 0, 0, 0.20)), rgba(149, 111, 248, 0.50);");
            }
            this.addOption(buttonOption);
        }
    }

    private int sizeOptions(DriveOptionDetailButton buttonOption) {
        int id_group_products;
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        ProductInfoExt subProduct = buttonOption.getSubProduct();
        SupplementProduct groupOption = buttonOption.getGroupOption();
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        int size = 0;
        for (OptionItemOrder optionItem : this.listChoiceSupplement) {
            if (optionItem.getIdCarte() != id_group_products && (id_group_products != -1 || optionItem.getIdCarte() != 0) || optionItem.getIdProduct() != id_sub_product && (id_sub_product != -1 || optionItem.getIdProduct() != 0) || optionItem.getId_groupe_option() != groupOption.getiD() || optionItem.getIndex_carte() != index_group_products || optionItem.getParent_supplement_id() != 0) continue;
            size += optionItem.getNumberOption();
        }
        return size;
    }

    private void addOption(DriveOptionDetailButton buttonOption) {
        String id_global_group_products;
        int id_group_products;
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        ProductInfoExt subProduct = buttonOption.getSubProduct();
        SupplementProduct groupOption = buttonOption.getGroupOption();
        SupplementItemInfo optionItem = buttonOption.getOption();
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        String name_group_products = groupProducts != null ? groupProducts.getName() : null;
        String name_sub_product = subProduct != null ? subProduct.getName() : null;
        String ref_sub_product = subProduct != null ? subProduct.getRef_web() : null;
        String ref_group_products = groupProducts != null ? groupProducts.getRef_web() : null;
        String id_global_sub_product = subProduct != null ? subProduct.getId_global() : null;
        String string = id_global_group_products = groupProducts != null ? groupProducts.getId_global() : null;
        if (!this.listChoiceSupplement.isEmpty() && groupOption.getHas_options().booleanValue() && groupOption.getMax_options() == this.sizeOptions(buttonOption)) {
            this.deleteLastOption(groupProducts, subProduct, groupOption);
        }
        double price = 0.0;
        int number_free = 0;
        if (this.makeItemFree || this.isOptionFreeable(groupOption) && optionItem.getPrice_order() > 0.0) {
            price = 0.0;
            number_free = 1;
            this.makeItemFree = !this.isOptionFreeable(groupOption) || !(optionItem.getPrice_order() > 0.0);
        } else {
            number_free = 0;
            price = optionItem.getPrice_order();
        }
        OptionItemOrder optionItemOrder = new OptionItemOrder(id_group_products, id_sub_product, optionItem.getiD(), optionItem.getName(), name_sub_product, name_group_products, 1, groupOption.getIsBold(), price, index_group_products, number_free, groupOption.isSeparate(), null, groupOption.isMultiple_category(), groupOption.isDisplay_free(), groupOption.getiD(), this.makeItemFree, groupOption.getPrinter(), groupOption.getShift_option(), groupOption.isDisplay_screen_sorti(), this.getColor(optionItem, groupOption), optionItem, groupOption.isNo_printable(), groupOption.getName(), groupOption.isPrint_black_background(), ref_sub_product, ref_group_products, id_global_sub_product, id_global_group_products);
        optionItemOrder.setImageSupplement(buttonOption.getImageItem());
        this.listChoiceSupplement.add(optionItemOrder);
        buttonOption.setOptionItemOrder(optionItemOrder);
        if (!this.makeItemFree) {
            this.decrementOptionFree(groupOption);
        }
        this.next_option = !this.listChoiceSupplement.isEmpty() && groupOption.getHas_options() != false && groupOption.getMax_options() == this.sizeOptions(buttonOption);
        System.out.println("next_option : " + this.next_option);
        if ((optionItem.getGroupsSubSupplement() == null || optionItem.getGroupsSubSupplement().isEmpty()) && this.next_option) {
            this.nextOption(buttonOption);
        }
        this.makeItemFree = false;
        buttonOption.setQuantity(1);
        buttonOption.select();
        this.setPriceTotal();
        if (groupOption.getNumber_click() == 1 || groupOption.getMax_options() == 1) {
            // empty if block
        }
    }

    private OptionItemOrder lastOption(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementProduct groupOption) {
        int id_group_products;
        int group_option = groupOption.getiD();
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        OptionItemOrder optionItem = null;
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            if (optionItemOrder.getParent_supplement_id() != 0 || optionItemOrder.getId_groupe_option() != group_option || optionItemOrder.getIdCarte() != id_group_products || optionItemOrder.getIdProduct() != id_sub_product || optionItemOrder.getIndex_carte() != index_group_products) continue;
            optionItem = optionItemOrder;
        }
        return optionItem;
    }

    private void decreaseQttOption(DriveOptionDetailButton buttonOption, OptionItemOrder itemToUpdate) {
        if (itemToUpdate.getNumber_free() == itemToUpdate.getNumberOption()) {
            if (!itemToUpdate.isForce_free()) {
                this.incrementOptionFree(buttonOption.getGroupOption(), 1);
            }
            this.calculFreeAfterDelete(buttonOption);
            itemToUpdate.setNumber_free(itemToUpdate.getNumber_free() - 1);
            itemToUpdate.setNumberOption(itemToUpdate.getNumberOption() - 1);
        } else {
            itemToUpdate.setNumberOption(itemToUpdate.getNumberOption() - 1);
            if (buttonOption.getOption() != null) {
                itemToUpdate.setPrice(buttonOption.getOption().getPrice_order(), itemToUpdate.getNumberOption() - itemToUpdate.getNumber_free());
            }
        }
        buttonOption.setQuantity(itemToUpdate.getNumberOption());
        buttonOption.getQuantityIncreaseButton().setOpacity(1.0);
        this.setPriceTotal();
    }

    private void deleteLastOption(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementProduct groupOption) {
        OptionItemOrder itemToDelete = this.lastOption(groupProducts, subProduct, groupOption);
        if (itemToDelete != null) {
            DriveOptionDetailButton buttonOption = null;
            for (LinkedHashMap<Integer, DriveOptionDetailButton> listButtons : this.map_options.values()) {
                if (listButtons.get(itemToDelete.getSupplement()) == null) continue;
                buttonOption = listButtons.get(itemToDelete.getSupplement());
                break;
            }
            if (buttonOption != null) {
                if (itemToDelete.getNumberOption() > 1) {
                    this.decreaseQttOption(buttonOption, itemToDelete);
                } else {
                    this.deleteOption(buttonOption, itemToDelete);
                }
            }
        }
    }

    public void deleteOption(int optionId) {
        SupplementItemInfo optionItem;
        ProductInfoExt subProduct;
        DriveOptionDetailButton buttonOption = this.getOptionBtn(optionId);
        if (buttonOption == null) {
            return;
        }
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        int indexOption = this.indexSelectedOptionIfExist(groupProducts, subProduct = buttonOption.getSubProduct(), optionItem = buttonOption.getOption());
        if (indexOption != -1) {
            OptionItemOrder optionToDelete = this.listChoiceSupplement.get(indexOption);
            this.deleteOption(buttonOption, optionToDelete);
        }
    }

    private void deleteOption(DriveOptionDetailButton buttonOption, OptionItemOrder itemToDelete) {
        if (itemToDelete.getNumber_free() > 0) {
            this.incrementOptionFree(buttonOption.getGroupOption(), itemToDelete.getNumber_free());
            if (!itemToDelete.isForce_free()) {
                this.incrementOptionFree(buttonOption.getGroupOption(), 1);
            }
            this.listChoiceSupplement.remove(itemToDelete);
            this.calculFreeAfterDelete(buttonOption);
        } else {
            this.listChoiceSupplement.remove(itemToDelete);
        }
        if (buttonOption.getOption() != null) {
            // empty if block
        }
        buttonOption.deselect();
        this.deleteSubOptions(buttonOption);
        this.setPriceTotal();
    }

    public void setPrice(String text) {
        this.price_label.setText(text);
    }

    public void nextOption(int optionId) {
        DriveOptionDetailButton optionBtn = this.getOptionBtn(optionId);
        if (optionBtn != null) {
            this.nextOption(optionBtn);
        }
    }

    private void nextOption(DriveOptionDetailButton buttonOption) {
        int index_group_option = buttonOption.getIndex_group_option();
        if (this.groupOptionTabs != null && !this.groupOptionTabs.isEmpty()) {
            int index_group_option_next = index_group_option + 1;
            if (index_group_option_next < this.groupOptionTabs.size()) {
                int page = (int)Math.ceil((double)(index_group_option_next + 1) / (double)this.MAX_OPTIONS_TABS);
                if (--page > this.page_options_tabs) {
                    this.nextGroupOption();
                } else {
                    DriveGroupOptionsHeaderButton buttonGroupOption = this.groupOptionTabs.get(index_group_option_next);
                    this.loadDetailGroupOption(buttonGroupOption);
                }
            } else {
                int index_header_tab = -1;
                if (buttonOption.getGroupProducts() != null) {
                    for (DriveHeaderDetailProductButton groupTab : this.groupTabs) {
                        if (groupTab == null || !groupTab.getGroup_type().equalsIgnoreCase(STR_GROUP_PRODUCTS) || ((CarteOrderInfo)groupTab.getGroupItem()).getId() != buttonOption.getGroupProducts().getId() || ((CarteOrderInfo)groupTab.getGroupItem()).getIndex_carte() != buttonOption.getGroupProducts().getIndex_carte()) continue;
                        index_header_tab = groupTab.getIndex();
                        break;
                    }
                } else if (buttonOption.getSubProduct() != null) {
                    for (DriveHeaderDetailProductButton groupTab : this.groupTabs) {
                        if (groupTab == null || !groupTab.getGroup_type().equalsIgnoreCase(STR_SUB_PRODUCT) || ((ProductInfoExt)groupTab.getGroupItem()).getID() != buttonOption.getSubProduct().getID() || ((ProductInfoExt)groupTab.getGroupItem()).getIndex_sub_product() != buttonOption.getSubProduct().getIndex_sub_product()) continue;
                        index_header_tab = groupTab.getIndex();
                        break;
                    }
                }
                if (index_header_tab != -1 && ++index_header_tab <= this.groupTabs.size()) {
                    int index = index_header_tab;
                    int page = (int)Math.ceil((double)index / 4.0);
                    if (--page != this.page_detail_product_header && page < this.numberPageDetailProductHeader) {
                        this.page_detail_product_header = page;
                        this.header_detail_product_pane.getChildren().clear();
                        this.header_detail_product_pane.getChildren().addAll((Collection)this.headerButtonsArray.get(this.page_detail_product_header));
                        if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                            // empty if block
                        }
                    }
                    DriveHeaderDetailProductButton nextGroupTab = null;
                    for (DriveHeaderDetailProductButton groupTab : this.groupTabs) {
                        if (groupTab.getIndex() != index_header_tab) continue;
                        nextGroupTab = groupTab;
                    }
                    this.loadHeaderTab(nextGroupTab);
                }
            }
        }
    }

    public void handleOptionAction(int optionId, boolean increase) {
        DriveOptionDetailButton buttonOption = this.getOptionBtn(optionId);
        if (buttonOption == null) {
            return;
        }
        if (increase) {
            this.increaseQttOption(buttonOption);
        } else {
            this.decreaseQttOption(buttonOption);
        }
    }

    private void increaseQttOption(DriveOptionDetailButton buttonOption) {
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        ProductInfoExt subProduct = buttonOption.getSubProduct();
        SupplementItemInfo optionItem = buttonOption.getOption();
        SupplementProduct groupOption = buttonOption.getGroupOption();
        int indexOption = this.indexSelectedOptionIfExist(groupProducts, subProduct, optionItem);
        if (indexOption != -1) {
            int number = this.listChoiceSupplement.get(indexOption).getNumberOption();
            if (number < groupOption.getNumber_click() && number < groupOption.getMax_options()) {
                OptionItemOrder lastOption = this.lastOption(groupProducts, subProduct, groupOption);
                boolean same_option = false;
                boolean delete_last_option = false;
                if (lastOption != null && lastOption.getSupplement() == this.listChoiceSupplement.get(indexOption).getSupplement() && lastOption.getIdProduct() == this.listChoiceSupplement.get(indexOption).getIdProduct() && lastOption.getIdCarte() == this.listChoiceSupplement.get(indexOption).getIdCarte() && lastOption.getIndex_carte() == this.listChoiceSupplement.get(indexOption).getIndex_carte()) {
                    same_option = true;
                }
                if (!this.listChoiceSupplement.isEmpty() && groupOption.getHas_options().booleanValue() && groupOption.getMax_options() == this.sizeOptions(buttonOption)) {
                    delete_last_option = true;
                }
                if (!same_option && delete_last_option) {
                    this.deleteLastOption(groupProducts, subProduct, groupOption);
                }
                if (!same_option || !delete_last_option) {
                    int numberFree = this.listChoiceSupplement.get(indexOption).getNumber_free();
                    if (this.isOptionFreeable(groupOption) && optionItem.getPrice_order() > 0.0) {
                        this.listChoiceSupplement.get(indexOption).setNumber_free(++numberFree);
                        this.decrementOptionFree(groupOption);
                    }
                    this.listChoiceSupplement.get(indexOption).setNumberOption(++number);
                    this.listChoiceSupplement.get(indexOption).setPrice(optionItem.getPrice_order(), number - numberFree);
                    if (!this.listChoiceSupplement.isEmpty() && groupOption.getHas_options().booleanValue() && groupOption.getMax_options() == this.sizeOptions(buttonOption)) {
                        this.nextOption(buttonOption);
                    }
                }
                buttonOption.setQuantity(number);
                this.setPriceTotal();
            }
            if (number >= groupOption.getNumber_click() || number >= groupOption.getMax_options()) {
                // empty if block
            }
        }
    }

    private void decreaseQttOption(DriveOptionDetailButton buttonOption) {
        SupplementItemInfo optionItem;
        ProductInfoExt subProduct;
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        int indexOption = this.indexSelectedOptionIfExist(groupProducts, subProduct = buttonOption.getSubProduct(), optionItem = buttonOption.getOption());
        if (indexOption != -1) {
            OptionItemOrder optionToDelete = this.listChoiceSupplement.get(indexOption);
            if (optionToDelete.getNumberOption() > 1) {
                this.decreaseQttOption(buttonOption, optionToDelete);
            } else {
                this.deleteOption(buttonOption, optionToDelete);
            }
        }
    }

    public void setMakeItemFree() {
        this.makeItemFree = true;
        this.make_items_free_button.setStyle("-fx-font-size: 12px;-fx-text-fill: white;-fx-background-radius: 0px 0px 11px 11px;-fx-background-color: #0B8871;");
    }

    private void setTypeLine() {
        try {
            if (this.type_line != null) {
                switch (this.type_line) {
                    case "Sur Place": {
                        this.setTypeLineDineIn();
                        break;
                    }
                    case "A Emporter": {
                        this.setTypeLineTakeAway();
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void setTypeLineTakeAway() throws URISyntaxException {
        this.imageTakeAwayLine = new Image(this.getClass().getResource("/com/openbravo/images/take_away_line.png").toURI().toString(), 30.0, 30.0, false, false);
        this.type_order_button.setGraphic((Node)new ImageView(this.imageTakeAwayLine));
        this.type_order_button.setStyle("-fx-background-color: #00AFD5; -fx-background-radius: 0px 0px 11px 11px; -fx-text-fill: white;");
    }

    private void setTypeLineDineIn() throws URISyntaxException {
        this.imageDineInLine = new Image(this.getClass().getResource("/com/openbravo/images/at_spot_line.png").toURI().toString(), 30.0, 30.0, false, false);
        this.type_order_button.setGraphic((Node)new ImageView(this.imageDineInLine));
        this.type_order_button.setStyle(this.styleDineIn);
    }

    private int indexSubProductIfExist(ProductInfoExt item, CarteOrderInfo groupProduct) {
        int indexSubProduct = -1;
        for (int i = 0; i < this.listProducts.size(); ++i) {
            if (this.listProducts.get(i).getIdProduct() != item.getID() || this.listProducts.get(i).getIdCarte() != groupProduct.getId() || this.listProducts.get(i).getIndex_carte() != groupProduct.getIndex_carte()) continue;
            indexSubProduct = i;
            break;
        }
        return indexSubProduct;
    }

    private void loadProductsFamille(CarteOrderInfo groupProducts) {
        this.setOptionsPaneBannerStyle(true, false);
        this.preparePane(this.productsFamillePane);
        if (this.map_products_famille == null) {
            this.map_products_famille = new HashMap();
        }
        this.map_products_famille.clear();
        double padding = 50.0;
        double heightProductsFamillePane = this.screenHeight * 0.63 - padding;
        double widthProductsFamillePane = this.screenWidth - padding;
        double widthProductFamille = widthProductsFamillePane / 3.0;
        double heightProductFamille = heightProductsFamillePane / 3.0;
        int index = 0;
        int index_map = 0;
        int index_sub_product = 0;
        DriveProductFamilleButton productButtonSelected = null;
        this.productsFamilleButtons = new LinkedHashMap();
        this.numberPageProductsFamille = (int)Math.ceil((double)groupProducts.getItems().size() / 9.0);
        this.MAX_PRODUCT_FAMILLE = this.numberPageProductsFamille > 1 ? 8 : 9;
        for (ProductInfoExt productFamille : groupProducts.getItems()) {
            Image image = this.mImagesUtils.getImageProduct(productFamille, this.refProducts, "", true);
            if (image == null) {
                image = this.imageDefaultItemOption;
            }
            DriveProductFamilleButton productButton = new DriveProductFamilleButton(groupProducts, productFamille, widthProductFamille, heightProductFamille, image, index_sub_product++);
            int indexOption = this.indexSubProductIfExist(productFamille, groupProducts);
            if (indexOption != -1) {
                productButton.select();
                productButtonSelected = productButton;
            } else {
                productButton.deselect();
            }
            if (index < this.MAX_PRODUCT_FAMILLE) {
                this.productsFamilleButtons.put(productFamille.getID(), productButton);
            } else {
                this.map_products_famille.put(index_map, this.productsFamilleButtons);
                this.productsFamilleButtons = new LinkedHashMap();
                this.productsFamilleButtons.put(productFamille.getID(), productButton);
                ++index_map;
                index = 0;
            }
            ++index;
        }
        if (this.productsFamilleButtons != null && !this.productsFamilleButtons.isEmpty()) {
            this.map_products_famille.put(index_map, this.productsFamilleButtons);
        }
        int column = 0;
        int row = 0;
        for (int i = 0; i < this.MAX_PRODUCT_FAMILLE; ++i) {
            GridPane productFamillePane = new GridPane();
            productFamillePane.setPrefHeight(heightProductFamille);
            productFamillePane.setPrefWidth(widthProductFamille);
            productFamillePane.setStyle("-fx-border-color: #FFFFFF1E; -fx-border-radius: 16px; -fx-background-color: #FFFFFF14;  -fx-background-radius: 16px;");
            this.productsFamillePane.add((Node)productFamillePane, column, row);
            if (column < 2) {
                ++column;
                continue;
            }
            column = 0;
            ++row;
        }
        if (this.numberPageProductsFamille > 1) {
            GridPane nextPreviousPane = new GridPane();
            nextPreviousPane.setAlignment(Pos.CENTER);
            nextPreviousPane.setVgap(5.0);
            nextPreviousPane.setHgap(5.0);
            nextPreviousPane.setPrefHeight(heightProductFamille);
            nextPreviousPane.setPrefWidth(widthProductFamille);
            nextPreviousPane.getStyleClass().add((Object)"bg_white_opacity20");
            nextPreviousPane.getStyleClass().add((Object)"border_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"bg_radius_12px");
            nextPreviousPane.getStyleClass().add((Object)"border_white_opacity12");
            this.nextProductFamilleButton = new Button();
            this.nextProductFamilleButton.getStyleClass().add((Object)"border_radius_14px");
            this.nextProductFamilleButton.getStyleClass().add((Object)"bg_radius_14px");
            this.nextProductFamilleButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.nextProductFamilleButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.nextProductFamilleButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.nextProductFamilleButton.setGraphic((Node)new ImageView(this.imageNextItemProduct));
            this.previousProductFamilleButton = new Button();
            this.previousProductFamilleButton.getStyleClass().add((Object)"border_radius_14px");
            this.previousProductFamilleButton.getStyleClass().add((Object)"bg_radius_14px");
            this.previousProductFamilleButton.getStyleClass().add((Object)"bg_white_opacity18");
            this.previousProductFamilleButton.setPrefHeight(nextPreviousPane.getPrefHeight() * 0.8);
            this.previousProductFamilleButton.setPrefWidth(nextPreviousPane.getPrefWidth() * 0.45);
            this.previousProductFamilleButton.setGraphic((Node)new ImageView(this.imagePreviousItemProduct));
            nextPreviousPane.add((Node)this.previousProductFamilleButton, 0, 0);
            nextPreviousPane.add((Node)this.nextProductFamilleButton, 1, 0);
            this.productsFamillePane.add((Node)nextPreviousPane, column, row);
            this.previousProductFamilleButton.setVisible(false);
            this.previousProductFamilleButton.setManaged(false);
            if (this.numberPageProductsFamille == 1) {
                this.nextProductFamilleButton.setVisible(false);
                this.nextProductFamilleButton.setManaged(false);
            }
        }
        this.toggleHeaderButtons((Node)this.header_detail_product_pages);
        this.page_products_famille = 0;
        this.loadPageProductsFamille(this.page_products_famille);
        if (productButtonSelected != null) {
            this.loadSelectedSubProduct(productButtonSelected);
        }
    }

    public void handleProductFamilyClick(int clickCount, CarteOrderInfo groupProducts, ProductInfoExt productFamille) {
        if (clickCount == 1) {
            this.selectProductFamille(groupProducts, productFamille);
        }
        if (clickCount == 2) {
            this.checkAndDeleteProductFamille(groupProducts, productFamille);
        }
    }

    public void nextProductsFamille() {
        if (this.page_products_famille < this.numberPageProductsFamille - 1) {
            ++this.page_products_famille;
            this.loadPageProductsFamille(this.page_products_famille);
            if (!this.previousProductFamilleButton.isVisible()) {
                this.previousProductFamilleButton.setVisible(true);
                this.previousProductFamilleButton.setManaged(true);
            }
            if (this.page_products_famille < this.numberPageProductsFamille - 1) {
                double width = this.previousProductFamilleButton.getPrefWidth();
                this.previousProductFamilleButton.setPrefWidth(width / 2.0);
                this.nextProductFamilleButton.setVisible(true);
                this.nextProductFamilleButton.setManaged(true);
                this.nextProductFamilleButton.setPrefWidth(width / 2.0);
            } else if (this.page_products_famille == this.numberPageProductsFamille - 1) {
                double width = this.nextProductFamilleButton.getPrefWidth();
                this.nextProductFamilleButton.setVisible(false);
                this.nextProductFamilleButton.setManaged(false);
                this.previousProductFamilleButton.setPrefWidth(width * 2.0);
            }
        }
    }

    public void previousProductsFamille() {
        if (this.page_products_famille > 0) {
            --this.page_products_famille;
            this.loadPageProductsFamille(this.page_products_famille);
            if (!this.nextProductFamilleButton.isVisible()) {
                this.nextProductFamilleButton.setVisible(true);
                this.nextProductFamilleButton.setManaged(true);
            }
            if (this.page_products_famille > this.numberPageProductsFamille - 1) {
                double width = this.nextProductFamilleButton.getPrefWidth();
                this.nextProductFamilleButton.setPrefWidth(width / 2.0);
                this.previousProductFamilleButton.setVisible(true);
                this.previousProductFamilleButton.setManaged(true);
                this.previousProductFamilleButton.setPrefWidth(width);
            } else if (this.page_products_famille == 0) {
                double width = this.previousProductFamilleButton.getPrefWidth();
                this.previousProductFamilleButton.setVisible(false);
                this.previousProductFamilleButton.setManaged(false);
                this.nextProductFamilleButton.setPrefWidth(width * 2.0);
            }
        }
    }

    private void loadPageProductsFamille(int page_products_famille) {
        LinkedHashMap<Integer, DriveProductFamilleButton> mapProductFamilleButton = this.map_products_famille.get(page_products_famille);
        List productsFamilleButton = mapProductFamilleButton.values().stream().collect(Collectors.toList());
        int numberProductsFamille = productsFamilleButton.size();
        int index = 0;
        for (Node node : this.productsFamillePane.getChildren()) {
            if (index >= this.MAX_PRODUCT_FAMILLE) break;
            if (node instanceof GridPane) {
                GridPane productFamillePane = (GridPane)node;
                productFamillePane.getChildren().clear();
                if (index < numberProductsFamille) {
                    productFamillePane.add((Node)productsFamilleButton.get(index), 0, 0);
                }
            }
            ++index;
        }
    }

    private boolean isItemOfGroupProductsAlreadyAdded(CarteOrderInfo groupProducts) {
        int id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : -1;
        boolean itemAdded = false;
        for (int i = 0; i < this.listProducts.size(); ++i) {
            if (this.listProducts.get(i).getIdCarte() != id_group_products || this.listProducts.get(i).getIndex_carte() != index_group_products) continue;
            itemAdded = true;
        }
        return itemAdded;
    }

    public void selectProductFamille(CarteOrderInfo groupProducts, ProductInfoExt productFamille) {
        int id_group_products;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (productFamille != null ? productFamille.getIndex_sub_product() : -1);
        String name_group_products = groupProducts != null ? groupProducts.getName() : null;
        String id_global_carte = groupProducts != null ? groupProducts.getId_global() : null;
        String ref_carte = groupProducts != null ? groupProducts.getRef_web() : null;
        String size_group_products = groupProducts != null && groupProducts.getSizeCarte() != null && !groupProducts.getSizeCarte().isEmpty() ? groupProducts.getSizeCarte() : this.name_sizeProduct;
        boolean itemAdded = this.isItemOfGroupProductsAlreadyAdded(groupProducts);
        int index_product_item = this.indexSubProductIfExist(productFamille, groupProducts);
        if (!itemAdded && index_product_item == -1) {
            ProductTicket productTicket = new ProductTicket(productFamille, id_group_products, name_group_products, 1, index_group_products, this.name_sizeProduct, productFamille.getRef_web(), ref_carte, id_global_carte);
            this.listProducts.add(productTicket);
            this.loadInfoProduct(productFamille, size_group_products, groupProducts);
            this.loadOptionsTabs_GroupProduct(groupProducts, productFamille);
            productTicket.setOptions(productFamille.getSupplements());
        }
        if (index_product_item != -1) {
            this.listProducts.get(index_product_item);
            this.loadInfoProduct(productFamille, size_group_products, groupProducts);
            this.loadOptionsTabs_GroupProduct(groupProducts, productFamille);
        }
        this.setPriceTotal();
    }

    public void checkAndDeleteProductFamille(CarteOrderInfo groupProducts, ProductInfoExt productFamille) {
        int id_group_products;
        this.currentSubProductName = null;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (productFamille != null ? productFamille.getIndex_sub_product() : -1);
        int index_product_item = this.indexSubProductIfExist(productFamille, groupProducts);
        if (index_product_item != -1) {
            this.listProducts.remove(index_product_item);
            ArrayList<OptionItemOrder> listSupplement = new ArrayList<OptionItemOrder>();
            ArrayList<ItemOrderInfo> listIngredient = new ArrayList<ItemOrderInfo>();
            listSupplement.addAll(this.listChoiceSupplement);
            listIngredient.addAll(this.listChoiceIngredient);
            boolean delete = false;
            for (ItemOrderInfo ingredient : this.listChoiceIngredient) {
                if (ingredient.getIdCarte() != id_group_products || ingredient.getIdProduct() != productFamille.getID() || ingredient.getIndex_carte() != index_group_products) continue;
                listIngredient.remove(ingredient);
                delete = true;
            }
            for (OptionItemOrder supplement : this.listChoiceSupplement) {
                if (supplement.getIdCarte() != id_group_products || supplement.getIdProduct() != productFamille.getID() || supplement.getIndex_carte() != index_group_products) continue;
                listSupplement.remove(supplement);
                delete = true;
            }
            if (delete) {
                this.listChoiceSupplement.clear();
                this.listChoiceSupplement.addAll(listSupplement);
                this.listChoiceIngredient.clear();
                this.listChoiceIngredient.addAll(listIngredient);
            }
            this.optionTabsPages.getChildren().clear();
            this.optionsPane.getChildren().clear();
            this.optionsPane.setStyle("");
            this.setPriceTotal();
        }
        this.toggleHeaderButtons((Node)this.header_detail_product_pages);
        this.preparePane(this.productsFamillePane);
        this.loadProductsFamille(groupProducts);
    }

    private void loadInfoProduct(ProductInfoExt subProduct, String size_group_products, CarteOrderInfo groupProducts) {
        try {
            int index_group_products;
            int id_group_products;
            int id_sub_product = subProduct != null ? subProduct.getID() : -1;
            int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
            int n2 = groupProducts != null ? groupProducts.getIndex_carte() : (index_group_products = subProduct != null ? subProduct.getIndex_sub_product() : -1);
            if (subProduct.getIngredients().isEmpty()) {
                List<SupplementItemInfo> ingredientsItem = this.dlSales.getIngredientsByProducts(subProduct.getID(), false, false);
                subProduct.setIngredients(ingredientsItem);
            }
            if (subProduct.getSupplements().isEmpty()) {
                List<SupplementProduct> optionsProduct = this.dlItems.getSupplementsByProduct(subProduct.getID(), false, true);
                subProduct.setSupplements(optionsProduct);
                for (SupplementProduct supplement : subProduct.getSupplements()) {
                    List<SupplementItemInfo> optionsItem = this.dlItems.getSuppelementsItem(supplement.getiD(), true);
                    if (optionsItem.size() <= 0) continue;
                    ArrayList<SupplementItemInfo> optionsItemToAdd = new ArrayList<SupplementItemInfo>();
                    for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
                        if (supplement.getiD() != optionItemOrder.getId_groupe_option() || id_sub_product != optionItemOrder.getIdProduct() || id_group_products != optionItemOrder.getIdCarte() || index_group_products != optionItemOrder.getIndex_carte()) continue;
                        supplement.setOption_free_tmp(supplement.getOption_free_tmp() + optionItemOrder.getNumber_free());
                    }
                    for (SupplementItemInfo item : optionsItem) {
                        double price_option = item.getPriceOption(size_group_products, this.type_order);
                        if (this.product.isMany_size() && item.isMany_size() && price_option == -1.0) continue;
                        item.setPrice_order(price_option);
                        optionsItemToAdd.add(item);
                    }
                    supplement.setItems(optionsItemToAdd);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void loadDetailSubProduct(ProductInfoExt subProduct) {
        this.loadInfoProduct(subProduct, this.name_sizeProduct, null);
        this.loadOptionsTabs_DirectSubProduct(subProduct);
    }

    private void loadIngredients() {
        this.NUMBER_COLUMN_INGREDIENT = 4;
        this.NUMBER_ROW_INGREDIENT = 4;
        this.MAX_INGREDIENTS_PER_PAGE = 15;
        this.heightIngredientsPane = this.screenHeight * 0.63;
        this.loadIngredients(null, this.product);
    }

    private void loadIngredients_SubProduct(CarteOrderInfo groupProducts, ProductInfoExt subProduct) {
        this.NUMBER_COLUMN_INGREDIENT = 4;
        this.NUMBER_ROW_INGREDIENT = 4;
        this.MAX_INGREDIENTS_PER_PAGE = 15;
        this.heightIngredientsPane = this.screenHeight * 0.4 - 40.0;
        this.loadIngredients(groupProducts, subProduct);
    }

    private void loadHeaderTab(DriveHeaderDetailProductButton firstButton) {
        if (firstButton != null) {
            switch (firstButton.getGroup_type()) {
                case "ingredients": {
                    this.deselectHeaderTabs(firstButton.getIndex());
                    this.selectHeaderTab(firstButton);
                    this.loadIngredients();
                    break;
                }
                case "sub_product": {
                    this.deselectHeaderTabs(firstButton.getIndex());
                    this.selectHeaderTab(firstButton);
                    if (firstButton.getGroupItem() == null || !(firstButton.getGroupItem() instanceof ProductInfoExt)) break;
                    ProductInfoExt subProduct = (ProductInfoExt)firstButton.getGroupItem();
                    this.loadDetailSubProduct(subProduct);
                    break;
                }
                case "group_products": {
                    this.deselectHeaderTabs(firstButton.getIndex());
                    this.selectHeaderTab(firstButton);
                    if (firstButton.getGroupItem() == null || !(firstButton.getGroupItem() instanceof CarteOrderInfo)) break;
                    CarteOrderInfo groupProducts = (CarteOrderInfo)firstButton.getGroupItem();
                    this.loadProductsFamille(groupProducts);
                    break;
                }
                case "options": {
                    this.deselectHeaderTabs(firstButton.getIndex());
                    this.selectHeaderTab(firstButton);
                    this.loadOptionsTabs_Product();
                }
            }
        }
    }

    private List<OptionItemOrder> getChosenSubOptions(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo option) {
        int id_group_products;
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        ArrayList<OptionItemOrder> listChosenOptionsMultiple = new ArrayList<OptionItemOrder>();
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            if (optionItemOrder.getIdCarte() != id_group_products && (id_group_products != -1 || optionItemOrder.getIdCarte() != 0) || optionItemOrder.getIdProduct() != id_sub_product && (id_sub_product != -1 || optionItemOrder.getIdProduct() != 0) || optionItemOrder.getParent_supplement_id() != option.getiD() || optionItemOrder.getIndex_carte() != index_group_products) continue;
            listChosenOptionsMultiple.add((OptionItemOrder)optionItemOrder.clone());
        }
        return listChosenOptionsMultiple;
    }

    public void loadSubSupplements(int optionId) {
        DriveOptionDetailButton buttonOption = this.getOptionBtn(optionId);
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        ProductInfoExt subProduct = buttonOption.getSubProduct();
        SupplementItemInfo optionItem = buttonOption.getOption();
        this.subOptionsMainPane.getProperties().put((Object)"groupProducts", (Object)groupProducts);
        this.subOptionsMainPane.getProperties().put((Object)"subProduct", (Object)subProduct);
        this.subOptionsMainPane.getProperties().put((Object)"optionItem", (Object)optionItem);
        this.options_main_pane.setEffect((Effect)new BoxBlur(6.0, 6.0, 4));
        this.subOptionsPane.setManaged(true);
        this.subOptionsPane.setVisible(true);
        List<OptionItemOrder> listChosenSubSupplement = this.getChosenSubOptions(groupProducts, subProduct, optionItem);
        this.subOptionsMainPane.getChildren().clear();
        if (this.subSupplementsController == null) {
            this.subSupplementsController = new DriveSubSupplementsController(this.refOptions, this.subOptionsMainPane);
        }
        this.subSupplementsController.initializer(buttonOption, groupProducts, subProduct, optionItem, listChosenSubSupplement, buttonOption.getIndex_group_option());
    }

    public void hideSubSupplements(boolean resultIsValid) {
        System.out.println("hideSubSupplements drive : " + new Date());
        this.subOptionsPane.setManaged(false);
        this.subOptionsPane.setVisible(false);
        this.options_main_pane.setEffect(null);
        if (this.subSupplementsController != null && resultIsValid) {
            this.subSupplementsController.valid();
            SupplementItemInfo optionItemParent = this.subSupplementsController.getParentSupplement();
            CarteOrderInfo groupProducts = this.subSupplementsController.getGroupProducts();
            ProductInfoExt subProduct = this.subSupplementsController.getSubProduct();
            SubSupplementResult result = this.subSupplementsController.getResult();
            List<OptionItemOrder> supplements = result.getListChoiceSupplement();
            System.out.println("hideSubSupplements supplements size : " + supplements.size());
            List<OptionItemOrder> supplements_to_delete = result.getSupplements_to_delete();
            this.deleteOption(groupProducts, subProduct, optionItemParent, supplements_to_delete);
            this.chooseOptions(groupProducts, subProduct, optionItemParent, supplements);
        }
    }

    private void deleteOption(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo optionItemParent, List<OptionItemOrder> supplements_to_delete) {
        for (OptionItemOrder subOption : supplements_to_delete) {
            OptionItemOrder option_to_delete = this.getSubOption(groupProducts, subProduct, optionItemParent, subOption);
            if (option_to_delete == null) continue;
            this.listChoiceSupplement.remove(option_to_delete);
        }
        this.setPriceTotal();
    }

    private void chooseOptions(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo optionItemParent, List<OptionItemOrder> supplements) {
        for (OptionItemOrder subOption : supplements) {
            System.out.println("subOption : " + subOption);
            OptionItemOrder sub_option = this.getSubOption(groupProducts, subProduct, optionItemParent, subOption);
            System.out.println("sub_option : " + sub_option);
            if (sub_option != null) continue;
            this.listChoiceSupplement.add(subOption);
        }
        this.setPriceTotal();
    }

    private OptionItemOrder getSubOption(CarteOrderInfo groupProducts, ProductInfoExt subProduct, SupplementItemInfo optionItemParent, OptionItemOrder subOptionItem) {
        int id_group_products;
        int id_sub_product = subProduct != null ? subProduct.getID() : -1;
        int n = id_group_products = groupProducts != null ? groupProducts.getId() : -1;
        int index_group_products = groupProducts != null ? groupProducts.getIndex_carte() : (subProduct != null ? subProduct.getIndex_sub_product() : -1);
        int sub_supplement_id = subOptionItem.getSupplement();
        int parent_supplement_id = optionItemParent.getiD();
        OptionItemOrder option = null;
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            if (optionItemOrder.getIdCarte() != id_group_products && (id_group_products != -1 || optionItemOrder.getIdCarte() != 0) || optionItemOrder.getIdProduct() != id_sub_product && (id_sub_product != -1 || optionItemOrder.getIdProduct() != 0) || optionItemOrder.getIndex_carte() != index_group_products || sub_supplement_id != optionItemOrder.getSupplement() || parent_supplement_id != optionItemOrder.getParent_supplement_id()) continue;
            option = optionItemOrder;
            break;
        }
        return option;
    }

    private void setPriceTotal() {
        double price = this.priceProduct;
        System.out.println("price : " + price);
        for (OptionItemOrder optionItemOrder : this.listChoiceSupplement) {
            price += optionItemOrder.getPrice().doubleValue();
        }
        for (ProductTicket subProduct : this.listProducts) {
            price += subProduct.getPriceProduct();
        }
        this.priceSell = price;
        this.price_label.setText(this.printPriceSell());
        int numberItems = this.getNumberItems();
        this.quantity_label.setText("Quantit\u00e9 " + numberItems);
    }

    public void checkAndValid() {
        try {
            int number;
            ArrayList<DetailProductError> errors = new ArrayList<DetailProductError>();
            for (SupplementProduct option : this.options) {
                if (!option.getHas_options().booleanValue()) continue;
                number = 0;
                for (OptionItemOrder supplement : this.listChoiceSupplement) {
                    if (supplement.getParent_supplement_id() != 0 || supplement.getId_groupe_option() != option.getiD() || supplement.getIdCarte() != -1 && supplement.getIdCarte() != 0 || supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
                    number += supplement.getNumberOption();
                }
                if ((number >= option.getMin_options() || number >= option.getItems().size() * option.getNumber_click()) && number <= option.getMax_options()) continue;
                errors.add(new DetailProductError(null, null, option, STR_OPTIONS, option.getMin_options(), option.getMax_options(), number, option.getName()));
            }
            for (CarteOrderInfo groupProduct : this.groupProducts) {
                number = 0;
                for (ProductTicket subProduct : this.listProducts) {
                    if (subProduct.getIdCarte() != groupProduct.getId() || groupProduct.getIndex_carte() != subProduct.getIndex_carte()) continue;
                    ++number;
                }
                if (number != 0) continue;
                errors.add(new DetailProductError(groupProduct, null, null, STR_GROUP_PRODUCTS, 1, 1, number, groupProduct.getName()));
            }
            for (ProductTicket subProduct : this.listProducts) {
                for (SupplementProduct option : subProduct.getOptions()) {
                    if (!option.getHas_options().booleanValue()) continue;
                    int number2 = 0;
                    for (OptionItemOrder supplement : this.listChoiceSupplement) {
                        if (supplement.getParent_supplement_id() != 0 || supplement.getId_groupe_option() != option.getiD() || supplement.getIdCarte() != subProduct.getIdCarte() || supplement.getIdProduct() != subProduct.getIdProduct() || supplement.getIndex_carte() != subProduct.getIndex_carte()) continue;
                        number2 += supplement.getNumberOption();
                    }
                    if ((number2 >= option.getMin_options() || number2 >= option.getItems().size() * option.getNumber_click()) && number2 <= option.getMax_options()) continue;
                    errors.add(new DetailProductError(null, subProduct, option, STR_SUB_PRODUCT, option.getMin_options(), option.getMax_options(), number2, subProduct.getNameProduct() + " - " + option.getName()));
                }
            }
            if (errors.isEmpty()) {
                this.hidePopup.apply(null);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void setOptionsOfSubProducts() throws BasicException {
        if (this.listProducts != null) {
            for (ProductTicket subProduct : this.listProducts) {
                if (subProduct.getOptions() != null && !subProduct.getOptions().isEmpty()) continue;
                List<SupplementProduct> optionsProduct = this.dlItems.getSupplementsByProduct(subProduct.getIdProduct(), false, true);
                for (SupplementProduct supplementProduct : optionsProduct) {
                    List<SupplementItemInfo> optionsItem = this.dlItems.getSuppelementsItem(supplementProduct.getiD(), true);
                    supplementProduct.setItems(optionsItem);
                }
                subProduct.setOptions(optionsProduct);
            }
        }
    }

    private void deleteSubOptions(DriveOptionDetailButton buttonOption) {
        SupplementItemInfo optionItemParent;
        ProductInfoExt subProduct;
        CarteOrderInfo groupProducts = buttonOption.getGroupProducts();
        List<OptionItemOrder> supplements_to_delete = this.getChosenSubOptions(groupProducts, subProduct = buttonOption.getSubProduct(), optionItemParent = buttonOption.getOption());
        if (supplements_to_delete != null && !supplements_to_delete.isEmpty()) {
            for (OptionItemOrder sub_option : supplements_to_delete) {
                OptionItemOrder sub_option_to_delete = this.getSubOption(groupProducts, subProduct, optionItemParent, sub_option);
                if (sub_option_to_delete == null) continue;
                this.listChoiceSupplement.remove(sub_option_to_delete);
            }
            this.setPriceTotal();
        }
    }

    private void loadDetailGroupOption(DriveGroupOptionsHeaderButton buttonGroupOption) {
        this.deselectOptionTabs(buttonGroupOption.getIndex());
        this.selectOptionTab(buttonGroupOption);
        if (buttonGroupOption.getGroupOption().getIs_ingredient().booleanValue()) {
            this.loadIngredients_SubProduct(buttonGroupOption.getGroupProducts(), buttonGroupOption.getProduct());
        } else {
            this.loadOptions(buttonGroupOption);
        }
    }

    public void checkAddMinItems() {
        boolean error = false;
        try {
            int number;
            for (SupplementProduct option : this.options) {
                if (!option.getHas_options().booleanValue()) continue;
                number = 0;
                for (OptionItemOrder supplement : this.listChoiceSupplement) {
                    if (supplement.getParent_supplement_id() != 0 || supplement.getId_groupe_option() != option.getiD() || supplement.getIdCarte() != -1 && supplement.getIdCarte() != 0 || supplement.getIdProduct() != -1 && supplement.getIdProduct() != 0) continue;
                    number += supplement.getNumberOption();
                }
                if (number >= option.getMin_options() || number >= option.getItems().size() * option.getNumber_click()) continue;
                error = true;
            }
            for (CarteOrderInfo groupProduct : this.groupProducts) {
                number = 0;
                for (ProductTicket subProduct : this.listProducts) {
                    if (subProduct.getIdCarte() != groupProduct.getId() || groupProduct.getIndex_carte() != subProduct.getIndex_carte()) continue;
                    ++number;
                }
                if (number != 0) continue;
                error = true;
            }
            for (ProductTicket subProduct : this.listProducts) {
                for (SupplementProduct option : subProduct.getOptions()) {
                    if (!option.getHas_options().booleanValue()) continue;
                    int number2 = 0;
                    for (OptionItemOrder supplement : this.listChoiceSupplement) {
                        if (supplement.getParent_supplement_id() != 0 || supplement.getId_groupe_option() != option.getiD() || supplement.getIdCarte() != subProduct.getIdCarte() || supplement.getIdProduct() != subProduct.getIdProduct() || supplement.getIndex_carte() != subProduct.getIndex_carte()) continue;
                        number2 += supplement.getNumberOption();
                    }
                    if (number2 >= option.getMin_options() || number2 >= option.getItems().size() * option.getNumber_click()) continue;
                    error = true;
                }
            }
            if (error) {
                if (this.productValid) {
                    this.valid_product_button.setStyle("-fx-background-color: #2D2D2D;-fx-background-radius: 0px 0px 11px 11px;-fx-text-fill: white;");
                }
                this.productValid = false;
            } else {
                if (!this.productValid) {
                    this.valid_product_button.setStyle("-fx-background-color: #0B8871;-fx-background-radius: 0px 0px 11px 11px;-fx-text-fill: white;");
                }
                this.productValid = true;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private int getNumberItems() {
        int quantity = (int)this.multiply;
        for (OptionItemOrder supplement : this.listChoiceSupplement) {
            quantity = (int)((double)quantity + (double)supplement.getNumberOption() * this.multiply);
        }
        for (ProductTicket subProduct : this.listProducts) {
            quantity = (int)((double)quantity + (double)subProduct.getNumberProduct() * this.multiply);
        }
        return quantity;
    }

    private void loadSelectedSubProduct(DriveProductFamilleButton productButtonSelected) {
        System.out.println("++++++ selected_currentSubProductName: " + this.currentSubProductName);
        CarteOrderInfo groupProducts = productButtonSelected.getGroupProduct();
        ProductInfoExt productFamille = productButtonSelected.getProduct();
        String size_group_products = groupProducts != null && groupProducts.getSizeCarte() != null && !groupProducts.getSizeCarte().isEmpty() ? groupProducts.getSizeCarte() : this.name_sizeProduct;
        this.loadInfoProduct(productFamille, size_group_products, groupProducts);
        this.loadOptionsTabs_GroupProduct(groupProducts, productFamille);
        int page = this.getPageProductFamille(productButtonSelected);
        if (page < this.numberPageProductsFamille) {
            this.page_products_famille = page;
            this.loadPageProductsFamille(this.page_products_famille);
            if (this.page_products_famille == this.numberPageProductsFamille - 1 && this.nextProductFamilleButton != null) {
                this.nextProductFamilleButton.setDisable(true);
            }
            if (this.previousProductFamilleButton != null) {
                this.previousProductFamilleButton.setDisable(false);
            }
        }
    }

    public int getPageProductFamille(DriveProductFamilleButton productButtonSelected) {
        int index = productButtonSelected.getIndex();
        int page = (int)Math.ceil((double)(index + 1) / (double)this.numberPageProductsFamille);
        return --page;
    }

    private DriveIngredientDetailButton getIngredientButton(int idIngredient) {
        return this.map_ingredients.values().stream().flatMap(val -> val.stream()).filter(ing -> ing.getIngredient().getiD() == idIngredient).findFirst().orElse(null);
    }

    private DriveHeaderDetailProductButton getGroupTabBtn(String type, Integer index) {
        return this.groupTabs.stream().filter(tab -> {
            boolean sameType = type.equalsIgnoreCase(tab.getGroup_type());
            boolean sameIndex = true;
            if (index != null) {
                sameIndex = Objects.equals(tab.getIndex(), index);
            }
            return sameType && sameIndex;
        }).findFirst().orElse(null);
    }

    private DriveOptionDetailButton getOptionBtn(int optionId) {
        return this.optionsButtons.stream().filter(optionBtn -> Objects.equals(optionBtn.getOption().getiD(), optionId)).findFirst().orElse(null);
    }

    private DriveGroupOptionsHeaderButton getGroupOptionTabBtn(OptionDetailProductTab tab) {
        return this.groupOptionTabs.stream().filter(btn -> Objects.equals(this.buildSomeId(btn.getGroupProducts(), btn.getProduct(), btn.getGroupOption()), this.buildSomeId(tab.getGroupProducts(), tab.getProduct(), tab.getGroupOption()))).findFirst().orElse(null);
    }

    private String buildSomeId(CarteOrderInfo groupProducts, ProductInfoExt product, SupplementProduct groupOption) {
        String id1 = "";
        String id2 = "";
        String id3 = "";
        if (groupProducts != null) {
            id1 = Objects.requireNonNullElse(groupProducts.getId(), 0).toString();
        }
        if (product != null) {
            id2 = Objects.requireNonNullElse(product.getID(), 0).toString();
        }
        if (groupOption != null) {
            id3 = Objects.requireNonNullElse(groupOption.getiD(), 0).toString();
        }
        return String.join((CharSequence)"_", List.of(id1, id2, id3));
    }

    public boolean isSoldedOut() {
        return this.product.isSold_out() || this.product.isSold_out_temporary();
    }

    public void preparePane(ProductInfoExt subProduct) {
        this.ingredientsSpecialPane.setVisible(true);
        this.ingredientsSpecialPane.setManaged(true);
        Image image = this.mImagesUtils.getImageProduct(subProduct, this.refProducts, "", true);
        ImageView imageItem = new ImageView(image);
        imageItem.setFitHeight(this.screenHeight * 0.3);
        imageItem.setPreserveRatio(true);
        imageItem.setSmooth(true);
        this.ingredientsProductImage.setGraphic((Node)imageItem);
        this.ingredientsProductName.setText(subProduct.getName());
        this.ingredientsProductPrice.setText(" + " + Formats.CURRENCY.formatValue(subProduct.getPriceSell()));
    }

    public void preparePane(GridPane pane) {
        this.options_main_pane.setEffect(null);
        if (this.ingredientsSpecialPane.isVisible()) {
            this.ingredientsSpecialPane.setVisible(false);
            this.ingredientsSpecialPane.setManaged(false);
        }
        if (this.productsFamillePane.getId().equals(pane.getId())) {
            this.footer_pane.setVisible(false);
            this.footer_pane.setManaged(false);
        } else {
            this.footer_pane.setVisible(true);
            this.footer_pane.setManaged(true);
        }
        for (GridPane p : List.of(this.productsFamillePane, this.optionsPane)) {
            if (p.getId().equalsIgnoreCase(pane.getId())) {
                p.setVisible(true);
                p.setManaged(true);
                p.getChildren().clear();
                continue;
            }
            p.setVisible(false);
            p.setManaged(false);
        }
    }

    public void toggleHeaderButtons(Node pane) {
        if (this.optionTabsPages.getId().equalsIgnoreCase(pane.getId())) {
            this.header_detail_product_pages.setVisible(false);
            this.header_detail_product_pages.setManaged(false);
            this.optionTabsPages.setVisible(true);
            this.optionTabsPages.setManaged(true);
            this.optionTabsPages.getChildren().clear();
        } else {
            this.optionTabsPages.setVisible(false);
            this.optionTabsPages.setManaged(false);
            this.header_detail_product_pages.setVisible(true);
            this.header_detail_product_pages.setManaged(true);
        }
    }

    public void loadGroupOptionsWithError(DetailProductError detailProductError) {
        if (detailProductError.getGroupOption() != null) {
            int page;
            DriveHeaderDetailProductButton groupTabOption = null;
            for (DriveHeaderDetailProductButton groupTab : this.groupTabs) {
                if (!groupTab.getGroup_type().equals(STR_OPTIONS)) continue;
                groupTabOption = groupTab;
            }
            if (groupTabOption != null && (page = this.getPageHeaderTab(groupTabOption)) < this.numberPageDetailProductHeader) {
                this.page_detail_product_header = page;
                this.header_detail_product_pane.getChildren().clear();
                this.header_detail_product_pane.getChildren().addAll((Collection)this.headerButtonsArray.get(this.page_detail_product_header));
                if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                    // empty if block
                }
                this.deselectHeaderTabs(groupTabOption.getIndex());
                this.selectHeaderTab(groupTabOption);
                this.loadOptionsTabs_Product();
                SupplementProduct groupOption = detailProductError.getGroupOption();
                this.loadGroupOptionWithChangePage(groupOption);
            }
        }
    }

    private void loadGroupOptionWithChangePage(SupplementProduct groupOption) {
        int index_group_option;
        DriveGroupOptionsHeaderButton optionDetailProductTab = null;
        for (DriveGroupOptionsHeaderButton groupOptionTab : this.groupOptionTabs) {
            if (groupOptionTab.getGroupOption().getiD() != groupOption.getiD()) continue;
            optionDetailProductTab = groupOptionTab;
            break;
        }
        if (optionDetailProductTab != null && (index_group_option = optionDetailProductTab.getIndex()) < this.groupOptionTabs.size()) {
            int page = (int)Math.ceil((double)(index_group_option + 1) / (double)this.MAX_OPTIONS_TABS);
            if (--page < this.numberPageOptionsTabs) {
                this.page_options_tabs = page;
                this.groupOptionsPane.getChildren().clear();
                this.groupOptionsPane.getChildren().addAll((Collection)this.optionTabsArray.get(this.page_options_tabs));
                if (this.page_options_tabs == this.numberPageOptionsTabs - 1) {
                    // empty if block
                }
                this.loadDetailGroupOption(optionDetailProductTab);
            }
        }
    }

    public void loadGroupProductsWithError(DetailProductError detailProductError) {
        if (detailProductError.getGroupProducts() != null) {
            DriveHeaderDetailProductButton groupProductsTab = null;
            for (DriveHeaderDetailProductButton groupTab : this.groupTabs) {
                if (!groupTab.getGroup_type().equals(STR_GROUP_PRODUCTS) || !(groupTab.getGroupItem() instanceof CarteOrderInfo) || ((CarteOrderInfo)groupTab.getGroupItem()).getId() != detailProductError.getGroupProducts().getId() || ((CarteOrderInfo)groupTab.getGroupItem()).getIndex_carte() != detailProductError.getGroupProducts().getIndex_carte()) continue;
                groupProductsTab = groupTab;
            }
            this.loadGroupProduct(groupProductsTab, null);
        }
    }

    private void loadGroupProduct(DriveHeaderDetailProductButton groupProductsTab, DetailProductError detailProductError) {
        int page;
        if (groupProductsTab != null && (page = this.getPageHeaderTab(groupProductsTab)) < this.numberPageDetailProductHeader) {
            this.page_detail_product_header = page;
            this.header_detail_product_pane.getChildren().clear();
            this.header_detail_product_pane.getChildren().addAll((Collection)this.headerButtonsArray.get(this.page_detail_product_header));
            if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                // empty if block
            }
            this.deselectHeaderTabs(groupProductsTab.getIndex());
            this.selectHeaderTab(groupProductsTab);
            if (groupProductsTab.getGroupItem() != null && groupProductsTab.getGroupItem() instanceof CarteOrderInfo) {
                CarteOrderInfo groupProducts = (CarteOrderInfo)groupProductsTab.getGroupItem();
                this.loadProductsFamille(groupProducts);
                if (detailProductError != null && detailProductError.getGroupOption() != null) {
                    SupplementProduct groupOption = detailProductError.getGroupOption();
                    this.loadGroupOptionWithChangePage(groupOption);
                }
            }
        }
    }

    public void loadSubProductWithError(DetailProductError detailProductError) {
        if (detailProductError.getSubProduct() != null) {
            ProductTicket productTicket = detailProductError.getSubProduct();
            if (productTicket.getIdCarte() != 0 && productTicket.getIdCarte() != -1) {
                DriveHeaderDetailProductButton groupProductsTab = null;
                for (DriveHeaderDetailProductButton groupTab : this.groupTabs) {
                    if (!groupTab.getGroup_type().equals(STR_GROUP_PRODUCTS) || !(groupTab.getGroupItem() instanceof CarteOrderInfo) || ((CarteOrderInfo)groupTab.getGroupItem()).getId() != productTicket.getIdCarte() || ((CarteOrderInfo)groupTab.getGroupItem()).getIndex_carte() != productTicket.getIndex_carte()) continue;
                    groupProductsTab = groupTab;
                }
                this.loadGroupProduct(groupProductsTab, detailProductError);
            } else {
                int page;
                DriveHeaderDetailProductButton subProductsTab = null;
                for (DriveHeaderDetailProductButton groupTab : this.groupTabs) {
                    if (!groupTab.getGroup_type().equals(STR_SUB_PRODUCT) || !(groupTab.getGroupItem() instanceof ProductInfoExt) || ((ProductInfoExt)groupTab.getGroupItem()).getID() != productTicket.getIdProduct() || ((ProductInfoExt)groupTab.getGroupItem()).getIndex_sub_product() != productTicket.getIndex_carte()) continue;
                    subProductsTab = groupTab;
                }
                if (subProductsTab != null && (page = this.getPageHeaderTab(subProductsTab)) < this.numberPageDetailProductHeader) {
                    this.page_detail_product_header = page;
                    this.header_detail_product_pane.getChildren().clear();
                    this.header_detail_product_pane.getChildren().addAll((Collection)this.headerButtonsArray.get(this.page_detail_product_header));
                    if (this.page_detail_product_header == this.numberPageDetailProductHeader - 1) {
                        // empty if block
                    }
                    if (subProductsTab.getGroupItem() != null && subProductsTab.getGroupItem() instanceof ProductInfoExt) {
                        ProductInfoExt subProduct = (ProductInfoExt)subProductsTab.getGroupItem();
                        this.deselectHeaderTabs(subProductsTab.getIndex());
                        this.selectHeaderTab(subProductsTab);
                        this.loadDetailSubProduct(subProduct);
                        SupplementProduct groupOption = detailProductError.getGroupOption();
                        this.loadGroupOptionWithChangePage(groupOption);
                    }
                }
            }
        }
    }

    public void setOptionsPaneBannerStyle(boolean subProducts, boolean options) {
        if (options) {
            this.setOptionsPaneBannerStyle(true);
            this.toggleStepper(false, this.getGroupTabBtn(STR_OPTIONS, null).getContent());
            this.image_product_label.setVisible(false);
            this.image_product_label.setManaged(false);
            this.name_product_label.setTextAlignment(TextAlignment.CENTER);
            this.name_menu_label.setTextAlignment(TextAlignment.CENTER);
            double resizedWidth = this.options_main_pane.getPrefWidth() * 0.9;
            this.name_menu_label.setMinWidth(resizedWidth);
            this.name_menu_label.setMaxWidth(resizedWidth);
            this.name_menu_label.setPadding(Insets.EMPTY);
            this.name_product_label.setMinWidth(resizedWidth);
            this.name_product_label.setMaxWidth(resizedWidth);
            this.name_product_label.setPadding(Insets.EMPTY);
        } else {
            this.setOptionsPaneBannerStyle(subProducts);
            this.name_product_label.setTextAlignment(TextAlignment.LEFT);
            this.name_menu_label.setTextAlignment(TextAlignment.LEFT);
            double resizedWidth = this.options_main_pane.getPrefWidth() * 0.55;
            this.name_menu_label.setMinWidth(resizedWidth);
            this.name_menu_label.setMaxWidth(resizedWidth);
            this.name_menu_label.setPadding(new Insets(0.0, 0.0, 0.0, 40.0));
            this.name_product_label.setMinWidth(resizedWidth);
            this.name_product_label.setMaxWidth(resizedWidth);
            this.name_product_label.setPadding(new Insets(0.0, 0.0, 0.0, 40.0));
            this.image_product_label.setVisible(true);
            this.image_product_label.setManaged(true);
            if (subProducts) {
                this.toggleStepper(false, null);
            } else {
                this.loadMenuStepper();
            }
        }
    }

    public void setOptionsPaneBannerStyle(boolean subProducts) {
        if (this.bannerIntermediateImage.getImage() == null) {
            Image image = new Image("/images/dust-original.png");
            this.bannerIntermediateImage.setImage(image);
            this.bannerIntermediateImage.setPreserveRatio(false);
            this.bannerIntermediateImage.setSmooth(false);
            this.bannerIntermediateImage.setCache(true);
        }
        if (subProducts) {
            String col = ColorUtils.getColorText(ColorUtils.increaseSaturation(ColorUtils.getColorByString(AppLocal.color_borne)));
            this.optionsPaneBanner.setStyle("-fx-font-family: Namaku; -fx-border-radius: 20px; -fx-background-radius: 20px; -fx-background-color: linear-gradient(from 0% 0% to 100% 100%, " + ColorUtils.getColor(col) + ", " + this.hexColorBorne + ");");
        } else {
            this.optionsPaneBanner.setStyle("-fx-font-family: Namaku; -fx-border-radius: 20px; -fx-background-radius: 20px; -fx-background-color: linear-gradient(from 0% 0% to 100% 100%, #000000, " + this.hexColorBorne + ");");
        }
    }

    private void loadMenuStepper() {
        int index = 1;
        this.stepperButtons.clear();
        double heightDetailProductPane = this.options_main_pane.getPrefHeight() * 0.08;
        double widthDetailProductTab = this.options_main_pane.getPrefWidth() * 0.55 / 3.0;
        if (!this.ingredients.isEmpty()) {
            DriveHeaderDetailProductButton ingredientButton = new DriveHeaderDetailProductButton(STR_INGREDIENTS, null, index++, widthDetailProductTab, heightDetailProductPane * 0.9);
            this.stepperButtons.add(ingredientButton);
        }
        if (!this.subProducts.isEmpty()) {
            for (ProductInfoExt sub_product : this.subProducts) {
                DriveHeaderDetailProductButton subProductButton = new DriveHeaderDetailProductButton(STR_SUB_PRODUCT, sub_product, index++, widthDetailProductTab, heightDetailProductPane * 0.9);
                this.stepperButtons.add(subProductButton);
            }
        }
        if (!this.groupProducts.isEmpty()) {
            for (CarteOrderInfo groupProduct : this.groupProducts) {
                DriveHeaderDetailProductButton groupProductButton = new DriveHeaderDetailProductButton(STR_GROUP_PRODUCTS, groupProduct, index++, widthDetailProductTab, heightDetailProductPane * 0.9);
                this.stepperButtons.add(groupProductButton);
            }
        }
        if (!this.options.isEmpty()) {
            DriveHeaderDetailProductButton optionsButton = new DriveHeaderDetailProductButton(STR_OPTIONS, null, index++, widthDetailProductTab, heightDetailProductPane * 0.9);
            this.stepperButtons.add(optionsButton);
        }
        if (!this.stepperButtons.isEmpty()) {
            int startIndex = 0;
            int trueEndIndex = Math.min(this.stepperButtons.size(), 3);
            for (int j = startIndex; j < trueEndIndex; ++j) {
                DriveHeaderDetailProductButton headerButton = this.stepperButtons.get(j);
                int startOrEnd = 2;
                if (this.stepperButtons.size() == 1) {
                    startOrEnd = 0;
                } else {
                    if (j == startIndex) {
                        startOrEnd = -1;
                    }
                    if (j == trueEndIndex - 1) {
                        startOrEnd = 1;
                    }
                }
                headerButton.setViewForMenu(startOrEnd);
            }
            this.menu_stepper.getChildren().clear();
            this.menu_stepper.getChildren().addAll(this.stepperButtons.subList(startIndex, trueEndIndex));
        }
        try {
            this.category = this.dlItems.getCategoryInfo(String.valueOf(this.product.getCategoryid()));
        }
        catch (BasicException basicException) {
            // empty catch block
        }
        this.updateMenuStepper(this.menuCurrentStep, null);
    }

    private void updateMenuStepper(int selectedIndex, String subProductName) {
        System.out.println("subProductName : " + subProductName);
        if (this.stepperButtons.isEmpty()) {
            this.loadMenuStepper();
        }
        System.out.println("menuCurrentStep : " + this.menuCurrentStep);
        System.out.println("selectedIndex : " + selectedIndex);
        if (this.menuCurrentStep != selectedIndex) {
            this.menuCurrentStep = selectedIndex;
        }
        this.menuCurrentStep = selectedIndex;
        this.stepperButtons.stream().forEach(btn -> {
            if (btn.getIndex() == selectedIndex) {
                btn.select();
            } else {
                btn.deselect(selectedIndex);
            }
        });
        this.toggleStepper(true, subProductName);
    }

    private void toggleStepper(boolean showStepper, String name) {
        if (showStepper) {
            this.name_menu_label.setVisible(true);
            this.name_menu_label.setManaged(true);
            this.menu_stepper.setVisible(true);
            this.menu_stepper.setManaged(true);
            System.out.println("name : " + name);
            System.out.println("currentSubProductName : " + this.currentSubProductName);
            if (this.currentSubProductName != null) {
                this.setMenuLabelText(this.product.getName().toUpperCase());
                this.setProductName(List.of(this.currentSubProductName));
            } else {
                if (this.category != null) {
                    this.setMenuLabelText(this.category.getName());
                } else {
                    this.setMenuLabelText("");
                }
                this.setProductName(List.of("\n" + this.product.getName().toUpperCase() + "\n\n", this.printPriceSell()));
            }
        } else {
            this.menu_stepper.setVisible(false);
            this.menu_stepper.setManaged(false);
            if (name != null) {
                if (this.currentSubProductName != null) {
                    this.setMenuLabelText(this.currentSubProductName);
                } else {
                    this.setMenuLabelText(this.product.getName().toUpperCase());
                }
                this.setProductName(List.of(name));
            } else {
                if (this.category != null) {
                    this.setMenuLabelText(this.category.getName());
                }
                this.setProductName(List.of("\n" + this.product.getName().toUpperCase() + "\n\n", this.printPriceSell()));
            }
        }
    }

    public void setProductName(List<String> names) {
        this.name_product_label.getChildren().clear();
        ArrayList<Text> texts = new ArrayList<Text>();
        int index = 0;
        for (String name : names) {
            Text text = new Text((String)(index >= names.size() - 2 ? name : name + "\n"));
            text.setStyle("-fx-font-size: 30pt; -fx-fill: white;");
            texts.add(text);
            ++index;
        }
        this.name_product_label.getChildren().addAll(texts);
    }

    public void setMenuLabelText(String name) {
        this.name_menu_label.getChildren().clear();
        Text text = new Text(name);
        text.setStyle("-fx-font-size: 20pt; -fx-fill: white;");
        this.name_menu_label.getChildren().add((Object)text);
    }

    public void nextSubOptions() {
        if (this.subSupplementsController != null) {
            this.subSupplementsController.nextOptions();
        }
    }

    public void previousSubOptions() {
        if (this.subSupplementsController != null) {
            this.subSupplementsController.previousOptions();
        }
    }

    public void selectSubOptions(int subOptionId) {
        if (this.subSupplementsController != null) {
            System.out.println("subOptionId : " + subOptionId);
            this.subSupplementsController.selectOption(subOptionId);
        }
    }

    public void handleSubOptionAction(int subOptionId, boolean increase) {
        if (this.subSupplementsController != null) {
            this.subSupplementsController.handleSubOptionAction(subOptionId, increase);
        }
    }

    public void nextSubOptionHeaderTab() {
        if (this.subSupplementsController != null) {
            this.subSupplementsController.nextHeaderTab();
        }
    }

    public void previousSupOptionHeaderTab() {
        if (this.subSupplementsController != null) {
            this.subSupplementsController.previousHeaderTab();
        }
    }

    public void loadDetailGroupSubOption(int groupId, String type) {
        if (this.subSupplementsController != null) {
            this.subSupplementsController.loadDetailGroupSubOption(groupId, type);
        }
    }
}

