/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.CarteService;
import com.openbravo.service.ItemService;
import com.procaisse.db.connection.firebase.FirebaseService;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public class DownLoadJsonDBItemController {
    private AppView m_App;
    @FXML
    Label download_label;
    @FXML
    Label title_1;
    @FXML
    Label title_2;
    @FXML
    Label logo_label;
    @FXML
    GridPane main_pane;
    private ItemService mItemService;

    public void initialize(final AppView m_App, final boolean firstInstall, final String typeEquipement, final Scene sceneOrigin, final JFXPanel fxPanel) {
        try {
            this.m_App = m_App;
            Stop[] stops = new Stop[]{new Stop(0.0, Color.web((String)"#EF3A13")), new Stop(1.0, Color.web((String)"#9241A7"))};
            LinearGradient linearGradient = new LinearGradient(0.0, 0.0, 1.0, 1.0, true, CycleMethod.NO_CYCLE, stops);
            this.main_pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)linearGradient, null, null)}));
            Image image_logo = new Image(this.getClass().getResource("/com/openbravo/images/logo_biborne_new.png").toURI().toString());
            ImageView imageViewLogo = new ImageView(image_logo);
            imageViewLogo.setFitWidth(94.754);
            imageViewLogo.setFitHeight(31.77);
            imageViewLogo.setPreserveRatio(false);
            imageViewLogo.setSmooth(false);
            imageViewLogo.setCache(false);
            this.logo_label.setGraphic((Node)imageViewLogo);
            this.title_1.setText("Telechargement en Cours...");
            this.title_2.setText("Votre t\u00e9l\u00e9chargement est en cours. Merci de patienter");
            Image image_download = new Image(this.getClass().getResource("/com/openbravo/images/download_icon.png").toURI().toString());
            ImageView imageViewDownload = new ImageView(image_download);
            imageViewDownload.setFitWidth(AppVarUtils.getScreenDimension().getWidth() * 0.11);
            imageViewDownload.setPreserveRatio(true);
            imageViewDownload.setSmooth(true);
            imageViewDownload.setCache(true);
            this.download_label.setGraphic((Node)imageViewDownload);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    DownLoadJsonDBItemController.this.downloadCarte();
                    if (firstInstall) {
                        m_App.showFirstViewAfterDownloadDBItems();
                    } else {
                        if (typeEquipement.equals("Caisse")) {
                            DownLoadJsonDBItemController.this.sychroniseItems();
                        }
                        Platform.runLater(() -> fxPanel.setScene(sceneOrigin));
                    }
                }
            }).start();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(DownLoadJsonDBItemController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void downloadCarte() {
        boolean is_full_downlaoded = false;
        String operation = "";
        try {
            CarteService mCarteService = new CarteService(AppLocal.dlSales, AppLocal.dlItems, this.m_App);
            boolean result_images = mCarteService.downloadPicture();
            boolean result_download = mCarteService.downloadCarte();
            boolean bl = is_full_downlaoded = result_images && result_download;
            if (result_images && result_download) {
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La carte est telecharg\u00e9e.", 4000, NPosition.BOTTOM_RIGHT);
                operation = "download";
            } else {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.BOTTOM_RIGHT);
                operation = "error";
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu.", 1500, NPosition.BOTTOM_RIGHT);
            operation = "error";
        }
        if (AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre")) {
            this.uploadInfoDownloadedCarte(is_full_downlaoded, operation);
        }
    }

    private void sychroniseItems() {
        if (AppLocal.MODEL_CAISSE != null && AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre")) {
            if (this.mItemService == null) {
                this.mItemService = ItemService.getInstance();
            }
            this.mItemService.sychroniseItemsAndImages();
        }
    }

    private void uploadInfoDownloadedCarte(final boolean is_full_downlaoded, final String operation) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FirebaseService mFirebaseService = FirebaseService.getInstance();
                    mFirebaseService.uploadInfoDownloadedCarte(is_full_downlaoded, operation);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }).start();
    }
}

