/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.ticket.TaxInfo;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;

public class DiversController
implements RootController {
    private List<TaxInfo> taxes;
    private Stage stage;
    private Object[] result;
    @FXML
    TextField price;
    @FXML
    TextField qtt;
    private boolean textPrice;
    private ObservableList<TaxInfo> data;
    private ObservableList<CategoryInfo> dataCategories;
    private List<CategoryInfo> categories;
    @FXML
    ComboBox tvaCombo;
    @FXML
    ComboBox categoryCombo;
    private TextField focusedTextField;
    @FXML
    Label label_various_product;
    @FXML
    Button btn_valid;
    private String TAX_ID_0 = "004";

    public void valider() {
        TaxInfo taxe = null;
        taxe = AppLocal.MODULE_MEV ? new TaxInfo(this.TAX_ID_0, "0%", 0.0) : (TaxInfo)this.tvaCombo.getSelectionModel().getSelectedItem();
        CategoryInfo categorie = (CategoryInfo)this.categoryCombo.getSelectionModel().getSelectedItem();
        String nameCategory = "";
        if (categorie != null) {
            nameCategory = categorie.getName();
        }
        if (taxe != null && !this.price.getText().isEmpty()) {
            this.result[0] = taxe;
            this.result[1] = Double.parseDouble(this.price.getText());
            this.result[2] = "diver " + nameCategory;
            this.result[3] = Double.parseDouble(this.qtt.getText().isEmpty() ? "0.0" : this.qtt.getText());
            if ((Double)this.result[3] == 0.0) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.write.quantity"), 1500, NPosition.BOTTOM_RIGHT);
            } else if ((Double)this.result[1] == 0.0) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.write.price"), 1500, NPosition.BOTTOM_RIGHT);
            } else {
                this.result[4] = true;
                this.stage.close();
            }
        } else {
            NotifyWindow notifyWindow = new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.fields"), 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    public void closePopUp() {
        this.stage.close();
    }

    public Object[] getResult() {
        return this.result;
    }

    private void fillTextField(String mData) {
        if (this.focusedTextField != null) {
            this.focusedTextField.setText(this.focusedTextField.getText() + mData);
        }
    }

    public void select0() {
        this.fillTextField("0");
    }

    public void select1() {
        this.fillTextField("1");
    }

    public void select2() {
        this.fillTextField("2");
    }

    public void select3() {
        this.fillTextField("3");
    }

    public void select4() {
        this.fillTextField("4");
    }

    public void select5() {
        this.fillTextField("5");
    }

    public void select6() {
        this.fillTextField("6");
    }

    public void select7() {
        this.fillTextField("7");
    }

    public void select8() {
        this.fillTextField("8");
    }

    public void select9() {
        this.fillTextField("9");
    }

    public void selectPoint() {
        if (this.focusedTextField != null && this.focusedTextField.getText().length() >= 1 && !this.focusedTextField.getText().contains(".")) {
            this.fillTextField(".");
        }
    }

    public void selectBack() {
        if (this.focusedTextField != null && this.focusedTextField.getText().length() >= 1) {
            this.focusedTextField.setText(this.focusedTextField.getText().substring(0, this.focusedTextField.getText().length() - 1));
        }
    }

    private void initializer() {
        this.result = new Object[5];
        this.result[0] = null;
        this.result[1] = 0.0;
        this.result[2] = null;
        this.result[3] = 0.0;
        this.result[4] = false;
        this.data = FXCollections.observableArrayList(this.taxes);
        this.tvaCombo.setItems(this.data);
        this.dataCategories = FXCollections.observableArrayList(this.categories);
        this.categoryCombo.setItems(this.dataCategories);
        this.price.getProperties().put((Object)"vkType", (Object)4);
        this.qtt.getProperties().put((Object)"vkType", (Object)4);
        this.price.setEditable(false);
        this.qtt.setEditable(false);
        this.focusedTextField = this.price;
        this.price.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DiversController.this.focusedTextField = DiversController.this.price;
            }
        });
        this.qtt.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DiversController.this.focusedTextField = DiversController.this.qtt;
            }
        });
        this.setText();
        if (AppLocal.MODULE_MEV) {
            this.tvaCombo.setVisible(false);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        for (Object object : objects) {
            List m;
            if (object == null || !(object instanceof List) || (m = (List)object).size() <= 0) continue;
            if (m.get(0) instanceof TaxInfo) {
                this.taxes = (List)object;
                continue;
            }
            if (!(m.get(0) instanceof CategoryInfo)) continue;
            this.categories = (List)object;
        }
        this.initializer();
    }

    private void setText() {
        this.label_various_product.setText(AppLocal.getIntString("Label.various.product"));
        this.categoryCombo.setPromptText(AppLocal.getIntString("Text.category"));
        this.qtt.setPromptText(AppLocal.getIntString("Label.quantity"));
        this.price.setPromptText(AppLocal.getIntString("Text.selling.price"));
        this.tvaCombo.setPromptText(AppLocal.getIntString("Text.tva"));
        this.btn_valid.setText(AppLocal.getIntString("Button.valid"));
    }
}

