/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.components.interfaces.RootController;
import com.openbravo.components.views.ButtonBoxReduction;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.procaisse.dao.entities.ReductionInfo;
import fr.protactile.procaisse.services.ReductionService;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class DiscountController
implements RootController {
    private Stage stage;
    private double discountReturn;
    private Object[] result;
    private double total;
    private String type;
    private String currency;
    private List<ReductionInfo> reductions;
    private List<Button> listButtonReductions;
    private ReductionService mReductionService;
    private int page_reduction;
    private GridPane[] list_reductions;
    private int number_page_reduction;
    private int number_line;
    private int number_column;
    private double with_pane = 500.0;
    private double height_pane = 400.0;
    private String label_discount;
    private boolean select_my_reductions;
    @FXML
    Button btn_percent;
    @FXML
    Button btn_somme;
    @FXML
    Label discount;
    @FXML
    Label currencyText;
    @FXML
    GridPane pane_choose_reductions;
    @FXML
    GridPane keyborad_pane;
    @FXML
    GridPane main_pane_reductions;
    @FXML
    Button btn_reductions;
    @FXML
    GridPane btns_reduction;
    @FXML
    Button btn_reduction_previous;
    @FXML
    Button btn_reduction_next;
    @FXML
    GridPane pane_reductions;
    @FXML
    Button btn_valid;
    @FXML
    Label title_discount;
    private EventHandler mEventHandlerReductionAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            ButtonBoxReduction mButtonSource = (ButtonBoxReduction)((Object)event.getSource());
            if (mButtonSource != null && mButtonSource.getReduction() != null) {
                DiscountController.this.type = mButtonSource.getReduction().getType();
                DiscountController.this.label_discount = mButtonSource.getReduction().getName();
                DiscountController.this.discountReturn = mButtonSource.getReduction().getReduction();
                DiscountController.this.listButtonReductions.forEach(buttonReduction -> DiscountController.this.deselectButtonReduction((Button)buttonReduction));
                DiscountController.this.selectButtonReduction(mButtonSource);
            }
        }
    };

    public void closePopUp() {
        this.stage.close();
    }

    public void setType(String type) {
        if ("pourcentage".equals(type)) {
            this.currencyText.setText("%");
            this.deselectButton(this.btn_somme);
            this.selectButton(this.btn_percent);
            this.deselectButton(this.btn_reductions);
        } else {
            this.currencyText.setText(this.currency);
            this.selectButton(this.btn_somme);
            this.deselectButton(this.btn_percent);
            this.deselectButton(this.btn_reductions);
        }
    }

    public void selectPrercent() {
        this.type = "pourcentage";
        this.currencyText.setText("%");
        this.deselectButton(this.btn_somme);
        this.selectButton(this.btn_percent);
        this.deselectButton(this.btn_reductions);
        this.createReduction();
        this.select_my_reductions = false;
    }

    public void selectSomme() {
        this.type = "somme";
        this.currencyText.setText(this.currency);
        this.selectButton(this.btn_somme);
        this.deselectButton(this.btn_percent);
        this.deselectButton(this.btn_reductions);
        this.createReduction();
        this.select_my_reductions = false;
    }

    private void fillTextDiscount(String value) {
        StringBuilder mBuilder = new StringBuilder(this.discount.getText());
        this.discount.setText(mBuilder.append(value).toString());
    }

    public void select0() {
        this.fillTextDiscount("0");
    }

    public void select1() {
        this.fillTextDiscount("1");
    }

    public void select2() {
        this.fillTextDiscount("2");
    }

    public void select3() {
        this.fillTextDiscount("3");
    }

    public void select4() {
        this.fillTextDiscount("4");
    }

    public void select5() {
        this.fillTextDiscount("5");
    }

    public void select6() {
        this.fillTextDiscount("6");
    }

    public void select7() {
        this.fillTextDiscount("7");
    }

    public void select8() {
        this.fillTextDiscount("8");
    }

    public void select9() {
        this.fillTextDiscount("9");
    }

    public void selectBack() {
        if (this.discount.getText().length() >= 1) {
            this.discount.setText(this.discount.getText().substring(0, this.discount.getText().length() - 1));
        }
    }

    public void selectPoint() {
        if (this.discount.getText().length() >= 1 && !this.discount.getText().contains(".")) {
            this.discount.setText(this.discount.getText() + ".");
        }
    }

    public void Valider() {
        boolean valide = false;
        if (this.select_my_reductions) {
            valide = this.valideReductions();
        } else if (this.discount.getText().isEmpty()) {
            valide = true;
            this.discountReturn = 0.0;
            this.type = "pourcentage";
        } else {
            valide = "pourcentage".equals(this.type) ? this.discountPercent() : this.discountSomme();
        }
        if (valide) {
            this.result[0] = this.discountReturn;
            this.result[1] = this.type;
            this.result[2] = true;
            this.result[3] = this.label_discount;
            this.stage.close();
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.discount"), 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    public Object[] getResult() {
        return this.result;
    }

    private void initializer() {
        try {
            this.result = new Object[4];
            this.currency = Formats.getCurrency();
            this.result[0] = this.discountReturn;
            this.result[1] = this.type;
            this.result[2] = false;
            this.result[3] = this.label_discount;
            this.setType(this.type);
            if (this.discountReturn > 0.0) {
                this.discount.setText(String.valueOf(this.discountReturn));
            }
            this.number_line = 4;
            this.number_column = 4;
            this.createReduction();
            this.listButtonReductions = new ArrayList<Button>();
            this.reductions = new ArrayList<ReductionInfo>();
            this.mReductionService = ReductionService.getInstance();
            Image imageNext = new Image(this.getClass().getResource("/com/openbravo/images/1rightarrow.png").toURI().toString());
            Image imagePrevious = new Image(this.getClass().getResource("/com/openbravo/images/1leftarrow.png").toURI().toString());
            ImageView imageViewNext = new ImageView(imageNext);
            imageViewNext.setFitHeight(30.0);
            imageViewNext.setPreserveRatio(true);
            imageViewNext.setSmooth(true);
            imageViewNext.setCache(true);
            ImageView imageViewPrevious = new ImageView(imagePrevious);
            imageViewPrevious.setFitHeight(30.0);
            imageViewPrevious.setPreserveRatio(true);
            imageViewPrevious.setSmooth(true);
            imageViewPrevious.setCache(true);
            this.btn_reduction_previous.setGraphic((Node)imageViewPrevious);
            this.btn_reduction_next.setGraphic((Node)imageViewNext);
            this.loadReductions();
            this.setTexts();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.initializer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        if (objects != null) {
            boolean i = false;
            this.total = NumericUtils.round((Double)objects[0]);
            this.type = (String)objects[1];
            this.discountReturn = (Double)objects[2];
            this.label_discount = (String)objects[3];
        }
        this.initializer();
    }

    private boolean discountPercent() {
        if (Double.parseDouble(this.discount.getText()) <= 100.0) {
            this.discountReturn = Double.parseDouble(this.discount.getText()) * this.total / 100.0;
            this.discountReturn = Double.parseDouble(this.discount.getText());
            return true;
        }
        return false;
    }

    private boolean discountSomme() {
        if (Double.parseDouble(this.discount.getText()) <= this.total) {
            this.discountReturn = Double.parseDouble(this.discount.getText());
            return true;
        }
        return false;
    }

    public void selectReductions() {
        this.deselectButton(this.btn_somme);
        this.deselectButton(this.btn_percent);
        this.selectButton(this.btn_reductions);
        this.pane_choose_reductions.getChildren().clear();
        this.pane_choose_reductions.add((Node)this.main_pane_reductions, 0, 0);
        this.select_my_reductions = true;
    }

    private void createReduction() {
        this.pane_choose_reductions.getChildren().clear();
        this.pane_choose_reductions.add((Node)this.keyborad_pane, 0, 0);
    }

    private void loadReductions() {
        this.reductions = this.mReductionService.getReductions();
        this.reductions.forEach(reduction -> {
            ButtonBoxReduction button_reduction = new ButtonBoxReduction((ReductionInfo)reduction, this.with_pane * 0.25, this.height_pane * 0.6 * 0.25);
            button_reduction.getStyleClass().add((Object)"bg-81cfe0");
            button_reduction.setOnAction(this.mEventHandlerReductionAction);
            this.listButtonReductions.add(button_reduction);
        });
        this.showReductions(this.listButtonReductions);
    }

    private void showReductions(List<Button> items) {
        this.number_page_reduction = (int)Math.ceil((double)items.size() / (double)(this.number_line * this.number_column));
        this.list_reductions = new GridPane[this.number_page_reduction];
        for (int i = 0; i < this.number_page_reduction; ++i) {
            this.list_reductions[i] = new GridPane();
            this.list_reductions[i].setVgap(5.0);
            this.list_reductions[i].setHgap(5.0);
            this.list_reductions[i].setAlignment(Pos.CENTER);
        }
        int index_reduction = 0;
        int column_reduction = 0;
        int row_reduction = 0;
        for (Button paneItem : items) {
            this.list_reductions[index_reduction].add((Node)paneItem, column_reduction, row_reduction);
            if (column_reduction < this.number_column - 1) {
                ++column_reduction;
                continue;
            }
            if (row_reduction < this.number_line - 1) {
                ++row_reduction;
                column_reduction = 0;
                continue;
            }
            ++index_reduction;
            row_reduction = 0;
            column_reduction = 0;
        }
        this.main_pane_reductions.getChildren().clear();
        if (this.number_page_reduction > 0) {
            this.page_reduction = 0;
            this.pane_reductions.add((Node)this.list_reductions[this.page_reduction], 0, 0);
            this.main_pane_reductions.add((Node)this.pane_reductions, 0, 0);
            if (this.number_page_reduction > 1) {
                this.main_pane_reductions.add((Node)this.btns_reduction, 0, 1);
            }
        }
    }

    private void selectButton(Button button) {
        if (button.getStyleClass().contains((Object)"btn_typeOrder")) {
            button.getStyleClass().remove((Object)"btn_typeOrder");
        }
        if (!button.getStyleClass().contains((Object)"btn_typeOrder_selected")) {
            button.getStyleClass().add((Object)"btn_typeOrder_selected");
        }
    }

    private void deselectButton(Button button) {
        if (button.getStyleClass().contains((Object)"btn_typeOrder_selected")) {
            button.getStyleClass().remove((Object)"btn_typeOrder_selected");
        }
        if (!button.getStyleClass().contains((Object)"btn_typeOrder")) {
            button.getStyleClass().add((Object)"btn_typeOrder");
        }
    }

    private void deselectButtonReduction(Button button) {
        if (button.getStyleClass().contains((Object)"bg-70c0c1")) {
            button.getStyleClass().remove((Object)"bg-70c0c1");
        }
        if (!button.getStyleClass().contains((Object)"bg-81cfe0")) {
            button.getStyleClass().add((Object)"bg-81cfe0");
        }
    }

    private void selectButtonReduction(Button button) {
        if (button.getStyleClass().contains((Object)"bg-81cfe0")) {
            button.getStyleClass().remove((Object)"bg-81cfe0");
        }
        if (!button.getStyleClass().contains((Object)"bg-70c0c1")) {
            button.getStyleClass().add((Object)"bg-70c0c1");
        }
    }

    private boolean valideReductions() {
        return this.label_discount != null && this.discountReturn != 0.0;
    }

    public void lastPageReduction() {
        if (this.page_reduction > 0) {
            --this.page_reduction;
            this.pane_reductions.getChildren().clear();
            this.pane_reductions.add((Node)this.list_reductions[this.page_reduction], 0, 0);
            this.btn_reduction_next.setDisable(false);
            if (this.page_reduction == 0) {
                this.btn_reduction_previous.setDisable(true);
            } else {
                this.btn_reduction_previous.setDisable(false);
            }
        }
    }

    public void nextPageReduction() {
        if (this.page_reduction < this.number_page_reduction - 1) {
            ++this.page_reduction;
            this.pane_reductions.getChildren().clear();
            this.pane_reductions.add((Node)this.list_reductions[this.page_reduction], 0, 0);
            this.btn_reduction_previous.setDisable(false);
            if (this.page_reduction == this.number_page_reduction - 1) {
                this.btn_reduction_next.setDisable(true);
            } else {
                this.btn_reduction_next.setDisable(false);
            }
        }
    }

    private void setTexts() {
        this.btn_percent.setText(AppLocal.getIntString("Button.pourcentage"));
        this.btn_somme.setText(AppLocal.getIntString("Button.sum"));
        this.btn_reductions.setText(AppLocal.getIntString("Button.my.discounts"));
        this.btn_valid.setText(AppLocal.getIntString("Button.valid"));
        this.title_discount.setText(AppLocal.getIntString("Button.type.promotion"));
    }
}

