/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.beans.OrderOnLine;
import com.openbravo.components.OnLineCell;
import com.openbravo.events.CustomBasketListdetailOrder;
import com.openbravo.format.Formats;
import com.openbravo.pos.util.AppVarUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class DetailOrderOnline {
    private Stage stage;
    private ListView listLines;
    private ObservableList observableList;
    private List<OnLineCell> m_listItems;
    @FXML
    FlowPane infos_pane;
    @FXML
    FlowPane detail_pane;
    public final SimpleDateFormat dateFormatterFull = new SimpleDateFormat("dd/MM/yyyy - HH:mm");

    public void init(Stage stage, OrderOnLine order) {
        this.stage = stage;
        this.listLines = new ListView();
        this.observableList = FXCollections.observableArrayList();
        this.m_listItems = new ArrayList<OnLineCell>();
        this.listLines.getStyleClass().add((Object)"list-no-scrollbar");
        this.listLines.setCellFactory((Callback)new Callback<ListView<OnLineCell>, ListCell<OnLineCell>>(){

            public CustomBasketListdetailOrder call(ListView<OnLineCell> listView) {
                return new CustomBasketListdetailOrder();
            }
        });
        this.loadOrder(order);
    }

    private void addNewLine(String line) {
        this.addNewLine(line, 1);
    }

    private void addNewLine(String line, int pane) {
        Label label = new Label();
        label.setText(line);
        label.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.7 * 0.5);
        label.setAlignment(Pos.CENTER_LEFT);
        label.setPrefHeight(20.0);
        if (pane == 1) {
            this.infos_pane.getChildren().add((Object)label);
        } else {
            this.detail_pane.getChildren().add((Object)label);
        }
    }

    private void loadOrder(OrderOnLine order) {
        if (order.getId() > 0) {
            this.addNewLine("N\u00b0 " + order.getId());
        }
        if (order.getType() != null) {
            this.addNewLine("Type de commande : " + order.getType());
        }
        if (order.getDateCmd() != null) {
            this.addNewLine("Command\u00e9 le : " + this.dateFormatterFull.format(order.getDateCmd()));
        }
        if (order.getDateDelevery() != null) {
            this.addNewLine("Date de livraison : " + this.dateFormatterFull.format(order.getDateDelevery()));
        }
        if (order.getTypePayment() != null) {
            this.addNewLine("Payement : " + order.getTypePayment());
        }
        if (!order.getTypePayment().contains("enligne")) {
            if (!order.getJsonOrder().isNull("payment_cash") && order.getJsonOrder().getBoolean("payment_cash")) {
                this.addNewLine("Payement en Esp\u00e8ce");
            }
            if (!order.getJsonOrder().isNull("payment_cb") && order.getJsonOrder().getBoolean("payment_cb")) {
                this.addNewLine("Payement en CB");
            }
            if (!order.getJsonOrder().isNull("payment_ticket") && order.getJsonOrder().getBoolean("payment_ticket")) {
                this.addNewLine("Payement avec Ticket Resto");
            }
        }
        this.addNewLine(" ");
        this.addNewLine("Informations client");
        if (!order.getClient().isNull("civility")) {
            this.addNewLine(order.getClient().getString("civility") + " " + order.getClientName());
        }
        if (!order.getClient().isNull("company")) {
            this.addNewLine("Soci\u00e9t\u00e9 : " + order.getClient().getString("company"));
        }
        if (!order.getClient().isNull("phone")) {
            this.addNewLine("T\u00e9l : " + order.getClient().getString("phone"));
        }
        if (!order.getClient().isNull("email")) {
            this.addNewLine("Email : " + order.getClient().getString("email"));
        }
        if (!order.getClient().isNull("city")) {
            this.addNewLine(order.getClient().getString("city"));
        }
        if (!order.getClient().isNull("address")) {
            this.addNewLine(order.getClient().getString("address"));
        }
        if (!order.getClient().isNull("street_number")) {
            this.addNewLine("N\u00b0 de voie : " + order.getClient().getString("street_number"));
        }
        if (!order.getClient().isNull("building") && !order.getClient().isNull("intercom")) {
            this.addNewLine("Batiment : " + order.getClient().getString("building") + ", Interphone:" + order.getClient().getString("intercom"));
        } else {
            if (!order.getClient().isNull("building")) {
                this.addNewLine("Batiment : " + order.getClient().getString("building"));
            }
            if (!order.getClient().isNull("intercom")) {
                this.addNewLine("Interphone : " + order.getClient().getString("intercom"));
            }
        }
        if (!order.getClient().isNull("entryCode") && !order.getClient().isNull("stairs")) {
            this.addNewLine("Code d'entr\u00e9e : " + order.getClient().getString("entryCode") + ", Escaliers : " + order.getClient().getString("stairs"));
        } else {
            if (!order.getClient().isNull("stairs")) {
                this.addNewLine("Escaliers : " + order.getClient().getString("stairs"));
            }
            if (!order.getClient().isNull("entryCode")) {
                this.addNewLine("Code d'entr\u00e9e : " + order.getClient().getString("entryCode"));
            }
        }
        if (!order.getClient().isNull("floor") && !order.getClient().isNull("flatNumber")) {
            this.addNewLine("Etage : " + order.getClient().getString("floor") + ", Appartement : " + order.getClient().getString("flatNumber"));
        } else {
            if (!order.getClient().isNull("floor")) {
                this.addNewLine("Etage : " + order.getClient().getString("floor"));
            }
            if (!order.getClient().isNull("flatNumber")) {
                this.addNewLine("Appartement : " + order.getClient().getString("flatNumber"));
            }
        }
        if (!order.getJsonOrder().isNull("comment")) {
            this.addNewLine(order.getJsonOrder().isNull("comment") ? "" : order.getJsonOrder().get("comment").toString());
        }
        if (!order.getClient().isNull("extra")) {
            this.addNewLine("Autre : " + order.getClient().getString("extra"));
        }
        JSONArray lines = order.getJsonOrder().getJSONArray("items");
        this.addLineDetail("QTE", "DESIGNATION", "PRIX", "TOTAL");
        this.addNewLine(" ", 2);
        if (this.listLines.getItems().isEmpty()) {
            this.listLines.getItems().clear();
        }
        if (!this.m_listItems.isEmpty()) {
            this.m_listItems.clear();
        }
        if (!this.observableList.isEmpty()) {
            this.observableList.clear();
        }
        this.listLines.setPrefWidth(this.getWidthRightPane());
        this.listLines.setPrefHeight(this.getHeightRightPane() - 100.0);
        for (int i = 0; i < lines.length(); ++i) {
            JSONObject line = lines.getJSONObject(i);
            OnLineCell cellLine = new OnLineCell(line);
            this.m_listItems.add(cellLine);
        }
        this.observableList.setAll(this.m_listItems);
        this.listLines.setItems(this.observableList);
        this.detail_pane.getChildren().add((Object)this.listLines);
        this.addNewLine(" ", 2);
        if (!order.getTypePayment().contains("enligne")) {
            this.addLineTotal("NET A PAYER ", Formats.CURRENCY.formatValue(order.getTotal()));
        } else {
            this.addLineTotal("TOTAL TTC ", Formats.CURRENCY.formatValue(order.getTotal()));
        }
    }

    private void addLineTotal(String text, String total) {
        double width = AppVarUtils.getScreenDimension().getWidth() * 0.7 * 0.5;
        Label label1 = new Label();
        label1.setPrefWidth(width * 0.85);
        label1.setPrefHeight(20.0);
        label1.setAlignment(Pos.CENTER_LEFT);
        label1.setText(text);
        Label label2 = new Label();
        label2.setPrefWidth(width * 0.15);
        label2.setPrefHeight(20.0);
        label2.setAlignment(Pos.CENTER_LEFT);
        label2.setText(total);
        GridPane pane = new GridPane();
        pane.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.7 * 0.5 - 5.0);
        pane.setPrefHeight(20.0);
        pane.add((Node)label1, 0, 0);
        pane.add((Node)label2, 1, 0);
        this.detail_pane.getChildren().add((Object)pane);
    }

    private void addLineDetail(String qte, String designation, String prix, String total) {
        double width = AppVarUtils.getScreenDimension().getWidth() * 0.7 * 0.5 - 65.0;
        Label label1 = new Label();
        label1.setPrefWidth(width * 0.1);
        label1.setPrefHeight(20.0);
        label1.setAlignment(Pos.CENTER_LEFT);
        label1.setText(qte);
        Label label2 = new Label();
        label2.setPrefWidth(width * 0.6);
        label2.setPrefHeight(20.0);
        label2.setAlignment(Pos.CENTER_LEFT);
        label2.setText(designation);
        Label label3 = new Label();
        label3.setPrefWidth(width * 0.15);
        label3.setPrefHeight(20.0);
        label3.setAlignment(Pos.CENTER_LEFT);
        label3.setText(prix);
        Label label4 = new Label();
        label4.setPrefWidth(width * 0.15);
        label4.setPrefHeight(20.0);
        label4.setAlignment(Pos.CENTER_LEFT);
        label4.setText(total);
        GridPane pane = new GridPane();
        pane.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.7 * 0.5 - 5.0);
        pane.setPrefHeight(20.0);
        pane.add((Node)label1, 0, 0);
        pane.add((Node)label2, 1, 0);
        pane.add((Node)label3, 2, 0);
        pane.add((Node)label4, 3, 0);
        this.detail_pane.getChildren().add((Object)pane);
    }

    private void appendLineOrderOnLine(JSONObject line) {
        int i;
        String quantity = !line.isNull("quantity") ? "" + line.getInt("quantity") : "1";
        String name_product = !line.isNull("size") ? line.getString("title") + " - " + line.getString("size") : line.getString("title");
        this.addLineDetail(quantity, name_product.toUpperCase(), Formats.CURRENCY.formatValue(line.getDouble("price")), StringUtils.leftPad((String)Formats.CURRENCY.formatValue(line.getDouble("price") * line.getDouble("quantity")), (int)8));
        if (!line.isNull("supplements")) {
            JSONArray supplements = line.getJSONArray("supplements");
            for (i = 0; i < supplements.length(); ++i) {
                JSONObject supplement = supplements.getJSONObject(i);
                if (supplement.getDouble("amount") == 0.0) continue;
                this.appendSupplementOnline(supplement, true, line);
            }
        }
        if (!line.isNull("items")) {
            JSONArray products = line.getJSONArray("items");
            for (i = 0; i < products.length(); ++i) {
                JSONObject product = products.getJSONObject(i);
                this.appendItemOnLine(product);
            }
        }
    }

    private void appendSupplementOnline(JSONObject line, boolean isPositive, JSONObject ticketLine) {
        String numberOptions = "1";
        String itemName = "  " + line.getString("name");
        if (line.getDouble("amount") != 0.0) {
            this.addLineDetail(numberOptions, itemName, Formats.CURRENCY.formatValue(line.getDouble("amount")), StringUtils.leftPad((String)Formats.CURRENCY.formatValue(line.getDouble("amount")), (int)7));
        } else {
            this.addLineDetail(numberOptions, itemName, "", "");
        }
    }

    private void appendItemOnLine(JSONObject productInMenu) {
        JSONObject item = productInMenu.getJSONObject("item");
        String numberOptions = String.valueOf(1);
        String itemName = "--" + item.getString("name");
        this.addLineDetail(numberOptions, itemName.toUpperCase(), !productInMenu.isNull("price") ? Formats.CURRENCY.formatValue(productInMenu.getDouble("price")) : "", !productInMenu.isNull("amount") ? StringUtils.leftPad((String)Formats.CURRENCY.formatValue(productInMenu.getDouble("amount")), (int)7) : "");
    }

    public void closePopUp() {
        this.stage.close();
    }

    private double getHeightRightPane() {
        return AppVarUtils.getScreenDimension().getHeight() * 0.6 * 0.9;
    }

    private double getWidthRightPane() {
        return AppVarUtils.getScreenDimension().getWidth() * 0.7 * 0.5 - 5.0;
    }
}

