/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.format.Formats;
import com.openbravo.models.HBoxLine;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;

public class DetailOrderController {
    private AppView m_App;
    private TicketInfo currentOrder;
    @FXML
    ListView list_detail;
    @FXML
    Label num_order_label;
    @FXML
    Label total_order_label;
    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();

    public void initialize(AppView app, TicketInfo ticket) throws BasicException {
        this.m_App = app;
        this.currentOrder = ticket;
        this.loadPanier();
    }

    public void loadPanier() {
        if (this.currentOrder != null) {
            this.num_order_label.setText("Commande N\u00b0" + String.valueOf(this.currentOrder.getNumero_order()));
            this.total_order_label.setText(this.currentOrder.printTotal());
            this.list_detail.getItems().clear();
            ArrayList<HBoxLine> list = new ArrayList<HBoxLine>();
            for (TicketLineInfo line : this.currentOrder.getLines()) {
                if (line.isNext()) continue;
                HBoxLine componentLine = new HBoxLine(line);
                list.add(componentLine);
                if (!(line.getValueDiscount() > 0.0)) continue;
                String name = line.printLabelDiscount();
                HBoxLine componentLineDiscount = new HBoxLine(" " + name, "-" + Formats.CURRENCY.formatValue(line.getDiscount()));
                list.add(componentLineDiscount);
            }
            if (this.currentOrder.getDiscount() > 0.0) {
                String text = this.currentOrder.getTypeDiscount().equals("pourcentage") ? "Promotion globale " + (int)this.currentOrder.getDiscount() + "%" : "Promotion globale";
                HBoxLine componentLineDiscount = new HBoxLine(text, "-" + this.currentOrder.printDiscount());
                list.add(componentLineDiscount);
            }
            ObservableList observableList = FXCollections.observableArrayList();
            observableList.setAll(list);
            this.list_detail.setItems(observableList);
        }
    }
}

