/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.LazyModal;
import com.openbravo.components.ModalConfirmationController;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.DetailOrderController;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.customers.exports.ExportDebitsCustomerExcel;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.DebitCustomerView;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketInfoView;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.service.CustomerEnvService;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.entities.DebitCustomerInfo;
import fr.protactile.procaisse.services.CustomerService;
import fr.protactile.procaisse.services.DebitCustomerService;
import java.awt.Dimension;
import java.io.File;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class CustomerController {
    private AppView m_App;
    private List<CustomerInfo> listCustomers;
    private DataLogicSales dlSales;
    @FXML
    GridPane pane_info_customer;
    @FXML
    FlowPane pane_btn_edit;
    @FXML
    TextField edit_name_customer;
    @FXML
    TextField edit_phone1;
    @FXML
    TextField edit_phone2;
    @FXML
    TextField edit_email;
    @FXML
    TextField edit_address;
    @FXML
    TextField edit_zipCode;
    @FXML
    TextField edit_city;
    @FXML
    ComboBox edit_listCompany;
    @FXML
    TextField edit_responsible;
    @FXML
    TextField edit_name_company;
    @FXML
    TextField edit_interlocutor;
    @FXML
    TextField edit_interlocutorFunction;
    @FXML
    TextField edit_phoneInterlocutor;
    @FXML
    TextField edit_emailInterlocutor;
    @FXML
    TextField edit_addressCompany;
    @FXML
    TextField edit_zipCodeCompany;
    @FXML
    TextField edit_cityCompany;
    @FXML
    ComboBox edit_range;
    @FXML
    TextField edit_discountCompany;
    @FXML
    TextField edit_comment;
    @FXML
    TextField edit_discount;
    @FXML
    GridPane pane_edit;
    @FXML
    ScrollPane scroll_edit_customer;
    @FXML
    ScrollPane scroll_edit_company;
    @FXML
    GridPane parent_search;
    @FXML
    Button back_list;
    @FXML
    Label label_customer;
    @FXML
    TextField phone;
    @FXML
    TextField nom_client;
    @FXML
    TextField name_customer;
    @FXML
    TextField phone1;
    @FXML
    TextField phone2;
    @FXML
    TextField email;
    @FXML
    TextField address;
    @FXML
    TextField zipCode;
    @FXML
    TextField city;
    @FXML
    TextField comment;
    @FXML
    TextField discount;
    @FXML
    TextField name_company;
    @FXML
    TextField responsible;
    @FXML
    TextField interlocutor;
    @FXML
    TextField interlocutorFunction;
    @FXML
    TextField phoneInterlocutor;
    @FXML
    TextField emailInterlocutor;
    @FXML
    TextField addressCompany;
    @FXML
    TextField zipCodeCompany;
    @FXML
    TextField cityCompany;
    @FXML
    TextField discountCompany;
    @FXML
    ComboBox range;
    @FXML
    ComboBox listCompany;
    @FXML
    Button btn_paid_debit;
    @FXML
    Button delete_customer;
    private List<CustomerInfo> companies;
    private ObservableList<CustomerInfo> data;
    @FXML
    GridPane main_pane;
    @FXML
    FlowPane pane_message;
    @FXML
    ScrollPane scroll_client;
    @FXML
    FlowPane button_clients;
    @FXML
    GridPane new_client_pane;
    @FXML
    ToggleGroup groupe;
    @FXML
    RadioButton physical;
    @FXML
    RadioButton moral;
    @FXML
    GridPane pane_add;
    @FXML
    FlowPane pane_add_customer;
    @FXML
    FlowPane pane_add_company;
    @FXML
    ScrollPane scroll_add_customer;
    @FXML
    ScrollPane scroll_add_company;
    @FXML
    TableView tableOrders;
    @FXML
    TableView tableDebit;
    @FXML
    TableColumn num_order_debit;
    @FXML
    TableColumn amount;
    @FXML
    TableColumn date_payment;
    @FXML
    TableColumn hour_payment;
    @FXML
    TableColumn paid;
    @FXML
    TableColumn transfer_num;
    @FXML
    GridPane detail_customer_pane;
    private CustomerInfo currentCustomer;
    private List<CustomerInfo> listCustomersFilter;
    private Scene scene;
    private boolean showEspaceClient;
    private List<TicketInfo> orders;
    private List<DebitCustomerInfo> debits;
    private final SimpleDateFormat dateFormatter = DateUtils.formatterDayMonthYear;
    private final SimpleDateFormat timeFormatter = DateUtils.timeFormatter;
    private String styleCss = "/styles/styles.css";
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn etat_order;
    @FXML
    TableColumn total_order;
    @FXML
    TableColumn serveur_order;
    @FXML
    Button edit_btn;
    @FXML
    Button cancel_btn;
    @FXML
    Button save_btn;
    @FXML
    Button btn_filter_name_client;
    @FXML
    TabPane tabber;
    @FXML
    Button btn_import;
    @FXML
    Button btn_export;
    private TicketInfo currentOrder;
    private DebitCustomerInfo currentDebit;
    int filter_number;
    private CustomerService mCustomerService = CustomerService.getInstance();
    private DebitCustomerService mDebitCustomerService = DebitCustomerService.getInstance();

    public void init(AppView app, Scene scene) throws BasicException, URISyntaxException {
        this.m_App = app;
        Image img_back = new Image(this.getClass().getResource("/com/openbravo/images/back.png").toURI().toString(), 30.0, 30.0, false, false);
        this.back_list.setGraphic((Node)new ImageView(img_back));
        Image img_delete = new Image(this.getClass().getResource("/com/openbravo/images/sale_delete.png").toURI().toString(), 30.0, 30.0, false, false);
        this.delete_customer.setGraphic((Node)new ImageView(img_delete));
        Image img_edit = new Image(this.getClass().getResource("/com/openbravo/images/icon_edit.png").toURI().toString(), 30.0, 30.0, false, false);
        this.edit_btn.setGraphic((Node)new ImageView(img_edit));
        Image img_save = new Image(this.getClass().getResource("/com/openbravo/images/save_icon.png").toURI().toString(), 30.0, 30.0, false, false);
        this.save_btn.setGraphic((Node)new ImageView(img_save));
        Image img_cancel = new Image(this.getClass().getResource("/com/openbravo/images/cancel_icon.png").toURI().toString(), 30.0, 30.0, false, false);
        this.cancel_btn.setGraphic((Node)new ImageView(img_cancel));
        if (!AppLocal.MODE_DEBIT) {
            this.tabber.getTabs().remove(2);
        }
        this.filter_number = AppLocal.FILTER_NUMBER != null && !AppLocal.FILTER_NUMBER.isEmpty() ? Integer.parseInt(AppLocal.FILTER_NUMBER) : 4;
        this.parent_search.requestFocus();
        this.currentCustomer = null;
        this.scene = scene;
        this.showEspaceClient = false;
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.orders = new ArrayList<TicketInfo>();
        this.listCustomersFilter = new ArrayList<CustomerInfo>();
        this.nom_client.getProperties().put((Object)"vkType", (Object)5);
        this.nom_client.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (CustomerController.this.nom_client.getText().length() > CustomerController.this.filter_number) {
                    CustomerController.this.searchByNom();
                }
            }
        });
        this.phone.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                CustomerController.this.searchByPhone();
            }
        });
        this.currentOrder = null;
        this.num_order_debit.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
        this.amount.setCellValueFactory((Callback)new PropertyValueFactory("amount"));
        this.date_payment.setCellValueFactory((Callback)new PropertyValueFactory("datePayment"));
        this.hour_payment.setCellValueFactory((Callback)new PropertyValueFactory("hourPayment"));
        this.paid.setCellValueFactory((Callback)new PropertyValueFactory("paid"));
        this.transfer_num.setCellValueFactory((Callback)new PropertyValueFactory("num_transfer"));
        this.tableDebit.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (CustomerController.this.tableDebit.getSelectionModel().getSelectedIndex() != -1 && (row = CustomerController.this.tableDebit.getSelectionModel().getSelectedIndex()) != -1) {
                    CustomerController.this.currentDebit = CustomerController.this.debits.get(row);
                    if (CustomerController.this.currentDebit.isPaid().booleanValue()) {
                        CustomerController.this.btn_paid_debit.setDisable(true);
                    } else {
                        CustomerController.this.btn_paid_debit.setDisable(false);
                    }
                }
            }
        });
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
        this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
        this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hourOrder"));
        this.etat_order.setCellValueFactory((Callback)new PropertyValueFactory("etatOrder"));
        this.total_order.setCellValueFactory((Callback)new PropertyValueFactory("totalOrder"));
        this.serveur_order.setCellValueFactory((Callback)new PropertyValueFactory("serveurOrder"));
        this.tableOrders.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (CustomerController.this.tableOrders.getSelectionModel().getSelectedIndex() != -1 && (row = CustomerController.this.tableOrders.getSelectionModel().getSelectedIndex()) != -1) {
                    CustomerController.this.currentOrder = CustomerController.this.orders.get(row);
                    try {
                        List<TicketLineInfo> lines = CustomerController.this.dlSales.loadLines(CustomerController.this.currentOrder.getId());
                        List<TicketLineInfo> linesExterne = CustomerController.this.dlSales.getTicketLineExterne(CustomerController.this.currentOrder.getId());
                        lines.addAll(linesExterne);
                        CustomerController.this.currentOrder.setLines(lines);
                        CustomerController.this.loadDetailOrder();
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
            }
        });
        try {
            this.loadPaneCustomer();
            this.loadCompanies();
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        this.physical.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                if (CustomerController.this.physical.isSelected()) {
                    CustomerController.this.pane_add.getChildren().clear();
                    CustomerController.this.pane_add.add((Node)CustomerController.this.scroll_add_customer, 0, 0);
                }
                if (CustomerController.this.groupe != null) {
                    CustomerController.this.groupe.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                        public void changed(ObservableValue<? extends Toggle> arg0, Toggle arg1, Toggle arg2) {
                        }
                    });
                }
            }
        });
        this.moral.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                if (CustomerController.this.moral.isSelected()) {
                    CustomerController.this.pane_add.getChildren().clear();
                    CustomerController.this.pane_add.add((Node)CustomerController.this.scroll_add_company, 0, 0);
                }
                if (CustomerController.this.groupe != null) {
                    CustomerController.this.groupe.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

                        public void changed(ObservableValue<? extends Toggle> arg0, Toggle arg1, Toggle arg2) {
                        }
                    });
                }
            }
        });
        Image imagegeoFilter = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/filter_icon.png"));
        this.btn_filter_name_client.setGraphic((Node)new ImageView(imagegeoFilter));
    }

    public void toNext() {
    }

    public void toPrevious() {
    }

    private void loadDetailOrder() {
        if (this.currentOrder != null) {
            try {
                FXMLLoader loader = new FXMLLoader();
                Parent rootNode = (Parent)loader.load(this.getClass().getResourceAsStream("/fxml/detail_order.fxml"));
                DetailOrderController controller = (DetailOrderController)loader.getController();
                Scene scenePop = new Scene(rootNode, 700.0, 500.0);
                scenePop.getStylesheets().add((Object)this.styleCss);
                Stage modalStage = new Stage();
                modalStage.setTitle("Rappel ticket");
                modalStage.getIcons().add((Object)new Image(this.getClass().getResourceAsStream("/com/openbravo/images/favicon.png")));
                modalStage.setScene(scenePop);
                modalStage.initOwner(this.scene.getWindow());
                modalStage.initModality(Modality.APPLICATION_MODAL);
                modalStage.initStyle(StageStyle.UTILITY);
                modalStage.setAlwaysOnTop(true);
                controller.initialize(this.m_App, this.currentOrder);
                modalStage.show();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void searchByPhone() {
        if (!this.showEspaceClient) {
            this.listCustomersFilter.clear();
            try {
                if (this.phone != null && !this.phone.getText().isEmpty() && this.phone.getText().length() >= this.filter_number) {
                    this.listCustomersFilter = this.mCustomerService.filterByPhoneOrName(this.phone.getText(), this.nom_client.getText());
                    if (this.listCustomersFilter.size() > 0) {
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.scroll_client, 0, 0);
                        this.loadClient();
                    } else if (this.phone.getText().length() == 10) {
                        this.showEspaceClient = true;
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.new_client_pane, 0, 0);
                    } else {
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.pane_message, 0, 0);
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void searchByNom() {
        block6: {
            if (!this.showEspaceClient) {
                this.listCustomersFilter.clear();
                if (!this.nom_client.getText().isEmpty() || !this.phone.getText().isEmpty()) {
                    try {
                        this.listCustomersFilter = this.mCustomerService.filterByPhoneOrName(this.phone.getText(), this.nom_client.getText());
                        if (this.listCustomersFilter.size() > 0) {
                            this.main_pane.getChildren().clear();
                            this.main_pane.add((Node)this.scroll_client, 0, 0);
                            this.loadClient();
                            break block6;
                        }
                        this.main_pane.getChildren().clear();
                        this.main_pane.add((Node)this.pane_message, 0, 0);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                } else {
                    this.main_pane.getChildren().clear();
                    this.main_pane.add((Node)this.pane_message, 0, 0);
                }
            }
        }
    }

    public void loadClient() {
        this.button_clients.getChildren().clear();
        for (final CustomerInfo customer : this.listCustomersFilter) {
            FlowPane pane_client = new FlowPane();
            pane_client.setVgap(2.0);
            pane_client.setHgap(2.0);
            pane_client.setPrefWidth(150.0);
            pane_client.getStyleClass().add((Object)"btn_client");
            pane_client.setPrefHeight(150.0);
            Button btnCustomer = new Button();
            btnCustomer.getStyleClass().add((Object)"btn_client");
            btnCustomer.getStyleClass().add((Object)"text-size-20");
            btnCustomer.setWrapText(true);
            String textCustomer = customer.getName() + "\n" + customer.printPhone();
            btnCustomer.setText(textCustomer);
            btnCustomer.setPrefHeight(150.0);
            btnCustomer.setPrefWidth(200.0);
            btnCustomer.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    CustomerController.this.hideEdit();
                    CustomerController.this.currentCustomer = customer;
                    CustomerController.this.loadCustomerItem(CustomerController.this.currentCustomer);
                }
            });
            pane_client.getChildren().add((Object)btnCustomer);
            this.button_clients.getChildren().add((Object)pane_client);
        }
    }

    private void loadCustomerItem(CustomerInfo customer) {
        this.label_customer.setText(customer.getName() + " " + customer.printPhone());
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.detail_customer_pane, 0, 0);
        this.pane_edit.getChildren().clear();
        if (customer.getType() == null || customer.getType() != null && customer.getType().equals("customer")) {
            this.pane_edit.add((Node)this.scroll_edit_customer, 0, 0);
            this.loadFieldCustomer(customer);
        } else {
            this.pane_edit.add((Node)this.scroll_edit_company, 0, 0);
            this.loadFieldCompany(customer);
        }
        try {
            this.loadHistory();
            this.loadDebit();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void reloadCustomer(CustomerInfo customer) {
        int i = 0;
        int found = -1;
        for (CustomerInfo customerTmp : this.listCustomers) {
            if (customerTmp.getId() == customer.getId()) {
                found = i;
                break;
            }
            ++i;
        }
        if (found != -1) {
            this.listCustomers.remove(found);
            this.listCustomers.add(found, customer);
        }
    }

    public void deleteCustomer() {
        if (this.currentCustomer != null) {
            try {
                EventHiddenModal mAction = new EventHiddenModal(){
                    Boolean result = false;

                    @Override
                    public void onHidden() {
                        if (this.result.booleanValue()) {
                            try {
                                if (!CustomerController.this.mCustomerService.remove(CustomerController.this.currentCustomer)) {
                                    // empty if block
                                }
                                CustomerController.this.loadPaneCustomer();
                                CustomerController.this.loadCompanies();
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", null, ex);
                            }
                        }
                    }

                    @Override
                    public void onHidden(AppLoaderBuilder mBuilder) {
                        if (mBuilder != null && mBuilder.getController() != null) {
                            ModalConfirmationController mController = (ModalConfirmationController)mBuilder.getController();
                            this.result = mController.getResult();
                        }
                        this.onHidden();
                    }
                };
                LazyModal mLazy = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/components/popup_confirmation.fxml", new Dimension(400, 150), mAction);
                mLazy.load(new Object[0]);
                ModalConfirmationController mController = (ModalConfirmationController)mLazy.getLoadder().getController();
                mController.configureText("Suppression du client", "Voulez-vous vraiment supprimer ce client ?", "Confirmer", "Annuler");
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public void paidDebit() {
        if (this.currentDebit != null) {
            try {
                EventHiddenModal mAction = new EventHiddenModal(){
                    Boolean result = false;

                    @Override
                    public void onHidden() {
                        if (this.result.booleanValue()) {
                            try {
                                Boolean res = CustomerController.this.mDebitCustomerService.setDebitAsPaid(CustomerController.this.currentDebit, true);
                                if (!res.booleanValue()) {
                                    // empty if block
                                }
                                CustomerController.this.currentDebit.setPaid(res);
                                CustomerController.this.loadDebit();
                            }
                            catch (Exception ex) {
                                LogToFile.log("severe", ex.getMessage(), ex);
                            }
                        }
                    }

                    @Override
                    public void onHidden(AppLoaderBuilder mBuilder) {
                        if (mBuilder != null && mBuilder.getController() != null) {
                            ModalConfirmationController mController = (ModalConfirmationController)mBuilder.getController();
                            this.result = mController.getResult();
                        }
                        this.onHidden();
                    }
                };
                LazyModal mLazy = new LazyModal(StageStyle.UNDECORATED, this.scene, "/fxml/components/popup_confirmation.fxml", new Dimension(400, 150), mAction);
                mLazy.load(new Object[0]);
                ModalConfirmationController mController = (ModalConfirmationController)mLazy.getLoadder().getController();
                mController.configureText("Mise \u00e0 jour de d\u00e9bit", "Voulez-vous marquer la ligne comme pay\u00e9 ?", "Confirmer", "Annuler");
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void loadDebit() throws BasicException {
        if (this.currentCustomer != null) {
            this.btn_paid_debit.setDisable(true);
            this.debits = this.mDebitCustomerService.getByCustomerId(this.currentCustomer.getId());
            ArrayList<DebitCustomerView> items = new ArrayList<DebitCustomerView>();
            for (DebitCustomerInfo debit : this.debits) {
                String paid = debit.isPaid() != false ? "Oui" : "Non";
                items.add(new DebitCustomerView(debit.getNumOrder(), debit.getAmount(), this.dateFormatter.format(debit.getDatePayment()), this.timeFormatter.format(debit.getDatePayment()), paid, debit.getTransferNumber()));
            }
            ObservableList dataDebit = FXCollections.observableArrayList(items);
            this.tableDebit.setItems(dataDebit);
        }
    }

    public void loadHistory() throws BasicException {
        if (this.currentCustomer != null) {
            this.orders = this.dlSales.loadTicketByCustomer(this.currentCustomer.getId());
            ArrayList<TicketInfoView> items = new ArrayList<TicketInfoView>();
            for (TicketInfo order : this.orders) {
                String table = "";
                if (order.getIdTable() != -1) {
                    table = String.valueOf(order.getTable().getNumber());
                }
                String status = this.getStatus(order.getStatus());
                String nameCustomer = order.getCustomer() != null ? order.getCustomer().getName() : order.getName_customer();
                String orderNum = order.getCaisse() != null ? order.getCaisse() + order.getNumero_order() : String.valueOf(order.getNumero_order());
                items.add(new TicketInfoView(orderNum, nameCustomer, order.getCustomerPhone(), this.dateFormatter.format(order.getDate()), this.timeFormatter.format(order.getDate()), order.getType(), status, order.printTotalOrder(), order.getUser().getName(), order.getSource_order(), table));
            }
            ObservableList data = FXCollections.observableArrayList(items);
            this.tableOrders.setItems(data);
            this.parent_search.requestFocus();
        }
    }

    public void loadCompanies() throws BasicException {
        this.companies = this.mCustomerService.getCustomersAsCompanies();
        CustomerInfo defaultComapny = new CustomerInfo(0);
        defaultComapny.setName("--Soci\u00e9t\u00e9--");
        this.companies.add(0, defaultComapny);
        this.data = FXCollections.observableArrayList(this.companies);
        StringConverter<CustomerInfo> converter = new StringConverter<CustomerInfo>(){

            public String toString(CustomerInfo object) {
                return object != null ? object.getName() : null;
            }

            public CustomerInfo fromString(String string) {
                return null;
            }
        };
        this.listCompany.setItems(this.data);
        this.edit_listCompany.setItems(this.data);
        this.listCompany.setConverter((StringConverter)converter);
        this.edit_listCompany.setConverter((StringConverter)converter);
    }

    public void phone7() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "7");
            this.searchByPhone();
        }
    }

    public void phone8() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "8");
            this.searchByPhone();
        }
    }

    public void phone9() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "9");
            this.searchByPhone();
        }
    }

    public void phone6() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "6");
            this.searchByPhone();
        }
    }

    public void phone5() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "5");
            this.searchByPhone();
        }
    }

    public void phone4() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "4");
            this.searchByPhone();
        }
    }

    public void phone3() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "3");
            this.searchByPhone();
        }
    }

    public void phone2() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "2");
            this.searchByPhone();
        }
    }

    public void phone1() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "1");
            this.searchByPhone();
        }
    }

    public void phone0() {
        if (this.phone.getText().length() < 10) {
            this.phone.setText(this.phone.getText() + "0");
            this.searchByPhone();
        }
    }

    public void phoneClear() {
        if (this.phone.getText().length() >= 1) {
            this.phone.setText(this.phone.getText().substring(0, this.phone.getText().length() - 1));
            this.searchByPhone();
        }
    }

    public void loadEspaceClient() {
        this.showEspaceClient = true;
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.new_client_pane, 0, 0);
        this.pane_add.getChildren().clear();
        this.pane_add.add((Node)this.scroll_add_customer, 0, 0);
        this.physical.setSelected(true);
    }

    public void addCustomer() throws SQLException {
        if (this.physical.isSelected()) {
            if (this.name_customer.getText().isEmpty() || this.phone1.getText().isEmpty()) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de remplir les champs necessaires.", 1500, NPosition.CENTER);
            } else if (this.phone1.getText().length() == 10) {
                CustomerInfo customer = new CustomerInfo();
                customer.setPhone(this.phone1.getText());
                customer.setName(this.name_customer.getText());
                customer.setPhone2(this.phone2.getText());
                customer.setEmail(this.email.getText());
                customer.setType("customer");
                CustomerInfo company = (CustomerInfo)this.listCompany.getSelectionModel().getSelectedItem();
                if (company != null && company.getId() != null && !company.getId().equals(0)) {
                    customer.setCompany(company.getId());
                } else {
                    customer.setCompany(-1);
                }
                customer.setNotes(this.comment.getText());
                customer.setDiscount(Double.parseDouble(this.discount.getText().isEmpty() ? "0.0" : this.discount.getText()));
                AddressInfo addressCustomer = null;
                if (!(this.address.getText().isEmpty() && this.zipCode.getText().isEmpty() && this.city.getText().isEmpty())) {
                    addressCustomer = new AddressInfo();
                    addressCustomer.setAddress(this.address.getText());
                    addressCustomer.setZipcode(this.zipCode.getText());
                    addressCustomer.setCity(this.city.getText());
                }
                try {
                    if (addressCustomer != null) {
                        this.mCustomerService.saveWithAddress(customer, addressCustomer);
                    } else {
                        this.mCustomerService.save(customer);
                    }
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Client Ajout\u00e9.", 1500, NPosition.CENTER);
                    this.loadPaneCustomer();
                    this.loadCompanies();
                    this.initialize();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Le num\u00e9ro t\u00e9l\u00e9phone do\u00eet contenir 10 chiffres.", 1500, NPosition.CENTER);
            }
        } else if (this.name_company.getText().isEmpty() || this.phoneInterlocutor.getText().isEmpty()) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "merci de pr\u00e9ciser tous les champs.", 1500, NPosition.CENTER);
        } else if (this.phoneInterlocutor.getText().length() == 10) {
            CustomerInfo customer = new CustomerInfo();
            customer.setName(this.name_company.getText());
            customer.setResponsible(this.responsible.getText());
            customer.setInterlocutor(this.interlocutor.getText());
            customer.setFunction_interlocutor(this.interlocutorFunction.getText());
            customer.setPhone(this.phoneInterlocutor.getText());
            customer.setEmail(this.emailInterlocutor.getText());
            customer.setRange((String)this.range.getSelectionModel().getSelectedItem());
            customer.setDiscount(Double.parseDouble(this.discountCompany.getText().isEmpty() ? "0.0" : this.discountCompany.getText()));
            customer.setType("company");
            AddressInfo addressCustomer = null;
            if (!(this.addressCompany.getText().isEmpty() && this.zipCodeCompany.getText().isEmpty() && this.cityCompany.getText().isEmpty())) {
                addressCustomer = new AddressInfo();
                addressCustomer.setAddress(this.addressCompany.getText());
                addressCustomer.setZipcode(this.zipCodeCompany.getText());
                addressCustomer.setCity(this.cityCompany.getText());
            }
            try {
                if (addressCustomer != null) {
                    this.mCustomerService.saveWithAddress(customer, addressCustomer);
                } else {
                    this.mCustomerService.save(customer);
                }
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "L'entreprise est sauvegard\u00e9 avec succ\u00e8s.", 1500, NPosition.CENTER);
                this.loadPaneCustomer();
                this.loadCompanies();
                this.initialize();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Le num\u00e9ro t\u00e9l\u00e9phone do\u00eet contenir 10 chiffres.", 1500, NPosition.CENTER);
        }
    }

    public void updateCustomer() throws SQLException {
        if (this.currentCustomer.getType() == null || this.currentCustomer.getType() != null && this.currentCustomer.getType().equals("customer")) {
            if (this.edit_name_customer.getText().isEmpty() || this.edit_phone1.getText().isEmpty()) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de remplir les champs necessaires.", 1500, NPosition.CENTER);
            } else if (this.edit_phone1.getText().length() == 10) {
                this.currentCustomer.setPhone(this.edit_phone1.getText());
                this.currentCustomer.setName(this.edit_name_customer.getText());
                this.currentCustomer.setPhone2(this.edit_phone2.getText());
                this.currentCustomer.setEmail(this.edit_email.getText());
                CustomerInfo company = (CustomerInfo)this.edit_listCompany.getSelectionModel().getSelectedItem();
                if (company != null && company.getId() != null && !company.getId().equals(0)) {
                    this.currentCustomer.setCompany(company.getId());
                } else {
                    this.currentCustomer.setCompany(-1);
                }
                AddressInfo addressCustomer = null;
                if (this.currentCustomer.getAdresseInfoCollection() != null && this.currentCustomer.getAdresseInfoCollection().size() > 0) {
                    addressCustomer = this.currentCustomer.getAdresseInfoCollection().get(0);
                    addressCustomer.setAddress(this.edit_address.getText());
                    addressCustomer.setZipcode(this.edit_zipCode.getText());
                    addressCustomer.setCity(this.edit_city.getText());
                } else if (!(this.edit_address.getText().isEmpty() && this.edit_zipCode.getText().isEmpty() && this.edit_city.getText().isEmpty())) {
                    addressCustomer = new AddressInfo();
                    addressCustomer.setId(-1);
                    addressCustomer.setAddress(this.edit_address.getText());
                    addressCustomer.setZipcode(this.edit_zipCode.getText());
                    addressCustomer.setCity(this.edit_city.getText());
                }
                this.currentCustomer.setNotes(this.edit_comment.getText());
                this.currentCustomer.setDiscount(Double.parseDouble(this.edit_discount.getText().isEmpty() ? "0.0" : this.edit_discount.getText()));
                try {
                    this.currentCustomer = this.mCustomerService.updateWithAddress(this.currentCustomer, addressCustomer);
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les informations du client ont \u00e9t\u00e9 modifi\u00e9 avec succ\u00e8s.", 1500, NPosition.CENTER);
                    this.loadCustomerItem(this.currentCustomer);
                    this.reloadCustomer(this.currentCustomer);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Le num\u00e9ro t\u00e9l\u00e9phone do\u00eet contenir 10 chiffres.", 1500, NPosition.CENTER);
            }
        } else if (this.edit_name_company.getText().isEmpty() || this.edit_phoneInterlocutor.getText().isEmpty()) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Merci de pr\u00e9ciser tous les champs.", 1500, NPosition.CENTER);
        } else if (this.edit_phoneInterlocutor.getText().length() == 10) {
            this.currentCustomer.setName(this.edit_name_company.getText());
            this.currentCustomer.setResponsible(this.edit_responsible.getText());
            this.currentCustomer.setInterlocutor(this.edit_interlocutor.getText());
            this.currentCustomer.setFunction_interlocutor(this.edit_interlocutorFunction.getText());
            this.currentCustomer.setPhone(this.edit_phoneInterlocutor.getText());
            this.currentCustomer.setEmail(this.edit_emailInterlocutor.getText());
            this.currentCustomer.setRange((String)this.edit_range.getSelectionModel().getSelectedItem());
            this.currentCustomer.setDiscount(Double.parseDouble(this.edit_discountCompany.getText().isEmpty() ? "0.0" : this.edit_discountCompany.getText()));
            AddressInfo addressCustomer = null;
            if (this.currentCustomer.getAdresseInfoCollection().size() > 0) {
                addressCustomer = this.currentCustomer.getAdresseInfoCollection().get(0);
                addressCustomer.setAddress(this.edit_addressCompany.getText());
                addressCustomer.setZipcode(this.edit_zipCodeCompany.getText());
                addressCustomer.setCity(this.edit_cityCompany.getText());
            } else if (!(this.edit_addressCompany.getText().isEmpty() && this.edit_zipCodeCompany.getText().isEmpty() && this.edit_cityCompany.getText().isEmpty())) {
                addressCustomer = new AddressInfo();
                addressCustomer.setId(-1);
                addressCustomer.setAddress(this.edit_addressCompany.getText());
                addressCustomer.setZipcode(this.edit_zipCodeCompany.getText());
                addressCustomer.setCity(this.edit_cityCompany.getText());
            }
            try {
                this.currentCustomer = this.mCustomerService.updateWithAddress(this.currentCustomer, addressCustomer);
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les informations de l'entreprise ont \u00e9t\u00e9 modifi\u00e9 avec succ\u00e8s.", 1500, NPosition.CENTER);
                this.loadCustomerItem(this.currentCustomer);
                this.reloadCustomer(this.currentCustomer);
            }
            catch (Exception ex) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "une erreur est servenu.", 1500, NPosition.CENTER);
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Le num\u00e9ro t\u00e9l\u00e9phone do\u00eet contenir 10 chiffres.", 1500, NPosition.CENTER);
        }
    }

    public void initialize() {
        this.showEspaceClient = false;
        this.nom_client.setText("");
        this.phone.setText("");
        this.name_customer.setText("");
        this.phone1.setText("");
        this.phone2.setText("");
        this.email.setText("");
        this.address.setText("");
        this.zipCode.setText("");
        this.city.setText("");
        this.comment.setText("");
        this.discount.setText("");
        this.name_company.setText("");
        this.responsible.setText("");
        this.interlocutor.setText("");
        this.interlocutorFunction.setText("");
        this.phoneInterlocutor.setText("");
        this.emailInterlocutor.setText("");
        this.addressCompany.setText("");
        this.zipCodeCompany.setText("");
        this.cityCompany.setText("");
        this.discountCompany.setText("");
        this.range.getSelectionModel().select(null);
        this.listCompany.getSelectionModel().select(null);
    }

    public void hideEspaceClient() {
        this.nom_client.setText("");
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)this.pane_message, 0, 0);
        this.showEspaceClient = false;
    }

    public static boolean like(String str, String expr) {
        return str.matches(expr + ".*");
    }

    public void loadPaneCustomer() {
        this.main_pane.getChildren().clear();
        this.listCustomers = new ArrayList<CustomerInfo>();
        if (this.listCustomers.size() > 0) {
            this.listCustomersFilter.clear();
            this.listCustomersFilter.addAll(this.listCustomers);
            this.main_pane.add((Node)this.scroll_client, 0, 0);
            this.loadClient();
        } else {
            this.main_pane.add((Node)this.pane_message, 0, 0);
        }
        this.parent_search.requestFocus();
    }

    public void backToCustomers() {
        this.main_pane.getChildren().clear();
        this.searchByPhone();
        this.parent_search.requestFocus();
    }

    public void exportCustomer() {
        this.btn_export.setText("Exportation ...");
        this.btn_export.setDisable(true);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(() -> Platform.runLater(() -> {
            DirectoryChooser fileChooser = new DirectoryChooser();
            fileChooser.setTitle("Export des clients");
            File customersCSVFile = fileChooser.showDialog(this.scene.getWindow());
            if (customersCSVFile != null) {
                CustomerEnvService customerService = new CustomerEnvService();
                try {
                    customerService.exportClients(customersCSVFile);
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Clients export\u00e9s.", 1500, NPosition.CENTER);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            this.btn_export.setText("Export");
            this.btn_export.setDisable(false);
        }));
    }

    public void importCustomer() {
        this.btn_import.setText("Imporation ...");
        this.btn_import.setDisable(true);
        ExecutorService exec = Executors.newSingleThreadExecutor();
        exec.execute(() -> Platform.runLater(() -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Importation des clients");
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("CSV", new String[]{"*.csv"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            File customersCSVFile = fileChooser.showOpenDialog(this.phone.getScene().getWindow());
            if (customersCSVFile != null) {
                CustomerEnvService customerService = new CustomerEnvService();
                try {
                    customerService.importClients(customersCSVFile);
                    this.loadPaneCustomer();
                    this.loadCompanies();
                    this.initialize();
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Clients import\u00e9s.", 1500, NPosition.CENTER);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
            this.btn_import.setText("Import");
            this.btn_import.setDisable(false);
        }));
    }

    private void enableFieldCustomer() {
        this.edit_name_customer.setDisable(false);
        this.edit_phone1.setDisable(false);
        this.edit_phone2.setDisable(false);
        this.edit_email.setDisable(false);
        this.edit_address.setDisable(false);
        this.edit_zipCode.setDisable(false);
        this.edit_city.setDisable(false);
        this.edit_listCompany.setDisable(false);
        this.edit_comment.setDisable(false);
        this.edit_discount.setDisable(false);
    }

    private void loadFieldCompany(CustomerInfo customer) {
        AddressInfo addr;
        this.edit_name_company.setText(customer.getName());
        this.edit_responsible.setText(customer.getResponsible());
        this.edit_interlocutor.setText(customer.getInterlocutor());
        this.edit_interlocutorFunction.setText(customer.getFunction_interlocutor());
        this.edit_phoneInterlocutor.setText(customer.getPhone());
        this.edit_emailInterlocutor.setText(customer.getEmail());
        this.edit_range.getSelectionModel().select((Object)customer.getRange());
        this.edit_discountCompany.setText(String.valueOf(customer.getDiscount()));
        if (this.currentCustomer.getAdresseInfoCollection().size() > 0 && (addr = this.currentCustomer.getAdresseInfoCollection().get(0)) != null) {
            this.edit_addressCompany.setText(addr.getAddress());
            this.edit_zipCodeCompany.setText(addr.getZipcode());
            this.edit_cityCompany.setText(addr.getCity());
        }
    }

    private void loadFieldCustomer(CustomerInfo customer) {
        AddressInfo addr;
        this.edit_name_customer.setText(customer.getName());
        this.edit_phone1.setText(customer.getPhone());
        this.edit_phone2.setText(customer.getPhone2());
        this.edit_email.setText(customer.getEmail());
        if (this.currentCustomer.getAdresseInfoCollection().size() > 0 && (addr = this.currentCustomer.getAdresseInfoCollection().get(0)) != null) {
            this.edit_address.setText(addr.getAddress());
            this.edit_zipCode.setText(addr.getZipcode());
            this.edit_city.setText(addr.getCity());
        }
        CustomerInfo infoCompany = null;
        if (customer.getCompany() != null && customer.getCompany() != -1) {
            for (CustomerInfo next : this.companies) {
                if (!next.getId().equals(customer.getCompany())) continue;
                infoCompany = next;
                break;
            }
        }
        this.edit_listCompany.getSelectionModel().select(infoCompany);
        this.edit_comment.setText(customer.getNotes());
        this.edit_discount.setText(String.valueOf(customer.getDiscount()));
    }

    private void disableFieldCustomer() {
        this.edit_name_customer.setDisable(true);
        this.edit_phone1.setDisable(true);
        this.edit_phone2.setDisable(true);
        this.edit_email.setDisable(true);
        this.edit_address.setDisable(true);
        this.edit_zipCode.setDisable(true);
        this.edit_city.setDisable(true);
        this.edit_listCompany.setDisable(true);
        this.edit_comment.setDisable(true);
        this.edit_discount.setDisable(true);
    }

    private void disableFieldCompany() {
        this.edit_name_company.setDisable(true);
        this.edit_responsible.setDisable(true);
        this.edit_interlocutor.setDisable(true);
        this.edit_interlocutorFunction.setDisable(true);
        this.edit_phoneInterlocutor.setDisable(true);
        this.edit_emailInterlocutor.setDisable(true);
        this.edit_addressCompany.setDisable(true);
        this.edit_zipCodeCompany.setDisable(true);
        this.edit_cityCompany.setDisable(true);
        this.edit_range.setDisable(true);
        this.edit_discountCompany.setDisable(true);
    }

    private void enableFieldCompany() {
        this.edit_name_company.setDisable(false);
        this.edit_responsible.setDisable(false);
        this.edit_interlocutor.setDisable(false);
        this.edit_interlocutorFunction.setDisable(false);
        this.edit_phoneInterlocutor.setDisable(false);
        this.edit_emailInterlocutor.setDisable(false);
        this.edit_addressCompany.setDisable(false);
        this.edit_zipCodeCompany.setDisable(false);
        this.edit_cityCompany.setDisable(false);
        this.edit_range.setDisable(false);
        this.edit_discountCompany.setDisable(false);
    }

    public void editCustomer() {
        this.showEdit();
        if (this.currentCustomer.getType() == null || this.currentCustomer.getType() != null && this.currentCustomer.getType().equals("customer")) {
            this.enableFieldCustomer();
        } else {
            this.enableFieldCompany();
        }
    }

    public void validUpdate() {
        try {
            this.updateCustomer();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.hideEdit();
    }

    public void cancelUpdate() {
        this.hideEdit();
    }

    private void hideEdit() {
        this.disableFieldCustomer();
        this.disableFieldCompany();
        this.pane_btn_edit.getChildren().clear();
        this.pane_btn_edit.getChildren().add((Object)this.edit_btn);
    }

    private void showEdit() {
        this.pane_btn_edit.getChildren().clear();
        this.pane_btn_edit.getChildren().add((Object)this.cancel_btn);
        this.pane_btn_edit.getChildren().add((Object)this.save_btn);
        this.enableFieldCustomer();
        this.enableFieldCompany();
    }

    private String getStatus(String status) {
        if (status != null) {
            switch (status) {
                case "livre": {
                    return "Livr\u00e9e";
                }
                case "paid": {
                    return "Termin\u00e9e";
                }
                case "cancel": {
                    return "Annul\u00e9e";
                }
                case "pending": {
                    return "En cours";
                }
                case "Refund": {
                    return "Remboursement";
                }
            }
        }
        return null;
    }

    public void exportDebit() {
        if (this.currentCustomer != null && this.debits != null && !this.debits.isEmpty()) {
            try {
                String fileName = this.currentCustomer.getName() + "_" + this.currentCustomer.getPhone();
                ExportDebitsCustomerExcel mExportDebitsCustomerExcel = new ExportDebitsCustomerExcel();
                mExportDebitsCustomerExcel.setComponentParent(null);
                fileName = fileName + ".xlsx";
                mExportDebitsCustomerExcel.setFileName(fileName);
                mExportDebitsCustomerExcel.setDebits(this.debits);
                mExportDebitsCustomerExcel.setmCustomerInfo(this.currentCustomer);
                String $result = mExportDebitsCustomerExcel.export();
                if ($result != null && !$result.equals("canceled")) {
                    try {
                        new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Les donn\u00e9es on \u00e9t\u00e9 export\u00e9 avec succ\u00e8s !", 1500, NPosition.BOTTOM_RIGHT);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }
}

