/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.beans.DateUtils;
import com.openbravo.components.interfaces.RootController;
import com.openbravo.dao.DataLogicProduct;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.Course;
import com.openbravo.pos.ticket.CourseView;
import com.openbravo.pos.util.LogToFile;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.util.Callback;

public class CoursesController
implements RootController {
    @FXML
    TableView tableView;
    @FXML
    TableColumn product;
    @FXML
    TableColumn hour;
    @FXML
    TableColumn price;
    @FXML
    TextField text_product;
    @FXML
    DatePicker datePicker;
    @FXML
    TextField text_price;
    @FXML
    Label label_groceries;
    @FXML
    Button btn_valid;
    @FXML
    Button btn_delete;
    private final SimpleDateFormat timeFormatter = com.openbravo.pos.util.DateUtils.timeFormatter;
    private AppView app;
    private Date date;
    private DataLogicProduct dlProducts;
    private Course currentCourse;
    private List<Course> courses;
    int row = -1;
    private static double widthPane = 700.0;
    private Stage stage;

    private void loadCourses() {
        this.currentCourse = null;
        try {
            this.courses = this.dlProducts.getCourseByDate(this.date);
            this.buildLines();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void loadCourse() {
        if (this.currentCourse != null) {
            this.text_product.setText(this.currentCourse.getProduct());
            this.text_price.setText(String.valueOf(this.currentCourse.getPrice()));
        }
    }

    private void buildLines() {
        ArrayList<CourseView> items = new ArrayList<CourseView>();
        for (Course course : this.courses) {
            items.add(new CourseView(course.getProduct(), course.getUnit(), course.getPrice(), this.timeFormatter.format(course.getCreated())));
        }
        ObservableList data = FXCollections.observableArrayList(items);
        this.tableView.setItems(data);
    }

    public void printTicket() {
        if (this.currentCourse != null) {
            // empty if block
        }
    }

    public void closePopUp() {
        this.stage.close();
    }

    public void select0() {
        this.text_price.setText(this.text_price.getText() + "0");
    }

    public void select1() {
        this.text_price.setText(this.text_price.getText() + "1");
    }

    public void select2() {
        this.text_price.setText(this.text_price.getText() + "2");
    }

    public void select3() {
        this.text_price.setText(this.text_price.getText() + "3");
    }

    public void select4() {
        this.text_price.setText(this.text_price.getText() + "4");
    }

    public void select5() {
        this.text_price.setText(this.text_price.getText() + "5");
    }

    public void select6() {
        this.text_price.setText(this.text_price.getText() + "6");
    }

    public void select7() {
        this.text_price.setText(this.text_price.getText() + "7");
    }

    public void select8() {
        this.text_price.setText(this.text_price.getText() + "8");
    }

    public void select9() {
        this.text_price.setText(this.text_price.getText() + "9");
    }

    public void selectPoint() {
        if (this.text_price.getText().length() >= 1) {
            this.text_price.setText(this.text_price.getText() + ".");
        }
    }

    public void selectBack() {
        if (this.text_price.getText().length() >= 1) {
            this.text_price.setText(this.text_price.getText().substring(0, this.text_price.getText().length() - 1));
        }
    }

    private void validCourse() {
        if (this.currentCourse != null) {
            if (!this.text_product.getText().isEmpty() && !this.text_price.getText().isEmpty()) {
                try {
                    this.currentCourse.setProduct(this.text_product.getText());
                    this.currentCourse.setUnit(1.0);
                    this.currentCourse.setPrice(Double.parseDouble(this.text_price.getText().isEmpty() ? "0.0" : this.text_price.getText()));
                    this.currentCourse.setDate_validation(this.date);
                    this.dlProducts.updateCource(this.currentCourse);
                    this.loadCourses();
                    this.intialize();
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, AppLocal.getIntString("Message.product.registered"), 1500, NPosition.BOTTOM_RIGHT);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else {
                new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, AppLocal.getIntString("Message.error.product"), 1500, NPosition.BOTTOM_RIGHT);
            }
        }
    }

    public void addCourse() {
        if (!this.text_product.getText().isEmpty() && !this.text_price.getText().isEmpty()) {
            try {
                Course course = new Course();
                course.setProduct(this.text_product.getText());
                course.setUser(this.app.getAppUserView().getUser().getUserInfo());
                course.setUnit(1.0);
                course.setCreated(this.date);
                course.setPrice(Double.parseDouble(this.text_price.getText().isEmpty() ? "0.0" : this.text_price.getText()));
                course.setDate_validation(this.date);
                this.dlProducts.addCource(course);
                this.loadCourses();
                this.intialize();
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, AppLocal.getIntString("Message.product.added"), 1500, NPosition.BOTTOM_RIGHT);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            new NotifyWindow(NotifyType.DEFAULT_NOTIFICATION, AppLocal.getIntString("Message.error.product"), 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    public void valid() {
        if (this.currentCourse != null) {
            this.validCourse();
        } else {
            this.addCourse();
        }
        this.stage.close();
    }

    public void intialize() {
        this.currentCourse = null;
        this.text_product.setText("");
        this.text_price.setText("");
    }

    public void deleteCourse() {
        if (this.currentCourse != null) {
            try {
                this.dlProducts.deleteCource(this.currentCourse);
                this.loadCourses();
                this.intialize();
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, AppLocal.getIntString("Message.product.deleted"), 1500, NPosition.BOTTOM_RIGHT);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void initalizer() {
        this.text_product.setPromptText(AppLocal.getIntString("Label.name.product"));
        this.text_price.setPromptText(AppLocal.getIntString("label.price"));
        this.datePicker.getProperties().put((Object)"vkType", (Object)4);
        this.text_price.getProperties().put((Object)"vkType", (Object)4);
        this.dlProducts = (DataLogicProduct)this.app.getBean("com.openbravo.dao.DataLogicProduct");
        this.courses = new ArrayList<Course>();
        this.tableView.setFixedCellSize(40.0);
        this.tableView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                int row;
                if (CoursesController.this.tableView.getSelectionModel().getSelectedIndex() != -1 && (row = CoursesController.this.tableView.getSelectionModel().getSelectedIndex()) != -1) {
                    CoursesController.this.currentCourse = CoursesController.this.courses.get(row);
                    CoursesController.this.loadCourse();
                }
            }
        });
        Calendar calToday = Calendar.getInstance();
        this.date = DateUtils.getToday();
        this.datePicker.setShowWeekNumbers(false);
        this.datePicker.setValue((Object)LocalDate.now());
        this.datePicker.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                LocalDate datePickerValue = (LocalDate)CoursesController.this.datePicker.getValue();
                CoursesController.this.date = com.openbravo.pos.util.DateUtils.asDate(datePickerValue);
                CoursesController.this.loadCourses();
            }
        });
        Callback<TableColumn<CourseView, String>, TableCell<CourseView, String>> cellFactoryProduct = new Callback<TableColumn<CourseView, String>, TableCell<CourseView, String>>(){

            public TableCell call(TableColumn<CourseView, String> param) {
                TableCell<CourseView, String> cell = new TableCell<CourseView, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            Text text = new Text(item);
                            text.setStyle("-fx-padding: 5px 30px 5px 5px;-fx-text-alignment:center;");
                            text.wrappingWidthProperty().bind((ObservableValue)this.getTableColumn().widthProperty().subtract(35));
                            this.setGraphic((Node)text);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                return cell;
            }
        };
        Callback<TableColumn<CourseView, Double>, TableCell<CourseView, Double>> cellFactoryUnit = new Callback<TableColumn<CourseView, Double>, TableCell<CourseView, Double>>(){

            public TableCell call(TableColumn<CourseView, Double> param) {
                TableCell<CourseView, Double> cell = new TableCell<CourseView, Double>(){

                    public void updateItem(Double item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null && !empty) {
                            Text text = new Text(item.toString());
                            text.setStyle("-fx-padding: 5px 30px 5px 5px;-fx-text-alignment:center;");
                            text.wrappingWidthProperty().bind((ObservableValue)this.getTableColumn().widthProperty().subtract(35));
                            this.setGraphic((Node)text);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                return cell;
            }
        };
        this.product.setCellFactory((Callback)cellFactoryProduct);
        this.hour.setCellFactory((Callback)cellFactoryProduct);
        this.price.setCellFactory((Callback)cellFactoryUnit);
        this.product.setCellValueFactory((Callback)new PropertyValueFactory("product"));
        this.hour.setCellValueFactory((Callback)new PropertyValueFactory("hour"));
        this.price.setCellValueFactory((Callback)new PropertyValueFactory("price"));
        this.loadCourses();
        this.setTexts();
    }

    @Override
    public void init(Stage mStage) {
        this.stage = mStage;
        this.initalizer();
    }

    @Override
    public void init(Stage mStage, Object object) {
        this.stage = mStage;
        this.app = this.app;
        this.initalizer();
    }

    @Override
    public void init(Stage mStage, Object ... objects) {
        this.stage = mStage;
        if (objects != null) {
            for (Object object : objects) {
                if (!(object instanceof AppView)) continue;
                this.app = (AppView)object;
            }
        }
        this.initalizer();
    }

    private void setTexts() {
        this.label_groceries.setText(AppLocal.getIntString("Text.groceries"));
        this.product.setText(AppLocal.getIntString("Label.name.product"));
        this.price.setText(AppLocal.getIntString("Label.amount"));
        this.hour.setText(AppLocal.getIntString("Text.hour"));
        this.btn_delete.setText(AppLocal.getIntString("Button.delete"));
        this.btn_valid.setText(AppLocal.getIntString("Button.valid"));
    }
}

