/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.services.SecurityCheckService;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;

public class ConnectAppController {
    @FXML
    GridPane main_pane;
    @FXML
    Label error_message;
    private JRootApp jRootApp;
    private SecurityCheckService securityCheckService;
    private DataLogicSales m_dlSales;
    String siret;
    String Key;
    private DataLogicItems dlItems;
    private TextField textCode;
    private Label error_text_code;
    private EventHandler mEventHandlerAddverificationCodeyAction = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            String codeVerificationAndUnlockPeriod = ConnectAppController.this.textCode.getText();
            if (codeVerificationAndUnlockPeriod != null && !codeVerificationAndUnlockPeriod.isEmpty()) {
                String dailyCode = String.valueOf(ConnectAppController.this.generateUnlockCode(ConnectAppController.this.siret, ConnectAppController.this.Key, new Date()));
                int unlockPeriod = ConnectAppController.this.getUnlockPeriod(codeVerificationAndUnlockPeriod);
                String codeVerification = codeVerificationAndUnlockPeriod.substring(2, codeVerificationAndUnlockPeriod.length() - 1);
                if (codeVerification.equals(dailyCode) && dailyCode != null) {
                    try {
                        ConnectAppController.this.error_text_code.setText("Chargement en cours ...");
                        ConnectAppController.this.error_text_code.getStyleClass().add((Object)"text_green1");
                        ConnectAppController.this.securityCheckService = SecurityCheckService.getInstance();
                        ConnectAppController.this.securityCheckService.setDateVerification(unlockPeriod);
                        ConnectAppController.this.jRootApp.loadFirstViewAfterCheckKeyLicence();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(ConnectAppController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    ConnectAppController.this.error_text_code.setText("Veuillez saisir un code valide");
                }
            } else {
                ConnectAppController.this.error_text_code.setText("Veuillez saisir un code valide");
            }
        }
    };

    public void initialize(JRootApp jRootApp, String message_error_value, boolean isusedpassword, boolean blocked) {
        try {
            this.m_dlSales = AppLocal.dlSales;
            this.jRootApp = jRootApp;
            if (blocked) {
                this.loadPopUpConnectApp(message_error_value, blocked);
            } else if (isusedpassword) {
                this.loadPopUpConnectApp(message_error_value, blocked);
            } else {
                this.loadPopUpAddCode(message_error_value);
            }
            if (this.m_dlSales != null) {
                this.siret = this.m_dlSales.getMarqueNF().getSiret();
            }
            this.dlItems = AppLocal.dlItems;
            if (this.dlItems != null) {
                this.Key = this.dlItems.getUserKeenIo();
                if (this.Key == null) {
                    this.Key = "-";
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void loadPopUpAddCode(String message_error_value) {
        GridPane connectAppPane = new GridPane();
        connectAppPane.setPrefWidth(this.main_pane.getPrefWidth());
        connectAppPane.setPrefHeight(this.main_pane.getPrefHeight() * 0.6);
        connectAppPane.setHgap(10.0);
        connectAppPane.setVgap(10.0);
        connectAppPane.setAlignment(Pos.CENTER);
        Label alertLabel = new Label("Attention !!");
        alertLabel.getStyleClass().addAll((Object[])new String[]{"text_red_fb3e3e", "text-size-80"});
        alertLabel.setAlignment(Pos.CENTER);
        alertLabel.setPrefHeight(connectAppPane.getPrefHeight() * 0.3);
        alertLabel.setPrefWidth(connectAppPane.getPrefWidth());
        this.error_message.setText(message_error_value);
        this.error_message.setPrefHeight(connectAppPane.getPrefHeight() * 0.7);
        this.error_message.setWrapText(true);
        GridPane codePane = new GridPane();
        this.textCode = new TextField();
        codePane.setAlignment(Pos.CENTER);
        this.textCode.setPromptText("Ins\u00e9rez votre code temporaire ici");
        this.textCode.getStyleClass().add((Object)"text-size-20");
        codePane.setPrefWidth(this.main_pane.getPrefWidth());
        codePane.setPrefHeight(this.main_pane.getPrefHeight() * 0.25);
        codePane.setHgap(10.0);
        codePane.setVgap(10.0);
        this.error_text_code = new Label("");
        this.error_text_code.setPrefWidth(codePane.getPrefWidth() * 0.5);
        this.error_text_code.setPrefHeight(codePane.getPrefHeight() * 0.4);
        this.error_text_code.setAlignment(Pos.CENTER);
        this.error_text_code.getStyleClass().addAll((Object[])new String[]{"text-size-15"});
        this.textCode.setPrefWidth(codePane.getPrefWidth() * 0.5);
        this.textCode.setPrefHeight(codePane.getPrefHeight() * 0.4);
        this.textCode.setAlignment(Pos.CENTER);
        codePane.add((Node)this.error_text_code, 0, 0);
        codePane.add((Node)this.textCode, 0, 1);
        connectAppPane.add((Node)alertLabel, 0, 0);
        connectAppPane.add((Node)this.error_message, 0, 1);
        GridPane PanebtnConnect = new GridPane();
        PanebtnConnect.setPrefHeight(this.main_pane.getPrefHeight() * 0.25);
        PanebtnConnect.setPrefWidth(this.main_pane.getPrefWidth());
        PanebtnConnect.setAlignment(Pos.CENTER);
        PanebtnConnect.setHgap(20.0);
        Button btnConnect = new Button("J'AI CONNECT\u00c9 L'APPAREIL");
        btnConnect.getStyleClass().addAll((Object[])new String[]{"bg_caribbean_green", "text-size-20", "bg_radius_1"});
        btnConnect.setPrefWidth(PanebtnConnect.getPrefWidth() * 0.3);
        btnConnect.setPrefHeight(PanebtnConnect.getPrefHeight() * 0.3);
        btnConnect.setOnAction(event -> this.jRootApp.loadFirstView());
        Button btnAddCode = new Button("JE SAISIS LE CODE");
        btnAddCode.getStyleClass().addAll((Object[])new String[]{"bg_orange", "text-size-20", "bg_radius_1"});
        btnAddCode.setPrefWidth(PanebtnConnect.getPrefWidth() * 0.3);
        btnAddCode.setPrefHeight(PanebtnConnect.getPrefHeight() * 0.3);
        btnAddCode.setOnAction(this.mEventHandlerAddverificationCodeyAction);
        PanebtnConnect.add((Node)btnConnect, 0, 0);
        PanebtnConnect.add((Node)btnAddCode, 1, 0);
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)connectAppPane, 0, 0);
        this.main_pane.add((Node)codePane, 0, 1);
        this.main_pane.add((Node)PanebtnConnect, 0, 2);
    }

    private int getUnlockPeriod(String codeVerificationAndUnlockPeriod) {
        String twoFirstDigits = codeVerificationAndUnlockPeriod.substring(0, 2);
        String lastDigit = codeVerificationAndUnlockPeriod.substring(codeVerificationAndUnlockPeriod.length() - 1, codeVerificationAndUnlockPeriod.length());
        int valueIntOftwoDigits = Integer.parseInt(twoFirstDigits);
        StringBuilder unlockPeriodText = new StringBuilder();
        unlockPeriodText.append(String.valueOf(valueIntOftwoDigits / 2));
        unlockPeriodText.append(lastDigit);
        int unlockPeriod = Integer.parseInt(unlockPeriodText.toString());
        return unlockPeriod;
    }

    public void loadPopUpConnectApp(String message_error_value, boolean blocked) {
        GridPane connectAppPane = new GridPane();
        connectAppPane.setPrefWidth(this.main_pane.getPrefWidth());
        connectAppPane.setPrefHeight(this.main_pane.getPrefHeight() * 0.7);
        connectAppPane.setHgap(10.0);
        connectAppPane.setVgap(10.0);
        connectAppPane.setAlignment(Pos.CENTER);
        Label alertLabel = new Label("Attention !!");
        alertLabel.getStyleClass().addAll((Object[])new String[]{"text_red_fb3e3e", "text-size-80"});
        alertLabel.setAlignment(Pos.CENTER);
        alertLabel.setPrefHeight(connectAppPane.getPrefHeight() * 0.5);
        alertLabel.setPrefWidth(connectAppPane.getPrefWidth());
        this.error_message.setText(message_error_value);
        this.error_message.setPrefHeight(connectAppPane.getPrefHeight() * 0.5);
        this.error_message.setWrapText(true);
        connectAppPane.add((Node)alertLabel, 0, 0);
        connectAppPane.add((Node)this.error_message, 0, 1);
        this.main_pane.getChildren().clear();
        this.main_pane.add((Node)connectAppPane, 0, 0);
        if (!blocked) {
            GridPane PanebtnConnect = new GridPane();
            PanebtnConnect.setPrefHeight(this.main_pane.getPrefHeight() * 0.3);
            PanebtnConnect.setPrefWidth(this.main_pane.getPrefWidth());
            PanebtnConnect.setAlignment(Pos.CENTER);
            Button btnConnect = new Button("J'AI CONNECT\u00c9 L'APPAREIL");
            btnConnect.getStyleClass().addAll((Object[])new String[]{"bg_caribbean_green", "text-size-20", "bg_radius_1"});
            btnConnect.setPrefWidth(PanebtnConnect.getPrefWidth() * 0.4);
            btnConnect.setPrefHeight(PanebtnConnect.getPrefHeight() * 0.3);
            btnConnect.setOnAction(event -> this.jRootApp.loadFirstView());
            PanebtnConnect.add((Node)btnConnect, 0, 0);
            this.main_pane.add((Node)PanebtnConnect, 0, 1);
        }
    }

    public String generateUnlockCode(String Siret, String KeenIo, Date date) {
        try {
            if (Siret == null || KeenIo == null || Siret.isEmpty() || KeenIo.isEmpty()) {
                return null;
            }
            String cleanedKeenIo = KeenIo.replaceAll("[^0-9]", "");
            System.out.println("++++++++++++++++++cleanedKeenIo" + cleanedKeenIo);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            String formattedDate = dateFormat.format(date).replaceAll("-", "");
            System.out.println("+++++++++++++++++++++++++formattedDate" + formattedDate);
            String inputString = Siret + cleanedKeenIo + formattedDate;
            System.out.println("++++++++++++++++++++inputString" + inputString);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] hashBytes = md5.digest(inputString.getBytes(StandardCharsets.UTF_8));
            System.out.println("++++++++++++++++++++++HashString " + this.bytesToHex(hashBytes));
            String code = this.bytesToHex(hashBytes).substring(0, 4) + this.bytesToHex(hashBytes).substring(this.bytesToHex(hashBytes).length() - 4);
            System.out.println("Unlock Code: " + code);
            return code;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

