/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.AppConstants;
import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.SystemUtils;
import java.io.File;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import org.apache.commons.io.FileUtils;

public class CheckListController {
    private AppView m_App;
    private DataLogicSales dlSales;
    private AppConfig config;
    private Scene scene;
    private String styleCss = "/styles/styles.css";
    @FXML
    TabPane parent_print_pane;
    @FXML
    Tab backuptab;
    @FXML
    Label licenceStatut;
    @FXML
    Label dateExpire;
    @FXML
    Label softVersionLicence;
    @FXML
    Label email;
    @FXML
    Label company;
    @FXML
    Label timeBackup;
    @FXML
    Label nbQuotidien;
    @FXML
    Label nbHebdo;
    @FXML
    Label nbMensuel;
    @FXML
    Label emplacemcentBackup;
    @FXML
    Label sgbd;
    @FXML
    Label driverClass;
    @FXML
    Label driverLibrary;
    @FXML
    Label url;
    @FXML
    Label companyName;
    @FXML
    Label siret;
    @FXML
    Label TVAIntra;
    @FXML
    Label emailCompany;
    @FXML
    Label adress;
    @FXML
    Label tel;
    @FXML
    Label city;
    @FXML
    Label zipCode;
    @FXML
    Label country;
    @FXML
    Label localName;
    @FXML
    Label integerFormat;
    @FXML
    Label doubleFormat;
    @FXML
    Label currencyFormat;
    @FXML
    Label percentFormat;
    @FXML
    Label dateFormat;
    @FXML
    Label timeFormat;
    @FXML
    Label dateTimeFormat;
    @FXML
    Label radius;
    @FXML
    Label adressPos;
    @FXML
    Label cleDallas;
    @FXML
    Label qrScanner;
    @FXML
    Label tpe;
    @FXML
    Label tpePort;
    @FXML
    Label balance;
    @FXML
    Label balancePort;
    @FXML
    Label bipper;
    @FXML
    Label bipperPort;
    @FXML
    Label afficheurParams;
    @FXML
    Label afficheurType;
    @FXML
    Label enteteTicket;
    @FXML
    Label piedTicket;
    @FXML
    Label telPOS;
    @FXML
    Label renduMonnaie;
    @FXML
    Label printCommande;
    @FXML
    Label pickTicket;
    @FXML
    Label printAvoir;
    @FXML
    Label numberTicket;
    @FXML
    Label caisseName;
    @FXML
    Label token;
    @FXML
    Label modeCaisse;
    @FXML
    Label typeCaisse;
    @FXML
    Label color1Born;
    @FXML
    Label color2Born;
    @FXML
    Label labelConnectedToBorn;
    @FXML
    Label connectedToborn;
    @FXML
    Label ipLabelPrinter;
    @FXML
    Label modelLabelPrinter;
    @FXML
    Label ipMaitre;
    @FXML
    Label typeAffichage;
    @FXML
    Label welcomeMsg;
    @FXML
    Label paimentBorne;
    @FXML
    Label printNumOrdre;
    @FXML
    Label fondNoirCuisine;
    @FXML
    Label printAllProduct;
    @FXML
    Label serveurCuisin;
    @FXML
    Label tailleProduct;
    @FXML
    Label tailleOptions;
    @FXML
    Label cutLabel;
    @FXML
    Label exclusIngredients;
    @FXML
    Label inclusIngredients;
    @FXML
    Label commentLabel;
    @FXML
    Label encaissementRapid;
    @FXML
    Label paimentBorneLabel;
    @FXML
    Label tailleProductPlausible;
    @FXML
    Label encaissementSeparate;
    @FXML
    Label openTiroir;
    @FXML
    Label modeCommande;
    @FXML
    Label tauxPromo;
    @FXML
    Label nbHeursHistorique;
    @FXML
    Label plusTard;
    @FXML
    Label methodPayement;
    @FXML
    Label typeCommandePlausible;
    @FXML
    Label rapportMail;
    @FXML
    Label ordreOnline;
    @FXML
    Label course;
    @FXML
    Label stock;
    @FXML
    Label stockLabel;
    @FXML
    Label alloResto;
    @FXML
    Label statsOnLine;
    @FXML
    Label orderAttente;
    @FXML
    Label modeCommadeOnBipper;
    @FXML
    Label viewPectureCat;
    @FXML
    Label desableQuantity;
    @FXML
    Label groupOptions;
    @FXML
    Label separateOptionsUnit;
    @FXML
    Label tableObligatoire;
    @FXML
    Label bipperObligatoire;
    @FXML
    Label desablePlanTable;
    @FXML
    Label viewTableNumber;
    @FXML
    Label fondCaisse;
    @FXML
    Separator paimentBorneSeparator;
    private MarqueNFC marqueNFC = null;

    private void loadModulesParams() {
        this.ordreOnline.setText((String)(this.config.getBooleanProperty("online.enabled") != false ? "Activ\u00e9 ,ID :" + this.config.getStringProperty("online.id") : "D\u00e9sactiv\u00e9"));
        this.rapportMail.setText(this.config.getBooleanProperty("email.synthese") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.course.setText(this.config.getBooleanProperty("module.course") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        if (AppLocal.licence.equals("livraison")) {
            this.stock.setText(this.config.getBooleanProperty("gestion.stock") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
            this.alloResto.setText(this.config.getBooleanProperty("allo.resto") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        } else {
            this.stock.setText("D\u00e9sactiv\u00e9");
            this.alloResto.setText("D\u00e9sactiv\u00e9");
        }
        this.statsOnLine.setText(this.config.getBooleanProperty("stats.online") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
    }

    private void loadAdvancedParams() {
        this.tableObligatoire.setText(this.config.getBooleanProperty("mandatory.table") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        String bipOnsite = this.config.getBooleanProperty("bip.onsite") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9";
        String bipTakeaway = this.config.getBooleanProperty("bip.takeaway") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9";
        String bipTakeawayPhone = this.config.getBooleanProperty("bip.takeaway.phone") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9";
        this.bipperObligatoire.setText("Sur Place: " + bipOnsite + ", Emport\u00e9: " + bipTakeaway + ", Emport\u00e9 par t\u00e9l\u00e9phone: " + bipTakeawayPhone);
        this.orderAttente.setText(this.config.getBooleanProperty("source.order") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.modeCommadeOnBipper.setText(this.config.getBooleanProperty("cache.typeOrder") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.viewPectureCat.setText(this.config.getBooleanProperty("image.category") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.desableQuantity.setText(this.config.getBooleanProperty("deactive.quantity") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.groupOptions.setText(this.config.getBooleanAndDefaultProperty("option.groupe") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.separateOptionsUnit.setText(this.config.getBooleanProperty("separate.option") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.desablePlanTable.setText(this.config.getBooleanProperty("deactive.plan") != false ? "D\u00e9sactiv\u00e9" : "Activ\u00e9");
        this.viewTableNumber.setText(this.config.getBooleanProperty("order.table") != false ? "D\u00e9sactiv\u00e9" : "Activ\u00e9");
        this.fondCaisse.setText(this.config.getBooleanProperty("show.fondCaisse") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
    }

    private void loadGeneralsParams() {
        this.encaissementRapid.setText(this.config.getBooleanProperty("encaisse.rapide") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.encaissementSeparate.setText(this.config.getBooleanProperty("payment.separe") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.openTiroir.setText(this.config.getBooleanProperty("open.drawer") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.plusTard.setText(this.config.getBooleanProperty("commande.plustard") != false ? "---Emporter Plus Tard---" : "---Faire suivre---");
        this.modeCommande.setText(this.config.getStringPropertyWithDefaultValue("default.modeOrder", "Sur Place"));
        this.nbHeursHistorique.setText((String)(this.config.getBooleanProperty("rappelTicket.limited") != false ? this.config.getStringProperty("rappelTicket.limited.count") + " heures" : "D\u00e9sactiv\u00e9"));
        StringBuilder payements = new StringBuilder();
        this.addToStrBuilder(payements, "payment.cash", AppConstants.PAYMENT_MODE.CASH.toString());
        this.addToStrBuilder(payements, "payment.ticketResto", AppConstants.PAYMENT_MODE.TICKET_RESTO.toString());
        this.addToStrBuilder(payements, "payment.cb", AppConstants.PAYMENT_MODE.CB.toString());
        this.addToStrBuilder(payements, "payment.free", AppConstants.PAYMENT_MODE.FREE.toString());
        this.addToStrBuilder(payements, "payment.cheque", AppConstants.PAYMENT_MODE.CHEQUE.toString());
        this.addToStrBuilder(payements, "payment.cashDro", AppConstants.PAYMENT_MODE.CASHDROW.toString());
        this.addToStrBuilder(payements, "payment.debit", AppConstants.PAYMENT_MODE.DEBIT.toString());
        this.methodPayement.setText(payements.toString());
        StringBuilder tailles = new StringBuilder();
        tailles.append("| Junior || Senior || Mega |");
        this.addPromo("product.size1", tailles, "| ", " |");
        this.addPromo("product.size2", tailles, "| ", " |");
        this.addPromo("product.size3", tailles, "| ", " |");
        this.tailleProductPlausible.setText(tailles.toString());
        StringBuilder typeCommandes = new StringBuilder();
        if (this.config.getStringProperty("order.sp") == null || this.config.getStringProperty("order.sp").equals("yes")) {
            typeCommandes.append("| ").append("Sur Place").append(" |");
        }
        if (this.config.getStringProperty("order.emp") == null || this.config.getStringProperty("order.emp").equals("yes")) {
            typeCommandes.append("| ").append("EMPORTER").append(" |");
        }
        if (this.config.getStringProperty("order.bar") != null && this.config.getStringProperty("order.bar").equals("yes")) {
            typeCommandes.append("| ").append("BAR").append(" |");
        }
        if (this.config.getStringProperty("order.terasse") != null && this.config.getStringProperty("order.terasse").equals("yes")) {
            typeCommandes.append("| ").append("TERASSE").append(" |");
        }
        if (this.config.getStringProperty("order.happyHour") != null && this.config.getStringProperty("order.happyHour").equals("yes")) {
            typeCommandes.append("| ").append("HAPPY HOUR").append(" |");
        }
        this.typeCommandePlausible.setText(typeCommandes.toString());
        StringBuilder tauxPromoString = new StringBuilder();
        this.addPromo("discount.sp", tauxPromoString.append("| "), "Sur Place: ", "% |");
        this.addPromo("discount.emp", tauxPromoString.append("| "), "EMPORTER: ", "% |");
        this.addPromo("discount.bar", tauxPromoString.append("| "), "BAR: ", "% |");
        this.addPromo("discount.terasse", tauxPromoString.append("| "), "TERASSE: ", "% |");
        this.addPromo("discount.happyHour", tauxPromoString.append("| "), "HAPPY HOUR: ", "% |");
        this.addPromo("discount.lv", tauxPromoString.append("| "), "LIVRAISON: ", "% |");
        this.tauxPromo.setText(tauxPromoString.toString());
    }

    private void addPromo(String str_discount_sur_place, StringBuilder append, String s, String s2) {
        if (this.config.getStringProperty(str_discount_sur_place) != null && !this.config.getStringProperty(str_discount_sur_place).isEmpty()) {
            append.append(s).append(this.config.getStringProperty(str_discount_sur_place)).append(s2);
        }
    }

    private void addToStrBuilder(StringBuilder payements, String s, String s2) {
        if (this.config.getBooleanProperty(s).booleanValue()) {
            payements.append(s2);
        } else {
            payements.append(s2);
        }
    }

    public void init(AppView app, Scene scene) throws BasicException, URISyntaxException {
        this.m_App = app;
        this.dlSales = (DataLogicSales)this.m_App.getBean("com.openbravo.dao.DataLogicSales");
        this.marqueNFC = this.dlSales.getMarqueNF();
        this.config = AppConfig.getInstance(true, this.m_App.getProperties().getConfigFile());
        this.loadLicenceInfos();
        this.loadCordonnes();
        this.loadDBconfig();
        this.loadMachineParams();
        this.loadLocalParams();
        this.loadPeripheralParams();
        this.loadTicketCaisseParams();
        this.loadNotesCuisineParams();
        this.loadGeneralsParams();
        this.loadAdvancedParams();
        this.loadModulesParams();
        this.backuptab.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event t) {
                if (CheckListController.this.backuptab.isSelected()) {
                    CheckListController.this.loadBackupParams();
                }
            }
        });
    }

    public void initialize() {
        this.parent_print_pane.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.loadBackupParams();
    }

    public void loadLicenceInfos() {
    }

    private void loadNotesCuisineParams() {
        this.printNumOrdre.setText(this.config.getBooleanProperty("display.numberOrder") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.exclusIngredients.setText(this.config.getBooleanProperty("label.printIngredientExclus") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.inclusIngredients.setText(this.config.getBooleanProperty("label.printIngredient") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.fondNoirCuisine.setText(this.config.getBooleanProperty("print.fondNoir") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.printAllProduct.setText(this.config.getBooleanProperty("print.ticketCuisine") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.serveurCuisin.setText(this.config.getBooleanProperty("display.nameServeur") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.cutLabel.setText(this.config.getBooleanProperty("label.autocutter") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.commentLabel.setText(this.config.getBooleanProperty("label.printnote") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
        this.tailleProduct.setText(this.config.getIntegerProperty("size.product") != 0 ? this.config.getStringProperty("size.product") : "1");
        this.tailleOptions.setText(this.config.getIntegerProperty("size.supplement") != 0 ? this.config.getStringProperty("size.supplement") : "1");
    }

    private void loadTicketCaisseParams() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CheckListController.this.enteteTicket.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("header.restaurant", "-------------"));
                CheckListController.this.piedTicket.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("footer.restaurant", "-------------"));
                CheckListController.this.telPOS.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("phone.restaurant", "-------------"));
                CheckListController.this.renduMonnaie.setText(CheckListController.this.config.getBooleanAndDefaultProperty("ticket.rendMonnaie") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
                CheckListController.this.printCommande.setText(CheckListController.this.config.getBooleanProperty("pending.ticket") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
                CheckListController.this.printAvoir.setText((String)(CheckListController.this.config.getBooleanProperty("print.avoir") != false ? "Activ\u00e9 : Ticket Avoir s'expire apr\u00e8s : " + CheckListController.this.config.getStringProperty("print.avoir.delai") + " " + CheckListController.this.config.getStringProperty("print.avoir.unit") : "D\u00e9sactiv\u00e9"));
                String path = new File(SystemUtils.SYS_USER_HOME, "images/logos/" + CheckListController.this.config.getStringProperty("pic.ticket")).getAbsolutePath();
                CheckListController.this.pickTicket.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("pic.ticket", path));
                CheckListController.this.setNumberTicket();
            }
        });
    }

    public void setNumberTicket() {
        try {
            PrinterInfo printerCaisse = this.dlSales.getPrinterByID(1);
            this.numberTicket.setText(printerCaisse.getNumber() + " Ticket(s)");
        }
        catch (BasicException ex) {
            Logger.getLogger(CheckListController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void loadBackupParams() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                String BACKUP_CONFIG = (AppLocal.IS_APP_PORTABLE != false ? Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() : SystemUtils.SYS_USER_HOME) + File.separator + "procaisse-properties" + File.separator + "backup.properties";
                File fConfig = new File(BACKUP_CONFIG);
                if (fConfig.exists()) {
                    try {
                        String[] configBackupString = FileUtils.readFileToString((File)new File(BACKUP_CONFIG)).split("\n");
                        if (configBackupString.length == 5) {
                            CheckListController.this.emplacemcentBackup.setText(configBackupString[0]);
                            CheckListController.this.nbQuotidien.setText(configBackupString[1]);
                            CheckListController.this.nbHebdo.setText(configBackupString[2]);
                            CheckListController.this.nbMensuel.setText(configBackupString[3]);
                            CheckListController.this.timeBackup.setText(configBackupString[4]);
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }
        });
    }

    private void loadPeripheralParams() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CheckListController.this.cleDallas.setText(CheckListController.this.config.getBooleanProperty("finger.print") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
                CheckListController.this.qrScanner.setText(CheckListController.this.config.getBooleanProperty("scan.qr") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
                CheckListController.this.tpe.setText(CheckListController.this.config.getBooleanProperty("payment.cb.tpe") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
                CheckListController.this.tpePort.setText("Port : " + CheckListController.this.config.getStringPropertyWithDefaultValue("payment.cb.tpe.port", ""));
                CheckListController.this.balance.setText(CheckListController.this.config.getBooleanProperty("units.balance") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
                CheckListController.this.balancePort.setText("Port : " + CheckListController.this.config.getStringPropertyWithDefaultValue("units.balance.port", ""));
                CheckListController.this.bipper.setText(CheckListController.this.config.getBooleanProperty("bipper.auto") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
                CheckListController.this.bipperPort.setText("Port : " + CheckListController.this.config.getStringPropertyWithDefaultValue("bipper.auto.port", ""));
                String machineDisplay = CheckListController.this.config.getStringProperty("machine.display");
                String[] aficheurparams = machineDisplay.split(",");
                String type = aficheurparams[0];
                CheckListController.this.afficheurType.setText(type);
                if (aficheurparams.length > 1) {
                    String params = machineDisplay.substring(machineDisplay.indexOf(",") + 1);
                    CheckListController.this.afficheurParams.setText(params);
                }
                if (machineDisplay.contains("window")) {
                    CheckListController.this.afficheurParams.setText("Slider time : " + CheckListController.this.config.getStringPropertyWithDefaultValue("time.slide", "0") + " s");
                }
            }
        });
    }

    private void loadLocalParams() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CheckListController.this.localName.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("user.language", "par d\u00e9faut"));
                CheckListController.this.integerFormat.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("format.integer", "par d\u00e9faut"));
                CheckListController.this.doubleFormat.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("format.double", "par d\u00e9faut"));
                CheckListController.this.currencyFormat.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("format.currency", "par d\u00e9faut"));
                CheckListController.this.percentFormat.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("format.percent", "par d\u00e9faut"));
                CheckListController.this.dateFormat.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("format.date", "par d\u00e9faut"));
                CheckListController.this.timeFormat.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("format.time", "par d\u00e9faut"));
                CheckListController.this.dateTimeFormat.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("format.datetime", "par d\u00e9faut"));
                CheckListController.this.radius.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("address.radius", "non d\u00e9finit"));
                CheckListController.this.adressPos.setText(CheckListController.this.config.getStringPropertyWithDefaultValue("address.resto", "non d\u00e9finit"));
            }
        });
    }

    public void loadCordonnes() {
        try {
            this.marqueNFC = this.dlSales.getMarqueNF();
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (CheckListController.this.marqueNFC != null) {
                    CheckListController.this.companyName.setText(CheckListController.this.marqueNFC.getCompany() != null ? CheckListController.this.marqueNFC.getCompany() : "-------------");
                    CheckListController.this.siret.setText(CheckListController.this.marqueNFC.getSiret() != null ? CheckListController.this.marqueNFC.getSiret() : "-------------");
                    CheckListController.this.TVAIntra.setText(CheckListController.this.marqueNFC.getIntraTVA() != null && !CheckListController.this.marqueNFC.getIntraTVA().isEmpty() ? CheckListController.this.marqueNFC.getIntraTVA() : "-------------");
                    CheckListController.this.emailCompany.setText(CheckListController.this.marqueNFC.getEmail() != null ? CheckListController.this.marqueNFC.getEmail() : "-------------");
                    CheckListController.this.adress.setText(CheckListController.this.marqueNFC.getAdresse1() != null ? CheckListController.this.marqueNFC.getAdresse1() : "-------------");
                    CheckListController.this.tel.setText(CheckListController.this.marqueNFC.getTel() != null ? CheckListController.this.marqueNFC.getTel() : "-------------");
                    CheckListController.this.city.setText(CheckListController.this.marqueNFC.getCity() != null ? CheckListController.this.marqueNFC.getCity() : "-------------");
                    CheckListController.this.zipCode.setText(CheckListController.this.marqueNFC.getZipCode() != null ? CheckListController.this.marqueNFC.getZipCode() : "-------------");
                    CheckListController.this.country.setText(CheckListController.this.marqueNFC.getCountry() != null ? CheckListController.this.marqueNFC.getCountry() : "-------------");
                }
            }
        });
    }

    private void loadDBconfig() {
        this.sgbd.setText(this.config.getStringProperty("db.engine"));
        this.driverClass.setText(this.config.getStringProperty("db.driverlib"));
        this.driverLibrary.setText(this.config.getStringProperty("db.driver"));
        this.url.setText(this.config.getStringProperty("db.URL"));
    }

    private void loadMachineParams() {
        this.caisseName.setText(this.config.getStringProperty("machine.hostname"));
        this.token.setText(this.config.getStringProperty("machine.token"));
        String displayMode = this.config.getStringProperty("mode.display");
        this.modeCaisse.setText(displayMode);
        this.paimentBorne.setVisible(false);
        this.paimentBorneLabel.setVisible(false);
        this.paimentBorneSeparator.setVisible(false);
        if (displayMode != null && displayMode.equalsIgnoreCase("Borne")) {
            this.paimentBorne.setVisible(true);
            this.paimentBorneLabel.setVisible(true);
            this.paimentBorneSeparator.setVisible(true);
            this.paimentBorne.setText(this.config.getBooleanProperty("payment.borne") != false ? "Activ\u00e9" : "D\u00e9sactiv\u00e9");
            this.modeCaisse.setText(displayMode + " / " + this.config.getStringProperty("type.borne"));
            this.labelConnectedToBorn.setVisible(false);
            this.connectedToborn.setVisible(false);
            this.ipLabelPrinter.setVisible(false);
            this.modelLabelPrinter.setVisible(false);
            this.color1Born.setVisible(true);
            this.color2Born.setVisible(true);
            this.color1Born.setText("couleur 1 : RGB(" + this.config.getStringProperty("color.borne") + ")");
            this.color2Born.setText("couleur 2 : RGB(" + this.config.getStringProperty("color_light.borne") + ")");
        } else if (displayMode == null || displayMode.equalsIgnoreCase("Caisse") || displayMode.equalsIgnoreCase("Tabletto")) {
            this.labelConnectedToBorn.setVisible(true);
            this.connectedToborn.setVisible(true);
            this.connectedToborn.setText(this.config.getStringProperty("exist.borne"));
            this.color1Born.setVisible(false);
            this.color2Born.setVisible(false);
            this.ipLabelPrinter.setVisible(false);
            this.modelLabelPrinter.setVisible(false);
        } else if (displayMode.equalsIgnoreCase("Ecran cuisine")) {
            this.ipLabelPrinter.setText("IP : " + this.config.getStringProperty("ip.label"));
            this.modelLabelPrinter.setText("model : " + this.config.getStringProperty("model.label"));
            this.ipLabelPrinter.setVisible(true);
            this.modelLabelPrinter.setVisible(true);
            this.color1Born.setVisible(false);
            this.color2Born.setVisible(false);
            this.labelConnectedToBorn.setVisible(false);
            this.connectedToborn.setVisible(false);
        }
        this.typeCaisse.setText(this.config.getStringProperty("model.caisse"));
        this.ipMaitre.setVisible(false);
        if (this.typeCaisse.getText().equalsIgnoreCase("Esclave")) {
            this.ipMaitre.setVisible(true);
            this.ipMaitre.setText("IP de la caisse Maitre : " + this.config.getStringProperty("ip.master"));
        }
        this.typeAffichage.setText(this.config.getStringProperty("machine.screenmode"));
        this.welcomeMsg.setText(this.config.getStringPropertyWithDefaultValue("message.welcome", "non d\u00e9finit"));
    }
}

