/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.controllers.OpenCaisseController;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppUser;
import com.openbravo.pos.forms.JRootApp;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import java.awt.Color;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;

public class CaisseFermeController {
    @FXML
    private ImageView logo;
    private Scene sceneCaisse;
    private JRootApp app;
    @FXML
    Button btn_exit;
    @FXML
    Button btn_open_caisse;
    @FXML
    Button btn_back;
    private int role;
    private AppUser user;
    @FXML
    FlowPane pane_center;
    @FXML
    FlowPane pane_btn_open;
    @FXML
    Label message_caisse;
    @FXML
    Label label_caisse_closed;
    private DataLogicAdmin dlUser;
    Label exitLabel = new Label();
    private String colorCaisse;
    @FXML
    FlowPane pane_btnss;
    @FXML
    FlowPane pane_text;
    @FXML
    GridPane pane_back;
    @FXML
    GridPane pane_exit;
    @FXML
    GridPane pane_btn;
    @FXML
    GridPane pane_image;
    @FXML
    GridPane gridtext;
    @FXML
    StackPane stack_pane;
    Label statusCaisseLabel = new Label(AppLocal.getIntString("Text.closed.cash.registrer"));

    public void init(int role, JRootApp app, AppUser user, Scene sceneCaisse) throws BasicException {
        try {
            this.app = app;
            this.sceneCaisse = sceneCaisse;
            this.role = role;
            this.user = user;
            Image img_logo = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/status_caisse.png"));
            this.dlUser = (DataLogicAdmin)app.getBean("com.openbravo.pos.admin.DataLogicAdmin");
            if (this.dlUser.hasPermission(user.getId(), "1")) {
                this.pane_text.getChildren().clear();
                this.pane_text.getChildren().add((Object)this.btn_open_caisse);
            } else {
                this.pane_text.getChildren().clear();
                this.pane_text.getChildren().add((Object)this.message_caisse);
            }
            this.exitLabel.setPrefHeight(40.0);
            this.exitLabel.setPrefWidth(40.0);
            this.exitLabel.setAlignment(Pos.CENTER);
            ImageView imagexit = new ImageView(new Image(this.getClass().getResource("/com/openbravo/images/ximage.png").toURI().toString()));
            imagexit.setFitHeight(30.0);
            imagexit.setFitWidth(30.0);
            this.exitLabel.setGraphic((Node)imagexit);
            this.btn_exit.setGraphic((Node)this.exitLabel);
            Image image = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/back-arrow.png"));
            this.btn_back.setGraphic((Node)new ImageView(image));
            BackgroundImage bImg = new BackgroundImage(img_logo, BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, BackgroundSize.DEFAULT);
            Background bGround = new Background(new BackgroundImage[]{bImg});
            this.stack_pane.setBackground(bGround);
            this.gridtext.setPrefHeight(this.stack_pane.getPrefHeight());
            this.gridtext.setPrefWidth(this.stack_pane.getPrefWidth());
            this.gridtext.add((Node)this.statusCaisseLabel, 0, 0);
            this.changeButtonOpenCaisse(this.btn_open_caisse, "#2ECC71");
            this.initCss();
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(CaisseFermeController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void exit() {
        try {
            Journal.writeToJET(new Event(40, "Arret de l'application", AppLocal.user != null ? AppLocal.user.getId() : "", "", new Date().getTime(), ""));
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
        System.exit(0);
    }

    public void back() {
        this.app.getFxPanel().setScene(this.app.getCurrentScene());
    }

    public void openCaisse() {
        try {
            String fxmlFile = "/fxml/popUp_openCaisse.fxml";
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource(fxmlFile));
            Parent rootNode = (Parent)loader.load();
            OpenCaisseController controller = (OpenCaisseController)loader.getController();
            Scene scenePop = new Scene(rootNode, 600.0, 500.0);
            scenePop.getStylesheets().add((Object)"/styles/styles.css");
            Stage modalStage = new Stage();
            modalStage.setScene(scenePop);
            modalStage.initOwner(this.sceneCaisse.getWindow());
            modalStage.initModality(Modality.APPLICATION_MODAL);
            modalStage.initStyle(StageStyle.UTILITY);
            modalStage.setAlwaysOnTop(true);
            controller.init(modalStage, this.sceneCaisse, this.role, this.app, this.user);
            modalStage.show();
            modalStage.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                }
            });
        }
        catch (Exception ex) {
            LogToFile.log("sever", ex.getMessage(), ex);
        }
    }

    public void initCss() {
        if (AppLocal.color_borne != null && !AppLocal.color_borne.isEmpty()) {
            Color rbgColor = ColorUtils.getColorByString(AppLocal.color_borne);
            this.colorCaisse = String.format("#%02x%02x%02x", rbgColor.getRed(), rbgColor.getGreen(), rbgColor.getBlue());
        } else {
            this.colorCaisse = "#FF5E00";
        }
        String styleCaisse = " -fx-background-color: " + this.colorCaisse + ";";
        this.pane_back.setStyle(styleCaisse);
        this.pane_exit.setStyle(styleCaisse);
        this.pane_btn.setStyle(styleCaisse);
        this.pane_image.setStyle(styleCaisse);
        this.exitLabel.setStyle("-fx-border-radius: 50%; -fx-font-weight: 1000; -fx-background-color:" + this.colorCaisse + "; -fx-background-radius: 50px; -fx-border-radius: 50px; -fx-border-color: #FFFFFF; -fx-border-style: solid;-fx-padding: 5px;");
        this.statusCaisseLabel.setStyle("-fx-font-family: Poppins, Helvetica, Arial, sans-serif;-fx-font-size: 27px;-fx-text-fill: " + this.colorCaisse + ";-fx-font-weight: bold; -fx-font-style: normal;");
        this.message_caisse.setStyle("-fx-font-family: Poppins, Helvetica, Arial, sans-serif;-fx-font-size: 27px;-fx-text-fill: " + this.colorCaisse + ";-fx-font-weight: bold; -fx-font-style: normal;");
    }

    public void changeButtonOpenCaisse(Button btn, String color) {
        GridPane gridOpenCaisse = new GridPane();
        gridOpenCaisse.setPrefHeight(btn.getPrefHeight() * 0.9);
        gridOpenCaisse.setPrefWidth(395.0);
        gridOpenCaisse.setAlignment(Pos.CENTER);
        Label labelopen = new Label(AppLocal.getIntString("Button.open.caisse"));
        labelopen.setPrefWidth(300.0);
        labelopen.setPrefHeight(gridOpenCaisse.getPrefHeight());
        labelopen.setAlignment(Pos.CENTER);
        String styleLabelgcolored = "-fx-font-family: Poppins, Helvetica, Arial, sans-serif;-fx-font-size: 27px;-fx-text-fill: " + color + ";-fx-font-weight: bold; -fx-font-style: normal;";
        String styleLabelWite = "-fx-font-family: Poppins, Helvetica, Arial, sans-serif;-fx-font-size: 27px;-fx-text-fill: #FFFFFF;-fx-font-weight: bold; -fx-font-style: normal;";
        Image Imgwhite = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/direct_white.png"));
        Image ImgGreen = new Image(this.getClass().getResourceAsStream("/com/openbravo/images/direct_green.png"));
        String IDLE_BUTTON_STYLE = " -fx-font-family: Poppins, Helvetica, Arial, sans-serif;    -fx-font-weight: bold;    -fx-font-size: 24px;    -fx-hgap: 20px;    -fx-background-color: #FFFFFF;    -fx-background-radius: 16px;    -fx-border-radius: 16px;    -fx-border-width: 3px;    -fx-border-color: " + color + ";    -fx-text-fill:" + color + ";";
        String HOVERED_BUTTON_STYLE = " -fx-font-family: Poppins, Helvetica, Arial, sans-serif;    -fx-font-weight: bold;    -fx-font-size: 24px;    -fx-hgap: 20px;    -fx-background-color:  " + color + ";    -fx-background-radius: 16px;    -fx-border-radius: 16px;    -fx-border-width: 3px;    -fx-border-color: " + color + ";    -fx-text-fill: #FFFFFF;";
        this.addGrid(gridOpenCaisse, ImgGreen, labelopen, btn, IDLE_BUTTON_STYLE, styleLabelgcolored);
        btn.setOnMouseEntered(e -> this.addGrid(gridOpenCaisse, Imgwhite, labelopen, btn, HOVERED_BUTTON_STYLE, styleLabelWite));
        btn.setOnMouseExited(e -> this.addGrid(gridOpenCaisse, ImgGreen, labelopen, btn, IDLE_BUTTON_STYLE, styleLabelgcolored));
    }

    public void addGrid(GridPane grid, Image image, Label label, Button btn, String style, String styleLabel) {
        grid.getChildren().clear();
        label.setStyle(styleLabel);
        btn.setStyle(style);
        ImageView img = new ImageView(image);
        grid.add((Node)label, 0, 0);
        grid.add((Node)img, 1, 0);
        btn.setGraphic((Node)grid);
    }
}

