/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.BorneInfo;
import fr.protactile.procaisse.services.BorneService;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import org.json.JSONObject;
import org.json.JSONTokener;

public class BornesControllerNew {
    @FXML
    GridPane main_pane;
    @FXML
    GridPane list_bornes;
    @FXML
    GridPane pane_next_borne;
    @FXML
    ScrollPane list_parent_scroll_pane;
    @FXML
    ScrollPane info_scroll_pane;
    @FXML
    FlowPane list_pane;
    @FXML
    FlowPane togglers_pane;
    @FXML
    FlowPane info_pane;
    @FXML
    FlowPane info_parent_pane;
    @FXML
    FlowPane info_pane_notice;
    @FXML
    FlowPane tags_pane;
    @FXML
    Button btn_borne_previous;
    @FXML
    Button btn_borne_next;
    @FXML
    Button sync_btn;
    @FXML
    Button sync_products_btn;
    @FXML
    Button sync_images_btn;
    @FXML
    Button relaunch_btn;
    @FXML
    Button restart_btn;
    @FXML
    Button shutdown_btn;
    @FXML
    Button cashlogy_btn;
    @FXML
    Label name_label;
    @FXML
    Label ip_label;
    @FXML
    Label pending_label;
    @FXML
    Label disable_terminal_label;
    @FXML
    Label delete_terminal_label;
    @FXML
    Label cashlogy_label;
    @FXML
    Label sync_label;
    @FXML
    Label sync_products_label;
    @FXML
    Label sync_images_label;
    @FXML
    Label relaunch_label;
    @FXML
    Label restart_label;
    @FXML
    Label shutdown_label;
    @FXML
    Label diff_onseat_status;
    @FXML
    ImageView pending_imgv;
    @FXML
    Button payment_btn;
    @FXML
    Button onseat_btn;
    @FXML
    Button maintenance_btn;
    @FXML
    Button delete_terminal_btn;
    @FXML
    Button disable_terminal_btn;
    @FXML
    Button add_terminal_btn;
    @FXML
    Button update_terminal_btn;
    @FXML
    Button persist_update_terminal_btn;
    @FXML
    Button cancel_update_btn;
    @FXML
    Button cancel_new_btn;
    @FXML
    Button save_terminal_btn;
    @FXML
    Button global_onseat_btn;
    @FXML
    HBox payment_toggler;
    @FXML
    HBox onseat_toggler;
    @FXML
    HBox maintenance_toggler;
    @FXML
    HBox header_box;
    @FXML
    HBox update_trigger_box;
    @FXML
    HBox update_form_box;
    @FXML
    HBox super_admin;
    @FXML
    HBox global_onseat_toggler;
    @FXML
    TextField terminal_ip_field;
    @FXML
    TextField new_terminal_ip_field;
    @FXML
    VBox new_terminal_form;
    @FXML
    ComboBox<String> type_combo;
    List<String> synchroJobs = new ArrayList<String>();
    private AppView app;
    private List<BorneInfo> bornes;
    private BorneService mBorneService;
    private boolean USER_IS_SUPER_ADMIN;
    private boolean USER_HAS_ACCES_TO_BACK_OFFICE;
    private BorneInfo currentBorne;
    private final String mainColor = "#FB5B4D";
    private RotateTransition rotate;
    private final EventHandler mEventHandlerDisable = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            String op = BornesControllerNew.this.currentBorne.isEquipment_disabled() ? "D\u00e9sactivation..." : "Activation...";
            BornesControllerNew.this.disable_terminal_label.setText(op);
            if (BornesControllerNew.this.currentBorne == null) {
                return;
            }
            System.out.println("borne : " + BornesControllerNew.this.currentBorne);
            BornesControllerNew.this.currentBorne.setEquipment_disabled(!BornesControllerNew.this.currentBorne.isEquipment_disabled());
            BornesControllerNew.this.mBorneService.setDisableEquipment(BornesControllerNew.this.currentBorne);
            if (BornesControllerNew.this.currentBorne.isEquipment_disabled()) {
                BornesControllerNew.this.disable_terminal_label.setText("Activer");
            } else {
                BornesControllerNew.this.disable_terminal_label.setText("D\u00e9sactiver");
            }
        }
    };

    public void init(AppView app) throws BasicException, URISyntaxException {
        this.app = app;
        this.mBorneService = BorneService.getInstance();
        this.bornes = new ArrayList<BorneInfo>();
        this.delete_terminal_btn.setOnAction(e -> this.deleteBorne());
        this.relaunch_btn.setOnAction(e -> this.relaunchSoftware());
        this.disable_terminal_btn.setOnAction(this.mEventHandlerDisable);
        this.restart_btn.setOnAction(e -> this.shutdownTerminal(true));
        this.shutdown_btn.setOnAction(e -> this.shutdownTerminal(false));
        this.payment_toggler.setOnMouseClicked(e -> this.toggleButton(this.payment_toggler));
        this.onseat_toggler.setOnMouseClicked(e -> this.toggleButton(this.onseat_toggler));
        this.maintenance_toggler.setOnMouseClicked(e -> this.toggleButton(this.maintenance_toggler));
        this.global_onseat_toggler.setOnMouseClicked(e -> this.toggleButton(this.global_onseat_toggler));
        this.sync_btn.setOnAction(e -> this.synchroGlobal());
        this.sync_images_btn.setOnAction(e -> this.synchroImages());
        this.sync_products_btn.setOnAction(e -> this.synchroItems());
        this.cancel_update_btn.setOnAction(e -> this.cancelUpdate());
        this.update_terminal_btn.setOnAction(e -> this.triggerUpdate());
        this.persist_update_terminal_btn.setOnAction(e -> this.persistUpdateTerminal());
        this.cancel_new_btn.setOnAction(e -> this.hideNewTerminal());
        this.add_terminal_btn.setOnAction(e -> this.addNewTerminal());
        this.save_terminal_btn.setOnAction(e -> this.saveTerminal());
        this.initTypeCombo();
        this.hideScrollBars();
        this.initMainPaneConstraints();
        this.cashlogy_btn.setOnAction(e -> this.loadCashlogy());
    }

    private void initTypeCombo() {
        this.type_combo.getItems().addAll((Object[])new String[]{"Caisse", "Borne", "Tablette", "SelfCheckout"});
        this.type_combo.setValue((Object)"Borne");
        this.type_combo.setButtonCell((ListCell)new ListCell<String>(){

            protected void updateItem(String o, boolean bln) {
                super.updateItem((Object)o, bln);
                this.setText(o);
                this.setStyle("-fx-background-color: white; -fx-text-fill: black; -fx-border-radius: 10px; -fx-background-radius: 10px;");
            }
        });
    }

    private void hideScrollBars() {
        this.list_parent_scroll_pane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.list_parent_scroll_pane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.list_parent_scroll_pane.setPannable(true);
        this.info_scroll_pane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.info_scroll_pane.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.info_scroll_pane.setPannable(true);
    }

    private void initMainPaneConstraints() {
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setPercentWidth(50.0);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setPercentWidth(50.0);
        this.main_pane.getColumnConstraints().clear();
        this.main_pane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
    }

    private void loadBornes() {
        this.bornes = this.mBorneService.getBornes();
        System.out.println("********bornes :" + this.bornes);
        this.repaintBornes();
    }

    private void initGlobalToggler() {
        this.setTogglerStatus(this.global_onseat_toggler, this.getTogglerPosition(this.isOnseatEnabledForAll()));
        if (this.isOnseatEnabledOnlyForSome()) {
            this.diff_onseat_status.setManaged(true);
            this.diff_onseat_status.setVisible(true);
        } else {
            this.diff_onseat_status.setVisible(false);
            this.diff_onseat_status.setManaged(false);
        }
    }

    private void repaintBornes() {
        this.list_pane.getChildren().clear();
        if (this.bornes != null && !this.bornes.isEmpty()) {
            this.insertIntoMainPane();
        } else {
            this.list_pane.setAlignment(Pos.CENTER);
            Label noContent = new Label("Aucune borne disponible.");
            noContent.setStyle("-fx-font-weight: bold; -fx-text-fill: black; -fx-font-size: 30pt;");
            this.list_pane.getChildren().add((Object)noContent);
        }
    }

    private String getSynchUrl(String typeSynchro) {
        switch (typeSynchro) {
            case "images": {
                Platform.runLater(() -> {
                    this.sync_images_label.setStyle(this.getSynchLabelStyle("#FB5B4D"));
                    this.sync_images_label.setText("Synchronisation...");
                });
                return "http://" + this.currentBorne.getAddress_ip() + ":9097/newItems/remoteSyncImages";
            }
            case "items": {
                Platform.runLater(() -> {
                    this.sync_products_label.setStyle(this.getSynchLabelStyle("#FB5B4D"));
                    this.sync_products_label.setText("Synchronisation...");
                });
                return "http://" + this.currentBorne.getAddress_ip() + ":9097/newItems/remoteSyncItems";
            }
        }
        Platform.runLater(() -> {
            this.sync_label.setStyle(this.getSynchLabelStyle("#FB5B4D"));
            this.sync_label.setText("Synchronisation...");
        });
        return "http://" + this.currentBorne.getAddress_ip() + ":9097/newItems/remoteSync";
    }

    private String getSynchLabelStyle(String color) {
        return "-fx-font-size: 12pt; -fx-font-weight: normal; -fx-background-color: transparent; -fx-text-fill: " + color + ";";
    }

    public void loadCashlogy() {
        if (this.currentBorne == null || !this.USER_HAS_ACCES_TO_BACK_OFFICE) {
            return;
        }
        if (this.currentBorne.getAddress_ip() != null) {
            this.cashlogy_label.setText("Affichage du BackOffice Cashlogy...");
            new Thread(() -> {
                try {
                    String url_base = "http://" + this.currentBorne.getAddress_ip() + ":9097/newItems/LoadBackofficeCashlogy";
                    System.out.println("+++++++++++++ url_base : " + url_base);
                    if (!url_base.isEmpty()) {
                        URL url = new URL(url_base);
                        JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                        JSONObject data = new JSONObject(tokener);
                        System.out.println("+++++++++++++++++++ data :" + data.toString());
                        String message = data.getString("STATUS");
                        if (message.equals("OK")) {
                            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Le BackOffice s'affiche avec succ\u00e8s sur " + this.currentBorne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                        } else {
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "\u00c9chec de l'affichage du BackOffice sur  " + this.currentBorne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
                }
                finally {
                    this.changeTextButton("cashlogy");
                }
            }).start();
        }
    }

    private void addBorne(BorneInfo borne) {
        try {
            this.mBorneService.addBorne(borne);
            this.currentBorne = borne;
            this.bornes.add(borne);
            this.repaintBornes();
            this.loadInfoPaneContent();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Borne enregistr\u00e9e", 1500, NPosition.BOTTOM_RIGHT);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void updateBorne() {
        try {
            this.currentBorne.setAddress_ip(this.terminal_ip_field.getText().trim());
            this.mBorneService.setAddress(this.currentBorne);
            this.repaintBornes();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Borne enregistr\u00e9", 1500, NPosition.BOTTOM_RIGHT);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    private void deleteBorne() {
        if (this.currentBorne == null || !this.USER_IS_SUPER_ADMIN) {
            return;
        }
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Vous voulez vraiment supprimer cette borne ?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
        alert.showAndWait();
        if (alert.getResult() == ButtonType.YES) {
            try {
                this.delete_terminal_label.setText("Suppression...");
                this.mBorneService.deleteBorne(this.currentBorne);
                this.togglers_pane.setVisible(false);
                this.togglers_pane.setManaged(false);
                this.tags_pane.setVisible(false);
                this.tags_pane.setManaged(false);
                this.bornes.removeIf(b -> b.getId().equals(this.currentBorne.getId()));
                this.currentBorne = null;
                this.loadInfoPaneContent();
                this.repaintBornes();
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Borne supprim\u00e9e", 1500, NPosition.BOTTOM_RIGHT);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
            }
            finally {
                this.changeTextButton("delete");
            }
        }
    }

    private void changeTextButton(String typeSynchro) {
        Platform.runLater(() -> {
            switch (typeSynchro) {
                case "items": {
                    this.sync_products_label.setStyle(this.getSynchLabelStyle("black"));
                    this.sync_products_label.setText("Mettre \u00e0 jour les produits");
                    break;
                }
                case "images": {
                    this.sync_images_label.setStyle(this.getSynchLabelStyle("black"));
                    this.sync_images_label.setText("Mettre \u00e0 jour les images");
                    break;
                }
                case "global": {
                    this.sync_label.setStyle(this.getSynchLabelStyle("black"));
                    this.sync_label.setText("Mettre \u00e0 jour");
                    break;
                }
                case "relaunch": {
                    this.relaunch_label.setText("Relancer le logiciel");
                    break;
                }
                case "restart": {
                    this.restart_label.setText("Red\u00e9marrer l'\u00e9quipement");
                    break;
                }
                case "shutdown": {
                    this.shutdown_label.setText("Eteindre l'\u00e9quipement");
                    break;
                }
                case "cashlogy": {
                    this.cashlogy_label.setText("Acc\u00e9der au BackOffice de Cashlogy");
                    break;
                }
                case "delete": {
                    this.delete_terminal_label.setText("Supprimer");
                }
            }
        });
    }

    public void synchroItems() {
        this.synchronize("items");
    }

    public void synchroImages() {
        this.synchronize("images");
    }

    public void synchroGlobal() {
        this.synchronize("global");
    }

    public void synchronize(final String typeSynchro) {
        if (this.currentBorne == null || this.getSynchroType() != null) {
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String name = BornesControllerNew.this.currentBorne.getName_borne();
                String signature = BornesControllerNew.this.currentBorne.getId().toString().concat(":").concat(typeSynchro);
                BornesControllerNew.this.synchroJobs.add(signature);
                try {
                    if (typeSynchro != null) {
                        String url_base = BornesControllerNew.this.getSynchUrl(typeSynchro);
                        System.out.println("+++++++++++++ url_base : " + url_base);
                        if (!url_base.isEmpty()) {
                            URL url = new URL(url_base);
                            JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                            JSONObject data = new JSONObject(tokener);
                            String message = data.getString("ERROR");
                            if (message.equals("OK")) {
                                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Synchronisation r\u00e9ussie pour " + name, 1500, NPosition.BOTTOM_RIGHT);
                            } else {
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu sur " + name, 1500, NPosition.BOTTOM_RIGHT);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu sur " + name, 1500, NPosition.BOTTOM_RIGHT);
                }
                finally {
                    BornesControllerNew.this.synchroJobs.remove(signature);
                    BornesControllerNew.this.changeTextButton(typeSynchro);
                }
            }
        }).start();
    }

    public void reload() {
        try {
            this.USER_IS_SUPER_ADMIN = this.app.getAppUserView().getUser() != null && this.app.getAppUserView().getUser().getRole().equals("0");
            boolean bl = this.USER_HAS_ACCES_TO_BACK_OFFICE = this.app.getAppUserView().getUser() != null && AppLocal.dlSystem.getPermissions(this.app.getAppUserView().getUser().getId()).contains("BackOffice Cashlogy");
            if (this.info_pane.isVisible()) {
                this.togglers_pane.setVisible(false);
                this.togglers_pane.setManaged(false);
                this.tags_pane.setVisible(false);
                this.tags_pane.setManaged(false);
                this.currentBorne = null;
                this.loadInfoPaneContent();
            }
            this.loadBornes();
            this.initGlobalToggler();
        }
        catch (BasicException ex) {
            Logger.getLogger(BornesControllerNew.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void relaunchSoftware() {
        if (this.currentBorne == null || this.getSynchroType() != null) {
            return;
        }
        System.out.println("++++++++++++relaunchSoftware");
        if (this.currentBorne != null && this.currentBorne.getAddress_ip() != null) {
            this.relaunch_label.setText("Relancement...");
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String urlRelaunch = "http://" + BornesControllerNew.this.currentBorne.getAddress_ip() + ":9097/newItems/relaunch";
                        URL url = new URL(urlRelaunch);
                        JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                        JSONObject data = new JSONObject(tokener);
                        String message = data.getString("STATUS");
                        if (message.equals("OK")) {
                            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Le logiciel de la borne a \u00e9t\u00e9 relanc\u00e9 avec succ\u00e8s sur " + BornesControllerNew.this.currentBorne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                        } else {
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "\u00c9chec du relancement du logiciel sur  " + BornesControllerNew.this.currentBorne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                        }
                    }
                    catch (Exception ex) {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "\u00c9chec du relancement du logiciel sur  " + BornesControllerNew.this.currentBorne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                    finally {
                        BornesControllerNew.this.changeTextButton("relaunch");
                    }
                }
            }).start();
        }
    }

    public void shutdownTerminal(final boolean restart) {
        if (this.currentBorne == null || this.getSynchroType() != null) {
            return;
        }
        System.out.println("++++++++++++ shutdownTerminal, restart : " + restart);
        if (this.currentBorne != null && this.currentBorne.getAddress_ip() != null) {
            if (restart) {
                this.restart_label.setText("Red\u00e9marrage...");
            } else {
                this.shutdown_label.setText("Extinction...");
            }
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String urlRelaunch = "http://" + BornesControllerNew.this.currentBorne.getAddress_ip() + (restart ? ":9097/newItems/restartTerminal" : ":9097/newItems/shutdownTerminal");
                        URL url = new URL(urlRelaunch);
                        JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                        JSONObject data = new JSONObject(tokener);
                        String message = data.getString("error");
                        if (message.equalsIgnoreCase("OK")) {
                            String operation = restart ? "red\u00e9marr\u00e9e" : "\u00e9teinte";
                            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La borne " + BornesControllerNew.this.currentBorne.getName_borne() + " a \u00e9t\u00e9 " + operation, 1500, NPosition.BOTTOM_RIGHT);
                        } else {
                            String operation = restart ? "du red\u00e9marrage" : "de l'extinction";
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "\u00c9chec " + operation + " de  " + BornesControllerNew.this.currentBorne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                        }
                        BornesControllerNew.this.changeTextButton(restart ? "restart" : "shutdown");
                    }
                    catch (Exception ex) {
                        try {
                            String operation = restart ? "du red\u00e9marrage" : "de l'extinction";
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "\u00c9chec " + operation + " de  " + BornesControllerNew.this.currentBorne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                            LogToFile.log("severe", ex.getMessage(), ex);
                            BornesControllerNew.this.changeTextButton(restart ? "restart" : "shutdown");
                        }
                        catch (Throwable throwable) {
                            BornesControllerNew.this.changeTextButton(restart ? "restart" : "shutdown");
                            throw throwable;
                        }
                    }
                }
            }).start();
        }
    }

    private void insertIntoMainPane() {
        this.main_pane.setAlignment(Pos.TOP_CENTER);
        double height = 200.0;
        double width = 160.0;
        int spacing = 20;
        double maxWidth = AppVarUtils.getScreenDimension().getWidth() / 2.0 - 30.0;
        int nbBornesByRow = (int)(maxWidth / width);
        double recomputedSize = (double)((nbBornesByRow - 1) * spacing) + width * (double)nbBornesByRow;
        if (recomputedSize > maxWidth) {
            --nbBornesByRow;
        }
        int nbRows = (int)Math.ceil((double)this.bornes.size() / (double)nbBornesByRow);
        for (int i = 1; i <= nbRows; ++i) {
            HBox hb = new HBox();
            hb.setSpacing((double)spacing);
            hb.setAlignment(Pos.CENTER);
            int rangeStart = nbBornesByRow * (i - 1);
            int rangeEnd = nbBornesByRow * i;
            int maxEnd = Math.min(this.bornes.size(), rangeEnd);
            for (int j = rangeStart; j < maxEnd; ++j) {
                hb.getChildren().add((Object)this.getBornePreview(this.bornes.get(j), height, width));
            }
            this.list_pane.getChildren().add((Object)hb);
        }
    }

    private StackPane getBornePreview(BorneInfo bi, double height, double width) {
        Image image;
        boolean isCurrent;
        StackPane preview = new StackPane();
        double blanksHeight = height * 0.05;
        DropShadow shadow = new DropShadow();
        shadow.setRadius(5.0);
        shadow.setOffsetX(3.0);
        shadow.setOffsetY(3.0);
        shadow.setColor(Color.rgb((int)50, (int)50, (int)50, (double)0.4));
        String nameTextFill = "white";
        String backgroundColor = "#FB5B4D";
        String foregroundColor = "white";
        String foregroundTextFill = "black";
        String imagePrefix = "/images/black-terminal";
        boolean bl = isCurrent = this.currentBorne != null && bi.getId().equals(this.currentBorne.getId());
        if (isCurrent) {
            nameTextFill = "black";
            backgroundColor = "white";
            foregroundColor = "#FB5B4D";
            foregroundTextFill = "white";
            imagePrefix = "/images/white-terminal";
        }
        VBox background = new VBox();
        background.setMinWidth(width * 0.8);
        background.setMaxWidth(width * 0.8);
        background.setMinHeight(height);
        background.setMaxHeight(height);
        background.setStyle("-fx-border-radius: 15px; -fx-background-radius: 15px; -fx-background-color: " + backgroundColor + ";");
        background.setEffect((Effect)shadow);
        preview.getChildren().add((Object)background);
        VBox foreground = new VBox();
        foreground.setStyle("-fx-background-color: transparent;");
        foreground.setMinWidth(width);
        foreground.setMaxWidth(width);
        foreground.setMinHeight(height);
        foreground.setMaxHeight(height);
        foreground.setAlignment(Pos.CENTER);
        VBox innerForeground = new VBox();
        innerForeground.setMinWidth(width);
        innerForeground.setMaxWidth(width);
        innerForeground.setMinHeight(height * 0.6);
        innerForeground.setMaxHeight(height * 0.6);
        innerForeground.setStyle("-fx-padding: 20px; -fx-border-radius: 15px; -fx-background-radius: 15px; -fx-background-color: " + foregroundColor + ";");
        innerForeground.setAlignment(Pos.CENTER);
        innerForeground.setEffect((Effect)shadow);
        String imageSuffix = "-without-tpe.png";
        if (bi.isPayment_enabled()) {
            imageSuffix = "-with-tpe.png";
        }
        if ((image = this.getImage(imagePrefix.concat(imageSuffix), 150.0, 55.0)) != null) {
            ImageView view = new ImageView(image);
            innerForeground.getChildren().add((Object)view);
            Pane blank = new Pane();
            blank.setMinHeight(blanksHeight);
            blank.setMaxHeight(blanksHeight);
            innerForeground.getChildren().add((Object)blank);
        }
        Label ip = new Label(bi.getAddress_ip());
        ip.setAlignment(Pos.CENTER);
        ip.setStyle("-fx-font-size: 12pt; -fx-font-weight: normal; -fx-background-color: transparent; -fx-text-fill: " + foregroundTextFill + ";");
        innerForeground.getChildren().add((Object)ip);
        Pane blank1 = new Pane();
        Pane blank2 = new Pane();
        blank1.setMinHeight(blanksHeight);
        blank1.setMaxHeight(blanksHeight);
        blank2.setMinHeight(blanksHeight);
        blank2.setMaxHeight(blanksHeight);
        Label name = new Label(bi.getName_borne().toUpperCase());
        name.setAlignment(Pos.CENTER);
        name.setStyle("-fx-font-weight: bold; -fx-background-color: transparent; -fx-font-size: 12pt; -fx-text-fill: " + nameTextFill + ";");
        foreground.getChildren().add((Object)blank1);
        foreground.getChildren().add((Object)innerForeground);
        foreground.getChildren().add((Object)blank2);
        foreground.getChildren().add((Object)name);
        preview.getChildren().add((Object)foreground);
        preview.setOnMouseClicked(e -> {
            if (this.currentBorne == null || !this.currentBorne.getId().equals(bi.getId())) {
                this.currentBorne = bi;
                this.loadInfoPaneContent();
            } else {
                this.currentBorne = null;
                this.loadInfoPaneContent();
            }
        });
        return preview;
    }

    private Image getImage(String path, double height, double width) {
        try {
            return new Image(this.getClass().getResource(path).toURI().toString(), height, width, true, false);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return null;
        }
    }

    private void loadInfoPaneContent() {
        this.repaintBornes();
        if (this.currentBorne == null) {
            this.ip_label.setText("");
            this.name_label.setText("");
            this.togglers_pane.setVisible(false);
            this.togglers_pane.setManaged(false);
        } else {
            this.setInfoPanePreview();
        }
    }

    private void setInfoPanePreview() {
        if (this.USER_IS_SUPER_ADMIN) {
            this.delete_terminal_btn.setVisible(true);
            this.delete_terminal_btn.setManaged(true);
            this.update_trigger_box.setVisible(true);
            this.update_trigger_box.setManaged(true);
        } else if (this.delete_terminal_btn.isVisible()) {
            this.delete_terminal_btn.setVisible(false);
            this.delete_terminal_btn.setManaged(false);
            this.header_box.setAlignment(Pos.CENTER_LEFT);
            this.update_trigger_box.setVisible(false);
            this.update_trigger_box.setManaged(false);
        }
        System.out.println("*currentBorne.getName_borne() :" + this.currentBorne.getName_borne());
        System.out.println("*USER_HAS_ACCES_TO_BACK_OFFICE :" + this.USER_HAS_ACCES_TO_BACK_OFFICE);
        if ((this.currentBorne.getName_borne().startsWith("SelfCheckout") || this.currentBorne.getName_borne().startsWith("Borne")) && this.USER_HAS_ACCES_TO_BACK_OFFICE) {
            this.cashlogy_btn.setVisible(true);
            this.cashlogy_btn.setManaged(true);
        } else {
            this.cashlogy_btn.setVisible(false);
            this.cashlogy_btn.setManaged(false);
        }
        if (this.currentBorne.isEquipment_disabled()) {
            this.disable_terminal_label.setText("Activer");
        } else {
            this.disable_terminal_label.setText("D\u00e9sactiver");
        }
        this.resetSynchroTextButton();
        String synchroType = this.getSynchroType();
        if (synchroType != null) {
            this.getSynchUrl(synchroType);
        }
        this.name_label.setText(this.currentBorne.getName_borne());
        this.ip_label.setText(this.currentBorne.getAddress_ip());
        this.togglers_pane.setVisible(true);
        this.togglers_pane.setManaged(true);
        this.setTogglers();
    }

    private String getSynchroType() {
        String prefix = this.currentBorne.getId().toString().concat(":");
        String match = this.synchroJobs.stream().filter(type -> type.startsWith(prefix)).findFirst().orElse(null);
        if (match == null) {
            return null;
        }
        return match.replace(prefix, "");
    }

    private void resetSynchroTextButton() {
        this.changeTextButton("global");
        this.changeTextButton("items");
        this.changeTextButton("images");
    }

    private void setTogglers() {
        if (this.currentBorne == null) {
            return;
        }
        this.setTogglerStatus(this.payment_toggler, this.getTogglerPosition(this.currentBorne.isPayment_enabled()));
        this.setTogglerStatus(this.onseat_toggler, this.getTogglerPosition(this.currentBorne.isOnseatEnabled()));
        this.setTogglerStatus(this.maintenance_toggler, this.getTogglerPosition(this.currentBorne.isInMaintenance()));
    }

    public Pos getTogglerPosition(boolean checked) {
        return checked ? Pos.CENTER_RIGHT : Pos.CENTER_LEFT;
    }

    public void toggleButton(HBox toggler) {
        if (this.currentBorne == null && !toggler.getId().equals(this.global_onseat_toggler.getId())) {
            return;
        }
        if (toggler.getAlignment() == Pos.CENTER_LEFT) {
            this.setTogglerStatus(toggler, Pos.CENTER_RIGHT);
            this.setSettings(toggler.getId());
        } else if (toggler.getAlignment() == Pos.CENTER_RIGHT) {
            this.setTogglerStatus(toggler, Pos.CENTER_LEFT);
            this.setSettings(toggler.getId());
        }
    }

    public void setTogglerStatus(HBox toggler, Pos position) {
        toggler.setAlignment(position);
        if (position == Pos.CENTER_LEFT) {
            toggler.setStyle("-fx-border-color: transparent; -fx-padding: 0 3 0 3; -fx-background-radius: 50px; -fx-border-radius: 50px; -fx-background-color: lightgray;");
        } else if (position == Pos.CENTER_RIGHT) {
            toggler.setStyle("-fx-border-color: transparent; -fx-padding: 0 3 0 3; -fx-background-radius: 50px; -fx-border-radius: 50px; -fx-background-color: #FB5B4D;");
        }
    }

    public void setSettings(String togglerId) {
        if (togglerId.equals(this.onseat_toggler.getId())) {
            this.changeOnSeatStatus();
        }
        if (togglerId.equals(this.payment_toggler.getId())) {
            this.changePaymentStatus();
        }
        if (togglerId.equals(this.maintenance_toggler.getId())) {
            this.changeMaintenanceStatus();
        }
        if (togglerId.equals(this.global_onseat_toggler.getId())) {
            this.changeOnSeatStatusForAll();
        }
    }

    private void changeMaintenanceStatus() {
        Platform.runLater(() -> this.showPendingSpinner());
        new Thread(){

            @Override
            public void run() {
                boolean isInMaintenance = !BornesControllerNew.this.currentBorne.isInMaintenance();
                try {
                    BornesControllerNew.this.currentBorne.setInMaintenance(isInMaintenance);
                    BornesControllerNew.this.mBorneService.setInMaintenance(BornesControllerNew.this.currentBorne);
                    Platform.runLater(() -> {
                        BornesControllerNew.this.hidePendingSpinner();
                        BornesControllerNew.this.repaintBornes();
                    });
                }
                catch (Exception ex) {
                    BornesControllerNew.this.currentBorne.setInMaintenance(!isInMaintenance);
                    Platform.runLater(() -> {
                        BornesControllerNew.this.hidePendingSpinner();
                        BornesControllerNew.this.setTogglerStatus(BornesControllerNew.this.maintenance_toggler, BornesControllerNew.this.currentBorne.isInMaintenance() ? Pos.CENTER_RIGHT : Pos.CENTER_LEFT);
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue", 1500, NPosition.BOTTOM_RIGHT);
                    });
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }.start();
    }

    private void changeOnSeatStatusForAll() {
        Platform.runLater(() -> this.showPendingSpinner());
        new Thread(){

            @Override
            public void run() {
                boolean onseatEnabled = !BornesControllerNew.this.isOnseatEnabledForAll();
                boolean error = false;
                for (BorneInfo bi : BornesControllerNew.this.bornes) {
                    boolean wasEnabled = bi.isOnseatEnabled();
                    try {
                        bi.setOnseatEnabled(onseatEnabled);
                        BornesControllerNew.this.mBorneService.setOnseatEnabled(bi);
                    }
                    catch (Exception ex) {
                        error = true;
                        bi.setOnseatEnabled(wasEnabled);
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est survenue pour " + bi.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
                Platform.runLater(() -> {
                    BornesControllerNew.this.hidePendingSpinner();
                    if (BornesControllerNew.this.isOnseatEnabledOnlyForSome()) {
                        BornesControllerNew.this.diff_onseat_status.setManaged(true);
                        BornesControllerNew.this.diff_onseat_status.setVisible(true);
                    } else {
                        BornesControllerNew.this.diff_onseat_status.setVisible(false);
                        BornesControllerNew.this.diff_onseat_status.setManaged(false);
                    }
                    if (BornesControllerNew.this.currentBorne != null) {
                        BornesControllerNew.this.setInfoPanePreview();
                    }
                });
                if (!error) {
                    String status = onseatEnabled ? "activ\u00e9e" : "d\u00e9sactiv\u00e9e";
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Sur Place a \u00e9t\u00e9 " + status + " sur toutes les bornes.", 1500, NPosition.BOTTOM_RIGHT);
                }
            }
        }.start();
    }

    private boolean isOnseatEnabledForAll() {
        if (this.bornes.isEmpty()) {
            return false;
        }
        return this.bornes.stream().allMatch(BorneInfo::isOnseatEnabled);
    }

    private boolean isOnseatEnabledOnlyForSome() {
        if (this.bornes.isEmpty()) {
            return false;
        }
        boolean enabled = this.bornes.stream().anyMatch(BorneInfo::isOnseatEnabled);
        boolean notEnabled = this.bornes.stream().anyMatch(b -> !b.isOnseatEnabled());
        return enabled && notEnabled;
    }

    private void changeOnSeatStatus() {
        Platform.runLater(() -> this.showPendingSpinner());
        new Thread(){

            @Override
            public void run() {
                boolean onseatEnabled = !BornesControllerNew.this.currentBorne.isOnseatEnabled();
                try {
                    BornesControllerNew.this.currentBorne.setOnseatEnabled(onseatEnabled);
                    BornesControllerNew.this.mBorneService.setOnseatEnabled(BornesControllerNew.this.currentBorne);
                    Platform.runLater(() -> {
                        BornesControllerNew.this.hidePendingSpinner();
                        BornesControllerNew.this.repaintBornes();
                    });
                }
                catch (Exception ex) {
                    BornesControllerNew.this.currentBorne.setOnseatEnabled(!onseatEnabled);
                    Platform.runLater(() -> {
                        BornesControllerNew.this.hidePendingSpinner();
                        BornesControllerNew.this.setTogglerStatus(BornesControllerNew.this.onseat_toggler, BornesControllerNew.this.currentBorne.isOnseatEnabled() ? Pos.CENTER_RIGHT : Pos.CENTER_LEFT);
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue", 1500, NPosition.BOTTOM_RIGHT);
                    });
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                finally {
                    Platform.runLater(() -> {
                        if (BornesControllerNew.this.isOnseatEnabledForAll()) {
                            BornesControllerNew.this.setTogglerStatus(BornesControllerNew.this.global_onseat_toggler, BornesControllerNew.this.getTogglerPosition(true));
                        } else {
                            BornesControllerNew.this.setTogglerStatus(BornesControllerNew.this.global_onseat_toggler, BornesControllerNew.this.getTogglerPosition(false));
                        }
                        if (BornesControllerNew.this.isOnseatEnabledOnlyForSome()) {
                            BornesControllerNew.this.diff_onseat_status.setManaged(true);
                            BornesControllerNew.this.diff_onseat_status.setVisible(true);
                        } else {
                            BornesControllerNew.this.diff_onseat_status.setVisible(false);
                            BornesControllerNew.this.diff_onseat_status.setManaged(false);
                        }
                    });
                }
            }
        }.start();
    }

    private void changePaymentStatus() {
        Platform.runLater(() -> this.showPendingSpinner());
        new Thread(){

            @Override
            public void run() {
                boolean paymentEnabled = !BornesControllerNew.this.currentBorne.isPayment_enabled();
                try {
                    BornesControllerNew.this.currentBorne.setPayment_enabled(paymentEnabled);
                    BornesControllerNew.this.mBorneService.setPaymentEnabled(BornesControllerNew.this.currentBorne);
                    Platform.runLater(() -> {
                        BornesControllerNew.this.hidePendingSpinner();
                        BornesControllerNew.this.repaintBornes();
                    });
                }
                catch (Exception ex) {
                    BornesControllerNew.this.currentBorne.setPayment_enabled(!paymentEnabled);
                    Platform.runLater(() -> {
                        BornesControllerNew.this.hidePendingSpinner();
                        BornesControllerNew.this.setTogglerStatus(BornesControllerNew.this.payment_toggler, BornesControllerNew.this.currentBorne.isPayment_enabled() ? Pos.CENTER_RIGHT : Pos.CENTER_LEFT);
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue", 1500, NPosition.BOTTOM_RIGHT);
                    });
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            }
        }.start();
    }

    private void showPendingSpinner() {
        this.pending_label.setManaged(true);
        this.pending_label.setVisible(true);
        this.rotate = new RotateTransition();
        this.rotate.setNode((Node)this.pending_imgv);
        this.rotate.setByAngle(360.0);
        this.rotate.setCycleCount(-1);
        this.rotate.setDuration(Duration.seconds((double)2.0));
        this.rotate.setInterpolator(Interpolator.LINEAR);
        this.rotate.play();
    }

    private void hidePendingSpinner() {
        this.rotate.stop();
        this.pending_label.setVisible(false);
        this.pending_label.setManaged(false);
    }

    private void cancelUpdate() {
        this.update_form_box.setVisible(false);
        this.update_form_box.setManaged(false);
        this.update_trigger_box.setVisible(true);
        this.update_trigger_box.setManaged(true);
    }

    private void triggerUpdate() {
        if (this.currentBorne == null) {
            return;
        }
        this.terminal_ip_field.setText(this.currentBorne.getAddress_ip());
        this.update_trigger_box.setVisible(false);
        this.update_trigger_box.setManaged(false);
        this.update_form_box.setVisible(true);
        this.update_form_box.setManaged(true);
    }

    private void persistUpdateTerminal() {
        if (this.terminal_ip_field.getText().trim().isBlank()) {
            return;
        }
        this.updateBorne();
        this.cancelUpdate();
        this.ip_label.setText(this.currentBorne.getAddress_ip());
        this.loadInfoPaneContent();
    }

    private void hideNewTerminal() {
        this.new_terminal_form.setVisible(false);
        this.new_terminal_form.setManaged(false);
        this.add_terminal_btn.setVisible(true);
        this.add_terminal_btn.setManaged(true);
    }

    private void addNewTerminal() {
        this.new_terminal_ip_field.setText("");
        this.new_terminal_form.setVisible(true);
        this.new_terminal_form.setManaged(true);
        this.add_terminal_btn.setVisible(false);
        this.add_terminal_btn.setManaged(false);
    }

    private void saveTerminal() {
        String ip = this.new_terminal_ip_field.getText().trim();
        if (!ip.isBlank()) {
            this.hideNewTerminal();
            BorneInfo borne = new BorneInfo();
            borne.setAddress_ip(this.new_terminal_ip_field.getText().trim());
            String selectedType = (String)this.type_combo.getSelectionModel().getSelectedItem();
            String nameBorne = this.generateNameBorne(selectedType);
            borne.setName_borne(nameBorne);
            this.name_label.setText(borne.getName_borne());
            this.ip_label.setText(borne.getAddress_ip());
            this.addBorne(borne);
        }
    }

    private String generateNameBorne(String type) {
        int maxNumber = 0;
        for (BorneInfo borne : this.bornes) {
            String[] parts;
            String nameBorne = borne.getName_borne();
            if (!nameBorne.startsWith(type) || (parts = nameBorne.split(" ")).length != 2) continue;
            try {
                int number = Integer.parseInt(parts[1]);
                if (number <= maxNumber) continue;
                maxNumber = number;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return type + " " + (maxNumber + 1);
    }
}

