/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.components.LazyModal;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.dao.DataLogicSystem;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.BorneInfo;
import fr.protactile.procaisse.services.BorneService;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class BornesController {
    @FXML
    GridPane pane_main;
    @FXML
    GridPane pane_preview_borne;
    @FXML
    GridPane list_bornes;
    @FXML
    GridPane pane_next_borne;
    @FXML
    Button btn_borne_previous;
    @FXML
    Button btn_borne_next;
    @FXML
    Button button_items;
    @FXML
    Button button_images;
    @FXML
    Button button_global;
    @FXML
    GridPane pane_synchro_global;
    private int page_borne;
    private GridPane[] pane_bornes;
    private int number_page_borne;
    private int number_line;
    private int number_column;
    private AppView app;
    private DataLogicSystem dlSystem;
    private List<BorneInfo> bornes;
    private List<GridPane> listPaneBornes;
    int row = -1;
    private static double widthPane = 700.0;
    private double height_paneBorne;
    private BorneService mBorneService;
    private boolean USER_IS_SUPER_ADMIN;
    private boolean USER_HAS_ACCES_TO_BACK_OFFICE;
    private double width_pane;
    private boolean changeStatusPayment = false;
    private LazyModal managerSettingsLazyModal = null;
    private EventHiddenModal managerSettingsActionEvent = null;
    private Scene scene;
    private EventHandler mEventHandlerSynchroItems = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borne = (BorneInfo)mButtonSource.getProperties().get((Object)"borne");
                BornesController.this.synchronize(borne, mButtonSource, "items");
            }
        }
    };
    private EventHandler mEventHandlerSynchroImages = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borne = (BorneInfo)mButtonSource.getProperties().get((Object)"borne");
                BornesController.this.synchronize(borne, mButtonSource, "images");
            }
        }
    };
    private EventHandler mEventHandlerSynchroGlobal = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borne = (BorneInfo)mButtonSource.getProperties().get((Object)"borne");
                BornesController.this.synchronize(borne, mButtonSource, "global");
            }
        }
    };
    private EventHandler mEventHandlerRelaunch = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            System.out.println("borne : " + mButtonSource.getProperties().get((Object)"borne"));
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borne = (BorneInfo)mButtonSource.getProperties().get((Object)"borne");
                BornesController.this.relaunchSoftware(borne, mButtonSource);
            }
        }
    };
    private final EventHandler mEventHandlerShutdown = event -> {
        Button buttonSource = (Button)event.getSource();
        if (buttonSource != null && buttonSource.getProperties().get((Object)"borne") != null) {
            BorneInfo borne = (BorneInfo)buttonSource.getProperties().get((Object)"borne");
            this.shutdownTerminal(borne, buttonSource);
        }
    };
    private EventHandler mEventHandlerSynchroParams = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borne = (BorneInfo)mButtonSource.getProperties().get((Object)"borne");
                BornesController.this.synchronize(borne, mButtonSource, "params");
            }
        }
    };
    private EventHandler mEventHandlerLodBackOfficeCashlogy = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borne = (BorneInfo)mButtonSource.getProperties().get((Object)"borne");
                BornesController.this.loadCashlogy(borne, mButtonSource);
            }
        }
    };
    private EventHandler mEventHandlerBlockBorne = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borneInfo = (BorneInfo)mButtonSource.getProperties().get((Object)"borne");
            }
        }
    };
    private EventHandler mEventHandlerChangePaymentStatus = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borne = (BorneInfo)mButtonSource.getProperties().get((Object)"borne");
                boolean paymentEnabled = !borne.isPayment_enabled();
                try {
                    borne.setPayment_enabled(paymentEnabled);
                    BornesController.this.mBorneService.setPaymentEnabled(borne);
                    BornesController.this.loadBornes();
                }
                catch (Exception ex) {
                    borne.setPayment_enabled(!paymentEnabled);
                    LogToFile.log("severe", ex.getMessage(), ex);
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
                }
            }
        }
    };
    private EventHandler mEventHandlerDeleteBorne = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borne = (BorneInfo)mButtonSource.getProperties().get((Object)"borne");
                BornesController.this.deleteBorne(borne);
            }
        }
    };
    private EventHandler mEventHandlerChangeUpdateIP = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borne = (BorneInfo)mButtonSource.getProperties().get((Object)"borne");
                TextField textAddress = (TextField)mButtonSource.getProperties().get((Object)"address");
                borne.setAddress_ip(textAddress.getText());
                BornesController.this.updateBorne(borne);
            }
        }
    };
    private EventHandler mEventHandlerDisable = new EventHandler<ActionEvent>(){

        public void handle(ActionEvent event) {
            Button mButtonSource = (Button)event.getSource();
            System.out.println("borne : " + mButtonSource.getProperties().get((Object)"borne"));
            if (mButtonSource != null && mButtonSource.getProperties().get((Object)"borne") != null) {
                BorneInfo borne;
                borne.setEquipment_disabled(!(borne = (BorneInfo)mButtonSource.getProperties().get((Object)"borne")).isEquipment_disabled());
                BornesController.this.mBorneService.setDisableEquipment(borne);
                if (borne.isEquipment_disabled()) {
                    mButtonSource.setText("Activer");
                } else {
                    mButtonSource.setText("D\u00e9sactiver");
                }
            }
        }
    };
    private final EventHandler changeOnseatStatusHandler = event -> {
        final Button buttonSource = (Button)event.getSource();
        if (buttonSource != null && buttonSource.getProperties().get((Object)"borne") != null) {
            final String previous = buttonSource.getText();
            buttonSource.setText("...");
            new Thread(){

                @Override
                public void run() {
                    BorneInfo borne = (BorneInfo)buttonSource.getProperties().get((Object)"borne");
                    boolean onseatEnabled = !borne.isOnseatEnabled();
                    try {
                        borne.setOnseatEnabled(onseatEnabled);
                        BornesController.this.mBorneService.setOnseatEnabled(borne);
                        Platform.runLater(() -> BornesController.this.loadBornes());
                    }
                    catch (Exception ex) {
                        borne.setOnseatEnabled(!onseatEnabled);
                        Platform.runLater(() -> {
                            buttonSource.setText(previous);
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue", 1500, NPosition.BOTTOM_RIGHT);
                        });
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }.start();
        }
    };
    private final EventHandler changeMaintenanceStatusHandler = event -> {
        final Button buttonSource = (Button)event.getSource();
        if (buttonSource != null && buttonSource.getProperties().get((Object)"borne") != null) {
            final String previous = buttonSource.getText();
            buttonSource.setText("...");
            new Thread(){

                @Override
                public void run() {
                    BorneInfo borne = (BorneInfo)buttonSource.getProperties().get((Object)"borne");
                    boolean isInMaintenance = !borne.isInMaintenance();
                    try {
                        borne.setInMaintenance(isInMaintenance);
                        BornesController.this.mBorneService.setInMaintenance(borne);
                        Platform.runLater(() -> BornesController.this.loadBornes());
                    }
                    catch (Exception ex) {
                        borne.setInMaintenance(!isInMaintenance);
                        Platform.runLater(() -> {
                            buttonSource.setText(previous);
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenue", 1500, NPosition.BOTTOM_RIGHT);
                        });
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                }
            }.start();
        }
    };

    public void init(AppView app, Scene scene) throws BasicException, URISyntaxException {
        this.app = app;
        this.scene = scene;
        this.dlSystem = (DataLogicSystem)this.app.getBean("com.openbravo.dao.DataLogicSystem");
        this.mBorneService = BorneService.getInstance();
        this.bornes = new ArrayList<BorneInfo>();
        this.listPaneBornes = new ArrayList<GridPane>();
        this.number_line = 2;
        this.number_column = 3;
        this.height_paneBorne = (AppVarUtils.getScreenDimension().getHeight() - 100.0) * 0.72 / (double)this.number_line;
        Image imageNext = new Image(this.getClass().getResource("/com/openbravo/images/btn_next.png").toURI().toString(), 40.0, 30.0, false, false);
        Image imagebPrevious = new Image(this.getClass().getResource("/com/openbravo/images/btn_previous.png").toURI().toString(), 40.0, 30.0, false, false);
        this.btn_borne_previous.setGraphic((Node)new ImageView(imagebPrevious));
        this.btn_borne_next.setGraphic((Node)new ImageView(imageNext));
        this.mBorneService.checkNamesBornes();
    }

    private double heightPane() {
        return (AppVarUtils.getScreenDimension().getHeight() - 55.0) * 0.8 * 0.9 * 0.5;
    }

    public void loadBornes() {
        this.loadBornes(false);
    }

    private void loadBornes(boolean afterSync) {
        this.listPaneBornes.clear();
        this.bornes = this.mBorneService.getBornes();
        if (this.bornes != null) {
            for (BorneInfo borne : this.bornes) {
                GridPane paneBorne = new GridPane();
                paneBorne.setAlignment(Pos.CENTER);
                paneBorne.setVgap(5.0);
                paneBorne.setHgap(5.0);
                paneBorne.getStyleClass().add((Object)"bg_gray_dfe8e8");
                paneBorne.setPrefWidth(this.width_pane);
                paneBorne.setPrefHeight(this.heightPane());
                Label nameBorne = new Label(borne.getName_borne());
                nameBorne.setAlignment(Pos.CENTER);
                TextField textAdress = new TextField();
                textAdress.getProperties().put((Object)"vkType", (Object)1);
                textAdress.setAlignment(Pos.CENTER);
                textAdress.setText(borne.getAddress_ip());
                Button btnSynch = new Button("Mettre \u00e0 jour");
                Button btnSynchImages = new Button("Mettre \u00e0 jour les images");
                Button btnSynchItems = new Button("Mettre \u00e0 jour les produits");
                Button btnRelancer = new Button("Relancer l'\u00e9quipement");
                Button btnShutdown = new Button("Eteindre l'\u00e9quipement");
                Button btnDisbale = new Button("D\u00e9sactiver la borne");
                Button btnPaymentBorne = new Button();
                if (borne.isPayment_enabled()) {
                    btnPaymentBorne.setText("D\u00e9sactiver paiement");
                } else {
                    btnPaymentBorne.setText("Activer paiement");
                }
                if (borne.isEquipment_disabled()) {
                    btnDisbale.setText("Activer");
                } else {
                    btnDisbale.setText("D\u00e9sactiver");
                }
                Button onseatButton = new Button();
                if (borne.isOnseatEnabled()) {
                    onseatButton.setText("D\u00e9sactiver Sur Place");
                } else {
                    onseatButton.setText("Activer Sur Place");
                }
                Button maintenanceButton = new Button();
                if (borne.isInMaintenance()) {
                    maintenanceButton.setText("D\u00e9sactiver la Maintenance");
                } else {
                    maintenanceButton.setText("Mettre en Maintenance");
                }
                btnSynch.getProperties().put((Object)"borne", (Object)borne);
                btnSynchImages.getProperties().put((Object)"borne", (Object)borne);
                btnSynchItems.getProperties().put((Object)"borne", (Object)borne);
                btnPaymentBorne.getProperties().put((Object)"borne", (Object)borne);
                btnRelancer.getProperties().put((Object)"borne", (Object)borne);
                btnShutdown.getProperties().put((Object)"borne", (Object)borne);
                btnDisbale.getProperties().put((Object)"borne", (Object)borne);
                onseatButton.getProperties().put((Object)"borne", (Object)borne);
                maintenanceButton.getProperties().put((Object)"borne", (Object)borne);
                btnSynch.getStyleClass().add((Object)"bg-70c0c1");
                btnSynchImages.getStyleClass().add((Object)"bg-70c0c1");
                btnSynchItems.getStyleClass().add((Object)"bg-70c0c1");
                btnPaymentBorne.getStyleClass().add((Object)"bg-70c0c1");
                onseatButton.getStyleClass().add((Object)"bg-70c0c1");
                maintenanceButton.getStyleClass().add((Object)"bg-70c0c1");
                btnRelancer.getStyleClass().add((Object)"bg-70c0c1");
                btnShutdown.getStyleClass().add((Object)"bg-70c0c1");
                btnDisbale.getStyleClass().add((Object)"bg-70c0c1");
                btnPaymentBorne.setOnAction(this.mEventHandlerChangePaymentStatus);
                btnSynch.setOnAction(this.mEventHandlerSynchroGlobal);
                btnSynchImages.setOnAction(this.mEventHandlerSynchroImages);
                btnSynchItems.setOnAction(this.mEventHandlerSynchroItems);
                btnRelancer.setOnAction(this.mEventHandlerRelaunch);
                btnShutdown.setOnAction(this.mEventHandlerShutdown);
                btnDisbale.setOnAction(this.mEventHandlerDisable);
                onseatButton.setOnAction(this.changeOnseatStatusHandler);
                maintenanceButton.setOnAction(this.changeMaintenanceStatusHandler);
                paneBorne.add((Node)nameBorne, 0, 0);
                paneBorne.add((Node)textAdress, 0, 1);
                paneBorne.add((Node)btnSynch, 0, 2);
                paneBorne.add((Node)btnSynchItems, 0, 3);
                paneBorne.add((Node)btnSynchImages, 0, 4);
                paneBorne.add((Node)btnRelancer, 0, 5);
                paneBorne.add((Node)btnShutdown, 0, 6);
                paneBorne.add((Node)onseatButton, 0, 7);
                paneBorne.add((Node)maintenanceButton, 0, 8);
                if (this.USER_IS_SUPER_ADMIN) {
                    Button btnUpdateIP = new Button("Modifier Adresse");
                    Button btnDelete = new Button("Supprimer");
                    btnUpdateIP.getProperties().put((Object)"borne", (Object)borne);
                    btnDelete.getProperties().put((Object)"borne", (Object)borne);
                    btnUpdateIP.getProperties().put((Object)"address", (Object)textAdress);
                    btnUpdateIP.getStyleClass().add((Object)"bg-70c0c1");
                    btnDelete.getStyleClass().add((Object)"bg-70c0c1");
                    btnUpdateIP.setOnAction(this.mEventHandlerChangeUpdateIP);
                    btnDelete.setOnAction(this.mEventHandlerDeleteBorne);
                    nameBorne.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    nameBorne.setPrefHeight(paneBorne.getPrefHeight() * 0.16);
                    textAdress.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    textAdress.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    btnSynch.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnSynch.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    btnSynchImages.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnSynchImages.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    btnSynchItems.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnSynchItems.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    btnRelancer.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnRelancer.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    btnShutdown.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnShutdown.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    btnUpdateIP.setPrefWidth(paneBorne.getPrefWidth() * 0.4);
                    btnUpdateIP.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    btnPaymentBorne.setPrefWidth(paneBorne.getPrefWidth() * 0.4);
                    btnPaymentBorne.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    btnDelete.setPrefWidth(paneBorne.getPrefWidth() * 0.4);
                    btnDelete.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    btnDisbale.setPrefWidth(paneBorne.getPrefWidth() * 0.4);
                    btnDisbale.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    onseatButton.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    onseatButton.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    maintenanceButton.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    maintenanceButton.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    GridPane pane1 = new GridPane();
                    GridPane pane2 = new GridPane();
                    pane1.setVgap(1.0);
                    pane1.setHgap(1.0);
                    pane1.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    pane1.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    pane1.add((Node)btnDisbale, 0, 0);
                    pane1.add((Node)btnDelete, 1, 0);
                    pane2.setVgap(1.0);
                    pane2.setHgap(1.0);
                    pane2.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    pane2.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    pane2.add((Node)btnUpdateIP, 0, 0);
                    pane2.add((Node)btnPaymentBorne, 1, 0);
                    int row = 10;
                    paneBorne.add((Node)pane2, 0, row++);
                    paneBorne.add((Node)pane1, 0, row);
                } else {
                    nameBorne.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    nameBorne.setPrefHeight(paneBorne.getPrefHeight() * 0.16);
                    textAdress.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    textAdress.setPrefHeight(paneBorne.getPrefHeight() * 0.14);
                    btnSynch.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnSynch.setPrefHeight(paneBorne.getPrefHeight() * 0.14);
                    btnSynchImages.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnSynchImages.setPrefHeight(paneBorne.getPrefHeight() * 0.14);
                    btnSynchItems.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnSynchItems.setPrefHeight(paneBorne.getPrefHeight() * 0.14);
                    btnPaymentBorne.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnPaymentBorne.setPrefHeight(paneBorne.getPrefHeight() * 0.14);
                    btnRelancer.setPrefHeight(paneBorne.getPrefHeight() * 0.14);
                    btnRelancer.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnShutdown.setPrefHeight(paneBorne.getPrefHeight() * 0.14);
                    btnShutdown.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnDisbale.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnDisbale.setPrefHeight(paneBorne.getPrefHeight() * 0.14);
                    onseatButton.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    onseatButton.setPrefHeight(paneBorne.getPrefHeight() * 0.14);
                    maintenanceButton.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    maintenanceButton.setPrefHeight(paneBorne.getPrefHeight() * 0.14);
                    paneBorne.add((Node)btnDisbale, 0, 10);
                    paneBorne.add((Node)btnPaymentBorne, 0, 11);
                }
                if (this.USER_HAS_ACCES_TO_BACK_OFFICE) {
                    Button btnBackOffice = new Button("Acc\u00e9der au BackOffice de Cashlogy");
                    btnBackOffice.getProperties().put((Object)"borne", (Object)borne);
                    btnBackOffice.getStyleClass().add((Object)"bg-70c0c1");
                    btnBackOffice.setOnAction(this.mEventHandlerLodBackOfficeCashlogy);
                    btnBackOffice.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
                    btnBackOffice.setPrefHeight(paneBorne.getPrefHeight() * 0.12);
                    if (borne.getName_borne().startsWith("SelfCheckout") || borne.getName_borne().startsWith("Borne")) {
                        paneBorne.add((Node)btnBackOffice, 0, 12);
                    }
                }
                this.listPaneBornes.add(paneBorne);
            }
        }
        final GridPane paneBorne = new GridPane();
        paneBorne.setAlignment(Pos.CENTER);
        paneBorne.setVgap(5.0);
        paneBorne.setHgap(5.0);
        paneBorne.getStyleClass().add((Object)"bg-e6eded");
        paneBorne.setPrefWidth(AppVarUtils.getScreenDimension().getWidth() * 0.2);
        paneBorne.setPrefHeight(this.heightPane());
        final TextField textAdress = new TextField();
        Button btnAdd = new Button("Ajouter");
        final Button btnValid = new Button("Valider");
        textAdress.setAlignment(Pos.CENTER);
        textAdress.setPromptText("0.0.0.0");
        textAdress.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
        textAdress.setPrefHeight(paneBorne.getPrefHeight() * 0.15);
        final ComboBox McBoxTypes = new ComboBox();
        McBoxTypes.getItems().addAll((Object[])new String[]{"Caisse", "Borne", "Tablette", "SelfCheckout"});
        McBoxTypes.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
        McBoxTypes.setPrefHeight(paneBorne.getPrefHeight() * 0.15);
        McBoxTypes.setValue((Object)"Borne");
        btnValid.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
        btnValid.setPrefHeight(paneBorne.getPrefHeight() * 0.15);
        btnAdd.setPrefWidth(paneBorne.getPrefWidth() * 0.8);
        btnAdd.setPrefHeight(paneBorne.getPrefHeight() * 0.15);
        btnAdd.getStyleClass().add((Object)"bg-70c0c1");
        btnValid.getStyleClass().add((Object)"bg-70c0c1");
        btnAdd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                paneBorne.add((Node)textAdress, 0, 0);
                paneBorne.add((Node)McBoxTypes, 0, 1);
                paneBorne.add((Node)btnValid, 0, 2);
            }
        });
        btnValid.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                BorneInfo borne = new BorneInfo();
                borne.setAddress_ip(textAdress.getText());
                String selectedType = (String)McBoxTypes.getSelectionModel().getSelectedItem();
                String nameBorne = BornesController.this.generateNameBorne(selectedType);
                borne.setName_borne(nameBorne);
                BornesController.this.addBorne(borne);
            }
        });
        paneBorne.add((Node)btnAdd, 0, 0);
        this.listPaneBornes.add(paneBorne);
        this.showBornes(this.listPaneBornes);
        if (!afterSync) {
            CompletableFuture.runAsync(() -> this.requestBornesSettings());
        }
    }

    public void synchronize(final BorneInfo borne, final Button btnSynch, final String type_synchro) {
        if (borne != null && borne.getAddress_ip() != null) {
            btnSynch.setText("Synchronisation ...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        System.out.println("+++++++++++++ type_synchro : " + type_synchro);
                        if (type_synchro != null) {
                            Object url_base = "";
                            switch (type_synchro) {
                                case "images": {
                                    url_base = "http://" + borne.getAddress_ip() + ":9097/newItems/remoteSyncImages";
                                    break;
                                }
                                case "items": {
                                    url_base = "http://" + borne.getAddress_ip() + ":9097/newItems/remoteSyncItems";
                                    break;
                                }
                                case "global": {
                                    url_base = "http://" + borne.getAddress_ip() + ":9097/newItems/remoteSync";
                                }
                            }
                            System.out.println("+++++++++++++ url_base : " + (String)url_base);
                            if (!((String)url_base).isEmpty()) {
                                URL url = new URL((String)url_base);
                                JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                                JSONObject data = new JSONObject(tokener);
                                String message = data.getString("ERROR");
                                System.out.println("++++++++++++++++++dataSend" + data);
                                if (message.equals("OK")) {
                                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Synchronisation faite avec succ\u00e8s.", 1500, NPosition.BOTTOM_RIGHT);
                                } else {
                                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
                                }
                                BornesController.this.changeTextButton(type_synchro, btnSynch);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
                        BornesController.this.changeTextButton(type_synchro, btnSynch);
                    }
                }
            }).start();
        }
    }

    public void loadCashlogy(final BorneInfo borne, final Button btnSynch) {
        if (borne != null && borne.getAddress_ip() != null) {
            btnSynch.setText("Affichage du BackOffice Cashlogy ...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object url_base = "";
                        url_base = "http://" + borne.getAddress_ip() + ":9097/newItems/LoadBackofficeCashlogy";
                        System.out.println("+++++++++++++ url_base : " + (String)url_base);
                        if (!((String)url_base).isEmpty()) {
                            URL url = new URL((String)url_base);
                            JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                            JSONObject data = new JSONObject(tokener);
                            System.out.println("+++++++++++++++++++ data :" + data.toString());
                            String message = data.getString("STATUS");
                            if (message.equals("OK")) {
                                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Le BackOffice s'affiche avec succ\u00e8s sur " + borne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                            } else {
                                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "\u00c9chec de l'affichage du BackOffice sur  " + borne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                            }
                            Platform.runLater((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    btnSynch.setText("Affichage du BackOffice Cashlogy ");
                                }
                            });
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
                        btnSynch.setText("Affichage du BackOffice Cashlogy ");
                    }
                }
            }).start();
        }
    }

    public void block(final BorneInfo borne, final Button btnBlock) {
        if (borne != null && borne.getAddress_ip() != null && !borne.getAddress_ip().isEmpty()) {
            if (borne.isBlocked()) {
                btnBlock.setText("Activation ...");
            } else {
                btnBlock.setText("D\u00e9sactivation ...");
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        DefaultHttpClient httpClient = new DefaultHttpClient();
                        String url_base = "http://" + borne.getAddress_ip() + ":9097/newItems/changeStatus";
                        HttpPost post = new HttpPost(url_base);
                        post.setHeader("Content-type", "application/json; charset=utf-8");
                        JSONObject jsonParams = new JSONObject();
                        String status = borne.isBlocked() ? "enabled" : "disabled";
                        jsonParams.put("status", (Object)status);
                        StringEntity params = new StringEntity(jsonParams.toString(), "UTF-8");
                        post.setEntity((HttpEntity)params);
                        CloseableHttpResponse result = httpClient.execute((HttpUriRequest)post);
                        String json = EntityUtils.toString((HttpEntity)result.getEntity(), (String)"UTF-8");
                        JSONObject jsonObject = new JSONObject(json);
                        String message = jsonObject.getString("error");
                        if (message.equals("OK")) {
                            boolean blocked = !borne.isBlocked();
                            borne.setBlocked(blocked);
                            BornesController.this.mBorneService.changeBorneStatus(borne);
                            BornesController.this.loadBornes();
                            if (blocked) {
                                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "d\u00e9sactivation faite avec succ\u00e8s.", 1500, NPosition.BOTTOM_RIGHT);
                            } else {
                                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Activation faite avec succ\u00e8s.", 1500, NPosition.BOTTOM_RIGHT);
                            }
                        }
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (borne.isBlocked()) {
                                    btnBlock.setText("Activer");
                                } else {
                                    btnBlock.setText("D\u00e9sactiver");
                                }
                            }
                        });
                    }
                }
            }).start();
        }
    }

    private void addBorne(BorneInfo borne) {
        try {
            this.mBorneService.addBorne(borne);
            this.loadBornes();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Borne enregistr\u00e9", 1500, NPosition.BOTTOM_RIGHT);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void updateBorne(BorneInfo borne) {
        try {
            this.mBorneService.setAddress(borne);
            this.loadBornes();
            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Borne enregistr\u00e9", 1500, NPosition.BOTTOM_RIGHT);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
        }
    }

    private void deleteBorne(BorneInfo borne) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, "Vous voulez vraiment supprimer cette borne ?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
        alert.showAndWait();
        if (alert.getResult() == ButtonType.YES) {
            try {
                this.mBorneService.deleteBorne(borne);
                this.loadBornes();
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Borne supprim\u00e9", 1500, NPosition.BOTTOM_RIGHT);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu", 1500, NPosition.BOTTOM_RIGHT);
            }
        }
    }

    private void showBornes(List<GridPane> items) {
        this.number_page_borne = (int)Math.ceil((double)items.size() / (double)(this.number_line * this.number_column));
        this.pane_bornes = new GridPane[this.number_page_borne];
        for (int i = 0; i < this.number_page_borne; ++i) {
            this.pane_bornes[i] = new GridPane();
            this.pane_bornes[i].setVgap(5.0);
            this.pane_bornes[i].setHgap(5.0);
            this.pane_bornes[i].setAlignment(Pos.CENTER);
            this.pane_bornes[i].getStyleClass().add((Object)"bg-white");
        }
        int index_borne = 0;
        int column_borne = 0;
        int row_borne = 0;
        for (GridPane paneItem : items) {
            this.pane_bornes[index_borne].add((Node)paneItem, column_borne, row_borne);
            if (column_borne < this.number_column - 1) {
                ++column_borne;
                continue;
            }
            if (row_borne < this.number_line - 1) {
                ++row_borne;
                column_borne = 0;
                continue;
            }
            ++index_borne;
            row_borne = 0;
            column_borne = 0;
        }
        this.pane_main.getChildren().clear();
        this.list_bornes.getChildren().clear();
        if (this.number_page_borne > 0) {
            this.page_borne = 0;
            this.list_bornes.add((Node)this.pane_bornes[this.page_borne], 0, 0);
            if (this.number_page_borne <= 1) {
                this.pane_main.add((Node)this.list_bornes, 0, 0);
            } else {
                this.pane_preview_borne.getChildren().clear();
                this.pane_next_borne.getChildren().clear();
                this.pane_next_borne.add((Node)this.btn_borne_next, 0, 0);
                this.pane_preview_borne.getChildren().clear();
                this.pane_main.add((Node)this.pane_preview_borne, 0, 0);
                this.pane_main.add((Node)this.list_bornes, 0, 1);
                this.pane_main.add((Node)this.pane_next_borne, 0, 2);
            }
        }
    }

    public void lastPaneBorne() {
        if (this.page_borne > 0) {
            --this.page_borne;
            this.list_bornes.getChildren().clear();
            this.list_bornes.add((Node)this.pane_bornes[this.page_borne], 0, 0);
            this.pane_next_borne.getChildren().clear();
            this.pane_next_borne.add((Node)this.btn_borne_next, 0, 0);
            if (this.page_borne == 0) {
                this.pane_preview_borne.getChildren().clear();
            } else {
                this.pane_preview_borne.getChildren().clear();
                this.pane_preview_borne.add((Node)this.btn_borne_previous, 0, 0);
            }
        }
    }

    public void nextPageBorne() {
        if (this.page_borne < this.number_page_borne - 1) {
            ++this.page_borne;
            this.list_bornes.getChildren().clear();
            this.list_bornes.add((Node)this.pane_bornes[this.page_borne], 0, 0);
            this.pane_preview_borne.getChildren().clear();
            this.pane_preview_borne.add((Node)this.btn_borne_previous, 0, 0);
            if (this.page_borne == this.number_page_borne - 1) {
                this.pane_next_borne.getChildren().clear();
            } else {
                this.pane_next_borne.getChildren().clear();
                this.pane_next_borne.add((Node)this.btn_borne_next, 0, 0);
            }
        }
    }

    private void changeTextButton(String type_synchro, Button btnSynch) {
        Platform.runLater(() -> {
            switch (type_synchro) {
                case "items": {
                    btnSynch.setText("Mettre \u00e0 jour les items");
                    break;
                }
                case "images": {
                    btnSynch.setText("Mettre \u00e0 jour les images");
                    break;
                }
                case "global": {
                    btnSynch.setText("Mettre \u00e0 jour");
                    break;
                }
                case "params": {
                    btnSynch.setText("Mettre \u00e0 jour les param\u00e8tres");
                    break;
                }
                case "Relancer": {
                    btnSynch.setText("relancement du logiciel");
                }
                case "shutdown": {
                    btnSynch.setText("Eteindre l'\u00e9quipement");
                }
            }
        });
    }

    public void synchroItems() {
        this.synchronizeGlobal(this.button_items, "items");
    }

    public void synchroImages() {
        this.synchronizeGlobal(this.button_images, "images");
    }

    public void synchroGlobal() {
        this.synchronizeGlobal(this.button_global, "global");
    }

    public void synchronizeGlobal(final Button btnSynch, final String type_synchro) {
        btnSynch.setText("Synchronisation ...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                for (BorneInfo borne : BornesController.this.bornes) {
                    try {
                        URL url;
                        JSONTokener tokener;
                        JSONObject data;
                        String message;
                        if (type_synchro == null) continue;
                        Object url_base = "";
                        switch (type_synchro) {
                            case "images": {
                                url_base = "http://" + borne.getAddress_ip() + ":9097/newItems/remoteSyncImages";
                                break;
                            }
                            case "items": {
                                url_base = "http://" + borne.getAddress_ip() + ":9097/newItems/remoteSyncItems";
                                break;
                            }
                            case "global": {
                                url_base = "http://" + borne.getAddress_ip() + ":9097/newItems/remoteSync";
                            }
                        }
                        System.out.println("+++++++++++++ url_base : " + (String)url_base);
                        if (((String)url_base).isEmpty() || (message = (data = new JSONObject(tokener = new JSONTokener((Reader)new InputStreamReader((url = new URL((String)url_base)).openStream(), "UTF-8")))).getString("ERROR")).equals("OK")) continue;
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu sur " + borne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Une erreur est servenu sur " + borne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                    }
                }
                BornesController.this.changeTextButton(type_synchro, btnSynch);
            }
        }).start();
    }

    public void reload() {
        this.USER_IS_SUPER_ADMIN = this.app.getAppUserView().getUser() != null && (this.app.getAppUserView().getUser().getRole().equals("0") || this.app.getAppUserView().getUser().getRole().equals("1"));
        try {
            System.out.println("************ dlSystem.getPermissions(app.getAppUserView().getUser().getRole())" + this.dlSystem.getPermissions(this.app.getAppUserView().getUser().getRole()));
            this.USER_HAS_ACCES_TO_BACK_OFFICE = this.app.getAppUserView().getUser() != null && this.dlSystem.getPermissions(this.app.getAppUserView().getUser().getRole()).contains("BackOffice Cashlogy");
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        this.pane_synchro_global.getChildren().clear();
        this.pane_synchro_global.add((Node)this.button_items, 0, 0);
        this.pane_synchro_global.add((Node)this.button_images, 1, 0);
        this.pane_synchro_global.add((Node)this.button_global, 2, 0);
        this.width_pane = this.USER_IS_SUPER_ADMIN ? AppVarUtils.getScreenDimension().getWidth() * 0.3 : AppVarUtils.getScreenDimension().getWidth() * 0.25;
        this.loadBornes();
    }

    public void relaunchSoftware(final BorneInfo borne, final Button btnRelaunch) {
        System.out.println("++++++++++++relaunchSoftware");
        if (borne != null && borne.getAddress_ip() != null) {
            btnRelaunch.setText("Relancement ...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String urlRelaunch = "http://" + borne.getAddress_ip() + ":9097/newItems/relaunch";
                        URL url = new URL(urlRelaunch);
                        JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                        JSONObject data = new JSONObject(tokener);
                        String message = data.getString("STATUS");
                        if (message.equals("SUCCESS")) {
                            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Le logiciel de la borne a \u00e9t\u00e9 relanc\u00e9 avec succ\u00e8s sur " + borne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                        } else {
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "\u00c9chec du relancement du logiciel sur  " + borne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                        }
                        BornesController.this.changeTextButton("Relancer", btnRelaunch);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                        BornesController.this.changeTextButton("Relancer", btnRelaunch);
                    }
                }
            }).start();
        }
    }

    public void shutdownTerminal(final BorneInfo borne, final Button btnShutdown) {
        System.out.println("++++++++++++ shutdownTerminal");
        if (borne != null && borne.getAddress_ip() != null) {
            btnShutdown.setText("Extinction ...");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String urlRelaunch = "http://" + borne.getAddress_ip() + ":9097/newItems/shutdownTerminal";
                        URL url = new URL(urlRelaunch);
                        JSONTokener tokener = new JSONTokener((Reader)new InputStreamReader(url.openStream(), "UTF-8"));
                        JSONObject data = new JSONObject(tokener);
                        String message = data.getString("error");
                        if (message.equalsIgnoreCase("OK")) {
                            new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "La borne " + borne.getName_borne() + " a \u00e9t\u00e9 \u00e9teinte", 1500, NPosition.BOTTOM_RIGHT);
                        } else {
                            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "\u00c9chec de l'extinction de  " + borne.getName_borne(), 1500, NPosition.BOTTOM_RIGHT);
                        }
                        BornesController.this.changeTextButton("shutdown", btnShutdown);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                        BornesController.this.changeTextButton("shutdown", btnShutdown);
                    }
                }
            }).start();
        }
    }

    private String generateNameBorne(String type) {
        int maxNumber = 0;
        for (BorneInfo borne : this.bornes) {
            String[] parts;
            String nameBorne = borne.getName_borne();
            if (!nameBorne.startsWith(type) || (parts = nameBorne.split(" ")).length != 2) continue;
            try {
                int number = Integer.parseInt(parts[1]);
                if (number <= maxNumber) continue;
                maxNumber = number;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return type + " " + (maxNumber + 1);
    }

    private void requestBornesSettings() {
        System.out.println("+++++ retrieving params");
        boolean errorFired = false;
        for (BorneInfo borne : this.bornes) {
            try {
                JSONObject params;
                if (borne.isBlocked() || borne.isEquipment_disabled() || (params = this.mBorneService.getParams(borne)) == null) continue;
                System.out.println("params of borne IP " + borne.getAddress_ip() + " : " + params);
                borne.setPayment_enabled(params.getBoolean("payment.borne"));
                borne.setInMaintenance(params.getBoolean("borne.in.maintenance"));
                borne.setOnseatEnabled(!params.getBoolean("only.take.away.borne"));
                this.mBorneService.save(borne);
            }
            catch (IOException | JSONException ex) {
                if (!errorFired) {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Impossible de r\u00e9cup\u00e9rer les param\u00e8tres de certains equipements", 1500, NPosition.BOTTOM_RIGHT);
                }
                if (ex instanceof JSONException) {
                    System.out.println("++++++++= json parsing error : " + ex.getMessage());
                }
                errorFired = true;
            }
        }
        this.loadBornes(true);
    }
}

