/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controllers;

import com.openbravo.basic.BasicException;
import com.openbravo.beans.DateUtils;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.format.Formats;
import com.openbravo.pos.admin.DataLogicAdmin;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.printer.BackupDialogue;
import com.openbravo.pos.printer.Decreaser;
import com.openbravo.pos.printer.PrinterHelper;
import com.openbravo.pos.printer.QueuedDoc;
import com.openbravo.pos.printer.QueuedDocView;
import com.openbravo.pos.printer.Ticket2;
import com.openbravo.pos.ticket.PrinterInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.norm.beans.EnteteInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.util.Callback;

public class BackupController {
    @FXML
    Button btn_next_date;
    @FXML
    Button btn_previous_date;
    @FXML
    Label jdate;
    @FXML
    TableView tableView;
    @FXML
    TableColumn num_order;
    @FXML
    TableColumn date_order;
    @FXML
    TableColumn hour_order;
    @FXML
    TableColumn type_order;
    @FXML
    TableColumn printer;
    @FXML
    TableColumn etat_order;
    @FXML
    TableColumn total_order;
    @FXML
    TableColumn serveur_order;
    @FXML
    Button btn_kitchen;
    @FXML
    Button btn_caisse;
    @FXML
    Button btn_caisse_principal;
    @FXML
    Button btn_cancel;
    @FXML
    Button btn_duplicate;
    @FXML
    GridPane footer_print_pane;
    @FXML
    GridPane footer_btns;
    @FXML
    GridPane footer_cancel;
    @FXML
    GridPane pane_main;
    @FXML
    FlowPane pane_raison;
    @FXML
    TextArea raison;
    private static final SimpleDateFormat dateFormatter = com.openbravo.pos.util.DateUtils.formatterYEAR_MONTH_DAY_TIRETS6;
    private static final SimpleDateFormat timeFormatter = com.openbravo.pos.util.DateUtils.timeFormatter;
    @FXML
    TableColumn commandNum;
    private Stage stage;
    private AppView app;
    private Date date;
    protected DataLogicSales dlSales;
    private Date dateStart;
    private Date dateEnd;
    private List<PrinterInfo> printers;
    List<TicketLineInfo> productToSend;
    private List<QueuedDoc> documents;
    private QueuedDoc document;
    private EnteteInfo entetTicket;
    protected DataLogicAdmin dlUsers;
    private boolean editRaison;
    int row = -1;
    private boolean printFond;
    private boolean isSeparate;
    private boolean displayQuantity;
    private static double widthPane = 700.0;
    private BackupDialogue parent;

    public void init(Scene scene, AppView app, BackupDialogue parent) throws BasicException {
        this.parent = parent;
        this.app = app;
        this.dlSales = (DataLogicSales)this.app.getBean("com.openbravo.dao.DataLogicSales");
        this.printers = new ArrayList<PrinterInfo>();
        this.productToSend = new ArrayList<TicketLineInfo>();
        this.loadPaneFooter();
        this.switchToBtns();
        this.pane_main.getChildren().clear();
        this.pane_main.add((Node)this.tableView, 0, 0);
        this.document = null;
        this.tableView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observableValue, Object oldValue, Object newValue) {
                if (BackupController.this.tableView.getSelectionModel().getSelectedIndex() != -1) {
                    BackupController.this.row = BackupController.this.tableView.getSelectionModel().getSelectedIndex();
                    if (BackupController.this.row != -1) {
                        BackupController.this.document = BackupController.this.documents.get(BackupController.this.row);
                        BackupController.this.switchToBtns();
                    }
                }
            }
        });
        Calendar calToday = Calendar.getInstance();
        this.date = DateUtils.getToday();
        this.num_order.setCellValueFactory((Callback)new PropertyValueFactory("numOrder"));
        this.commandNum.setCellValueFactory((Callback)new PropertyValueFactory("commandNum"));
        this.date_order.setCellValueFactory((Callback)new PropertyValueFactory("dateOrder"));
        this.hour_order.setCellValueFactory((Callback)new PropertyValueFactory("hourOrder"));
        this.type_order.setCellValueFactory((Callback)new PropertyValueFactory("typeOrder"));
        this.printer.setCellValueFactory((Callback)new PropertyValueFactory("printer"));
        if (calToday.getTime().getHours() >= 0 && calToday.getTime().getHours() <= AppLocal.dateEnd) {
            calToday.setTime(this.date);
            calToday.add(6, -1);
            this.date = calToday.getTime();
        }
        this.setTime(this.date);
        this.loadDocuments();
    }

    public void next() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, 1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDay() == cal.getTime().getDay()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText("Aujourd'hui");
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDay() == cal.getTime().getDay()) {
            this.jdate.setText("Hier");
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        this.loadDocuments();
    }

    public void previous() {
        Calendar cal = Calendar.getInstance();
        Calendar today = Calendar.getInstance();
        cal.setTime(this.date);
        cal.add(5, -1);
        Calendar yesterday = Calendar.getInstance();
        yesterday.setTime(DateUtils.getToday());
        yesterday.add(5, -1);
        if (today.getTime().getHours() >= 0 && today.getTime().getHours() <= AppLocal.dateEnd) {
            yesterday.add(6, -1);
            today.add(6, -1);
        }
        this.jdate.setText(Formats.DATE.formatValue(cal.getTime()));
        if (today.getTime().getYear() == cal.getTime().getYear() && today.getTime().getMonth() == cal.getTime().getMonth() && today.getTime().getDay() == cal.getTime().getDay()) {
            this.btn_next_date.setVisible(false);
            this.jdate.setText("Aujourd'hui");
        } else {
            this.btn_next_date.setVisible(true);
        }
        if (yesterday.getTime().getYear() == cal.getTime().getYear() && yesterday.getTime().getMonth() == cal.getTime().getMonth() && yesterday.getTime().getDay() == cal.getTime().getDay()) {
            this.jdate.setText("Hier");
        }
        this.date = cal.getTime();
        this.setTime(this.date);
        this.loadDocuments();
    }

    public void setTime(Date date) {
        Calendar calStart = Calendar.getInstance();
        calStart.setTime(date);
        calStart.add(11, AppLocal.dateStart);
        calStart.getTime();
        this.dateStart = calStart.getTime();
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(date);
        if (AppLocal.dateStart >= AppLocal.dateEnd) {
            calEnd.add(11, AppLocal.dateEnd + 24);
        } else {
            calEnd.add(11, AppLocal.dateEnd);
        }
        calEnd.getTime();
        this.dateEnd = calEnd.getTime();
    }

    private void loadDocuments() {
        if (AppVarUtils.QUEUE != null) {
            this.documents = new ArrayList<QueuedDoc>(AppVarUtils.QUEUE.values());
            ArrayList<QueuedDocView> items = new ArrayList<QueuedDocView>();
            for (QueuedDoc doc : this.documents) {
                items.add(new QueuedDocView(doc.getId(), doc.getNumDoc(), dateFormatter.format(doc.getDateEchec()), timeFormatter.format(doc.getDateEchec()), doc.getTypeDoc(), doc.getPrinter().getName() != null ? doc.getPrinter().getName() : (doc.getPrinter().getNamePrinter() != null ? doc.getPrinter().getNamePrinter() : doc.getPrinter().getIp())));
            }
            ObservableList data = FXCollections.observableArrayList(items);
            this.tableView.setItems(data);
        }
    }

    public void cancel() {
        if (this.document != null) {
            AppVarUtils.QUEUE.remove(this.document.getTypeDoc() + this.document.getIdDocument());
            this.loadDocuments();
            this.document = null;
        }
    }

    public void printTicket() {
        if (this.document != null) {
            try {
                final PrinterInfo pri = this.dlSales.getPrinterByID(this.document.getPrinter().getId());
                final String idDocument = this.document.getTypeDoc().toUpperCase().equalsIgnoreCase("TICKET") || this.document.getTypeDoc().toUpperCase().equalsIgnoreCase("FACTURE") || this.document.getTypeDoc().toUpperCase().equalsIgnoreCase("DUPLICATA") ? this.document.getIdDocument() : "";
                AppVarUtils.QUEUE.remove(this.document.getTypeDoc() + this.document.getIdDocument());
                Executors.newSingleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        PrinterHelper ph = new PrinterHelper();
                        Decreaser decreaser = new Decreaser(BackupController.this.dlSales, idDocument, BackupController.this.document.getTypeDoc(), null, BackupController.this.document.getNumDoc());
                        PrinterHelper.printTicket(new Ticket2(BackupController.this.document.getPrinter().getWith(), BackupController.this.document.getPrinter().getWith(), BackupController.this.document.getContent()), "Echec d'impression ", "Echec  d'impression de " + BackupController.this.document.getTypeDoc(), pri, decreaser);
                    }
                });
                Thread.sleep(3500L);
                this.loadDocuments();
                this.document = null;
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public void printTicketPrincipal() {
        if (this.document != null) {
            AppVarUtils.QUEUE.remove(this.document.getTypeDoc() + this.document.getIdDocument());
            Executors.newSingleThreadExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    PrinterHelper ph = new PrinterHelper();
                    Decreaser decreaser = new Decreaser(BackupController.this.dlSales, BackupController.this.document.getIdDocument(), BackupController.this.document.getTypeDoc(), null, BackupController.this.document.getNumDoc());
                    try {
                        PrinterInfo pri = BackupController.this.dlSales.getPrinterByID(1);
                        PrinterHelper.printTicket(new Ticket2(BackupController.this.document.getPrinter().getWith(), BackupController.this.document.getPrinter().getWith(), BackupController.this.document.getContent()), "Echec  d'impression ", "Echec  d'impression de " + BackupController.this.document.getTypeDoc(), pri, decreaser);
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", null, ex);
                    }
                }
            });
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException ex) {
                LogToFile.log("severe", null, ex);
            }
            this.loadDocuments();
            this.document = null;
        }
    }

    public void switchToBtns() {
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.footer_btns, 0, 0);
    }

    public void switchToCancel() {
        this.footer_print_pane.getChildren().clear();
        this.footer_print_pane.add((Node)this.footer_cancel, 0, 0);
    }

    private String getStatus(String status) {
        if (status != null) {
            switch (status) {
                case "livre": {
                    return "Livr\u00e9e";
                }
                case "paid": {
                    return "Termin\u00e9e";
                }
                case "cancel": {
                    return "Annul\u00e9e";
                }
                case "pending": {
                    return "En cours";
                }
                case "Refund": {
                    return "Remboursement";
                }
            }
        }
        return null;
    }

    private void loadPaneFooter() throws BasicException {
        this.footer_btns.getChildren().clear();
        this.footer_btns.add((Node)this.btn_caisse, 1, 0);
        this.footer_btns.add((Node)this.btn_caisse_principal, 2, 0);
        this.footer_btns.add((Node)this.btn_cancel, 0, 0);
    }

    public void closePopUp() {
        this.parent.dispose();
    }
}

