/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.controlFX;

import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;

public class AutoCompleteTextField
extends TextField {
    private final SortedSet<String> entries = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private ContextMenu entriesPopup = new ContextMenu();

    public AutoCompleteTextField() {
        this.entriesPopup.setPrefWidth(this.getPrefWidth());
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observableValue, String s, String s2) {
                if (AutoCompleteTextField.this.getText().length() == 0) {
                    AutoCompleteTextField.this.entriesPopup.hide();
                } else {
                    LinkedList<String> searchResult = new LinkedList<String>();
                    searchResult.addAll(AutoCompleteTextField.this.entries.subSet(AutoCompleteTextField.this.getText(), AutoCompleteTextField.this.getText() + "\uffff"));
                    if (AutoCompleteTextField.this.entries.size() > 0) {
                        AutoCompleteTextField.this.populatePopup(searchResult);
                        if (!AutoCompleteTextField.this.entriesPopup.isShowing()) {
                            AutoCompleteTextField.this.entriesPopup.show((Node)AutoCompleteTextField.this, Side.BOTTOM, 0.0, 0.0);
                        }
                    } else {
                        AutoCompleteTextField.this.entriesPopup.hide();
                    }
                }
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean aBoolean, Boolean aBoolean2) {
                AutoCompleteTextField.this.entriesPopup.hide();
            }
        });
    }

    public ContextMenu getEntriesPopup() {
        return this.entriesPopup;
    }

    public void setEntriesPopup(ContextMenu entriesPopup) {
        this.entriesPopup = entriesPopup;
    }

    public SortedSet<String> getEntries() {
        return this.entries;
    }

    private void populatePopup(List<String> searchResult) {
        LinkedList<CustomMenuItem> menuItems = new LinkedList<CustomMenuItem>();
        int maxEntries = 10;
        int count = Math.min(searchResult.size(), maxEntries);
        for (int i = 0; i < count; ++i) {
            final String result = searchResult.get(i);
            Label entryLabel = new Label(result);
            entryLabel.setPrefWidth(this.entriesPopup.getPrefWidth());
            CustomMenuItem item = new CustomMenuItem((Node)entryLabel, true);
            item.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    AutoCompleteTextField.this.setText(result);
                    AutoCompleteTextField.this.entriesPopup.hide();
                }
            });
            menuItems.add(item);
        }
        this.entriesPopup.getItems().clear();
        this.entriesPopup.getItems().addAll(menuItems);
    }
}

