/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components.views;

import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.ProductInfoExt;
import com.openbravo.pos.util.ColorUtils;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.text.TextAlignment;

public class ButtonBoxProduct
extends Button {
    private ProductInfoExt mProductInfoExt;
    private double customWidth = 0.0;
    private double customHeight = 0.0;
    private String defaultColor = "#f5a623";
    private Boolean hide_stock = false;
    private Boolean inventory_management = false;

    public ButtonBoxProduct(ProductInfoExt mProductInfoExt, double mCustomWidth, double mCustomHeight, Boolean hide_stock, Boolean inventory_management, Image image) {
        this.mProductInfoExt = mProductInfoExt;
        this.customWidth = mCustomWidth;
        this.customHeight = mCustomHeight;
        this.hide_stock = hide_stock;
        this.inventory_management = inventory_management;
        this.initialize(image);
    }

    public ButtonBoxProduct(ProductInfoExt mProductInfoExt, double mCustomWidth, double mCustomHeight) {
        this.mProductInfoExt = mProductInfoExt;
        this.customWidth = mCustomWidth;
        this.customHeight = mCustomHeight;
        if (this.customWidth != 0.0) {
            this.setPrefWidth(this.customWidth);
        }
        if (this.customHeight != 0.0) {
            this.setPrefHeight(this.customHeight);
        }
    }

    public void initialize(Image image) {
        double height_name;
        this.setTextAlignment(TextAlignment.CENTER);
        if (this.customWidth != 0.0) {
            this.setPrefWidth(this.customWidth);
        }
        if (this.customHeight != 0.0) {
            this.setPrefHeight(this.customHeight);
        }
        if (this.mProductInfoExt.getColor() != null && !this.mProductInfoExt.getColor().isEmpty()) {
            this.defaultColor = ColorUtils.getColor(this.mProductInfoExt.getColor());
        }
        int column = 0;
        int size_product = 9;
        this.setStyle("-fx-background-color: " + this.defaultColor + ";");
        GridPane paneName = new GridPane();
        GridPane paneProdcut = new GridPane();
        paneProdcut.setPrefHeight(this.getPrefHeight());
        paneProdcut.setPrefWidth(this.getPrefWidth());
        double d = height_name = this.mProductInfoExt.isSold_out() ? paneProdcut.getPrefHeight() * 0.8 : paneProdcut.getPrefHeight();
        if (image != null) {
            Label labelImage = new Label();
            labelImage.setPrefWidth(paneProdcut.getPrefWidth() * 0.5);
            labelImage.setPrefHeight(height_name);
            ImageView imageOption = new ImageView(image);
            imageOption.setFitHeight(height_name * 0.9);
            imageOption.setFitWidth(paneProdcut.getPrefWidth() * 0.5);
            imageOption.setPreserveRatio(false);
            imageOption.setSmooth(false);
            labelImage.setGraphic((Node)imageOption);
            paneProdcut.add((Node)labelImage, column++, 0);
            paneName.setPrefWidth(this.getPrefWidth() * 0.5);
            size_product = 8;
        } else {
            paneName.setPrefWidth(this.getPrefWidth());
        }
        paneName.setPrefHeight(height_name);
        Object name = this.mProductInfoExt.getName().toUpperCase();
        if (!this.mProductInfoExt.isHas_bar_code() && !this.mProductInfoExt.isFree_price() && !this.mProductInfoExt.isMany_size() && (this.mProductInfoExt.getPriceSell() != 0.0 || this.mProductInfoExt.isUse_points() && this.mProductInfoExt.getPrice_point() != 0.0)) {
            name = (String)name + "\n" + this.mProductInfoExt.printPriceSell();
        }
        Label nameProduct = new Label((String)name);
        nameProduct.setAlignment(Pos.CENTER);
        nameProduct.getStyleClass().add((Object)"text-white");
        nameProduct.setStyle("-fx-background-color: " + this.defaultColor + "; -fx-font-size : " + size_product + "pt;");
        nameProduct.setWrapText(true);
        nameProduct.setPrefHeight(paneName.getPrefHeight());
        if ("venteDetail".equals(AppLocal.licence) && this.inventory_management.booleanValue() && !this.hide_stock.booleanValue() || !"venteDetail".equals(AppLocal.licence) && this.inventory_management.booleanValue() && !this.hide_stock.booleanValue() && this.mProductInfoExt.isStorable()) {
            Label m_labelStockQty = new Label(Formats.INT.formatValue(this.mProductInfoExt.getQuantity()));
            m_labelStockQty.getStyleClass().add((Object)"m-badge-stock");
            if (this.mProductInfoExt.getQuantity() <= this.mProductInfoExt.getMin_store()) {
                m_labelStockQty.getStyleClass().add((Object)"bg_red");
            } else {
                m_labelStockQty.getStyleClass().add((Object)"bg_57606f");
            }
            m_labelStockQty.setPrefWidth(paneName.getPrefWidth() * 0.3);
            nameProduct.setPrefWidth(paneName.getPrefWidth() * 0.7);
            paneName.add((Node)nameProduct, 0, 0);
            paneName.add((Node)m_labelStockQty, 1, 0);
        } else {
            nameProduct.setPrefWidth(paneName.getPrefWidth());
            paneName.add((Node)nameProduct, 0, 0);
        }
        paneProdcut.add((Node)paneName, column, 0);
        if (this.mProductInfoExt.isSold_out()) {
            GridPane paneSoldOut = new GridPane();
            paneSoldOut.setAlignment(Pos.CENTER);
            paneSoldOut.setPrefWidth(paneProdcut.getPrefWidth());
            paneSoldOut.setPrefHeight(paneProdcut.getPrefHeight() * 0.2);
            Label labelSoldOut = new Label("Rupture");
            labelSoldOut.setPrefWidth(paneSoldOut.getPrefWidth());
            labelSoldOut.setPrefHeight(paneSoldOut.getPrefHeight() * 0.9);
            labelSoldOut.getStyleClass().add((Object)"bg_red_fb3e3e");
            labelSoldOut.getStyleClass().add((Object)"text-white");
            labelSoldOut.setAlignment(Pos.CENTER);
            paneSoldOut.add((Node)labelSoldOut, 0, 0);
            paneProdcut.add((Node)paneSoldOut, 0, 1, 2, 1);
        }
        this.setGraphic((Node)paneProdcut);
        boolean higher_price = this.mProductInfoExt.isUse_points() && (AppLocal.currentCustomerLoyalty == null || AppLocal.currentCustomerLoyalty != null && AppLocal.currentCustomerLoyalty.getPoints() < this.mProductInfoExt.getPrice_point());
        this.setDisable(higher_price);
    }

    public ProductInfoExt getProductInfoExt() {
        return this.mProductInfoExt;
    }

    public void setProductInfoExt(ProductInfoExt mProductInfoExt) {
        this.mProductInfoExt = mProductInfoExt;
    }

    public String getDefaultColor() {
        return this.defaultColor;
    }

    public String toString() {
        return "ButtonBoxProduct{mProductInfoExt=" + this.mProductInfoExt + ", customWidth=" + this.customWidth + ", customHeight=" + this.customHeight + ", defaultColor=" + this.defaultColor + ", hide_stock=" + this.hide_stock + ", inventory_management=" + this.inventory_management + "}";
    }
}

