/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components.views;

import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.NumericUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.SVGPath;
import javafx.scene.text.TextAlignment;
import org.apache.commons.lang3.StringUtils;

public class ButtonBoxLine
extends Button {
    private TicketLineInfo line;

    public ButtonBoxLine(TicketLineInfo line, double width, double height, String color_borne) {
        String color_text = line.getDiscount() != 0.0 && line.getLabelDiscount() != null && !line.getLabelDiscount().isEmpty() ? color_borne : "#000000";
        String colot_light_20 = ColorUtils.getColorLight(AppLocal.color_borne, 0.1);
        String colot_light_50 = ColorUtils.getColorLight(AppLocal.color_borne, 0.5);
        this.line = line;
        this.setPrefWidth(width);
        this.setPrefHeight(height);
        GridPane paneMain = new GridPane();
        paneMain.setPrefHeight(height * 0.95);
        paneMain.setPrefWidth(width * 0.95);
        paneMain.setStyle("-fx-border-color: " + color_borne + "; -fx-text-fill: " + color_borne + "; -fx-background-color: " + colot_light_20 + "; ");
        paneMain.getStyleClass().add((Object)"bg_radius_1");
        paneMain.getStyleClass().add((Object)"border_radius_1");
        paneMain.getStyleClass().add((Object)"border_width_1");
        Label labelQuantity = new Label();
        labelQuantity.setAlignment(Pos.CENTER_RIGHT);
        labelQuantity.setTextAlignment(TextAlignment.RIGHT);
        labelQuantity.setText("X" + line.printMultiply());
        labelQuantity.getStyleClass().add((Object)"text-size-18");
        labelQuantity.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        labelQuantity.setStyle("-fx-text-fill: " + color_text + ";");
        labelQuantity.setPrefHeight(height * 0.25);
        labelQuantity.setPrefWidth(width);
        GridPane paneName = new GridPane();
        paneName.setPrefWidth(width);
        paneName.setPrefHeight(height * 0.5);
        paneName.setAlignment(Pos.CENTER);
        Label textName = new Label(StringUtils.capitalize((String)line.getDisplayedName().toLowerCase()));
        textName.setAlignment(Pos.CENTER);
        textName.setTextAlignment(TextAlignment.CENTER);
        textName.setMaxHeight(Double.NEGATIVE_INFINITY);
        textName.setPrefWidth(paneName.getPrefWidth());
        textName.getStyleClass().add((Object)"JejuHallasan-font");
        textName.getStyleClass().add((Object)"text-size-16");
        paneName.add((Node)textName, 0, 0);
        if (line.getSizeProduct() != null) {
            Label textSize = new Label(line.getSizeProduct());
            textSize.setAlignment(Pos.CENTER);
            textSize.setTextAlignment(TextAlignment.CENTER);
            textSize.setPrefWidth(paneName.getPrefWidth());
            textSize.setMaxHeight(Double.NEGATIVE_INFINITY);
            textSize.getStyleClass().add((Object)"JejuHallasan-font");
            textSize.getStyleClass().add((Object)"text-size-12");
            paneName.add((Node)textSize, 0, 1);
        }
        paneMain.add((Node)labelQuantity, 0, 0);
        paneMain.add((Node)paneName, 0, 1);
        if (line.getDiscount() != 0.0) {
            StackPane stackPane = new StackPane();
            stackPane.setAlignment(Pos.CENTER);
            stackPane.setPrefHeight(height);
            stackPane.setPrefWidth(width);
            stackPane.getChildren().add((Object)paneMain);
            GridPane paneDiscount = new GridPane();
            paneDiscount.setAlignment(Pos.BOTTOM_CENTER);
            paneDiscount.setPrefHeight(height);
            paneDiscount.setPrefWidth(width);
            Label labelDiscount = new Label();
            labelDiscount.setAlignment(Pos.CENTER);
            labelDiscount.setTextAlignment(TextAlignment.CENTER);
            labelDiscount.getStyleClass().add((Object)"text-white");
            labelDiscount.setPrefWidth(width);
            labelDiscount.setText(this.getLabelPromotion(line));
            labelDiscount.setPrefHeight(height * 0.25);
            labelDiscount.setStyle("-fx-background-color: " + color_borne + "; -fx-background-radius: 0.2em; -fx-font-size: 14pt;");
            paneDiscount.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
            paneDiscount.add((Node)labelDiscount, 0, 0);
            stackPane.getChildren().add((Object)paneDiscount);
            this.setGraphic((Node)stackPane);
        } else {
            SVGPath sVGPath = new SVGPath();
            sVGPath.prefHeight(35.0);
            sVGPath.prefWidth(77.0);
            sVGPath.setContent("M75.9935 3.49294C75.9935 3.49294 80.6221 31.1253 59.8144 33.8613C39.0067 36.5973 1.00573 31.5079 1.00573 31.5079C1.00573 31.5079 -1.14427 3.54956 19.6635 0.813584C40.4712 -1.92239 75.9935 3.49294 75.9935 3.49294Z");
            sVGPath.setStyle("-fx-fill: " + colot_light_20 + ";");
            Label backgroundPriceProduct = new Label();
            backgroundPriceProduct.setAlignment(Pos.CENTER);
            backgroundPriceProduct.setPrefWidth(paneMain.getPrefWidth() * 0.5);
            backgroundPriceProduct.setPrefHeight(paneMain.getPrefHeight() * 0.25);
            backgroundPriceProduct.setGraphic((Node)sVGPath);
            Label labelPrice = new Label();
            labelPrice.getStyleClass().add((Object)"text-size-14");
            labelPrice.setAlignment(Pos.CENTER);
            labelPrice.setTextAlignment(TextAlignment.CENTER);
            labelPrice.setText(line.printValueMinusDiscount());
            labelPrice.setPrefHeight(paneMain.getPrefHeight() * 0.25);
            labelPrice.setPrefWidth(paneMain.getPrefWidth());
            StackPane stackPanePrice = new StackPane();
            stackPanePrice.setPrefWidth(paneMain.getPrefWidth());
            stackPanePrice.setPrefHeight(paneMain.getPrefHeight() * 0.25);
            stackPanePrice.getChildren().add((Object)backgroundPriceProduct);
            stackPanePrice.getChildren().add((Object)labelPrice);
            paneMain.add((Node)stackPanePrice, 0, 2);
            this.setGraphic((Node)paneMain);
        }
        this.getStyleClass().add((Object)"bg-white");
        this.setWrapText(true);
    }

    public TicketLineInfo getLine() {
        return this.line;
    }

    public void setLine(TicketLineInfo line) {
        this.line = line;
    }

    public String toString() {
        return "LineBorne{line=" + this.line + "}";
    }

    private String getLabelPromotion(TicketLineInfo line) {
        Object labelPromotion = line.getLabel_promotion();
        if (labelPromotion == null || ((String)labelPromotion).isEmpty()) {
            if (line.getPoints_loyalty() != 0.0) {
                labelPromotion = "OFFERT";
            } else {
                double valueDiscountPourcentage = 0.0;
                valueDiscountPourcentage = line.getType_discount() != null && line.getType_discount().equals("pourcentage") ? line.getDiscount() : 100.0 * NumericUtils.round(NumericUtils.round(line.getDiscount()) / NumericUtils.round(line.getMultiply() * line.getPrice()));
                labelPromotion = line.getDiscount() == 100.0 ? "OFFERT" : "-" + this.printNumber(line.getDiscount()) + "%";
            }
        }
        return labelPromotion;
    }

    private String printNumber(double value) {
        if (value == (double)Math.round(value)) {
            return Formats.INT.formatValue(value);
        }
        return Formats.DOUBLE.formatValue(value);
    }
}

