/*
 * Decompiled with CFR 0.152.
 */
package com.openbravo.components.views;

import com.openbravo.pos.ticket.CategoryInfo;
import com.openbravo.pos.util.ColorUtils;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.text.TextAlignment;

public class ButtonBoxCategory
extends Button {
    private CategoryInfo mCategoryInfo;
    private double customWidth = 0.0;
    private double customHeight = 0.0;
    private String defaultColor = "#f5a623";

    public ButtonBoxCategory(CategoryInfo mCategoryInfo) {
        this.mCategoryInfo = mCategoryInfo;
        this.init(mCategoryInfo, 0.0, 0.0, false);
    }

    public ButtonBoxCategory(CategoryInfo mCategoryInfo, double mCustomWidth, double mCustomHeight) {
        this.init(mCategoryInfo, mCustomWidth, mCustomHeight, false);
    }

    public ButtonBoxCategory(CategoryInfo mCategoryInfo, double mCustomWidth, double mCustomHeight, boolean borne) {
        this.init(mCategoryInfo, mCustomWidth, mCustomHeight, borne);
    }

    public void init(CategoryInfo mCategoryInfo, double mCustomWidth, double mCustomHeight, boolean borne) {
        this.mCategoryInfo = mCategoryInfo;
        this.customWidth = mCustomWidth;
        this.customHeight = mCustomHeight;
        if (!borne) {
            if (this.mCategoryInfo != null) {
                this.setText(this.mCategoryInfo.getDisplayedName().toUpperCase());
                if (mCategoryInfo.getColor() != null) {
                    this.defaultColor = ColorUtils.getColor(mCategoryInfo.getColor());
                }
            }
            this.setTextAlignment(TextAlignment.CENTER);
            this.setWrapText(true);
            this.setStyle("-fx-background-color:  " + this.defaultColor + ";");
        } else {
            this.setStyle("-fx-background-color: transparent; -fx-text-fill: #000000; -fx-font-size : 16pt; -fx-font-family : Consolas;");
        }
        if (this.customWidth != 0.0) {
            this.setPrefWidth(this.customWidth);
        }
        if (this.customHeight != 0.0) {
            this.setPrefHeight(this.customHeight);
        }
    }

    public void showGraphic(Image image) {
        System.out.println("++++++++++++showGraphic");
        if (image != null) {
            ImageView imageView = new ImageView(image);
            imageView.setFitHeight(30.0);
            imageView.setFitWidth(30.0);
            imageView.setSmooth(false);
            imageView.setPreserveRatio(false);
            this.setGraphic((Node)imageView);
        }
    }

    public String getDefaultColor() {
        return this.defaultColor;
    }

    public CategoryInfo getCategoryInfo() {
        return this.mCategoryInfo;
    }

    public void setCategoryInfo(CategoryInfo mCategoryInfo) {
        this.mCategoryInfo = mCategoryInfo;
    }

    public String toString() {
        return "CategoryButtonCaisse{mCategoryInfo=" + this.mCategoryInfo + "}";
    }
}

